(ns joints.components.datomic.core
  (:require
   [joints.components.datomic.conn :as cdc]
   [joints.components.datomic.proto :as cdp]))

(def IDatomicBlueprint cdp/IDatomicBlueprint)

(defn uri
  [idatomic-blueprint]
  (cdp/uri idatomic-blueprint))

(defn datomic-blueprint?
  [x]
  (cdp/datomic-blueprint? x))

(defn make-temp-datomic-blueprint
  [option]
  (cdc/make-temp-datomic-blueprint option))

(defn make-datomic-blueprint
  [option]
  (cdc/make-datomic-blueprint option))

(def IDatomic cdp/IDatomic)

(defn conn
  [idatomic]
  (cdp/conn idatomic))

(defn db
  [idatomic]
  (cdp/db idatomic))

(defn make-datomic
  []
  (cdc/make-datomic))

(defn datomic?
  [x]
  (cdp/datomic? x))
