(ns joints.components.datomic.conn
  (:require
   [com.stuartsierra.component :as c]
   [datomic.api :as d]
   [joints.components.datomic.proto :as cdp]
   [joints.components.util :as cu]))

(defrecord TempDatomicBlueprint [uri started?]
  c/Lifecycle
  (start [this]
    (if started?
      this
      (do (d/create-database uri)
          (assoc this :started? true))))
  (stop [this]
    (if-not started?
      this
      (assoc this :started? false))))

(defn make-temp-datomic-blueprint
  [{:keys [uri]}]
  (map->TempDatomicBlueprint {:uri uri :started? false}))

(defrecord DatomicBlueprint [uri started?]
  c/Lifecycle
  (start [this]
    (if started?
      this
      (do (d/create-database uri)
          (assoc this :started? true))))
  (stop [this]
    (if-not started?
      this
      (do (d/delete-database uri)
          (assoc this :started? false)))))

(defn make-datomic-blueprint
  [{:keys [uri]}]
  (map->DatomicBlueprint {:uri uri :started? false}))

(defn search-uri
  [m]
  (if-let [uri (->> m
                    (cu/search-filter-vals cdp/datomic-blueprint?)
                    (map cdp/uri)
                    first)]
    uri
    (throw (ex-info "No datomic blueprint found" {}))))

(defrecord Datomic [conn]
  c/Lifecycle
  (start [this]
    (if (some? conn)
      this
      (let [conn (d/connect (search-uri this))]
        (assoc this :conn conn))))
  (stop [this]
    (if (nil? conn)
      this
      (do (d/release conn)
          (assoc this :conn nil))))

  cdp/IDatomic
  (-conn [_]
    conn))

(defn make-datomic
  []
  (map->Datomic {}))
