(ns joints.components.ring.head
  (:require
   [joints.components.middleware.core :as cmc]
   [joints.components.ring.proto :as crp]
   [joints.components.util :as cu]
   [ring.util.http-response :as resp]))

(defn search-wrapper
  [m]
  (->> m
       (cu/search-filter-vals cmc/middleware?)
       (map cmc/wrapper)
       (apply comp)))

(defn search-handler
  [{:keys [default-handler] :as m}]
  (or (->> m
           (cu/search-filter-vals crp/request-handler?)
           (map crp/request-handler)
           first)
      default-handler
      (constantly
       (resp/service-unavailable "No request handler to be found"))))

(defn search-context
  [m]
  (->> m
       (cu/search-filter-vals crp/request-context?)
       (map crp/request-context)
       (reduce merge {})))

(defrecord RingHead [default-handler]
  crp/IRequestHandler
  (-request-handler [this]
    (let [wrapper (search-wrapper this)
          handler (search-handler this)]
      (wrapper
       (fn [request]
         (let [context (search-context this)]
           (handler (assoc request :context context))))))))

(defn make-ring-head
  [{:keys [default-handler]}]
  (map->RingHead {:default-handler default-handler}))
