(ns joints.components.datomic-conformity.impl
  (:require
   [clojure.java.io :as io]
   [com.stuartsierra.component :as c]
   [io.rkn.conformity :refer [ensure-conforms]]
   [joints.components.datomic-conformity.proto :as cdcp]
   [joints.components.datomic.core :as cdc]))

(defrecord DatomicNormMap [paths]
  cdcp/IDatomicNormMap
  (-norm-map [this]
    (->> paths
         (keep io/resource)
         (map io/file)
         (filter #(.isFile %))
         (map (comp read-string slurp))
         (reduce merge {}))))

(defn make-datomic-norm-map
  [{:keys [paths]}]
  (map->DatomicNormMap {:paths paths}))

(defn search-norm-map
  [m]
  (->> m
       (map val)
       (filter #(satisfies? cdcp/IDatomicNormMap %))
       (map cdcp/norm-map)
       (reduce merge {})))

(defn search-conn
  [m]
  (if-let [conn (->> m
                     (map val)
                     (filter #(satisfies? cdc/IDatomic %))
                     (map cdc/conn)
                     first)]
    conn
    (throw (ex-info "No datomic found" {}))))

(defrecord DatomicConformer [started?]
  c/Lifecycle
  (start [this]
    (if started?
      this
      (do (when-let [norm-map (not-empty (search-norm-map this))]
            (ensure-conforms (search-conn this) norm-map))
          (assoc this :started? true))))
  (stop [this]
    (if-not started?
      this
      (assoc this :started? false))))

(defn make-datomic-conformer
  []
  (map->DatomicConformer {:started? false}))
