(ns joints.components.ring.head
  (:require
   [joints.components.middleware.core :as cmc]
   [joints.components.ring.proto :as crp]
   [joints.components.util :as cu]
   [ring.util.http-response :as resp]))

(defn search-wrapper
  [m]
  (apply comp
         (into []
               (comp
                (cu/xsatisfied-vals cmc/IMiddleware)
                (map cmc/wrapper))
               m)))

(defn search-handler
  [{:keys [default-handler] :as m}]
  (or (->> (map val m)
           (filter #(satisfies? crp/IRequestHandler %))
           (map crp/request-handler)
           first)
      default-handler
      (constantly
       (resp/service-unavailable "No request handler to be found"))))

(defn search-context
  [m]
  (into {}
        (comp
         (cu/xsatisfied-vals crp/IRequestContext)
         (map crp/request-context))
        m))

(defrecord RingHead [default-handler]
  crp/IRequestHandler
  (-request-handler [this]
    (let [wrapper (search-wrapper this)
          handler (search-handler this)]
      (wrapper
       (fn [request]
         (let [context (search-context this)]
           (handler (assoc request :context context))))))))

(defn make-ring-head
  ([{:keys [default-handler]}]
   (->RingHead default-handler))
  ([]
   (make-ring-head {})))
