(ns joints.components.middleware.impl
  (:require
   [joints.components.middleware.proto :as cmp]
   [joints.components.util :as cu]))

(defn substitute
  [component entry]
  (if (vector? entry)
    (replace {:component component} entry)
    entry))

(defn coerce
  [entry]
  (if (vector? entry)
    #(apply (first entry) % (rest entry))
    entry))

(defn compose
  [component entries]
  (apply comp (into []
                    (comp
                     (map #(substitute component %))
                     (map coerce))
                    entries)))

(defn search-wrapper
  [m]
  (apply comp
         (into []
               (comp
                (cu/xsatisfied-vals cmp/IMiddleware)
                (map cmp/wrapper))
               m)))

(defrecord Middleware [entries]
  cmp/IMiddleware
  (-wrapper [this]
    (let [wrapper       (compose this entries)
          next-wrappers (search-wrapper this)]
      (comp wrapper next-wrappers))))

(defn make-middleware
  ([{:keys [entries]}]
   (map->Middleware {:entries entries}))
  ([]
   (make-middleware {})))
