(ns leiningen.new.nrepl-figwheel-node
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]))

(def render (renderer "nrepl-figwheel-node"))

(defn nrepl-figwheel-node [name]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (->files data
      ["package.json" (render "package.json" data)]
      ["project.clj" (render "project.clj" data)]
      ["src/{{sanitized}}/core.cljs" (render "core.cljs" data)]
      ["src/{{sanitized}}/figwheel_nrepl.clj" (render "figwheel_nrepl.clj" data)]
      [".gitignore" (render "gitignore" data)])))
