(ns fdb-clj.tuple
  (:require [cheshire.core :as cheshire])
  (:import [com.apple.foundationdb.tuple Tuple]
           [java.nio ByteBuffer]))


(defn tuple->map
  ""
  [tuple]
  {:items (seq (.getItems tuple)) :size (.size tuple) :empty? (.isEmpty tuple)
   :packed-size (.getPackedSize tuple) :tuple tuple :packed (.pack tuple)})

(defn <-bytes
  "Takes `bs`, a byte array, builds a Tuple."
  [^bytes bs]
  (if (empty? bs)
    nil
    (-> (Tuple/fromBytes bs)
        tuple->map)))

(defn make
  "Takes `x`, builds a Tuple."
  [x]
  (-> (if (sequential? x) (to-array x) (to-array (conj [] x)))
      Tuple/from
      tuple->map))
  ;(let [t (if (sequential? x)
  ;          (Tuple/from (to-array x))
  ;          (Tuple/from (to-array (conj [] x))))
  ;      y (tuple->map t)]
  ;  y))

(defn nth
  ""
  ([tuple n] (nth tuple n nil))
  ([tuple n type]
    (case type
      :types/boolean (.getBoolean tuple n)
      :types/string  (.getString tuple n)
      :types/int     (.getInt (ByteBuffer/wrap (.getBytes tuple n)))
      :types/double  (.getDouble tuple n)
      :types/float   (.getFloat tuple n)
      :types/json    (cheshire/parse-string (.getString tuple n) true)
      :types/uuid    (.getUUID tuple n)
      :types/long    (.getLong tuple n)
      (.get tuple n))))
