(ns fdb-clj.key-value
  (:require [fdb-clj.tuple :as t])
  (:import [com.apple.foundationdb KeyValue]))

(defn ->map
  "Takes `kv`, the KeyValue, builds a map."
  [^KeyValue kv]
  (let [key-bs (.getKey kv)
        val-bs (.getValue kv)]
  {:key key-bs :key-tuple (t/<-bytes key-bs) :value val-bs :value-tuple (t/<-bytes val-bs)}))

