(ns fdb-clj.directory
  (:import [com.apple.foundationdb ReadTransactionContext Transaction]
           [com.apple.foundationdb.directory Directory DirectoryLayer]))

(defn instantiate
  "Creates a new DirectoryLayer"
  []
  (DirectoryLayer.))

(defn create-or-open
  "Takes `path`, creates or opens the FoundationDB directory."
  [^Transaction tr path]
  (let [sub-dir (if (sequential? path) path (conj [] path))]
    (.createOrOpen (instantiate) tr sub-dir)))

(defn open!
  "Takes `path`, opens the FoundationDB directory."
  [^Transaction tr path]
  (let [sub-dir (if (sequential? path) path (conj [] path))]
    (.open (instantiate) tr sub-dir)))

(defn exists?
  [^ReadTransactionContext tr ^Directory *dir]
  (.exists @*dir tr))

(defn subpath-exists?
  [^ReadTransactionContext tr ^Directory *dir subpath]
  (if (sequential? subpath)
    (.exists @*dir tr subpath)
    (.exists @*dir tr (conj [] subpath))))
