(ns fdb-clj.range
  (:require [fdb-clj.key-value :as kv])
  (:import [com.apple.foundationdb Range]
           [com.apple.foundationdb.tuple Tuple]))

(def ^:dynamic *directory* nil)

(defn from-start
  [tr start & {:keys [directory] :or {directory *directory*}}]
  (let [tuple (Tuple/fromList start)
        range (if (nil? directory) (.range tuple) (.range @directory tuple))
        xs    (-> (.getRange tr range)
                  .iterator
                  iterator-seq)]
    (mapv kv/->map xs)))

(defn start-end
  [tr start end & {:keys [directory] :or {directory *directory*}}]
  (let [start-tuple (Tuple/fromList start)
        start-bs    (if (nil? directory) (.pack start-tuple) (.pack @directory start-tuple))
        range       (Range. start-bs end)
        xs    (-> (.getRange tr range)
                  .iterator
                  iterator-seq)]
    (mapv kv/->map xs)))

(defn starts-with
  [tr start & {:keys [directory] :or {directory *directory*}}]
  (let [tuple (-> (if (sequential? start) (to-array start) (to-array (conj [] start)))
                  Tuple/from)
        bs    (if (nil? directory) (.pack tuple) (.pack @directory tuple))
        range (Range/startsWith bs)
        xs    (-> (.getRange tr range)
                  .iterator
                  iterator-seq)]
    (if (empty? xs)
      []
      (mapv kv/->map xs))))
