/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.slf4j.event.Level;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.impl.Mulog;

public final class MulogLoggerAdapter
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 4141593414490482208L;
    private String nm;

    MulogLoggerAdapter(String string) {
        this.nm = string;
    }

    public boolean isTraceEnabled() {
        return Mulog.isAtLeast(Level.TRACE);
    }

    public boolean isDebugEnabled() {
        return Mulog.isAtLeast(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return Mulog.isAtLeast(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return Mulog.isAtLeast(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return Mulog.isAtLeast(Level.ERROR);
    }

    public void trace(String string) {
        if (this.isTraceEnabled()) {
            Mulog.trace(this.nm, string);
        }
    }

    public void debug(String string) {
        if (this.isDebugEnabled()) {
            Mulog.debug(this.nm, string);
        }
    }

    public void info(String string) {
        if (this.isInfoEnabled()) {
            Mulog.info(this.nm, string);
        }
    }

    public void warn(String string) {
        if (this.isWarnEnabled()) {
            Mulog.warn(this.nm, string);
        }
    }

    public void error(String string) {
        if (this.isErrorEnabled()) {
            Mulog.error(this.nm, string);
        }
    }

    public void trace(String string, Throwable throwable) {
        if (this.isTraceEnabled()) {
            Mulog.trace(this.nm, string, throwable);
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.isDebugEnabled()) {
            Mulog.debug(this.nm, string, throwable);
        }
    }

    public void info(String string, Throwable throwable) {
        if (this.isInfoEnabled()) {
            Mulog.info(this.nm, string, throwable);
        }
    }

    public void warn(String string, Throwable throwable) {
        if (this.isWarnEnabled()) {
            Mulog.warn(this.nm, string, throwable);
        }
    }

    public void error(String string, Throwable throwable) {
        if (this.isErrorEnabled()) {
            Mulog.error(this.nm, string, throwable);
        }
    }

    private String fmt(String string, Object object) {
        return MessageFormatter.format((String)string, (Object)object).getMessage();
    }

    private String fmt(String string, Object object, Object object2) {
        return MessageFormatter.format((String)string, (Object)object, (Object)object2).getMessage();
    }

    private String afmt(String string, Object[] objectArray) {
        return MessageFormatter.arrayFormat((String)string, (Object[])objectArray).getMessage();
    }

    public void trace(String string, Object object) {
        if (this.isTraceEnabled()) {
            Mulog.trace(this.nm, this.fmt(string, object));
        }
    }

    public void trace(String string, Object object, Object object2) {
        if (this.isTraceEnabled()) {
            Mulog.trace(this.nm, this.fmt(string, object, object2));
        }
    }

    public void trace(String string, Object ... objectArray) {
        if (this.isTraceEnabled()) {
            Mulog.trace(this.nm, this.afmt(string, objectArray));
        }
    }

    public void debug(String string, Object object) {
        if (this.isDebugEnabled()) {
            Mulog.debug(this.nm, this.fmt(string, object));
        }
    }

    public void debug(String string, Object object, Object object2) {
        if (this.isDebugEnabled()) {
            Mulog.debug(this.nm, this.fmt(string, object, object2));
        }
    }

    public void debug(String string, Object ... objectArray) {
        if (this.isDebugEnabled()) {
            Mulog.debug(this.nm, this.afmt(string, objectArray));
        }
    }

    public void info(String string, Object object) {
        if (this.isInfoEnabled()) {
            Mulog.info(this.nm, this.fmt(string, object));
        }
    }

    public void info(String string, Object object, Object object2) {
        if (this.isInfoEnabled()) {
            Mulog.info(this.nm, this.fmt(string, object, object2));
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.isInfoEnabled()) {
            Mulog.info(this.nm, this.afmt(string, objectArray));
        }
    }

    public void warn(String string, Object object) {
        if (this.isWarnEnabled()) {
            Mulog.warn(this.nm, this.fmt(string, object));
        }
    }

    public void warn(String string, Object object, Object object2) {
        if (this.isWarnEnabled()) {
            Mulog.warn(this.nm, this.fmt(string, object, object2));
        }
    }

    public void warn(String string, Object ... objectArray) {
        if (this.isWarnEnabled()) {
            Mulog.warn(this.nm, this.afmt(string, objectArray));
        }
    }

    public void error(String string, Object object) {
        if (this.isErrorEnabled()) {
            Mulog.error(this.nm, this.fmt(string, object));
        }
    }

    public void error(String string, Object object, Object object2) {
        if (this.isErrorEnabled()) {
            Mulog.error(this.nm, this.fmt(string, object, object2));
        }
    }

    public void error(String string, Object ... objectArray) {
        if (this.isErrorEnabled()) {
            Mulog.error(this.nm, this.afmt(string, objectArray));
        }
    }
}

