(ns portfolio.react-utils
  (:require [goog]
            [goog.object :as o]
            ["react" :as react]
            [portfolio.ui.actions :as actions]
            [portfolio.adapter :as adapter]))

(def ^:dynamic *decorator* nil)

(defn set-decorator! [decorator]
  (set! *decorator* decorator))

(defn create-scene [scene impl]
  (-> scene
      (update :component-fn (fn [f]
                              (fn [& args]
                                (react/createElement #(apply f args) #js {}))))
      (adapter/prepare-scene impl)))

(defn get-scene [this]
  (o/getValueByKeys this "props" "scene"))

(defn create-safe-wrapper []
  (let [ctor (fn [])
        Decorator (or *decorator*
                      (.-Fragment react))]
    (goog.inherits ctor react/Component)
    (set! (.-getDerivedStateFromError ctor)
          (fn [error]
            #js {:error error}))
    (specify! (.-prototype ctor)
      Object

      (componentDidCatch [this error info]
        (when-let [actions (:report-render-error (:actions (get-scene this)))]
          (actions/dispatch actions nil {:action/exception error
                                         :action/info (js->clj info)
                                         :action/cause "React error boundary caught error"})))

      (render [this]
        (.createElement
         react Decorator #js{}
         (.createElement
          react "div" #js {}
          (if (o/getValueByKeys this "state" "error")
            ""
            (:component (get-scene this)))))))
    ctor))
