(ns portfolio.repl
  (:require [portfolio.data :as data]))

(defn register-scene! [scene]
  (when-not (:portfolio.repl @data/collections)
    (data/register-collection!
     :portfolio.repl
     {:kind :folder
      :collection nil
      :title "REPL"}))

  (let [scene (if (and (map? scene) (:component scene))
                scene
                {:component scene})]
    (data/register-scene!
     (into
      scene
      {:id (or (:id scene) (keyword "portfolio.repl" (str "scene-" (.getTime (js/Date.)))))
       :idx (data/get-next-idx "portfolio.repl")
       :collection :portfolio.repl}))))
