// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('rum.core');
goog.require('cljs.core');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
goog.require('goog.functions');
goog.require('clojure.set');
goog.require('rum.specs');
goog.require('daiquiri.core');
goog.require('rum.cursor');
goog.require('rum.util');
goog.require('rum.derived_atom');
goog.require('goog.object');
goog.scope(function(){
rum.core.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Given React component, returns Rum state associated with it.
 */
rum.core.state = (function rum$core$state(comp){
return rum.core.goog$module$goog$object.get.call(null,comp.state,":rum/state");
});
rum.core.extend_BANG_ = (function rum$core$extend_BANG_(obj,props){
var seq__22837 = cljs.core.seq.call(null,props);
var chunk__22839 = null;
var count__22840 = (0);
var i__22841 = (0);
while(true){
if((i__22841 < count__22840)){
var vec__22849 = cljs.core._nth.call(null,chunk__22839,i__22841);
var k = cljs.core.nth.call(null,vec__22849,(0),null);
var v = cljs.core.nth.call(null,vec__22849,(1),null);
if((!((v == null)))){
rum.core.goog$module$goog$object.set.call(null,obj,cljs.core.name.call(null,k),cljs.core.clj__GT_js.call(null,v));


var G__22855 = seq__22837;
var G__22856 = chunk__22839;
var G__22857 = count__22840;
var G__22858 = (i__22841 + (1));
seq__22837 = G__22855;
chunk__22839 = G__22856;
count__22840 = G__22857;
i__22841 = G__22858;
continue;
} else {
var G__22859 = seq__22837;
var G__22860 = chunk__22839;
var G__22861 = count__22840;
var G__22862 = (i__22841 + (1));
seq__22837 = G__22859;
chunk__22839 = G__22860;
count__22840 = G__22861;
i__22841 = G__22862;
continue;
}
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__22837);
if(temp__5804__auto__){
var seq__22837__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22837__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__22837__$1);
var G__22863 = cljs.core.chunk_rest.call(null,seq__22837__$1);
var G__22864 = c__5568__auto__;
var G__22865 = cljs.core.count.call(null,c__5568__auto__);
var G__22866 = (0);
seq__22837 = G__22863;
chunk__22839 = G__22864;
count__22840 = G__22865;
i__22841 = G__22866;
continue;
} else {
var vec__22852 = cljs.core.first.call(null,seq__22837__$1);
var k = cljs.core.nth.call(null,vec__22852,(0),null);
var v = cljs.core.nth.call(null,vec__22852,(1),null);
if((!((v == null)))){
rum.core.goog$module$goog$object.set.call(null,obj,cljs.core.name.call(null,k),cljs.core.clj__GT_js.call(null,v));


var G__22867 = cljs.core.next.call(null,seq__22837__$1);
var G__22868 = null;
var G__22869 = (0);
var G__22870 = (0);
seq__22837 = G__22867;
chunk__22839 = G__22868;
count__22840 = G__22869;
i__22841 = G__22870;
continue;
} else {
var G__22871 = cljs.core.next.call(null,seq__22837__$1);
var G__22872 = null;
var G__22873 = (0);
var G__22874 = (0);
seq__22837 = G__22871;
chunk__22839 = G__22872;
count__22840 = G__22873;
i__22841 = G__22874;
continue;
}
}
} else {
return null;
}
}
break;
}
});
rum.core.build_class = (function rum$core$build_class(render,mixins,display_name){
if(goog.DEBUG){
var mixins_22885__$1 = cljs.core.set.call(null,cljs.core.mapcat.call(null,cljs.core.keys,mixins));
if(clojure.set.subset_QMARK_.call(null,mixins_22885__$1,rum.specs.mixins)){
} else {
throw (new Error(["Assert failed: ",[cljs.core.str.cljs$core$IFn$_invoke$arity$1(display_name)," declares invalid mixin keys ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.set.difference.call(null,mixins_22885__$1,rum.specs.mixins)),", ","did you mean one of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(rum.specs.mixins)].join(''),"\n","(set/subset? mixins rum.specs/mixins)"].join('')));
}

cljs.core.run_BANG_.call(null,(function (p1__22875_SHARP_){
return console.warn(p1__22875_SHARP_);
}),cljs.core.vals.call(null,cljs.core.select_keys.call(null,rum.specs.deprecated_mixins,mixins_22885__$1)));
} else {
}

var init = rum.util.collect.call(null,new cljs.core.Keyword(null,"init","init",-1875481434),mixins);
var before_render = rum.util.collect_STAR_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"will-mount","will-mount",-434633071),new cljs.core.Keyword("unsafe","will-mount","unsafe/will-mount",265089051),new cljs.core.Keyword(null,"before-render","before-render",71256781)], null),mixins);
var render__$1 = render;
var wrap_render = rum.util.collect.call(null,new cljs.core.Keyword(null,"wrap-render","wrap-render",1782000986),mixins);
var wrapped_render = cljs.core.reduce.call(null,(function (p1__22877_SHARP_,p2__22876_SHARP_){
return p2__22876_SHARP_.call(null,p1__22877_SHARP_);
}),render__$1,wrap_render);
var did_mount = rum.util.collect_STAR_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"did-mount","did-mount",918232960),new cljs.core.Keyword(null,"after-render","after-render",1997533433)], null),mixins);
var will_remount = rum.util.collect_STAR_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"did-remount","did-remount",1362550500),new cljs.core.Keyword(null,"will-remount","will-remount",-141604325)], null),mixins);
var should_update = rum.util.collect.call(null,new cljs.core.Keyword(null,"should-update","should-update",-1292781795),mixins);
var before_update = rum.util.collect_STAR_.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"will-update","will-update",328062998),new cljs.core.Keyword("unsafe","will-update","unsafe/will-update",1505013232),new cljs.core.Keyword(null,"before-render","before-render",71256781)], null),mixins);
var did_update = rum.util.collect_STAR_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"did-update","did-update",-2143702256),new cljs.core.Keyword(null,"after-render","after-render",1997533433)], null),mixins);
var did_catch = rum.util.collect.call(null,new cljs.core.Keyword(null,"did-catch","did-catch",2139522313),mixins);
var will_unmount = rum.util.collect.call(null,new cljs.core.Keyword(null,"will-unmount","will-unmount",-808051550),mixins);
var child_context = rum.util.collect.call(null,new cljs.core.Keyword(null,"child-context","child-context",-1375270295),mixins);
var class_props = cljs.core.reduce.call(null,cljs.core.merge,rum.util.collect.call(null,new cljs.core.Keyword(null,"class-properties","class-properties",1351279702),mixins));
var static_props = cljs.core.reduce.call(null,cljs.core.merge,rum.util.collect.call(null,new cljs.core.Keyword(null,"static-properties","static-properties",-577838503),mixins));
var ctor = (function (props){
var this$ = this;
rum.core.goog$module$goog$object.set.call(null,this$,"state",({":rum/state": cljs.core.volatile_BANG_.call(null,rum.util.call_all.call(null,cljs.core.assoc.call(null,rum.core.goog$module$goog$object.get.call(null,props,":rum/initial-state"),new cljs.core.Keyword("rum","react-component","rum/react-component",-1879897248),this$),init,props))}));

return React.Component.call(this$,props);
});
var _ = goog.inherits(ctor,React.Component);
var prototype = rum.core.goog$module$goog$object.get.call(null,ctor,"prototype");
if(cljs.core.empty_QMARK_.call(null,before_render)){
} else {
rum.core.goog$module$goog$object.set.call(null,prototype,"UNSAFE_componentWillMount",(function (){
var this$ = this;
return cljs.core._vreset_BANG_.call(null,rum.core.state.call(null,this$),rum.util.call_all.call(null,cljs.core._deref.call(null,rum.core.state.call(null,this$)),before_render));
}));
}

if(cljs.core.empty_QMARK_.call(null,did_mount)){
} else {
rum.core.goog$module$goog$object.set.call(null,prototype,"componentDidMount",(function (){
var this$ = this;
return cljs.core._vreset_BANG_.call(null,rum.core.state.call(null,this$),rum.util.call_all.call(null,cljs.core._deref.call(null,rum.core.state.call(null,this$)),did_mount));
}));
}

rum.core.goog$module$goog$object.set.call(null,prototype,"UNSAFE_componentWillReceiveProps",(function (next_props){
var this$ = this;
var old_state = cljs.core.deref.call(null,rum.core.state.call(null,this$));
var state = cljs.core.merge.call(null,old_state,rum.core.goog$module$goog$object.get.call(null,next_props,":rum/initial-state"));
var next_state = cljs.core.reduce.call(null,(function (p1__22879_SHARP_,p2__22878_SHARP_){
return p2__22878_SHARP_.call(null,old_state,p1__22879_SHARP_);
}),state,will_remount);
return this$.setState(({":rum/state": cljs.core.volatile_BANG_.call(null,next_state)}));
}));

if(cljs.core.empty_QMARK_.call(null,should_update)){
} else {
rum.core.goog$module$goog$object.set.call(null,prototype,"shouldComponentUpdate",(function (next_props,next_state){
var this$ = this;
var old_state = cljs.core.deref.call(null,rum.core.state.call(null,this$));
var new_state = cljs.core.deref.call(null,rum.core.goog$module$goog$object.get.call(null,next_state,":rum/state"));
var or__5045__auto__ = cljs.core.some.call(null,(function (p1__22880_SHARP_){
return p1__22880_SHARP_.call(null,old_state,new_state);
}),should_update);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return false;
}
}));
}

if(cljs.core.empty_QMARK_.call(null,before_update)){
} else {
rum.core.goog$module$goog$object.set.call(null,prototype,"UNSAFE_componentWillUpdate",(function (___$1,next_state){
var this$ = this;
var new_state = rum.core.goog$module$goog$object.get.call(null,next_state,":rum/state");
return cljs.core._vreset_BANG_.call(null,new_state,rum.util.call_all.call(null,cljs.core._deref.call(null,new_state),before_update));
}));
}

rum.core.goog$module$goog$object.set.call(null,prototype,"render",(function (){
var this$ = this;
var state = rum.core.state.call(null,this$);
var vec__22882 = wrapped_render.call(null,cljs.core.deref.call(null,state));
var dom = cljs.core.nth.call(null,vec__22882,(0),null);
var next_state = cljs.core.nth.call(null,vec__22882,(1),null);
cljs.core.vreset_BANG_.call(null,state,next_state);

return dom;
}));

if(cljs.core.empty_QMARK_.call(null,did_update)){
} else {
rum.core.goog$module$goog$object.set.call(null,prototype,"componentDidUpdate",(function (___$1,___$2){
var this$ = this;
return cljs.core._vreset_BANG_.call(null,rum.core.state.call(null,this$),rum.util.call_all.call(null,cljs.core._deref.call(null,rum.core.state.call(null,this$)),did_update));
}));
}

if(cljs.core.empty_QMARK_.call(null,did_catch)){
} else {
rum.core.goog$module$goog$object.set.call(null,prototype,"componentDidCatch",(function (error,info){
var this$ = this;
cljs.core._vreset_BANG_.call(null,rum.core.state.call(null,this$),rum.util.call_all.call(null,cljs.core._deref.call(null,rum.core.state.call(null,this$)),did_catch,error,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("rum","component-stack","rum/component-stack",2037541138),rum.core.goog$module$goog$object.get.call(null,info,"componentStack")], null)));

return this$.forceUpdate();
}));
}

rum.core.goog$module$goog$object.set.call(null,prototype,"componentWillUnmount",(function (){
var this$ = this;
if(cljs.core.empty_QMARK_.call(null,will_unmount)){
} else {
cljs.core._vreset_BANG_.call(null,rum.core.state.call(null,this$),rum.util.call_all.call(null,cljs.core._deref.call(null,rum.core.state.call(null,this$)),will_unmount));
}

return rum.core.goog$module$goog$object.set.call(null,this$,":rum/unmounted?",true);
}));

if(cljs.core.empty_QMARK_.call(null,child_context)){
} else {
rum.core.goog$module$goog$object.set.call(null,prototype,"getChildContext",(function (){
var this$ = this;
var state = cljs.core.deref.call(null,rum.core.state.call(null,this$));
return cljs.core.clj__GT_js.call(null,cljs.core.transduce.call(null,cljs.core.map.call(null,(function (p1__22881_SHARP_){
return p1__22881_SHARP_.call(null,state);
})),cljs.core.merge,cljs.core.PersistentArrayMap.EMPTY,child_context));
}));
}

rum.core.extend_BANG_.call(null,prototype,class_props);

rum.core.goog$module$goog$object.set.call(null,ctor,"displayName",display_name);

rum.core.extend_BANG_.call(null,ctor,static_props);

return ctor;
});
rum.core.set_meta_BANG_ = (function rum$core$set_meta_BANG_(c){
var f = (function (){
var ctr = c.call(null);
return ctr.apply(ctr,arguments);
});
var x22886_22887 = f;
(x22886_22887.cljs$core$IMeta$ = cljs.core.PROTOCOL_SENTINEL);

(x22886_22887.cljs$core$IMeta$_meta$arity$1 = (function (_){
var ___$1 = this;
return cljs.core.meta.call(null,c.call(null));
}));


return f;
});
/**
 * Wraps component construction in a way so that Google Closure Compiler
 * can properly recognize and elide unused components. The extra `set-meta`
 * fn is needed so that the compiler can properly detect that all functions
 * are side effect free.
 */
rum.core.lazy_build = (function rum$core$lazy_build(ctor,render,mixins,display_name){
var bf = (function (){
return ctor.call(null,render,mixins,display_name);
});
var c = goog.functions.cacheReturnValue(bf);
return rum.core.set_meta_BANG_.call(null,c);
});
rum.core.build_ctor = (function rum$core$build_ctor(render,mixins,display_name){
var class$ = rum.core.build_class.call(null,render,mixins,display_name);
var key_fn = cljs.core.first.call(null,rum.util.collect.call(null,new cljs.core.Keyword(null,"key-fn","key-fn",-636154479),mixins));
var ctor = (((!((key_fn == null))))?(function() { 
var G__22888__delegate = function (args){
var props = ({":rum/initial-state": new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("rum","args","rum/args",1315791754),args], null), "key": cljs.core.apply.call(null,key_fn,args)});
return React.createElement(class$,props);
};
var G__22888 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__22889__i = 0, G__22889__a = new Array(arguments.length -  0);
while (G__22889__i < G__22889__a.length) {G__22889__a[G__22889__i] = arguments[G__22889__i + 0]; ++G__22889__i;}
  args = new cljs.core.IndexedSeq(G__22889__a,0,null);
} 
return G__22888__delegate.call(this,args);};
G__22888.cljs$lang$maxFixedArity = 0;
G__22888.cljs$lang$applyTo = (function (arglist__22890){
var args = cljs.core.seq(arglist__22890);
return G__22888__delegate(args);
});
G__22888.cljs$core$IFn$_invoke$arity$variadic = G__22888__delegate;
return G__22888;
})()
:(function() { 
var G__22891__delegate = function (args){
var props = ({":rum/initial-state": new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("rum","args","rum/args",1315791754),args], null)});
return React.createElement(class$,props);
};
var G__22891 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__22892__i = 0, G__22892__a = new Array(arguments.length -  0);
while (G__22892__i < G__22892__a.length) {G__22892__a[G__22892__i] = arguments[G__22892__i + 0]; ++G__22892__i;}
  args = new cljs.core.IndexedSeq(G__22892__a,0,null);
} 
return G__22891__delegate.call(this,args);};
G__22891.cljs$lang$maxFixedArity = 0;
G__22891.cljs$lang$applyTo = (function (arglist__22893){
var args = cljs.core.seq(arglist__22893);
return G__22891__delegate(args);
});
G__22891.cljs$core$IFn$_invoke$arity$variadic = G__22891__delegate;
return G__22891;
})()
);
return cljs.core.with_meta.call(null,ctor,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("rum","class","rum/class",-2030775258),class$], null));
});
rum.core.memo_compare_props = (function rum$core$memo_compare_props(prev_props,next_props){
return cljs.core._EQ_.call(null,(prev_props[":rum/args"]),(next_props[":rum/args"]));
});
rum.core.react_memo = (function rum$core$react_memo(f){
var temp__5806__auto__ = React.memo;
if((temp__5806__auto__ == null)){
return f;
} else {
var memo = temp__5806__auto__;
return memo.call(null,f,rum.core.memo_compare_props);
}
});
rum.core.build_defc = (function rum$core$build_defc(render_body,mixins,display_name){
if(cljs.core._EQ_.call(null,mixins,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [rum.core.static$], null))){
var class$ = (function (props){
return cljs.core.apply.call(null,render_body,(props[":rum/args"]));
});
var _ = (class$["displayName"] = display_name);
var memo_class = rum.core.react_memo.call(null,class$);
var ctor = (function() { 
var G__22894__delegate = function (args){
return React.createElement(memo_class,({":rum/args": args}));
};
var G__22894 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__22895__i = 0, G__22895__a = new Array(arguments.length -  0);
while (G__22895__i < G__22895__a.length) {G__22895__a[G__22895__i] = arguments[G__22895__i + 0]; ++G__22895__i;}
  args = new cljs.core.IndexedSeq(G__22895__a,0,null);
} 
return G__22894__delegate.call(this,args);};
G__22894.cljs$lang$maxFixedArity = 0;
G__22894.cljs$lang$applyTo = (function (arglist__22896){
var args = cljs.core.seq(arglist__22896);
return G__22894__delegate(args);
});
G__22894.cljs$core$IFn$_invoke$arity$variadic = G__22894__delegate;
return G__22894;
})()
;
return cljs.core.with_meta.call(null,ctor,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("rum","class","rum/class",-2030775258),memo_class], null));
} else {
if(cljs.core.empty_QMARK_.call(null,mixins)){
var class$ = (function (props){
return cljs.core.apply.call(null,render_body,(props[":rum/args"]));
});
var _ = (class$["displayName"] = display_name);
var ctor = (function() { 
var G__22897__delegate = function (args){
return React.createElement(class$,({":rum/args": args}));
};
var G__22897 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__22898__i = 0, G__22898__a = new Array(arguments.length -  0);
while (G__22898__i < G__22898__a.length) {G__22898__a[G__22898__i] = arguments[G__22898__i + 0]; ++G__22898__i;}
  args = new cljs.core.IndexedSeq(G__22898__a,0,null);
} 
return G__22897__delegate.call(this,args);};
G__22897.cljs$lang$maxFixedArity = 0;
G__22897.cljs$lang$applyTo = (function (arglist__22899){
var args = cljs.core.seq(arglist__22899);
return G__22897__delegate(args);
});
G__22897.cljs$core$IFn$_invoke$arity$variadic = G__22897__delegate;
return G__22897;
})()
;
return cljs.core.with_meta.call(null,ctor,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("rum","class","rum/class",-2030775258),class$], null));
} else {
var render = (function (state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,render_body,new cljs.core.Keyword("rum","args","rum/args",1315791754).cljs$core$IFn$_invoke$arity$1(state)),state], null);
});
return rum.core.build_ctor.call(null,render,mixins,display_name);

}
}
});
rum.core.build_defcs = (function rum$core$build_defcs(render_body,mixins,display_name){
var render = (function (state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,render_body,state,new cljs.core.Keyword("rum","args","rum/args",1315791754).cljs$core$IFn$_invoke$arity$1(state)),state], null);
});
return rum.core.build_ctor.call(null,render,mixins,display_name);
});
rum.core.build_defcc = (function rum$core$build_defcc(render_body,mixins,display_name){
var render = (function (state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.apply.call(null,render_body,new cljs.core.Keyword("rum","react-component","rum/react-component",-1879897248).cljs$core$IFn$_invoke$arity$1(state),new cljs.core.Keyword("rum","args","rum/args",1315791754).cljs$core$IFn$_invoke$arity$1(state)),state], null);
});
return rum.core.build_ctor.call(null,render,mixins,display_name);
});
rum.core.schedule = (function (){var or__5045__auto__ = (function (){var and__5043__auto__ = (typeof window !== 'undefined');
if(and__5043__auto__){
var or__5045__auto__ = window.requestAnimationFrame;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = window.webkitRequestAnimationFrame;
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
var or__5045__auto____$2 = window.mozRequestAnimationFrame;
if(cljs.core.truth_(or__5045__auto____$2)){
return or__5045__auto____$2;
} else {
return window.msRequestAnimationFrame;
}
}
}
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (function (p1__22900_SHARP_){
return setTimeout(p1__22900_SHARP_,(16));
});
}
})();
rum.core.batch = (function (){var or__5045__auto__ = (((typeof ReactNative !== 'undefined'))?ReactNative.unstable_batchedUpdates:null);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = (((typeof ReactDOM !== 'undefined'))?ReactDOM.unstable_batchedUpdates:null);
if(cljs.core.truth_(or__5045__auto____$1)){
return or__5045__auto____$1;
} else {
return (function (f,a){
return f.call(null,a);
});
}
}
})();
rum.core.empty_queue = cljs.core.PersistentVector.EMPTY;
rum.core.render_queue = cljs.core.volatile_BANG_.call(null,rum.core.empty_queue);
rum.core.render_one = (function rum$core$render_one(comp){
if((((!((comp == null)))) && (cljs.core.not.call(null,rum.core.goog$module$goog$object.get.call(null,comp,":rum/unmounted?"))))){
return comp.forceUpdate();
} else {
return null;
}
});
rum.core.render_all = (function rum$core$render_all(queue){
return cljs.core.run_BANG_.call(null,rum.core.render_one,queue);
});
rum.core.render = (function rum$core$render(){
var queue = cljs.core.deref.call(null,rum.core.render_queue);
cljs.core.vreset_BANG_.call(null,rum.core.render_queue,rum.core.empty_queue);

return rum.core.batch.call(null,rum.core.render_all,queue);
});
rum.core.sync_update_QMARK_ = cljs.core.volatile_BANG_.call(null,false);
/**
 * Schedules react component to be rendered on next animation frame,
 *   unless the requested update happens to be in a sync-update phase.
 */
rum.core.request_render = (function rum$core$request_render(component){
if(cljs.core.truth_(cljs.core.deref.call(null,rum.core.sync_update_QMARK_))){
return rum.core.render_one.call(null,component);
} else {
if(cljs.core.empty_QMARK_.call(null,cljs.core.deref.call(null,rum.core.render_queue))){
rum.core.schedule.call(null,rum.core.render);
} else {
}

return cljs.core._vreset_BANG_.call(null,rum.core.render_queue,cljs.core.conj.call(null,cljs.core._deref.call(null,rum.core.render_queue),component));
}
});
rum.core.mark_sync_update = (function rum$core$mark_sync_update(f){
if(cljs.core.fn_QMARK_.call(null,f)){
return (function rum$core$mark_sync_update_$_wrapped_handler(e){
var _ = cljs.core.vreset_BANG_.call(null,rum.core.sync_update_QMARK_,true);
var ret = f.call(null,e);
var ___$1 = cljs.core.vreset_BANG_.call(null,rum.core.sync_update_QMARK_,false);
return ret;
});
} else {
return f;
}
});
goog.exportSymbol('rum.core.mark_sync_update', rum.core.mark_sync_update);
/**
 * Add element to the DOM tree. Idempotent. Subsequent mounts will just update element.
 */
rum.core.mount = (function rum$core$mount(element,node){
ReactDOM.render(element,node);

return null;
});
/**
 * Removes component from the DOM tree.
 */
rum.core.unmount = (function rum$core$unmount(node){
return ReactDOM.unmountComponentAtNode(node);
});
/**
 * Same as [[mount]] but must be called on DOM tree already rendered by a server via [[render-html]].
 */
rum.core.hydrate = (function rum$core$hydrate(element,node){
return ReactDOM.hydrate(element,node);
});
/**
 * Render `element` in a DOM `node` that is ouside of current DOM hierarchy.
 */
rum.core.portal = (function rum$core$portal(element,node){
return ReactDOM.createPortal(element,node);
});
rum.core.create_context = (function rum$core$create_context(default_value){
return React.createContext(default_value);
});
/**
 * Adds React key to element.
 * 
 * ```
 * (rum/defc label [text] [:div text])
 * 
 * (-> (label)
 *     (rum/with-key "abc")
 *     (rum/mount js/document.body))
 * ```
 */
rum.core.with_key = (function rum$core$with_key(element,key){
return React.cloneElement(element,({"key": key}),null);
});
/**
 * Adds React ref (string or callback) to element.
 * 
 * ```
 * (rum/defc label [text] [:div text])
 * 
 * (-> (label)
 *     (rum/with-ref "abc")
 *     (rum/mount js/document.body))
 * ```
 */
rum.core.with_ref = (function rum$core$with_ref(element,ref){
return React.cloneElement(element,({"ref": ref}),null);
});
/**
 * Usage of this function is discouraged. Use :ref callback instead.
 *   Given state, returns top-level DOM node of component. Call it during lifecycle callbacks. Can’t be called during render.
 */
rum.core.dom_node = (function rum$core$dom_node(state){
return ReactDOM.findDOMNode(new cljs.core.Keyword("rum","react-component","rum/react-component",-1879897248).cljs$core$IFn$_invoke$arity$1(state));
});
/**
 * DEPRECATED: Use :ref (fn [dom-or-nil]) callback instead. See rum issue #124
 *   Given state and ref handle, returns React component.
 */
rum.core.ref = (function rum$core$ref(state,key){
return ((new cljs.core.Keyword("rum","react-component","rum/react-component",-1879897248).cljs$core$IFn$_invoke$arity$1(state)["refs"])[cljs.core.name.call(null,key)]);
});
/**
 * DEPRECATED: Use :ref (fn [dom-or-nil]) callback instead. See rum issue #124
 *   Given state and ref handle, returns DOM node associated with ref.
 */
rum.core.ref_node = (function rum$core$ref_node(state,key){
return ReactDOM.findDOMNode(rum.core.ref.call(null,state,cljs.core.name.call(null,key)));
});
/**
 * Mixin. Will avoid re-render if none of component’s arguments have changed. Does equality check (`=`) on all arguments.
 * 
 * ```
 * (rum/defc label < rum/static
 *   [text]
 *   [:div text])
 * 
 * (rum/mount (label "abc") js/document.body)
 * 
 * ;; def != abc, will re-render
 * (rum/mount (label "def") js/document.body)
 * 
 * ;; def == def, won’t re-render
 * (rum/mount (label "def") js/document.body)
 * ```
 */
rum.core.static$ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"should-update","should-update",-1292781795),(function (old_state,new_state){
return cljs.core.not_EQ_.call(null,new cljs.core.Keyword("rum","args","rum/args",1315791754).cljs$core$IFn$_invoke$arity$1(old_state),new cljs.core.Keyword("rum","args","rum/args",1315791754).cljs$core$IFn$_invoke$arity$1(new_state));
})], null);
/**
 * Mixin constructor. Adds an atom to component’s state that can be used to keep stuff during component’s lifecycle. Component will be re-rendered if atom’s value changes. Atom is stored under user-provided key or under `:rum/local` by default.
 * 
 * ```
 * (rum/defcs counter < (rum/local 0 :cnt)
 *   [state label]
 *   (let [*cnt (:cnt state)]
 *     [:div {:on-click (fn [_] (swap! *cnt inc))}
 *       label @*cnt]))
 * 
 * (rum/mount (counter "Click count: "))
 * ```
 */
rum.core.local = (function rum$core$local(var_args){
var G__22902 = arguments.length;
switch (G__22902) {
case 1:
return rum.core.local.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rum.core.local.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(rum.core.local.cljs$core$IFn$_invoke$arity$1 = (function (initial){
return rum.core.local.call(null,initial,new cljs.core.Keyword("rum","local","rum/local",-1497916586));
}));

(rum.core.local.cljs$core$IFn$_invoke$arity$2 = (function (initial,key){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"will-mount","will-mount",-434633071),(function (state){
var local_state = cljs.core.atom.call(null,initial);
var component = new cljs.core.Keyword("rum","react-component","rum/react-component",-1879897248).cljs$core$IFn$_invoke$arity$1(state);
cljs.core.add_watch.call(null,local_state,key,(function (_,___$1,p,n){
if(cljs.core.not_EQ_.call(null,p,n)){
return rum.core.request_render.call(null,component);
} else {
return null;
}
}));

return cljs.core.assoc.call(null,state,key,local_state);
})], null);
}));

(rum.core.local.cljs$lang$maxFixedArity = 2);

/**
 * Mixin. Works in conjunction with [[react]].
 * 
 * ```
 * (rum/defc comp < rum/reactive
 *   [*counter]
 *   [:div (rum/react counter)])
 * 
 * (def *counter (atom 0))
 * (rum/mount (comp *counter) js/document.body)
 * (swap! *counter inc) ;; will force comp to re-render
 * ```
 */
rum.core.reactive = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"init","init",-1875481434),(function (state,props){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("rum.reactive","key","rum.reactive/key",-803425142),cljs.core.random_uuid.call(null));
}),new cljs.core.Keyword(null,"wrap-render","wrap-render",1782000986),(function (render_fn){
return (function (state){
var _STAR_reactions_STAR__orig_val__22904 = rum.core._STAR_reactions_STAR_;
var _STAR_reactions_STAR__temp_val__22905 = cljs.core.volatile_BANG_.call(null,cljs.core.PersistentHashSet.EMPTY);
(rum.core._STAR_reactions_STAR_ = _STAR_reactions_STAR__temp_val__22905);

try{var comp = new cljs.core.Keyword("rum","react-component","rum/react-component",-1879897248).cljs$core$IFn$_invoke$arity$1(state);
var old_reactions = new cljs.core.Keyword("rum.reactive","refs","rum.reactive/refs",-814076325).cljs$core$IFn$_invoke$arity$2(state,cljs.core.PersistentHashSet.EMPTY);
var vec__22906 = render_fn.call(null,state);
var dom = cljs.core.nth.call(null,vec__22906,(0),null);
var next_state = cljs.core.nth.call(null,vec__22906,(1),null);
var new_reactions = cljs.core.deref.call(null,rum.core._STAR_reactions_STAR_);
var key = new cljs.core.Keyword("rum.reactive","key","rum.reactive/key",-803425142).cljs$core$IFn$_invoke$arity$1(state);
var seq__22909_22921 = cljs.core.seq.call(null,old_reactions);
var chunk__22910_22922 = null;
var count__22911_22923 = (0);
var i__22912_22924 = (0);
while(true){
if((i__22912_22924 < count__22911_22923)){
var ref_22925 = cljs.core._nth.call(null,chunk__22910_22922,i__22912_22924);
if(cljs.core.contains_QMARK_.call(null,new_reactions,ref_22925)){
} else {
cljs.core.remove_watch.call(null,ref_22925,key);
}


var G__22926 = seq__22909_22921;
var G__22927 = chunk__22910_22922;
var G__22928 = count__22911_22923;
var G__22929 = (i__22912_22924 + (1));
seq__22909_22921 = G__22926;
chunk__22910_22922 = G__22927;
count__22911_22923 = G__22928;
i__22912_22924 = G__22929;
continue;
} else {
var temp__5804__auto___22930 = cljs.core.seq.call(null,seq__22909_22921);
if(temp__5804__auto___22930){
var seq__22909_22931__$1 = temp__5804__auto___22930;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22909_22931__$1)){
var c__5568__auto___22932 = cljs.core.chunk_first.call(null,seq__22909_22931__$1);
var G__22933 = cljs.core.chunk_rest.call(null,seq__22909_22931__$1);
var G__22934 = c__5568__auto___22932;
var G__22935 = cljs.core.count.call(null,c__5568__auto___22932);
var G__22936 = (0);
seq__22909_22921 = G__22933;
chunk__22910_22922 = G__22934;
count__22911_22923 = G__22935;
i__22912_22924 = G__22936;
continue;
} else {
var ref_22937 = cljs.core.first.call(null,seq__22909_22931__$1);
if(cljs.core.contains_QMARK_.call(null,new_reactions,ref_22937)){
} else {
cljs.core.remove_watch.call(null,ref_22937,key);
}


var G__22938 = cljs.core.next.call(null,seq__22909_22931__$1);
var G__22939 = null;
var G__22940 = (0);
var G__22941 = (0);
seq__22909_22921 = G__22938;
chunk__22910_22922 = G__22939;
count__22911_22923 = G__22940;
i__22912_22924 = G__22941;
continue;
}
} else {
}
}
break;
}

var seq__22913_22942 = cljs.core.seq.call(null,new_reactions);
var chunk__22914_22943 = null;
var count__22915_22944 = (0);
var i__22916_22945 = (0);
while(true){
if((i__22916_22945 < count__22915_22944)){
var ref_22946 = cljs.core._nth.call(null,chunk__22914_22943,i__22916_22945);
if(cljs.core.contains_QMARK_.call(null,old_reactions,ref_22946)){
} else {
cljs.core.add_watch.call(null,ref_22946,key,((function (seq__22913_22942,chunk__22914_22943,count__22915_22944,i__22916_22945,ref_22946,comp,old_reactions,vec__22906,dom,next_state,new_reactions,key,_STAR_reactions_STAR__orig_val__22904,_STAR_reactions_STAR__temp_val__22905){
return (function (_,___$1,p,n){
if(cljs.core.not_EQ_.call(null,p,n)){
return rum.core.request_render.call(null,comp);
} else {
return null;
}
});})(seq__22913_22942,chunk__22914_22943,count__22915_22944,i__22916_22945,ref_22946,comp,old_reactions,vec__22906,dom,next_state,new_reactions,key,_STAR_reactions_STAR__orig_val__22904,_STAR_reactions_STAR__temp_val__22905))
);
}


var G__22947 = seq__22913_22942;
var G__22948 = chunk__22914_22943;
var G__22949 = count__22915_22944;
var G__22950 = (i__22916_22945 + (1));
seq__22913_22942 = G__22947;
chunk__22914_22943 = G__22948;
count__22915_22944 = G__22949;
i__22916_22945 = G__22950;
continue;
} else {
var temp__5804__auto___22951 = cljs.core.seq.call(null,seq__22913_22942);
if(temp__5804__auto___22951){
var seq__22913_22952__$1 = temp__5804__auto___22951;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22913_22952__$1)){
var c__5568__auto___22953 = cljs.core.chunk_first.call(null,seq__22913_22952__$1);
var G__22954 = cljs.core.chunk_rest.call(null,seq__22913_22952__$1);
var G__22955 = c__5568__auto___22953;
var G__22956 = cljs.core.count.call(null,c__5568__auto___22953);
var G__22957 = (0);
seq__22913_22942 = G__22954;
chunk__22914_22943 = G__22955;
count__22915_22944 = G__22956;
i__22916_22945 = G__22957;
continue;
} else {
var ref_22958 = cljs.core.first.call(null,seq__22913_22952__$1);
if(cljs.core.contains_QMARK_.call(null,old_reactions,ref_22958)){
} else {
cljs.core.add_watch.call(null,ref_22958,key,((function (seq__22913_22942,chunk__22914_22943,count__22915_22944,i__22916_22945,ref_22958,seq__22913_22952__$1,temp__5804__auto___22951,comp,old_reactions,vec__22906,dom,next_state,new_reactions,key,_STAR_reactions_STAR__orig_val__22904,_STAR_reactions_STAR__temp_val__22905){
return (function (_,___$1,p,n){
if(cljs.core.not_EQ_.call(null,p,n)){
return rum.core.request_render.call(null,comp);
} else {
return null;
}
});})(seq__22913_22942,chunk__22914_22943,count__22915_22944,i__22916_22945,ref_22958,seq__22913_22952__$1,temp__5804__auto___22951,comp,old_reactions,vec__22906,dom,next_state,new_reactions,key,_STAR_reactions_STAR__orig_val__22904,_STAR_reactions_STAR__temp_val__22905))
);
}


var G__22959 = cljs.core.next.call(null,seq__22913_22952__$1);
var G__22960 = null;
var G__22961 = (0);
var G__22962 = (0);
seq__22913_22942 = G__22959;
chunk__22914_22943 = G__22960;
count__22915_22944 = G__22961;
i__22916_22945 = G__22962;
continue;
}
} else {
}
}
break;
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [dom,cljs.core.assoc.call(null,next_state,new cljs.core.Keyword("rum.reactive","refs","rum.reactive/refs",-814076325),new_reactions)], null);
}finally {(rum.core._STAR_reactions_STAR_ = _STAR_reactions_STAR__orig_val__22904);
}});
}),new cljs.core.Keyword(null,"will-unmount","will-unmount",-808051550),(function (state){
var key_22963 = new cljs.core.Keyword("rum.reactive","key","rum.reactive/key",-803425142).cljs$core$IFn$_invoke$arity$1(state);
var seq__22917_22964 = cljs.core.seq.call(null,new cljs.core.Keyword("rum.reactive","refs","rum.reactive/refs",-814076325).cljs$core$IFn$_invoke$arity$1(state));
var chunk__22918_22965 = null;
var count__22919_22966 = (0);
var i__22920_22967 = (0);
while(true){
if((i__22920_22967 < count__22919_22966)){
var ref_22968 = cljs.core._nth.call(null,chunk__22918_22965,i__22920_22967);
cljs.core.remove_watch.call(null,ref_22968,key_22963);


var G__22969 = seq__22917_22964;
var G__22970 = chunk__22918_22965;
var G__22971 = count__22919_22966;
var G__22972 = (i__22920_22967 + (1));
seq__22917_22964 = G__22969;
chunk__22918_22965 = G__22970;
count__22919_22966 = G__22971;
i__22920_22967 = G__22972;
continue;
} else {
var temp__5804__auto___22973 = cljs.core.seq.call(null,seq__22917_22964);
if(temp__5804__auto___22973){
var seq__22917_22974__$1 = temp__5804__auto___22973;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22917_22974__$1)){
var c__5568__auto___22975 = cljs.core.chunk_first.call(null,seq__22917_22974__$1);
var G__22976 = cljs.core.chunk_rest.call(null,seq__22917_22974__$1);
var G__22977 = c__5568__auto___22975;
var G__22978 = cljs.core.count.call(null,c__5568__auto___22975);
var G__22979 = (0);
seq__22917_22964 = G__22976;
chunk__22918_22965 = G__22977;
count__22919_22966 = G__22978;
i__22920_22967 = G__22979;
continue;
} else {
var ref_22980 = cljs.core.first.call(null,seq__22917_22974__$1);
cljs.core.remove_watch.call(null,ref_22980,key_22963);


var G__22981 = cljs.core.next.call(null,seq__22917_22974__$1);
var G__22982 = null;
var G__22983 = (0);
var G__22984 = (0);
seq__22917_22964 = G__22981;
chunk__22918_22965 = G__22982;
count__22919_22966 = G__22983;
i__22920_22967 = G__22984;
continue;
}
} else {
}
}
break;
}

return cljs.core.dissoc.call(null,state,new cljs.core.Keyword("rum.reactive","refs","rum.reactive/refs",-814076325),new cljs.core.Keyword("rum.reactive","key","rum.reactive/key",-803425142));
})], null);
/**
 * Works in conjunction with [[reactive]] mixin. Use this function instead of `deref` inside render, and your component will subscribe to changes happening to the derefed atom.
 */
rum.core.react = (function rum$core$react(ref){
if(cljs.core.truth_(rum.core._STAR_reactions_STAR_)){
} else {
throw (new Error(["Assert failed: ","rum.core/react is only supported in conjunction with rum.core/reactive","\n","*reactions*"].join('')));
}

cljs.core._vreset_BANG_.call(null,rum.core._STAR_reactions_STAR_,cljs.core.conj.call(null,cljs.core._deref.call(null,rum.core._STAR_reactions_STAR_),ref));

return cljs.core.deref.call(null,ref);
});
/**
 * Use this to create “chains” and acyclic graphs of dependent atoms.
 * 
 *           [[derived-atom]] will:
 * 
 *           - Take N “source” refs.
 *           - Set up a watch on each of them.
 *           - Create “sink” atom.
 *           - When any of source refs changes:
 *              - re-run function `f`, passing N dereferenced values of source refs.
 *              - `reset!` result of `f` to the sink atom.
 *           - Return sink atom.
 * 
 *           Example:
 * 
 *           ```
 *           (def *a (atom 0))
 *           (def *b (atom 1))
 *           (def *x (derived-atom [*a *b] ::key
 *                     (fn [a b]
 *                       (str a ":" b))))
 * 
 *           (type *x)  ;; => clojure.lang.Atom
 *           (deref *x) ;; => "0:1"
 * 
 *           (swap! *a inc)
 *           (deref *x) ;; => "1:1"
 * 
 *           (reset! *b 7)
 *           (deref *x) ;; => "1:7"
 *           ```
 * 
 *           Arguments:
 * 
 *           - `refs` - sequence of source refs,
 *           - `key`  - unique key to register watcher, same as in `clojure.core/add-watch`,
 *           - `f`    - function that must accept N arguments (same as number of source refs) and return a value to be written to the sink ref. Note: `f` will be called with already dereferenced values,
 *           - `opts` - optional. Map of:
 *             - `:ref` - use this as sink ref. By default creates new atom,
 *             - `:check-equals?` - Defaults to `true`. If equality check should be run on each source update: `(= @sink (f new-vals))`. When result of recalculating `f` equals to the old value, `reset!` won’t be called. Set to `false` if checking for equality can be expensive.
 */
rum.core.derived_atom = rum.derived_atom.derived_atom;
/**
 * Given atom with deep nested value and path inside it, creates an atom-like structure
 * that can be used separately from main atom, but will sync changes both ways:
 * 
 * ```
 * (def db (atom { :users { "Ivan" { :age 30 }}}))
 * 
 * (def ivan (rum/cursor db [:users "Ivan"]))
 * (deref ivan) ;; => { :age 30 }
 * 
 * (swap! ivan update :age inc) ;; => { :age 31 }
 * (deref db) ;; => { :users { "Ivan" { :age 31 }}}
 * 
 * (swap! db update-in [:users "Ivan" :age] inc)
 * ;; => { :users { "Ivan" { :age 32 }}}
 * 
 * (deref ivan) ;; => { :age 32 }
 * ```
 * 
 * Returned value supports `deref`, `swap!`, `reset!`, watches and metadata.
 * 
 * The only supported option is `:meta`
 */
rum.core.cursor_in = (function rum$core$cursor_in(var_args){
var args__5775__auto__ = [];
var len__5769__auto___22990 = arguments.length;
var i__5770__auto___22991 = (0);
while(true){
if((i__5770__auto___22991 < len__5769__auto___22990)){
args__5775__auto__.push((arguments[i__5770__auto___22991]));

var G__22992 = (i__5770__auto___22991 + (1));
i__5770__auto___22991 = G__22992;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return rum.core.cursor_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(rum.core.cursor_in.cljs$core$IFn$_invoke$arity$variadic = (function (ref,path,p__22988){
var map__22989 = p__22988;
var map__22989__$1 = cljs.core.__destructure_map.call(null,map__22989);
var options = map__22989__$1;
if((ref instanceof rum.cursor.Cursor)){
return (new rum.cursor.Cursor(ref.ref,cljs.core.into.call(null,ref.path,path),new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(options)));
} else {
return (new rum.cursor.Cursor(ref,path,new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(options)));
}
}));

(rum.core.cursor_in.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(rum.core.cursor_in.cljs$lang$applyTo = (function (seq22985){
var G__22986 = cljs.core.first.call(null,seq22985);
var seq22985__$1 = cljs.core.next.call(null,seq22985);
var G__22987 = cljs.core.first.call(null,seq22985__$1);
var seq22985__$2 = cljs.core.next.call(null,seq22985__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22986,G__22987,seq22985__$2);
}));

/**
 * Same as [[cursor-in]] but accepts single key instead of path vector.
 */
rum.core.cursor = (function rum$core$cursor(var_args){
var args__5775__auto__ = [];
var len__5769__auto___22996 = arguments.length;
var i__5770__auto___22997 = (0);
while(true){
if((i__5770__auto___22997 < len__5769__auto___22996)){
args__5775__auto__.push((arguments[i__5770__auto___22997]));

var G__22998 = (i__5770__auto___22997 + (1));
i__5770__auto___22997 = G__22998;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((2) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((2)),(0),null)):null);
return rum.core.cursor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5776__auto__);
});

(rum.core.cursor.cljs$core$IFn$_invoke$arity$variadic = (function (ref,key,options){
return cljs.core.apply.call(null,rum.core.cursor_in,ref,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [key], null),options);
}));

(rum.core.cursor.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(rum.core.cursor.cljs$lang$applyTo = (function (seq22993){
var G__22994 = cljs.core.first.call(null,seq22993);
var seq22993__$1 = cljs.core.next.call(null,seq22993);
var G__22995 = cljs.core.first.call(null,seq22993__$1);
var seq22993__$2 = cljs.core.next.call(null,seq22993__$1);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22994,G__22995,seq22993__$2);
}));

/**
 * Takes initial value or value returning fn and returns a tuple of [value set-value!],
 *   where `value` is current state value and `set-value!` is a function that schedules re-render.
 * 
 *   (let [[value set-state!] (rum/use-state 0)]
 *  [:button {:on-click #(set-state! (inc value))}
 *    value])
 */
rum.core.use_state = (function rum$core$use_state(value_or_fn){
return React.useState(value_or_fn);
});
/**
 * Takes reducing function and initial state value.
 *   Returns a tuple of [value dispatch!], where `value` is current state value and `dispatch` is a function that schedules re-render.
 * 
 *   (defmulti value-reducer (fn [value event] event))
 * 
 *   (defmethod value-reducer :inc [value _]
 *  (inc value))
 * 
 *   (let [[value dispatch!] (rum/use-reducer value-reducer 0)]
 *  [:button {:on-click #(dispatch! :inc)}
 *    value])
 * 
 *   Read more at https://reactjs.org/docs/hooks-reference.html#usereducer
 */
rum.core.use_reducer = (function rum$core$use_reducer(reducer_fn,initial_value){
return React.useReducer((function (p1__22999_SHARP_,p2__23000_SHARP_){
return reducer_fn.call(null,p1__22999_SHARP_,p2__23000_SHARP_);
}),initial_value,cljs.core.identity);
});
/**
 * Takes setup-fn that executes either on the first render or after every update.
 *   The function may return cleanup-fn to cleanup the effect, either before unmount or before every next update.
 *   Calling behavior is controlled by deps argument.
 * 
 *   (rum/use-effect!
 *  (fn []
 *    (.addEventListener js/window "load" handler)
 *    #(.removeEventListener js/window "load" handler))
 *  []) ;; empty deps collection instructs React to run setup-fn only once on initial render
 *      ;; and cleanup-fn only once before unmounting
 * 
 *   Read more at https://reactjs.org/docs/hooks-effect.html
 */
rum.core.use_effect_BANG_ = (function rum$core$use_effect_BANG_(var_args){
var G__23002 = arguments.length;
switch (G__23002) {
case 1:
return rum.core.use_effect_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rum.core.use_effect_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(rum.core.use_effect_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (setup_fn){
return React.useEffect((function (){
var or__5045__auto__ = setup_fn.call(null);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return undefined;
}
}));
}));

(rum.core.use_effect_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (setup_fn,deps){
return React.useEffect((function (){
var or__5045__auto__ = setup_fn.call(null);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return undefined;
}
}),((cljs.core.array_QMARK_.call(null,deps))?deps:cljs.core.into_array.call(null,deps)));
}));

(rum.core.use_effect_BANG_.cljs$lang$maxFixedArity = 2);

/**
 * (rum/use-layout-effect!
 *  (fn []
 *    (.addEventListener js/window "load" handler)
 *    #(.removeEventListener js/window "load" handler))
 *  []) ;; empty deps collection instructs React to run setup-fn only once on initial render
 *      ;; and cleanup-fn only once before unmounting
 * 
 *   Read more at https://reactjs.org/docs/hooks-effect.html
 */
rum.core.use_layout_effect_BANG_ = (function rum$core$use_layout_effect_BANG_(var_args){
var G__23005 = arguments.length;
switch (G__23005) {
case 1:
return rum.core.use_layout_effect_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rum.core.use_layout_effect_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(rum.core.use_layout_effect_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (setup_fn){
return React.useLayoutEffect((function (){
var or__5045__auto__ = setup_fn.call(null);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return undefined;
}
}));
}));

(rum.core.use_layout_effect_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (setup_fn,deps){
return React.useLayoutEffect((function (){
var or__5045__auto__ = setup_fn.call(null);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return undefined;
}
}),((cljs.core.array_QMARK_.call(null,deps))?deps:cljs.core.into_array.call(null,deps)));
}));

(rum.core.use_layout_effect_BANG_.cljs$lang$maxFixedArity = 2);

/**
 * Takes callback function and returns memoized variant, memoization is done based on provided deps collection.
 * 
 *   (rum/defc button < rum/static
 *  [{:keys [on-click]} text]
 *  [:button {:on-click on-click}
 *    text])
 * 
 *   (rum/defc app [v]
 *  (let [on-click (rum/use-callback #(do-stuff v) [v])]
 *    ;; because on-click callback is memoized here based on v argument
 *    ;; the callback won't be re-created on every render, unless v changes
 *    ;; which means that underlying `button` component won't re-render wastefully
 *    [button {:on-click on-click}
 *      "press me"]))
 * 
 *   Read more at https://reactjs.org/docs/hooks-reference.html#usecallback
 */
rum.core.use_callback = (function rum$core$use_callback(var_args){
var G__23008 = arguments.length;
switch (G__23008) {
case 1:
return rum.core.use_callback.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rum.core.use_callback.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(rum.core.use_callback.cljs$core$IFn$_invoke$arity$1 = (function (callback){
return React.useCallback(callback);
}));

(rum.core.use_callback.cljs$core$IFn$_invoke$arity$2 = (function (callback,deps){
return React.useCallback(callback,((cljs.core.array_QMARK_.call(null,deps))?deps:cljs.core.into_array.call(null,deps)));
}));

(rum.core.use_callback.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function, memoizes it based on provided deps collection and executes immediately returning a result.
 *   Read more at https://reactjs.org/docs/hooks-reference.html#usememo
 */
rum.core.use_memo = (function rum$core$use_memo(var_args){
var G__23011 = arguments.length;
switch (G__23011) {
case 1:
return rum.core.use_memo.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rum.core.use_memo.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(rum.core.use_memo.cljs$core$IFn$_invoke$arity$1 = (function (f){
return React.useMemo(f);
}));

(rum.core.use_memo.cljs$core$IFn$_invoke$arity$2 = (function (f,deps){
return React.useMemo(f,((cljs.core.array_QMARK_.call(null,deps))?deps:cljs.core.into_array.call(null,deps)));
}));

(rum.core.use_memo.cljs$lang$maxFixedArity = 2);

/**
 * Takes a value and puts it into a mutable container which is persisted for the full lifetime of the component.
 *   https://reactjs.org/docs/hooks-reference.html#useref
 */
rum.core.use_ref = (function rum$core$use_ref(initial_value){
return React.useRef(initial_value);
});
rum.core.create_ref = (function rum$core$create_ref(){
return React.createRef();
});
/**
 * Takes a ref returned from use-ref and returns its current value.
 */
rum.core.deref = (function rum$core$deref(ref){
return ref.current;
});
rum.core.set_ref_BANG_ = (function rum$core$set_ref_BANG_(ref,value){
return (ref.current = value);
});
/**
 * Main server-side rendering method. Given component, returns HTML string with static markup of that component.
 *   Serve that string to the browser and [[hydrate]] same Rum component over it. React will be able to reuse already existing DOM and will initialize much faster.
 *   No opts are supported at the moment.
 */
rum.core.render_html = (function rum$core$render_html(var_args){
var G__23014 = arguments.length;
switch (G__23014) {
case 1:
return rum.core.render_html.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return rum.core.render_html.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(rum.core.render_html.cljs$core$IFn$_invoke$arity$1 = (function (element){
return rum.core.render_html.call(null,element,null);
}));

(rum.core.render_html.cljs$core$IFn$_invoke$arity$2 = (function (element,opts){
if((!((cljs.core._STAR_target_STAR_ === "nodejs")))){
return ReactDOMServer.renderToString(element);
} else {
var react_dom_server = require("react-dom/server");
return react_dom_server.renderToString(element);
}
}));

(rum.core.render_html.cljs$lang$maxFixedArity = 2);

/**
 * Same as [[render-html]] but returned string has nothing React-specific.
 *   This allows Rum to be used as traditional server-side templating engine.
 */
rum.core.render_static_markup = (function rum$core$render_static_markup(src){
if((!((cljs.core._STAR_target_STAR_ === "nodejs")))){
return ReactDOMServer.renderToStaticMarkup(src);
} else {
var react_dom_server = require("react-dom/server");
return react_dom_server.renderToStaticMarkup(src);
}
});
rum.core.adapt_class_helper = (function rum$core$adapt_class_helper(type,attrs,children){
var args = [type,attrs].concat(children);
return React.createElement.apply(React,args);
});

//# sourceMappingURL=core.js.map
