(ns portfolio.views.canvas.args
  (:require [portfolio.components.arguments-panel :refer [ArgumentsPanel]]
            [portfolio.core :as p]
            [portfolio.view :as view]
            [portfolio.views.canvas.protocols :as canvas]))

(def render-impl
  {`view/render-view #'ArgumentsPanel})

(defn get-input-kind [scene k v]
  (or (get-in scene [:arg-defs k :input/kind])
      (cond
        (boolean? v)
        {:kind :boolean
         :value v
         :actions [[:set-scene-argument (:id scene) k (not v)]]}

        (number? v)
        {:kind :number
         :value v
         :actions [[:set-scene-argument (:id scene) k :event.target/number-value]]}

        :default
        {:kind :text
         :value v
         :actions [[:set-scene-argument (:id scene) k :event.target/value]]})))

(defn prepare-arguments [scene overrides param]
  (when (map? param)
    (for [[k v] param]
      (cond->
          {:label (str k)
           :value v
           :input (get-input-kind scene k v)}
        (= (k param) (k overrides))
        (assoc :clear-actions [[:remove-scene-argument (:id scene) k]])))))

(defn prepare-panel-content [panel state scene]
  (when (:param scene)
    (with-meta
      (let [param (p/get-scene-param state scene)
            param (if (satisfies? cljs.core/IWatchable param) @param param)
            overrides (p/get-scene-arg-overrides state scene)]
        {:param (prepare-arguments scene overrides param)})
      render-impl)))

(def data-impl
  {`canvas/prepare-panel-content #'prepare-panel-content})

(defn create-args-panel [config]
  (with-meta
    {:id :canvas/param-panel
     :title "Param"}
    data-impl))
