// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('portfolio.components.paredit');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljsjs.codemirror');
goog.require('cljsjs.codemirror.mode.clojure');
goog.require('cljsjs.codemirror.keymap.emacs');
cljs.core.enable_console_print_BANG_.call(null);
portfolio.components.paredit.openers = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["(",null,"{",null,"[",null], null), null);
portfolio.components.paredit.closers = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["]",null,")",null,"}",null], null), null);
portfolio.components.paredit.pair = new cljs.core.PersistentArrayMap(null, 7, ["(",")","[","]","{","}","\"","\"",")","(","]","[","}","{"], null);
/**
 * true if the two strings are a matching open/close pair 
 */
portfolio.components.paredit.pair_QMARK_ = (function portfolio$components$paredit$pair_QMARK_(s1,s2){
return cljs.core._EQ_.call(null,portfolio.components.paredit.pair.call(null,s1),s2);
});
portfolio.components.paredit.opener_QMARK_ = (function portfolio$components$paredit$opener_QMARK_(s){
return cljs.core.contains_QMARK_.call(null,portfolio.components.paredit.openers,s);
});
portfolio.components.paredit.closer_QMARK_ = (function portfolio$components$paredit$closer_QMARK_(s){
return cljs.core.contains_QMARK_.call(null,portfolio.components.paredit.closers,s);
});
portfolio.components.paredit.is_bracket_type_QMARK_ = (function portfolio$components$paredit$is_bracket_type_QMARK_(t){
var and__5043__auto__ = t;
if(cljs.core.truth_(and__5043__auto__)){
return clojure.string.starts_with_QMARK_.call(null,t,"bracket");
} else {
return and__5043__auto__;
}
});
/**
 * returns the number of characters in the code mirror instance
 */
portfolio.components.paredit.char_count = (function portfolio$components$paredit$char_count(cm){
return cljs.core.count.call(null,cm.getValue());
});
/**
 * get cur, the position of the cursor
 */
portfolio.components.paredit.cursor = (function portfolio$components$paredit$cursor(var_args){
var G__28673 = arguments.length;
switch (G__28673) {
case 1:
return portfolio.components.paredit.cursor.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.cursor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.cursor.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return cm.getCursor();
}));

(portfolio.components.paredit.cursor.cljs$core$IFn$_invoke$arity$2 = (function (cm,i){
return cm.posFromIndex(i);
}));

(portfolio.components.paredit.cursor.cljs$lang$maxFixedArity = 2);

/**
 * get the index i for the cursor's position
 */
portfolio.components.paredit.index = (function portfolio$components$paredit$index(var_args){
var G__28676 = arguments.length;
switch (G__28676) {
case 1:
return portfolio.components.paredit.index.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.index.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.index.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.index.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.index.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(cljs.core.truth_(cur)){
return cm.indexFromPos(cur);
} else {
return null;
}
}));

(portfolio.components.paredit.index.cljs$lang$maxFixedArity = 2);

/**
 * true if at beginning of file
 */
portfolio.components.paredit.bof_QMARK_ = (function portfolio$components$paredit$bof_QMARK_(cm,cur){
return (portfolio.components.paredit.index.call(null,cm,cur) === (0));
});
/**
 * true if at end of file
 */
portfolio.components.paredit.eof_QMARK_ = (function portfolio$components$paredit$eof_QMARK_(cm,cur){
return cljs.core._EQ_.call(null,portfolio.components.paredit.index.call(null,cm,cur),portfolio.components.paredit.char_count.call(null,cm));
});
/**
 * get token at cursor
 */
portfolio.components.paredit.token = (function portfolio$components$paredit$token(cm,cur){
return cm.getTokenAt(cur,true);
});
/**
 * get the type at the current cursor.
 */
portfolio.components.paredit.get_type = (function portfolio$components$paredit$get_type(var_args){
var G__28679 = arguments.length;
switch (G__28679) {
case 1:
return portfolio.components.paredit.get_type.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.get_type.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.get_type.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.get_type.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.get_type.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
return portfolio.components.paredit.token.call(null,cm,cur).type;
}));

(portfolio.components.paredit.get_type.cljs$lang$maxFixedArity = 2);

/**
 * gets the string of the current token
 */
portfolio.components.paredit.get_string = (function portfolio$components$paredit$get_string(var_args){
var G__28682 = arguments.length;
switch (G__28682) {
case 1:
return portfolio.components.paredit.get_string.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.get_string.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.get_string.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.get_string.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.get_string.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(cljs.core.truth_(cur)){
return portfolio.components.paredit.token.call(null,cm,cur).string;
} else {
return null;
}
}));

(portfolio.components.paredit.get_string.cljs$lang$maxFixedArity = 2);

/**
 * gets the length of the current line
 */
portfolio.components.paredit.line_length = (function portfolio$components$paredit$line_length(var_args){
var G__28685 = arguments.length;
switch (G__28685) {
case 1:
return portfolio.components.paredit.line_length.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.line_length.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.line_length.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.line_length.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.line_length.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(cljs.core.truth_(cur)){
return cljs.core.count.call(null,cm.getLine(cur.line));
} else {
return null;
}
}));

(portfolio.components.paredit.line_length.cljs$lang$maxFixedArity = 2);

/**
 * returns the last token of a line
 */
portfolio.components.paredit.last_token = (function portfolio$components$paredit$last_token(cm,cur){
return cljs.core.last.call(null,cm.getLineTokens(cur.line));
});
/**
 * returns the last cursor of a line
 */
portfolio.components.paredit.last_cur = (function portfolio$components$paredit$last_cur(var_args){
var G__28688 = arguments.length;
switch (G__28688) {
case 1:
return portfolio.components.paredit.last_cur.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.last_cur.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.last_cur.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.last_cur.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.last_cur.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var end = portfolio.components.paredit.last_token.call(null,cm,cur).end;
var diff = (end - cur.ch);
return portfolio.components.paredit.cursor.call(null,cm,(diff + portfolio.components.paredit.index.call(null,cm,cur)));
}));

(portfolio.components.paredit.last_cur.cljs$lang$maxFixedArity = 2);

/**
 * make info from CodeMirror more conveniently accessed by our code.
 *   we'll use destructuring and just name what we rant. hypothesizing
 *   that performance hit won't be that bad.
 */
portfolio.components.paredit.get_info = (function portfolio$components$paredit$get_info(var_args){
var G__28691 = arguments.length;
switch (G__28691) {
case 1:
return portfolio.components.paredit.get_info.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.get_info.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.get_info.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.get_info.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.get_info.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(cljs.core.truth_(cur)){
var tok = portfolio.components.paredit.token.call(null,cm,cur);
var eof = portfolio.components.paredit.eof_QMARK_.call(null,cm,cur);
var bof = portfolio.components.paredit.bof_QMARK_.call(null,cm,cur);
var i = portfolio.components.paredit.index.call(null,cm,cur);
var left_cur = ((bof)?null:portfolio.components.paredit.cursor.call(null,cm,(i - (1))));
var right_cur = ((eof)?null:portfolio.components.paredit.cursor.call(null,cm,(i + (1))));
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"bof","bof",-1065437469),new cljs.core.Keyword(null,"top","top",-1856271961),new cljs.core.Keyword(null,"cur","cur",1153190599),new cljs.core.Keyword(null,"right-char","right-char",-1500850071),new cljs.core.Keyword(null,"mode","mode",654403691),new cljs.core.Keyword(null,"start","start",-355208981),new cljs.core.Keyword(null,"left-char","left-char",509989355),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"ch","ch",-554717905),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"tok","tok",2091731382),new cljs.core.Keyword(null,"left-cur","left-cur",2010287159),new cljs.core.Keyword(null,"end","end",-268185958),new cljs.core.Keyword(null,"eof","eof",-489063237),new cljs.core.Keyword(null,"i","i",-1386841315),new cljs.core.Keyword(null,"right-cur","right-cur",1689901919)],[bof,(tok.state.indentStack == null),cur,((eof)?null:cm.getRange(cur,right_cur)),tok.state.mode,tok.start,((bof)?null:cm.getRange(left_cur,cur)),tok.type,tok.string,cur.ch,cur.line,tok,left_cur,tok.end,eof,i,right_cur]);
} else {
return null;
}
}));

(portfolio.components.paredit.get_info.cljs$lang$maxFixedArity = 2);

/**
 * true if the type is comment or string. a lot of editing behavior (like
 *   movement and deletion) is similar when you are in a string or in a comment, so
 *   often this is the predicate for that behavior.
 */
portfolio.components.paredit.comment_or_string_QMARK_ = (function portfolio$components$paredit$comment_or_string_QMARK_(type){
return ((cljs.core._EQ_.call(null,type,"comment")) || (cljs.core._EQ_.call(null,type,"string")));
});
/**
 * indent the current line
 */
portfolio.components.paredit.indent_line = (function portfolio$components$paredit$indent_line(cm){
return cm.indentLine(portfolio.components.paredit.cursor.call(null,cm).line);
});
/**
 * returns true if backslash is to the left and cursor is on an escaped char
 */
portfolio.components.paredit.in_escaped_char_QMARK_ = (function portfolio$components$paredit$in_escaped_char_QMARK_(var_args){
var G__28694 = arguments.length;
switch (G__28694) {
case 2:
return portfolio.components.paredit.in_escaped_char_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return portfolio.components.paredit.in_escaped_char_QMARK_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.in_escaped_char_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
return portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur,(0));
}));

(portfolio.components.paredit.in_escaped_char_QMARK_.cljs$core$IFn$_invoke$arity$3 = (function (cm,cur,offset){
var map__28695 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28695__$1 = cljs.core.__destructure_map.call(null,map__28695);
var ch = cljs.core.get.call(null,map__28695__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var start = cljs.core.get.call(null,map__28695__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__28695__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var type = cljs.core.get.call(null,map__28695__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return ((cljs.core._EQ_.call(null,start,((ch - (1)) + offset))) && (((cljs.core._EQ_.call(null,end,((ch + (1)) + offset))) && (cljs.core._EQ_.call(null,type,"string-2")))));
}));

(portfolio.components.paredit.in_escaped_char_QMARK_.cljs$lang$maxFixedArity = 3);

/**
 * returns true if an escaped char and its backslash are to the left
 */
portfolio.components.paredit.escaped_char_to_left_QMARK_ = (function portfolio$components$paredit$escaped_char_to_left_QMARK_(cm,cur){
return portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur,(-1));
});
/**
 * returns true if an escaped char and its backslash is to the right
 */
portfolio.components.paredit.escaped_char_to_right_QMARK_ = (function portfolio$components$paredit$escaped_char_to_right_QMARK_(cm,cur){
return portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur,(1));
});
/**
 * insert text at current cursor. move cursor to the end of inserted text minus
 *   optional offset. the offset is for moving the cursor immediately after the
 *   insert and before returning. example: inserting a pair of brackets and placing
 *   the cursor inside the pair. this returns the new cursor.
 */
portfolio.components.paredit.insert = (function portfolio$components$paredit$insert(var_args){
var G__28698 = arguments.length;
switch (G__28698) {
case 2:
return portfolio.components.paredit.insert.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return portfolio.components.paredit.insert.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return portfolio.components.paredit.insert.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.insert.cljs$core$IFn$_invoke$arity$2 = (function (cm,text){
return portfolio.components.paredit.insert.call(null,cm,text,(0));
}));

(portfolio.components.paredit.insert.cljs$core$IFn$_invoke$arity$3 = (function (cm,text,offset){
return portfolio.components.paredit.insert.call(null,cm,text,offset,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.insert.cljs$core$IFn$_invoke$arity$4 = (function (cm,text,offset,cur){
var map__28699 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28699__$1 = cljs.core.__destructure_map.call(null,map__28699);
var line = cljs.core.get.call(null,map__28699__$1,new cljs.core.Keyword(null,"line","line",212345235));
var ch = cljs.core.get.call(null,map__28699__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
cm.replaceRange(text,cur);

cm.setCursor(line,((ch + cljs.core.count.call(null,text)) + offset));

return portfolio.components.paredit.cursor.call(null,cm);
}));

(portfolio.components.paredit.insert.cljs$lang$maxFixedArity = 4);

/**
 * paredit-open-round exposed for keymap. unlike traditional emacs paredit, this
 *   supports brackets [] {} () but not double-quote
 */
portfolio.components.paredit.open_round = (function portfolio$components$paredit$open_round(var_args){
var G__28702 = arguments.length;
switch (G__28702) {
case 1:
return portfolio.components.paredit.open_round.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.open_round.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.open_round', portfolio.components.paredit.open_round);

(portfolio.components.paredit.open_round.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.open_round.call(null,cm,"(");
}));

(portfolio.components.paredit.open_round.cljs$core$IFn$_invoke$arity$2 = (function (cm,c){
var map__28703 = portfolio.components.paredit.get_info.call(null,cm);
var map__28703__$1 = cljs.core.__destructure_map.call(null,map__28703);
var type = cljs.core.get.call(null,map__28703__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var left_char = cljs.core.get.call(null,map__28703__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var right_char = cljs.core.get.call(null,map__28703__$1,new cljs.core.Keyword(null,"right-char","right-char",-1500850071));
if(cljs.core._EQ_.call(null,"\\",left_char)){
return portfolio.components.paredit.insert.call(null,cm,c);
} else {
if(portfolio.components.paredit.comment_or_string_QMARK_.call(null,type)){
return portfolio.components.paredit.insert.call(null,cm,c);
} else {
var need_left_padding = ((cljs.core.not_EQ_.call(null," ",left_char)) && ((!(portfolio.components.paredit.opener_QMARK_.call(null,left_char)))));
var need_right_padding = ((cljs.core.not_EQ_.call(null," ",right_char)) && ((!(portfolio.components.paredit.closer_QMARK_.call(null,right_char)))));
return portfolio.components.paredit.insert.call(null,cm,[((need_left_padding)?" ":null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(c),cljs.core.str.cljs$core$IFn$_invoke$arity$1(portfolio.components.paredit.pair.call(null,c)),((need_right_padding)?" ":null)].join(''),((need_right_padding)?(-2):(-1)));

}
}
}));

(portfolio.components.paredit.open_round.cljs$lang$maxFixedArity = 2);

/**
 * open curly brace with matching close brace
 */
portfolio.components.paredit.open_brace = (function portfolio$components$paredit$open_brace(cm){
return portfolio.components.paredit.open_round.call(null,cm,"{");
});
goog.exportSymbol('portfolio.components.paredit.open_brace', portfolio.components.paredit.open_brace);
/**
 * finds the *parent* closing bracket. behavior when used with skip: pushes
 *   opening brackets that appear along the way on a stack. closing brackets pop
 *   them off. stops when encountering a closing bracket while the stack is empty.
 *   assuming the cm has matched brackets for now. moves to the right.
 */
portfolio.components.paredit.parent_closer_sp = (function portfolio$components$paredit$parent_closer_sp(cm,cur,state){
var map__28705 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28705__$1 = cljs.core.__destructure_map.call(null,map__28705);
var string = cljs.core.get.call(null,map__28705__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var type = cljs.core.get.call(null,map__28705__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var top = cljs.core.get.call(null,map__28705__$1,new cljs.core.Keyword(null,"top","top",-1856271961));
var eof = cljs.core.get.call(null,map__28705__$1,new cljs.core.Keyword(null,"eof","eof",-489063237));
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return portfolio.components.paredit.opener_QMARK_.call(null,string);
} else {
return and__5043__auto__;
}
})())){
return (state + (1));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return ((portfolio.components.paredit.closer_QMARK_.call(null,string)) && ((state === (0))));
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.Keyword(null,"yes","yes",182838819);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = portfolio.components.paredit.closer_QMARK_.call(null,string);
if(and__5043__auto____$1){
var and__5043__auto____$2 = cljs.core.not_EQ_.call(null,(0),state);
if(and__5043__auto____$2){
return eof;
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.Keyword(null,"eof","eof",-489063237);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return ((portfolio.components.paredit.closer_QMARK_.call(null,string)) && (cljs.core.not_EQ_.call(null,(0),state)));
} else {
return and__5043__auto__;
}
})())){
return (state - (1));
} else {
return state;

}
}
}
}
});
/**
 * returns the cursor for the start of the current token
 */
portfolio.components.paredit.token_start = (function portfolio$components$paredit$token_start(cm,cur){
var map__28706 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28706__$1 = cljs.core.__destructure_map.call(null,map__28706);
var i = cljs.core.get.call(null,map__28706__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var start = cljs.core.get.call(null,map__28706__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var ch = cljs.core.get.call(null,map__28706__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
return portfolio.components.paredit.cursor.call(null,cm,(i - (ch - start)));
});
/**
 * returns the cursor for the end of the current token
 */
portfolio.components.paredit.token_end = (function portfolio$components$paredit$token_end(var_args){
var G__28708 = arguments.length;
switch (G__28708) {
case 2:
return portfolio.components.paredit.token_end.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return portfolio.components.paredit.token_end.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.token_end.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
return portfolio.components.paredit.token_end.call(null,cm,cur,(0));
}));

(portfolio.components.paredit.token_end.cljs$core$IFn$_invoke$arity$3 = (function (cm,cur,offset){
var map__28709 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28709__$1 = cljs.core.__destructure_map.call(null,map__28709);
var i = cljs.core.get.call(null,map__28709__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var end = cljs.core.get.call(null,map__28709__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var ch = cljs.core.get.call(null,map__28709__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
return portfolio.components.paredit.cursor.call(null,cm,((i + offset) + (end - ch)));
}));

(portfolio.components.paredit.token_end.cljs$lang$maxFixedArity = 3);

/**
 * take an index. get its token. return index of that token's end.
 */
portfolio.components.paredit.token_end_index = (function portfolio$components$paredit$token_end_index(cm,i){
return portfolio.components.paredit.index.call(null,cm,portfolio.components.paredit.token_end.call(null,cm,portfolio.components.paredit.cursor.call(null,cm,i)));
});
portfolio.components.paredit.guard = (function portfolio$components$paredit$guard(){
return cljs.core.println.call(null,"past");
});
/**
 * returns the cursor that satsifies skipping predicate 'sp' or nil if eof
 *   reached. does this by making sp something we can trampoline. sp takes these
 *   args: cm, cursor, state. counts down 'n' to 0 in order to guard against
 *   infinite loops.
 */
portfolio.components.paredit.skip_trampoline_helper = (function portfolio$components$paredit$skip_trampoline_helper(cm,cur,sp,state,n){
if((n >= (0))){
var map__28711 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28711__$1 = cljs.core.__destructure_map.call(null,map__28711);
var left_cur = cljs.core.get.call(null,map__28711__$1,new cljs.core.Keyword(null,"left-cur","left-cur",2010287159));
var i = cljs.core.get.call(null,map__28711__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var result = sp.call(null,cm,cur,state);
var G__28712 = result;
var G__28712__$1 = (((G__28712 instanceof cljs.core.Keyword))?G__28712.fqn:null);
switch (G__28712__$1) {
case "eof":
return null;

break;
case "stop":
return null;

break;
case "yes":
return cur;

break;
case "left":
return left_cur;

break;
case "end-of-this-token":
return portfolio.components.paredit.token_end.call(null,cm,cur);

break;
case "start-of-this-tok":
return portfolio.components.paredit.token_start.call(null,cm,cur);

break;
default:
var next_cur = portfolio.components.paredit.token_end.call(null,cm,cur,(1));
return (function (){
return portfolio.components.paredit.skip_trampoline_helper.call(null,cm,next_cur,sp,result,(n - (1)));
});

}
} else {
return portfolio.components.paredit.guard.call(null);
}
});
/**
 * like skip-trampoline-helper but in the opposite direction.
 */
portfolio.components.paredit.skip_trampoline_helper_left = (function portfolio$components$paredit$skip_trampoline_helper_left(cm,cur,sp,state,n){
if((n >= (0))){
var map__28714 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28714__$1 = cljs.core.__destructure_map.call(null,map__28714);
var left_cur = cljs.core.get.call(null,map__28714__$1,new cljs.core.Keyword(null,"left-cur","left-cur",2010287159));
var right_cur = cljs.core.get.call(null,map__28714__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
var i = cljs.core.get.call(null,map__28714__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var start = cljs.core.get.call(null,map__28714__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var ch = cljs.core.get.call(null,map__28714__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var result = sp.call(null,cm,cur,state);
var G__28715 = result;
var G__28715__$1 = (((G__28715 instanceof cljs.core.Keyword))?G__28715.fqn:null);
switch (G__28715__$1) {
case "bof":
return null;

break;
case "stop":
return null;

break;
case "yes":
return left_cur;

break;
case "right":
return right_cur;

break;
case "end-of-this-token":
return portfolio.components.paredit.token_end.call(null,cm,cur);

break;
case "start-of-this-tok":
return portfolio.components.paredit.token_start.call(null,cm,cur);

break;
default:
var next_cur = ((cljs.core._EQ_.call(null,ch,start))?portfolio.components.paredit.cursor.call(null,cm,(i - (1))):portfolio.components.paredit.cursor.call(null,cm,(i - (ch - start))));
return (function (){
return portfolio.components.paredit.skip_trampoline_helper_left.call(null,cm,next_cur,sp,result,(n - (1)));
});

}
} else {
return portfolio.components.paredit.guard.call(null);
}
});
/**
 * returns the cursor that satisfies sp or nil if either eof reached
 *   or we found out sp could not be satisfied. see skip-to for more
 *   info.
 */
portfolio.components.paredit.skip = (function portfolio$components$paredit$skip(var_args){
var G__28718 = arguments.length;
switch (G__28718) {
case 2:
return portfolio.components.paredit.skip.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return portfolio.components.paredit.skip.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.skip.cljs$core$IFn$_invoke$arity$2 = (function (cm,sp){
return portfolio.components.paredit.skip.call(null,cm,sp,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.skip.cljs$core$IFn$_invoke$arity$3 = (function (cm,sp,cur){
var temp__5804__auto__ = new cljs.core.Keyword(null,"right-cur","right-cur",1689901919).cljs$core$IFn$_invoke$arity$1(portfolio.components.paredit.get_info.call(null,cm,cur));
if(cljs.core.truth_(temp__5804__auto__)){
var right_cur = temp__5804__auto__;
return cljs.core.trampoline.call(null,portfolio.components.paredit.skip_trampoline_helper,cm,right_cur,sp,(0),portfolio.components.paredit.char_count.call(null,cm));
} else {
return null;
}
}));

(portfolio.components.paredit.skip.cljs$lang$maxFixedArity = 3);

/**
 * returns the cursor that satisfies sp or nil if either bof reached
 *   or we found out sp could not be satisfied. see skip-to for more
 *   info.
 */
portfolio.components.paredit.skip_left = (function portfolio$components$paredit$skip_left(cm,sp){
var temp__5804__auto__ = portfolio.components.paredit.cursor.call(null,cm);
if(cljs.core.truth_(temp__5804__auto__)){
var cur = temp__5804__auto__;
return cljs.core.trampoline.call(null,portfolio.components.paredit.skip_trampoline_helper_left,cm,cur,sp,(0),portfolio.components.paredit.char_count.call(null,cm));
} else {
return null;
}
});
/**
 * if cur is in whitespace, deletes it optionally without ruining indentation.
 */
portfolio.components.paredit.delete_whitespace = (function portfolio$components$paredit$delete_whitespace(var_args){
var G__28721 = arguments.length;
switch (G__28721) {
case 1:
return portfolio.components.paredit.delete_whitespace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.delete_whitespace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return portfolio.components.paredit.delete_whitespace.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.delete_whitespace.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.delete_whitespace.call(null,cm,portfolio.components.paredit.cursor.call(null,cm),true);
}));

(portfolio.components.paredit.delete_whitespace.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
return portfolio.components.paredit.delete_whitespace.call(null,cm,cur,true);
}));

(portfolio.components.paredit.delete_whitespace.cljs$core$IFn$_invoke$arity$3 = (function (cm,cur,indent_after){
var map__28722 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28722__$1 = cljs.core.__destructure_map.call(null,map__28722);
var start = cljs.core.get.call(null,map__28722__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__28722__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var line = cljs.core.get.call(null,map__28722__$1,new cljs.core.Keyword(null,"line","line",212345235));
var ch = cljs.core.get.call(null,map__28722__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var i = cljs.core.get.call(null,map__28722__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var type = cljs.core.get.call(null,map__28722__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var c1 = portfolio.components.paredit.cursor.call(null,cm,(i + (start - ch)));
var c2 = portfolio.components.paredit.cursor.call(null,cm,(i + (end - ch)));
if((type == null)){
cm.replaceRange("",c1,c2);

if(cljs.core.truth_(indent_after)){
return cm.indentLine(line);
} else {
return null;
}
} else {
return null;
}
}));

(portfolio.components.paredit.delete_whitespace.cljs$lang$maxFixedArity = 3);

portfolio.components.paredit.just_one_space = (function portfolio$components$paredit$just_one_space(var_args){
var G__28725 = arguments.length;
switch (G__28725) {
case 1:
return portfolio.components.paredit.just_one_space.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.just_one_space.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return portfolio.components.paredit.just_one_space.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.just_one_space.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.just_one_space.call(null,cm,portfolio.components.paredit.cursor.call(null,cm),true);
}));

(portfolio.components.paredit.just_one_space.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
return portfolio.components.paredit.just_one_space.call(null,cm,cur,true);
}));

(portfolio.components.paredit.just_one_space.cljs$core$IFn$_invoke$arity$3 = (function (cm,cur,indent_after){
var map__28726 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28726__$1 = cljs.core.__destructure_map.call(null,map__28726);
var start = cljs.core.get.call(null,map__28726__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__28726__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var line = cljs.core.get.call(null,map__28726__$1,new cljs.core.Keyword(null,"line","line",212345235));
var ch = cljs.core.get.call(null,map__28726__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var i = cljs.core.get.call(null,map__28726__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var type = cljs.core.get.call(null,map__28726__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var c1 = portfolio.components.paredit.cursor.call(null,cm,(i + (start - ch)));
var c2 = portfolio.components.paredit.cursor.call(null,cm,(i + (end - ch)));
if((type == null)){
cm.replaceRange(" ",c1,c2);

if(cljs.core.truth_(indent_after)){
return cm.indentLine(line);
} else {
return null;
}
} else {
return null;
}
}));

(portfolio.components.paredit.just_one_space.cljs$lang$maxFixedArity = 3);

/**
 * moves to the cursor that satisfies sp or doesn't move if eof reached.
 *   starts at current cursor for cm. sp stands for 'skipping predicate'
 *   which returns:
 *   - :yes if sp is satisfied.
 *   - :stop if we know we will not be satisfied with any future result.
 *   - :left if the cursor to the left is what we want.
 *   - new non-nil state if not satisfied. this state is used with the
 *   next iteration after we skip to the end of the current token. an sp
 *   takes cm, cursor, state.
 */
portfolio.components.paredit.skip_to = (function portfolio$components$paredit$skip_to(cm,sp){
var temp__5804__auto__ = portfolio.components.paredit.skip.call(null,cm,sp);
if(cljs.core.truth_(temp__5804__auto__)){
var cur_SINGLEQUOTE_ = temp__5804__auto__;
cm.setCursor(cur_SINGLEQUOTE_);

return cur_SINGLEQUOTE_;
} else {
return null;
}
});
/**
 * moves cursor to just outside the closing bracket, or if there is
 *   none then doesn't move at all.
 */
portfolio.components.paredit.move_past_parent_closer = (function portfolio$components$paredit$move_past_parent_closer(cm){
var temp__5804__auto__ = portfolio.components.paredit.skip_to.call(null,cm,portfolio.components.paredit.parent_closer_sp);
if(cljs.core.truth_(temp__5804__auto__)){
var cur = temp__5804__auto__;
portfolio.components.paredit.delete_whitespace.call(null,cm,new cljs.core.Keyword(null,"left-cur","left-cur",2010287159).cljs$core$IFn$_invoke$arity$1(portfolio.components.paredit.get_info.call(null,cm)));

return cur;
} else {
return null;
}
});
/**
 * paredit-close-round exposed for keymap. skips to end of current
 *   list even if it ends with ] or }. but if you're in a string or
 *   comment then this just inserts the bracket. requires CodeMirror
 *   mode's parser uses state with indentStack because that's how we
 *   can tell we've reached the end of a top level form and avoid
 *   entering the next top level form. 's' is the character as a string.
 */
portfolio.components.paredit.close_round = (function portfolio$components$paredit$close_round(var_args){
var G__28729 = arguments.length;
switch (G__28729) {
case 1:
return portfolio.components.paredit.close_round.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.close_round.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.close_round', portfolio.components.paredit.close_round);

(portfolio.components.paredit.close_round.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.close_round.call(null,cm,")");
}));

(portfolio.components.paredit.close_round.cljs$core$IFn$_invoke$arity$2 = (function (cm,s){
var map__28730 = portfolio.components.paredit.get_info.call(null,cm);
var map__28730__$1 = cljs.core.__destructure_map.call(null,map__28730);
var type = cljs.core.get.call(null,map__28730__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var left_char = cljs.core.get.call(null,map__28730__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
if(cljs.core._EQ_.call(null,"\\",left_char)){
return portfolio.components.paredit.insert.call(null,cm,s);
} else {
if(portfolio.components.paredit.comment_or_string_QMARK_.call(null,type)){
return portfolio.components.paredit.insert.call(null,cm,s);
} else {
return portfolio.components.paredit.move_past_parent_closer.call(null,cm);

}
}
}));

(portfolio.components.paredit.close_round.cljs$lang$maxFixedArity = 2);

/**
 * close curly brace like close-rond
 */
portfolio.components.paredit.close_brace = (function portfolio$components$paredit$close_brace(cm){
return portfolio.components.paredit.close_round.call(null,cm,"}");
});
goog.exportSymbol('portfolio.components.paredit.close_brace', portfolio.components.paredit.close_brace);
portfolio.components.paredit.close_round_and_newline = (function portfolio$components$paredit$close_round_and_newline(var_args){
var G__28733 = arguments.length;
switch (G__28733) {
case 1:
return portfolio.components.paredit.close_round_and_newline.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.close_round_and_newline.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.close_round_and_newline', portfolio.components.paredit.close_round_and_newline);

(portfolio.components.paredit.close_round_and_newline.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.close_round_and_newline.call(null,cm,")");
}));

(portfolio.components.paredit.close_round_and_newline.cljs$core$IFn$_invoke$arity$2 = (function (cm,s){
if(portfolio.components.paredit.comment_or_string_QMARK_.call(null,portfolio.components.paredit.get_type.call(null,cm))){
return portfolio.components.paredit.insert.call(null,cm,s);
} else {
if(cljs.core.truth_(portfolio.components.paredit.close_round.call(null,cm,s))){
return cm.execCommand("newlineAndIndent");
} else {
return null;
}
}
}));

(portfolio.components.paredit.close_round_and_newline.cljs$lang$maxFixedArity = 2);

portfolio.components.paredit.open_square = (function portfolio$components$paredit$open_square(cm){
return portfolio.components.paredit.open_round.call(null,cm,"[");
});
goog.exportSymbol('portfolio.components.paredit.open_square', portfolio.components.paredit.open_square);
portfolio.components.paredit.close_square = (function portfolio$components$paredit$close_square(cm){
return portfolio.components.paredit.close_round.call(null,cm,"]");
});
goog.exportSymbol('portfolio.components.paredit.close_square', portfolio.components.paredit.close_square);
portfolio.components.paredit.open_quote = (function portfolio$components$paredit$open_quote(cm){
return portfolio.components.paredit.open_round.call(null,cm,"\"");
});
goog.exportSymbol('portfolio.components.paredit.open_quote', portfolio.components.paredit.open_quote);
portfolio.components.paredit.close_quote = (function portfolio$components$paredit$close_quote(cm){
return portfolio.components.paredit.close_round.call(null,cm,"\"");
});
goog.exportSymbol('portfolio.components.paredit.close_quote', portfolio.components.paredit.close_quote);
portfolio.components.paredit.doublequote = (function portfolio$components$paredit$doublequote(cm){
var map__28735 = portfolio.components.paredit.get_info.call(null,cm);
var map__28735__$1 = cljs.core.__destructure_map.call(null,map__28735);
var type = cljs.core.get.call(null,map__28735__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var left_char = cljs.core.get.call(null,map__28735__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var right_char = cljs.core.get.call(null,map__28735__$1,new cljs.core.Keyword(null,"right-char","right-char",-1500850071));
var ch = cljs.core.get.call(null,map__28735__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var cur = cljs.core.get.call(null,map__28735__$1,new cljs.core.Keyword(null,"cur","cur",1153190599));
if(cljs.core._EQ_.call(null,"\\",left_char)){
return portfolio.components.paredit.insert.call(null,cm,"\"");
} else {
if(cljs.core._EQ_.call(null,type,"string")){
return portfolio.components.paredit.insert.call(null,cm,"\\\"");
} else {
return portfolio.components.paredit.insert.call(null,cm,[((cljs.core.not_EQ_.call(null," ",left_char))?" ":null),"\"\"",((((cljs.core.not_EQ_.call(null," ",right_char)) && (cljs.core.not_EQ_.call(null,"\n",right_char))))?" ":null)].join(''),((((cljs.core._EQ_.call(null," ",right_char)) || (cljs.core._EQ_.call(null,"\n",right_char))))?(-1):(-2)));

}
}
});
goog.exportSymbol('portfolio.components.paredit.doublequote', portfolio.components.paredit.doublequote);
portfolio.components.paredit.word_QMARK_ = (function portfolio$components$paredit$word_QMARK_(type){
return ((cljs.core._EQ_.call(null,type,"atom")) || (((cljs.core._EQ_.call(null,type,"builtin")) || (((cljs.core._EQ_.call(null,type,"number")) || (((cljs.core._EQ_.call(null,type,"variable")) || (cljs.core._EQ_.call(null,type,"keyword")))))))));
});
/**
 * returns true if at a word of code
 */
portfolio.components.paredit.at_a_word_QMARK_ = (function portfolio$components$paredit$at_a_word_QMARK_(cm,cur){
return portfolio.components.paredit.word_QMARK_.call(null,portfolio.components.paredit.get_type.call(null,cm,cur));
});
/**
 * true if in a word AND not at the end of that word. false if in whitespace or
 *   a string or a comment or at a bracket.
 */
portfolio.components.paredit.in_a_word_QMARK_ = (function portfolio$components$paredit$in_a_word_QMARK_(cm){
var cur = portfolio.components.paredit.cursor.call(null,cm);
var i = portfolio.components.paredit.index.call(null,cm,cur);
return ((portfolio.components.paredit.at_a_word_QMARK_.call(null,cm,cur)) && (cljs.core.not_EQ_.call(null,i,portfolio.components.paredit.token_end_index.call(null,cm,i))));
});
/**
 * returns true if at the start of a string.
 */
portfolio.components.paredit.start_of_a_string_QMARK_ = (function portfolio$components$paredit$start_of_a_string_QMARK_(cm,cur){
var map__28736 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28736__$1 = cljs.core.__destructure_map.call(null,map__28736);
var string = cljs.core.get.call(null,map__28736__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var type = cljs.core.get.call(null,map__28736__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var start = cljs.core.get.call(null,map__28736__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__28736__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var mode = cljs.core.get.call(null,map__28736__$1,new cljs.core.Keyword(null,"mode","mode",654403691));
return ((cljs.core._EQ_.call(null,type,"string")) && (((cljs.core._EQ_.call(null,(1),(end - start))) && (((cljs.core._EQ_.call(null,string,"\"")) && (cljs.core._EQ_.call(null,mode,"string")))))));
});
/**
 * returns true if just to the right of a closing doublequote of a string.
 */
portfolio.components.paredit.end_of_a_string_QMARK_ = (function portfolio$components$paredit$end_of_a_string_QMARK_(cm,cur){
var map__28737 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28737__$1 = cljs.core.__destructure_map.call(null,map__28737);
var type = cljs.core.get.call(null,map__28737__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var ch = cljs.core.get.call(null,map__28737__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var end = cljs.core.get.call(null,map__28737__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var string = cljs.core.get.call(null,map__28737__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var mode = cljs.core.get.call(null,map__28737__$1,new cljs.core.Keyword(null,"mode","mode",654403691));
return ((cljs.core._EQ_.call(null,type,"string")) && (((cljs.core._EQ_.call(null,ch,end)) && (((cljs.core._EQ_.call(null,"\"",cljs.core.last.call(null,string))) && (((cljs.core.not_EQ_.call(null,"\\",cljs.core.last.call(null,cljs.core.drop_last.call(null,string)))) && (cljs.core._EQ_.call(null,mode,false)))))))));
});
/**
 * returns the cursor at the end of the sibling to the right or nil if
 *   no sibling or eof. does not exit the containing form. does this by
 *   skipping past any comments or whitespace, and branches depending on
 *   whether an opening bracket or doublequote is encountered (sp
 *   satisfied when encountering a closing bracket that empties the
 *   stack) vs the beginning of a word (return token at the end of the
 *   word). assuming the cm has matched brackets for now.
 */
portfolio.components.paredit.end_of_next_sibling_sp = (function portfolio$components$paredit$end_of_next_sibling_sp(cm,cur,stack){
var map__28738 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28738__$1 = cljs.core.__destructure_map.call(null,map__28738);
var string = cljs.core.get.call(null,map__28738__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var type = cljs.core.get.call(null,map__28738__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var eof = cljs.core.get.call(null,map__28738__$1,new cljs.core.Keyword(null,"eof","eof",-489063237));
var ch = cljs.core.get.call(null,map__28738__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var end = cljs.core.get.call(null,map__28738__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var stack_empty = (stack === (0));
var one_left = cljs.core._EQ_.call(null,(1),stack);
var string_extends = ((cljs.core.not_EQ_.call(null,"\"",cljs.core.last.call(null,string))) || (cljs.core._EQ_.call(null,"\\",cljs.core.last.call(null,cljs.core.drop_last.call(null,string)))));
if(((portfolio.components.paredit.end_of_a_string_QMARK_.call(null,cm,cur)) && (one_left))){
return new cljs.core.Keyword(null,"yes","yes",182838819);
} else {
if(((portfolio.components.paredit.escaped_char_to_left_QMARK_.call(null,cm,cur)) && (stack_empty))){
return new cljs.core.Keyword(null,"yes","yes",182838819);
} else {
if(((portfolio.components.paredit.word_QMARK_.call(null,type)) && (((stack_empty) && (cljs.core._EQ_.call(null,ch,end)))))){
return new cljs.core.Keyword(null,"yes","yes",182838819);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return ((portfolio.components.paredit.closer_QMARK_.call(null,string)) && (one_left));
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.Keyword(null,"yes","yes",182838819);
} else {
if(cljs.core.truth_(eof)){
return new cljs.core.Keyword(null,"eof","eof",-489063237);
} else {
if((type == null)){
return stack;
} else {
if(cljs.core._EQ_.call(null,type,"comment")){
return stack;
} else {
if(portfolio.components.paredit.start_of_a_string_QMARK_.call(null,cm,cur)){
return (stack + (1));
} else {
if(((portfolio.components.paredit.end_of_a_string_QMARK_.call(null,cm,cur)) && (stack_empty))){
return new cljs.core.Keyword(null,"stop","stop",-2140911342);
} else {
if(((cljs.core._EQ_.call(null,type,"string")) && (((one_left) && (string_extends))))){
return stack;
} else {
if(((cljs.core._EQ_.call(null,type,"string")) && (one_left))){
return new cljs.core.Keyword(null,"end-of-this-token","end-of-this-token",350019828);
} else {
if(((cljs.core._EQ_.call(null,type,"string")) && (string_extends))){
return stack;
} else {
if(cljs.core._EQ_.call(null,type,"string")){
return (stack - (1));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur);
if(cljs.core.truth_(and__5043__auto__)){
return stack_empty;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.Keyword(null,"end-of-this-token","end-of-this-token",350019828);
} else {
if(cljs.core.truth_(portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur))){
return stack;
} else {
if(portfolio.components.paredit.escaped_char_to_left_QMARK_.call(null,cm,cur)){
return stack;
} else {
if(((portfolio.components.paredit.word_QMARK_.call(null,type)) && (stack_empty))){
return new cljs.core.Keyword(null,"end-of-this-token","end-of-this-token",350019828);
} else {
if(portfolio.components.paredit.word_QMARK_.call(null,type)){
return stack;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return portfolio.components.paredit.opener_QMARK_.call(null,string);
} else {
return and__5043__auto__;
}
})())){
return (stack + (1));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return ((portfolio.components.paredit.closer_QMARK_.call(null,string)) && (stack_empty));
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.Keyword(null,"stop","stop",-2140911342);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return portfolio.components.paredit.closer_QMARK_.call(null,string);
} else {
return and__5043__auto__;
}
})())){
return (stack - (1));
} else {
return new cljs.core.Keyword(null,"stop","stop",-2140911342);

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
/**
 * get the cursor for the end of the sibling to the right.
 */
portfolio.components.paredit.end_of_next_sibling = (function portfolio$components$paredit$end_of_next_sibling(var_args){
var G__28740 = arguments.length;
switch (G__28740) {
case 1:
return portfolio.components.paredit.end_of_next_sibling.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.end_of_next_sibling.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.end_of_next_sibling.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.end_of_next_sibling_sp);
}));

(portfolio.components.paredit.end_of_next_sibling.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(cljs.core.truth_(cur)){
cm.setCursor(cur);

return portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.end_of_next_sibling_sp);
} else {
return null;
}
}));

(portfolio.components.paredit.end_of_next_sibling.cljs$lang$maxFixedArity = 2);

/**
 * returns the cursor at the start of the sibling to the left or nil
 *   if no sibling or eof. does not exit the containing form. does this
 *   by skipping past any comments or whitespace, and branches depending
 *   on whether a bracket or doublequote is encountered (sp satisfied
 *   when encountering an opening bracket that empties the stack) vs the
 *   beginning of a word (return token at the start of the
 *   word). assuming the cm has matched brackets for now.
 */
portfolio.components.paredit.start_of_prev_sibling_sp = (function portfolio$components$paredit$start_of_prev_sibling_sp(cm,cur,stack){
var map__28742 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28742__$1 = cljs.core.__destructure_map.call(null,map__28742);
var string = cljs.core.get.call(null,map__28742__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var type = cljs.core.get.call(null,map__28742__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var bof = cljs.core.get.call(null,map__28742__$1,new cljs.core.Keyword(null,"bof","bof",-1065437469));
var ch = cljs.core.get.call(null,map__28742__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var start = cljs.core.get.call(null,map__28742__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var stack_empty = (stack === (0));
var one_left = cljs.core._EQ_.call(null,(1),stack);
var string_extends = cljs.core.not_EQ_.call(null,"\"",cljs.core.first.call(null,string));
if(((portfolio.components.paredit.start_of_a_string_QMARK_.call(null,cm,cur)) && (((one_left) && (string_extends))))){
return stack;
} else {
if(((portfolio.components.paredit.start_of_a_string_QMARK_.call(null,cm,cur)) && (one_left))){
return new cljs.core.Keyword(null,"yes","yes",182838819);
} else {
if(((portfolio.components.paredit.escaped_char_to_right_QMARK_.call(null,cm,cur)) && (stack_empty))){
return new cljs.core.Keyword(null,"yes","yes",182838819);
} else {
if(((portfolio.components.paredit.word_QMARK_.call(null,type)) && (((stack_empty) && (cljs.core._EQ_.call(null,ch,start)))))){
return new cljs.core.Keyword(null,"yes","yes",182838819);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return ((portfolio.components.paredit.opener_QMARK_.call(null,string)) && (one_left));
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.Keyword(null,"yes","yes",182838819);
} else {
if(cljs.core.truth_(bof)){
return new cljs.core.Keyword(null,"bof","bof",-1065437469);
} else {
if((type == null)){
return stack;
} else {
if(cljs.core._EQ_.call(null,type,"comment")){
return stack;
} else {
if(portfolio.components.paredit.end_of_a_string_QMARK_.call(null,cm,cur)){
return (stack + (1));
} else {
if(((portfolio.components.paredit.start_of_a_string_QMARK_.call(null,cm,cur)) && (((stack_empty) && (string_extends))))){
return stack;
} else {
if(((portfolio.components.paredit.start_of_a_string_QMARK_.call(null,cm,cur)) && (stack_empty))){
return new cljs.core.Keyword(null,"stop","stop",-2140911342);
} else {
if(((cljs.core._EQ_.call(null,type,"string")) && (((one_left) && (string_extends))))){
return stack;
} else {
if(((cljs.core._EQ_.call(null,type,"string")) && (one_left))){
return new cljs.core.Keyword(null,"start-of-this-tok","start-of-this-tok",1383678987);
} else {
if(((cljs.core._EQ_.call(null,type,"string")) && (string_extends))){
return stack;
} else {
if(cljs.core._EQ_.call(null,type,"string")){
return (stack - (1));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur);
if(cljs.core.truth_(and__5043__auto__)){
return stack_empty;
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.Keyword(null,"start-of-this-tok","start-of-this-tok",1383678987);
} else {
if(cljs.core.truth_(portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur))){
return stack;
} else {
if(portfolio.components.paredit.escaped_char_to_right_QMARK_.call(null,cm,cur)){
return stack;
} else {
if(((portfolio.components.paredit.word_QMARK_.call(null,type)) && (stack_empty))){
return new cljs.core.Keyword(null,"start-of-this-tok","start-of-this-tok",1383678987);
} else {
if(portfolio.components.paredit.word_QMARK_.call(null,type)){
return stack;
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return portfolio.components.paredit.closer_QMARK_.call(null,string);
} else {
return and__5043__auto__;
}
})())){
return (stack + (1));
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return ((portfolio.components.paredit.opener_QMARK_.call(null,string)) && (stack_empty));
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.Keyword(null,"stop","stop",-2140911342);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return portfolio.components.paredit.opener_QMARK_.call(null,string);
} else {
return and__5043__auto__;
}
})())){
return (stack - (1));
} else {
return new cljs.core.Keyword(null,"stop","stop",-2140911342);

}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
/**
 * return the cursor at the start of the sibling to the left.
 */
portfolio.components.paredit.start_of_prev_sibling = (function portfolio$components$paredit$start_of_prev_sibling(var_args){
var G__28744 = arguments.length;
switch (G__28744) {
case 1:
return portfolio.components.paredit.start_of_prev_sibling.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.start_of_prev_sibling.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.start_of_prev_sibling.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.skip_left.call(null,cm,portfolio.components.paredit.start_of_prev_sibling_sp);
}));

(portfolio.components.paredit.start_of_prev_sibling.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(cljs.core.truth_(cur)){
cm.setCursor(cur);

return portfolio.components.paredit.skip_left.call(null,cm,portfolio.components.paredit.start_of_prev_sibling_sp);
} else {
return null;
}
}));

(portfolio.components.paredit.start_of_prev_sibling.cljs$lang$maxFixedArity = 2);

/**
 * escapes a string, replacing backslashes and doublequotes. wraps
 *   result in a new pair of doublequotes.
 */
portfolio.components.paredit.escape_string = (function portfolio$components$paredit$escape_string(s){
return ["\"",clojure.string.replace.call(null,clojure.string.replace.call(null,s,/[\\]/,"\\\\"),/[\"]/,"\\\""),"\""].join('');
});
/**
 * turns selection into a string, escaping backslashes and doublequotes
 */
portfolio.components.paredit.stringify_selection = (function portfolio$components$paredit$stringify_selection(cm){
return cm.replaceSelection(portfolio.components.paredit.escape_string.call(null,cm.getSelection()));
});
/**
 * turns the region from cur-1 to cur-2 into a string, escaping
 *   backslashes and doublequotes
 */
portfolio.components.paredit.stringify = (function portfolio$components$paredit$stringify(cm,cur_1,cur_2){
cm.setSelection(cur_1,cur_2);

portfolio.components.paredit.stringify_selection.call(null,cm);

return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,cur_1) + (1))));
});
/**
 * moves cursor right, out of the current string
 */
portfolio.components.paredit.exit_string = (function portfolio$components$paredit$exit_string(cm){
var map__28746 = portfolio.components.paredit.get_info.call(null,cm);
var map__28746__$1 = cljs.core.__destructure_map.call(null,map__28746);
var type = cljs.core.get.call(null,map__28746__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var i = cljs.core.get.call(null,map__28746__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var ch = cljs.core.get.call(null,map__28746__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var end = cljs.core.get.call(null,map__28746__$1,new cljs.core.Keyword(null,"end","end",-268185958));
if(cljs.core._EQ_.call(null,type,"string")){
return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,(i + (end - ch))));
} else {
return null;
}
});
/**
 * returns true if token is in the middle of a string.
 */
portfolio.components.paredit.in_string_QMARK_ = (function portfolio$components$paredit$in_string_QMARK_(var_args){
var G__28748 = arguments.length;
switch (G__28748) {
case 1:
return portfolio.components.paredit.in_string_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.in_string_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.in_string_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.in_string_QMARK_.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.in_string_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var type = portfolio.components.paredit.get_type.call(null,cm,cur);
return ((cljs.core._EQ_.call(null,type,"string")) || (cljs.core._EQ_.call(null,type,"string-2")));
}));

(portfolio.components.paredit.in_string_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * paredit meta-doublequote exposed for keymap.
 *   if in a string, moves cursor out of the string to the right.
 *   if in a comment, insert a doublequote.
 *   if in an escaped char, do nothing.
 *   otherwise starts a string that that continues to the end of the next
 *   form, escaping backslashes and doublequotes.
 */
portfolio.components.paredit.meta_doublequote = (function portfolio$components$paredit$meta_doublequote(cm){
var map__28750 = portfolio.components.paredit.get_info.call(null,cm);
var map__28750__$1 = cljs.core.__destructure_map.call(null,map__28750);
var type = cljs.core.get.call(null,map__28750__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var eof = cljs.core.get.call(null,map__28750__$1,new cljs.core.Keyword(null,"eof","eof",-489063237));
var cur = cljs.core.get.call(null,map__28750__$1,new cljs.core.Keyword(null,"cur","cur",1153190599));
if(cljs.core.truth_(eof)){
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);
} else {
if(cljs.core.truth_(portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur))){
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);
} else {
if(portfolio.components.paredit.in_string_QMARK_.call(null,cm,cur)){
return portfolio.components.paredit.exit_string.call(null,cm);
} else {
if(cljs.core._EQ_.call(null,type,"comment")){
return portfolio.components.paredit.insert.call(null,cm,"\"");
} else {
if(portfolio.components.paredit.in_a_word_QMARK_.call(null,cm)){
return portfolio.components.paredit.stringify.call(null,cm,cur,portfolio.components.paredit.token_end.call(null,cm,cur));
} else {
return portfolio.components.paredit.stringify.call(null,cm,cur,portfolio.components.paredit.end_of_next_sibling.call(null,cm));

}
}
}
}
}
});
goog.exportSymbol('portfolio.components.paredit.meta_doublequote', portfolio.components.paredit.meta_doublequote);
/**
 * given a pair of cursors c1 and c2, returns the left-most one
 */
portfolio.components.paredit.left = (function portfolio$components$paredit$left(cm,c1,c2){
var i1 = portfolio.components.paredit.index.call(null,cm,c1);
var i2 = portfolio.components.paredit.index.call(null,cm,c2);
if((i1 < i2)){
return c1;
} else {
return c2;
}
});
/**
 * given a pair of cursors c1 and c2, returns the right-most one
 */
portfolio.components.paredit.right = (function portfolio$components$paredit$right(cm,c1,c2){
var i1 = portfolio.components.paredit.index.call(null,cm,c1);
var i2 = portfolio.components.paredit.index.call(null,cm,c2);
if((i1 < i2)){
return c2;
} else {
return c1;
}
});
/**
 * like get-info but for the first selection. gets the cursor to the left of the
 *   selection, the start, the end, the text selected, the starting and ending line
 *   numbers. nil if nothing selected.
 */
portfolio.components.paredit.selection_info = (function portfolio$components$paredit$selection_info(cm){
if(cljs.core.truth_(cm.somethingSelected())){
var first_sel = cljs.core.first.call(null,cm.listSelections());
var text = cljs.core.first.call(null,cm.getSelections());
var anchor = first_sel.anchor;
var head = first_sel.head;
var left_of_start = portfolio.components.paredit.left.call(null,cm,anchor,head);
var start_cur = portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,left_of_start) + (1)));
var end_cur = portfolio.components.paredit.right.call(null,cm,anchor,head);
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [left_of_start,start_cur,end_cur,text,start_cur.line,end_cur.line], null);
} else {
return null;
}
});
/**
 * get the types from cursors c1 to c2. assumes 1 is to the left of 2 and not
 *   vice versa.
 */
portfolio.components.paredit.get_types = (function portfolio$components$paredit$get_types(cm,c1,c2){
var types = cljs.core.PersistentVector.EMPTY;
var cur = c1;
while(true){
var map__28752 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28752__$1 = cljs.core.__destructure_map.call(null,map__28752);
var type = cljs.core.get.call(null,map__28752__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var right_cur = cljs.core.get.call(null,map__28752__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
var types_SINGLEQUOTE_ = cljs.core.conj.call(null,types,type);
if(cljs.core._EQ_.call(null,cur,c2)){
return types_SINGLEQUOTE_;
} else {
var G__28753 = types_SINGLEQUOTE_;
var G__28754 = right_cur;
types = G__28753;
cur = G__28754;
continue;
}
break;
}
});
/**
 * true if every position's type satisfies pred, for the entire (first)
 *   selection
 */
portfolio.components.paredit.selection_completely_satisfies_pred_QMARK_ = (function portfolio$components$paredit$selection_completely_satisfies_pred_QMARK_(cm,pred){
var temp__5804__auto__ = portfolio.components.paredit.selection_info.call(null,cm);
if(cljs.core.truth_(temp__5804__auto__)){
var vec__28755 = temp__5804__auto__;
var _ = cljs.core.nth.call(null,vec__28755,(0),null);
var c1 = cljs.core.nth.call(null,vec__28755,(1),null);
var c2 = cljs.core.nth.call(null,vec__28755,(2),null);
return cljs.core.every_QMARK_.call(null,pred,portfolio.components.paredit.get_types.call(null,cm,c1,c2));
} else {
return null;
}
});
portfolio.components.paredit.selection_completely_whitespace_QMARK_ = (function portfolio$components$paredit$selection_completely_whitespace_QMARK_(cm){
return portfolio.components.paredit.selection_completely_satisfies_pred_QMARK_.call(null,cm,cljs.core.nil_QMARK_);
});
portfolio.components.paredit.not_code_QMARK_ = (function portfolio$components$paredit$not_code_QMARK_(type){
return (((type == null)) || (cljs.core._EQ_.call(null,type,"comment")));
});
portfolio.components.paredit.selection_completely_non_code_QMARK_ = (function portfolio$components$paredit$selection_completely_non_code_QMARK_(cm){
return portfolio.components.paredit.selection_completely_satisfies_pred_QMARK_.call(null,cm,portfolio.components.paredit.not_code_QMARK_);
});
/**
 * starts each line in 's' with ;; and appends 'post-script'
 */
portfolio.components.paredit.to_comment = (function portfolio$components$paredit$to_comment(s,postscript){
var cmnt = clojure.string.join.call(null,"\n",cljs.core.map.call(null,(function (p1__28758_SHARP_){
return clojure.string.replace.call(null,p1__28758_SHARP_,/^/,";; ");
}),clojure.string.split_lines.call(null,s)));
return [cmnt,"\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(postscript)].join('');
});
/**
 * removes leading whitespace and semicolons from lines in 's'
 */
portfolio.components.paredit.uncomment = (function portfolio$components$paredit$uncomment(s){
return clojure.string.join.call(null,"\n",cljs.core.map.call(null,(function (p1__28759_SHARP_){
return clojure.string.replace.call(null,p1__28759_SHARP_,/^\s*;+/,"");
}),clojure.string.split_lines.call(null,s)));
});
/**
 * indents lines from a to z (line numbers). assumes a is before z.
 */
portfolio.components.paredit.indent_lines = (function portfolio$components$paredit$indent_lines(cm,a,z){
var seq__28760 = cljs.core.seq.call(null,cljs.core.range.call(null,a,(z + (1))));
var chunk__28761 = null;
var count__28762 = (0);
var i__28763 = (0);
while(true){
if((i__28763 < count__28762)){
var line = cljs.core._nth.call(null,chunk__28761,i__28763);
cm.indentLine(line);


var G__28764 = seq__28760;
var G__28765 = chunk__28761;
var G__28766 = count__28762;
var G__28767 = (i__28763 + (1));
seq__28760 = G__28764;
chunk__28761 = G__28765;
count__28762 = G__28766;
i__28763 = G__28767;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__28760);
if(temp__5804__auto__){
var seq__28760__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28760__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__28760__$1);
var G__28768 = cljs.core.chunk_rest.call(null,seq__28760__$1);
var G__28769 = c__5568__auto__;
var G__28770 = cljs.core.count.call(null,c__5568__auto__);
var G__28771 = (0);
seq__28760 = G__28768;
chunk__28761 = G__28769;
count__28762 = G__28770;
i__28763 = G__28771;
continue;
} else {
var line = cljs.core.first.call(null,seq__28760__$1);
cm.indentLine(line);


var G__28772 = cljs.core.next.call(null,seq__28760__$1);
var G__28773 = null;
var G__28774 = (0);
var G__28775 = (0);
seq__28760 = G__28772;
chunk__28761 = G__28773;
count__28762 = G__28774;
i__28763 = G__28775;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * removes whitespace and leading semicolons from selection, replaces
 *   selection with the result, indents lines affected.
 */
portfolio.components.paredit.uncomment_selection = (function portfolio$components$paredit$uncomment_selection(cm){
var temp__5804__auto__ = portfolio.components.paredit.selection_info.call(null,cm);
if(cljs.core.truth_(temp__5804__auto__)){
var vec__28776 = temp__5804__auto__;
var _ = cljs.core.nth.call(null,vec__28776,(0),null);
var c1 = cljs.core.nth.call(null,vec__28776,(1),null);
var c2 = cljs.core.nth.call(null,vec__28776,(2),null);
var text = cljs.core.nth.call(null,vec__28776,(3),null);
cm.replaceSelection(portfolio.components.paredit.uncomment.call(null,text));

return portfolio.components.paredit.indent_lines.call(null,cm,c1.line,c2.line);
} else {
return null;
}
});
/**
 * returns the result of appending the applicable part of 'tok' to
 *   's'. this is for collecting all the text on a line after 'ch'
 */
portfolio.components.paredit.append = (function portfolio$components$paredit$append(ch,s,tok){
if((ch < tok.end)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),cljs.core.subs.call(null,tok.string,((function (){var x__5130__auto__ = ch;
var y__5131__auto__ = tok.start;
return ((x__5130__auto__ > y__5131__auto__) ? x__5130__auto__ : y__5131__auto__);
})() - tok.start))].join('');
} else {
return s;
}
});
portfolio.components.paredit.get_text_to_end_of_line = (function portfolio$components$paredit$get_text_to_end_of_line(cm,cur){
var toks = cm.getLineTokens(cur.line);
var ch = cur.ch;
return cljs.core.reduce.call(null,cljs.core.partial.call(null,portfolio.components.paredit.append,ch),"",toks);
});
portfolio.components.paredit.comment_selection = (function portfolio$components$paredit$comment_selection(cm){
var vec__28779 = portfolio.components.paredit.selection_info.call(null,cm);
var _ = cljs.core.nth.call(null,vec__28779,(0),null);
var c1 = cljs.core.nth.call(null,vec__28779,(1),null);
var c2 = cljs.core.nth.call(null,vec__28779,(2),null);
var text = cljs.core.nth.call(null,vec__28779,(3),null);
var l1 = cljs.core.nth.call(null,vec__28779,(4),null);
var l2 = cljs.core.nth.call(null,vec__28779,(5),null);
var text_after_selection = portfolio.components.paredit.get_text_to_end_of_line.call(null,cm,c2);
var code_follows_selection = cljs.core.not_EQ_.call(null,text_after_selection,"");
var end_of_line = portfolio.components.paredit.last_cur.call(null,cm);
var line_to = ((code_follows_selection)?(l2 + (1)):l2);
if(code_follows_selection){
cm.setSelection(portfolio.components.paredit.left,end_of_line);
} else {
}

cm.replaceSelection(portfolio.components.paredit.to_comment.call(null,text,text_after_selection));

return portfolio.components.paredit.indent_lines.call(null,cm,l1,line_to);
});
/**
 * true if the line ends with a comment
 */
portfolio.components.paredit.line_ends_with_comment_QMARK_ = (function portfolio$components$paredit$line_ends_with_comment_QMARK_(cm){
return cljs.core._EQ_.call(null,"comment",portfolio.components.paredit.last_token.call(null,cm,portfolio.components.paredit.cursor.call(null,cm)).type);
});
portfolio.components.paredit.indent_current_line = (function portfolio$components$paredit$indent_current_line(cm){
return cm.indentLine(portfolio.components.paredit.cursor.call(null,cm).line);
});
/**
 * moves cursor to ;;X
 */
portfolio.components.paredit.go_to_comment = (function portfolio$components$paredit$go_to_comment(cm){
var cur = portfolio.components.paredit.cursor.call(null,cm);
var ch = cur.ch;
var i = portfolio.components.paredit.index.call(null,cm,cur);
var c_tok = portfolio.components.paredit.last_token.call(null,cm,cur);
var start = c_tok.start;
var offset = cljs.core.count.call(null,cljs.core.take_while.call(null,(function (p1__28782_SHARP_){
return cljs.core._EQ_.call(null,";",p1__28782_SHARP_);
}),c_tok.string));
return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,((i + (start - ch)) + offset)));
});
/**
 * presses spacebar until we are at col 40
 */
portfolio.components.paredit.insert_spaces_to_col_40 = (function portfolio$components$paredit$insert_spaces_to_col_40(cm){
var ch = portfolio.components.paredit.cursor.call(null,cm).ch;
if((ch < (40))){
return portfolio.components.paredit.insert.call(null,cm,clojure.string.join.call(null,cljs.core.repeat.call(null,((40) - ch)," ")));
} else {
return null;
}
});
/**
 * moves cursor to the comment on the line and makes sure the comment
 *   starts on column 40 or greater. assumes last token is a comment
 */
portfolio.components.paredit.go_to_comment_and_indent = (function portfolio$components$paredit$go_to_comment_and_indent(cm){
portfolio.components.paredit.indent_current_line.call(null,cm);

var cur = portfolio.components.paredit.cursor.call(null,cm);
var ch = cur.ch;
var i = portfolio.components.paredit.index.call(null,cm,cur);
var comment_start = portfolio.components.paredit.last_token.call(null,cm,cur).start;
cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,(i + (comment_start - ch))));

portfolio.components.paredit.insert_spaces_to_col_40.call(null,cm);

return portfolio.components.paredit.go_to_comment.call(null,cm);
});
/**
 * true if code is to the left and whitespace* is to the right.
 *   assumes you already know line does not end with a comment.
 */
portfolio.components.paredit.betw_code_and_line_end_QMARK_ = (function portfolio$components$paredit$betw_code_and_line_end_QMARK_(cm){
var cur = portfolio.components.paredit.cursor.call(null,cm);
var toks = cm.getLineTokens(cur.line);
var ch = cur.ch;
var tests = cljs.core.map.call(null,(function (p1__28783_SHARP_){
return (((p1__28783_SHARP_.end <= ch)) || ((p1__28783_SHARP_.type == null)));
}),toks);
var and__5043__auto__ = cljs.core.seq.call(null,toks);
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,tests);
if(and__5043__auto____$1){
return cljs.core.some.call(null,(function (p1__28784_SHARP_){
return (!((p1__28784_SHARP_.type == null)));
}),toks);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
/**
 * moves cursor to end of last non-whitespace token on a line.
 *   returns a vector of new index, new ch, and new cursor.
 */
portfolio.components.paredit.move_to_end_of_line = (function portfolio$components$paredit$move_to_end_of_line(var_args){
var G__28787 = arguments.length;
switch (G__28787) {
case 1:
return portfolio.components.paredit.move_to_end_of_line.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.move_to_end_of_line.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.move_to_end_of_line.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.move_to_end_of_line.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.move_to_end_of_line.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var end = cljs.core.last.call(null,cljs.core.remove.call(null,(function (p1__28785_SHARP_){
return (p1__28785_SHARP_.type == null);
}),cm.getLineTokens(cur.line))).end;
var ch = cur.ch;
var i = portfolio.components.paredit.index.call(null,cm,cur);
var i_SINGLEQUOTE_ = (i + (end - ch));
var cur_SINGLEQUOTE_ = portfolio.components.paredit.cursor.call(null,cm,i_SINGLEQUOTE_);
cm.setCursor(cur_SINGLEQUOTE_);

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i_SINGLEQUOTE_,cur_SINGLEQUOTE_.ch,cur_SINGLEQUOTE_], null);
}));

(portfolio.components.paredit.move_to_end_of_line.cljs$lang$maxFixedArity = 2);

/**
 * selects from current position to the end of the line
 */
portfolio.components.paredit.select_rest_of_line = (function portfolio$components$paredit$select_rest_of_line(cm){
return cm.setSelection(portfolio.components.paredit.cursor.call(null,cm),portfolio.components.paredit.last_cur.call(null,cm));
});
/**
 * deletes from current position to the end of the line
 */
portfolio.components.paredit.delete_to_end_of_line = (function portfolio$components$paredit$delete_to_end_of_line(cm){
return cm.replaceRange("",portfolio.components.paredit.cursor.call(null,cm),portfolio.components.paredit.last_cur.call(null,cm));
});
/**
 * starts a ; comment at column 40 or greater and moves to it.
 */
portfolio.components.paredit.create_comment_at_end = (function portfolio$components$paredit$create_comment_at_end(cm){
portfolio.components.paredit.indent_current_line.call(null,cm);

portfolio.components.paredit.move_to_end_of_line.call(null,cm);

portfolio.components.paredit.insert.call(null,cm," ");

portfolio.components.paredit.insert_spaces_to_col_40.call(null,cm);

portfolio.components.paredit.insert.call(null,cm,"; ");

return portfolio.components.paredit.delete_to_end_of_line.call(null,cm);
});
/**
 * returns true if line is all whitespace
 */
portfolio.components.paredit.line_is_whitespace_QMARK_ = (function portfolio$components$paredit$line_is_whitespace_QMARK_(cm){
return cljs.core.every_QMARK_.call(null,(function (p1__28789_SHARP_){
return (p1__28789_SHARP_.type == null);
}),cm.getLineTokens(portfolio.components.paredit.cursor.call(null,cm).line));
});
/**
 * creates and indents a ;; comment
 */
portfolio.components.paredit.create_line_comment = (function portfolio$components$paredit$create_line_comment(cm){
portfolio.components.paredit.insert.call(null,cm,";; ");

portfolio.components.paredit.delete_to_end_of_line.call(null,cm);

return portfolio.components.paredit.indent_current_line.call(null,cm);
});
/**
 * creates and indents a ;; comment on a new line
 */
portfolio.components.paredit.new_line_and_comment = (function portfolio$components$paredit$new_line_and_comment(cm){
portfolio.components.paredit.indent_current_line.call(null,cm);

portfolio.components.paredit.insert.call(null,cm,"\n\n");

cm.execCommand("goLineDown");

cm.execCommand("goLineDown");

portfolio.components.paredit.indent_current_line.call(null,cm);

cm.execCommand("goLineUp");

return portfolio.components.paredit.create_line_comment.call(null,cm);
});
/**
 * creates and indents a ;; comment on this line
 */
portfolio.components.paredit.insert_line_comment_here = (function portfolio$components$paredit$insert_line_comment_here(cm){
portfolio.components.paredit.insert.call(null,cm,"\n");

cm.execCommand("goLineDown");

portfolio.components.paredit.indent_current_line.call(null,cm);

cm.execCommand("goLineUp");

return portfolio.components.paredit.create_line_comment.call(null,cm);
});
/**
 * returns true if token is in the middle of code. assumes you've already ruled
 *   out comments.
 */
portfolio.components.paredit.in_code_QMARK_ = (function portfolio$components$paredit$in_code_QMARK_(cm){
var map__28790 = portfolio.components.paredit.get_info.call(null,cm);
var map__28790__$1 = cljs.core.__destructure_map.call(null,map__28790);
var type = cljs.core.get.call(null,map__28790__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var start = cljs.core.get.call(null,map__28790__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__28790__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var ch = cljs.core.get.call(null,map__28790__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
return (((start < ch)) && ((((ch < end)) && ((!((type == null)))))));
});
/**
 * returns true if token is to the right of whitespace
 */
portfolio.components.paredit.in_whitespace_QMARK_ = (function portfolio$components$paredit$in_whitespace_QMARK_(cm){
return (portfolio.components.paredit.get_type.call(null,cm) == null);
});
/**
 * returns true if there's any code to the left of cursor. assumes you've
 *   already ruled out comments so only looks for non nil tokens
 */
portfolio.components.paredit.code_to_left_QMARK_ = (function portfolio$components$paredit$code_to_left_QMARK_(cm){
var cur = portfolio.components.paredit.cursor.call(null,cm);
var toks = cm.getLineTokens(cur.line);
var ch = cur.ch;
var code = cljs.core.map.call(null,(function (p1__28791_SHARP_){
return (((!((p1__28791_SHARP_.type == null)))) && ((((p1__28791_SHARP_.end <= ch)) || ((((p1__28791_SHARP_.start < ch)) && ((ch < p1__28791_SHARP_.end)))))));
}),toks);
var and__5043__auto__ = cljs.core.seq.call(null,toks);
if(and__5043__auto__){
return cljs.core.some.call(null,cljs.core.true_QMARK_,code);
} else {
return and__5043__auto__;
}
});
portfolio.components.paredit.comment_dwim = (function portfolio$components$paredit$comment_dwim(cm){
if(cljs.core.truth_(portfolio.components.paredit.selection_completely_whitespace_QMARK_.call(null,cm))){
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);
} else {
if(cljs.core.truth_(portfolio.components.paredit.selection_completely_non_code_QMARK_.call(null,cm))){
return portfolio.components.paredit.uncomment_selection.call(null,cm);
} else {
if(cljs.core.truth_(cm.somethingSelected())){
return portfolio.components.paredit.comment_selection.call(null,cm);
} else {
if(portfolio.components.paredit.line_ends_with_comment_QMARK_.call(null,cm)){
return portfolio.components.paredit.go_to_comment_and_indent.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.betw_code_and_line_end_QMARK_.call(null,cm))){
return portfolio.components.paredit.create_comment_at_end.call(null,cm);
} else {
if(portfolio.components.paredit.in_code_QMARK_.call(null,cm)){
return portfolio.components.paredit.create_comment_at_end.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.in_string_QMARK_.call(null,cm))){
return portfolio.components.paredit.create_comment_at_end.call(null,cm);
} else {
if(portfolio.components.paredit.line_is_whitespace_QMARK_.call(null,cm)){
return portfolio.components.paredit.create_line_comment.call(null,cm);
} else {
if(cljs.core.truth_((function (){var and__5043__auto__ = portfolio.components.paredit.code_to_left_QMARK_.call(null,cm);
if(cljs.core.truth_(and__5043__auto__)){
return portfolio.components.paredit.in_whitespace_QMARK_.call(null,cm);
} else {
return and__5043__auto__;
}
})())){
return portfolio.components.paredit.new_line_and_comment.call(null,cm);
} else {
if(portfolio.components.paredit.in_whitespace_QMARK_.call(null,cm)){
return portfolio.components.paredit.insert_line_comment_here.call(null,cm);
} else {
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);

}
}
}
}
}
}
}
}
}
}
});
goog.exportSymbol('portfolio.components.paredit.comment_dwim', portfolio.components.paredit.comment_dwim);
/**
 * delete 1 or n char to left
 */
portfolio.components.paredit.backspace = (function portfolio$components$paredit$backspace(var_args){
var G__28794 = arguments.length;
switch (G__28794) {
case 1:
return portfolio.components.paredit.backspace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.backspace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.backspace.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.backspace.call(null,cm,(1));
}));

(portfolio.components.paredit.backspace.cljs$core$IFn$_invoke$arity$2 = (function (cm,n){
var _n = (function (p1__28792_SHARP_){
return (p1__28792_SHARP_ - n);
});
var cur = portfolio.components.paredit.cursor.call(null,cm);
var cur0 = portfolio.components.paredit.cursor.call(null,cm,_n.call(null,portfolio.components.paredit.index.call(null,cm,cur)));
return cm.replaceRange("",cur0,cur);
}));

(portfolio.components.paredit.backspace.cljs$lang$maxFixedArity = 2);

/**
 * true if this position would be whitespace if we pressed the spacebar.
 */
portfolio.components.paredit.right_cur_would_be_whitespace_QMARK_ = (function portfolio$components$paredit$right_cur_would_be_whitespace_QMARK_(cm,cur,right_cur){
var original_cur = portfolio.components.paredit.cursor.call(null,cm);
var _ = portfolio.components.paredit.insert.call(null,cm," ",(0),cur);
var answer = (portfolio.components.paredit.get_type.call(null,cm,right_cur) == null);
portfolio.components.paredit.backspace.call(null,cm);

cm.setCursor(original_cur);

return answer;
});
/**
 * returns true for closing brackets and for closing double-quotes
 */
portfolio.components.paredit.closing_delim_QMARK_ = (function portfolio$components$paredit$closing_delim_QMARK_(cm,cur){
var map__28796 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28796__$1 = cljs.core.__destructure_map.call(null,map__28796);
var string = cljs.core.get.call(null,map__28796__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var type = cljs.core.get.call(null,map__28796__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var left_char = cljs.core.get.call(null,map__28796__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var right_cur = cljs.core.get.call(null,map__28796__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
var or__5045__auto__ = (function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return portfolio.components.paredit.closer_QMARK_.call(null,left_char);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core._EQ_.call(null,type,"string")) && (((cljs.core._EQ_.call(null,"\"",left_char)) && (portfolio.components.paredit.right_cur_would_be_whitespace_QMARK_.call(null,cm,cur,right_cur)))));
}
});
/**
 * returns true if cur is just to the right of an opening doublequote
 */
portfolio.components.paredit.opening_doublequote_QMARK_ = (function portfolio$components$paredit$opening_doublequote_QMARK_(var_args){
var G__28798 = arguments.length;
switch (G__28798) {
case 2:
return portfolio.components.paredit.opening_doublequote_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return portfolio.components.paredit.opening_doublequote_QMARK_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.opening_doublequote_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var map__28799 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28799__$1 = cljs.core.__destructure_map.call(null,map__28799);
var type = cljs.core.get.call(null,map__28799__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var left_char = cljs.core.get.call(null,map__28799__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var right_cur = cljs.core.get.call(null,map__28799__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
return portfolio.components.paredit.opening_doublequote_QMARK_.call(null,cm,type,left_char,right_cur);
}));

(portfolio.components.paredit.opening_doublequote_QMARK_.cljs$core$IFn$_invoke$arity$4 = (function (cm,type,left_char,right_cur){
var and__5043__auto__ = cljs.core._EQ_.call(null,type,"string");
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core._EQ_.call(null,"\"",left_char);
if(and__5043__auto____$1){
var and__5043__auto____$2 = right_cur;
if(cljs.core.truth_(and__5043__auto____$2)){
return cljs.core._EQ_.call(null,"string",portfolio.components.paredit.get_type.call(null,cm,right_cur));
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
}));

(portfolio.components.paredit.opening_doublequote_QMARK_.cljs$lang$maxFixedArity = 4);

/**
 * returns true if cur is just to the right of a closing doublequote
 */
portfolio.components.paredit.closing_doublequote_QMARK_ = (function portfolio$components$paredit$closing_doublequote_QMARK_(cm,cur){
var map__28801 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28801__$1 = cljs.core.__destructure_map.call(null,map__28801);
var type = cljs.core.get.call(null,map__28801__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var left_char = cljs.core.get.call(null,map__28801__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var right_cur = cljs.core.get.call(null,map__28801__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
var right_type = portfolio.components.paredit.get_type.call(null,cm,right_cur);
return ((cljs.core._EQ_.call(null,type,"string")) && (((cljs.core._EQ_.call(null,"\"",left_char)) && (cljs.core.not_EQ_.call(null,right_type,"string")))));
});
/**
 * returns true for opening brackets and for opening double-quotes
 */
portfolio.components.paredit.opening_delim_QMARK_ = (function portfolio$components$paredit$opening_delim_QMARK_(cm,cur){
var map__28802 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28802__$1 = cljs.core.__destructure_map.call(null,map__28802);
var string = cljs.core.get.call(null,map__28802__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var type = cljs.core.get.call(null,map__28802__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var left_char = cljs.core.get.call(null,map__28802__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var right_cur = cljs.core.get.call(null,map__28802__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
var or__5045__auto__ = (function (){var and__5043__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(and__5043__auto__)){
return portfolio.components.paredit.opener_QMARK_.call(null,left_char);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return portfolio.components.paredit.opening_doublequote_QMARK_.call(null,cm,type,left_char,right_cur);
}
});
/**
 * returns true for an opening bracket of an empty pair ()
 */
portfolio.components.paredit.opening_delim_for_empty_pair_QMARK_ = (function portfolio$components$paredit$opening_delim_for_empty_pair_QMARK_(cm,cur){
var map__28803 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28803__$1 = cljs.core.__destructure_map.call(null,map__28803);
var left_char = cljs.core.get.call(null,map__28803__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var right_char = cljs.core.get.call(null,map__28803__$1,new cljs.core.Keyword(null,"right-char","right-char",-1500850071));
var right_cur = cljs.core.get.call(null,map__28803__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
var and__5043__auto__ = portfolio.components.paredit.opening_delim_QMARK_.call(null,cm,cur);
if(cljs.core.truth_(and__5043__auto__)){
var and__5043__auto____$1 = right_cur;
if(cljs.core.truth_(and__5043__auto____$1)){
var and__5043__auto____$2 = portfolio.components.paredit.closing_delim_QMARK_.call(null,cm,right_cur);
if(cljs.core.truth_(and__5043__auto____$2)){
return portfolio.components.paredit.pair_QMARK_.call(null,left_char,right_char);
} else {
return and__5043__auto____$2;
}
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
/**
 * returns true for an opening bracket of a pair that contains one or more
 *   chars.
 */
portfolio.components.paredit.opening_delim_for_non_empty_pair_QMARK_ = (function portfolio$components$paredit$opening_delim_for_non_empty_pair_QMARK_(cm){
var map__28804 = portfolio.components.paredit.get_info.call(null,cm);
var map__28804__$1 = cljs.core.__destructure_map.call(null,map__28804);
var left_char = cljs.core.get.call(null,map__28804__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var right_char = cljs.core.get.call(null,map__28804__$1,new cljs.core.Keyword(null,"right-char","right-char",-1500850071));
var cur = cljs.core.get.call(null,map__28804__$1,new cljs.core.Keyword(null,"cur","cur",1153190599));
var and__5043__auto__ = portfolio.components.paredit.opening_delim_QMARK_.call(null,cm,cur);
if(cljs.core.truth_(and__5043__auto__)){
return (!(portfolio.components.paredit.pair_QMARK_.call(null,left_char,right_char)));
} else {
return and__5043__auto__;
}
});
/**
 * moves the cursor by 'offset' places, negative for left. returns the cursor.
 */
portfolio.components.paredit.move = (function portfolio$components$paredit$move(cm,offset){
cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,(offset + portfolio.components.paredit.index.call(null,cm))));

return portfolio.components.paredit.cursor.call(null,cm);
});
/**
 * delete 1 or n char to right
 */
portfolio.components.paredit.delete$ = (function portfolio$components$paredit$delete(var_args){
var G__28807 = arguments.length;
switch (G__28807) {
case 1:
return portfolio.components.paredit.delete$.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.delete$.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.delete$.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.delete$.call(null,cm,(1));
}));

(portfolio.components.paredit.delete$.cljs$core$IFn$_invoke$arity$2 = (function (cm,n){
var _PLUS_n = (function (p1__28805_SHARP_){
return (p1__28805_SHARP_ + n);
});
var cur = portfolio.components.paredit.cursor.call(null,cm);
var cur2 = portfolio.components.paredit.cursor.call(null,cm,_PLUS_n.call(null,portfolio.components.paredit.index.call(null,cm,cur)));
return cm.replaceRange("",cur,cur2);
}));

(portfolio.components.paredit.delete$.cljs$lang$maxFixedArity = 2);

/**
 * returns true if cursor indicates whitespace
 */
portfolio.components.paredit.whitespace_QMARK_ = (function portfolio$components$paredit$whitespace_QMARK_(cm,cur){
var info = portfolio.components.paredit.get_info.call(null,cm,cur);
return (((!((info == null)))) && ((new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(info) == null)));
});
/**
 * true if cursor info indicates opening/closing bracket or quote
 */
portfolio.components.paredit.bracket_QMARK_ = (function portfolio$components$paredit$bracket_QMARK_(cm,cur){
var map__28809 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28809__$1 = cljs.core.__destructure_map.call(null,map__28809);
var info = map__28809__$1;
var type = cljs.core.get.call(null,map__28809__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var left_char = cljs.core.get.call(null,map__28809__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var or__5045__auto__ = portfolio.components.paredit.is_bracket_type_QMARK_.call(null,type);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core._EQ_.call(null,"string",type)) && (cljs.core._EQ_.call(null,"\"",left_char)));
}
});
/**
 * assumes a pair of brackets surround the cursor. selects the pair.
 */
portfolio.components.paredit.select_pair = (function portfolio$components$paredit$select_pair(cm){
var i = portfolio.components.paredit.index.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
var c1 = portfolio.components.paredit.cursor.call(null,cm,(i - (1)));
var c2 = portfolio.components.paredit.cursor.call(null,cm,(i + (1)));
return cm.setSelection(c1,c2);
});
portfolio.components.paredit.delete_selection = (function portfolio$components$paredit$delete_selection(cm){
return cm.replaceSelection("");
});
/**
 * assumes a pair of brackets surround the cursor. deletes the pair.
 */
portfolio.components.paredit.delete_pair = (function portfolio$components$paredit$delete_pair(cm){
portfolio.components.paredit.backspace.call(null,cm);

return portfolio.components.paredit.delete$.call(null,cm);
});
portfolio.components.paredit.move_right = (function portfolio$components$paredit$move_right(cm){
return portfolio.components.paredit.move.call(null,cm,(1));
});
portfolio.components.paredit.move_left = (function portfolio$components$paredit$move_left(cm){
return portfolio.components.paredit.move.call(null,cm,(-1));
});
/**
 * paredit-forward-delete exposed for keymap
 */
portfolio.components.paredit.forward_delete = (function portfolio$components$paredit$forward_delete(cm){
var map__28810 = portfolio.components.paredit.get_info.call(null,cm);
var map__28810__$1 = cljs.core.__destructure_map.call(null,map__28810);
var info = map__28810__$1;
var cur = cljs.core.get.call(null,map__28810__$1,new cljs.core.Keyword(null,"cur","cur",1153190599));
var right_cur = cljs.core.get.call(null,map__28810__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
if(cljs.core.truth_(cm.somethingSelected())){
return portfolio.components.paredit.delete_selection.call(null,cm);
} else {
if(portfolio.components.paredit.whitespace_QMARK_.call(null,cm,right_cur)){
return portfolio.components.paredit.delete$.call(null,cm);
} else {
if(cljs.core.not.call(null,portfolio.components.paredit.bracket_QMARK_.call(null,cm,right_cur))){
return portfolio.components.paredit.delete$.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_delim_QMARK_.call(null,cm,right_cur))){
return portfolio.components.paredit.move_right.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_delim_for_empty_pair_QMARK_.call(null,cm,cur))){
return portfolio.components.paredit.delete_pair.call(null,cm);
} else {
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);

}
}
}
}
}
});
goog.exportSymbol('portfolio.components.paredit.forward_delete', portfolio.components.paredit.forward_delete);
/**
 * paredit backward delete exposed for keymap
 */
portfolio.components.paredit.backward_delete = (function portfolio$components$paredit$backward_delete(cm){
var cur = portfolio.components.paredit.cursor.call(null,cm);
if(cljs.core.truth_(cm.somethingSelected())){
return portfolio.components.paredit.delete_selection.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur))){
return portfolio.components.paredit.delete_pair.call(null,cm);
} else {
if(portfolio.components.paredit.escaped_char_to_left_QMARK_.call(null,cm,cur)){
return portfolio.components.paredit.backspace.call(null,cm,(2));
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_delim_for_non_empty_pair_QMARK_.call(null,cm))){
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_delim_for_empty_pair_QMARK_.call(null,cm,cur))){
return portfolio.components.paredit.delete_pair.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.closing_delim_QMARK_.call(null,cm,cur))){
return portfolio.components.paredit.move_left.call(null,cm);
} else {
return portfolio.components.paredit.backspace.call(null,cm);

}
}
}
}
}
}
});
goog.exportSymbol('portfolio.components.paredit.backward_delete', portfolio.components.paredit.backward_delete);
/**
 * returns true if token is in the middle of a string.
 */
portfolio.components.paredit.in_regular_string_QMARK_ = (function portfolio$components$paredit$in_regular_string_QMARK_(cm,cur){
var or__5045__auto__ = portfolio.components.paredit.opening_doublequote_QMARK_.call(null,cm,cur);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return ((cljs.core._EQ_.call(null,"string",portfolio.components.paredit.get_type.call(null,cm,cur))) && ((!(portfolio.components.paredit.closing_doublequote_QMARK_.call(null,cm,cur)))));
}
});
/**
 * true if these values are from a string token that ends on another line
 */
portfolio.components.paredit.str_ends_on_another_line_QMARK_ = (function portfolio$components$paredit$str_ends_on_another_line_QMARK_(type,string){
return ((cljs.core._EQ_.call(null,"string",type)) && (cljs.core.not_EQ_.call(null,"\"",cljs.core.last.call(null,string))));
});
/**
 * moves cursor to end of the string you're in (but still inside the
 *   closing doublequote). assumes you're in a string. the end could be
 *   on a different line from where you start
 */
portfolio.components.paredit.go_to_end_of_string = (function portfolio$components$paredit$go_to_end_of_string(var_args){
var G__28812 = arguments.length;
switch (G__28812) {
case 1:
return portfolio.components.paredit.go_to_end_of_string.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.go_to_end_of_string.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.go_to_end_of_string.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.go_to_end_of_string.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.go_to_end_of_string.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var map__28813 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28813__$1 = cljs.core.__destructure_map.call(null,map__28813);
var left_char = cljs.core.get.call(null,map__28813__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var right_cur = cljs.core.get.call(null,map__28813__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
var type = cljs.core.get.call(null,map__28813__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var string = cljs.core.get.call(null,map__28813__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var ch = cljs.core.get.call(null,map__28813__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var end = cljs.core.get.call(null,map__28813__$1,new cljs.core.Keyword(null,"end","end",-268185958));
if((type == null)){
return portfolio.components.paredit.go_to_end_of_string.call(null,cm,right_cur);
} else {
if(portfolio.components.paredit.str_ends_on_another_line_QMARK_.call(null,type,string)){
portfolio.components.paredit.move_to_end_of_line.call(null,cm,cur);

portfolio.components.paredit.move.call(null,cm,(2));

return portfolio.components.paredit.go_to_end_of_string.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_doublequote_QMARK_.call(null,cm,type,left_char,right_cur))){
portfolio.components.paredit.move.call(null,cm,(1));

return portfolio.components.paredit.go_to_end_of_string.call(null,cm);
} else {
if(cljs.core._EQ_.call(null,"string",type)){
return portfolio.components.paredit.move.call(null,cm,((end - ch) - (1)));
} else {
return cur;

}
}
}
}
}));

(portfolio.components.paredit.go_to_end_of_string.cljs$lang$maxFixedArity = 2);

/**
 * assumes you are in a string.
 */
portfolio.components.paredit.select_rest_of_string = (function portfolio$components$paredit$select_rest_of_string(cm){
var c1 = portfolio.components.paredit.cursor.call(null,cm);
var c2 = portfolio.components.paredit.go_to_end_of_string.call(null,cm,c1);
return cm.setSelection(c1,c2);
});
/**
 * true if code is to the left and whitespace* comment* is to the right.
 */
portfolio.components.paredit.betw_code_and_comment_QMARK_ = (function portfolio$components$paredit$betw_code_and_comment_QMARK_(cm,cur){
if(cljs.core.truth_(cur)){
var toks = cm.getLineTokens(cur.line);
var ch = cur.ch;
var tests = cljs.core.map.call(null,(function (p1__28815_SHARP_){
return (((p1__28815_SHARP_.end <= ch)) || ((((p1__28815_SHARP_.type == null)) || (cljs.core._EQ_.call(null,"comment",p1__28815_SHARP_.type)))));
}),toks);
var and__5043__auto__ = cljs.core.seq.call(null,toks);
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,tests);
if(and__5043__auto____$1){
return cljs.core.some.call(null,(function (p1__28816_SHARP_){
return (!((p1__28816_SHARP_.type == null)));
}),toks);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
} else {
return null;
}
});
portfolio.components.paredit.rest_of_siblings = (function portfolio$components$paredit$rest_of_siblings(cm){
var c1 = portfolio.components.paredit.cursor.call(null,cm);
var parent_closer = portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp);
var c2 = (cljs.core.truth_(parent_closer)?portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,parent_closer) - (1))):null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [c1,c2], null);
});
portfolio.components.paredit.select_rest_of_siblings = (function portfolio$components$paredit$select_rest_of_siblings(cm){
var vec__28817 = portfolio.components.paredit.rest_of_siblings.call(null,cm);
var c1 = cljs.core.nth.call(null,vec__28817,(0),null);
var c2 = cljs.core.nth.call(null,vec__28817,(1),null);
var c1__$1 = portfolio.components.paredit.cursor.call(null,cm);
if(cljs.core.truth_(c2)){
return cm.setSelection(c1__$1,c2);
} else {
return null;
}
});
portfolio.components.paredit.kill_from_to = (function portfolio$components$paredit$kill_from_to(cm,i,j){
var cur = portfolio.components.paredit.cursor.call(null,cm,i);
CodeMirror.emacs.kill(cm,cur,portfolio.components.paredit.cursor.call(null,cm,j));

return cm.setCursor(cur);
});
portfolio.components.paredit.kill_region = (function portfolio$components$paredit$kill_region(cm){
var first_sel = cljs.core.first.call(null,cm.listSelections());
var anchor = first_sel.anchor;
var head = first_sel.head;
return CodeMirror.emacs.kill(cm,anchor,head);
});
/**
 * assumes a pair of brackets surround the cursor. deletes the pair.
 */
portfolio.components.paredit.kill_pair = (function portfolio$components$paredit$kill_pair(cm){
portfolio.components.paredit.select_pair.call(null,cm);

return portfolio.components.paredit.kill_region.call(null,cm);
});
portfolio.components.paredit.kill_rest_of_string = (function portfolio$components$paredit$kill_rest_of_string(cm){
portfolio.components.paredit.select_rest_of_string.call(null,cm);

return portfolio.components.paredit.kill_region.call(null,cm);
});
portfolio.components.paredit.kill_rest_of_line = (function portfolio$components$paredit$kill_rest_of_line(cm){
portfolio.components.paredit.select_rest_of_line.call(null,cm);

return portfolio.components.paredit.kill_region.call(null,cm);
});
portfolio.components.paredit.kill_rest_of_siblings = (function portfolio$components$paredit$kill_rest_of_siblings(cm){
portfolio.components.paredit.select_rest_of_siblings.call(null,cm);

return portfolio.components.paredit.kill_region.call(null,cm);
});
/**
 * kills the next sibling to the right of the cursor
 */
portfolio.components.paredit.kill_next_sibling = (function portfolio$components$paredit$kill_next_sibling(cm){
var from = portfolio.components.paredit.cursor.call(null,cm);
var mid = portfolio.components.paredit.end_of_next_sibling.call(null,cm,from);
var to = (cljs.core.truth_(portfolio.components.paredit.betw_code_and_comment_QMARK_.call(null,cm,mid))?portfolio.components.paredit.last_cur.call(null,cm,mid):mid);
if(cljs.core.truth_(to)){
cm.setSelection(from,to);

return portfolio.components.paredit.kill_region.call(null,cm);
} else {
return null;
}
});
/**
 * paredit kill exposed for keymap.
 */
portfolio.components.paredit.kill = (function portfolio$components$paredit$kill(cm){
var cur = portfolio.components.paredit.cursor.call(null,cm);
if(cljs.core.truth_(cm.somethingSelected())){
return portfolio.components.paredit.kill_region.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.in_regular_string_QMARK_.call(null,cm,cur))){
return portfolio.components.paredit.kill_rest_of_string.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.betw_code_and_comment_QMARK_.call(null,cm,cur))){
return portfolio.components.paredit.kill_rest_of_line.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.in_escaped_char_QMARK_.call(null,cm,cur))){
return portfolio.components.paredit.kill_pair.call(null,cm);
} else {
if(cljs.core.truth_(portfolio.components.paredit.code_to_left_QMARK_.call(null,cm))){
return portfolio.components.paredit.kill_rest_of_siblings.call(null,cm);
} else {
return portfolio.components.paredit.kill_next_sibling.call(null,cm);

}
}
}
}
}
});
goog.exportSymbol('portfolio.components.paredit.kill', portfolio.components.paredit.kill);
portfolio.components.paredit.comment_QMARK_ = (function portfolio$components$paredit$comment_QMARK_(cm,cur){
return cljs.core._EQ_.call(null,"comment",portfolio.components.paredit.get_type.call(null,cm,cur));
});
/**
 * true if block cursor is on the first ; of a line comment
 */
portfolio.components.paredit.start_of_comment_QMARK_ = (function portfolio$components$paredit$start_of_comment_QMARK_(cm,cur){
var map__28820 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28820__$1 = cljs.core.__destructure_map.call(null,map__28820);
var type = cljs.core.get.call(null,map__28820__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var right_cur = cljs.core.get.call(null,map__28820__$1,new cljs.core.Keyword(null,"right-cur","right-cur",1689901919));
var right_type = portfolio.components.paredit.get_type.call(null,cm,right_cur);
return ((cljs.core.not_EQ_.call(null,"comment",type)) && (cljs.core._EQ_.call(null,"comment right-type")));
});
portfolio.components.paredit.idx_of_next = (function portfolio$components$paredit$idx_of_next(cm,i,chars,member,max){
var map__28821 = portfolio.components.paredit.get_info.call(null,cm,portfolio.components.paredit.cursor.call(null,cm,i));
var map__28821__$1 = cljs.core.__destructure_map.call(null,map__28821);
var right_char = cljs.core.get.call(null,map__28821__$1,new cljs.core.Keyword(null,"right-char","right-char",-1500850071));
if(cljs.core._EQ_.call(null,i,max)){
return portfolio.components.paredit.guard.call(null);
} else {
if(cljs.core._EQ_.call(null,member,cljs.core.contains_QMARK_.call(null,chars,right_char))){
return i;
} else {
return (function (){
return portfolio.components.paredit.idx_of_next.call(null,cm,(i + (1)),chars,member,max);
});

}
}
});
portfolio.components.paredit.index_of_next = (function portfolio$components$paredit$index_of_next(cm,i,chars){
return cljs.core.trampoline.call(null,portfolio.components.paredit.idx_of_next,cm,i,chars,true,portfolio.components.paredit.char_count.call(null,cm));
});
portfolio.components.paredit.index_of_next_non = (function portfolio$components$paredit$index_of_next_non(cm,i,chars){
return cljs.core.trampoline.call(null,portfolio.components.paredit.idx_of_next,cm,i,chars,false,portfolio.components.paredit.char_count.call(null,cm));
});
portfolio.components.paredit.non_word_chars = cljs.core.set.call(null,"(){}[]|&; \n");
portfolio.components.paredit.comment_start = cljs.core.set.call(null,"; ");
portfolio.components.paredit.semicolons = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [";",null], null), null);
portfolio.components.paredit.comment_whitespace = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [" ",null,"\t",null], null), null);
/**
 * assumes i is in a comment or a string. returns the i at the end of
 *   the next word (going to the right) in this comment/string
 */
portfolio.components.paredit.end_of_next_word = (function portfolio$components$paredit$end_of_next_word(cm,i){
var map__28822 = portfolio.components.paredit.get_info.call(null,cm,portfolio.components.paredit.cursor.call(null,cm,i));
var map__28822__$1 = cljs.core.__destructure_map.call(null,map__28822);
var ch = cljs.core.get.call(null,map__28822__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var start = cljs.core.get.call(null,map__28822__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var string = cljs.core.get.call(null,map__28822__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var tail = cljs.core.subs.call(null,string,(ch - start));
var word = cljs.core.re_find.call(null,/^\s*[\S]*/,tail);
var length = cljs.core.count.call(null,word);
var quote = ((clojure.string.ends_with_QMARK_.call(null,word,"\""))?(-1):(0));
return ((i + length) + quote);
});
/**
 * assumes i is in a comment or a string. returns the i at the start of
 *   the prev word (going to the left) in this comment/string
 */
portfolio.components.paredit.start_of_prev_word = (function portfolio$components$paredit$start_of_prev_word(cm,i){
var map__28823 = portfolio.components.paredit.get_info.call(null,cm,portfolio.components.paredit.cursor.call(null,cm,i));
var map__28823__$1 = cljs.core.__destructure_map.call(null,map__28823);
var ch = cljs.core.get.call(null,map__28823__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var start = cljs.core.get.call(null,map__28823__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var string = cljs.core.get.call(null,map__28823__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var head = cljs.core.subs.call(null,string,(0),(ch - start));
var last_word = cljs.core.re_find.call(null,/[\S]*\s*$/,head);
var length = cljs.core.count.call(null,last_word);
var quote = ((clojure.string.ends_with_QMARK_.call(null,last_word,"\""))?(1):(0));
return ((i - length) - quote);
});
/**
 * assumes i is in a comment or a string. kills text from i to the end
 *   of the next word in this comment/string
 */
portfolio.components.paredit.kill_next_word = (function portfolio$components$paredit$kill_next_word(cm,i){
portfolio.components.paredit.kill_from_to.call(null,cm,i,portfolio.components.paredit.end_of_next_word.call(null,cm,(i + (1))));

return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,i));
});
/**
 * trampoline helper for forward-kill-word. 'mark' is the index to start killing
 *   from. 'i' is the index we're inspecting. 'n' is how many calls remaining that
 *   we'll support before stopping because of a suspected infinite loop. first call
 *   can put the count of characters in this cm instance.
 */
portfolio.components.paredit.fwd_kill_word = (function portfolio$components$paredit$fwd_kill_word(cm,mark,i,n){
var m = (n - (1));
var j = (i + (1));
var cur = portfolio.components.paredit.cursor.call(null,cm,i);
var right_cur = portfolio.components.paredit.cursor.call(null,cm,j);
if((n < (0))){
return portfolio.components.paredit.guard.call(null);
} else {
if(portfolio.components.paredit.eof_QMARK_.call(null,cm,right_cur)){
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);
} else {
if(portfolio.components.paredit.whitespace_QMARK_.call(null,cm,right_cur)){
return (function (){
return portfolio.components.paredit.fwd_kill_word.call(null,cm,mark,portfolio.components.paredit.token_end_index.call(null,cm,j),m);
});
} else {
if(portfolio.components.paredit.start_of_a_string_QMARK_.call(null,cm,right_cur)){
return (function (){
return portfolio.components.paredit.fwd_kill_word.call(null,cm,j,j,m);
});
} else {
if(cljs.core.truth_(portfolio.components.paredit.in_regular_string_QMARK_.call(null,cm,right_cur))){
return portfolio.components.paredit.kill_next_word.call(null,cm,mark);
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_delim_QMARK_.call(null,cm,right_cur))){
return (function (){
return portfolio.components.paredit.fwd_kill_word.call(null,cm,j,j,m);
});
} else {
if(cljs.core.truth_(portfolio.components.paredit.closing_delim_QMARK_.call(null,cm,right_cur))){
return (function (){
return portfolio.components.paredit.fwd_kill_word.call(null,cm,j,j,m);
});
} else {
if(portfolio.components.paredit.at_a_word_QMARK_.call(null,cm,right_cur)){
return portfolio.components.paredit.kill_from_to.call(null,cm,mark,portfolio.components.paredit.token_end_index.call(null,cm,j));
} else {
if(portfolio.components.paredit.start_of_comment_QMARK_.call(null,cm,cur)){
var j__$1 = portfolio.components.paredit.index_of_next_non.call(null,cm,i,portfolio.components.paredit.semicolons);
return (function (){
return portfolio.components.paredit.fwd_kill_word.call(null,cm,j__$1,j__$1,m);
});
} else {
if(portfolio.components.paredit.comment_QMARK_.call(null,cm,right_cur)){
return portfolio.components.paredit.kill_next_word.call(null,cm,mark);
} else {
return cljs.core.println.call(null,"unhandled");

}
}
}
}
}
}
}
}
}
}
});
/**
 * paredit forward-kill-word exposed for keymap.
 */
portfolio.components.paredit.forward_kill_word = (function portfolio$components$paredit$forward_kill_word(cm){
var i = portfolio.components.paredit.index.call(null,cm);
return cljs.core.trampoline.call(null,portfolio.components.paredit.fwd_kill_word,cm,i,i,portfolio.components.paredit.char_count.call(null,cm));
});
goog.exportSymbol('portfolio.components.paredit.forward_kill_word', portfolio.components.paredit.forward_kill_word);
portfolio.components.paredit.start_of_token_at = (function portfolio$components$paredit$start_of_token_at(cm,i){
var map__28824 = portfolio.components.paredit.get_info.call(null,cm,portfolio.components.paredit.cursor.call(null,cm,i));
var map__28824__$1 = cljs.core.__destructure_map.call(null,map__28824);
var ch = cljs.core.get.call(null,map__28824__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var start = cljs.core.get.call(null,map__28824__$1,new cljs.core.Keyword(null,"start","start",-355208981));
return (i - (ch - start));
});
/**
 * assumes i is in a comment. kills text from i to the beginning of the previous
 *   word in this comment
 */
portfolio.components.paredit.kill_prev_word_in_comment = (function portfolio$components$paredit$kill_prev_word_in_comment(cm,i){
var map__28825 = portfolio.components.paredit.get_info.call(null,cm,portfolio.components.paredit.cursor.call(null,cm,i));
var map__28825__$1 = cljs.core.__destructure_map.call(null,map__28825);
var ch = cljs.core.get.call(null,map__28825__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var start = cljs.core.get.call(null,map__28825__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var string = cljs.core.get.call(null,map__28825__$1,new cljs.core.Keyword(null,"string","string",-1989541586));
var cur_offset_in_string = (ch - start);
var head = cljs.core.subs.call(null,string,(0),cur_offset_in_string);
var tail = cljs.core.subs.call(null,string,cur_offset_in_string);
var word = cljs.core.re_find.call(null,/\S*\s*$/,head);
var length = cljs.core.count.call(null,word);
portfolio.components.paredit.kill_from_to.call(null,cm,(i - length),i);

return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,(i - length)));
});
portfolio.components.paredit.beginning_of_line_QMARK_ = (function portfolio$components$paredit$beginning_of_line_QMARK_(cm,cur){
var map__28826 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28826__$1 = cljs.core.__destructure_map.call(null,map__28826);
var info = map__28826__$1;
var start = cljs.core.get.call(null,map__28826__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var end = cljs.core.get.call(null,map__28826__$1,new cljs.core.Keyword(null,"end","end",-268185958));
var type = cljs.core.get.call(null,map__28826__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return (((!((info == null)))) && ((((type == null)) && (cljs.core._EQ_.call(null,start,end,(0))))));
});
portfolio.components.paredit.bkwd_kill_skippable_comment_char_QMARK_ = (function portfolio$components$paredit$bkwd_kill_skippable_comment_char_QMARK_(cm,cur){
var map__28827 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28827__$1 = cljs.core.__destructure_map.call(null,map__28827);
var info = map__28827__$1;
var type = cljs.core.get.call(null,map__28827__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var left_char = cljs.core.get.call(null,map__28827__$1,new cljs.core.Keyword(null,"left-char","left-char",509989355));
var and__5043__auto__ = (!((info == null)));
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core._EQ_.call(null,"comment",type);
if(and__5043__auto____$1){
return cljs.core.re_matches.call(null,/\s|;/,left_char);
} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
});
/**
 * trampoline helper for backward-kill-word. 'mark' is the index to start
 *   killing from. 'i' is the index we're inspecting. 'n' is how many more calls
 *   we'll entertain before stopping because we suspect an infinite loop. first
 *   call can use char count for 'n'.
 */
portfolio.components.paredit.bkwd_kill_word = (function portfolio$components$paredit$bkwd_kill_word(cm,mark,i,n){
var h = (i - (1));
var m = (n - (1));
var cur = portfolio.components.paredit.cursor.call(null,cm,i);
if((n < (0))){
return portfolio.components.paredit.guard.call(null);
} else {
if(portfolio.components.paredit.bof_QMARK_.call(null,cm,cur)){
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);
} else {
if(portfolio.components.paredit.beginning_of_line_QMARK_.call(null,cm,cur)){
return (function (){
return portfolio.components.paredit.bkwd_kill_word.call(null,cm,h,h,m);
});
} else {
if(portfolio.components.paredit.whitespace_QMARK_.call(null,cm,cur)){
return (function (){
return portfolio.components.paredit.bkwd_kill_word.call(null,cm,mark,portfolio.components.paredit.start_of_token_at.call(null,cm,i),m);
});
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_delim_QMARK_.call(null,cm,cur))){
return (function (){
return portfolio.components.paredit.bkwd_kill_word.call(null,cm,h,h,m);
});
} else {
if(cljs.core.truth_(portfolio.components.paredit.closing_delim_QMARK_.call(null,cm,cur))){
return (function (){
return portfolio.components.paredit.bkwd_kill_word.call(null,cm,h,h,m);
});
} else {
if(portfolio.components.paredit.at_a_word_QMARK_.call(null,cm,cur)){
return portfolio.components.paredit.kill_from_to.call(null,cm,portfolio.components.paredit.start_of_token_at.call(null,cm,i),mark);
} else {
if(portfolio.components.paredit.start_of_comment_QMARK_.call(null,cm,cur)){
var j = portfolio.components.paredit.index_of_next_non.call(null,cm,i,portfolio.components.paredit.semicolons);
return (function (){
return portfolio.components.paredit.fwd_kill_word.call(null,cm,j,j,m);
});
} else {
if(cljs.core.truth_(portfolio.components.paredit.bkwd_kill_skippable_comment_char_QMARK_.call(null,cm,cur))){
return (function (){
return portfolio.components.paredit.bkwd_kill_word.call(null,cm,mark,h,m);
});
} else {
if(portfolio.components.paredit.comment_QMARK_.call(null,cm,cur)){
return portfolio.components.paredit.kill_prev_word_in_comment.call(null,cm,mark);
} else {
return cljs.core.println.call(null,"unhandled");

}
}
}
}
}
}
}
}
}
}
});
/**
 * paredit backward-kill-word exposed for keymap.
 */
portfolio.components.paredit.backward_kill_word = (function portfolio$components$paredit$backward_kill_word(cm){
var i = portfolio.components.paredit.index.call(null,cm);
return cljs.core.trampoline.call(null,portfolio.components.paredit.bkwd_kill_word,cm,i,i,portfolio.components.paredit.char_count.call(null,cm));
});
goog.exportSymbol('portfolio.components.paredit.backward_kill_word', portfolio.components.paredit.backward_kill_word);
/**
 * trampoline helper for forward. 'i' is the index we're inspecting. 'n' is how
 *   many more calls we'll entertain before suspecting an infinite loop. first call
 *   can pass in char count.
 */
portfolio.components.paredit.fwd = (function portfolio$components$paredit$fwd(cm,i,n){
var j = (i + (1));
var m = (n - (1));
var cur = portfolio.components.paredit.cursor.call(null,cm,i);
var right_cur = portfolio.components.paredit.cursor.call(null,cm,j);
if((n < (0))){
return portfolio.components.paredit.guard.call(null);
} else {
if((right_cur == null)){
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);
} else {
if(portfolio.components.paredit.eof_QMARK_.call(null,cm,right_cur)){
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);
} else {
if(portfolio.components.paredit.whitespace_QMARK_.call(null,cm,right_cur)){
return (function (){
return portfolio.components.paredit.fwd.call(null,cm,j,m);
});
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_delim_QMARK_.call(null,cm,right_cur))){
return cm.setCursor(portfolio.components.paredit.end_of_next_sibling.call(null,cm,cur));
} else {
if(cljs.core.truth_(portfolio.components.paredit.closing_delim_QMARK_.call(null,cm,right_cur))){
return cm.setCursor(right_cur);
} else {
if(portfolio.components.paredit.at_a_word_QMARK_.call(null,cm,right_cur)){
return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,portfolio.components.paredit.token_end_index.call(null,cm,j)));
} else {
if(portfolio.components.paredit.comment_QMARK_.call(null,cm,right_cur)){
return (function (){
return portfolio.components.paredit.fwd.call(null,cm,portfolio.components.paredit.token_end_index.call(null,cm,j),m);
});
} else {
if(portfolio.components.paredit.in_string_QMARK_.call(null,cm,right_cur)){
return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,portfolio.components.paredit.end_of_next_word.call(null,cm,j)));
} else {
return cljs.core.println.call(null,"unhandled");

}
}
}
}
}
}
}
}
}
});
/**
 * paredit forward exposed for keymap. find the first thing that isn't
 *   whitespace or comment. if it is a closing bracket, step past it. otherwise
 *   skip over the thing.
 */
portfolio.components.paredit.forward = (function portfolio$components$paredit$forward(cm){
return cljs.core.trampoline.call(null,portfolio.components.paredit.fwd,cm,portfolio.components.paredit.index.call(null,cm),portfolio.components.paredit.char_count.call(null,cm));
});
goog.exportSymbol('portfolio.components.paredit.forward', portfolio.components.paredit.forward);
/**
 * trampoline helper for backward. 'i' is the index we're inspecting. 'n' is
 *   number of remaining calls before we suspect an infinite loop
 */
portfolio.components.paredit.bkwd = (function portfolio$components$paredit$bkwd(cm,i,n){
var h = (i - (1));
var m = (n - (1));
var cur = portfolio.components.paredit.cursor.call(null,cm,i);
if((n < (0))){
return portfolio.components.paredit.guard.call(null);
} else {
if((cur == null)){
return new cljs.core.Keyword(null,"do-nothing","do-nothing",1030476282);
} else {
if(portfolio.components.paredit.bof_QMARK_.call(null,cm,cur)){
return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,h));
} else {
if(portfolio.components.paredit.whitespace_QMARK_.call(null,cm,cur)){
return (function (){
return portfolio.components.paredit.bkwd.call(null,cm,h,m);
});
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_delim_QMARK_.call(null,cm,cur))){
return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,h));
} else {
if(cljs.core.truth_(portfolio.components.paredit.closing_delim_QMARK_.call(null,cm,cur))){
return cm.setCursor(portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur));
} else {
if(portfolio.components.paredit.at_a_word_QMARK_.call(null,cm,cur)){
return cm.setCursor(portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur));
} else {
if(portfolio.components.paredit.comment_QMARK_.call(null,cm,cur)){
return (function (){
return portfolio.components.paredit.bkwd.call(null,cm,portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur),m);
});
} else {
if(portfolio.components.paredit.in_string_QMARK_.call(null,cm,cur)){
return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,portfolio.components.paredit.start_of_prev_word.call(null,cm,h)));
} else {
return cljs.core.println.call(null,"unhandled");

}
}
}
}
}
}
}
}
}
});
/**
 * paredit backward exposed for keymap.
 */
portfolio.components.paredit.backward = (function portfolio$components$paredit$backward(cm){
return cljs.core.trampoline.call(null,portfolio.components.paredit.bkwd,cm,portfolio.components.paredit.index.call(null,cm),portfolio.components.paredit.char_count.call(null,cm));
});
goog.exportSymbol('portfolio.components.paredit.backward', portfolio.components.paredit.backward);
/**
 * get cursor corresponding to paredit forward up
 */
portfolio.components.paredit.forward_up_cur = (function portfolio$components$paredit$forward_up_cur(var_args){
var G__28829 = arguments.length;
switch (G__28829) {
case 1:
return portfolio.components.paredit.forward_up_cur.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.forward_up_cur.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.forward_up_cur.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.forward_up_cur.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.forward_up_cur.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if((cur == null)){
return null;
} else {
if(((portfolio.components.paredit.in_string_QMARK_.call(null,cm,cur)) && ((!(portfolio.components.paredit.end_of_a_string_QMARK_.call(null,cm,cur)))))){
return portfolio.components.paredit.token_end.call(null,cm,cur);
} else {
return portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp);

}
}
}));

(portfolio.components.paredit.forward_up_cur.cljs$lang$maxFixedArity = 2);

/**
 * paredit forward-up exposed for keymap.
 */
portfolio.components.paredit.forward_up = (function portfolio$components$paredit$forward_up(var_args){
var G__28832 = arguments.length;
switch (G__28832) {
case 1:
return portfolio.components.paredit.forward_up.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.forward_up.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.forward_up', portfolio.components.paredit.forward_up);

(portfolio.components.paredit.forward_up.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.forward_up.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.forward_up.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var temp__5804__auto__ = portfolio.components.paredit.forward_up_cur.call(null,cm,cur);
if(cljs.core.truth_(temp__5804__auto__)){
var cur_SINGLEQUOTE_ = temp__5804__auto__;
return cm.setCursor(cur_SINGLEQUOTE_);
} else {
return null;
}
}));

(portfolio.components.paredit.forward_up.cljs$lang$maxFixedArity = 2);

/**
 * get cursor corresponding to paredit backward up
 */
portfolio.components.paredit.backward_up_cur = (function portfolio$components$paredit$backward_up_cur(var_args){
var G__28835 = arguments.length;
switch (G__28835) {
case 1:
return portfolio.components.paredit.backward_up_cur.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.backward_up_cur.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.backward_up_cur.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.backward_up_cur.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.backward_up_cur.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
return portfolio.components.paredit.start_of_prev_sibling.call(null,cm,portfolio.components.paredit.forward_up_cur.call(null,cm,cur));
}));

(portfolio.components.paredit.backward_up_cur.cljs$lang$maxFixedArity = 2);

/**
 * paredit backward-up exposed for keymap.
 */
portfolio.components.paredit.backward_up = (function portfolio$components$paredit$backward_up(var_args){
var G__28838 = arguments.length;
switch (G__28838) {
case 1:
return portfolio.components.paredit.backward_up.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.backward_up.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.backward_up', portfolio.components.paredit.backward_up);

(portfolio.components.paredit.backward_up.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.backward_up.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.backward_up.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var temp__5804__auto__ = portfolio.components.paredit.backward_up_cur.call(null,cm,cur);
if(cljs.core.truth_(temp__5804__auto__)){
var cur_SINGLEQUOTE_ = temp__5804__auto__;
return cm.setCursor(cur_SINGLEQUOTE_);
} else {
return null;
}
}));

(portfolio.components.paredit.backward_up.cljs$lang$maxFixedArity = 2);

/**
 * go to the end of the current thing, whether it be a string or a word of code
 */
portfolio.components.paredit.end_of_this = (function portfolio$components$paredit$end_of_this(cm,cur){
if(portfolio.components.paredit.in_string_QMARK_.call(null,cm,cur)){
return portfolio.components.paredit.token_end.call(null,cm,cur);
} else {
return portfolio.components.paredit.end_of_next_sibling.call(null,cm,cur);
}
});
/**
 * paredit wrap-round exposed for keymap.
 */
portfolio.components.paredit.wrap_round = (function portfolio$components$paredit$wrap_round(var_args){
var G__28841 = arguments.length;
switch (G__28841) {
case 1:
return portfolio.components.paredit.wrap_round.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.wrap_round.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.wrap_round', portfolio.components.paredit.wrap_round);

(portfolio.components.paredit.wrap_round.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.wrap_round.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.wrap_round.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var cur_close = portfolio.components.paredit.end_of_this.call(null,cm,cur);
var cur_open = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur_close);
var i = (portfolio.components.paredit.index.call(null,cm,cur_open) + (1));
var text = cm.getRange(cur_open,cur_close);
var text_SINGLEQUOTE_ = ["(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(text),")"].join('');
cm.replaceRange(text_SINGLEQUOTE_,cur_open,cur_close);

return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,i));
}));

(portfolio.components.paredit.wrap_round.cljs$lang$maxFixedArity = 2);

/**
 * paredit splice-sexp exposed for keymap. unlike emacs' version, this does not
 *   splice a string by dropping its double-quotes.
 */
portfolio.components.paredit.splice_sexp = (function portfolio$components$paredit$splice_sexp(var_args){
var G__28844 = arguments.length;
switch (G__28844) {
case 1:
return portfolio.components.paredit.splice_sexp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.splice_sexp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.splice_sexp', portfolio.components.paredit.splice_sexp);

(portfolio.components.paredit.splice_sexp.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.splice_sexp.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.splice_sexp.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var i = (portfolio.components.paredit.index.call(null,cm) - (1));
var cur_close = portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp);
var cur_open = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur_close);
var text_SINGLEQUOTE_ = (cljs.core.truth_(cur_open)?cm.getRange(portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,cur_open) + (1))),portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,cur_close) - (1)))):null);
if(cljs.core.truth_(text_SINGLEQUOTE_)){
cm.replaceRange(text_SINGLEQUOTE_,cur_open,cur_close);

return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,i));
} else {
return null;
}
}));

(portfolio.components.paredit.splice_sexp.cljs$lang$maxFixedArity = 2);

/**
 * paredit splice-sexp-killing-backward exposed for keymap. like emacs' version,
 *   this doesn't actually kill to the clipboard. it just deletes. but unlink
 *   emacs, this does not splice a string by dropping its double-quotes.
 */
portfolio.components.paredit.splice_sexp_killing_backward = (function portfolio$components$paredit$splice_sexp_killing_backward(var_args){
var G__28847 = arguments.length;
switch (G__28847) {
case 1:
return portfolio.components.paredit.splice_sexp_killing_backward.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.splice_sexp_killing_backward.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.splice_sexp_killing_backward', portfolio.components.paredit.splice_sexp_killing_backward);

(portfolio.components.paredit.splice_sexp_killing_backward.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.splice_sexp_killing_backward.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.splice_sexp_killing_backward.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(portfolio.components.paredit.in_string_QMARK_.call(null,cm,cur)){
portfolio.components.paredit.backward_up.call(null,cm,cur);
} else {
}

var cur_SINGLEQUOTE_ = portfolio.components.paredit.cursor.call(null,cm);
var cur_close = portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp);
var cur_open = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur_close);
var text_SINGLEQUOTE_ = (cljs.core.truth_(cur_close)?cm.getRange(cur_SINGLEQUOTE_,portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,cur_close) - (1)))):null);
if(cljs.core.truth_(text_SINGLEQUOTE_)){
cm.replaceRange(text_SINGLEQUOTE_,cur_open,cur_close);

return cm.setCursor(cur_open);
} else {
return null;
}
}));

(portfolio.components.paredit.splice_sexp_killing_backward.cljs$lang$maxFixedArity = 2);

/**
 * paredit splice-sexp-killing-forward exposed for keymap. like emacs' version,
 *   this doesn't actually kill to the clipboard. it just deletes. but unlink
 *   emacs, this does not splice a string by dropping its double-quotes.
 */
portfolio.components.paredit.splice_sexp_killing_forward = (function portfolio$components$paredit$splice_sexp_killing_forward(var_args){
var G__28850 = arguments.length;
switch (G__28850) {
case 1:
return portfolio.components.paredit.splice_sexp_killing_forward.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.splice_sexp_killing_forward.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.splice_sexp_killing_forward', portfolio.components.paredit.splice_sexp_killing_forward);

(portfolio.components.paredit.splice_sexp_killing_forward.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.splice_sexp_killing_forward.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.splice_sexp_killing_forward.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(portfolio.components.paredit.in_string_QMARK_.call(null,cm,cur)){
portfolio.components.paredit.forward_up.call(null,cm,cur);
} else {
}

var cur_SINGLEQUOTE_ = portfolio.components.paredit.cursor.call(null,cm);
var final_cur = portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,cur_SINGLEQUOTE_) - (1)));
var cur_close = portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp);
var cur_open = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur_close);
var keep_from = (cljs.core.truth_(cur_open)?portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,cur_open) + (1))):null);
var text = (cljs.core.truth_(keep_from)?cm.getRange(cur_open,cur_close):null);
var text_SINGLEQUOTE_ = (cljs.core.truth_(keep_from)?cm.getRange(keep_from,cur_SINGLEQUOTE_):null);
if(cljs.core.truth_(text_SINGLEQUOTE_)){
cm.replaceRange(text_SINGLEQUOTE_,cur_open,cur_close);

return cm.setCursor(final_cur);
} else {
return null;
}
}));

(portfolio.components.paredit.splice_sexp_killing_forward.cljs$lang$maxFixedArity = 2);

/**
 * paredit raise-sexp exposed for keymap.
 */
portfolio.components.paredit.raise_sexp = (function portfolio$components$paredit$raise_sexp(var_args){
var G__28853 = arguments.length;
switch (G__28853) {
case 1:
return portfolio.components.paredit.raise_sexp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.raise_sexp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.raise_sexp', portfolio.components.paredit.raise_sexp);

(portfolio.components.paredit.raise_sexp.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.raise_sexp.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.raise_sexp.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(portfolio.components.paredit.in_string_QMARK_.call(null,cm,cur)){
portfolio.components.paredit.backward_up.call(null,cm,cur);
} else {
}

var c1 = portfolio.components.paredit.cursor.call(null,cm);
var c2 = portfolio.components.paredit.end_of_next_sibling.call(null,cm,c1);
var text = (cljs.core.truth_(c2)?cm.getRange(c1,c2):null);
var cur_close = (cljs.core.truth_(text)?portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp):null);
var cur_open = (cljs.core.truth_(cur_close)?portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur_close):null);
if(cljs.core.truth_(cur_open)){
cm.replaceRange(text,cur_open,cur_close);

return cm.setCursor(cur_open);
} else {
return null;
}
}));

(portfolio.components.paredit.raise_sexp.cljs$lang$maxFixedArity = 2);

/**
 * trampoline-able that looks for an ancestor closing bracket (parent,
 *   grandparent, etc) that has a sibling to slurp. returns a vector of the cur to
 *   the right of such a bracket, the cur to the right of the sibling that will be
 *   slurped, the string of the bracket to move. nil if there is no such anscestor
 *   that can slurp.
 */
portfolio.components.paredit.fwd_slurp = (function portfolio$components$paredit$fwd_slurp(cm,cur,n){
if((n >= (0))){
var parent = portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp,cur);
var sibling = portfolio.components.paredit.end_of_next_sibling.call(null,cm,parent);
if(cljs.core.truth_(sibling)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [parent,sibling,portfolio.components.paredit.get_string.call(null,cm,parent)], null);
} else {
return (function (){
return portfolio.components.paredit.fwd_slurp.call(null,cm,parent,(n - (1)));
});
}
} else {
return null;
}
});
/**
 * paredit forward-slurp-sexp exposed for keymap.
 */
portfolio.components.paredit.forward_slurp_sexp = (function portfolio$components$paredit$forward_slurp_sexp(var_args){
var G__28856 = arguments.length;
switch (G__28856) {
case 1:
return portfolio.components.paredit.forward_slurp_sexp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.forward_slurp_sexp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.forward_slurp_sexp', portfolio.components.paredit.forward_slurp_sexp);

(portfolio.components.paredit.forward_slurp_sexp.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.forward_slurp_sexp.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.forward_slurp_sexp.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var temp__5804__auto___28861 = cljs.core.trampoline.call(null,portfolio.components.paredit.fwd_slurp,cm,cur,portfolio.components.paredit.char_count.call(null,cm));
if(cljs.core.truth_(temp__5804__auto___28861)){
var vec__28857_28862 = temp__5804__auto___28861;
var parent_28863 = cljs.core.nth.call(null,vec__28857_28862,(0),null);
var sibling_28864 = cljs.core.nth.call(null,vec__28857_28862,(1),null);
var bracket_28865 = cljs.core.nth.call(null,vec__28857_28862,(2),null);
portfolio.components.paredit.insert.call(null,cm,bracket_28865,(0),sibling_28864);

cm.replaceRange("",portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,parent_28863) - cljs.core.count.call(null,bracket_28865))),parent_28863);
} else {
}

return cm.setCursor(cur);
}));

(portfolio.components.paredit.forward_slurp_sexp.cljs$lang$maxFixedArity = 2);

/**
 * trampoline-able that looks for the cursor where we'd be if we went forward
 *   and then down into the next sibling that is available. nil if there is no
 *   sibling to enter.
 */
portfolio.components.paredit.fwd_down = (function portfolio$components$paredit$fwd_down(cm,cur,n){
if((n <= (0))){
return null;
} else {
if((cur == null)){
return null;
} else {
if(cljs.core.truth_(portfolio.components.paredit.opening_delim_QMARK_.call(null,cm,cur))){
return cur;
} else {
var temp__5804__auto__ = portfolio.components.paredit.token_end.call(null,cm,cur,(1));
if(cljs.core.truth_(temp__5804__auto__)){
var cur_SINGLEQUOTE_ = temp__5804__auto__;
return (function (){
return portfolio.components.paredit.fwd_down.call(null,cm,cur_SINGLEQUOTE_,(n - (1)));
});
} else {
return null;
}

}
}
}
});
portfolio.components.paredit.forward_down_cur = (function portfolio$components$paredit$forward_down_cur(var_args){
var G__28867 = arguments.length;
switch (G__28867) {
case 1:
return portfolio.components.paredit.forward_down_cur.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.forward_down_cur.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.forward_down_cur.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.forward_down_cur.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.forward_down_cur.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
return cljs.core.trampoline.call(null,portfolio.components.paredit.fwd_down,cm,cur,portfolio.components.paredit.char_count.call(null,cm));
}));

(portfolio.components.paredit.forward_down_cur.cljs$lang$maxFixedArity = 2);

portfolio.components.paredit.forward_down = (function portfolio$components$paredit$forward_down(var_args){
var G__28870 = arguments.length;
switch (G__28870) {
case 1:
return portfolio.components.paredit.forward_down.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.forward_down.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.forward_down', portfolio.components.paredit.forward_down);

(portfolio.components.paredit.forward_down.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.forward_down.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.forward_down.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var temp__5804__auto__ = portfolio.components.paredit.forward_down_cur.call(null,cm,cur);
if(cljs.core.truth_(temp__5804__auto__)){
var cur_SINGLEQUOTE_ = temp__5804__auto__;
return cm.setCursor(cur_SINGLEQUOTE_);
} else {
return null;
}
}));

(portfolio.components.paredit.forward_down.cljs$lang$maxFixedArity = 2);

/**
 * trampoline-able that looks for the cursor where we'd be if we went backward
 *   and then down into the prev sibling that is available. nil if there is no
 *   sibling to enter.
 */
portfolio.components.paredit.bkwd_down = (function portfolio$components$paredit$bkwd_down(cm,cur,n){
var map__28872 = portfolio.components.paredit.get_info.call(null,cm,cur);
var map__28872__$1 = cljs.core.__destructure_map.call(null,map__28872);
var left_cur = cljs.core.get.call(null,map__28872__$1,new cljs.core.Keyword(null,"left-cur","left-cur",2010287159));
var i = cljs.core.get.call(null,map__28872__$1,new cljs.core.Keyword(null,"i","i",-1386841315));
var start = cljs.core.get.call(null,map__28872__$1,new cljs.core.Keyword(null,"start","start",-355208981));
var ch = cljs.core.get.call(null,map__28872__$1,new cljs.core.Keyword(null,"ch","ch",-554717905));
var bof = cljs.core.get.call(null,map__28872__$1,new cljs.core.Keyword(null,"bof","bof",-1065437469));
if((n <= (0))){
return portfolio.components.paredit.guard.call(null);
} else {
if(cljs.core.truth_(portfolio.components.paredit.closing_delim_QMARK_.call(null,cm,cur))){
return left_cur;
} else {
if(cljs.core.truth_(bof)){
return null;
} else {
if((ch === (0))){
return (function (){
return portfolio.components.paredit.bkwd_down.call(null,cm,portfolio.components.paredit.cursor.call(null,cm,(i - (1))),(n - (1)));
});
} else {
return (function (){
return portfolio.components.paredit.bkwd_down.call(null,cm,portfolio.components.paredit.cursor.call(null,cm,(i - (ch - start))),(n - (1)));
});

}
}
}
}
});
portfolio.components.paredit.backward_down = (function portfolio$components$paredit$backward_down(var_args){
var G__28874 = arguments.length;
switch (G__28874) {
case 1:
return portfolio.components.paredit.backward_down.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.backward_down.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.backward_down', portfolio.components.paredit.backward_down);

(portfolio.components.paredit.backward_down.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.backward_down.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.backward_down.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var temp__5804__auto__ = cljs.core.trampoline.call(null,portfolio.components.paredit.bkwd_down,cm,cur,portfolio.components.paredit.char_count.call(null,cm));
if(cljs.core.truth_(temp__5804__auto__)){
var cur_SINGLEQUOTE_ = temp__5804__auto__;
return cm.setCursor(cur_SINGLEQUOTE_);
} else {
return null;
}
}));

(portfolio.components.paredit.backward_down.cljs$lang$maxFixedArity = 2);

/**
 * trampolin-able that looks for an ancestor opening bracket (parent,
 *   grandparent, etc) that has a sibling to slurp. returns a vector of the cur to
 *   the left of such a bracket, the cur to the left of the sibling that will be
 *   slurped, the string of the bracket to move. nil if there is no such anscestor
 *   that can slurp.
 */
portfolio.components.paredit.bkwd_slurp = (function portfolio$components$paredit$bkwd_slurp(cm,cur,n){
if((n >= (0))){
var ending = portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp,cur);
var parent = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,ending);
var sibling = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,parent);
var bracket_cur = portfolio.components.paredit.forward_down_cur.call(null,cm,parent);
if((((!((sibling == null)))) && ((!((bracket_cur == null)))))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [parent,sibling,portfolio.components.paredit.get_string.call(null,cm,bracket_cur)], null);
} else {
return (function (){
return portfolio.components.paredit.bkwd_slurp.call(null,cm,parent,(n - (1)));
});
}
} else {
return null;
}
});
/**
 * paredit backward-slurp-sexp exposed for keymap.
 */
portfolio.components.paredit.backward_slurp_sexp = (function portfolio$components$paredit$backward_slurp_sexp(var_args){
var G__28877 = arguments.length;
switch (G__28877) {
case 1:
return portfolio.components.paredit.backward_slurp_sexp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.backward_slurp_sexp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.backward_slurp_sexp', portfolio.components.paredit.backward_slurp_sexp);

(portfolio.components.paredit.backward_slurp_sexp.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.backward_slurp_sexp.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.backward_slurp_sexp.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var i = portfolio.components.paredit.index.call(null,cm,cur);
var temp__5804__auto___28882 = cljs.core.trampoline.call(null,portfolio.components.paredit.bkwd_slurp,cm,cur,portfolio.components.paredit.char_count.call(null,cm));
if(cljs.core.truth_(temp__5804__auto___28882)){
var vec__28878_28883 = temp__5804__auto___28882;
var parent_28884 = cljs.core.nth.call(null,vec__28878_28883,(0),null);
var sibling_28885 = cljs.core.nth.call(null,vec__28878_28883,(1),null);
var bracket_28886 = cljs.core.nth.call(null,vec__28878_28883,(2),null);
cm.replaceRange("",parent_28884,portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,parent_28884) + cljs.core.count.call(null,bracket_28886))));

portfolio.components.paredit.insert.call(null,cm,bracket_28886,(0),sibling_28885);
} else {
}

return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,i));
}));

(portfolio.components.paredit.backward_slurp_sexp.cljs$lang$maxFixedArity = 2);

/**
 * trampoline-able that looks for an ancestor closing bracket (parent,
 *   grandparent, etc) that has a sibling to barf. returns a vector of
 *   the cur to the right of such a bracket, the cur at the bracket, the
 *   cur where the bracket should go, the text of the bracket, and
 *   whether the operation causes the cursor to be moved. nil if there is
 *   no such anscestor that can barf
 */
portfolio.components.paredit.fwd_barf = (function portfolio$components$paredit$fwd_barf(cm,cur,n){
if((n >= (0))){
var parent = portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp,cur);
var inside = portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,parent) - (1)));
var sibling = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,inside);
var prevsib = portfolio.components.paredit.end_of_next_sibling.call(null,cm,portfolio.components.paredit.start_of_prev_sibling.call(null,cm,sibling));
var bracket_cur = (function (){var or__5045__auto__ = prevsib;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return portfolio.components.paredit.forward_down_cur.call(null,cm,portfolio.components.paredit.backward_up_cur.call(null,cm,sibling));
}
})();
var moved = (function (){var and__5043__auto__ = bracket_cur;
if(cljs.core.truth_(and__5043__auto__)){
return (portfolio.components.paredit.index.call(null,cm,bracket_cur) < portfolio.components.paredit.index.call(null,cm,cur));
} else {
return and__5043__auto__;
}
})();
var bracket = (cljs.core.truth_(parent)?(cljs.core.truth_(moved)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(portfolio.components.paredit.get_string.call(null,cm,parent))," "].join(''):portfolio.components.paredit.get_string.call(null,cm,parent)):null);
if((parent == null)){
return null;
} else {
if((bracket_cur == null)){
return (function (){
return portfolio.components.paredit.fwd_barf.call(null,cm,parent,(n - (1)));
});
} else {
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [parent,inside,bracket_cur,bracket,moved], null);

}
}
} else {
return null;
}
});
/**
 * paredit forward-barf-sexp exposed for keymap.
 */
portfolio.components.paredit.forward_barf_sexp = (function portfolio$components$paredit$forward_barf_sexp(var_args){
var G__28888 = arguments.length;
switch (G__28888) {
case 1:
return portfolio.components.paredit.forward_barf_sexp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.forward_barf_sexp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.forward_barf_sexp', portfolio.components.paredit.forward_barf_sexp);

(portfolio.components.paredit.forward_barf_sexp.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.forward_barf_sexp.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.forward_barf_sexp.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var temp__5802__auto__ = cljs.core.trampoline.call(null,portfolio.components.paredit.fwd_barf,cm,cur,portfolio.components.paredit.char_count.call(null,cm));
if(cljs.core.truth_(temp__5802__auto__)){
var vec__28889 = temp__5802__auto__;
var parent = cljs.core.nth.call(null,vec__28889,(0),null);
var inside = cljs.core.nth.call(null,vec__28889,(1),null);
var sibling = cljs.core.nth.call(null,vec__28889,(2),null);
var bracket = cljs.core.nth.call(null,vec__28889,(3),null);
var moved = cljs.core.nth.call(null,vec__28889,(4),null);
cm.replaceRange("",inside,parent);

portfolio.components.paredit.insert.call(null,cm,bracket,(0),sibling);

if(cljs.core.truth_(moved)){
return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,cur) + cljs.core.count.call(null,bracket))));
} else {
return cm.setCursor(cur);
}
} else {
return cm.setCursor(cur);
}
}));

(portfolio.components.paredit.forward_barf_sexp.cljs$lang$maxFixedArity = 2);

/**
 * trampoline-able that looks for an ancestor opening bracket (parent,
 *   grandparent, etc) that has a sibling to barf. returns... . nil if
 *   there is no such anscestor that can barf
 */
portfolio.components.paredit.bkwd_barf = (function portfolio$components$paredit$bkwd_barf(cm,cur,n){
if((n >= (0))){
var outside = portfolio.components.paredit.backward_up_cur.call(null,cm,cur);
var inside = portfolio.components.paredit.forward_down_cur.call(null,cm,outside);
var end_of_barfed_sexp = portfolio.components.paredit.end_of_next_sibling.call(null,cm,inside);
var end_of_new_first_sib = portfolio.components.paredit.end_of_next_sibling.call(null,cm,end_of_barfed_sexp);
var bracket_cur = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,end_of_new_first_sib);
var bracket_text = portfolio.components.paredit.get_string.call(null,cm,inside);
var moved = (function (){var and__5043__auto__ = bracket_cur;
if(cljs.core.truth_(and__5043__auto__)){
return (portfolio.components.paredit.index.call(null,cm,cur) < portfolio.components.paredit.index.call(null,cm,bracket_cur));
} else {
return and__5043__auto__;
}
})();
if((outside == null)){
return null;
} else {
if((end_of_barfed_sexp == null)){
return (function (){
return portfolio.components.paredit.bkwd_barf.call(null,cm,outside,(n - (1)));
});
} else {
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [outside,inside,bracket_cur,bracket_text,moved], null);

}
}
} else {
return null;
}
});
/**
 * paredit backward-barf-sexp exposed for keymap.
 */
portfolio.components.paredit.backward_barf_sexp = (function portfolio$components$paredit$backward_barf_sexp(var_args){
var G__28894 = arguments.length;
switch (G__28894) {
case 1:
return portfolio.components.paredit.backward_barf_sexp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.backward_barf_sexp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.backward_barf_sexp', portfolio.components.paredit.backward_barf_sexp);

(portfolio.components.paredit.backward_barf_sexp.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.backward_barf_sexp.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.backward_barf_sexp.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var temp__5802__auto__ = cljs.core.trampoline.call(null,portfolio.components.paredit.bkwd_barf,cm,cur,portfolio.components.paredit.char_count.call(null,cm));
if(cljs.core.truth_(temp__5802__auto__)){
var vec__28895 = temp__5802__auto__;
var outside = cljs.core.nth.call(null,vec__28895,(0),null);
var inside = cljs.core.nth.call(null,vec__28895,(1),null);
var bracket_cur = cljs.core.nth.call(null,vec__28895,(2),null);
var bracket_text = cljs.core.nth.call(null,vec__28895,(3),null);
var moved = cljs.core.nth.call(null,vec__28895,(4),null);
portfolio.components.paredit.insert.call(null,cm,bracket_text,(0),bracket_cur);

cm.replaceRange("",outside,inside);

if(cljs.core.truth_(moved)){
return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,cur) - cljs.core.count.call(null,bracket_text))));
} else {
return cm.setCursor(cur);
}
} else {
return cm.setCursor(cur);
}
}));

(portfolio.components.paredit.backward_barf_sexp.cljs$lang$maxFixedArity = 2);

/**
 * split sexp for (forms like this)
 */
portfolio.components.paredit.split_form = (function portfolio$components$paredit$split_form(cm,cur){
var close_cur = portfolio.components.paredit.skip.call(null,cm,portfolio.components.paredit.parent_closer_sp,cur);
var close_bracket = portfolio.components.paredit.get_string.call(null,cm,close_cur);
var open_cur = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,close_cur);
var open_bracket = portfolio.components.paredit.get_string.call(null,cm,portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,open_cur) + (1))));
if((((!((open_bracket == null)))) && ((!((close_bracket == null)))))){
cm.setCursor(cur);

var offset = ((portfolio.components.paredit.in_whitespace_QMARK_.call(null,cm))?(1):(function (){
portfolio.components.paredit.insert.call(null,cm," ");

portfolio.components.paredit.just_one_space.call(null,cm,portfolio.components.paredit.cursor.call(null,cm),false);

return (0);
})()
);
var cur_SINGLEQUOTE_ = portfolio.components.paredit.cursor.call(null,cm);
var i_SINGLEQUOTE_ = (portfolio.components.paredit.index.call(null,cm,cur_SINGLEQUOTE_) + offset);
var prev_sib = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur_SINGLEQUOTE_);
var prev_sib_end = portfolio.components.paredit.end_of_next_sibling.call(null,cm,prev_sib);
var next_sib = portfolio.components.paredit.end_of_next_sibling.call(null,cm,cur);
var next_sib_start = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,next_sib);
if((next_sib_start == null)){
portfolio.components.paredit.insert.call(null,cm,open_bracket);
} else {
portfolio.components.paredit.insert.call(null,cm,open_bracket,(0),next_sib_start);
}

if((prev_sib_end == null)){
portfolio.components.paredit.move_left.call(null,cm);

portfolio.components.paredit.insert.call(null,cm,close_bracket);
} else {
portfolio.components.paredit.insert.call(null,cm,close_bracket,(0),prev_sib_end);
}

return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,i_SINGLEQUOTE_));
} else {
return null;
}
});
/**
 * split sexp for "strings like this"
 */
portfolio.components.paredit.split_string = (function portfolio$components$paredit$split_string(cm,cur){
var open_quote_i = portfolio.components.paredit.index_of_next_non.call(null,cm,portfolio.components.paredit.index.call(null,cm,cur)," ");
cm.replaceRange("\" \"",cur,portfolio.components.paredit.cursor.call(null,cm,open_quote_i));

portfolio.components.paredit.move_left.call(null,cm);

return portfolio.components.paredit.move_left.call(null,cm);
});
/**
 * paredit split-sexp exposed for keymap.
 */
portfolio.components.paredit.split_sexp = (function portfolio$components$paredit$split_sexp(var_args){
var G__28900 = arguments.length;
switch (G__28900) {
case 1:
return portfolio.components.paredit.split_sexp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.split_sexp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.split_sexp', portfolio.components.paredit.split_sexp);

(portfolio.components.paredit.split_sexp.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.split_sexp.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.split_sexp.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
if(portfolio.components.paredit.in_string_QMARK_.call(null,cm,cur)){
return portfolio.components.paredit.split_string.call(null,cm,cur);
} else {
return portfolio.components.paredit.split_form.call(null,cm,cur);
}
}));

(portfolio.components.paredit.split_sexp.cljs$lang$maxFixedArity = 2);

/**
 * paredit join-sexps exposed for keymap.
 */
portfolio.components.paredit.join_sexps = (function portfolio$components$paredit$join_sexps(var_args){
var G__28903 = arguments.length;
switch (G__28903) {
case 1:
return portfolio.components.paredit.join_sexps.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.join_sexps.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.join_sexps', portfolio.components.paredit.join_sexps);

(portfolio.components.paredit.join_sexps.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.join_sexps.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.join_sexps.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var left_sib = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur);
var close = portfolio.components.paredit.end_of_next_sibling.call(null,cm,left_sib);
var right_sib = portfolio.components.paredit.end_of_next_sibling.call(null,cm,cur);
var open = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,right_sib);
var open_right = (cljs.core.truth_(open)?portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,open) + (1))):null);
var close_char = portfolio.components.paredit.get_string.call(null,cm,close);
var open_char = portfolio.components.paredit.get_string.call(null,cm,open_right);
if((((!((open == null)))) && ((((!((close == null)))) && (portfolio.components.paredit.pair_QMARK_.call(null,open_char,close_char)))))){
cm.setCursor(open);

portfolio.components.paredit.delete$.call(null,cm);

cm.setCursor(close);

portfolio.components.paredit.backspace.call(null,cm);

return cm.setCursor(((cljs.core._EQ_.call(null,open.line,close.line))?portfolio.components.paredit.cursor.call(null,cm,(portfolio.components.paredit.index.call(null,cm,cur) - (1))):cur));
} else {
return cm.setCursor(cur);
}
}));

(portfolio.components.paredit.join_sexps.cljs$lang$maxFixedArity = 2);

/**
 * trampoline-able that looks for the top-most opening bracket for the specified
 *   location. returns the current cursor if there is no such anscestor
 */
portfolio.components.paredit.top_most_opener_candidate = (function portfolio$components$paredit$top_most_opener_candidate(cm,cur,n){
if((n >= (0))){
var temp__5802__auto__ = portfolio.components.paredit.backward_up_cur.call(null,cm,cur);
if(cljs.core.truth_(temp__5802__auto__)){
var parent = temp__5802__auto__;
return (function (){
return portfolio.components.paredit.top_most_opener_candidate.call(null,cm,parent,(n - (1)));
});
} else {
return cur;
}
} else {
return null;
}
});
/**
 * get the top most opening bracket for the specified location. nil if
 *   there is no such bracket.
 */
portfolio.components.paredit.top_most_opener = (function portfolio$components$paredit$top_most_opener(var_args){
var G__28906 = arguments.length;
switch (G__28906) {
case 1:
return portfolio.components.paredit.top_most_opener.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.top_most_opener.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.components.paredit.top_most_opener.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.top_most_opener.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.top_most_opener.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var candidate = portfolio.components.paredit.top_most_opener_candidate.call(null,cm,cur,portfolio.components.paredit.char_count.call(null,cm));
if(cljs.core.not_EQ_.call(null,candidate,cur)){
return candidate;
} else {
return null;
}
}));

(portfolio.components.paredit.top_most_opener.cljs$lang$maxFixedArity = 2);

/**
 * paredit reindent-defun exposed for keymap.
 */
portfolio.components.paredit.reindent_defun = (function portfolio$components$paredit$reindent_defun(var_args){
var G__28909 = arguments.length;
switch (G__28909) {
case 1:
return portfolio.components.paredit.reindent_defun.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.reindent_defun.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.reindent_defun', portfolio.components.paredit.reindent_defun);

(portfolio.components.paredit.reindent_defun.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.reindent_defun.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.reindent_defun.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var open = cljs.core.trampoline.call(null,portfolio.components.paredit.top_most_opener,cm,cur);
var close = portfolio.components.paredit.end_of_next_sibling.call(null,cm,open);
var open_line = (cljs.core.truth_(open)?open.line:null);
var line_offset = (cljs.core.truth_(open)?(cur.line - open_line):null);
var line_len = cljs.core.count.call(null,cm.getLine(cur.line));
var ch = cur.ch;
if((((!((open == null)))) && ((!((close == null)))))){
portfolio.components.paredit.indent_lines.call(null,cm,open.line,close.line);

cljs.core.repeatedly.call(null,line_offset,cm.execCommand("goLineDown"));

cm.execCommand("goLineStart");

return cm.setCursor(portfolio.components.paredit.cursor.call(null,cm,((portfolio.components.paredit.index.call(null,cm) + ch) + (cljs.core.count.call(null,cm.getLine(portfolio.components.paredit.cursor.call(null,cm).line)) - line_len))));
} else {
return null;
}
}));

(portfolio.components.paredit.reindent_defun.cljs$lang$maxFixedArity = 2);

/**
 * forward-sexp exposed for keymap. seems part of emacs and not part
 *   of paredit itself. but including it here since this will be used in
 *   things other than emacs itself.
 */
portfolio.components.paredit.forward_sexp = (function portfolio$components$paredit$forward_sexp(var_args){
var G__28912 = arguments.length;
switch (G__28912) {
case 1:
return portfolio.components.paredit.forward_sexp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.forward_sexp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.forward_sexp', portfolio.components.paredit.forward_sexp);

(portfolio.components.paredit.forward_sexp.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.forward_sexp.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.forward_sexp.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var temp__5804__auto__ = portfolio.components.paredit.end_of_next_sibling.call(null,cm,cur);
if(cljs.core.truth_(temp__5804__auto__)){
var cur_SINGLEQUOTE_ = temp__5804__auto__;
return cm.setCursor(cur_SINGLEQUOTE_);
} else {
return null;
}
}));

(portfolio.components.paredit.forward_sexp.cljs$lang$maxFixedArity = 2);

/**
 * backward-sexp exposed for keymap. seems part of emacs and not part
 *   of paredit itself. but including it here since this will be used in
 *   things other than emacs itself.
 */
portfolio.components.paredit.backward_sexp = (function portfolio$components$paredit$backward_sexp(var_args){
var G__28915 = arguments.length;
switch (G__28915) {
case 1:
return portfolio.components.paredit.backward_sexp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return portfolio.components.paredit.backward_sexp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('portfolio.components.paredit.backward_sexp', portfolio.components.paredit.backward_sexp);

(portfolio.components.paredit.backward_sexp.cljs$core$IFn$_invoke$arity$1 = (function (cm){
return portfolio.components.paredit.backward_sexp.call(null,cm,portfolio.components.paredit.cursor.call(null,cm));
}));

(portfolio.components.paredit.backward_sexp.cljs$core$IFn$_invoke$arity$2 = (function (cm,cur){
var temp__5804__auto__ = portfolio.components.paredit.start_of_prev_sibling.call(null,cm,cur);
if(cljs.core.truth_(temp__5804__auto__)){
var cur_SINGLEQUOTE_ = temp__5804__auto__;
return cm.setCursor(cur_SINGLEQUOTE_);
} else {
return null;
}
}));

(portfolio.components.paredit.backward_sexp.cljs$lang$maxFixedArity = 2);

portfolio.components.paredit.keymap = cljs.core.PersistentHashMap.fromArrays(["Alt-s","]","Shift-Ctrl-[","Backspace","Shift-Ctrl-b","Ctrl-Alt-d","Shift-Alt-8","\"","Shift-[","Shift-Ctrl-0","Alt-r","Shift-Ctrl-f","Ctrl-Alt-n","Ctrl-Alt-p","Shift-2","Ctrl-Alt-b","Alt-Up","Delete","Alt-8",new cljs.core.Keyword(null,"fallthrough","fallthrough",567425038),"Ctrl-Alt-f","Ctrl-Backspace","Alt-q","Shift-Alt-s","Shift-Alt-0","Ctrl-Alt-u","Ctrl-Delete","Shift-]","Ctrl-k","Shift-9","Shift-Alt-;","Shift-Ctrl-]","Alt-d","Shift-0","Shift-Alt-9","[","Alt-Down","Alt-9","Alt-Backspace","Shift-Alt-'","Shift-Ctrl-9","Shift-Alt-j"],[portfolio.components.paredit.splice_sexp,portfolio.components.paredit.close_square,portfolio.components.paredit.backward_barf_sexp,portfolio.components.paredit.backward_delete,portfolio.components.paredit.backward_sexp,portfolio.components.paredit.forward_down,portfolio.components.paredit.open_brace,portfolio.components.paredit.open_quote,portfolio.components.paredit.open_brace,portfolio.components.paredit.forward_slurp_sexp,portfolio.components.paredit.raise_sexp,portfolio.components.paredit.forward_sexp,portfolio.components.paredit.forward_up,portfolio.components.paredit.backward_down,portfolio.components.paredit.open_quote,portfolio.components.paredit.backward,portfolio.components.paredit.splice_sexp_killing_backward,portfolio.components.paredit.forward_delete,portfolio.components.paredit.open_square,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["basic","emacs"], null),portfolio.components.paredit.forward,portfolio.components.paredit.backward_kill_word,portfolio.components.paredit.reindent_defun,portfolio.components.paredit.split_sexp,portfolio.components.paredit.close_round_and_newline,portfolio.components.paredit.backward_up,portfolio.components.paredit.forward_kill_word,portfolio.components.paredit.close_brace,portfolio.components.paredit.kill,portfolio.components.paredit.open_round,portfolio.components.paredit.comment_dwim,portfolio.components.paredit.forward_barf_sexp,portfolio.components.paredit.forward_kill_word,portfolio.components.paredit.close_round,portfolio.components.paredit.open_brace,portfolio.components.paredit.open_square,portfolio.components.paredit.splice_sexp_killing_forward,portfolio.components.paredit.open_square,portfolio.components.paredit.backward_kill_word,portfolio.components.paredit.meta_doublequote,portfolio.components.paredit.backward_slurp_sexp,portfolio.components.paredit.join_sexps]);

//# sourceMappingURL=paredit.js.map
