// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('portfolio.actions');
goog.require('cljs.core');
goog.require('clojure.walk');
goog.require('portfolio.core');
goog.require('portfolio.css');
goog.require('portfolio.router');
/**
 * Takes a map and pairs of path value to assoc-in to the map. Makes `assoc-in`
 *   work like `assoc`, e.g.:
 * 
 *   ```clj
 *   (assoc-in* {}
 *           [:person :name] "Christian"
 *           [:person :language] "Clojure")
 *   ;;=>
 *   {:person {:name "Christian"
 *          :language "Clojure"}}
 *   ```
 */
portfolio.actions.assoc_in_STAR_ = (function portfolio$actions$assoc_in_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42396 = arguments.length;
var i__5770__auto___42397 = (0);
while(true){
if((i__5770__auto___42397 < len__5769__auto___42396)){
args__5775__auto__.push((arguments[i__5770__auto___42397]));

var G__42398 = (i__5770__auto___42397 + (1));
i__5770__auto___42397 = G__42398;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return portfolio.actions.assoc_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(portfolio.actions.assoc_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (m,args){
if(cljs.core._EQ_.call(null,(0),cljs.core.mod.call(null,cljs.core.count.call(null,args),(2)))){
} else {
throw (new Error(["Assert failed: ","assoc-in* takes a map and pairs of path value","\n","(= 0 (mod (count args) 2))"].join('')));
}

if(cljs.core.every_QMARK_.call(null,cljs.core.vector_QMARK_,cljs.core.map.call(null,cljs.core.first,cljs.core.partition.call(null,(2),args)))){
} else {
throw (new Error(["Assert failed: ","each path should be a vector","\n","(->> args (partition 2) (map first) (every? vector?))"].join('')));
}

return cljs.core.reduce.call(null,(function (m__$1,p__42392){
var vec__42393 = p__42392;
var path = cljs.core.nth.call(null,vec__42393,(0),null);
var v = cljs.core.nth.call(null,vec__42393,(1),null);
return cljs.core.assoc_in.call(null,m__$1,path,v);
}),m,cljs.core.partition.call(null,(2),args));
}));

(portfolio.actions.assoc_in_STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(portfolio.actions.assoc_in_STAR_.cljs$lang$applyTo = (function (seq42390){
var G__42391 = cljs.core.first.call(null,seq42390);
var seq42390__$1 = cljs.core.next.call(null,seq42390);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42391,seq42390__$1);
}));

/**
 * Takes a map and paths to dissoc from it. An example explains it best:
 * 
 *   ```clj
 *   (dissoc-in* {:person {:name "Christian"
 *                      :language "Clojure"}}
 *            [:person :language])
 *   ;;=>
 *   {:person {:name "Christian"}}
 *   ```
 * 
 *   Optionally pass additional paths.
 *   
 */
portfolio.actions.dissoc_in_STAR_ = (function portfolio$actions$dissoc_in_STAR_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___42404 = arguments.length;
var i__5770__auto___42405 = (0);
while(true){
if((i__5770__auto___42405 < len__5769__auto___42404)){
args__5775__auto__.push((arguments[i__5770__auto___42405]));

var G__42406 = (i__5770__auto___42405 + (1));
i__5770__auto___42405 = G__42406;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return portfolio.actions.dissoc_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(portfolio.actions.dissoc_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (m,args){
return cljs.core.reduce.call(null,(function (m__$1,path){
if(cljs.core._EQ_.call(null,(0),cljs.core.count.call(null,path))){
return m__$1;
} else {
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,path))){
return cljs.core.dissoc.call(null,m__$1,cljs.core.first.call(null,path));
} else {
var vec__42401 = cljs.core.reverse.call(null,path);
var seq__42402 = cljs.core.seq.call(null,vec__42401);
var first__42403 = cljs.core.first.call(null,seq__42402);
var seq__42402__$1 = cljs.core.next.call(null,seq__42402);
var k = first__42403;
var ks = seq__42402__$1;
return cljs.core.update_in.call(null,m__$1,cljs.core.reverse.call(null,ks),cljs.core.dissoc,k);

}
}
}),m,args);
}));

(portfolio.actions.dissoc_in_STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(portfolio.actions.dissoc_in_STAR_.cljs$lang$applyTo = (function (seq42399){
var G__42400 = cljs.core.first.call(null,seq42399);
var seq42399__$1 = cljs.core.next.call(null,seq42399);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42400,seq42399__$1);
}));

portfolio.actions.atom_QMARK_ = (function portfolio$actions$atom_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IWatchable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IWatchable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IWatchable,x);
}
});
portfolio.actions.get_page_title = (function portfolio$actions$get_page_title(location){
var params = new cljs.core.Keyword(null,"query-params","query-params",900640534).cljs$core$IFn$_invoke$arity$1(location);
var scene = (cljs.core.truth_(new cljs.core.Keyword(null,"scene","scene",1523800415).cljs$core$IFn$_invoke$arity$1(params))?cljs.core.keyword.call(null,new cljs.core.Keyword(null,"scene","scene",1523800415).cljs$core$IFn$_invoke$arity$1(params)):null);
if(cljs.core.truth_(scene)){
return ["Scene: ",cljs.core.name.call(null,scene)," (",cljs.core.namespace.call(null,scene),") - Portfolio"].join('');
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(params))){
return ["Namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(params))," - Portfolio"].join('');
} else {
return null;
}
}
});
portfolio.actions.go_to_location = (function portfolio$actions$go_to_location(state,location){
var current_scenes = portfolio.core.get_current_scenes.call(null,state,new cljs.core.Keyword(null,"location","location",1815599388).cljs$core$IFn$_invoke$arity$1(state));
var next_scenes = portfolio.core.get_current_scenes.call(null,state,location);
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"location","location",1815599388)], null),location], null),new cljs.core.Keyword(null,"fns","fns",1185138786),cljs.core.concat.call(null,cljs.core.map.call(null,(function (p__42408){
var map__42409 = p__42408;
var map__42409__$1 = cljs.core.__destructure_map.call(null,map__42409);
var on_unmount = cljs.core.get.call(null,map__42409__$1,new cljs.core.Keyword(null,"on-unmount","on-unmount",245689269));
var param = cljs.core.get.call(null,map__42409__$1,new cljs.core.Keyword(null,"param","param",2013631823));
var id = cljs.core.get.call(null,map__42409__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var title = cljs.core.get.call(null,map__42409__$1,new cljs.core.Keyword(null,"title","title",636505583));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-unmount","on-unmount",245689269),(function (){var or__5045__auto__ = id;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return title;
}
})(),on_unmount,param], null);
}),cljs.core.filter.call(null,new cljs.core.Keyword(null,"on-unmount","on-unmount",245689269),current_scenes)),cljs.core.map.call(null,(function (p__42410){
var map__42411 = p__42410;
var map__42411__$1 = cljs.core.__destructure_map.call(null,map__42411);
var on_mount = cljs.core.get.call(null,map__42411__$1,new cljs.core.Keyword(null,"on-mount","on-mount",-1236735840));
var param = cljs.core.get.call(null,map__42411__$1,new cljs.core.Keyword(null,"param","param",2013631823));
var id = cljs.core.get.call(null,map__42411__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var title = cljs.core.get.call(null,map__42411__$1,new cljs.core.Keyword(null,"title","title",636505583));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"on-mount","on-mount",-1236735840),(function (){var or__5045__auto__ = id;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return title;
}
})(),on_mount,param], null);
}),cljs.core.filter.call(null,new cljs.core.Keyword(null,"on-mount","on-mount",-1236735840),next_scenes))),new cljs.core.Keyword(null,"release","release",-1534371381),cljs.core.map.call(null,(function (ref){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ref,new cljs.core.Keyword("portfolio.actions","portfolio","portfolio.actions/portfolio",-1131433853)], null);
}),cljs.core.filter.call(null,portfolio.actions.atom_QMARK_,cljs.core.map.call(null,new cljs.core.Keyword(null,"param","param",2013631823),current_scenes))),new cljs.core.Keyword(null,"subscribe","subscribe",416253756),cljs.core.map.call(null,(function (p__42412){
var vec__42413 = p__42412;
var ref = cljs.core.nth.call(null,vec__42413,(0),null);
var scene = cljs.core.nth.call(null,vec__42413,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [ref,new cljs.core.Keyword("portfolio.actions","portfolio","portfolio.actions/portfolio",-1131433853),scene], null);
}),cljs.core.filter.call(null,cljs.core.comp.call(null,portfolio.actions.atom_QMARK_,cljs.core.first),cljs.core.map.call(null,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"param","param",2013631823),cljs.core.identity),next_scenes))),new cljs.core.Keyword(null,"set-page-title","set-page-title",-1142382407),portfolio.actions.get_page_title.call(null,location),new cljs.core.Keyword(null,"update-window-location","update-window-location",770004291),portfolio.router.get_url.call(null,location)], null);
});
portfolio.actions.remove_scene_param = (function portfolio$actions$remove_scene_param(var_args){
var G__42417 = arguments.length;
switch (G__42417) {
case 2:
return portfolio.actions.remove_scene_param.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return portfolio.actions.remove_scene_param.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.actions.remove_scene_param.cljs$core$IFn$_invoke$arity$2 = (function (state,scene_id){
var param = cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"scenes","scenes",-425219404),scene_id,new cljs.core.Keyword(null,"param","param",2013631823)], null));
if(cljs.core.map_QMARK_.call(null,param)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"actions","actions",-812656882),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"overrides","overrides",1738628867)], null)], null)], null)], null);
} else {
if(portfolio.actions.atom_QMARK_.call(null,param)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reset","reset",-800929946),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param,cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"original","original",-445386197)], null))], null),new cljs.core.Keyword(null,"actions","actions",-812656882),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"overrides","overrides",1738628867)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"original","original",-445386197)], null)], null)], null)], null);
} else {
return null;
}
}
}));

(portfolio.actions.remove_scene_param.cljs$core$IFn$_invoke$arity$3 = (function (state,scene_id,k){
var param = cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"scenes","scenes",-425219404),scene_id,new cljs.core.Keyword(null,"param","param",2013631823)], null));
if(cljs.core.map_QMARK_.call(null,param)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"actions","actions",-812656882),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"overrides","overrides",1738628867),k], null)], null)], null)], null);
} else {
if(portfolio.actions.atom_QMARK_.call(null,param)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"swap","swap",228675637),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [param,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"scenes","scenes",-425219404),scene_id,new cljs.core.Keyword(null,"original","original",-445386197),k], null))], null),new cljs.core.Keyword(null,"actions","actions",-812656882),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"overrides","overrides",1738628867),k], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"original","original",-445386197),k], null)], null)], null)], null);
} else {
return null;
}
}
}));

(portfolio.actions.remove_scene_param.cljs$lang$maxFixedArity = 3);

portfolio.actions.set_scene_param = (function portfolio$actions$set_scene_param(var_args){
var G__42420 = arguments.length;
switch (G__42420) {
case 3:
return portfolio.actions.set_scene_param.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return portfolio.actions.set_scene_param.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(portfolio.actions.set_scene_param.cljs$core$IFn$_invoke$arity$3 = (function (state,scene_id,v){
var param = cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"scenes","scenes",-425219404),scene_id,new cljs.core.Keyword(null,"param","param",2013631823)], null));
if(cljs.core.map_QMARK_.call(null,param)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"actions","actions",-812656882),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"overrides","overrides",1738628867)], null),v], null)], null)], null);
} else {
if(portfolio.actions.atom_QMARK_.call(null,param)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reset","reset",-800929946),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [param,v], null),new cljs.core.Keyword(null,"actions","actions",-812656882),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"overrides","overrides",1738628867)], null),v], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"original","original",-445386197)], null),cljs.core.deref.call(null,param)], null)], null)], null);
} else {
return null;
}
}
}));

(portfolio.actions.set_scene_param.cljs$core$IFn$_invoke$arity$4 = (function (state,scene_id,k,v){
var param = cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"scenes","scenes",-425219404),scene_id,new cljs.core.Keyword(null,"param","param",2013631823)], null));
if(cljs.core.map_QMARK_.call(null,param)){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"actions","actions",-812656882),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"overrides","overrides",1738628867),k], null),v], null)], null)], null);
} else {
if(portfolio.actions.atom_QMARK_.call(null,param)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"swap","swap",228675637),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [param,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),v], null),new cljs.core.Keyword(null,"actions","actions",-812656882),(function (){var G__42421 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"overrides","overrides",1738628867),k], null),v], null)], null);
if(cljs.core.not.call(null,cljs.core.get_in.call(null,state,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"original","original",-445386197),k], null)))){
return cljs.core.into.call(null,G__42421,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ui","ui",-469653645),scene_id,new cljs.core.Keyword(null,"original","original",-445386197),k], null),k.call(null,cljs.core.deref.call(null,param))], null)], null));
} else {
return G__42421;
}
})()], null);
} else {
return null;
}
}
}));

(portfolio.actions.set_scene_param.cljs$lang$maxFixedArity = 4);

portfolio.actions.process_action_result_BANG_ = (function portfolio$actions$process_action_result_BANG_(app,res){
var seq__42423_42481 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"release","release",-1534371381).cljs$core$IFn$_invoke$arity$1(res));
var chunk__42424_42482 = null;
var count__42425_42483 = (0);
var i__42426_42484 = (0);
while(true){
if((i__42426_42484 < count__42425_42483)){
var vec__42433_42485 = cljs.core._nth.call(null,chunk__42424_42482,i__42426_42484);
var ref_42486 = cljs.core.nth.call(null,vec__42433_42485,(0),null);
var k_42487 = cljs.core.nth.call(null,vec__42433_42485,(1),null);
cljs.core.println.call(null,"Stop watching atom",cljs.core.pr_str.call(null,ref_42486));

cljs.core.remove_watch.call(null,ref_42486,k_42487);


var G__42488 = seq__42423_42481;
var G__42489 = chunk__42424_42482;
var G__42490 = count__42425_42483;
var G__42491 = (i__42426_42484 + (1));
seq__42423_42481 = G__42488;
chunk__42424_42482 = G__42489;
count__42425_42483 = G__42490;
i__42426_42484 = G__42491;
continue;
} else {
var temp__5804__auto___42492 = cljs.core.seq.call(null,seq__42423_42481);
if(temp__5804__auto___42492){
var seq__42423_42493__$1 = temp__5804__auto___42492;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42423_42493__$1)){
var c__5568__auto___42494 = cljs.core.chunk_first.call(null,seq__42423_42493__$1);
var G__42495 = cljs.core.chunk_rest.call(null,seq__42423_42493__$1);
var G__42496 = c__5568__auto___42494;
var G__42497 = cljs.core.count.call(null,c__5568__auto___42494);
var G__42498 = (0);
seq__42423_42481 = G__42495;
chunk__42424_42482 = G__42496;
count__42425_42483 = G__42497;
i__42426_42484 = G__42498;
continue;
} else {
var vec__42436_42499 = cljs.core.first.call(null,seq__42423_42493__$1);
var ref_42500 = cljs.core.nth.call(null,vec__42436_42499,(0),null);
var k_42501 = cljs.core.nth.call(null,vec__42436_42499,(1),null);
cljs.core.println.call(null,"Stop watching atom",cljs.core.pr_str.call(null,ref_42500));

cljs.core.remove_watch.call(null,ref_42500,k_42501);


var G__42502 = cljs.core.next.call(null,seq__42423_42493__$1);
var G__42503 = null;
var G__42504 = (0);
var G__42505 = (0);
seq__42423_42481 = G__42502;
chunk__42424_42482 = G__42503;
count__42425_42483 = G__42504;
i__42426_42484 = G__42505;
continue;
}
} else {
}
}
break;
}

var seq__42439_42506 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"fns","fns",1185138786).cljs$core$IFn$_invoke$arity$1(res));
var chunk__42440_42507 = null;
var count__42441_42508 = (0);
var i__42442_42509 = (0);
while(true){
if((i__42442_42509 < count__42441_42508)){
var vec__42449_42510 = cljs.core._nth.call(null,chunk__42440_42507,i__42442_42509);
var seq__42450_42511 = cljs.core.seq.call(null,vec__42449_42510);
var first__42451_42512 = cljs.core.first.call(null,seq__42450_42511);
var seq__42450_42513__$1 = cljs.core.next.call(null,seq__42450_42511);
var k_42514 = first__42451_42512;
var first__42451_42515__$1 = cljs.core.first.call(null,seq__42450_42513__$1);
var seq__42450_42516__$2 = cljs.core.next.call(null,seq__42450_42513__$1);
var t_42517 = first__42451_42515__$1;
var first__42451_42518__$2 = cljs.core.first.call(null,seq__42450_42516__$2);
var seq__42450_42519__$3 = cljs.core.next.call(null,seq__42450_42516__$2);
var f_42520 = first__42451_42518__$2;
var args_42521 = seq__42450_42519__$3;
cljs.core.println.call(null,["Calling ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_42514)," on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(t_42517)," with"].join(''),cljs.core.pr_str.call(null,args_42521));

cljs.core.apply.call(null,f_42520,args_42521);


var G__42522 = seq__42439_42506;
var G__42523 = chunk__42440_42507;
var G__42524 = count__42441_42508;
var G__42525 = (i__42442_42509 + (1));
seq__42439_42506 = G__42522;
chunk__42440_42507 = G__42523;
count__42441_42508 = G__42524;
i__42442_42509 = G__42525;
continue;
} else {
var temp__5804__auto___42526 = cljs.core.seq.call(null,seq__42439_42506);
if(temp__5804__auto___42526){
var seq__42439_42527__$1 = temp__5804__auto___42526;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42439_42527__$1)){
var c__5568__auto___42528 = cljs.core.chunk_first.call(null,seq__42439_42527__$1);
var G__42529 = cljs.core.chunk_rest.call(null,seq__42439_42527__$1);
var G__42530 = c__5568__auto___42528;
var G__42531 = cljs.core.count.call(null,c__5568__auto___42528);
var G__42532 = (0);
seq__42439_42506 = G__42529;
chunk__42440_42507 = G__42530;
count__42441_42508 = G__42531;
i__42442_42509 = G__42532;
continue;
} else {
var vec__42452_42533 = cljs.core.first.call(null,seq__42439_42527__$1);
var seq__42453_42534 = cljs.core.seq.call(null,vec__42452_42533);
var first__42454_42535 = cljs.core.first.call(null,seq__42453_42534);
var seq__42453_42536__$1 = cljs.core.next.call(null,seq__42453_42534);
var k_42537 = first__42454_42535;
var first__42454_42538__$1 = cljs.core.first.call(null,seq__42453_42536__$1);
var seq__42453_42539__$2 = cljs.core.next.call(null,seq__42453_42536__$1);
var t_42540 = first__42454_42538__$1;
var first__42454_42541__$2 = cljs.core.first.call(null,seq__42453_42539__$2);
var seq__42453_42542__$3 = cljs.core.next.call(null,seq__42453_42539__$2);
var f_42543 = first__42454_42541__$2;
var args_42544 = seq__42453_42542__$3;
cljs.core.println.call(null,["Calling ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_42537)," on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(t_42540)," with"].join(''),cljs.core.pr_str.call(null,args_42544));

cljs.core.apply.call(null,f_42543,args_42544);


var G__42545 = cljs.core.next.call(null,seq__42439_42527__$1);
var G__42546 = null;
var G__42547 = (0);
var G__42548 = (0);
seq__42439_42506 = G__42545;
chunk__42440_42507 = G__42546;
count__42441_42508 = G__42547;
i__42442_42509 = G__42548;
continue;
}
} else {
}
}
break;
}

var seq__42455_42549 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"subscribe","subscribe",416253756).cljs$core$IFn$_invoke$arity$1(res));
var chunk__42456_42550 = null;
var count__42457_42551 = (0);
var i__42458_42552 = (0);
while(true){
if((i__42458_42552 < count__42457_42551)){
var vec__42465_42553 = cljs.core._nth.call(null,chunk__42456_42550,i__42458_42552);
var ref_42554 = cljs.core.nth.call(null,vec__42465_42553,(0),null);
var k_42555 = cljs.core.nth.call(null,vec__42465_42553,(1),null);
var scene_42556 = cljs.core.nth.call(null,vec__42465_42553,(2),null);
cljs.core.println.call(null,"Start watching atom",cljs.core.pr_str.call(null,ref_42554));

cljs.core.add_watch.call(null,ref_42554,k_42555,((function (seq__42455_42549,chunk__42456_42550,count__42457_42551,i__42458_42552,vec__42465_42553,ref_42554,k_42555,scene_42556){
return (function (_,___$1,___$2,___$3){
return cljs.core.swap_BANG_.call(null,app,cljs.core.update,new cljs.core.Keyword(null,"heartbeat","heartbeat",-1141780952),cljs.core.fnil.call(null,cljs.core.inc,(0)));
});})(seq__42455_42549,chunk__42456_42550,count__42457_42551,i__42458_42552,vec__42465_42553,ref_42554,k_42555,scene_42556))
);


var G__42557 = seq__42455_42549;
var G__42558 = chunk__42456_42550;
var G__42559 = count__42457_42551;
var G__42560 = (i__42458_42552 + (1));
seq__42455_42549 = G__42557;
chunk__42456_42550 = G__42558;
count__42457_42551 = G__42559;
i__42458_42552 = G__42560;
continue;
} else {
var temp__5804__auto___42561 = cljs.core.seq.call(null,seq__42455_42549);
if(temp__5804__auto___42561){
var seq__42455_42562__$1 = temp__5804__auto___42561;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42455_42562__$1)){
var c__5568__auto___42563 = cljs.core.chunk_first.call(null,seq__42455_42562__$1);
var G__42564 = cljs.core.chunk_rest.call(null,seq__42455_42562__$1);
var G__42565 = c__5568__auto___42563;
var G__42566 = cljs.core.count.call(null,c__5568__auto___42563);
var G__42567 = (0);
seq__42455_42549 = G__42564;
chunk__42456_42550 = G__42565;
count__42457_42551 = G__42566;
i__42458_42552 = G__42567;
continue;
} else {
var vec__42468_42568 = cljs.core.first.call(null,seq__42455_42562__$1);
var ref_42569 = cljs.core.nth.call(null,vec__42468_42568,(0),null);
var k_42570 = cljs.core.nth.call(null,vec__42468_42568,(1),null);
var scene_42571 = cljs.core.nth.call(null,vec__42468_42568,(2),null);
cljs.core.println.call(null,"Start watching atom",cljs.core.pr_str.call(null,ref_42569));

cljs.core.add_watch.call(null,ref_42569,k_42570,((function (seq__42455_42549,chunk__42456_42550,count__42457_42551,i__42458_42552,vec__42468_42568,ref_42569,k_42570,scene_42571,seq__42455_42562__$1,temp__5804__auto___42561){
return (function (_,___$1,___$2,___$3){
return cljs.core.swap_BANG_.call(null,app,cljs.core.update,new cljs.core.Keyword(null,"heartbeat","heartbeat",-1141780952),cljs.core.fnil.call(null,cljs.core.inc,(0)));
});})(seq__42455_42549,chunk__42456_42550,count__42457_42551,i__42458_42552,vec__42468_42568,ref_42569,k_42570,scene_42571,seq__42455_42562__$1,temp__5804__auto___42561))
);


var G__42572 = cljs.core.next.call(null,seq__42455_42562__$1);
var G__42573 = null;
var G__42574 = (0);
var G__42575 = (0);
seq__42455_42549 = G__42572;
chunk__42456_42550 = G__42573;
count__42457_42551 = G__42574;
i__42458_42552 = G__42575;
continue;
}
} else {
}
}
break;
}

var temp__5804__auto___42576 = new cljs.core.Keyword(null,"update-window-location","update-window-location",770004291).cljs$core$IFn$_invoke$arity$1(res);
if(cljs.core.truth_(temp__5804__auto___42576)){
var url_42577 = temp__5804__auto___42576;
if(cljs.core._EQ_.call(null,url_42577,portfolio.router.get_current_url.call(null))){
} else {
cljs.core.println.call(null,"Updating browser URL to",url_42577);

history.pushState(false,false,url_42577);
}
} else {
}

var temp__5804__auto___42578 = new cljs.core.Keyword(null,"set-page-title","set-page-title",-1142382407).cljs$core$IFn$_invoke$arity$1(res);
if(cljs.core.truth_(temp__5804__auto___42578)){
var title_42579 = temp__5804__auto___42578;
(document.title = title_42579);
} else {
}

if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806).cljs$core$IFn$_invoke$arity$1(res);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270).cljs$core$IFn$_invoke$arity$1(res);
}
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270).cljs$core$IFn$_invoke$arity$1(res))){
cljs.core.println.call(null,":assoc-in",cljs.core.pr_str.call(null,new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270).cljs$core$IFn$_invoke$arity$1(res)));
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806).cljs$core$IFn$_invoke$arity$1(res))){
cljs.core.println.call(null,":dissoc-in",cljs.core.pr_str.call(null,new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806).cljs$core$IFn$_invoke$arity$1(res)));
} else {
}

cljs.core.swap_BANG_.call(null,app,(function (state){
return cljs.core.apply.call(null,portfolio.actions.assoc_in_STAR_,cljs.core.apply.call(null,portfolio.actions.dissoc_in_STAR_,state,new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806).cljs$core$IFn$_invoke$arity$1(res)),new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270).cljs$core$IFn$_invoke$arity$1(res));
}));
} else {
}

var seq__42471_42580 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"actions","actions",-812656882).cljs$core$IFn$_invoke$arity$1(res));
var chunk__42472_42581 = null;
var count__42473_42582 = (0);
var i__42474_42583 = (0);
while(true){
if((i__42474_42583 < count__42473_42582)){
var action_42584 = cljs.core._nth.call(null,chunk__42472_42581,i__42474_42583);
portfolio.actions.execute_action_BANG_.call(null,app,action_42584);


var G__42585 = seq__42471_42580;
var G__42586 = chunk__42472_42581;
var G__42587 = count__42473_42582;
var G__42588 = (i__42474_42583 + (1));
seq__42471_42580 = G__42585;
chunk__42472_42581 = G__42586;
count__42473_42582 = G__42587;
i__42474_42583 = G__42588;
continue;
} else {
var temp__5804__auto___42589 = cljs.core.seq.call(null,seq__42471_42580);
if(temp__5804__auto___42589){
var seq__42471_42590__$1 = temp__5804__auto___42589;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42471_42590__$1)){
var c__5568__auto___42591 = cljs.core.chunk_first.call(null,seq__42471_42590__$1);
var G__42592 = cljs.core.chunk_rest.call(null,seq__42471_42590__$1);
var G__42593 = c__5568__auto___42591;
var G__42594 = cljs.core.count.call(null,c__5568__auto___42591);
var G__42595 = (0);
seq__42471_42580 = G__42592;
chunk__42472_42581 = G__42593;
count__42473_42582 = G__42594;
i__42474_42583 = G__42595;
continue;
} else {
var action_42596 = cljs.core.first.call(null,seq__42471_42590__$1);
portfolio.actions.execute_action_BANG_.call(null,app,action_42596);


var G__42597 = cljs.core.next.call(null,seq__42471_42590__$1);
var G__42598 = null;
var G__42599 = (0);
var G__42600 = (0);
seq__42471_42580 = G__42597;
chunk__42472_42581 = G__42598;
count__42473_42582 = G__42599;
i__42474_42583 = G__42600;
continue;
}
} else {
}
}
break;
}

var temp__5804__auto___42601 = new cljs.core.Keyword(null,"swap","swap",228675637).cljs$core$IFn$_invoke$arity$1(res);
if(cljs.core.truth_(temp__5804__auto___42601)){
var vec__42475_42602 = temp__5804__auto___42601;
var ref_42603 = cljs.core.nth.call(null,vec__42475_42602,(0),null);
var path_42604 = cljs.core.nth.call(null,vec__42475_42602,(1),null);
var v_42605 = cljs.core.nth.call(null,vec__42475_42602,(2),null);
cljs.core.swap_BANG_.call(null,ref_42603,cljs.core.assoc_in,path_42604,v_42605);
} else {
}

var temp__5804__auto___42606 = new cljs.core.Keyword(null,"reset","reset",-800929946).cljs$core$IFn$_invoke$arity$1(res);
if(cljs.core.truth_(temp__5804__auto___42606)){
var vec__42478_42607 = temp__5804__auto___42606;
var ref_42608 = cljs.core.nth.call(null,vec__42478_42607,(0),null);
var v_42609 = cljs.core.nth.call(null,vec__42478_42607,(1),null);
cljs.core.reset_BANG_.call(null,ref_42608,v_42609);
} else {
}

var temp__5804__auto___42610 = new cljs.core.Keyword(null,"load-css-files","load-css-files",-1144872475).cljs$core$IFn$_invoke$arity$1(res);
if(cljs.core.truth_(temp__5804__auto___42610)){
var paths_42611 = temp__5804__auto___42610;
portfolio.css.load_css_files.call(null,paths_42611);
} else {
}

var temp__5804__auto__ = new cljs.core.Keyword(null,"replace-css-files","replace-css-files",1438305968).cljs$core$IFn$_invoke$arity$1(res);
if(cljs.core.truth_(temp__5804__auto__)){
var paths = temp__5804__auto__;
return portfolio.css.replace_loaded_css_files.call(null,paths);
} else {
return null;
}
});
portfolio.actions.execute_action_BANG_ = (function portfolio$actions$execute_action_BANG_(app,action){
cljs.core.println.call(null,"execute-action!",action);

portfolio.actions.process_action_result_BANG_.call(null,app,(function (){var G__42612 = cljs.core.first.call(null,action);
var G__42612__$1 = (((G__42612 instanceof cljs.core.Keyword))?G__42612.fqn:null);
switch (G__42612__$1) {
case "assoc-in":
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),cljs.core.rest.call(null,action)], null);

break;
case "dissoc-in":
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806),cljs.core.rest.call(null,action)], null);

break;
case "fn/call":
var vec__42613 = cljs.core.rest.call(null,action);
var seq__42614 = cljs.core.seq.call(null,vec__42613);
var first__42615 = cljs.core.first.call(null,seq__42614);
var seq__42614__$1 = cljs.core.next.call(null,seq__42614);
var fn = first__42615;
var args = seq__42614__$1;
return cljs.core.apply.call(null,fn,args);

break;
case "go-to-location":
return cljs.core.apply.call(null,portfolio.actions.go_to_location,cljs.core.deref.call(null,app),cljs.core.rest.call(null,action));

break;
case "go-to-current-location":
return portfolio.actions.go_to_location.call(null,cljs.core.deref.call(null,app),portfolio.router.get_current_location.call(null));

break;
case "set-css-files":
var vec__42616 = cljs.core.rest.call(null,action);
var paths = cljs.core.nth.call(null,vec__42616,(0),null);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"css-paths","css-paths",582305563)], null),paths], null),new cljs.core.Keyword(null,"load-css-files","load-css-files",-1144872475),paths,new cljs.core.Keyword(null,"replace-css-files","replace-css-files",1438305968),paths], null);

break;
case "remove-scene-param":
return cljs.core.apply.call(null,portfolio.actions.remove_scene_param,cljs.core.deref.call(null,app),cljs.core.rest.call(null,action));

break;
case "set-scene-param":
return cljs.core.apply.call(null,portfolio.actions.set_scene_param,cljs.core.deref.call(null,app),cljs.core.rest.call(null,action));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__42612__$1)].join('')));

}
})());

return app;
});
portfolio.actions.available_actions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"assoc-in","assoc-in",-1754117270),null,new cljs.core.Keyword(null,"remove-scene-param","remove-scene-param",-1304315187),null,new cljs.core.Keyword(null,"go-to-current-location","go-to-current-location",1620881583),null,new cljs.core.Keyword(null,"set-scene-param","set-scene-param",234226032),null,new cljs.core.Keyword(null,"dissoc-in","dissoc-in",-1889884806),null,new cljs.core.Keyword(null,"go-to-location","go-to-location",-1047138405),null,new cljs.core.Keyword("fn","call","fn/call",-519998786),null], null), null);
portfolio.actions.actions_QMARK_ = (function portfolio$actions$actions_QMARK_(x){
return ((cljs.core.sequential_QMARK_.call(null,x)) && ((((!(cljs.core.empty_QMARK_.call(null,x)))) && (cljs.core.every_QMARK_.call(null,(function (p1__42620_SHARP_){
return ((cljs.core.sequential_QMARK_.call(null,p1__42620_SHARP_)) && (cljs.core.contains_QMARK_.call(null,portfolio.actions.available_actions,cljs.core.first.call(null,p1__42620_SHARP_))));
}),x)))));
});
portfolio.actions.parse_int = (function portfolio$actions$parse_int(s){
var n = parseInt(s,(10));
if(cljs.core.not_EQ_.call(null,n,n)){
return (0);
} else {
return n;
}
});
/**
 * Given a Portfolio `app` instance and some prepared data to render, wrap
 *   collections of actions in a function that executes these actions. Using this
 *   function makes it possible to prepare event handlers as a sequence of action
 *   tuples, and have them seemlessly emitted as actions in the components.
 * 
 *   If you need to access the `.-value` of the event target (e.g. for on-change on
 *   input fields, etc), use `:event.target/value` as a placeholder in your action,
 *   and it will be replaced with the value.
 */
portfolio.actions.actionize_data = (function portfolio$actions$actionize_data(app,data){
return clojure.walk.prewalk.call(null,(function (x){
if(portfolio.actions.actions_QMARK_.call(null,x)){
return (function (e){
var seq__42621 = cljs.core.seq.call(null,x);
var chunk__42622 = null;
var count__42623 = (0);
var i__42624 = (0);
while(true){
if((i__42624 < count__42623)){
var action = cljs.core._nth.call(null,chunk__42622,i__42624);
portfolio.actions.execute_action_BANG_.call(null,app,clojure.walk.prewalk.call(null,((function (seq__42621,chunk__42622,count__42623,i__42624,action){
return (function (ax){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("event.target","value","event.target/value",857030372),ax)){
var G__42629 = e;
var G__42629__$1 = (((G__42629 == null))?null:G__42629.target);
if((G__42629__$1 == null)){
return null;
} else {
return G__42629__$1.value;
}
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("event.target","number-value","event.target/number-value",-362876562),ax)){
var G__42630 = e;
var G__42630__$1 = (((G__42630 == null))?null:G__42630.target);
var G__42630__$2 = (((G__42630__$1 == null))?null:G__42630__$1.value);
if((G__42630__$2 == null)){
return null;
} else {
return portfolio.actions.parse_int.call(null,G__42630__$2);
}
} else {
return ax;

}
}
});})(seq__42621,chunk__42622,count__42623,i__42624,action))
,action));


var G__42633 = seq__42621;
var G__42634 = chunk__42622;
var G__42635 = count__42623;
var G__42636 = (i__42624 + (1));
seq__42621 = G__42633;
chunk__42622 = G__42634;
count__42623 = G__42635;
i__42624 = G__42636;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq.call(null,seq__42621);
if(temp__5804__auto__){
var seq__42621__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__42621__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__42621__$1);
var G__42637 = cljs.core.chunk_rest.call(null,seq__42621__$1);
var G__42638 = c__5568__auto__;
var G__42639 = cljs.core.count.call(null,c__5568__auto__);
var G__42640 = (0);
seq__42621 = G__42637;
chunk__42622 = G__42638;
count__42623 = G__42639;
i__42624 = G__42640;
continue;
} else {
var action = cljs.core.first.call(null,seq__42621__$1);
portfolio.actions.execute_action_BANG_.call(null,app,clojure.walk.prewalk.call(null,((function (seq__42621,chunk__42622,count__42623,i__42624,action,seq__42621__$1,temp__5804__auto__){
return (function (ax){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("event.target","value","event.target/value",857030372),ax)){
var G__42631 = e;
var G__42631__$1 = (((G__42631 == null))?null:G__42631.target);
if((G__42631__$1 == null)){
return null;
} else {
return G__42631__$1.value;
}
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("event.target","number-value","event.target/number-value",-362876562),ax)){
var G__42632 = e;
var G__42632__$1 = (((G__42632 == null))?null:G__42632.target);
var G__42632__$2 = (((G__42632__$1 == null))?null:G__42632__$1.value);
if((G__42632__$2 == null)){
return null;
} else {
return portfolio.actions.parse_int.call(null,G__42632__$2);
}
} else {
return ax;

}
}
});})(seq__42621,chunk__42622,count__42623,i__42624,action,seq__42621__$1,temp__5804__auto__))
,action));


var G__42641 = cljs.core.next.call(null,seq__42621__$1);
var G__42642 = null;
var G__42643 = (0);
var G__42644 = (0);
seq__42621 = G__42641;
chunk__42622 = G__42642;
count__42623 = G__42643;
i__42624 = G__42644;
continue;
}
} else {
return null;
}
}
break;
}
});
} else {
return x;
}
}),data);
});

//# sourceMappingURL=actions.js.map
