// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('helix.impl.props');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs_bean.core');
goog.require('goog.object');
goog.scope(function(){
helix.impl.props.goog$module$goog$object = goog.module.get('goog.object');
});
helix.impl.props.aria_data_css_custom_prop_special_case_re = /^(aria-|data-|--).*/;
helix.impl.props.camel_regexp = RegExp("-(\\w)","g");
/**
 * Returns camel case version of the string, e.g. "http-equiv" becomes "httpEquiv".
 */
helix.impl.props.camel_case = (function helix$impl$props$camel_case(s){
if((((s instanceof cljs.core.Keyword)) || (((typeof s === 'string') || ((s instanceof cljs.core.Symbol)))))){
var name_str = cljs.core.name.call(null,s);
if((!((name_str.match(helix.impl.props.aria_data_css_custom_prop_special_case_re) == null)))){
return name_str;
} else {
if(cljs.core._EQ_.call(null,name_str.substring((0),(1)),"'")){
return name_str.substring((1));
} else {
return name_str.replace(helix.impl.props.camel_regexp,(function (p1__21514_SHARP_,p2__21513_SHARP_){
return p2__21513_SHARP_.toUpperCase();
}));

}
}
} else {
return s;
}
});
helix.impl.props.kw__GT_str = (function helix$impl$props$kw__GT_str(kw){
var kw_ns = cljs.core.namespace.call(null,kw);
var kw_name = cljs.core.name.call(null,kw);
if((kw_ns == null)){
return kw_name;
} else {
return [kw_ns,"/",kw_name].join('');
}
});
helix.impl.props.set_obj = (function helix$impl$props$set_obj(o,k,v){
var G__21515 = o;
helix.impl.props.goog$module$goog$object.set.call(null,G__21515,k,v);

return G__21515;
});
helix.impl.props.__GT_js = (function helix$impl$props$__GT_js(x){
return cljs.core.clj__GT_js.call(null,x,new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),cljs.core.comp.call(null,helix.impl.props.camel_case,cljs.core.name));
});
helix.impl.props.primitive_obj = (function helix$impl$props$primitive_obj(var_args){
var G__21517 = arguments.length;
switch (G__21517) {
case 0:
return helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return ({});
}));

(helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$1 = (function (m){
return helix.impl.props.primitive_obj.call(null,m,helix.impl.props.primitive_obj.call(null));
}));

(helix.impl.props.primitive_obj.cljs$core$IFn$_invoke$arity$2 = (function (m,o){
while(true){
if(cljs.core.seq.call(null,m)){
var G__21519 = cljs.core.rest.call(null,m);
var G__21520 = (function (){var entry = cljs.core.first.call(null,m);
return helix.impl.props.set_obj.call(null,o,helix.impl.props.camel_case.call(null,helix.impl.props.kw__GT_str.call(null,cljs.core.key.call(null,entry))),helix.impl.props.__GT_js.call(null,cljs.core.val.call(null,entry)));
})();
m = G__21519;
o = G__21520;
continue;
} else {
return o;
}
break;
}
}));

(helix.impl.props.primitive_obj.cljs$lang$maxFixedArity = 2);

helix.impl.props.into_js_array = (function helix$impl$props$into_js_array(aseq){
return cljs.core.into_array.call(null,aseq);
});
helix.impl.props.merge_obj = (function helix$impl$props$merge_obj(o1,o2){
if((o2 == null)){
return o1;
} else {
var G__21521 = o1;
helix.impl.props.goog$module$goog$object.extend.call(null,G__21521,o2);

return G__21521;
}
});
helix.impl.props.seq_to_class = (function helix$impl$props$seq_to_class(class$){
return clojure.string.join.call(null," ",cljs.core.map.call(null,cljs.core.str,cljs.core.remove.call(null,cljs.core.nil_QMARK_,class$)));
});
helix.impl.props.normalize_class = (function helix$impl$props$normalize_class(class$){
if(typeof class$ === 'string'){
return class$;
} else {
if(cljs.core.sequential_QMARK_.call(null,class$)){
return helix.impl.props.seq_to_class.call(null,class$);
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(class$);

}
}
});
helix.impl.props.or_undefined = (function helix$impl$props$or_undefined(v){
if((v == null)){
return undefined;
} else {
return v;
}
});
helix.impl.props.dom_style = (function helix$impl$props$dom_style(style){
if(cljs.core.map_QMARK_.call(null,style)){
return helix.impl.props.primitive_obj.call(null,style);
} else {
if(cljs.core.vector_QMARK_.call(null,style)){
return helix.impl.props.into_js_array.call(null,cljs.core.map.call(null,(function (p1__21522_SHARP_){
if(cljs.core.map_QMARK_.call(null,p1__21522_SHARP_)){
return helix.impl.props.primitive_obj.call(null,p1__21522_SHARP_);
} else {
return p1__21522_SHARP_;
}
}),style));
} else {
return style;

}
}
});
helix.impl.props._dom_props = (function helix$impl$props$_dom_props(var_args){
var G__21524 = arguments.length;
switch (G__21524) {
case 1:
return helix.impl.props._dom_props.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.impl.props._dom_props.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.impl.props._dom_props.cljs$core$IFn$_invoke$arity$1 = (function (m){
if(cljs.core.map_QMARK_.call(null,m)){
return helix.impl.props._dom_props.call(null,m,helix.impl.props.primitive_obj.call(null));
} else {
return m;
}
}));

(helix.impl.props._dom_props.cljs$core$IFn$_invoke$arity$2 = (function (m,o){
while(true){
if(cljs.core.seq.call(null,m)){
var G__21527 = cljs.core.rest.call(null,m);
var G__21528 = (function (){var entry = cljs.core.first.call(null,m);
var k = cljs.core.key.call(null,entry);
var v = cljs.core.val.call(null,entry);
var G__21525 = k;
var G__21525__$1 = (((G__21525 instanceof cljs.core.Keyword))?G__21525.fqn:null);
switch (G__21525__$1) {
case "class":
return helix.impl.props.set_obj.call(null,o,"className",helix.impl.props.normalize_class.call(null,v));

break;
case "for":
return helix.impl.props.set_obj.call(null,o,"htmlFor",v);

break;
case "style":
return helix.impl.props.set_obj.call(null,o,"style",helix.impl.props.dom_style.call(null,v));

break;
case "value":
return helix.impl.props.set_obj.call(null,o,"value",helix.impl.props.or_undefined.call(null,v));

break;
default:
return helix.impl.props.set_obj.call(null,o,helix.impl.props.camel_case.call(null,helix.impl.props.kw__GT_str.call(null,k)),v);

}
})();
m = G__21527;
o = G__21528;
continue;
} else {
return o;
}
break;
}
}));

(helix.impl.props._dom_props.cljs$lang$maxFixedArity = 2);

var ret__5824__auto___21530 = helix.impl.props.dom_props = (function helix$impl$props$dom_props(_AMPERSAND_form,_AMPERSAND_env,m){
return helix.impl.props._dom_props.call(null,m);
});
(helix.impl.props.dom_props.cljs$lang$macro = true);

helix.impl.props._props = (function helix$impl$props$_props(var_args){
var G__21532 = arguments.length;
switch (G__21532) {
case 1:
return helix.impl.props._props.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.impl.props._props.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.impl.props._props.cljs$core$IFn$_invoke$arity$1 = (function (m){
if(cljs.core.map_QMARK_.call(null,m)){
return helix.impl.props._props.call(null,m,helix.impl.props.primitive_obj.call(null));
} else {
return m;
}
}));

(helix.impl.props._props.cljs$core$IFn$_invoke$arity$2 = (function (m,o){
while(true){
if(cljs.core.seq.call(null,m)){
var G__21534 = cljs.core.rest.call(null,m);
var G__21535 = (function (){var entry = cljs.core.first.call(null,m);
return helix.impl.props.set_obj.call(null,o,helix.impl.props.kw__GT_str.call(null,cljs.core.key.call(null,entry)),cljs.core.val.call(null,entry));
})();
m = G__21534;
o = G__21535;
continue;
} else {
return o;
}
break;
}
}));

(helix.impl.props._props.cljs$lang$maxFixedArity = 2);

var ret__5824__auto___21536 = helix.impl.props.props = (function helix$impl$props$props(_AMPERSAND_form,_AMPERSAND_env,m){
return helix.impl.props._props.call(null,m);
});
(helix.impl.props.props.cljs$lang$macro = true);


//# sourceMappingURL=props.js.map
