// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('helix.hooks');
goog.require('cljs.core');
goog.require('react');
goog.require('goog.object');
goog.scope(function(){
helix.hooks.goog$module$goog$object = goog.module.get('goog.object');
});
helix.hooks.global$module$react = goog.global["React"];
helix.hooks.raw_use_effect = helix.hooks.global$module$react.useEffect;

helix.hooks.raw_use_layout_effect = helix.hooks.global$module$react.useLayoutEffect;

helix.hooks.raw_use_memo = helix.hooks.global$module$react.useMemo;

helix.hooks.raw_use_callback = helix.hooks.global$module$react.useCallback;

helix.hooks.raw_use_imperative_handle = helix.hooks.global$module$react.useImperativeHandle;

/**
 * Protocol that marks a type as callable when passed to a use-state setter.
 * @interface
 */
helix.hooks.IStateUpdater = function(){};

(cljs.core.MultiFn.prototype.helix$hooks$IStateUpdater$ = cljs.core.PROTOCOL_SENTINEL);

(helix.hooks.IStateUpdater["function"] = true);
/**
 * Like `react/useState`, but the update function returned can be used similar
 *   to `swap!` if the first argument implements `IStateUpdater`.
 *   By default, this includes functions and multimethods.
 * 
 *   Example:
 *   ```
 *   (let [[state set-state] (use-state {:count 0})]
 * ;; ...
 * (set-state update :count inc))
 *   ```
 */
helix.hooks.use_state = (function helix$hooks$use_state(initial){
var vec__21889 = helix.hooks.global$module$react.useState(initial);
var v = cljs.core.nth.call(null,vec__21889,(0),null);
var u = cljs.core.nth.call(null,vec__21889,(1),null);
var updater = helix.hooks.global$module$react.useCallback((function() { 
var G__21893__delegate = function (x,xs){
if((((!((x == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x.helix$hooks$IStateUpdater$))))?true:(((!x.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,helix.hooks.IStateUpdater,x):false)):cljs.core.native_satisfies_QMARK_.call(null,helix.hooks.IStateUpdater,x))){
return u.call(null,(function helix$hooks$use_state_$_spread_updater(y){
return cljs.core.apply.call(null,x,y,xs);
}));
} else {
return u.call(null,x);
}
};
var G__21893 = function (x,var_args){
var xs = null;
if (arguments.length > 1) {
var G__21894__i = 0, G__21894__a = new Array(arguments.length -  1);
while (G__21894__i < G__21894__a.length) {G__21894__a[G__21894__i] = arguments[G__21894__i + 1]; ++G__21894__i;}
  xs = new cljs.core.IndexedSeq(G__21894__a,0,null);
} 
return G__21893__delegate.call(this,x,xs);};
G__21893.cljs$lang$maxFixedArity = 1;
G__21893.cljs$lang$applyTo = (function (arglist__21895){
var x = cljs.core.first(arglist__21895);
var xs = cljs.core.rest(arglist__21895);
return G__21893__delegate(x,xs);
});
G__21893.cljs$core$IFn$_invoke$arity$variadic = G__21893__delegate;
return G__21893;
})()
,[]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,updater], null);
});
/**
 * Like react/useRef. Supports accessing the "current" property via
 *   dereference (@) and updating the "current" property via `reset!` and
 *   `swap!`
 */
helix.hooks.use_ref = (function helix$hooks$use_ref(x){
var ref = helix.hooks.global$module$react.useRef(null);
if((ref.current == null)){
(ref.current = (function (){var x21896 = ({"current": x});
(x21896.cljs$core$IDeref$ = cljs.core.PROTOCOL_SENTINEL);

(x21896.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1.current;
}));

(x21896.cljs$core$IReset$ = cljs.core.PROTOCOL_SENTINEL);

(x21896.cljs$core$IReset$_reset_BANG_$arity$2 = (function (this$,v){
var this$__$1 = this;
return helix.hooks.goog$module$goog$object.set.call(null,this$__$1,"current",v);
}));

(x21896.cljs$core$ISwap$ = cljs.core.PROTOCOL_SENTINEL);

(x21896.cljs$core$ISwap$_swap_BANG_$arity$2 = (function (this$,f){
var this$__$1 = this;
return helix.hooks.goog$module$goog$object.set.call(null,this$__$1,"current",f.call(null,this$__$1.current));
}));

(x21896.cljs$core$ISwap$_swap_BANG_$arity$3 = (function (this$,f,a){
var this$__$1 = this;
return helix.hooks.goog$module$goog$object.set.call(null,this$__$1,"current",f.call(null,this$__$1.current,a));
}));

(x21896.cljs$core$ISwap$_swap_BANG_$arity$4 = (function (this$,f,a,b){
var this$__$1 = this;
return helix.hooks.goog$module$goog$object.set.call(null,this$__$1,"current",f.call(null,this$__$1.current,a,b));
}));

(x21896.cljs$core$ISwap$_swap_BANG_$arity$5 = (function (this$,f,a,b,xs){
var this$__$1 = this;
return helix.hooks.goog$module$goog$object.set.call(null,this$__$1,"current",cljs.core.apply.call(null,f,this$__$1.current,a,b,xs));
}));

return x21896;
})());
} else {
}

return ref.current;
});
/**
 * Just react/useReducer.
 */
helix.hooks.use_reducer = (function helix$hooks$use_reducer(var_args){
var G__21898 = arguments.length;
switch (G__21898) {
case 2:
return helix.hooks.use_reducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return helix.hooks.use_reducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.hooks.use_reducer.cljs$core$IFn$_invoke$arity$2 = (function (reducer,init_state){
return helix.hooks.use_reducer.call(null,reducer,init_state,undefined);
}));

(helix.hooks.use_reducer.cljs$core$IFn$_invoke$arity$3 = (function (reducer,init_state,init){
return helix.hooks.global$module$react.useReducer(helix.hooks.global$module$react.useMemo((function (){
if((((!(cljs.core.fn_QMARK_.call(null,reducer)))) && (cljs.core.ifn_QMARK_.call(null,reducer)))){
return (function helix$hooks$wrap_ifn(state,action){
return reducer.call(null,state,action);
});
} else {
return reducer;
}
}),[reducer]),init_state,init);
}));

(helix.hooks.use_reducer.cljs$lang$maxFixedArity = 3);

/**
 * Just react/useContext
 */
helix.hooks.use_context = helix.hooks.global$module$react.useContext;
helix.hooks.wrap_fx = (function helix$hooks$wrap_fx(f){
return (function helix$hooks$wrap_fx_$_wrap_fx_return(){
var x = f.call(null);
if(cljs.core.fn_QMARK_.call(null,x)){
return x;
} else {
return undefined;
}
});
});
helix.hooks.simple_body_QMARK_ = (function helix$hooks$simple_body_QMARK_(body){
return ((cljs.core._EQ_.call(null,cljs.core.count.call(null,body),(1))) && ((cljs.core.first.call(null,body) instanceof cljs.core.Symbol)));
});
helix.hooks.determine_deps = (function helix$hooks$determine_deps(deps){
var G__21900 = deps;
var G__21900__$1 = (((G__21900 instanceof cljs.core.Keyword))?G__21900.fqn:null);
switch (G__21900__$1) {
case "once":
return [];

break;
case "always":
return undefined;

break;
case "auto-deps":
throw (new Error("Cannot use :auto-deps outside of macro."));

break;
default:
return cljs.core.to_array.call(null,deps);

}
});
var ret__5824__auto___21906 = (function (){
/**
 * Like react/useEffect.  See namespace doc for `deps`.  `body` should be a
 *   code form which will be wrapped in a function and passed to
 *   react/useEffect.  If it returns a function, that will be used to clean up.
 * 
 *   Unlike react/useEffect, only if you return a function will it be used, you
 *   DO NOT need to return js/undefined.
 */
helix.hooks.use_effect = (function helix$hooks$use_effect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___21907 = arguments.length;
var i__5770__auto___21908 = (0);
while(true){
if((i__5770__auto___21908 < len__5769__auto___21907)){
args__5775__auto__.push((arguments[i__5770__auto___21908]));

var G__21909 = (i__5770__auto___21908 + (1));
i__5770__auto___21908 = G__21909;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return helix.hooks.use_effect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(helix.hooks.use_effect.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,deps,body){
return null;
}));

(helix.hooks.use_effect.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(helix.hooks.use_effect.cljs$lang$applyTo = (function (seq21902){
var G__21903 = cljs.core.first.call(null,seq21902);
var seq21902__$1 = cljs.core.next.call(null,seq21902);
var G__21904 = cljs.core.first.call(null,seq21902__$1);
var seq21902__$2 = cljs.core.next.call(null,seq21902__$1);
var G__21905 = cljs.core.first.call(null,seq21902__$2);
var seq21902__$3 = cljs.core.next.call(null,seq21902__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21903,G__21904,G__21905,seq21902__$3);
}));

return null;
})()
;
(helix.hooks.use_effect.cljs$lang$macro = true);

/**
 * Like react/useEffect.  See `use-effect` for details on what `f`'s return values.  See namespace doc for `deps`.
 */
helix.hooks.use_effect_STAR_ = (function helix$hooks$use_effect_STAR_(var_args){
var G__21911 = arguments.length;
switch (G__21911) {
case 1:
return helix.hooks.use_effect_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.hooks.use_effect_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.hooks.use_effect_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
return helix.hooks.global$module$react.useEffect(helix.hooks.wrap_fx.call(null,f));
}));

(helix.hooks.use_effect_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.call(null,deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-effect*`; use `use-effect` macro for that"));
} else {
}
} else {
}

return helix.hooks.global$module$react.useEffect(helix.hooks.wrap_fx.call(null,f),cljs.core.to_array.call(null,deps));
}));

(helix.hooks.use_effect_STAR_.cljs$lang$maxFixedArity = 2);

var ret__5824__auto___21917 = (function (){
/**
 * Like `use-effect` but instead calls react/useLayoutEffect.
 */
helix.hooks.use_layout_effect = (function helix$hooks$use_layout_effect(var_args){
var args__5775__auto__ = [];
var len__5769__auto___21918 = arguments.length;
var i__5770__auto___21919 = (0);
while(true){
if((i__5770__auto___21919 < len__5769__auto___21918)){
args__5775__auto__.push((arguments[i__5770__auto___21919]));

var G__21920 = (i__5770__auto___21919 + (1));
i__5770__auto___21919 = G__21920;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return helix.hooks.use_layout_effect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(helix.hooks.use_layout_effect.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,deps,body){
return null;
}));

(helix.hooks.use_layout_effect.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(helix.hooks.use_layout_effect.cljs$lang$applyTo = (function (seq21913){
var G__21914 = cljs.core.first.call(null,seq21913);
var seq21913__$1 = cljs.core.next.call(null,seq21913);
var G__21915 = cljs.core.first.call(null,seq21913__$1);
var seq21913__$2 = cljs.core.next.call(null,seq21913__$1);
var G__21916 = cljs.core.first.call(null,seq21913__$2);
var seq21913__$3 = cljs.core.next.call(null,seq21913__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21914,G__21915,G__21916,seq21913__$3);
}));

return null;
})()
;
(helix.hooks.use_layout_effect.cljs$lang$macro = true);

/**
 * Like `use-effect*` but instead calls react/useLayoutEffect.
 */
helix.hooks.use_layout_effect_STAR_ = (function helix$hooks$use_layout_effect_STAR_(var_args){
var G__21922 = arguments.length;
switch (G__21922) {
case 1:
return helix.hooks.use_layout_effect_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.hooks.use_layout_effect_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.hooks.use_layout_effect_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
return helix.hooks.global$module$react.useLayoutEffect(helix.hooks.wrap_fx.call(null,f));
}));

(helix.hooks.use_layout_effect_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.call(null,deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-layout-effect*`; use `use-layout-effect` macro for that"));
} else {
}
} else {
}

return helix.hooks.global$module$react.useLayoutEffect(helix.hooks.wrap_fx.call(null,f),cljs.core.to_array.call(null,deps));
}));

(helix.hooks.use_layout_effect_STAR_.cljs$lang$maxFixedArity = 2);

var ret__5824__auto___21928 = (function (){
/**
 * Like react/useMemo.  See namespace doc for `deps`.  `body` should be a
 *   code form which will be wrapped in a function.
 */
helix.hooks.use_memo = (function helix$hooks$use_memo(var_args){
var args__5775__auto__ = [];
var len__5769__auto___21929 = arguments.length;
var i__5770__auto___21930 = (0);
while(true){
if((i__5770__auto___21930 < len__5769__auto___21929)){
args__5775__auto__.push((arguments[i__5770__auto___21930]));

var G__21931 = (i__5770__auto___21930 + (1));
i__5770__auto___21930 = G__21931;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return helix.hooks.use_memo.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(helix.hooks.use_memo.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,deps,body){
return null;
}));

(helix.hooks.use_memo.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(helix.hooks.use_memo.cljs$lang$applyTo = (function (seq21924){
var G__21925 = cljs.core.first.call(null,seq21924);
var seq21924__$1 = cljs.core.next.call(null,seq21924);
var G__21926 = cljs.core.first.call(null,seq21924__$1);
var seq21924__$2 = cljs.core.next.call(null,seq21924__$1);
var G__21927 = cljs.core.first.call(null,seq21924__$2);
var seq21924__$3 = cljs.core.next.call(null,seq21924__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21925,G__21926,G__21927,seq21924__$3);
}));

return null;
})()
;
(helix.hooks.use_memo.cljs$lang$macro = true);

/**
 * Like react/useMemo.  `f` is unchanged in meaning.  See namespace doc for
 *   `deps`.
 */
helix.hooks.use_memo_STAR_ = (function helix$hooks$use_memo_STAR_(var_args){
var G__21933 = arguments.length;
switch (G__21933) {
case 1:
return helix.hooks.use_memo_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.hooks.use_memo_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.hooks.use_memo_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
return helix.hooks.global$module$react.useMemo(f);
}));

(helix.hooks.use_memo_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.call(null,deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-memo*`; use `use-memo` macro for that"));
} else {
}
} else {
}

return helix.hooks.global$module$react.useMemo(f,cljs.core.to_array.call(null,deps));
}));

(helix.hooks.use_memo_STAR_.cljs$lang$maxFixedArity = 2);

var ret__5824__auto___21939 = (function (){
/**
 * Like react/useCallback.  See namespace doc for `deps`.  `fn-body` should
 *   be a code form which returns a function.
 */
helix.hooks.use_callback = (function helix$hooks$use_callback(var_args){
var args__5775__auto__ = [];
var len__5769__auto___21940 = arguments.length;
var i__5770__auto___21941 = (0);
while(true){
if((i__5770__auto___21941 < len__5769__auto___21940)){
args__5775__auto__.push((arguments[i__5770__auto___21941]));

var G__21942 = (i__5770__auto___21941 + (1));
i__5770__auto___21941 = G__21942;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return helix.hooks.use_callback.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(helix.hooks.use_callback.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,deps,fn_body){
return null;
}));

(helix.hooks.use_callback.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(helix.hooks.use_callback.cljs$lang$applyTo = (function (seq21935){
var G__21936 = cljs.core.first.call(null,seq21935);
var seq21935__$1 = cljs.core.next.call(null,seq21935);
var G__21937 = cljs.core.first.call(null,seq21935__$1);
var seq21935__$2 = cljs.core.next.call(null,seq21935__$1);
var G__21938 = cljs.core.first.call(null,seq21935__$2);
var seq21935__$3 = cljs.core.next.call(null,seq21935__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21936,G__21937,G__21938,seq21935__$3);
}));

return null;
})()
;
(helix.hooks.use_callback.cljs$lang$macro = true);

/**
 * `f` is a function which will be passed to react/useCallback.  See
 *   namespace doc for `deps`.
 */
helix.hooks.use_callback_STAR_ = (function helix$hooks$use_callback_STAR_(var_args){
var G__21944 = arguments.length;
switch (G__21944) {
case 1:
return helix.hooks.use_callback_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.hooks.use_callback_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.hooks.use_callback_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
return helix.hooks.global$module$react.useCallback(f);
}));

(helix.hooks.use_callback_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.call(null,deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-callback*`; use `use-callback` macro for that"));
} else {
}
} else {
}

return helix.hooks.global$module$react.useCallback(f,cljs.core.to_array.call(null,deps));
}));

(helix.hooks.use_callback_STAR_.cljs$lang$maxFixedArity = 2);

var ret__5824__auto___21951 = (function (){
/**
 * Like react/useImperativeHandle.  `ref` is unchanged in meaning.  See
 *   namespace doc for `deps`.  `body` should be a code form which will be
 *   wrapped in a function.
 */
helix.hooks.use_imperative_handle = (function helix$hooks$use_imperative_handle(var_args){
var args__5775__auto__ = [];
var len__5769__auto___21952 = arguments.length;
var i__5770__auto___21953 = (0);
while(true){
if((i__5770__auto___21953 < len__5769__auto___21952)){
args__5775__auto__.push((arguments[i__5770__auto___21953]));

var G__21954 = (i__5770__auto___21953 + (1));
i__5770__auto___21953 = G__21954;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((4) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((4)),(0),null)):null);
return helix.hooks.use_imperative_handle.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__5776__auto__);
});

(helix.hooks.use_imperative_handle.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,ref,deps,body){
return null;
}));

(helix.hooks.use_imperative_handle.cljs$lang$maxFixedArity = (4));

/** @this {Function} */
(helix.hooks.use_imperative_handle.cljs$lang$applyTo = (function (seq21946){
var G__21947 = cljs.core.first.call(null,seq21946);
var seq21946__$1 = cljs.core.next.call(null,seq21946);
var G__21948 = cljs.core.first.call(null,seq21946__$1);
var seq21946__$2 = cljs.core.next.call(null,seq21946__$1);
var G__21949 = cljs.core.first.call(null,seq21946__$2);
var seq21946__$3 = cljs.core.next.call(null,seq21946__$2);
var G__21950 = cljs.core.first.call(null,seq21946__$3);
var seq21946__$4 = cljs.core.next.call(null,seq21946__$3);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21947,G__21948,G__21949,G__21950,seq21946__$4);
}));

return null;
})()
;
(helix.hooks.use_imperative_handle.cljs$lang$macro = true);

/**
 * Like react/useImperativeHandle.  `ref` and `f` are unchanged in meaning.
 *   See namespace doc for `deps`
 */
helix.hooks.use_imperative_handle_STAR_ = (function helix$hooks$use_imperative_handle_STAR_(var_args){
var G__21956 = arguments.length;
switch (G__21956) {
case 2:
return helix.hooks.use_imperative_handle_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return helix.hooks.use_imperative_handle_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.hooks.use_imperative_handle_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (ref,f){
return helix.hooks.global$module$react.useImperativeHandle(ref,f);
}));

(helix.hooks.use_imperative_handle_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (ref,f,deps){
if(cljs.core.truth_(goog.DEBUG)){
if(cljs.core._EQ_.call(null,deps,new cljs.core.Keyword(null,"auto-deps","auto-deps",-2124919365))){
throw (new Error("Can't use `:auto-deps` with `use-imperative-handle*`; use `use-imperative-handle` macro for that"));
} else {
}
} else {
}

return helix.hooks.global$module$react.useImperativeHandle(ref,f,cljs.core.to_array.call(null,deps));
}));

(helix.hooks.use_imperative_handle_STAR_.cljs$lang$maxFixedArity = 3);

/**
 * Just react/useDebugValue
 */
helix.hooks.use_debug_value = helix.hooks.global$module$react.useDebugValue;
/**
 * Hook used for safely managing subscriptions, respecting Clojure equality.
 * 
 *   In order to avoid removing and re-adding subscriptions each time this hook is
 *   called, the parameters passed to this hook should be memoized in some way–
 *   either by wrapping the entire params object with `use-memo` or by wrapping the
 *   individual callbacks with `use-callback`.
 */
helix.hooks.use_subscription = (function helix$hooks$use_subscription(p__21958){
var map__21959 = p__21958;
var map__21959__$1 = cljs.core.__destructure_map.call(null,map__21959);
var get_current_value = cljs.core.get.call(null,map__21959__$1,new cljs.core.Keyword(null,"get-current-value","get-current-value",-1706578691));
var subscribe = cljs.core.get.call(null,map__21959__$1,new cljs.core.Keyword(null,"subscribe","subscribe",416253756));
var vec__21960 = helix.hooks.global$module$react.useState((function (){
return ({"get-current-value": get_current_value, "subscribe": subscribe, "value": get_current_value.call(null)});
}));
var state = cljs.core.nth.call(null,vec__21960,(0),null);
var set_state = cljs.core.nth.call(null,vec__21960,(1),null);
helix.hooks.global$module$react.useEffect((function (){
var did_unsubscribe = ({"value": false});
var check_for_updates = (function helix$hooks$use_subscription_$_check_for_updates(){
if(cljs.core.not.call(null,helix.hooks.goog$module$goog$object.get.call(null,did_unsubscribe,"value"))){
var value = get_current_value.call(null);
return set_state.call(null,(function (prev){
if(((cljs.core.not_EQ_.call(null,get_current_value,helix.hooks.goog$module$goog$object.get.call(null,prev,"get-current-value"))) || (cljs.core.not_EQ_.call(null,subscribe,helix.hooks.goog$module$goog$object.get.call(null,prev,"subscribe"))))){
return prev;
} else {
if(cljs.core._EQ_.call(null,value,helix.hooks.goog$module$goog$object.get.call(null,prev,"value"))){
return prev;
} else {
return ({"get-current-value": helix.hooks.goog$module$goog$object.get.call(null,prev,"get-current-value"), "subscribe": helix.hooks.goog$module$goog$object.get.call(null,prev,"subscribe"), "value": value});

}
}
}));
} else {
return null;
}
});
var unsubscribe = subscribe.call(null,check_for_updates);
check_for_updates.call(null);

return (function (){
helix.hooks.goog$module$goog$object.set.call(null,did_unsubscribe,"value",true);

return unsubscribe.call(null);
});
}),[get_current_value,subscribe]);

if(((cljs.core.not_EQ_.call(null,get_current_value,helix.hooks.goog$module$goog$object.get.call(null,state,"get-current-value"))) || (cljs.core.not_EQ_.call(null,subscribe,helix.hooks.goog$module$goog$object.get.call(null,state,"subscribe"))))){
var value = get_current_value.call(null);
set_state.call(null,({"get-current-value": get_current_value, "subscribe": subscribe, "value": value}));

return value;
} else {
return helix.hooks.goog$module$goog$object.get.call(null,state,"value");
}
});

//# sourceMappingURL=hooks.js.map
