// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('helix.core');
goog.require('cljs.core');
goog.require('helix.impl.props');
goog.require('helix.impl.classes');
goog.require('cljs_bean.core');
goog.require('react');
goog.require('goog.object');
goog.scope(function(){
helix.core.goog$module$goog$object = goog.module.get('goog.object');
});
helix.core.global$module$react = goog.global["React"];
if((typeof Symbol !== 'undefined')){
(Symbol.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (sym,writer,_){
var sym__$1 = this;
return cljs.core._write.call(null,writer,["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sym__$1.toString()),"\""].join(''));
}));
} else {
}
/**
 * React.Fragment. See `helix.core/<>` for macro version.
 */
helix.core.Fragment = helix.core.global$module$react.Fragment;
/**
 * React.Suspense. See `helix.core/suspense` for macro version.
 */
helix.core.Suspense = helix.core.global$module$react.Suspense;
helix.core.create_element = helix.core.global$module$react.createElement;
/**
 * React.createContext
 */
helix.core.create_context = helix.core.global$module$react.createContext;
helix.core.get_react = (function helix$core$get_react(){
return helix.core.global$module$react;
});
/**
 * Create a new React element from a valid React type.
 * 
 *   Example:
 *   ```
 *   ($ MyComponent
 * "child1"
 * ($ "span"
 *   {:style {:color "green"}}
 *   "child2" ))
 *   ```
 */
helix.core.$ = (function helix$core$$(var_args){
var args__5775__auto__ = [];
var len__5769__auto___21810 = arguments.length;
var i__5770__auto___21811 = (0);
while(true){
if((i__5770__auto___21811 < len__5769__auto___21810)){
args__5775__auto__.push((arguments[i__5770__auto___21811]));

var G__21812 = (i__5770__auto___21811 + (1));
i__5770__auto___21811 = G__21812;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return helix.core.$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(helix.core.$.cljs$core$IFn$_invoke$arity$variadic = (function (type,args){
var _QMARK_p = cljs.core.first.call(null,args);
var _QMARK_c = cljs.core.rest.call(null,args);
var native_QMARK_ = (function (){var or__5045__auto__ = (type instanceof cljs.core.Keyword);
if(or__5045__auto__){
return or__5045__auto__;
} else {
var or__5045__auto____$1 = typeof type === 'string';
if(or__5045__auto____$1){
return or__5045__auto____$1;
} else {
return new cljs.core.Keyword(null,"native","native",-613060878).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,type));
}
}
})();
var type_SINGLEQUOTE_ = (((type instanceof cljs.core.Keyword))?cljs.core.name.call(null,type):type);
if(cljs.core.map_QMARK_.call(null,_QMARK_p)){
return cljs.core.apply.call(null,helix.core.create_element,type_SINGLEQUOTE_,(cljs.core.truth_(native_QMARK_)?helix.impl.props._dom_props.call(null,_QMARK_p):helix.impl.props._props.call(null,_QMARK_p)),_QMARK_c);
} else {
return cljs.core.apply.call(null,helix.core.create_element,type_SINGLEQUOTE_,null,args);
}
}));

(helix.core.$.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(helix.core.$.cljs$lang$applyTo = (function (seq21808){
var G__21809 = cljs.core.first.call(null,seq21808);
var seq21808__$1 = cljs.core.next.call(null,seq21808);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21809,seq21808__$1);
}));

/**
 * Dynamically create a new React element from a valid React type.
 * 
 *   `$` can typically be faster, because it will statically process the arguments
 *   at macro-time if possible.
 * 
 *   Example:
 *   ```
 *   ($$ MyComponent
 * "child1"
 * ($$ "span"
 *   {:style {:color "green"}}
 *   "child2" ))
 *   ```
 */
helix.core.$$ = helix.core.$;

/**
 * @interface
 */
helix.core.IExtractType = function(){};

var helix$core$IExtractType$_type$dyn_21813 = (function (factory){
var x__5393__auto__ = (((factory == null))?null:factory);
var m__5394__auto__ = (helix.core._type[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,factory);
} else {
var m__5392__auto__ = (helix.core._type["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,factory);
} else {
throw cljs.core.missing_protocol.call(null,"IExtractType.-type",factory);
}
}
});
/**
 * Extracts the underlying type from the factory function.
 */
helix.core._type = (function helix$core$_type(factory){
if((((!((factory == null)))) && ((!((factory.helix$core$IExtractType$_type$arity$1 == null)))))){
return factory.helix$core$IExtractType$_type$arity$1(factory);
} else {
return helix$core$IExtractType$_type$dyn_21813.call(null,factory);
}
});

/**
 * Geven a factory function created by `helix.core/factory` or `cljs-factory`,
 *   returns the original component that the factory creates elements of.
 */
helix.core.type = (function helix$core$type(f){
return helix.core._type.call(null,f);
});
/**
 * Creates a factory function for a React component, that when called returns an
 *   element with the props and children passed to the factory.
 * 
 *   Use `helix.core/type` to extract the original React component.
 */
helix.core.factory = (function helix$core$factory(type){
var x21814 = (function() { 
var helix$core$factory_$_factory__delegate = function (args){
return cljs.core.apply.call(null,helix.core.$,type,args);
};
var helix$core$factory_$_factory = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__21815__i = 0, G__21815__a = new Array(arguments.length -  0);
while (G__21815__i < G__21815__a.length) {G__21815__a[G__21815__i] = arguments[G__21815__i + 0]; ++G__21815__i;}
  args = new cljs.core.IndexedSeq(G__21815__a,0,null);
} 
return helix$core$factory_$_factory__delegate.call(this,args);};
helix$core$factory_$_factory.cljs$lang$maxFixedArity = 0;
helix$core$factory_$_factory.cljs$lang$applyTo = (function (arglist__21816){
var args = cljs.core.seq(arglist__21816);
return helix$core$factory_$_factory__delegate(args);
});
helix$core$factory_$_factory.cljs$core$IFn$_invoke$arity$variadic = helix$core$factory_$_factory__delegate;
return helix$core$factory_$_factory;
})()
;
(x21814.helix$core$IExtractType$ = cljs.core.PROTOCOL_SENTINEL);

(x21814.helix$core$IExtractType$_type$arity$1 = (function (_){
var ___$1 = this;
return type;
}));

return x21814;
});
/**
 * Creates a factory function for a component defined via `defnc`, that when
 *   called returns an element with the props and children passed to the factory.
 *   Slightly more performant than `factory` when used with a helix component.
 * 
 *   Use `helix.core/type` to extract the original component this was called with.
 */
helix.core.cljs_factory = (function helix$core$cljs_factory(type){
var x21817 = (function() { 
var helix$core$cljs_factory_$_factory__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var props = cljs.core.first.call(null,args);
return cljs.core.apply.call(null,helix.core.global$module$react.createElement,type,({"helix/props": cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"key","key",-1516042587),new cljs.core.Keyword(null,"ref","ref",1289896967)), "key": cljs.core.get.call(null,props,new cljs.core.Keyword(null,"key","key",-1516042587),undefined), "ref": cljs.core.get.call(null,props,new cljs.core.Keyword(null,"ref","ref",1289896967),undefined)}),cljs.core.rest.call(null,args));
} else {
return cljs.core.apply.call(null,helix.core.global$module$react.createElement,type,({}),args);
}
};
var helix$core$cljs_factory_$_factory = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__21818__i = 0, G__21818__a = new Array(arguments.length -  0);
while (G__21818__i < G__21818__a.length) {G__21818__a[G__21818__i] = arguments[G__21818__i + 0]; ++G__21818__i;}
  args = new cljs.core.IndexedSeq(G__21818__a,0,null);
} 
return helix$core$cljs_factory_$_factory__delegate.call(this,args);};
helix$core$cljs_factory_$_factory.cljs$lang$maxFixedArity = 0;
helix$core$cljs_factory_$_factory.cljs$lang$applyTo = (function (arglist__21819){
var args = cljs.core.seq(arglist__21819);
return helix$core$cljs_factory_$_factory__delegate(args);
});
helix$core$cljs_factory_$_factory.cljs$core$IFn$_invoke$arity$variadic = helix$core$cljs_factory_$_factory__delegate;
return helix$core$cljs_factory_$_factory;
})()
;
(x21817.helix$core$IExtractType$ = cljs.core.PROTOCOL_SENTINEL);

(x21817.helix$core$IExtractType$_type$arity$1 = (function (_){
var ___$1 = this;
return type;
}));

return x21817;
});
helix.core.assoc_some = (function helix$core$assoc_some(m,k,x){
if((!((x == null)))){
return cljs.core.assoc.call(null,m,k,x);
} else {
return m;
}
});
/**
 * A helper function for turning a props object into a CLJS map. Works with both
 *   factory functions (which stores a map in a single key, "helix/props") and
 *   normal JS objects.
 *   Mostly used internally by helix, but can be useful when writing HOC.
 */
helix.core.extract_cljs_props = (function helix$core$extract_cljs_props(o){
if(((goog.DEBUG) && (((cljs.core.map_QMARK_.call(null,o)) || ((o == null)))))){
throw cljs.core.ex_info.call(null,"Props received were a map. This probably means you're calling your component as a function.",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"props","props",453281727),o], null));
} else {
}

var temp__5802__auto__ = helix.core.goog$module$goog$object.get.call(null,o,"helix/props");
if(cljs.core.truth_(temp__5802__auto__)){
var props = temp__5802__auto__;
return helix.core.assoc_some.call(null,props,new cljs.core.Keyword(null,"children","children",-940561982),helix.core.goog$module$goog$object.get.call(null,o,"children"));
} else {
return cljs_bean.core.bean.call(null,o);
}
});
helix.core.props_kvs_identical_QMARK_ = (function helix$core$props_kvs_identical_QMARK_(prev,cur){
var prev_props = helix.core.extract_cljs_props.call(null,prev);
var cur_props = helix.core.extract_cljs_props.call(null,cur);
return ((cljs.core._EQ_.call(null,cljs.core.count.call(null,prev_props),cljs.core.count.call(null,cur_props))) && (cljs.core.every_QMARK_.call(null,(function (p1__21820_SHARP_){
return (cljs.core.get.call(null,prev_props,p1__21820_SHARP_) === cljs.core.get.call(null,cur_props,p1__21820_SHARP_));
}),cljs.core.keys.call(null,cur_props))));
});
/**
 * Like React.memo, but passes props to `compare` as CLJS map-likes instead of
 *   JS objects.
 *   `compare` should return true if props are equal, and false if not.
 */
helix.core.memo = (function helix$core$memo(var_args){
var G__21822 = arguments.length;
switch (G__21822) {
case 1:
return helix.core.memo.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return helix.core.memo.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(helix.core.memo.cljs$core$IFn$_invoke$arity$1 = (function (component){
return helix.core.global$module$react.memo(component,helix.core.props_kvs_identical_QMARK_);
}));

(helix.core.memo.cljs$core$IFn$_invoke$arity$2 = (function (component,compare){
return helix.core.global$module$react.memo(component,(function helix$core$memo_compare(o,o_SINGLEQUOTE_){
return compare.call(null,helix.core.extract_cljs_props.call(null,o),helix.core.extract_cljs_props.call(null,o_SINGLEQUOTE_));
}));
}));

(helix.core.memo.cljs$lang$maxFixedArity = 2);

/**
 * Helper function for creating a class component. See `defcomponent`.
 */
helix.core.create_component = (function helix$core$create_component(spec,statics){
var render = spec.render;
var render_SINGLEQUOTE_ = (function (this$){
return render.call(null,this$,helix.core.extract_cljs_props.call(null,this$.props),this$.state);
});
helix.core.goog$module$goog$object.set.call(null,spec,"render",render_SINGLEQUOTE_);

return helix.impl.classes.createComponent(helix.core.global$module$react.Component,spec,statics);
});
/**
 * Registers a component with the React Fresh runtime.
 *   `type` is the component function, and `id` is the unique ID assigned to it
 *   (e.g. component name) for cache invalidation.
 */
helix.core.register_BANG_ = (function helix$core$register_BANG_(type,id){
if((!((window.$$Register$$ == null)))){
return window.$$Register$$(type,id);
} else {
return null;
}
});
helix.core.signature_BANG_ = (function helix$core$signature_BANG_(){
var and__5043__auto__ = (!((window.$$Signature$$ == null)));
if(and__5043__auto__){
return window.$$Signature$$();
} else {
return and__5043__auto__;
}
});

//# sourceMappingURL=core.js.map
