/*TRANSPILED*/goog.loadModule(function(exports) {'use strict';/*

 Copyright The Closure Library Authors.
 SPDX-License-Identifier: Apache-2.0
*/
'use strict';
goog.module("goog.object");
goog.module.declareLegacyNamespace();
function forEach(obj, f, opt_obj) {
  for (const key in obj) {
    f.call(opt_obj, obj[key], key, obj);
  }
}
function filter(obj, f, opt_obj) {
  const res = {};
  for (const key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key];
    }
  }
  return res;
}
function map(obj, f, opt_obj) {
  const res = {};
  for (const key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj);
  }
  return res;
}
function some(obj, f, opt_obj) {
  for (const key in obj) {
    if (f.call(opt_obj, obj[key], key, obj)) {
      return true;
    }
  }
  return false;
}
function every(obj, f, opt_obj) {
  for (const key in obj) {
    if (!f.call(opt_obj, obj[key], key, obj)) {
      return false;
    }
  }
  return true;
}
function getCount(obj) {
  let rv = 0;
  for (const key in obj) {
    rv++;
  }
  return rv;
}
function getAnyKey(obj) {
  for (const key in obj) {
    return key;
  }
}
function getAnyValue(obj) {
  for (const key in obj) {
    return obj[key];
  }
}
function contains(obj, val) {
  return containsValue(obj, val);
}
function getValues(obj) {
  const res = [];
  let i = 0;
  for (const key in obj) {
    res[i++] = obj[key];
  }
  return res;
}
function getKeys(obj) {
  const res = [];
  let i = 0;
  for (const key in obj) {
    res[i++] = key;
  }
  return res;
}
function getValueByKeys(obj, var_args) {
  const isArrayLike = goog.isArrayLike(var_args);
  const keys = isArrayLike ? var_args : arguments;
  for (let i = isArrayLike ? 0 : 1; i < keys.length; i++) {
    if (obj == null) {
      return undefined;
    }
    obj = obj[keys[i]];
  }
  return obj;
}
function containsKey(obj, key) {
  return obj !== null && key in obj;
}
function containsValue(obj, val) {
  for (const key in obj) {
    if (obj[key] == val) {
      return true;
    }
  }
  return false;
}
function findKey(obj, f, thisObj = undefined) {
  for (const key in obj) {
    if (f.call(thisObj, obj[key], key, obj)) {
      return key;
    }
  }
  return undefined;
}
function findValue(obj, f, thisObj = undefined) {
  const key = findKey(obj, f, thisObj);
  return key && obj[key];
}
function isEmpty(obj) {
  for (const key in obj) {
    return false;
  }
  return true;
}
function clear(obj) {
  for (const i in obj) {
    delete obj[i];
  }
}
function remove(obj, key) {
  let rv;
  if (rv = key in obj) {
    delete obj[key];
  }
  return rv;
}
function add(obj, key, val) {
  if (obj !== null && key in obj) {
    throw new Error(`The object already contains the key "${key}"`);
  }
  set(obj, key, val);
}
function get(obj, key, val = undefined) {
  if (obj !== null && key in obj) {
    return obj[key];
  }
  return val;
}
function set(obj, key, value) {
  obj[key] = value;
}
function setIfUndefined(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value;
}
function setWithReturnValueIfNotSet(obj, key, f) {
  if (key in obj) {
    return obj[key];
  }
  const val = f();
  obj[key] = val;
  return val;
}
function equals(a, b) {
  for (const k in a) {
    if (!(k in b) || a[k] !== b[k]) {
      return false;
    }
  }
  for (const k in b) {
    if (!(k in a)) {
      return false;
    }
  }
  return true;
}
function clone(obj) {
  const res = {};
  for (const key in obj) {
    res[key] = obj[key];
  }
  return res;
}
function unsafeClone(obj) {
  if (!obj || typeof obj !== "object") {
    return obj;
  }
  if (typeof obj.clone === "function") {
    return obj.clone();
  }
  if (typeof Map !== "undefined" && obj instanceof Map) {
    return new Map(obj);
  } else if (typeof Set !== "undefined" && obj instanceof Set) {
    return new Set(obj);
  }
  const clone = Array.isArray(obj) ? [] : typeof ArrayBuffer === "function" && typeof ArrayBuffer.isView === "function" && ArrayBuffer.isView(obj) && !(obj instanceof DataView) ? new obj.constructor(obj.length) : {};
  for (const key in obj) {
    clone[key] = unsafeClone(obj[key]);
  }
  return clone;
}
function transpose(obj) {
  const transposed = {};
  for (const key in obj) {
    transposed[obj[key]] = key;
  }
  return transposed;
}
const PROTOTYPE_FIELDS = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf",];
function extend(target, var_args) {
  let key;
  let source;
  for (let i = 1; i < arguments.length; i++) {
    source = arguments[i];
    for (key in source) {
      target[key] = source[key];
    }
    for (let j = 0; j < PROTOTYPE_FIELDS.length; j++) {
      key = PROTOTYPE_FIELDS[j];
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }
}
function create(var_args) {
  const argLength = arguments.length;
  if (argLength == 1 && Array.isArray(arguments[0])) {
    return create.apply(null, arguments[0]);
  }
  if (argLength % 2) {
    throw new Error("Uneven number of arguments");
  }
  const rv = {};
  for (let i = 0; i < argLength; i += 2) {
    rv[arguments[i]] = arguments[i + 1];
  }
  return rv;
}
function createSet(var_args) {
  const argLength = arguments.length;
  if (argLength == 1 && Array.isArray(arguments[0])) {
    return createSet.apply(null, arguments[0]);
  }
  const rv = {};
  for (let i = 0; i < argLength; i++) {
    rv[arguments[i]] = true;
  }
  return rv;
}
function createImmutableView(obj) {
  let result = obj;
  if (Object.isFrozen && !Object.isFrozen(obj)) {
    result = Object.create(obj);
    Object.freeze(result);
  }
  return result;
}
function isImmutableView(obj) {
  return !!Object.isFrozen && Object.isFrozen(obj);
}
function getAllPropertyNames(obj, includeObjectPrototype = undefined, includeFunctionPrototype = undefined) {
  if (!obj) {
    return [];
  }
  if (!Object.getOwnPropertyNames || !Object.getPrototypeOf) {
    return getKeys(obj);
  }
  const visitedSet = {};
  let proto = obj;
  while (proto && (proto !== Object.prototype || !!includeObjectPrototype) && (proto !== Function.prototype || !!includeFunctionPrototype)) {
    const names = Object.getOwnPropertyNames(proto);
    for (let i = 0; i < names.length; i++) {
      visitedSet[names[i]] = true;
    }
    proto = Object.getPrototypeOf(proto);
  }
  return getKeys(visitedSet);
}
function getSuperClass(constructor) {
  const proto = Object.getPrototypeOf(constructor.prototype);
  return proto && proto.constructor;
}
exports = {add, clear, clone, contains, containsKey, containsValue, create, createImmutableView, createSet, equals, every, extend, filter, findKey, findValue, forEach, get, getAllPropertyNames, getAnyKey, getAnyValue, getCount, getKeys, getSuperClass, getValueByKeys, getValues, isEmpty, isImmutableView, map, remove, set, setIfUndefined, setWithReturnValueIfNotSet, some, transpose, unsafeClone,};

;return exports;});
