// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('gadget.extensions');
goog.require('cljs.core');
goog.require('gadget.browsable');
goog.require('gadget.datafy');
goog.require('gadget.core');
goog.require('gadget.std');
goog.require('clojure.string');
cljs.core._add_method.call(null,gadget.core.render,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"inline","inline",1399884222),new cljs.core.Keyword(null,"jwt","jwt",1504015441)], null),(function (_,p__22589){
var map__22590 = p__22589;
var map__22590__$1 = cljs.core.__destructure_map.call(null,map__22590);
var raw = cljs.core.get.call(null,map__22590__$1,new cljs.core.Keyword(null,"raw","raw",1604651272));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"strong","strong",269529000),cljs.core.PersistentArrayMap.EMPTY,"JWT: "], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("gadget","string","gadget/string",-192737950),cljs.core.pr_str.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,clojure.string.split.call(null,raw,/\./))),"..."].join(''))], null)], null);
}));
gadget.extensions.base64json = (function gadget$extensions$base64json(s){
return cljs.core.js__GT_clj.call(null,JSON.parse(atob(s)),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {gadget.browsable.Browsable}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
gadget.extensions.JWT = (function (header,data,sig,__meta,__extmap,__hash){
this.header = header;
this.data = data;
this.sig = sig;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(gadget.extensions.JWT.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(gadget.extensions.JWT.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k22592,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__22596 = k22592;
var G__22596__$1 = (((G__22596 instanceof cljs.core.Keyword))?G__22596.fqn:null);
switch (G__22596__$1) {
case "header":
return self__.header;

break;
case "data":
return self__.data;

break;
case "sig":
return self__.sig;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k22592,else__5346__auto__);

}
}));

(gadget.extensions.JWT.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__22597){
var vec__22598 = p__22597;
var k__5367__auto__ = cljs.core.nth.call(null,vec__22598,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__22598,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(gadget.extensions.JWT.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#gadget.extensions.JWT{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"header","header",119441134),self__.header],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"data","data",-232669377),self__.data],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"sig","sig",-1920417200),self__.sig],null))], null),self__.__extmap));
}));

(gadget.extensions.JWT.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__22591){
var self__ = this;
var G__22591__$1 = this;
return (new cljs.core.RecordIter((0),G__22591__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"header","header",119441134),new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"sig","sig",-1920417200)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(gadget.extensions.JWT.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(gadget.extensions.JWT.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new gadget.extensions.JWT(self__.header,self__.data,self__.sig,self__.__meta,self__.__extmap,self__.__hash));
}));

(gadget.extensions.JWT.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
}));

(gadget.extensions.JWT.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1492980269 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(gadget.extensions.JWT.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this22593,other22594){
var self__ = this;
var this22593__$1 = this;
return (((!((other22594 == null)))) && ((((this22593__$1.constructor === other22594.constructor)) && (((cljs.core._EQ_.call(null,this22593__$1.header,other22594.header)) && (((cljs.core._EQ_.call(null,this22593__$1.data,other22594.data)) && (((cljs.core._EQ_.call(null,this22593__$1.sig,other22594.sig)) && (cljs.core._EQ_.call(null,this22593__$1.__extmap,other22594.__extmap)))))))))));
}));

(gadget.extensions.JWT.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"header","header",119441134),null,new cljs.core.Keyword(null,"sig","sig",-1920417200),null,new cljs.core.Keyword(null,"data","data",-232669377),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new gadget.extensions.JWT(self__.header,self__.data,self__.sig,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(gadget.extensions.JWT.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k22592){
var self__ = this;
var this__5350__auto____$1 = this;
var G__22601 = k22592;
var G__22601__$1 = (((G__22601 instanceof cljs.core.Keyword))?G__22601.fqn:null);
switch (G__22601__$1) {
case "header":
case "data":
case "sig":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k22592);

}
}));

(gadget.extensions.JWT.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__22591){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__22602 = cljs.core.keyword_identical_QMARK_;
var expr__22603 = k__5352__auto__;
if(cljs.core.truth_(pred__22602.call(null,new cljs.core.Keyword(null,"header","header",119441134),expr__22603))){
return (new gadget.extensions.JWT(G__22591,self__.data,self__.sig,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22602.call(null,new cljs.core.Keyword(null,"data","data",-232669377),expr__22603))){
return (new gadget.extensions.JWT(self__.header,G__22591,self__.sig,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22602.call(null,new cljs.core.Keyword(null,"sig","sig",-1920417200),expr__22603))){
return (new gadget.extensions.JWT(self__.header,self__.data,G__22591,self__.__meta,self__.__extmap,null));
} else {
return (new gadget.extensions.JWT(self__.header,self__.data,self__.sig,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__22591),null));
}
}
}
}));

(gadget.extensions.JWT.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"header","header",119441134),self__.header,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"data","data",-232669377),self__.data,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"sig","sig",-1920417200),self__.sig,null))], null),self__.__extmap));
}));

(gadget.extensions.JWT.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__22591){
var self__ = this;
var this__5342__auto____$1 = this;
return (new gadget.extensions.JWT(self__.header,self__.data,self__.sig,G__22591,self__.__extmap,self__.__hash));
}));

(gadget.extensions.JWT.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(gadget.extensions.JWT.prototype.gadget$browsable$Browsable$ = cljs.core.PROTOCOL_SENTINEL);

(gadget.extensions.JWT.prototype.gadget$browsable$Browsable$entries$arity$1 = (function (jwt){
var self__ = this;
var jwt__$1 = this;
return cljs.core.sort_by.call(null,gadget.core.key_order.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"header","header",119441134),new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"signature","signature",1463754794)], null)),jwt__$1);
}));

(gadget.extensions.JWT.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"header","header",1759972661,null),new cljs.core.Symbol(null,"data","data",1407862150,null),new cljs.core.Symbol(null,"sig","sig",-279885673,null)], null);
}));

(gadget.extensions.JWT.cljs$lang$type = true);

(gadget.extensions.JWT.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"gadget.extensions/JWT",null,(1),null));
}));

(gadget.extensions.JWT.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"gadget.extensions/JWT");
}));

/**
 * Positional factory function for gadget.extensions/JWT.
 */
gadget.extensions.__GT_JWT = (function gadget$extensions$__GT_JWT(header,data,sig){
return (new gadget.extensions.JWT(header,data,sig,null,null,null));
});

/**
 * Factory function for gadget.extensions/JWT, taking a map of keywords to field values.
 */
gadget.extensions.map__GT_JWT = (function gadget$extensions$map__GT_JWT(G__22595){
var extmap__5385__auto__ = (function (){var G__22605 = cljs.core.dissoc.call(null,G__22595,new cljs.core.Keyword(null,"header","header",119441134),new cljs.core.Keyword(null,"data","data",-232669377),new cljs.core.Keyword(null,"sig","sig",-1920417200));
if(cljs.core.record_QMARK_.call(null,G__22595)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__22605);
} else {
return G__22605;
}
})();
return (new gadget.extensions.JWT(new cljs.core.Keyword(null,"header","header",119441134).cljs$core$IFn$_invoke$arity$1(G__22595),new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(G__22595),new cljs.core.Keyword(null,"sig","sig",-1920417200).cljs$core$IFn$_invoke$arity$1(G__22595),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

gadget.extensions.parse_jwt = (function gadget$extensions$parse_jwt(token){
var vec__22608 = clojure.string.split.call(null,token,/\./);
var header = cljs.core.nth.call(null,vec__22608,(0),null);
var data = cljs.core.nth.call(null,vec__22608,(1),null);
var sig = cljs.core.nth.call(null,vec__22608,(2),null);
return (new gadget.extensions.JWT(gadget.extensions.base64json.call(null,header),gadget.extensions.base64json.call(null,data),sig,null,null,null));
});
cljs.core._add_method.call(null,gadget.datafy.datafy,new cljs.core.Keyword(null,"jwt","jwt",1504015441),(function (token){
return gadget.extensions.parse_jwt.call(null,token);
}));
gadget.extensions.re_jwt = /^[A-Za-z0-9-_=]{4,}\.[A-Za-z0-9-_=]{4,}\.?[A-Za-z0-9-_.+\/=]*$/;
gadget.datafy.add_type_inference.call(null,(function (v){
if(cljs.core.truth_((function (){var and__5043__auto__ = typeof v === 'string';
if(and__5043__auto__){
var and__5043__auto____$1 = cljs.core.re_find.call(null,gadget.extensions.re_jwt,v);
if(cljs.core.truth_(and__5043__auto____$1)){
try{return gadget.extensions.parse_jwt.call(null,v);
}catch (e22611){var e = e22611;
return null;
}} else {
return and__5043__auto____$1;
}
} else {
return and__5043__auto__;
}
})())){
return new cljs.core.Keyword(null,"jwt","jwt",1504015441);
} else {
return null;
}
}));
gadget.extensions.supports_intl_QMARK_ = (function (){var and__5043__auto__ = window.Intl;
if(cljs.core.truth_(and__5043__auto__)){
return window.Intl.DateTimeFormat;
} else {
return and__5043__auto__;
}
})();
gadget.extensions.date_key_order = new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"iso","iso",-1366207543),new cljs.core.Keyword(null,"locale-date-string","locale-date-string",-628195831),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"timezone","timezone",1831928099),new cljs.core.Keyword(null,"year","year",335913393),new cljs.core.Keyword(null,"month","month",-1960248533),new cljs.core.Keyword(null,"date","date",-1463434462),new cljs.core.Keyword(null,"timestamp","timestamp",579478971)], null);

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {gadget.browsable.Browsable}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
gadget.extensions.Instant = (function (timestamp,iso,locale_date_string,year,month,date,time,timezone,__meta,__extmap,__hash){
this.timestamp = timestamp;
this.iso = iso;
this.locale_date_string = locale_date_string;
this.year = year;
this.month = month;
this.date = date;
this.time = time;
this.timezone = timezone;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(gadget.extensions.Instant.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(gadget.extensions.Instant.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k22613,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__22617 = k22613;
var G__22617__$1 = (((G__22617 instanceof cljs.core.Keyword))?G__22617.fqn:null);
switch (G__22617__$1) {
case "timestamp":
return self__.timestamp;

break;
case "iso":
return self__.iso;

break;
case "locale-date-string":
return self__.locale_date_string;

break;
case "year":
return self__.year;

break;
case "month":
return self__.month;

break;
case "date":
return self__.date;

break;
case "time":
return self__.time;

break;
case "timezone":
return self__.timezone;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k22613,else__5346__auto__);

}
}));

(gadget.extensions.Instant.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__5366__auto__,p__22618){
var vec__22619 = p__22618;
var k__5367__auto__ = cljs.core.nth.call(null,vec__22619,(0),null);
var v__5368__auto__ = cljs.core.nth.call(null,vec__22619,(1),null);
return f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__);
}),init__5365__auto__,this__5363__auto____$1);
}));

(gadget.extensions.Instant.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__5359__auto__,pr_pair__5361__auto__,"#gadget.extensions.Instant{",", ","}",opts__5360__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timestamp","timestamp",579478971),self__.timestamp],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"iso","iso",-1366207543),self__.iso],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"locale-date-string","locale-date-string",-628195831),self__.locale_date_string],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"year","year",335913393),self__.year],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"month","month",-1960248533),self__.month],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"date","date",-1463434462),self__.date],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"time","time",1385887882),self__.time],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"timezone","timezone",1831928099),self__.timezone],null))], null),self__.__extmap));
}));

(gadget.extensions.Instant.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__22612){
var self__ = this;
var G__22612__$1 = this;
return (new cljs.core.RecordIter((0),G__22612__$1,8,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"iso","iso",-1366207543),new cljs.core.Keyword(null,"locale-date-string","locale-date-string",-628195831),new cljs.core.Keyword(null,"year","year",335913393),new cljs.core.Keyword(null,"month","month",-1960248533),new cljs.core.Keyword(null,"date","date",-1463434462),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"timezone","timezone",1831928099)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(gadget.extensions.Instant.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(gadget.extensions.Instant.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,self__.locale_date_string,self__.year,self__.month,self__.date,self__.time,self__.timezone,self__.__meta,self__.__extmap,self__.__hash));
}));

(gadget.extensions.Instant.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (8 + cljs.core.count.call(null,self__.__extmap));
}));

(gadget.extensions.Instant.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (1286383333 ^ cljs.core.hash_unordered_coll.call(null,coll__5340__auto__));
}).call(null,this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(gadget.extensions.Instant.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this22614,other22615){
var self__ = this;
var this22614__$1 = this;
return (((!((other22615 == null)))) && ((((this22614__$1.constructor === other22615.constructor)) && (((cljs.core._EQ_.call(null,this22614__$1.timestamp,other22615.timestamp)) && (((cljs.core._EQ_.call(null,this22614__$1.iso,other22615.iso)) && (((cljs.core._EQ_.call(null,this22614__$1.locale_date_string,other22615.locale_date_string)) && (((cljs.core._EQ_.call(null,this22614__$1.year,other22615.year)) && (((cljs.core._EQ_.call(null,this22614__$1.month,other22615.month)) && (((cljs.core._EQ_.call(null,this22614__$1.date,other22615.date)) && (((cljs.core._EQ_.call(null,this22614__$1.time,other22615.time)) && (((cljs.core._EQ_.call(null,this22614__$1.timezone,other22615.timezone)) && (cljs.core._EQ_.call(null,this22614__$1.__extmap,other22615.__extmap)))))))))))))))))))));
}));

(gadget.extensions.Instant.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"date","date",-1463434462),null,new cljs.core.Keyword(null,"timezone","timezone",1831928099),null,new cljs.core.Keyword(null,"locale-date-string","locale-date-string",-628195831),null,new cljs.core.Keyword(null,"iso","iso",-1366207543),null,new cljs.core.Keyword(null,"time","time",1385887882),null,new cljs.core.Keyword(null,"month","month",-1960248533),null,new cljs.core.Keyword(null,"year","year",335913393),null,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,self__.locale_date_string,self__.year,self__.month,self__.date,self__.time,self__.timezone,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__5354__auto__)),null));
}
}));

(gadget.extensions.Instant.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k22613){
var self__ = this;
var this__5350__auto____$1 = this;
var G__22622 = k22613;
var G__22622__$1 = (((G__22622 instanceof cljs.core.Keyword))?G__22622.fqn:null);
switch (G__22622__$1) {
case "timestamp":
case "iso":
case "locale-date-string":
case "year":
case "month":
case "date":
case "time":
case "timezone":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k22613);

}
}));

(gadget.extensions.Instant.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__22612){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__22623 = cljs.core.keyword_identical_QMARK_;
var expr__22624 = k__5352__auto__;
if(cljs.core.truth_(pred__22623.call(null,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),expr__22624))){
return (new gadget.extensions.Instant(G__22612,self__.iso,self__.locale_date_string,self__.year,self__.month,self__.date,self__.time,self__.timezone,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22623.call(null,new cljs.core.Keyword(null,"iso","iso",-1366207543),expr__22624))){
return (new gadget.extensions.Instant(self__.timestamp,G__22612,self__.locale_date_string,self__.year,self__.month,self__.date,self__.time,self__.timezone,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22623.call(null,new cljs.core.Keyword(null,"locale-date-string","locale-date-string",-628195831),expr__22624))){
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,G__22612,self__.year,self__.month,self__.date,self__.time,self__.timezone,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22623.call(null,new cljs.core.Keyword(null,"year","year",335913393),expr__22624))){
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,self__.locale_date_string,G__22612,self__.month,self__.date,self__.time,self__.timezone,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22623.call(null,new cljs.core.Keyword(null,"month","month",-1960248533),expr__22624))){
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,self__.locale_date_string,self__.year,G__22612,self__.date,self__.time,self__.timezone,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22623.call(null,new cljs.core.Keyword(null,"date","date",-1463434462),expr__22624))){
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,self__.locale_date_string,self__.year,self__.month,G__22612,self__.time,self__.timezone,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22623.call(null,new cljs.core.Keyword(null,"time","time",1385887882),expr__22624))){
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,self__.locale_date_string,self__.year,self__.month,self__.date,G__22612,self__.timezone,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__22623.call(null,new cljs.core.Keyword(null,"timezone","timezone",1831928099),expr__22624))){
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,self__.locale_date_string,self__.year,self__.month,self__.date,self__.time,G__22612,self__.__meta,self__.__extmap,null));
} else {
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,self__.locale_date_string,self__.year,self__.month,self__.date,self__.time,self__.timezone,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__5352__auto__,G__22612),null));
}
}
}
}
}
}
}
}
}));

(gadget.extensions.Instant.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"timestamp","timestamp",579478971),self__.timestamp,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"iso","iso",-1366207543),self__.iso,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"locale-date-string","locale-date-string",-628195831),self__.locale_date_string,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"year","year",335913393),self__.year,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"month","month",-1960248533),self__.month,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"date","date",-1463434462),self__.date,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"time","time",1385887882),self__.time,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"timezone","timezone",1831928099),self__.timezone,null))], null),self__.__extmap));
}));

(gadget.extensions.Instant.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__22612){
var self__ = this;
var this__5342__auto____$1 = this;
return (new gadget.extensions.Instant(self__.timestamp,self__.iso,self__.locale_date_string,self__.year,self__.month,self__.date,self__.time,self__.timezone,G__22612,self__.__extmap,self__.__hash));
}));

(gadget.extensions.Instant.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__5349__auto__,(0)),cljs.core._nth.call(null,entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(gadget.extensions.Instant.prototype.gadget$browsable$Browsable$ = cljs.core.PROTOCOL_SENTINEL);

(gadget.extensions.Instant.prototype.gadget$browsable$Browsable$entries$arity$1 = (function (m){
var self__ = this;
var m__$1 = this;
return cljs.core.sort_by.call(null,gadget.core.key_order.call(null,gadget.extensions.date_key_order),m__$1);
}));

(gadget.extensions.Instant.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"timestamp","timestamp",-2074956798,null),new cljs.core.Symbol(null,"iso","iso",274323984,null),new cljs.core.Symbol(null,"locale-date-string","locale-date-string",1012335696,null),new cljs.core.Symbol(null,"year","year",1976444920,null),new cljs.core.Symbol(null,"month","month",-319717006,null),new cljs.core.Symbol(null,"date","date",177097065,null),new cljs.core.Symbol(null,"time","time",-1268547887,null),new cljs.core.Symbol(null,"timezone","timezone",-822507670,null)], null);
}));

(gadget.extensions.Instant.cljs$lang$type = true);

(gadget.extensions.Instant.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"gadget.extensions/Instant",null,(1),null));
}));

(gadget.extensions.Instant.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write.call(null,writer__5390__auto__,"gadget.extensions/Instant");
}));

/**
 * Positional factory function for gadget.extensions/Instant.
 */
gadget.extensions.__GT_Instant = (function gadget$extensions$__GT_Instant(timestamp,iso,locale_date_string,year,month,date,time,timezone){
return (new gadget.extensions.Instant(timestamp,iso,locale_date_string,year,month,date,time,timezone,null,null,null));
});

/**
 * Factory function for gadget.extensions/Instant, taking a map of keywords to field values.
 */
gadget.extensions.map__GT_Instant = (function gadget$extensions$map__GT_Instant(G__22616){
var extmap__5385__auto__ = (function (){var G__22626 = cljs.core.dissoc.call(null,G__22616,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"iso","iso",-1366207543),new cljs.core.Keyword(null,"locale-date-string","locale-date-string",-628195831),new cljs.core.Keyword(null,"year","year",335913393),new cljs.core.Keyword(null,"month","month",-1960248533),new cljs.core.Keyword(null,"date","date",-1463434462),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"timezone","timezone",1831928099));
if(cljs.core.record_QMARK_.call(null,G__22616)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__22626);
} else {
return G__22626;
}
})();
return (new gadget.extensions.Instant(new cljs.core.Keyword(null,"timestamp","timestamp",579478971).cljs$core$IFn$_invoke$arity$1(G__22616),new cljs.core.Keyword(null,"iso","iso",-1366207543).cljs$core$IFn$_invoke$arity$1(G__22616),new cljs.core.Keyword(null,"locale-date-string","locale-date-string",-628195831).cljs$core$IFn$_invoke$arity$1(G__22616),new cljs.core.Keyword(null,"year","year",335913393).cljs$core$IFn$_invoke$arity$1(G__22616),new cljs.core.Keyword(null,"month","month",-1960248533).cljs$core$IFn$_invoke$arity$1(G__22616),new cljs.core.Keyword(null,"date","date",-1463434462).cljs$core$IFn$_invoke$arity$1(G__22616),new cljs.core.Keyword(null,"time","time",1385887882).cljs$core$IFn$_invoke$arity$1(G__22616),new cljs.core.Keyword(null,"timezone","timezone",1831928099).cljs$core$IFn$_invoke$arity$1(G__22616),null,cljs.core.not_empty.call(null,extmap__5385__auto__),null));
});

cljs.core._add_method.call(null,gadget.datafy.datafy,new cljs.core.Keyword(null,"date","date",-1463434462),(function (date){
var G__22629 = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"timestamp","timestamp",579478971),date.getTime(),new cljs.core.Keyword(null,"iso","iso",-1366207543),date.toISOString(),new cljs.core.Keyword(null,"locale-date-string","locale-date-string",-628195831),date.toLocaleDateString("en-US",cljs.core.clj__GT_js.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"weekday","weekday",-1413046442),"long",new cljs.core.Keyword(null,"year","year",335913393),"numeric",new cljs.core.Keyword(null,"month","month",-1960248533),"long",new cljs.core.Keyword(null,"day","day",-274800446),"numeric"], null))),new cljs.core.Keyword(null,"year","year",335913393),((1900) + date.getYear()),new cljs.core.Keyword(null,"month","month",-1960248533),(date.getMonth() + (1)),new cljs.core.Keyword(null,"date","date",-1463434462),date.getDate(),new cljs.core.Keyword(null,"time","time",1385887882),[gadget.std.pad.call(null,date.getHours()),":",gadget.std.pad.call(null,date.getMinutes()),":",gadget.std.pad.call(null,date.getSeconds())].join('')], null);
var G__22629__$1 = (cljs.core.truth_(gadget.extensions.supports_intl_QMARK_)?cljs.core.assoc.call(null,G__22629,new cljs.core.Keyword(null,"timezone","timezone",1831928099),Intl.DateTimeFormat().resolvedOptions().timeZone):G__22629);
return gadget.extensions.map__GT_Instant.call(null,G__22629__$1);

}));
cljs.core._add_method.call(null,gadget.datafy.datafy,new cljs.core.Keyword(null,"object","object",1474613949),(function (obj){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,k),(obj[k])], null);
}),Object.keys(obj)));
}));

//# sourceMappingURL=extensions.js.map
