// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('daiquiri.interpreter');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('daiquiri.normalize');
goog.require('daiquiri.util');
goog.require('cljsjs.react');
goog.require('goog.object');
goog.scope(function(){
daiquiri.interpreter.goog$module$goog$object = goog.module.get('goog.object');
});
/**
 * Create a React element. Returns a JavaScript object when running
 *   under ClojureScript, and a om.dom.Element record in Clojure.
 */
daiquiri.interpreter.create_element = (function daiquiri$interpreter$create_element(type,attrs,children){
return React.createElement.apply(null,[type,attrs].concat(children));
});
daiquiri.interpreter.component_attributes = (function daiquiri$interpreter$component_attributes(attrs){
var x = daiquiri.util.camel_case_keys_STAR_.call(null,attrs);
var m = ({});
var seq__21764_21780 = cljs.core.seq.call(null,x);
var chunk__21765_21781 = null;
var count__21766_21782 = (0);
var i__21767_21783 = (0);
while(true){
if((i__21767_21783 < count__21766_21782)){
var vec__21774_21784 = cljs.core._nth.call(null,chunk__21765_21781,i__21767_21783);
var k_21785 = cljs.core.nth.call(null,vec__21774_21784,(0),null);
var v_21786 = cljs.core.nth.call(null,vec__21774_21784,(1),null);
daiquiri.interpreter.goog$module$goog$object.set.call(null,m,cljs.core.name.call(null,k_21785),v_21786);


var G__21787 = seq__21764_21780;
var G__21788 = chunk__21765_21781;
var G__21789 = count__21766_21782;
var G__21790 = (i__21767_21783 + (1));
seq__21764_21780 = G__21787;
chunk__21765_21781 = G__21788;
count__21766_21782 = G__21789;
i__21767_21783 = G__21790;
continue;
} else {
var temp__5804__auto___21791 = cljs.core.seq.call(null,seq__21764_21780);
if(temp__5804__auto___21791){
var seq__21764_21792__$1 = temp__5804__auto___21791;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__21764_21792__$1)){
var c__5568__auto___21793 = cljs.core.chunk_first.call(null,seq__21764_21792__$1);
var G__21794 = cljs.core.chunk_rest.call(null,seq__21764_21792__$1);
var G__21795 = c__5568__auto___21793;
var G__21796 = cljs.core.count.call(null,c__5568__auto___21793);
var G__21797 = (0);
seq__21764_21780 = G__21794;
chunk__21765_21781 = G__21795;
count__21766_21782 = G__21796;
i__21767_21783 = G__21797;
continue;
} else {
var vec__21777_21798 = cljs.core.first.call(null,seq__21764_21792__$1);
var k_21799 = cljs.core.nth.call(null,vec__21777_21798,(0),null);
var v_21800 = cljs.core.nth.call(null,vec__21777_21798,(1),null);
daiquiri.interpreter.goog$module$goog$object.set.call(null,m,cljs.core.name.call(null,k_21799),v_21800);


var G__21801 = cljs.core.next.call(null,seq__21764_21792__$1);
var G__21802 = null;
var G__21803 = (0);
var G__21804 = (0);
seq__21764_21780 = G__21801;
chunk__21765_21781 = G__21802;
count__21766_21782 = G__21803;
i__21767_21783 = G__21804;
continue;
}
} else {
}
}
break;
}

return m;
});
daiquiri.interpreter.element_attributes = (function daiquiri$interpreter$element_attributes(attrs){
var temp__5804__auto__ = cljs.core.clj__GT_js.call(null,daiquiri.util.html_to_dom_attrs.call(null,attrs));
if(cljs.core.truth_(temp__5804__auto__)){
var js_attrs = temp__5804__auto__;
var class$ = js_attrs.className;
var class$__$1 = ((cljs.core.array_QMARK_.call(null,class$))?clojure.string.join.call(null," ",class$):class$);
if(cljs.core.truth_(js_attrs.onChange)){
(js_attrs.onChange = rum.core.mark_sync_update(js_attrs.onChange));
} else {
}

if(clojure.string.blank_QMARK_.call(null,class$__$1)){
delete js_attrs["className"];
} else {
(js_attrs.className = class$__$1);
}

return js_attrs;
} else {
return null;
}
});
/**
 * Eagerly interpret the seq `x` as HTML elements.
 */
daiquiri.interpreter.interpret_seq = (function daiquiri$interpreter$interpret_seq(x){
return cljs.core.reduce.call(null,(function (ret,x__$1){
ret.push(daiquiri.interpreter.interpret.call(null,x__$1));

return ret;
}),[],x);
});
/**
 * Render an element vector as a HTML element.
 */
daiquiri.interpreter.element = (function daiquiri$interpreter$element(element){
var vec__21805 = daiquiri.normalize.element.call(null,element);
var type = cljs.core.nth.call(null,vec__21805,(0),null);
var attrs = cljs.core.nth.call(null,vec__21805,(1),null);
var content = cljs.core.nth.call(null,vec__21805,(2),null);
return daiquiri.interpreter.create_element.call(null,type,daiquiri.interpreter.element_attributes.call(null,attrs),daiquiri.interpreter.interpret_seq.call(null,content));
});
daiquiri.interpreter.fragment = (function daiquiri$interpreter$fragment(p__21808){
var vec__21809 = p__21808;
var seq__21810 = cljs.core.seq.call(null,vec__21809);
var first__21811 = cljs.core.first.call(null,seq__21810);
var seq__21810__$1 = cljs.core.next.call(null,seq__21810);
var _ = first__21811;
var first__21811__$1 = cljs.core.first.call(null,seq__21810__$1);
var seq__21810__$2 = cljs.core.next.call(null,seq__21810__$1);
var attrs = first__21811__$1;
var children = seq__21810__$2;
var vec__21812 = ((cljs.core.map_QMARK_.call(null,attrs))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [daiquiri.interpreter.component_attributes.call(null,attrs),daiquiri.interpreter.interpret_seq.call(null,children)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,daiquiri.interpreter.interpret_seq.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs], null),children))], null));
var attrs__$1 = cljs.core.nth.call(null,vec__21812,(0),null);
var children__$1 = cljs.core.nth.call(null,vec__21812,(1),null);
return daiquiri.interpreter.create_element.call(null,React.Fragment,attrs__$1,children__$1);
});
daiquiri.interpreter.interop = (function daiquiri$interpreter$interop(p__21815){
var vec__21816 = p__21815;
var seq__21817 = cljs.core.seq.call(null,vec__21816);
var first__21818 = cljs.core.first.call(null,seq__21817);
var seq__21817__$1 = cljs.core.next.call(null,seq__21817);
var _ = first__21818;
var first__21818__$1 = cljs.core.first.call(null,seq__21817__$1);
var seq__21817__$2 = cljs.core.next.call(null,seq__21817__$1);
var component = first__21818__$1;
var first__21818__$2 = cljs.core.first.call(null,seq__21817__$2);
var seq__21817__$3 = cljs.core.next.call(null,seq__21817__$2);
var attrs = first__21818__$2;
var children = seq__21817__$3;
var vec__21819 = ((cljs.core.map_QMARK_.call(null,attrs))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [daiquiri.interpreter.component_attributes.call(null,attrs),daiquiri.interpreter.interpret_seq.call(null,children)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,daiquiri.interpreter.interpret_seq.call(null,cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [attrs], null),children))], null));
var attrs__$1 = cljs.core.nth.call(null,vec__21819,(0),null);
var children__$1 = cljs.core.nth.call(null,vec__21819,(1),null);
return daiquiri.interpreter.create_element.call(null,component,attrs__$1,children__$1);
});
/**
 * Interpret the vector `x` as an HTML element or a the children of an
 *   element.
 */
daiquiri.interpreter.interpret_vec = (function daiquiri$interpreter$interpret_vec(x){
if(daiquiri.util.fragment_QMARK_.call(null,x)){
return daiquiri.interpreter.fragment.call(null,x);
} else {
if(cljs.core.keyword_identical_QMARK_.call(null,new cljs.core.Keyword(null,">",">",-555517146),cljs.core.nth.call(null,x,(0),null))){
return daiquiri.interpreter.interop.call(null,x);
} else {
if(daiquiri.util.element_QMARK_.call(null,x)){
return daiquiri.interpreter.element.call(null,x);
} else {
return daiquiri.interpreter.interpret_seq.call(null,x);

}
}
}
});
daiquiri.interpreter.interpret = (function daiquiri$interpreter$interpret(v){
if(cljs.core.vector_QMARK_.call(null,v)){
return daiquiri.interpreter.interpret_vec.call(null,v);
} else {
if(cljs.core.seq_QMARK_.call(null,v)){
return daiquiri.interpreter.interpret_seq.call(null,v);
} else {
return v;

}
}
});

//# sourceMappingURL=interpreter.js.map
