// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('cljs.repl');
goog.require('cljs.core');
goog.require('cljs.spec.alpha');
goog.require('goog.string');
goog.require('goog.string.format');
cljs.repl.print_doc = (function cljs$repl$print_doc(p__24953){
var map__24954 = p__24953;
var map__24954__$1 = cljs.core.__destructure_map.call(null,map__24954);
var m = map__24954__$1;
var n = cljs.core.get.call(null,map__24954__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var nm = cljs.core.get.call(null,map__24954__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.println.call(null,"-------------------------");

cljs.core.println.call(null,(function (){var or__5045__auto__ = new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return [(function (){var temp__5804__auto__ = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/"].join('');
} else {
return null;
}
})(),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join('');
}
})());

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Protocol");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m))){
var seq__24955_24983 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"forms","forms",2045992350).cljs$core$IFn$_invoke$arity$1(m));
var chunk__24956_24984 = null;
var count__24957_24985 = (0);
var i__24958_24986 = (0);
while(true){
if((i__24958_24986 < count__24957_24985)){
var f_24987 = cljs.core._nth.call(null,chunk__24956_24984,i__24958_24986);
cljs.core.println.call(null,"  ",f_24987);


var G__24988 = seq__24955_24983;
var G__24989 = chunk__24956_24984;
var G__24990 = count__24957_24985;
var G__24991 = (i__24958_24986 + (1));
seq__24955_24983 = G__24988;
chunk__24956_24984 = G__24989;
count__24957_24985 = G__24990;
i__24958_24986 = G__24991;
continue;
} else {
var temp__5804__auto___24992 = cljs.core.seq.call(null,seq__24955_24983);
if(temp__5804__auto___24992){
var seq__24955_24993__$1 = temp__5804__auto___24992;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24955_24993__$1)){
var c__5568__auto___24994 = cljs.core.chunk_first.call(null,seq__24955_24993__$1);
var G__24995 = cljs.core.chunk_rest.call(null,seq__24955_24993__$1);
var G__24996 = c__5568__auto___24994;
var G__24997 = cljs.core.count.call(null,c__5568__auto___24994);
var G__24998 = (0);
seq__24955_24983 = G__24995;
chunk__24956_24984 = G__24996;
count__24957_24985 = G__24997;
i__24958_24986 = G__24998;
continue;
} else {
var f_24999 = cljs.core.first.call(null,seq__24955_24993__$1);
cljs.core.println.call(null,"  ",f_24999);


var G__25000 = cljs.core.next.call(null,seq__24955_24993__$1);
var G__25001 = null;
var G__25002 = (0);
var G__25003 = (0);
seq__24955_24983 = G__25000;
chunk__24956_24984 = G__25001;
count__24957_24985 = G__25002;
i__24958_24986 = G__25003;
continue;
}
} else {
}
}
break;
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m))){
var arglists_25004 = new cljs.core.Keyword(null,"arglists","arglists",1661989754).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_((function (){var or__5045__auto__ = new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m);
}
})())){
cljs.core.prn.call(null,arglists_25004);
} else {
cljs.core.prn.call(null,((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.first.call(null,arglists_25004)))?cljs.core.second.call(null,arglists_25004):arglists_25004));
}
} else {
}
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"special-form","special-form",-1326536374).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Special Form");

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"url","url",276297046))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))){
return cljs.core.println.call(null,["\n  Please see http://clojure.org/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(m))].join(''));
} else {
return null;
}
} else {
return cljs.core.println.call(null,["\n  Please see http://clojure.org/special_forms#",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(m))].join(''));
}
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"macro","macro",-867863404).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Macro");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"spec","spec",347520401).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"Spec");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-special-function","repl-special-function",1262603725).cljs$core$IFn$_invoke$arity$1(m))){
cljs.core.println.call(null,"REPL Special Function");
} else {
}

cljs.core.println.call(null," ",new cljs.core.Keyword(null,"doc","doc",1913296891).cljs$core$IFn$_invoke$arity$1(m));

if(cljs.core.truth_(new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(m))){
var seq__24959_25005 = cljs.core.seq.call(null,new cljs.core.Keyword(null,"methods","methods",453930866).cljs$core$IFn$_invoke$arity$1(m));
var chunk__24960_25006 = null;
var count__24961_25007 = (0);
var i__24962_25008 = (0);
while(true){
if((i__24962_25008 < count__24961_25007)){
var vec__24971_25009 = cljs.core._nth.call(null,chunk__24960_25006,i__24962_25008);
var name_25010 = cljs.core.nth.call(null,vec__24971_25009,(0),null);
var map__24974_25011 = cljs.core.nth.call(null,vec__24971_25009,(1),null);
var map__24974_25012__$1 = cljs.core.__destructure_map.call(null,map__24974_25011);
var doc_25013 = cljs.core.get.call(null,map__24974_25012__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_25014 = cljs.core.get.call(null,map__24974_25012__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_25010);

cljs.core.println.call(null," ",arglists_25014);

if(cljs.core.truth_(doc_25013)){
cljs.core.println.call(null," ",doc_25013);
} else {
}


var G__25015 = seq__24959_25005;
var G__25016 = chunk__24960_25006;
var G__25017 = count__24961_25007;
var G__25018 = (i__24962_25008 + (1));
seq__24959_25005 = G__25015;
chunk__24960_25006 = G__25016;
count__24961_25007 = G__25017;
i__24962_25008 = G__25018;
continue;
} else {
var temp__5804__auto___25019 = cljs.core.seq.call(null,seq__24959_25005);
if(temp__5804__auto___25019){
var seq__24959_25020__$1 = temp__5804__auto___25019;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24959_25020__$1)){
var c__5568__auto___25021 = cljs.core.chunk_first.call(null,seq__24959_25020__$1);
var G__25022 = cljs.core.chunk_rest.call(null,seq__24959_25020__$1);
var G__25023 = c__5568__auto___25021;
var G__25024 = cljs.core.count.call(null,c__5568__auto___25021);
var G__25025 = (0);
seq__24959_25005 = G__25022;
chunk__24960_25006 = G__25023;
count__24961_25007 = G__25024;
i__24962_25008 = G__25025;
continue;
} else {
var vec__24975_25026 = cljs.core.first.call(null,seq__24959_25020__$1);
var name_25027 = cljs.core.nth.call(null,vec__24975_25026,(0),null);
var map__24978_25028 = cljs.core.nth.call(null,vec__24975_25026,(1),null);
var map__24978_25029__$1 = cljs.core.__destructure_map.call(null,map__24978_25028);
var doc_25030 = cljs.core.get.call(null,map__24978_25029__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var arglists_25031 = cljs.core.get.call(null,map__24978_25029__$1,new cljs.core.Keyword(null,"arglists","arglists",1661989754));
cljs.core.println.call(null);

cljs.core.println.call(null," ",name_25027);

cljs.core.println.call(null," ",arglists_25031);

if(cljs.core.truth_(doc_25030)){
cljs.core.println.call(null," ",doc_25030);
} else {
}


var G__25032 = cljs.core.next.call(null,seq__24959_25020__$1);
var G__25033 = null;
var G__25034 = (0);
var G__25035 = (0);
seq__24959_25005 = G__25032;
chunk__24960_25006 = G__25033;
count__24961_25007 = G__25034;
i__24962_25008 = G__25035;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(n)){
var temp__5804__auto__ = cljs.spec.alpha.get_spec.call(null,cljs.core.symbol.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.ns_name.call(null,n)),cljs.core.name.call(null,nm)));
if(cljs.core.truth_(temp__5804__auto__)){
var fnspec = temp__5804__auto__;
cljs.core.print.call(null,"Spec");

var seq__24979 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"args","args",1315556576),new cljs.core.Keyword(null,"ret","ret",-468222814),new cljs.core.Keyword(null,"fn","fn",-1175266204)], null));
var chunk__24980 = null;
var count__24981 = (0);
var i__24982 = (0);
while(true){
if((i__24982 < count__24981)){
var role = cljs.core._nth.call(null,chunk__24980,i__24982);
var temp__5804__auto___25036__$1 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5804__auto___25036__$1)){
var spec_25037 = temp__5804__auto___25036__$1;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_25037));
} else {
}


var G__25038 = seq__24979;
var G__25039 = chunk__24980;
var G__25040 = count__24981;
var G__25041 = (i__24982 + (1));
seq__24979 = G__25038;
chunk__24980 = G__25039;
count__24981 = G__25040;
i__24982 = G__25041;
continue;
} else {
var temp__5804__auto____$1 = cljs.core.seq.call(null,seq__24979);
if(temp__5804__auto____$1){
var seq__24979__$1 = temp__5804__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__24979__$1)){
var c__5568__auto__ = cljs.core.chunk_first.call(null,seq__24979__$1);
var G__25042 = cljs.core.chunk_rest.call(null,seq__24979__$1);
var G__25043 = c__5568__auto__;
var G__25044 = cljs.core.count.call(null,c__5568__auto__);
var G__25045 = (0);
seq__24979 = G__25042;
chunk__24980 = G__25043;
count__24981 = G__25044;
i__24982 = G__25045;
continue;
} else {
var role = cljs.core.first.call(null,seq__24979__$1);
var temp__5804__auto___25046__$2 = cljs.core.get.call(null,fnspec,role);
if(cljs.core.truth_(temp__5804__auto___25046__$2)){
var spec_25047 = temp__5804__auto___25046__$2;
cljs.core.print.call(null,["\n ",cljs.core.name.call(null,role),":"].join(''),cljs.spec.alpha.describe.call(null,spec_25047));
} else {
}


var G__25048 = cljs.core.next.call(null,seq__24979__$1);
var G__25049 = null;
var G__25050 = (0);
var G__25051 = (0);
seq__24979 = G__25048;
chunk__24980 = G__25049;
count__24981 = G__25050;
i__24982 = G__25051;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Constructs a data representation for a Error with keys:
 *  :cause - root cause message
 *  :phase - error phase
 *  :via - cause chain, with cause keys:
 *           :type - exception class symbol
 *           :message - exception message
 *           :data - ex-data
 *           :at - top stack element
 *  :trace - root cause stack elements
 */
cljs.repl.Error__GT_map = (function cljs$repl$Error__GT_map(o){
var base = (function (t){
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"type","type",1174270348),(((t instanceof cljs.core.ExceptionInfo))?new cljs.core.Symbol("cljs.core","ExceptionInfo","cljs.core/ExceptionInfo",701839050,null):(((t instanceof Error))?cljs.core.symbol.call(null,"js",t.name):null
))], null),(function (){var temp__5804__auto__ = cljs.core.ex_message.call(null,t);
if(cljs.core.truth_(temp__5804__auto__)){
var msg = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"message","message",-406056002),msg], null);
} else {
return null;
}
})(),(function (){var temp__5804__auto__ = cljs.core.ex_data.call(null,t);
if(cljs.core.truth_(temp__5804__auto__)){
var ed = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),ed], null);
} else {
return null;
}
})());
});
var via = (function (){var via = cljs.core.PersistentVector.EMPTY;
var t = o;
while(true){
if(cljs.core.truth_(t)){
var G__25052 = cljs.core.conj.call(null,via,t);
var G__25053 = cljs.core.ex_cause.call(null,t);
via = G__25052;
t = G__25053;
continue;
} else {
return via;
}
break;
}
})();
var root = cljs.core.peek.call(null,via);
return cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"via","via",-1904457336),cljs.core.vec.call(null,cljs.core.map.call(null,base,via)),new cljs.core.Keyword(null,"trace","trace",-1082747415),null], null),(function (){var temp__5804__auto__ = cljs.core.ex_message.call(null,root);
if(cljs.core.truth_(temp__5804__auto__)){
var root_msg = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"cause","cause",231901252),root_msg], null);
} else {
return null;
}
})(),(function (){var temp__5804__auto__ = cljs.core.ex_data.call(null,root);
if(cljs.core.truth_(temp__5804__auto__)){
var data = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"data","data",-232669377),data], null);
} else {
return null;
}
})(),(function (){var temp__5804__auto__ = new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358).cljs$core$IFn$_invoke$arity$1(cljs.core.ex_data.call(null,o));
if(cljs.core.truth_(temp__5804__auto__)){
var phase = temp__5804__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"phase","phase",575722892),phase], null);
} else {
return null;
}
})());
});
/**
 * Returns an analysis of the phase, error, cause, and location of an error that occurred
 *   based on Throwable data, as returned by Throwable->map. All attributes other than phase
 *   are optional:
 *  :clojure.error/phase - keyword phase indicator, one of:
 *    :read-source :compile-syntax-check :compilation :macro-syntax-check :macroexpansion
 *    :execution :read-eval-result :print-eval-result
 *  :clojure.error/source - file name (no path)
 *  :clojure.error/line - integer line number
 *  :clojure.error/column - integer column number
 *  :clojure.error/symbol - symbol being expanded/compiled/invoked
 *  :clojure.error/class - cause exception class symbol
 *  :clojure.error/cause - cause exception message
 *  :clojure.error/spec - explain-data for spec error
 */
cljs.repl.ex_triage = (function cljs$repl$ex_triage(datafied_throwable){
var map__25056 = datafied_throwable;
var map__25056__$1 = cljs.core.__destructure_map.call(null,map__25056);
var via = cljs.core.get.call(null,map__25056__$1,new cljs.core.Keyword(null,"via","via",-1904457336));
var trace = cljs.core.get.call(null,map__25056__$1,new cljs.core.Keyword(null,"trace","trace",-1082747415));
var phase = cljs.core.get.call(null,map__25056__$1,new cljs.core.Keyword(null,"phase","phase",575722892),new cljs.core.Keyword(null,"execution","execution",253283524));
var map__25057 = cljs.core.last.call(null,via);
var map__25057__$1 = cljs.core.__destructure_map.call(null,map__25057);
var type = cljs.core.get.call(null,map__25057__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var message = cljs.core.get.call(null,map__25057__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var data = cljs.core.get.call(null,map__25057__$1,new cljs.core.Keyword(null,"data","data",-232669377));
var map__25058 = data;
var map__25058__$1 = cljs.core.__destructure_map.call(null,map__25058);
var problems = cljs.core.get.call(null,map__25058__$1,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814));
var fn = cljs.core.get.call(null,map__25058__$1,new cljs.core.Keyword("cljs.spec.alpha","fn","cljs.spec.alpha/fn",408600443));
var caller = cljs.core.get.call(null,map__25058__$1,new cljs.core.Keyword("cljs.spec.test.alpha","caller","cljs.spec.test.alpha/caller",-398302390));
var map__25059 = new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,via));
var map__25059__$1 = cljs.core.__destructure_map.call(null,map__25059);
var top_data = map__25059__$1;
var source = cljs.core.get.call(null,map__25059__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
return cljs.core.assoc.call(null,(function (){var G__25060 = phase;
var G__25060__$1 = (((G__25060 instanceof cljs.core.Keyword))?G__25060.fqn:null);
switch (G__25060__$1) {
case "read-source":
var map__25061 = data;
var map__25061__$1 = cljs.core.__destructure_map.call(null,map__25061);
var line = cljs.core.get.call(null,map__25061__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__25061__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var G__25062 = cljs.core.merge.call(null,new cljs.core.Keyword(null,"data","data",-232669377).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,via)),top_data);
var G__25062__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__25062,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__25062);
var G__25062__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__25062__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__25062__$1);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__25062__$2,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__25062__$2;
}

break;
case "compile-syntax-check":
case "compilation":
case "macro-syntax-check":
case "macroexpansion":
var G__25063 = top_data;
var G__25063__$1 = (cljs.core.truth_(source)?cljs.core.assoc.call(null,G__25063,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),source):G__25063);
var G__25063__$2 = (cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,source))?cljs.core.dissoc.call(null,G__25063__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397)):G__25063__$1);
var G__25063__$3 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__25063__$2,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__25063__$2);
var G__25063__$4 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__25063__$3,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__25063__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__25063__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__25063__$4;
}

break;
case "read-eval-result":
case "print-eval-result":
var vec__25064 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__25064,(0),null);
var method = cljs.core.nth.call(null,vec__25064,(1),null);
var file = cljs.core.nth.call(null,vec__25064,(2),null);
var line = cljs.core.nth.call(null,vec__25064,(3),null);
var G__25067 = top_data;
var G__25067__$1 = (cljs.core.truth_(line)?cljs.core.assoc.call(null,G__25067,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),line):G__25067);
var G__25067__$2 = (cljs.core.truth_(file)?cljs.core.assoc.call(null,G__25067__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file):G__25067__$1);
var G__25067__$3 = (cljs.core.truth_((function (){var and__5043__auto__ = source__$1;
if(cljs.core.truth_(and__5043__auto__)){
return method;
} else {
return and__5043__auto__;
}
})())?cljs.core.assoc.call(null,G__25067__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null))):G__25067__$2);
var G__25067__$4 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__25067__$3,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type):G__25067__$3);
if(cljs.core.truth_(message)){
return cljs.core.assoc.call(null,G__25067__$4,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message);
} else {
return G__25067__$4;
}

break;
case "execution":
var vec__25068 = cljs.core.first.call(null,trace);
var source__$1 = cljs.core.nth.call(null,vec__25068,(0),null);
var method = cljs.core.nth.call(null,vec__25068,(1),null);
var file = cljs.core.nth.call(null,vec__25068,(2),null);
var line = cljs.core.nth.call(null,vec__25068,(3),null);
var file__$1 = cljs.core.first.call(null,cljs.core.remove.call(null,(function (p1__25055_SHARP_){
var or__5045__auto__ = (p1__25055_SHARP_ == null);
if(or__5045__auto__){
return or__5045__auto__;
} else {
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["NO_SOURCE_PATH",null,"NO_SOURCE_FILE",null], null), null).call(null,p1__25055_SHARP_);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(caller),file], null)));
var err_line = (function (){var or__5045__auto__ = new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(caller);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return line;
}
})();
var G__25071 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890),type], null);
var G__25071__$1 = (cljs.core.truth_(err_line)?cljs.core.assoc.call(null,G__25071,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471),err_line):G__25071);
var G__25071__$2 = (cljs.core.truth_(message)?cljs.core.assoc.call(null,G__25071__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742),message):G__25071__$1);
var G__25071__$3 = (cljs.core.truth_((function (){var or__5045__auto__ = fn;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
var and__5043__auto__ = source__$1;
if(cljs.core.truth_(and__5043__auto__)){
return method;
} else {
return and__5043__auto__;
}
}
})())?cljs.core.assoc.call(null,G__25071__$2,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994),(function (){var or__5045__auto__ = fn;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[source__$1,method],null));
}
})()):G__25071__$2);
var G__25071__$4 = (cljs.core.truth_(file__$1)?cljs.core.assoc.call(null,G__25071__$3,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397),file__$1):G__25071__$3);
if(cljs.core.truth_(problems)){
return cljs.core.assoc.call(null,G__25071__$4,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595),data);
} else {
return G__25071__$4;
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25060__$1)].join('')));

}
})(),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),phase);
});
/**
 * Returns a string from exception data, as produced by ex-triage.
 *   The first line summarizes the exception phase and location.
 *   The subsequent lines describe the cause.
 */
cljs.repl.ex_str = (function cljs$repl$ex_str(p__25075){
var map__25076 = p__25075;
var map__25076__$1 = cljs.core.__destructure_map.call(null,map__25076);
var triage_data = map__25076__$1;
var phase = cljs.core.get.call(null,map__25076__$1,new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358));
var source = cljs.core.get.call(null,map__25076__$1,new cljs.core.Keyword("clojure.error","source","clojure.error/source",-2011936397));
var line = cljs.core.get.call(null,map__25076__$1,new cljs.core.Keyword("clojure.error","line","clojure.error/line",-1816287471));
var column = cljs.core.get.call(null,map__25076__$1,new cljs.core.Keyword("clojure.error","column","clojure.error/column",304721553));
var symbol = cljs.core.get.call(null,map__25076__$1,new cljs.core.Keyword("clojure.error","symbol","clojure.error/symbol",1544821994));
var class$ = cljs.core.get.call(null,map__25076__$1,new cljs.core.Keyword("clojure.error","class","clojure.error/class",278435890));
var cause = cljs.core.get.call(null,map__25076__$1,new cljs.core.Keyword("clojure.error","cause","clojure.error/cause",-1879175742));
var spec = cljs.core.get.call(null,map__25076__$1,new cljs.core.Keyword("clojure.error","spec","clojure.error/spec",2055032595));
var loc = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = source;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "<cljs repl>";
}
})()),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__5045__auto__ = line;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return (1);
}
})()),(cljs.core.truth_(column)?[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column)].join(''):"")].join('');
var class_name = cljs.core.name.call(null,(function (){var or__5045__auto__ = class$;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return "";
}
})());
var simple_class = class_name;
var cause_type = ((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["RuntimeException",null,"Exception",null], null), null),simple_class))?"":[" (",simple_class,")"].join(''));
var format = goog.string.format;
var G__25077 = phase;
var G__25077__$1 = (((G__25077 instanceof cljs.core.Keyword))?G__25077.fqn:null);
switch (G__25077__$1) {
case "read-source":
return format.call(null,"Syntax error reading source at (%s).\n%s\n",loc,cause);

break;
case "macro-syntax-check":
return format.call(null,"Syntax error macroexpanding %sat (%s).\n%s",(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,(cljs.core.truth_(spec)?(function (){var sb__5690__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__25078_25087 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__25079_25088 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__25080_25089 = true;
var _STAR_print_fn_STAR__temp_val__25081_25090 = (function (x__5691__auto__){
return sb__5690__auto__.append(x__5691__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__25080_25089);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__25081_25090);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__25073_SHARP_){
return cljs.core.dissoc.call(null,p1__25073_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__25079_25088);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__25078_25087);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5690__auto__);
})():format.call(null,"%s\n",cause)));

break;
case "macroexpansion":
return format.call(null,"Unexpected error%s macroexpanding %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compile-syntax-check":
return format.call(null,"Syntax error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "compilation":
return format.call(null,"Unexpected error%s compiling %sat (%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);

break;
case "read-eval-result":
return format.call(null,"Error reading eval result%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "print-eval-result":
return format.call(null,"Error printing return value%s at %s (%s).\n%s\n",cause_type,symbol,loc,cause);

break;
case "execution":
if(cljs.core.truth_(spec)){
return format.call(null,"Execution error - invalid arguments to %s at (%s).\n%s",symbol,loc,(function (){var sb__5690__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__25082_25091 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__25083_25092 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__25084_25093 = true;
var _STAR_print_fn_STAR__temp_val__25085_25094 = (function (x__5691__auto__){
return sb__5690__auto__.append(x__5691__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__25084_25093);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__25085_25094);

try{cljs.spec.alpha.explain_out.call(null,cljs.core.update.call(null,spec,new cljs.core.Keyword("cljs.spec.alpha","problems","cljs.spec.alpha/problems",447400814),(function (probs){
return cljs.core.map.call(null,(function (p1__25074_SHARP_){
return cljs.core.dissoc.call(null,p1__25074_SHARP_,new cljs.core.Keyword(null,"in","in",-1531184865));
}),probs);
}))
);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__25083_25092);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__25082_25091);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__5690__auto__);
})());
} else {
return format.call(null,"Execution error%s at %s(%s).\n%s\n",cause_type,(cljs.core.truth_(symbol)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(symbol)," "].join(''):""),loc,cause);
}

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25077__$1)].join('')));

}
});
cljs.repl.error__GT_str = (function cljs$repl$error__GT_str(error){
return cljs.repl.ex_str.call(null,cljs.repl.ex_triage.call(null,cljs.repl.Error__GT_map.call(null,error)));
});

//# sourceMappingURL=repl.js.map
