// Compiled by ClojureScript 1.11.60 {:optimizations :none}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
goog.scope(function(){
cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__20567 = arguments.length;
switch (G__20567) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20568 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20568 = (function (f,blockable,meta20569){
this.f = f;
this.blockable = blockable;
this.meta20569 = meta20569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20570,meta20569__$1){
var self__ = this;
var _20570__$1 = this;
return (new cljs.core.async.t_cljs$core$async20568(self__.f,self__.blockable,meta20569__$1));
}));

(cljs.core.async.t_cljs$core$async20568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20570){
var self__ = this;
var _20570__$1 = this;
return self__.meta20569;
}));

(cljs.core.async.t_cljs$core$async20568.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20568.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async20568.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async20568.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async20568.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta20569","meta20569",-1026763080,null)], null);
}));

(cljs.core.async.t_cljs$core$async20568.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20568.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20568");

(cljs.core.async.t_cljs$core$async20568.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async20568");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20568.
 */
cljs.core.async.__GT_t_cljs$core$async20568 = (function cljs$core$async$__GT_t_cljs$core$async20568(f__$1,blockable__$1,meta20569){
return (new cljs.core.async.t_cljs$core$async20568(f__$1,blockable__$1,meta20569));
});

}

return (new cljs.core.async.t_cljs$core$async20568(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__20574 = arguments.length;
switch (G__20574) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__20577 = arguments.length;
switch (G__20577) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__20580 = arguments.length;
switch (G__20580) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_20582 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_20582);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,val_20582);
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__20584 = arguments.length;
switch (G__20584) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,(function (){
return fn1.call(null,ret);
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___20586 = n;
var x_20587 = (0);
while(true){
if((x_20587 < n__5636__auto___20586)){
(a[x_20587] = x_20587);

var G__20588 = (x_20587 + (1));
x_20587 = G__20588;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle.call(null,a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20589 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20589 = (function (flag,meta20590){
this.flag = flag;
this.meta20590 = meta20590;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20589.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20591,meta20590__$1){
var self__ = this;
var _20591__$1 = this;
return (new cljs.core.async.t_cljs$core$async20589(self__.flag,meta20590__$1));
}));

(cljs.core.async.t_cljs$core$async20589.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20591){
var self__ = this;
var _20591__$1 = this;
return self__.meta20590;
}));

(cljs.core.async.t_cljs$core$async20589.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20589.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async20589.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async20589.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async20589.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta20590","meta20590",869884340,null)], null);
}));

(cljs.core.async.t_cljs$core$async20589.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20589.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20589");

(cljs.core.async.t_cljs$core$async20589.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async20589");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20589.
 */
cljs.core.async.__GT_t_cljs$core$async20589 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async20589(flag__$1,meta20590){
return (new cljs.core.async.t_cljs$core$async20589(flag__$1,meta20590));
});

}

return (new cljs.core.async.t_cljs$core$async20589(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async20592 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async20592 = (function (flag,cb,meta20593){
this.flag = flag;
this.cb = cb;
this.meta20593 = meta20593;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async20592.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_20594,meta20593__$1){
var self__ = this;
var _20594__$1 = this;
return (new cljs.core.async.t_cljs$core$async20592(self__.flag,self__.cb,meta20593__$1));
}));

(cljs.core.async.t_cljs$core$async20592.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_20594){
var self__ = this;
var _20594__$1 = this;
return self__.meta20593;
}));

(cljs.core.async.t_cljs$core$async20592.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async20592.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
}));

(cljs.core.async.t_cljs$core$async20592.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async20592.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async20592.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta20593","meta20593",585632164,null)], null);
}));

(cljs.core.async.t_cljs$core$async20592.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async20592.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async20592");

(cljs.core.async.t_cljs$core$async20592.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async20592");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async20592.
 */
cljs.core.async.__GT_t_cljs$core$async20592 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async20592(flag__$1,cb__$1,meta20593){
return (new cljs.core.async.t_cljs$core$async20592(flag__$1,cb__$1,meta20593));
});

}

return (new cljs.core.async.t_cljs$core$async20592(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20595_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20595_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__20596_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20596_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__20597 = (i + (1));
i = G__20597;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__5043__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___20602 = arguments.length;
var i__5770__auto___20603 = (0);
while(true){
if((i__5770__auto___20603 < len__5769__auto___20602)){
args__5775__auto__.push((arguments[i__5770__auto___20603]));

var G__20604 = (i__5770__auto___20603 + (1));
i__5770__auto___20603 = G__20604;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__20600){
var map__20601 = p__20600;
var map__20601__$1 = cljs.core.__destructure_map.call(null,map__20601);
var opts = map__20601__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq20598){
var G__20599 = cljs.core.first.call(null,seq20598);
var seq20598__$1 = cljs.core.next.call(null,seq20598);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__20599,seq20598__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__20606 = arguments.length;
switch (G__20606) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20507__auto___20652 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_20630){
var state_val_20631 = (state_20630[(1)]);
if((state_val_20631 === (7))){
var inst_20626 = (state_20630[(2)]);
var state_20630__$1 = state_20630;
var statearr_20632_20653 = state_20630__$1;
(statearr_20632_20653[(2)] = inst_20626);

(statearr_20632_20653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (1))){
var state_20630__$1 = state_20630;
var statearr_20633_20654 = state_20630__$1;
(statearr_20633_20654[(2)] = null);

(statearr_20633_20654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (4))){
var inst_20609 = (state_20630[(7)]);
var inst_20609__$1 = (state_20630[(2)]);
var inst_20610 = (inst_20609__$1 == null);
var state_20630__$1 = (function (){var statearr_20634 = state_20630;
(statearr_20634[(7)] = inst_20609__$1);

return statearr_20634;
})();
if(cljs.core.truth_(inst_20610)){
var statearr_20635_20655 = state_20630__$1;
(statearr_20635_20655[(1)] = (5));

} else {
var statearr_20636_20656 = state_20630__$1;
(statearr_20636_20656[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (13))){
var state_20630__$1 = state_20630;
var statearr_20637_20657 = state_20630__$1;
(statearr_20637_20657[(2)] = null);

(statearr_20637_20657[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (6))){
var inst_20609 = (state_20630[(7)]);
var state_20630__$1 = state_20630;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20630__$1,(11),to,inst_20609);
} else {
if((state_val_20631 === (3))){
var inst_20628 = (state_20630[(2)]);
var state_20630__$1 = state_20630;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20630__$1,inst_20628);
} else {
if((state_val_20631 === (12))){
var state_20630__$1 = state_20630;
var statearr_20638_20658 = state_20630__$1;
(statearr_20638_20658[(2)] = null);

(statearr_20638_20658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (2))){
var state_20630__$1 = state_20630;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20630__$1,(4),from);
} else {
if((state_val_20631 === (11))){
var inst_20619 = (state_20630[(2)]);
var state_20630__$1 = state_20630;
if(cljs.core.truth_(inst_20619)){
var statearr_20639_20659 = state_20630__$1;
(statearr_20639_20659[(1)] = (12));

} else {
var statearr_20640_20660 = state_20630__$1;
(statearr_20640_20660[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (9))){
var state_20630__$1 = state_20630;
var statearr_20641_20661 = state_20630__$1;
(statearr_20641_20661[(2)] = null);

(statearr_20641_20661[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (5))){
var state_20630__$1 = state_20630;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20642_20662 = state_20630__$1;
(statearr_20642_20662[(1)] = (8));

} else {
var statearr_20643_20663 = state_20630__$1;
(statearr_20643_20663[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (14))){
var inst_20624 = (state_20630[(2)]);
var state_20630__$1 = state_20630;
var statearr_20644_20664 = state_20630__$1;
(statearr_20644_20664[(2)] = inst_20624);

(statearr_20644_20664[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (10))){
var inst_20616 = (state_20630[(2)]);
var state_20630__$1 = state_20630;
var statearr_20645_20665 = state_20630__$1;
(statearr_20645_20665[(2)] = inst_20616);

(statearr_20645_20665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20631 === (8))){
var inst_20613 = cljs.core.async.close_BANG_.call(null,to);
var state_20630__$1 = state_20630;
var statearr_20646_20666 = state_20630__$1;
(statearr_20646_20666[(2)] = inst_20613);

(statearr_20646_20666[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_20647 = [null,null,null,null,null,null,null,null];
(statearr_20647[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_20647[(1)] = (1));

return statearr_20647;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_20630){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_20630);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e20648){if((e20648 instanceof Object)){
var ex__20414__auto__ = e20648;
var statearr_20649_20667 = state_20630;
(statearr_20649_20667[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20630);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20648;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20668 = state_20630;
state_20630 = G__20668;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_20630){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_20630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_20650 = f__20508__auto__.call(null);
(statearr_20650[(6)] = c__20507__auto___20652);

return statearr_20650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process__$1 = (function (p__20669){
var vec__20670 = p__20669;
var v = cljs.core.nth.call(null,vec__20670,(0),null);
var p = cljs.core.nth.call(null,vec__20670,(1),null);
var job = vec__20670;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__20507__auto___20841 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_20677){
var state_val_20678 = (state_20677[(1)]);
if((state_val_20678 === (1))){
var state_20677__$1 = state_20677;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20677__$1,(2),res,v);
} else {
if((state_val_20678 === (2))){
var inst_20674 = (state_20677[(2)]);
var inst_20675 = cljs.core.async.close_BANG_.call(null,res);
var state_20677__$1 = (function (){var statearr_20679 = state_20677;
(statearr_20679[(7)] = inst_20674);

return statearr_20679;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20677__$1,inst_20675);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0 = (function (){
var statearr_20680 = [null,null,null,null,null,null,null,null];
(statearr_20680[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__);

(statearr_20680[(1)] = (1));

return statearr_20680;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1 = (function (state_20677){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_20677);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e20681){if((e20681 instanceof Object)){
var ex__20414__auto__ = e20681;
var statearr_20682_20842 = state_20677;
(statearr_20682_20842[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20677);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20681;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20843 = state_20677;
state_20677 = G__20843;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = function(state_20677){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1.call(this,state_20677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_20683 = f__20508__auto__.call(null);
(statearr_20683[(6)] = c__20507__auto___20841);

return statearr_20683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var async = (function (p__20684){
var vec__20685 = p__20684;
var v = cljs.core.nth.call(null,vec__20685,(0),null);
var p = cljs.core.nth.call(null,vec__20685,(1),null);
var job = vec__20685;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});
var n__5636__auto___20844 = n;
var __20845 = (0);
while(true){
if((__20845 < n__5636__auto___20844)){
var G__20688_20846 = type;
var G__20688_20847__$1 = (((G__20688_20846 instanceof cljs.core.Keyword))?G__20688_20846.fqn:null);
switch (G__20688_20847__$1) {
case "compute":
var c__20507__auto___20849 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20845,c__20507__auto___20849,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async){
return (function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = ((function (__20845,c__20507__auto___20849,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async){
return (function (state_20701){
var state_val_20702 = (state_20701[(1)]);
if((state_val_20702 === (1))){
var state_20701__$1 = state_20701;
var statearr_20703_20850 = state_20701__$1;
(statearr_20703_20850[(2)] = null);

(statearr_20703_20850[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20702 === (2))){
var state_20701__$1 = state_20701;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20701__$1,(4),jobs);
} else {
if((state_val_20702 === (3))){
var inst_20699 = (state_20701[(2)]);
var state_20701__$1 = state_20701;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20701__$1,inst_20699);
} else {
if((state_val_20702 === (4))){
var inst_20691 = (state_20701[(2)]);
var inst_20692 = process__$1.call(null,inst_20691);
var state_20701__$1 = state_20701;
if(cljs.core.truth_(inst_20692)){
var statearr_20704_20851 = state_20701__$1;
(statearr_20704_20851[(1)] = (5));

} else {
var statearr_20705_20852 = state_20701__$1;
(statearr_20705_20852[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20702 === (5))){
var state_20701__$1 = state_20701;
var statearr_20706_20853 = state_20701__$1;
(statearr_20706_20853[(2)] = null);

(statearr_20706_20853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20702 === (6))){
var state_20701__$1 = state_20701;
var statearr_20707_20854 = state_20701__$1;
(statearr_20707_20854[(2)] = null);

(statearr_20707_20854[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20702 === (7))){
var inst_20697 = (state_20701[(2)]);
var state_20701__$1 = state_20701;
var statearr_20708_20855 = state_20701__$1;
(statearr_20708_20855[(2)] = inst_20697);

(statearr_20708_20855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20845,c__20507__auto___20849,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async))
;
return ((function (__20845,switch__20410__auto__,c__20507__auto___20849,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0 = (function (){
var statearr_20709 = [null,null,null,null,null,null,null];
(statearr_20709[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__);

(statearr_20709[(1)] = (1));

return statearr_20709;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1 = (function (state_20701){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_20701);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e20710){if((e20710 instanceof Object)){
var ex__20414__auto__ = e20710;
var statearr_20711_20856 = state_20701;
(statearr_20711_20856[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20701);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20710;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20857 = state_20701;
state_20701 = G__20857;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = function(state_20701){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1.call(this,state_20701);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__;
})()
;})(__20845,switch__20410__auto__,c__20507__auto___20849,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async))
})();
var state__20509__auto__ = (function (){var statearr_20712 = f__20508__auto__.call(null);
(statearr_20712[(6)] = c__20507__auto___20849);

return statearr_20712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
});})(__20845,c__20507__auto___20849,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async))
);


break;
case "async":
var c__20507__auto___20858 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__20845,c__20507__auto___20858,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async){
return (function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = ((function (__20845,c__20507__auto___20858,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async){
return (function (state_20725){
var state_val_20726 = (state_20725[(1)]);
if((state_val_20726 === (1))){
var state_20725__$1 = state_20725;
var statearr_20727_20859 = state_20725__$1;
(statearr_20727_20859[(2)] = null);

(statearr_20727_20859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (2))){
var state_20725__$1 = state_20725;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20725__$1,(4),jobs);
} else {
if((state_val_20726 === (3))){
var inst_20723 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20725__$1,inst_20723);
} else {
if((state_val_20726 === (4))){
var inst_20715 = (state_20725[(2)]);
var inst_20716 = async.call(null,inst_20715);
var state_20725__$1 = state_20725;
if(cljs.core.truth_(inst_20716)){
var statearr_20728_20860 = state_20725__$1;
(statearr_20728_20860[(1)] = (5));

} else {
var statearr_20729_20861 = state_20725__$1;
(statearr_20729_20861[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (5))){
var state_20725__$1 = state_20725;
var statearr_20730_20862 = state_20725__$1;
(statearr_20730_20862[(2)] = null);

(statearr_20730_20862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (6))){
var state_20725__$1 = state_20725;
var statearr_20731_20863 = state_20725__$1;
(statearr_20731_20863[(2)] = null);

(statearr_20731_20863[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20726 === (7))){
var inst_20721 = (state_20725[(2)]);
var state_20725__$1 = state_20725;
var statearr_20732_20864 = state_20725__$1;
(statearr_20732_20864[(2)] = inst_20721);

(statearr_20732_20864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__20845,c__20507__auto___20858,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async))
;
return ((function (__20845,switch__20410__auto__,c__20507__auto___20858,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0 = (function (){
var statearr_20733 = [null,null,null,null,null,null,null];
(statearr_20733[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__);

(statearr_20733[(1)] = (1));

return statearr_20733;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1 = (function (state_20725){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_20725);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e20734){if((e20734 instanceof Object)){
var ex__20414__auto__ = e20734;
var statearr_20735_20865 = state_20725;
(statearr_20735_20865[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20725);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20866 = state_20725;
state_20725 = G__20866;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = function(state_20725){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1.call(this,state_20725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__;
})()
;})(__20845,switch__20410__auto__,c__20507__auto___20858,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async))
})();
var state__20509__auto__ = (function (){var statearr_20736 = f__20508__auto__.call(null);
(statearr_20736[(6)] = c__20507__auto___20858);

return statearr_20736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
});})(__20845,c__20507__auto___20858,G__20688_20846,G__20688_20847__$1,n__5636__auto___20844,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20688_20847__$1)].join('')));

}

var G__20867 = (__20845 + (1));
__20845 = G__20867;
continue;
} else {
}
break;
}

var c__20507__auto___20868 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_20758){
var state_val_20759 = (state_20758[(1)]);
if((state_val_20759 === (7))){
var inst_20754 = (state_20758[(2)]);
var state_20758__$1 = state_20758;
var statearr_20760_20869 = state_20758__$1;
(statearr_20760_20869[(2)] = inst_20754);

(statearr_20760_20869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20759 === (1))){
var state_20758__$1 = state_20758;
var statearr_20761_20870 = state_20758__$1;
(statearr_20761_20870[(2)] = null);

(statearr_20761_20870[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20759 === (4))){
var inst_20739 = (state_20758[(7)]);
var inst_20739__$1 = (state_20758[(2)]);
var inst_20740 = (inst_20739__$1 == null);
var state_20758__$1 = (function (){var statearr_20762 = state_20758;
(statearr_20762[(7)] = inst_20739__$1);

return statearr_20762;
})();
if(cljs.core.truth_(inst_20740)){
var statearr_20763_20871 = state_20758__$1;
(statearr_20763_20871[(1)] = (5));

} else {
var statearr_20764_20872 = state_20758__$1;
(statearr_20764_20872[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20759 === (6))){
var inst_20739 = (state_20758[(7)]);
var inst_20744 = (state_20758[(8)]);
var inst_20744__$1 = cljs.core.async.chan.call(null,(1));
var inst_20745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20746 = [inst_20739,inst_20744__$1];
var inst_20747 = (new cljs.core.PersistentVector(null,2,(5),inst_20745,inst_20746,null));
var state_20758__$1 = (function (){var statearr_20765 = state_20758;
(statearr_20765[(8)] = inst_20744__$1);

return statearr_20765;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20758__$1,(8),jobs,inst_20747);
} else {
if((state_val_20759 === (3))){
var inst_20756 = (state_20758[(2)]);
var state_20758__$1 = state_20758;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20758__$1,inst_20756);
} else {
if((state_val_20759 === (2))){
var state_20758__$1 = state_20758;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20758__$1,(4),from);
} else {
if((state_val_20759 === (9))){
var inst_20751 = (state_20758[(2)]);
var state_20758__$1 = (function (){var statearr_20766 = state_20758;
(statearr_20766[(9)] = inst_20751);

return statearr_20766;
})();
var statearr_20767_20873 = state_20758__$1;
(statearr_20767_20873[(2)] = null);

(statearr_20767_20873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20759 === (5))){
var inst_20742 = cljs.core.async.close_BANG_.call(null,jobs);
var state_20758__$1 = state_20758;
var statearr_20768_20874 = state_20758__$1;
(statearr_20768_20874[(2)] = inst_20742);

(statearr_20768_20874[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20759 === (8))){
var inst_20744 = (state_20758[(8)]);
var inst_20749 = (state_20758[(2)]);
var state_20758__$1 = (function (){var statearr_20769 = state_20758;
(statearr_20769[(10)] = inst_20749);

return statearr_20769;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20758__$1,(9),results,inst_20744);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0 = (function (){
var statearr_20770 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20770[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__);

(statearr_20770[(1)] = (1));

return statearr_20770;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1 = (function (state_20758){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_20758);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e20771){if((e20771 instanceof Object)){
var ex__20414__auto__ = e20771;
var statearr_20772_20875 = state_20758;
(statearr_20772_20875[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20758);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20771;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20876 = state_20758;
state_20758 = G__20876;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = function(state_20758){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1.call(this,state_20758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_20773 = f__20508__auto__.call(null);
(statearr_20773[(6)] = c__20507__auto___20868);

return statearr_20773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


var c__20507__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_20811){
var state_val_20812 = (state_20811[(1)]);
if((state_val_20812 === (7))){
var inst_20807 = (state_20811[(2)]);
var state_20811__$1 = state_20811;
var statearr_20813_20877 = state_20811__$1;
(statearr_20813_20877[(2)] = inst_20807);

(statearr_20813_20877[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (20))){
var state_20811__$1 = state_20811;
var statearr_20814_20878 = state_20811__$1;
(statearr_20814_20878[(2)] = null);

(statearr_20814_20878[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (1))){
var state_20811__$1 = state_20811;
var statearr_20815_20879 = state_20811__$1;
(statearr_20815_20879[(2)] = null);

(statearr_20815_20879[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (4))){
var inst_20776 = (state_20811[(7)]);
var inst_20776__$1 = (state_20811[(2)]);
var inst_20777 = (inst_20776__$1 == null);
var state_20811__$1 = (function (){var statearr_20816 = state_20811;
(statearr_20816[(7)] = inst_20776__$1);

return statearr_20816;
})();
if(cljs.core.truth_(inst_20777)){
var statearr_20817_20880 = state_20811__$1;
(statearr_20817_20880[(1)] = (5));

} else {
var statearr_20818_20881 = state_20811__$1;
(statearr_20818_20881[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (15))){
var inst_20789 = (state_20811[(8)]);
var state_20811__$1 = state_20811;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20811__$1,(18),to,inst_20789);
} else {
if((state_val_20812 === (21))){
var inst_20802 = (state_20811[(2)]);
var state_20811__$1 = state_20811;
var statearr_20819_20882 = state_20811__$1;
(statearr_20819_20882[(2)] = inst_20802);

(statearr_20819_20882[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (13))){
var inst_20804 = (state_20811[(2)]);
var state_20811__$1 = (function (){var statearr_20820 = state_20811;
(statearr_20820[(9)] = inst_20804);

return statearr_20820;
})();
var statearr_20821_20883 = state_20811__$1;
(statearr_20821_20883[(2)] = null);

(statearr_20821_20883[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (6))){
var inst_20776 = (state_20811[(7)]);
var state_20811__$1 = state_20811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20811__$1,(11),inst_20776);
} else {
if((state_val_20812 === (17))){
var inst_20797 = (state_20811[(2)]);
var state_20811__$1 = state_20811;
if(cljs.core.truth_(inst_20797)){
var statearr_20822_20884 = state_20811__$1;
(statearr_20822_20884[(1)] = (19));

} else {
var statearr_20823_20885 = state_20811__$1;
(statearr_20823_20885[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (3))){
var inst_20809 = (state_20811[(2)]);
var state_20811__$1 = state_20811;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20811__$1,inst_20809);
} else {
if((state_val_20812 === (12))){
var inst_20786 = (state_20811[(10)]);
var state_20811__$1 = state_20811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20811__$1,(14),inst_20786);
} else {
if((state_val_20812 === (2))){
var state_20811__$1 = state_20811;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20811__$1,(4),results);
} else {
if((state_val_20812 === (19))){
var state_20811__$1 = state_20811;
var statearr_20824_20886 = state_20811__$1;
(statearr_20824_20886[(2)] = null);

(statearr_20824_20886[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (11))){
var inst_20786 = (state_20811[(2)]);
var state_20811__$1 = (function (){var statearr_20825 = state_20811;
(statearr_20825[(10)] = inst_20786);

return statearr_20825;
})();
var statearr_20826_20887 = state_20811__$1;
(statearr_20826_20887[(2)] = null);

(statearr_20826_20887[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (9))){
var state_20811__$1 = state_20811;
var statearr_20827_20888 = state_20811__$1;
(statearr_20827_20888[(2)] = null);

(statearr_20827_20888[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (5))){
var state_20811__$1 = state_20811;
if(cljs.core.truth_(close_QMARK_)){
var statearr_20828_20889 = state_20811__$1;
(statearr_20828_20889[(1)] = (8));

} else {
var statearr_20829_20890 = state_20811__$1;
(statearr_20829_20890[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (14))){
var inst_20789 = (state_20811[(8)]);
var inst_20791 = (state_20811[(11)]);
var inst_20789__$1 = (state_20811[(2)]);
var inst_20790 = (inst_20789__$1 == null);
var inst_20791__$1 = cljs.core.not.call(null,inst_20790);
var state_20811__$1 = (function (){var statearr_20830 = state_20811;
(statearr_20830[(8)] = inst_20789__$1);

(statearr_20830[(11)] = inst_20791__$1);

return statearr_20830;
})();
if(inst_20791__$1){
var statearr_20831_20891 = state_20811__$1;
(statearr_20831_20891[(1)] = (15));

} else {
var statearr_20832_20892 = state_20811__$1;
(statearr_20832_20892[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (16))){
var inst_20791 = (state_20811[(11)]);
var state_20811__$1 = state_20811;
var statearr_20833_20893 = state_20811__$1;
(statearr_20833_20893[(2)] = inst_20791);

(statearr_20833_20893[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (10))){
var inst_20783 = (state_20811[(2)]);
var state_20811__$1 = state_20811;
var statearr_20834_20894 = state_20811__$1;
(statearr_20834_20894[(2)] = inst_20783);

(statearr_20834_20894[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (18))){
var inst_20794 = (state_20811[(2)]);
var state_20811__$1 = state_20811;
var statearr_20835_20895 = state_20811__$1;
(statearr_20835_20895[(2)] = inst_20794);

(statearr_20835_20895[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20812 === (8))){
var inst_20780 = cljs.core.async.close_BANG_.call(null,to);
var state_20811__$1 = state_20811;
var statearr_20836_20896 = state_20811__$1;
(statearr_20836_20896[(2)] = inst_20780);

(statearr_20836_20896[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0 = (function (){
var statearr_20837 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20837[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__);

(statearr_20837[(1)] = (1));

return statearr_20837;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1 = (function (state_20811){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_20811);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e20838){if((e20838 instanceof Object)){
var ex__20414__auto__ = e20838;
var statearr_20839_20897 = state_20811;
(statearr_20839_20897[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20811);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20838;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20898 = state_20811;
state_20811 = G__20898;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__ = function(state_20811){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1.call(this,state_20811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20411__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_20840 = f__20508__auto__.call(null);
(statearr_20840[(6)] = c__20507__auto__);

return statearr_20840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));

return c__20507__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__20900 = arguments.length;
switch (G__20900) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__20903 = arguments.length;
switch (G__20903) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__20906 = arguments.length;
switch (G__20906) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__20507__auto___20955 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_20932){
var state_val_20933 = (state_20932[(1)]);
if((state_val_20933 === (7))){
var inst_20928 = (state_20932[(2)]);
var state_20932__$1 = state_20932;
var statearr_20934_20956 = state_20932__$1;
(statearr_20934_20956[(2)] = inst_20928);

(statearr_20934_20956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (1))){
var state_20932__$1 = state_20932;
var statearr_20935_20957 = state_20932__$1;
(statearr_20935_20957[(2)] = null);

(statearr_20935_20957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (4))){
var inst_20909 = (state_20932[(7)]);
var inst_20909__$1 = (state_20932[(2)]);
var inst_20910 = (inst_20909__$1 == null);
var state_20932__$1 = (function (){var statearr_20936 = state_20932;
(statearr_20936[(7)] = inst_20909__$1);

return statearr_20936;
})();
if(cljs.core.truth_(inst_20910)){
var statearr_20937_20958 = state_20932__$1;
(statearr_20937_20958[(1)] = (5));

} else {
var statearr_20938_20959 = state_20932__$1;
(statearr_20938_20959[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (13))){
var state_20932__$1 = state_20932;
var statearr_20939_20960 = state_20932__$1;
(statearr_20939_20960[(2)] = null);

(statearr_20939_20960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (6))){
var inst_20909 = (state_20932[(7)]);
var inst_20915 = p.call(null,inst_20909);
var state_20932__$1 = state_20932;
if(cljs.core.truth_(inst_20915)){
var statearr_20940_20961 = state_20932__$1;
(statearr_20940_20961[(1)] = (9));

} else {
var statearr_20941_20962 = state_20932__$1;
(statearr_20941_20962[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (3))){
var inst_20930 = (state_20932[(2)]);
var state_20932__$1 = state_20932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20932__$1,inst_20930);
} else {
if((state_val_20933 === (12))){
var state_20932__$1 = state_20932;
var statearr_20942_20963 = state_20932__$1;
(statearr_20942_20963[(2)] = null);

(statearr_20942_20963[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (2))){
var state_20932__$1 = state_20932;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20932__$1,(4),ch);
} else {
if((state_val_20933 === (11))){
var inst_20909 = (state_20932[(7)]);
var inst_20919 = (state_20932[(2)]);
var state_20932__$1 = state_20932;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20932__$1,(8),inst_20919,inst_20909);
} else {
if((state_val_20933 === (9))){
var state_20932__$1 = state_20932;
var statearr_20943_20964 = state_20932__$1;
(statearr_20943_20964[(2)] = tc);

(statearr_20943_20964[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (5))){
var inst_20912 = cljs.core.async.close_BANG_.call(null,tc);
var inst_20913 = cljs.core.async.close_BANG_.call(null,fc);
var state_20932__$1 = (function (){var statearr_20944 = state_20932;
(statearr_20944[(8)] = inst_20912);

return statearr_20944;
})();
var statearr_20945_20965 = state_20932__$1;
(statearr_20945_20965[(2)] = inst_20913);

(statearr_20945_20965[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (14))){
var inst_20926 = (state_20932[(2)]);
var state_20932__$1 = state_20932;
var statearr_20946_20966 = state_20932__$1;
(statearr_20946_20966[(2)] = inst_20926);

(statearr_20946_20966[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (10))){
var state_20932__$1 = state_20932;
var statearr_20947_20967 = state_20932__$1;
(statearr_20947_20967[(2)] = fc);

(statearr_20947_20967[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20933 === (8))){
var inst_20921 = (state_20932[(2)]);
var state_20932__$1 = state_20932;
if(cljs.core.truth_(inst_20921)){
var statearr_20948_20968 = state_20932__$1;
(statearr_20948_20968[(1)] = (12));

} else {
var statearr_20949_20969 = state_20932__$1;
(statearr_20949_20969[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_20950 = [null,null,null,null,null,null,null,null,null];
(statearr_20950[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_20950[(1)] = (1));

return statearr_20950;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_20932){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_20932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e20951){if((e20951 instanceof Object)){
var ex__20414__auto__ = e20951;
var statearr_20952_20970 = state_20932;
(statearr_20952_20970[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20932);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20951;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20971 = state_20932;
state_20932 = G__20971;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_20932){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_20932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_20953 = f__20508__auto__.call(null);
(statearr_20953[(6)] = c__20507__auto___20955);

return statearr_20953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20507__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_20992){
var state_val_20993 = (state_20992[(1)]);
if((state_val_20993 === (7))){
var inst_20988 = (state_20992[(2)]);
var state_20992__$1 = state_20992;
var statearr_20994_21012 = state_20992__$1;
(statearr_20994_21012[(2)] = inst_20988);

(statearr_20994_21012[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20993 === (1))){
var inst_20972 = init;
var state_20992__$1 = (function (){var statearr_20995 = state_20992;
(statearr_20995[(7)] = inst_20972);

return statearr_20995;
})();
var statearr_20996_21013 = state_20992__$1;
(statearr_20996_21013[(2)] = null);

(statearr_20996_21013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20993 === (4))){
var inst_20975 = (state_20992[(8)]);
var inst_20975__$1 = (state_20992[(2)]);
var inst_20976 = (inst_20975__$1 == null);
var state_20992__$1 = (function (){var statearr_20997 = state_20992;
(statearr_20997[(8)] = inst_20975__$1);

return statearr_20997;
})();
if(cljs.core.truth_(inst_20976)){
var statearr_20998_21014 = state_20992__$1;
(statearr_20998_21014[(1)] = (5));

} else {
var statearr_20999_21015 = state_20992__$1;
(statearr_20999_21015[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20993 === (6))){
var inst_20979 = (state_20992[(9)]);
var inst_20972 = (state_20992[(7)]);
var inst_20975 = (state_20992[(8)]);
var inst_20979__$1 = f.call(null,inst_20972,inst_20975);
var inst_20980 = cljs.core.reduced_QMARK_.call(null,inst_20979__$1);
var state_20992__$1 = (function (){var statearr_21000 = state_20992;
(statearr_21000[(9)] = inst_20979__$1);

return statearr_21000;
})();
if(inst_20980){
var statearr_21001_21016 = state_20992__$1;
(statearr_21001_21016[(1)] = (8));

} else {
var statearr_21002_21017 = state_20992__$1;
(statearr_21002_21017[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20993 === (3))){
var inst_20990 = (state_20992[(2)]);
var state_20992__$1 = state_20992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20992__$1,inst_20990);
} else {
if((state_val_20993 === (2))){
var state_20992__$1 = state_20992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20992__$1,(4),ch);
} else {
if((state_val_20993 === (9))){
var inst_20979 = (state_20992[(9)]);
var inst_20972 = inst_20979;
var state_20992__$1 = (function (){var statearr_21003 = state_20992;
(statearr_21003[(7)] = inst_20972);

return statearr_21003;
})();
var statearr_21004_21018 = state_20992__$1;
(statearr_21004_21018[(2)] = null);

(statearr_21004_21018[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20993 === (5))){
var inst_20972 = (state_20992[(7)]);
var state_20992__$1 = state_20992;
var statearr_21005_21019 = state_20992__$1;
(statearr_21005_21019[(2)] = inst_20972);

(statearr_21005_21019[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20993 === (10))){
var inst_20986 = (state_20992[(2)]);
var state_20992__$1 = state_20992;
var statearr_21006_21020 = state_20992__$1;
(statearr_21006_21020[(2)] = inst_20986);

(statearr_21006_21020[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20993 === (8))){
var inst_20979 = (state_20992[(9)]);
var inst_20982 = cljs.core.deref.call(null,inst_20979);
var state_20992__$1 = state_20992;
var statearr_21007_21021 = state_20992__$1;
(statearr_21007_21021[(2)] = inst_20982);

(statearr_21007_21021[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__20411__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20411__auto____0 = (function (){
var statearr_21008 = [null,null,null,null,null,null,null,null,null,null];
(statearr_21008[(0)] = cljs$core$async$reduce_$_state_machine__20411__auto__);

(statearr_21008[(1)] = (1));

return statearr_21008;
});
var cljs$core$async$reduce_$_state_machine__20411__auto____1 = (function (state_20992){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_20992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21009){if((e21009 instanceof Object)){
var ex__20414__auto__ = e21009;
var statearr_21010_21022 = state_20992;
(statearr_21010_21022[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20992);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21009;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21023 = state_20992;
state_20992 = G__21023;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20411__auto__ = function(state_20992){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20411__auto____1.call(this,state_20992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20411__auto____0;
cljs$core$async$reduce_$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20411__auto____1;
return cljs$core$async$reduce_$_state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21011 = f__20508__auto__.call(null);
(statearr_21011[(6)] = c__20507__auto__);

return statearr_21011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));

return c__20507__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__20507__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_21029){
var state_val_21030 = (state_21029[(1)]);
if((state_val_21030 === (1))){
var inst_21024 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_21029__$1 = state_21029;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21029__$1,(2),inst_21024);
} else {
if((state_val_21030 === (2))){
var inst_21026 = (state_21029[(2)]);
var inst_21027 = f__$1.call(null,inst_21026);
var state_21029__$1 = state_21029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21029__$1,inst_21027);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__20411__auto__ = null;
var cljs$core$async$transduce_$_state_machine__20411__auto____0 = (function (){
var statearr_21031 = [null,null,null,null,null,null,null];
(statearr_21031[(0)] = cljs$core$async$transduce_$_state_machine__20411__auto__);

(statearr_21031[(1)] = (1));

return statearr_21031;
});
var cljs$core$async$transduce_$_state_machine__20411__auto____1 = (function (state_21029){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_21029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21032){if((e21032 instanceof Object)){
var ex__20414__auto__ = e21032;
var statearr_21033_21035 = state_21029;
(statearr_21033_21035[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21029);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21032;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21036 = state_21029;
state_21029 = G__21036;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__20411__auto__ = function(state_21029){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__20411__auto____1.call(this,state_21029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__20411__auto____0;
cljs$core$async$transduce_$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__20411__auto____1;
return cljs$core$async$transduce_$_state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21034 = f__20508__auto__.call(null);
(statearr_21034[(6)] = c__20507__auto__);

return statearr_21034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));

return c__20507__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__21038 = arguments.length;
switch (G__21038) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20507__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_21063){
var state_val_21064 = (state_21063[(1)]);
if((state_val_21064 === (7))){
var inst_21045 = (state_21063[(2)]);
var state_21063__$1 = state_21063;
var statearr_21065_21086 = state_21063__$1;
(statearr_21065_21086[(2)] = inst_21045);

(statearr_21065_21086[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (1))){
var inst_21039 = cljs.core.seq.call(null,coll);
var inst_21040 = inst_21039;
var state_21063__$1 = (function (){var statearr_21066 = state_21063;
(statearr_21066[(7)] = inst_21040);

return statearr_21066;
})();
var statearr_21067_21087 = state_21063__$1;
(statearr_21067_21087[(2)] = null);

(statearr_21067_21087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (4))){
var inst_21040 = (state_21063[(7)]);
var inst_21043 = cljs.core.first.call(null,inst_21040);
var state_21063__$1 = state_21063;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21063__$1,(7),ch,inst_21043);
} else {
if((state_val_21064 === (13))){
var inst_21057 = (state_21063[(2)]);
var state_21063__$1 = state_21063;
var statearr_21068_21088 = state_21063__$1;
(statearr_21068_21088[(2)] = inst_21057);

(statearr_21068_21088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (6))){
var inst_21048 = (state_21063[(2)]);
var state_21063__$1 = state_21063;
if(cljs.core.truth_(inst_21048)){
var statearr_21069_21089 = state_21063__$1;
(statearr_21069_21089[(1)] = (8));

} else {
var statearr_21070_21090 = state_21063__$1;
(statearr_21070_21090[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (3))){
var inst_21061 = (state_21063[(2)]);
var state_21063__$1 = state_21063;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21063__$1,inst_21061);
} else {
if((state_val_21064 === (12))){
var state_21063__$1 = state_21063;
var statearr_21071_21091 = state_21063__$1;
(statearr_21071_21091[(2)] = null);

(statearr_21071_21091[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (2))){
var inst_21040 = (state_21063[(7)]);
var state_21063__$1 = state_21063;
if(cljs.core.truth_(inst_21040)){
var statearr_21072_21092 = state_21063__$1;
(statearr_21072_21092[(1)] = (4));

} else {
var statearr_21073_21093 = state_21063__$1;
(statearr_21073_21093[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (11))){
var inst_21054 = cljs.core.async.close_BANG_.call(null,ch);
var state_21063__$1 = state_21063;
var statearr_21074_21094 = state_21063__$1;
(statearr_21074_21094[(2)] = inst_21054);

(statearr_21074_21094[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (9))){
var state_21063__$1 = state_21063;
if(cljs.core.truth_(close_QMARK_)){
var statearr_21075_21095 = state_21063__$1;
(statearr_21075_21095[(1)] = (11));

} else {
var statearr_21076_21096 = state_21063__$1;
(statearr_21076_21096[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (5))){
var inst_21040 = (state_21063[(7)]);
var state_21063__$1 = state_21063;
var statearr_21077_21097 = state_21063__$1;
(statearr_21077_21097[(2)] = inst_21040);

(statearr_21077_21097[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (10))){
var inst_21059 = (state_21063[(2)]);
var state_21063__$1 = state_21063;
var statearr_21078_21098 = state_21063__$1;
(statearr_21078_21098[(2)] = inst_21059);

(statearr_21078_21098[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21064 === (8))){
var inst_21040 = (state_21063[(7)]);
var inst_21050 = cljs.core.next.call(null,inst_21040);
var inst_21040__$1 = inst_21050;
var state_21063__$1 = (function (){var statearr_21079 = state_21063;
(statearr_21079[(7)] = inst_21040__$1);

return statearr_21079;
})();
var statearr_21080_21099 = state_21063__$1;
(statearr_21080_21099[(2)] = null);

(statearr_21080_21099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_21081 = [null,null,null,null,null,null,null,null];
(statearr_21081[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_21081[(1)] = (1));

return statearr_21081;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_21063){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_21063);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21082){if((e21082 instanceof Object)){
var ex__20414__auto__ = e21082;
var statearr_21083_21100 = state_21063;
(statearr_21083_21100[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21063);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21082;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21101 = state_21063;
state_21063 = G__21101;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_21063){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_21063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21084 = f__20508__auto__.call(null);
(statearr_21084[(6)] = c__20507__auto__);

return statearr_21084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));

return c__20507__auto__;
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_21102 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,_);
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_21102.call(null,_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_21103 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_21103.call(null,m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_21104 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,ch);
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_21104.call(null,m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_21105 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m);
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_21105.call(null,m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21106 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21106 = (function (ch,cs,meta21107){
this.ch = ch;
this.cs = cs;
this.meta21107 = meta21107;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21106.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21108,meta21107__$1){
var self__ = this;
var _21108__$1 = this;
return (new cljs.core.async.t_cljs$core$async21106(self__.ch,self__.cs,meta21107__$1));
}));

(cljs.core.async.t_cljs$core$async21106.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21108){
var self__ = this;
var _21108__$1 = this;
return self__.meta21107;
}));

(cljs.core.async.t_cljs$core$async21106.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21106.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async21106.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21106.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async21106.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async21106.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async21106.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta21107","meta21107",-124485938,null)], null);
}));

(cljs.core.async.t_cljs$core$async21106.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21106.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21106");

(cljs.core.async.t_cljs$core$async21106.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async21106");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21106.
 */
cljs.core.async.__GT_t_cljs$core$async21106 = (function cljs$core$async$mult_$___GT_t_cljs$core$async21106(ch__$1,cs__$1,meta21107){
return (new cljs.core.async.t_cljs$core$async21106(ch__$1,cs__$1,meta21107));
});

}

return (new cljs.core.async.t_cljs$core$async21106(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});
var c__20507__auto___21328 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_21243){
var state_val_21244 = (state_21243[(1)]);
if((state_val_21244 === (7))){
var inst_21239 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
var statearr_21245_21329 = state_21243__$1;
(statearr_21245_21329[(2)] = inst_21239);

(statearr_21245_21329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (20))){
var inst_21142 = (state_21243[(7)]);
var inst_21154 = cljs.core.first.call(null,inst_21142);
var inst_21155 = cljs.core.nth.call(null,inst_21154,(0),null);
var inst_21156 = cljs.core.nth.call(null,inst_21154,(1),null);
var state_21243__$1 = (function (){var statearr_21246 = state_21243;
(statearr_21246[(8)] = inst_21155);

return statearr_21246;
})();
if(cljs.core.truth_(inst_21156)){
var statearr_21247_21330 = state_21243__$1;
(statearr_21247_21330[(1)] = (22));

} else {
var statearr_21248_21331 = state_21243__$1;
(statearr_21248_21331[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (27))){
var inst_21184 = (state_21243[(9)]);
var inst_21111 = (state_21243[(10)]);
var inst_21191 = (state_21243[(11)]);
var inst_21186 = (state_21243[(12)]);
var inst_21191__$1 = cljs.core._nth.call(null,inst_21184,inst_21186);
var inst_21192 = cljs.core.async.put_BANG_.call(null,inst_21191__$1,inst_21111,done);
var state_21243__$1 = (function (){var statearr_21249 = state_21243;
(statearr_21249[(11)] = inst_21191__$1);

return statearr_21249;
})();
if(cljs.core.truth_(inst_21192)){
var statearr_21250_21332 = state_21243__$1;
(statearr_21250_21332[(1)] = (30));

} else {
var statearr_21251_21333 = state_21243__$1;
(statearr_21251_21333[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (1))){
var state_21243__$1 = state_21243;
var statearr_21252_21334 = state_21243__$1;
(statearr_21252_21334[(2)] = null);

(statearr_21252_21334[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (24))){
var inst_21142 = (state_21243[(7)]);
var inst_21161 = (state_21243[(2)]);
var inst_21162 = cljs.core.next.call(null,inst_21142);
var inst_21120 = inst_21162;
var inst_21121 = null;
var inst_21122 = (0);
var inst_21123 = (0);
var state_21243__$1 = (function (){var statearr_21253 = state_21243;
(statearr_21253[(13)] = inst_21120);

(statearr_21253[(14)] = inst_21123);

(statearr_21253[(15)] = inst_21121);

(statearr_21253[(16)] = inst_21122);

(statearr_21253[(17)] = inst_21161);

return statearr_21253;
})();
var statearr_21254_21335 = state_21243__$1;
(statearr_21254_21335[(2)] = null);

(statearr_21254_21335[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (39))){
var state_21243__$1 = state_21243;
var statearr_21258_21336 = state_21243__$1;
(statearr_21258_21336[(2)] = null);

(statearr_21258_21336[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (4))){
var inst_21111 = (state_21243[(10)]);
var inst_21111__$1 = (state_21243[(2)]);
var inst_21112 = (inst_21111__$1 == null);
var state_21243__$1 = (function (){var statearr_21259 = state_21243;
(statearr_21259[(10)] = inst_21111__$1);

return statearr_21259;
})();
if(cljs.core.truth_(inst_21112)){
var statearr_21260_21337 = state_21243__$1;
(statearr_21260_21337[(1)] = (5));

} else {
var statearr_21261_21338 = state_21243__$1;
(statearr_21261_21338[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (15))){
var inst_21120 = (state_21243[(13)]);
var inst_21123 = (state_21243[(14)]);
var inst_21121 = (state_21243[(15)]);
var inst_21122 = (state_21243[(16)]);
var inst_21138 = (state_21243[(2)]);
var inst_21139 = (inst_21123 + (1));
var tmp21255 = inst_21120;
var tmp21256 = inst_21121;
var tmp21257 = inst_21122;
var inst_21120__$1 = tmp21255;
var inst_21121__$1 = tmp21256;
var inst_21122__$1 = tmp21257;
var inst_21123__$1 = inst_21139;
var state_21243__$1 = (function (){var statearr_21262 = state_21243;
(statearr_21262[(13)] = inst_21120__$1);

(statearr_21262[(18)] = inst_21138);

(statearr_21262[(14)] = inst_21123__$1);

(statearr_21262[(15)] = inst_21121__$1);

(statearr_21262[(16)] = inst_21122__$1);

return statearr_21262;
})();
var statearr_21263_21339 = state_21243__$1;
(statearr_21263_21339[(2)] = null);

(statearr_21263_21339[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (21))){
var inst_21165 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
var statearr_21267_21340 = state_21243__$1;
(statearr_21267_21340[(2)] = inst_21165);

(statearr_21267_21340[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (31))){
var inst_21191 = (state_21243[(11)]);
var inst_21195 = done.call(null,null);
var inst_21196 = cljs.core.async.untap_STAR_.call(null,m,inst_21191);
var state_21243__$1 = (function (){var statearr_21268 = state_21243;
(statearr_21268[(19)] = inst_21195);

return statearr_21268;
})();
var statearr_21269_21341 = state_21243__$1;
(statearr_21269_21341[(2)] = inst_21196);

(statearr_21269_21341[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (32))){
var inst_21185 = (state_21243[(20)]);
var inst_21184 = (state_21243[(9)]);
var inst_21183 = (state_21243[(21)]);
var inst_21186 = (state_21243[(12)]);
var inst_21198 = (state_21243[(2)]);
var inst_21199 = (inst_21186 + (1));
var tmp21264 = inst_21185;
var tmp21265 = inst_21184;
var tmp21266 = inst_21183;
var inst_21183__$1 = tmp21266;
var inst_21184__$1 = tmp21265;
var inst_21185__$1 = tmp21264;
var inst_21186__$1 = inst_21199;
var state_21243__$1 = (function (){var statearr_21270 = state_21243;
(statearr_21270[(20)] = inst_21185__$1);

(statearr_21270[(9)] = inst_21184__$1);

(statearr_21270[(21)] = inst_21183__$1);

(statearr_21270[(22)] = inst_21198);

(statearr_21270[(12)] = inst_21186__$1);

return statearr_21270;
})();
var statearr_21271_21342 = state_21243__$1;
(statearr_21271_21342[(2)] = null);

(statearr_21271_21342[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (40))){
var inst_21211 = (state_21243[(23)]);
var inst_21215 = done.call(null,null);
var inst_21216 = cljs.core.async.untap_STAR_.call(null,m,inst_21211);
var state_21243__$1 = (function (){var statearr_21272 = state_21243;
(statearr_21272[(24)] = inst_21215);

return statearr_21272;
})();
var statearr_21273_21343 = state_21243__$1;
(statearr_21273_21343[(2)] = inst_21216);

(statearr_21273_21343[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (33))){
var inst_21202 = (state_21243[(25)]);
var inst_21204 = cljs.core.chunked_seq_QMARK_.call(null,inst_21202);
var state_21243__$1 = state_21243;
if(inst_21204){
var statearr_21274_21344 = state_21243__$1;
(statearr_21274_21344[(1)] = (36));

} else {
var statearr_21275_21345 = state_21243__$1;
(statearr_21275_21345[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (13))){
var inst_21132 = (state_21243[(26)]);
var inst_21135 = cljs.core.async.close_BANG_.call(null,inst_21132);
var state_21243__$1 = state_21243;
var statearr_21276_21346 = state_21243__$1;
(statearr_21276_21346[(2)] = inst_21135);

(statearr_21276_21346[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (22))){
var inst_21155 = (state_21243[(8)]);
var inst_21158 = cljs.core.async.close_BANG_.call(null,inst_21155);
var state_21243__$1 = state_21243;
var statearr_21277_21347 = state_21243__$1;
(statearr_21277_21347[(2)] = inst_21158);

(statearr_21277_21347[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (36))){
var inst_21202 = (state_21243[(25)]);
var inst_21206 = cljs.core.chunk_first.call(null,inst_21202);
var inst_21207 = cljs.core.chunk_rest.call(null,inst_21202);
var inst_21208 = cljs.core.count.call(null,inst_21206);
var inst_21183 = inst_21207;
var inst_21184 = inst_21206;
var inst_21185 = inst_21208;
var inst_21186 = (0);
var state_21243__$1 = (function (){var statearr_21278 = state_21243;
(statearr_21278[(20)] = inst_21185);

(statearr_21278[(9)] = inst_21184);

(statearr_21278[(21)] = inst_21183);

(statearr_21278[(12)] = inst_21186);

return statearr_21278;
})();
var statearr_21279_21348 = state_21243__$1;
(statearr_21279_21348[(2)] = null);

(statearr_21279_21348[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (41))){
var inst_21202 = (state_21243[(25)]);
var inst_21218 = (state_21243[(2)]);
var inst_21219 = cljs.core.next.call(null,inst_21202);
var inst_21183 = inst_21219;
var inst_21184 = null;
var inst_21185 = (0);
var inst_21186 = (0);
var state_21243__$1 = (function (){var statearr_21280 = state_21243;
(statearr_21280[(27)] = inst_21218);

(statearr_21280[(20)] = inst_21185);

(statearr_21280[(9)] = inst_21184);

(statearr_21280[(21)] = inst_21183);

(statearr_21280[(12)] = inst_21186);

return statearr_21280;
})();
var statearr_21281_21349 = state_21243__$1;
(statearr_21281_21349[(2)] = null);

(statearr_21281_21349[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (43))){
var state_21243__$1 = state_21243;
var statearr_21282_21350 = state_21243__$1;
(statearr_21282_21350[(2)] = null);

(statearr_21282_21350[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (29))){
var inst_21227 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
var statearr_21283_21351 = state_21243__$1;
(statearr_21283_21351[(2)] = inst_21227);

(statearr_21283_21351[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (44))){
var inst_21236 = (state_21243[(2)]);
var state_21243__$1 = (function (){var statearr_21284 = state_21243;
(statearr_21284[(28)] = inst_21236);

return statearr_21284;
})();
var statearr_21285_21352 = state_21243__$1;
(statearr_21285_21352[(2)] = null);

(statearr_21285_21352[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (6))){
var inst_21175 = (state_21243[(29)]);
var inst_21174 = cljs.core.deref.call(null,cs);
var inst_21175__$1 = cljs.core.keys.call(null,inst_21174);
var inst_21176 = cljs.core.count.call(null,inst_21175__$1);
var inst_21177 = cljs.core.reset_BANG_.call(null,dctr,inst_21176);
var inst_21182 = cljs.core.seq.call(null,inst_21175__$1);
var inst_21183 = inst_21182;
var inst_21184 = null;
var inst_21185 = (0);
var inst_21186 = (0);
var state_21243__$1 = (function (){var statearr_21286 = state_21243;
(statearr_21286[(20)] = inst_21185);

(statearr_21286[(9)] = inst_21184);

(statearr_21286[(30)] = inst_21177);

(statearr_21286[(29)] = inst_21175__$1);

(statearr_21286[(21)] = inst_21183);

(statearr_21286[(12)] = inst_21186);

return statearr_21286;
})();
var statearr_21287_21353 = state_21243__$1;
(statearr_21287_21353[(2)] = null);

(statearr_21287_21353[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (28))){
var inst_21183 = (state_21243[(21)]);
var inst_21202 = (state_21243[(25)]);
var inst_21202__$1 = cljs.core.seq.call(null,inst_21183);
var state_21243__$1 = (function (){var statearr_21288 = state_21243;
(statearr_21288[(25)] = inst_21202__$1);

return statearr_21288;
})();
if(inst_21202__$1){
var statearr_21289_21354 = state_21243__$1;
(statearr_21289_21354[(1)] = (33));

} else {
var statearr_21290_21355 = state_21243__$1;
(statearr_21290_21355[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (25))){
var inst_21185 = (state_21243[(20)]);
var inst_21186 = (state_21243[(12)]);
var inst_21188 = (inst_21186 < inst_21185);
var inst_21189 = inst_21188;
var state_21243__$1 = state_21243;
if(cljs.core.truth_(inst_21189)){
var statearr_21291_21356 = state_21243__$1;
(statearr_21291_21356[(1)] = (27));

} else {
var statearr_21292_21357 = state_21243__$1;
(statearr_21292_21357[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (34))){
var state_21243__$1 = state_21243;
var statearr_21293_21358 = state_21243__$1;
(statearr_21293_21358[(2)] = null);

(statearr_21293_21358[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (17))){
var state_21243__$1 = state_21243;
var statearr_21294_21359 = state_21243__$1;
(statearr_21294_21359[(2)] = null);

(statearr_21294_21359[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (3))){
var inst_21241 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21243__$1,inst_21241);
} else {
if((state_val_21244 === (12))){
var inst_21170 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
var statearr_21295_21360 = state_21243__$1;
(statearr_21295_21360[(2)] = inst_21170);

(statearr_21295_21360[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (2))){
var state_21243__$1 = state_21243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21243__$1,(4),ch);
} else {
if((state_val_21244 === (23))){
var state_21243__$1 = state_21243;
var statearr_21296_21361 = state_21243__$1;
(statearr_21296_21361[(2)] = null);

(statearr_21296_21361[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (35))){
var inst_21225 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
var statearr_21297_21362 = state_21243__$1;
(statearr_21297_21362[(2)] = inst_21225);

(statearr_21297_21362[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (19))){
var inst_21142 = (state_21243[(7)]);
var inst_21146 = cljs.core.chunk_first.call(null,inst_21142);
var inst_21147 = cljs.core.chunk_rest.call(null,inst_21142);
var inst_21148 = cljs.core.count.call(null,inst_21146);
var inst_21120 = inst_21147;
var inst_21121 = inst_21146;
var inst_21122 = inst_21148;
var inst_21123 = (0);
var state_21243__$1 = (function (){var statearr_21298 = state_21243;
(statearr_21298[(13)] = inst_21120);

(statearr_21298[(14)] = inst_21123);

(statearr_21298[(15)] = inst_21121);

(statearr_21298[(16)] = inst_21122);

return statearr_21298;
})();
var statearr_21299_21363 = state_21243__$1;
(statearr_21299_21363[(2)] = null);

(statearr_21299_21363[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (11))){
var inst_21120 = (state_21243[(13)]);
var inst_21142 = (state_21243[(7)]);
var inst_21142__$1 = cljs.core.seq.call(null,inst_21120);
var state_21243__$1 = (function (){var statearr_21300 = state_21243;
(statearr_21300[(7)] = inst_21142__$1);

return statearr_21300;
})();
if(inst_21142__$1){
var statearr_21301_21364 = state_21243__$1;
(statearr_21301_21364[(1)] = (16));

} else {
var statearr_21302_21365 = state_21243__$1;
(statearr_21302_21365[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (9))){
var inst_21172 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
var statearr_21303_21366 = state_21243__$1;
(statearr_21303_21366[(2)] = inst_21172);

(statearr_21303_21366[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (5))){
var inst_21118 = cljs.core.deref.call(null,cs);
var inst_21119 = cljs.core.seq.call(null,inst_21118);
var inst_21120 = inst_21119;
var inst_21121 = null;
var inst_21122 = (0);
var inst_21123 = (0);
var state_21243__$1 = (function (){var statearr_21304 = state_21243;
(statearr_21304[(13)] = inst_21120);

(statearr_21304[(14)] = inst_21123);

(statearr_21304[(15)] = inst_21121);

(statearr_21304[(16)] = inst_21122);

return statearr_21304;
})();
var statearr_21305_21367 = state_21243__$1;
(statearr_21305_21367[(2)] = null);

(statearr_21305_21367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (14))){
var state_21243__$1 = state_21243;
var statearr_21306_21368 = state_21243__$1;
(statearr_21306_21368[(2)] = null);

(statearr_21306_21368[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (45))){
var inst_21233 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
var statearr_21307_21369 = state_21243__$1;
(statearr_21307_21369[(2)] = inst_21233);

(statearr_21307_21369[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (26))){
var inst_21175 = (state_21243[(29)]);
var inst_21229 = (state_21243[(2)]);
var inst_21230 = cljs.core.seq.call(null,inst_21175);
var state_21243__$1 = (function (){var statearr_21308 = state_21243;
(statearr_21308[(31)] = inst_21229);

return statearr_21308;
})();
if(inst_21230){
var statearr_21309_21370 = state_21243__$1;
(statearr_21309_21370[(1)] = (42));

} else {
var statearr_21310_21371 = state_21243__$1;
(statearr_21310_21371[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (16))){
var inst_21142 = (state_21243[(7)]);
var inst_21144 = cljs.core.chunked_seq_QMARK_.call(null,inst_21142);
var state_21243__$1 = state_21243;
if(inst_21144){
var statearr_21311_21372 = state_21243__$1;
(statearr_21311_21372[(1)] = (19));

} else {
var statearr_21312_21373 = state_21243__$1;
(statearr_21312_21373[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (38))){
var inst_21222 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
var statearr_21313_21374 = state_21243__$1;
(statearr_21313_21374[(2)] = inst_21222);

(statearr_21313_21374[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (30))){
var state_21243__$1 = state_21243;
var statearr_21314_21375 = state_21243__$1;
(statearr_21314_21375[(2)] = null);

(statearr_21314_21375[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (10))){
var inst_21123 = (state_21243[(14)]);
var inst_21121 = (state_21243[(15)]);
var inst_21131 = cljs.core._nth.call(null,inst_21121,inst_21123);
var inst_21132 = cljs.core.nth.call(null,inst_21131,(0),null);
var inst_21133 = cljs.core.nth.call(null,inst_21131,(1),null);
var state_21243__$1 = (function (){var statearr_21315 = state_21243;
(statearr_21315[(26)] = inst_21132);

return statearr_21315;
})();
if(cljs.core.truth_(inst_21133)){
var statearr_21316_21376 = state_21243__$1;
(statearr_21316_21376[(1)] = (13));

} else {
var statearr_21317_21377 = state_21243__$1;
(statearr_21317_21377[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (18))){
var inst_21168 = (state_21243[(2)]);
var state_21243__$1 = state_21243;
var statearr_21318_21378 = state_21243__$1;
(statearr_21318_21378[(2)] = inst_21168);

(statearr_21318_21378[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (42))){
var state_21243__$1 = state_21243;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21243__$1,(45),dchan);
} else {
if((state_val_21244 === (37))){
var inst_21211 = (state_21243[(23)]);
var inst_21111 = (state_21243[(10)]);
var inst_21202 = (state_21243[(25)]);
var inst_21211__$1 = cljs.core.first.call(null,inst_21202);
var inst_21212 = cljs.core.async.put_BANG_.call(null,inst_21211__$1,inst_21111,done);
var state_21243__$1 = (function (){var statearr_21319 = state_21243;
(statearr_21319[(23)] = inst_21211__$1);

return statearr_21319;
})();
if(cljs.core.truth_(inst_21212)){
var statearr_21320_21379 = state_21243__$1;
(statearr_21320_21379[(1)] = (39));

} else {
var statearr_21321_21380 = state_21243__$1;
(statearr_21321_21380[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21244 === (8))){
var inst_21123 = (state_21243[(14)]);
var inst_21122 = (state_21243[(16)]);
var inst_21125 = (inst_21123 < inst_21122);
var inst_21126 = inst_21125;
var state_21243__$1 = state_21243;
if(cljs.core.truth_(inst_21126)){
var statearr_21322_21381 = state_21243__$1;
(statearr_21322_21381[(1)] = (10));

} else {
var statearr_21323_21382 = state_21243__$1;
(statearr_21323_21382[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__20411__auto__ = null;
var cljs$core$async$mult_$_state_machine__20411__auto____0 = (function (){
var statearr_21324 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21324[(0)] = cljs$core$async$mult_$_state_machine__20411__auto__);

(statearr_21324[(1)] = (1));

return statearr_21324;
});
var cljs$core$async$mult_$_state_machine__20411__auto____1 = (function (state_21243){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_21243);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21325){if((e21325 instanceof Object)){
var ex__20414__auto__ = e21325;
var statearr_21326_21383 = state_21243;
(statearr_21326_21383[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21243);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21325;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21384 = state_21243;
state_21243 = G__21384;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20411__auto__ = function(state_21243){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20411__auto____1.call(this,state_21243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20411__auto____0;
cljs$core$async$mult_$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20411__auto____1;
return cljs$core$async$mult_$_state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21327 = f__20508__auto__.call(null);
(statearr_21327[(6)] = c__20507__auto___21328);

return statearr_21327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__21386 = arguments.length;
switch (G__21386) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_21388 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,ch);
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_21388.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_21389 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,ch);
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_21389.call(null,m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_21390 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m);
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_21390.call(null,m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_21391 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,state_map);
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_21391.call(null,m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_21392 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,m,mode);
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_21392.call(null,m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___21402 = arguments.length;
var i__5770__auto___21403 = (0);
while(true){
if((i__5770__auto___21403 < len__5769__auto___21402)){
args__5775__auto__.push((arguments[i__5770__auto___21403]));

var G__21404 = (i__5770__auto___21403 + (1));
i__5770__auto___21403 = G__21404;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__21397){
var map__21398 = p__21397;
var map__21398__$1 = cljs.core.__destructure_map.call(null,map__21398);
var opts = map__21398__$1;
var statearr_21399_21405 = state;
(statearr_21399_21405[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts.call(null,(function (val){
var statearr_21400_21406 = state;
(statearr_21400_21406[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_21401_21407 = state;
(statearr_21401_21407[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq21393){
var G__21394 = cljs.core.first.call(null,seq21393);
var seq21393__$1 = cljs.core.next.call(null,seq21393);
var G__21395 = cljs.core.first.call(null,seq21393__$1);
var seq21393__$2 = cljs.core.next.call(null,seq21393__$1);
var G__21396 = cljs.core.first.call(null,seq21393__$2);
var seq21393__$3 = cljs.core.next.call(null,seq21393__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__21394,G__21395,G__21396,seq21393__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv.call(null,(function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21408 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21408 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta21409){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta21409 = meta21409;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21410,meta21409__$1){
var self__ = this;
var _21410__$1 = this;
return (new cljs.core.async.t_cljs$core$async21408(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta21409__$1));
}));

(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21410){
var self__ = this;
var _21410__$1 = this;
return self__.meta21409;
}));

(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async21408.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
}));

(cljs.core.async.t_cljs$core$async21408.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta21409","meta21409",985598041,null)], null);
}));

(cljs.core.async.t_cljs$core$async21408.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21408.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21408");

(cljs.core.async.t_cljs$core$async21408.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async21408");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21408.
 */
cljs.core.async.__GT_t_cljs$core$async21408 = (function cljs$core$async$mix_$___GT_t_cljs$core$async21408(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21409){
return (new cljs.core.async.t_cljs$core$async21408(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta21409));
});

}

return (new cljs.core.async.t_cljs$core$async21408(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20507__auto___21522 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_21478){
var state_val_21479 = (state_21478[(1)]);
if((state_val_21479 === (7))){
var inst_21438 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
if(cljs.core.truth_(inst_21438)){
var statearr_21480_21523 = state_21478__$1;
(statearr_21480_21523[(1)] = (8));

} else {
var statearr_21481_21524 = state_21478__$1;
(statearr_21481_21524[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (20))){
var inst_21431 = (state_21478[(7)]);
var state_21478__$1 = state_21478;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21478__$1,(23),out,inst_21431);
} else {
if((state_val_21479 === (1))){
var inst_21414 = calc_state.call(null);
var inst_21415 = cljs.core.__destructure_map.call(null,inst_21414);
var inst_21416 = cljs.core.get.call(null,inst_21415,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21417 = cljs.core.get.call(null,inst_21415,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21418 = cljs.core.get.call(null,inst_21415,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_21419 = inst_21414;
var state_21478__$1 = (function (){var statearr_21482 = state_21478;
(statearr_21482[(8)] = inst_21418);

(statearr_21482[(9)] = inst_21417);

(statearr_21482[(10)] = inst_21416);

(statearr_21482[(11)] = inst_21419);

return statearr_21482;
})();
var statearr_21483_21525 = state_21478__$1;
(statearr_21483_21525[(2)] = null);

(statearr_21483_21525[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (24))){
var inst_21422 = (state_21478[(12)]);
var inst_21419 = inst_21422;
var state_21478__$1 = (function (){var statearr_21484 = state_21478;
(statearr_21484[(11)] = inst_21419);

return statearr_21484;
})();
var statearr_21485_21526 = state_21478__$1;
(statearr_21485_21526[(2)] = null);

(statearr_21485_21526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (4))){
var inst_21431 = (state_21478[(7)]);
var inst_21433 = (state_21478[(13)]);
var inst_21430 = (state_21478[(2)]);
var inst_21431__$1 = cljs.core.nth.call(null,inst_21430,(0),null);
var inst_21432 = cljs.core.nth.call(null,inst_21430,(1),null);
var inst_21433__$1 = (inst_21431__$1 == null);
var state_21478__$1 = (function (){var statearr_21486 = state_21478;
(statearr_21486[(7)] = inst_21431__$1);

(statearr_21486[(13)] = inst_21433__$1);

(statearr_21486[(14)] = inst_21432);

return statearr_21486;
})();
if(cljs.core.truth_(inst_21433__$1)){
var statearr_21487_21527 = state_21478__$1;
(statearr_21487_21527[(1)] = (5));

} else {
var statearr_21488_21528 = state_21478__$1;
(statearr_21488_21528[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (15))){
var inst_21423 = (state_21478[(15)]);
var inst_21452 = (state_21478[(16)]);
var inst_21452__$1 = cljs.core.empty_QMARK_.call(null,inst_21423);
var state_21478__$1 = (function (){var statearr_21489 = state_21478;
(statearr_21489[(16)] = inst_21452__$1);

return statearr_21489;
})();
if(inst_21452__$1){
var statearr_21490_21529 = state_21478__$1;
(statearr_21490_21529[(1)] = (17));

} else {
var statearr_21491_21530 = state_21478__$1;
(statearr_21491_21530[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (21))){
var inst_21422 = (state_21478[(12)]);
var inst_21419 = inst_21422;
var state_21478__$1 = (function (){var statearr_21492 = state_21478;
(statearr_21492[(11)] = inst_21419);

return statearr_21492;
})();
var statearr_21493_21531 = state_21478__$1;
(statearr_21493_21531[(2)] = null);

(statearr_21493_21531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (13))){
var inst_21445 = (state_21478[(2)]);
var inst_21446 = calc_state.call(null);
var inst_21419 = inst_21446;
var state_21478__$1 = (function (){var statearr_21494 = state_21478;
(statearr_21494[(17)] = inst_21445);

(statearr_21494[(11)] = inst_21419);

return statearr_21494;
})();
var statearr_21495_21532 = state_21478__$1;
(statearr_21495_21532[(2)] = null);

(statearr_21495_21532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (22))){
var inst_21472 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
var statearr_21496_21533 = state_21478__$1;
(statearr_21496_21533[(2)] = inst_21472);

(statearr_21496_21533[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (6))){
var inst_21432 = (state_21478[(14)]);
var inst_21436 = cljs.core._EQ_.call(null,inst_21432,change);
var state_21478__$1 = state_21478;
var statearr_21497_21534 = state_21478__$1;
(statearr_21497_21534[(2)] = inst_21436);

(statearr_21497_21534[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (25))){
var state_21478__$1 = state_21478;
var statearr_21498_21535 = state_21478__$1;
(statearr_21498_21535[(2)] = null);

(statearr_21498_21535[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (17))){
var inst_21424 = (state_21478[(18)]);
var inst_21432 = (state_21478[(14)]);
var inst_21454 = inst_21424.call(null,inst_21432);
var inst_21455 = cljs.core.not.call(null,inst_21454);
var state_21478__$1 = state_21478;
var statearr_21499_21536 = state_21478__$1;
(statearr_21499_21536[(2)] = inst_21455);

(statearr_21499_21536[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (3))){
var inst_21476 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21478__$1,inst_21476);
} else {
if((state_val_21479 === (12))){
var state_21478__$1 = state_21478;
var statearr_21500_21537 = state_21478__$1;
(statearr_21500_21537[(2)] = null);

(statearr_21500_21537[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (2))){
var inst_21422 = (state_21478[(12)]);
var inst_21419 = (state_21478[(11)]);
var inst_21422__$1 = cljs.core.__destructure_map.call(null,inst_21419);
var inst_21423 = cljs.core.get.call(null,inst_21422__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_21424 = cljs.core.get.call(null,inst_21422__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_21425 = cljs.core.get.call(null,inst_21422__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_21478__$1 = (function (){var statearr_21501 = state_21478;
(statearr_21501[(15)] = inst_21423);

(statearr_21501[(12)] = inst_21422__$1);

(statearr_21501[(18)] = inst_21424);

return statearr_21501;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_21478__$1,(4),inst_21425);
} else {
if((state_val_21479 === (23))){
var inst_21463 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
if(cljs.core.truth_(inst_21463)){
var statearr_21502_21538 = state_21478__$1;
(statearr_21502_21538[(1)] = (24));

} else {
var statearr_21503_21539 = state_21478__$1;
(statearr_21503_21539[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (19))){
var inst_21458 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
var statearr_21504_21540 = state_21478__$1;
(statearr_21504_21540[(2)] = inst_21458);

(statearr_21504_21540[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (11))){
var inst_21432 = (state_21478[(14)]);
var inst_21442 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_21432);
var state_21478__$1 = state_21478;
var statearr_21505_21541 = state_21478__$1;
(statearr_21505_21541[(2)] = inst_21442);

(statearr_21505_21541[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (9))){
var inst_21423 = (state_21478[(15)]);
var inst_21449 = (state_21478[(19)]);
var inst_21432 = (state_21478[(14)]);
var inst_21449__$1 = inst_21423.call(null,inst_21432);
var state_21478__$1 = (function (){var statearr_21506 = state_21478;
(statearr_21506[(19)] = inst_21449__$1);

return statearr_21506;
})();
if(cljs.core.truth_(inst_21449__$1)){
var statearr_21507_21542 = state_21478__$1;
(statearr_21507_21542[(1)] = (14));

} else {
var statearr_21508_21543 = state_21478__$1;
(statearr_21508_21543[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (5))){
var inst_21433 = (state_21478[(13)]);
var state_21478__$1 = state_21478;
var statearr_21509_21544 = state_21478__$1;
(statearr_21509_21544[(2)] = inst_21433);

(statearr_21509_21544[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (14))){
var inst_21449 = (state_21478[(19)]);
var state_21478__$1 = state_21478;
var statearr_21510_21545 = state_21478__$1;
(statearr_21510_21545[(2)] = inst_21449);

(statearr_21510_21545[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (26))){
var inst_21468 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
var statearr_21511_21546 = state_21478__$1;
(statearr_21511_21546[(2)] = inst_21468);

(statearr_21511_21546[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (16))){
var inst_21460 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
if(cljs.core.truth_(inst_21460)){
var statearr_21512_21547 = state_21478__$1;
(statearr_21512_21547[(1)] = (20));

} else {
var statearr_21513_21548 = state_21478__$1;
(statearr_21513_21548[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (10))){
var inst_21474 = (state_21478[(2)]);
var state_21478__$1 = state_21478;
var statearr_21514_21549 = state_21478__$1;
(statearr_21514_21549[(2)] = inst_21474);

(statearr_21514_21549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (18))){
var inst_21452 = (state_21478[(16)]);
var state_21478__$1 = state_21478;
var statearr_21515_21550 = state_21478__$1;
(statearr_21515_21550[(2)] = inst_21452);

(statearr_21515_21550[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21479 === (8))){
var inst_21431 = (state_21478[(7)]);
var inst_21440 = (inst_21431 == null);
var state_21478__$1 = state_21478;
if(cljs.core.truth_(inst_21440)){
var statearr_21516_21551 = state_21478__$1;
(statearr_21516_21551[(1)] = (11));

} else {
var statearr_21517_21552 = state_21478__$1;
(statearr_21517_21552[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__20411__auto__ = null;
var cljs$core$async$mix_$_state_machine__20411__auto____0 = (function (){
var statearr_21518 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21518[(0)] = cljs$core$async$mix_$_state_machine__20411__auto__);

(statearr_21518[(1)] = (1));

return statearr_21518;
});
var cljs$core$async$mix_$_state_machine__20411__auto____1 = (function (state_21478){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_21478);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21519){if((e21519 instanceof Object)){
var ex__20414__auto__ = e21519;
var statearr_21520_21553 = state_21478;
(statearr_21520_21553[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21478);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21519;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21554 = state_21478;
state_21478 = G__21554;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20411__auto__ = function(state_21478){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20411__auto____1.call(this,state_21478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20411__auto____0;
cljs$core$async$mix_$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20411__auto____1;
return cljs$core$async$mix_$_state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21521 = f__20508__auto__.call(null);
(statearr_21521[(6)] = c__20507__auto___21522);

return statearr_21521;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_21557 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_21557.call(null,p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_21558 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,p,v,ch);
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_21558.call(null,p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_21559 = (function() {
var G__21560 = null;
var G__21560__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,p);
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
var G__21560__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return m__5394__auto__.call(null,p,v);
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return m__5392__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
});
G__21560 = function(p,v){
switch(arguments.length){
case 1:
return G__21560__1.call(this,p);
case 2:
return G__21560__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__21560.cljs$core$IFn$_invoke$arity$1 = G__21560__1;
G__21560.cljs$core$IFn$_invoke$arity$2 = G__21560__2;
return G__21560;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__21556 = arguments.length;
switch (G__21556) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_21559.call(null,p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_21559.call(null,p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__21564 = arguments.length;
switch (G__21564) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,(function (p1__21562_SHARP_){
if(cljs.core.truth_(p1__21562_SHARP_.call(null,topic))){
return p1__21562_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__21562_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21565 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21565 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta21566){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta21566 = meta21566;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21565.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21567,meta21566__$1){
var self__ = this;
var _21567__$1 = this;
return (new cljs.core.async.t_cljs$core$async21565(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta21566__$1));
}));

(cljs.core.async.t_cljs$core$async21565.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21567){
var self__ = this;
var _21567__$1 = this;
return self__.meta21566;
}));

(cljs.core.async.t_cljs$core$async21565.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21565.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async21565.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21565.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async21565.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async21565.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async21565.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async21565.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta21566","meta21566",-61438600,null)], null);
}));

(cljs.core.async.t_cljs$core$async21565.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21565.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21565");

(cljs.core.async.t_cljs$core$async21565.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async21565");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21565.
 */
cljs.core.async.__GT_t_cljs$core$async21565 = (function cljs$core$async$__GT_t_cljs$core$async21565(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta21566){
return (new cljs.core.async.t_cljs$core$async21565(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta21566));
});

}

return (new cljs.core.async.t_cljs$core$async21565(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20507__auto___21685 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_21639){
var state_val_21640 = (state_21639[(1)]);
if((state_val_21640 === (7))){
var inst_21635 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
var statearr_21641_21686 = state_21639__$1;
(statearr_21641_21686[(2)] = inst_21635);

(statearr_21641_21686[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (20))){
var state_21639__$1 = state_21639;
var statearr_21642_21687 = state_21639__$1;
(statearr_21642_21687[(2)] = null);

(statearr_21642_21687[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (1))){
var state_21639__$1 = state_21639;
var statearr_21643_21688 = state_21639__$1;
(statearr_21643_21688[(2)] = null);

(statearr_21643_21688[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (24))){
var inst_21618 = (state_21639[(7)]);
var inst_21627 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_21618);
var state_21639__$1 = state_21639;
var statearr_21644_21689 = state_21639__$1;
(statearr_21644_21689[(2)] = inst_21627);

(statearr_21644_21689[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (4))){
var inst_21570 = (state_21639[(8)]);
var inst_21570__$1 = (state_21639[(2)]);
var inst_21571 = (inst_21570__$1 == null);
var state_21639__$1 = (function (){var statearr_21645 = state_21639;
(statearr_21645[(8)] = inst_21570__$1);

return statearr_21645;
})();
if(cljs.core.truth_(inst_21571)){
var statearr_21646_21690 = state_21639__$1;
(statearr_21646_21690[(1)] = (5));

} else {
var statearr_21647_21691 = state_21639__$1;
(statearr_21647_21691[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (15))){
var inst_21612 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
var statearr_21648_21692 = state_21639__$1;
(statearr_21648_21692[(2)] = inst_21612);

(statearr_21648_21692[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (21))){
var inst_21632 = (state_21639[(2)]);
var state_21639__$1 = (function (){var statearr_21649 = state_21639;
(statearr_21649[(9)] = inst_21632);

return statearr_21649;
})();
var statearr_21650_21693 = state_21639__$1;
(statearr_21650_21693[(2)] = null);

(statearr_21650_21693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (13))){
var inst_21594 = (state_21639[(10)]);
var inst_21596 = cljs.core.chunked_seq_QMARK_.call(null,inst_21594);
var state_21639__$1 = state_21639;
if(inst_21596){
var statearr_21651_21694 = state_21639__$1;
(statearr_21651_21694[(1)] = (16));

} else {
var statearr_21652_21695 = state_21639__$1;
(statearr_21652_21695[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (22))){
var inst_21624 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
if(cljs.core.truth_(inst_21624)){
var statearr_21653_21696 = state_21639__$1;
(statearr_21653_21696[(1)] = (23));

} else {
var statearr_21654_21697 = state_21639__$1;
(statearr_21654_21697[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (6))){
var inst_21620 = (state_21639[(11)]);
var inst_21618 = (state_21639[(7)]);
var inst_21570 = (state_21639[(8)]);
var inst_21618__$1 = topic_fn.call(null,inst_21570);
var inst_21619 = cljs.core.deref.call(null,mults);
var inst_21620__$1 = cljs.core.get.call(null,inst_21619,inst_21618__$1);
var state_21639__$1 = (function (){var statearr_21655 = state_21639;
(statearr_21655[(11)] = inst_21620__$1);

(statearr_21655[(7)] = inst_21618__$1);

return statearr_21655;
})();
if(cljs.core.truth_(inst_21620__$1)){
var statearr_21656_21698 = state_21639__$1;
(statearr_21656_21698[(1)] = (19));

} else {
var statearr_21657_21699 = state_21639__$1;
(statearr_21657_21699[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (25))){
var inst_21629 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
var statearr_21658_21700 = state_21639__$1;
(statearr_21658_21700[(2)] = inst_21629);

(statearr_21658_21700[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (17))){
var inst_21594 = (state_21639[(10)]);
var inst_21603 = cljs.core.first.call(null,inst_21594);
var inst_21604 = cljs.core.async.muxch_STAR_.call(null,inst_21603);
var inst_21605 = cljs.core.async.close_BANG_.call(null,inst_21604);
var inst_21606 = cljs.core.next.call(null,inst_21594);
var inst_21580 = inst_21606;
var inst_21581 = null;
var inst_21582 = (0);
var inst_21583 = (0);
var state_21639__$1 = (function (){var statearr_21659 = state_21639;
(statearr_21659[(12)] = inst_21583);

(statearr_21659[(13)] = inst_21605);

(statearr_21659[(14)] = inst_21581);

(statearr_21659[(15)] = inst_21580);

(statearr_21659[(16)] = inst_21582);

return statearr_21659;
})();
var statearr_21660_21701 = state_21639__$1;
(statearr_21660_21701[(2)] = null);

(statearr_21660_21701[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (3))){
var inst_21637 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21639__$1,inst_21637);
} else {
if((state_val_21640 === (12))){
var inst_21614 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
var statearr_21661_21702 = state_21639__$1;
(statearr_21661_21702[(2)] = inst_21614);

(statearr_21661_21702[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (2))){
var state_21639__$1 = state_21639;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21639__$1,(4),ch);
} else {
if((state_val_21640 === (23))){
var state_21639__$1 = state_21639;
var statearr_21662_21703 = state_21639__$1;
(statearr_21662_21703[(2)] = null);

(statearr_21662_21703[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (19))){
var inst_21620 = (state_21639[(11)]);
var inst_21570 = (state_21639[(8)]);
var inst_21622 = cljs.core.async.muxch_STAR_.call(null,inst_21620);
var state_21639__$1 = state_21639;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21639__$1,(22),inst_21622,inst_21570);
} else {
if((state_val_21640 === (11))){
var inst_21580 = (state_21639[(15)]);
var inst_21594 = (state_21639[(10)]);
var inst_21594__$1 = cljs.core.seq.call(null,inst_21580);
var state_21639__$1 = (function (){var statearr_21663 = state_21639;
(statearr_21663[(10)] = inst_21594__$1);

return statearr_21663;
})();
if(inst_21594__$1){
var statearr_21664_21704 = state_21639__$1;
(statearr_21664_21704[(1)] = (13));

} else {
var statearr_21665_21705 = state_21639__$1;
(statearr_21665_21705[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (9))){
var inst_21616 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
var statearr_21666_21706 = state_21639__$1;
(statearr_21666_21706[(2)] = inst_21616);

(statearr_21666_21706[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (5))){
var inst_21577 = cljs.core.deref.call(null,mults);
var inst_21578 = cljs.core.vals.call(null,inst_21577);
var inst_21579 = cljs.core.seq.call(null,inst_21578);
var inst_21580 = inst_21579;
var inst_21581 = null;
var inst_21582 = (0);
var inst_21583 = (0);
var state_21639__$1 = (function (){var statearr_21667 = state_21639;
(statearr_21667[(12)] = inst_21583);

(statearr_21667[(14)] = inst_21581);

(statearr_21667[(15)] = inst_21580);

(statearr_21667[(16)] = inst_21582);

return statearr_21667;
})();
var statearr_21668_21707 = state_21639__$1;
(statearr_21668_21707[(2)] = null);

(statearr_21668_21707[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (14))){
var state_21639__$1 = state_21639;
var statearr_21672_21708 = state_21639__$1;
(statearr_21672_21708[(2)] = null);

(statearr_21672_21708[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (16))){
var inst_21594 = (state_21639[(10)]);
var inst_21598 = cljs.core.chunk_first.call(null,inst_21594);
var inst_21599 = cljs.core.chunk_rest.call(null,inst_21594);
var inst_21600 = cljs.core.count.call(null,inst_21598);
var inst_21580 = inst_21599;
var inst_21581 = inst_21598;
var inst_21582 = inst_21600;
var inst_21583 = (0);
var state_21639__$1 = (function (){var statearr_21673 = state_21639;
(statearr_21673[(12)] = inst_21583);

(statearr_21673[(14)] = inst_21581);

(statearr_21673[(15)] = inst_21580);

(statearr_21673[(16)] = inst_21582);

return statearr_21673;
})();
var statearr_21674_21709 = state_21639__$1;
(statearr_21674_21709[(2)] = null);

(statearr_21674_21709[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (10))){
var inst_21583 = (state_21639[(12)]);
var inst_21581 = (state_21639[(14)]);
var inst_21580 = (state_21639[(15)]);
var inst_21582 = (state_21639[(16)]);
var inst_21588 = cljs.core._nth.call(null,inst_21581,inst_21583);
var inst_21589 = cljs.core.async.muxch_STAR_.call(null,inst_21588);
var inst_21590 = cljs.core.async.close_BANG_.call(null,inst_21589);
var inst_21591 = (inst_21583 + (1));
var tmp21669 = inst_21581;
var tmp21670 = inst_21580;
var tmp21671 = inst_21582;
var inst_21580__$1 = tmp21670;
var inst_21581__$1 = tmp21669;
var inst_21582__$1 = tmp21671;
var inst_21583__$1 = inst_21591;
var state_21639__$1 = (function (){var statearr_21675 = state_21639;
(statearr_21675[(17)] = inst_21590);

(statearr_21675[(12)] = inst_21583__$1);

(statearr_21675[(14)] = inst_21581__$1);

(statearr_21675[(15)] = inst_21580__$1);

(statearr_21675[(16)] = inst_21582__$1);

return statearr_21675;
})();
var statearr_21676_21710 = state_21639__$1;
(statearr_21676_21710[(2)] = null);

(statearr_21676_21710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (18))){
var inst_21609 = (state_21639[(2)]);
var state_21639__$1 = state_21639;
var statearr_21677_21711 = state_21639__$1;
(statearr_21677_21711[(2)] = inst_21609);

(statearr_21677_21711[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21640 === (8))){
var inst_21583 = (state_21639[(12)]);
var inst_21582 = (state_21639[(16)]);
var inst_21585 = (inst_21583 < inst_21582);
var inst_21586 = inst_21585;
var state_21639__$1 = state_21639;
if(cljs.core.truth_(inst_21586)){
var statearr_21678_21712 = state_21639__$1;
(statearr_21678_21712[(1)] = (10));

} else {
var statearr_21679_21713 = state_21639__$1;
(statearr_21679_21713[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_21680 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21680[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_21680[(1)] = (1));

return statearr_21680;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_21639){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_21639);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21681){if((e21681 instanceof Object)){
var ex__20414__auto__ = e21681;
var statearr_21682_21714 = state_21639;
(statearr_21682_21714[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21639);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21681;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21715 = state_21639;
state_21639 = G__21715;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_21639){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_21639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21683 = f__20508__auto__.call(null);
(statearr_21683[(6)] = c__20507__auto___21685);

return statearr_21683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__21717 = arguments.length;
switch (G__21717) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__21720 = arguments.length;
switch (G__21720) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__21723 = arguments.length;
switch (G__21723) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,(function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.call(null,cnt));
var c__20507__auto___21790 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_21762){
var state_val_21763 = (state_21762[(1)]);
if((state_val_21763 === (7))){
var state_21762__$1 = state_21762;
var statearr_21764_21791 = state_21762__$1;
(statearr_21764_21791[(2)] = null);

(statearr_21764_21791[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (1))){
var state_21762__$1 = state_21762;
var statearr_21765_21792 = state_21762__$1;
(statearr_21765_21792[(2)] = null);

(statearr_21765_21792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (4))){
var inst_21726 = (state_21762[(7)]);
var inst_21728 = (inst_21726 < cnt);
var state_21762__$1 = state_21762;
if(cljs.core.truth_(inst_21728)){
var statearr_21766_21793 = state_21762__$1;
(statearr_21766_21793[(1)] = (6));

} else {
var statearr_21767_21794 = state_21762__$1;
(statearr_21767_21794[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (15))){
var inst_21758 = (state_21762[(2)]);
var state_21762__$1 = state_21762;
var statearr_21768_21795 = state_21762__$1;
(statearr_21768_21795[(2)] = inst_21758);

(statearr_21768_21795[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (13))){
var inst_21751 = cljs.core.async.close_BANG_.call(null,out);
var state_21762__$1 = state_21762;
var statearr_21769_21796 = state_21762__$1;
(statearr_21769_21796[(2)] = inst_21751);

(statearr_21769_21796[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (6))){
var state_21762__$1 = state_21762;
var statearr_21770_21797 = state_21762__$1;
(statearr_21770_21797[(2)] = null);

(statearr_21770_21797[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (3))){
var inst_21760 = (state_21762[(2)]);
var state_21762__$1 = state_21762;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21762__$1,inst_21760);
} else {
if((state_val_21763 === (12))){
var inst_21748 = (state_21762[(8)]);
var inst_21748__$1 = (state_21762[(2)]);
var inst_21749 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_21748__$1);
var state_21762__$1 = (function (){var statearr_21771 = state_21762;
(statearr_21771[(8)] = inst_21748__$1);

return statearr_21771;
})();
if(cljs.core.truth_(inst_21749)){
var statearr_21772_21798 = state_21762__$1;
(statearr_21772_21798[(1)] = (13));

} else {
var statearr_21773_21799 = state_21762__$1;
(statearr_21773_21799[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (2))){
var inst_21725 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_21726 = (0);
var state_21762__$1 = (function (){var statearr_21774 = state_21762;
(statearr_21774[(7)] = inst_21726);

(statearr_21774[(9)] = inst_21725);

return statearr_21774;
})();
var statearr_21775_21800 = state_21762__$1;
(statearr_21775_21800[(2)] = null);

(statearr_21775_21800[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (11))){
var inst_21726 = (state_21762[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_21762,(10),Object,null,(9));
var inst_21735 = chs__$1.call(null,inst_21726);
var inst_21736 = done.call(null,inst_21726);
var inst_21737 = cljs.core.async.take_BANG_.call(null,inst_21735,inst_21736);
var state_21762__$1 = state_21762;
var statearr_21776_21801 = state_21762__$1;
(statearr_21776_21801[(2)] = inst_21737);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21762__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (9))){
var inst_21726 = (state_21762[(7)]);
var inst_21739 = (state_21762[(2)]);
var inst_21740 = (inst_21726 + (1));
var inst_21726__$1 = inst_21740;
var state_21762__$1 = (function (){var statearr_21777 = state_21762;
(statearr_21777[(7)] = inst_21726__$1);

(statearr_21777[(10)] = inst_21739);

return statearr_21777;
})();
var statearr_21778_21802 = state_21762__$1;
(statearr_21778_21802[(2)] = null);

(statearr_21778_21802[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (5))){
var inst_21746 = (state_21762[(2)]);
var state_21762__$1 = (function (){var statearr_21779 = state_21762;
(statearr_21779[(11)] = inst_21746);

return statearr_21779;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21762__$1,(12),dchan);
} else {
if((state_val_21763 === (14))){
var inst_21748 = (state_21762[(8)]);
var inst_21753 = cljs.core.apply.call(null,f,inst_21748);
var state_21762__$1 = state_21762;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21762__$1,(16),out,inst_21753);
} else {
if((state_val_21763 === (16))){
var inst_21755 = (state_21762[(2)]);
var state_21762__$1 = (function (){var statearr_21780 = state_21762;
(statearr_21780[(12)] = inst_21755);

return statearr_21780;
})();
var statearr_21781_21803 = state_21762__$1;
(statearr_21781_21803[(2)] = null);

(statearr_21781_21803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (10))){
var inst_21730 = (state_21762[(2)]);
var inst_21731 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_21762__$1 = (function (){var statearr_21782 = state_21762;
(statearr_21782[(13)] = inst_21730);

return statearr_21782;
})();
var statearr_21783_21804 = state_21762__$1;
(statearr_21783_21804[(2)] = inst_21731);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21762__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21763 === (8))){
var inst_21744 = (state_21762[(2)]);
var state_21762__$1 = state_21762;
var statearr_21784_21805 = state_21762__$1;
(statearr_21784_21805[(2)] = inst_21744);

(statearr_21784_21805[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_21785 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21785[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_21785[(1)] = (1));

return statearr_21785;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_21762){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_21762);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21786){if((e21786 instanceof Object)){
var ex__20414__auto__ = e21786;
var statearr_21787_21806 = state_21762;
(statearr_21787_21806[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21762);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21786;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21807 = state_21762;
state_21762 = G__21807;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_21762){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_21762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21788 = f__20508__auto__.call(null);
(statearr_21788[(6)] = c__20507__auto___21790);

return statearr_21788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__21810 = arguments.length;
switch (G__21810) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20507__auto___21864 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_21842){
var state_val_21843 = (state_21842[(1)]);
if((state_val_21843 === (7))){
var inst_21822 = (state_21842[(7)]);
var inst_21821 = (state_21842[(8)]);
var inst_21821__$1 = (state_21842[(2)]);
var inst_21822__$1 = cljs.core.nth.call(null,inst_21821__$1,(0),null);
var inst_21823 = cljs.core.nth.call(null,inst_21821__$1,(1),null);
var inst_21824 = (inst_21822__$1 == null);
var state_21842__$1 = (function (){var statearr_21844 = state_21842;
(statearr_21844[(7)] = inst_21822__$1);

(statearr_21844[(8)] = inst_21821__$1);

(statearr_21844[(9)] = inst_21823);

return statearr_21844;
})();
if(cljs.core.truth_(inst_21824)){
var statearr_21845_21865 = state_21842__$1;
(statearr_21845_21865[(1)] = (8));

} else {
var statearr_21846_21866 = state_21842__$1;
(statearr_21846_21866[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21843 === (1))){
var inst_21811 = cljs.core.vec.call(null,chs);
var inst_21812 = inst_21811;
var state_21842__$1 = (function (){var statearr_21847 = state_21842;
(statearr_21847[(10)] = inst_21812);

return statearr_21847;
})();
var statearr_21848_21867 = state_21842__$1;
(statearr_21848_21867[(2)] = null);

(statearr_21848_21867[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21843 === (4))){
var inst_21812 = (state_21842[(10)]);
var state_21842__$1 = state_21842;
return cljs.core.async.ioc_alts_BANG_.call(null,state_21842__$1,(7),inst_21812);
} else {
if((state_val_21843 === (6))){
var inst_21838 = (state_21842[(2)]);
var state_21842__$1 = state_21842;
var statearr_21849_21868 = state_21842__$1;
(statearr_21849_21868[(2)] = inst_21838);

(statearr_21849_21868[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21843 === (3))){
var inst_21840 = (state_21842[(2)]);
var state_21842__$1 = state_21842;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21842__$1,inst_21840);
} else {
if((state_val_21843 === (2))){
var inst_21812 = (state_21842[(10)]);
var inst_21814 = cljs.core.count.call(null,inst_21812);
var inst_21815 = (inst_21814 > (0));
var state_21842__$1 = state_21842;
if(cljs.core.truth_(inst_21815)){
var statearr_21851_21869 = state_21842__$1;
(statearr_21851_21869[(1)] = (4));

} else {
var statearr_21852_21870 = state_21842__$1;
(statearr_21852_21870[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21843 === (11))){
var inst_21812 = (state_21842[(10)]);
var inst_21831 = (state_21842[(2)]);
var tmp21850 = inst_21812;
var inst_21812__$1 = tmp21850;
var state_21842__$1 = (function (){var statearr_21853 = state_21842;
(statearr_21853[(10)] = inst_21812__$1);

(statearr_21853[(11)] = inst_21831);

return statearr_21853;
})();
var statearr_21854_21871 = state_21842__$1;
(statearr_21854_21871[(2)] = null);

(statearr_21854_21871[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21843 === (9))){
var inst_21822 = (state_21842[(7)]);
var state_21842__$1 = state_21842;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21842__$1,(11),out,inst_21822);
} else {
if((state_val_21843 === (5))){
var inst_21836 = cljs.core.async.close_BANG_.call(null,out);
var state_21842__$1 = state_21842;
var statearr_21855_21872 = state_21842__$1;
(statearr_21855_21872[(2)] = inst_21836);

(statearr_21855_21872[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21843 === (10))){
var inst_21834 = (state_21842[(2)]);
var state_21842__$1 = state_21842;
var statearr_21856_21873 = state_21842__$1;
(statearr_21856_21873[(2)] = inst_21834);

(statearr_21856_21873[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21843 === (8))){
var inst_21812 = (state_21842[(10)]);
var inst_21822 = (state_21842[(7)]);
var inst_21821 = (state_21842[(8)]);
var inst_21823 = (state_21842[(9)]);
var inst_21826 = (function (){var cs = inst_21812;
var vec__21817 = inst_21821;
var v = inst_21822;
var c = inst_21823;
return (function (p1__21808_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__21808_SHARP_);
});
})();
var inst_21827 = cljs.core.filterv.call(null,inst_21826,inst_21812);
var inst_21812__$1 = inst_21827;
var state_21842__$1 = (function (){var statearr_21857 = state_21842;
(statearr_21857[(10)] = inst_21812__$1);

return statearr_21857;
})();
var statearr_21858_21874 = state_21842__$1;
(statearr_21858_21874[(2)] = null);

(statearr_21858_21874[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_21859 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21859[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_21859[(1)] = (1));

return statearr_21859;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_21842){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_21842);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21860){if((e21860 instanceof Object)){
var ex__20414__auto__ = e21860;
var statearr_21861_21875 = state_21842;
(statearr_21861_21875[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21842);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21860;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21876 = state_21842;
state_21842 = G__21876;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_21842){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_21842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21862 = f__20508__auto__.call(null);
(statearr_21862[(6)] = c__20507__auto___21864);

return statearr_21862;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__21878 = arguments.length;
switch (G__21878) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20507__auto___21923 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_21902){
var state_val_21903 = (state_21902[(1)]);
if((state_val_21903 === (7))){
var inst_21884 = (state_21902[(7)]);
var inst_21884__$1 = (state_21902[(2)]);
var inst_21885 = (inst_21884__$1 == null);
var inst_21886 = cljs.core.not.call(null,inst_21885);
var state_21902__$1 = (function (){var statearr_21904 = state_21902;
(statearr_21904[(7)] = inst_21884__$1);

return statearr_21904;
})();
if(inst_21886){
var statearr_21905_21924 = state_21902__$1;
(statearr_21905_21924[(1)] = (8));

} else {
var statearr_21906_21925 = state_21902__$1;
(statearr_21906_21925[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (1))){
var inst_21879 = (0);
var state_21902__$1 = (function (){var statearr_21907 = state_21902;
(statearr_21907[(8)] = inst_21879);

return statearr_21907;
})();
var statearr_21908_21926 = state_21902__$1;
(statearr_21908_21926[(2)] = null);

(statearr_21908_21926[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (4))){
var state_21902__$1 = state_21902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21902__$1,(7),ch);
} else {
if((state_val_21903 === (6))){
var inst_21897 = (state_21902[(2)]);
var state_21902__$1 = state_21902;
var statearr_21909_21927 = state_21902__$1;
(statearr_21909_21927[(2)] = inst_21897);

(statearr_21909_21927[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (3))){
var inst_21899 = (state_21902[(2)]);
var inst_21900 = cljs.core.async.close_BANG_.call(null,out);
var state_21902__$1 = (function (){var statearr_21910 = state_21902;
(statearr_21910[(9)] = inst_21899);

return statearr_21910;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21902__$1,inst_21900);
} else {
if((state_val_21903 === (2))){
var inst_21879 = (state_21902[(8)]);
var inst_21881 = (inst_21879 < n);
var state_21902__$1 = state_21902;
if(cljs.core.truth_(inst_21881)){
var statearr_21911_21928 = state_21902__$1;
(statearr_21911_21928[(1)] = (4));

} else {
var statearr_21912_21929 = state_21902__$1;
(statearr_21912_21929[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (11))){
var inst_21879 = (state_21902[(8)]);
var inst_21889 = (state_21902[(2)]);
var inst_21890 = (inst_21879 + (1));
var inst_21879__$1 = inst_21890;
var state_21902__$1 = (function (){var statearr_21913 = state_21902;
(statearr_21913[(8)] = inst_21879__$1);

(statearr_21913[(10)] = inst_21889);

return statearr_21913;
})();
var statearr_21914_21930 = state_21902__$1;
(statearr_21914_21930[(2)] = null);

(statearr_21914_21930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (9))){
var state_21902__$1 = state_21902;
var statearr_21915_21931 = state_21902__$1;
(statearr_21915_21931[(2)] = null);

(statearr_21915_21931[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (5))){
var state_21902__$1 = state_21902;
var statearr_21916_21932 = state_21902__$1;
(statearr_21916_21932[(2)] = null);

(statearr_21916_21932[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (10))){
var inst_21894 = (state_21902[(2)]);
var state_21902__$1 = state_21902;
var statearr_21917_21933 = state_21902__$1;
(statearr_21917_21933[(2)] = inst_21894);

(statearr_21917_21933[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21903 === (8))){
var inst_21884 = (state_21902[(7)]);
var state_21902__$1 = state_21902;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21902__$1,(11),out,inst_21884);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_21918 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21918[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_21918[(1)] = (1));

return statearr_21918;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_21902){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_21902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21919){if((e21919 instanceof Object)){
var ex__20414__auto__ = e21919;
var statearr_21920_21934 = state_21902;
(statearr_21920_21934[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21902);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21919;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21935 = state_21902;
state_21902 = G__21935;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_21902){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_21902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21921 = f__20508__auto__.call(null);
(statearr_21921[(6)] = c__20507__auto___21923);

return statearr_21921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21937 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21937 = (function (f,ch,meta21938){
this.f = f;
this.ch = ch;
this.meta21938 = meta21938;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21937.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21939,meta21938__$1){
var self__ = this;
var _21939__$1 = this;
return (new cljs.core.async.t_cljs$core$async21937(self__.f,self__.ch,meta21938__$1));
}));

(cljs.core.async.t_cljs$core$async21937.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21939){
var self__ = this;
var _21939__$1 = this;
return self__.meta21938;
}));

(cljs.core.async.t_cljs$core$async21937.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21937.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async21937.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async21937.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21937.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21940 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21940 = (function (f,ch,meta21938,_,fn1,meta21941){
this.f = f;
this.ch = ch;
this.meta21938 = meta21938;
this._ = _;
this.fn1 = fn1;
this.meta21941 = meta21941;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21940.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21942,meta21941__$1){
var self__ = this;
var _21942__$1 = this;
return (new cljs.core.async.t_cljs$core$async21940(self__.f,self__.ch,self__.meta21938,self__._,self__.fn1,meta21941__$1));
}));

(cljs.core.async.t_cljs$core$async21940.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21942){
var self__ = this;
var _21942__$1 = this;
return self__.meta21941;
}));

(cljs.core.async.t_cljs$core$async21940.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21940.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
}));

(cljs.core.async.t_cljs$core$async21940.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async21940.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return (function (p1__21936_SHARP_){
return f1.call(null,(((p1__21936_SHARP_ == null))?null:self__.f.call(null,p1__21936_SHARP_)));
});
}));

(cljs.core.async.t_cljs$core$async21940.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21938","meta21938",-621819069,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async21937","cljs.core.async/t_cljs$core$async21937",1153773608,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta21941","meta21941",-1691721113,null)], null);
}));

(cljs.core.async.t_cljs$core$async21940.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21940.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21940");

(cljs.core.async.t_cljs$core$async21940.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async21940");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21940.
 */
cljs.core.async.__GT_t_cljs$core$async21940 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21940(f__$1,ch__$1,meta21938__$1,___$2,fn1__$1,meta21941){
return (new cljs.core.async.t_cljs$core$async21940(f__$1,ch__$1,meta21938__$1,___$2,fn1__$1,meta21941));
});

}

return (new cljs.core.async.t_cljs$core$async21940(self__.f,self__.ch,self__.meta21938,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async21937.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21937.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async21937.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21938","meta21938",-621819069,null)], null);
}));

(cljs.core.async.t_cljs$core$async21937.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21937.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21937");

(cljs.core.async.t_cljs$core$async21937.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async21937");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21937.
 */
cljs.core.async.__GT_t_cljs$core$async21937 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async21937(f__$1,ch__$1,meta21938){
return (new cljs.core.async.t_cljs$core$async21937(f__$1,ch__$1,meta21938));
});

}

return (new cljs.core.async.t_cljs$core$async21937(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21943 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21943 = (function (f,ch,meta21944){
this.f = f;
this.ch = ch;
this.meta21944 = meta21944;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21943.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21945,meta21944__$1){
var self__ = this;
var _21945__$1 = this;
return (new cljs.core.async.t_cljs$core$async21943(self__.f,self__.ch,meta21944__$1));
}));

(cljs.core.async.t_cljs$core$async21943.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21945){
var self__ = this;
var _21945__$1 = this;
return self__.meta21944;
}));

(cljs.core.async.t_cljs$core$async21943.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21943.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async21943.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21943.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async21943.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21943.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
}));

(cljs.core.async.t_cljs$core$async21943.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21944","meta21944",-1083430222,null)], null);
}));

(cljs.core.async.t_cljs$core$async21943.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21943.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21943");

(cljs.core.async.t_cljs$core$async21943.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async21943");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21943.
 */
cljs.core.async.__GT_t_cljs$core$async21943 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async21943(f__$1,ch__$1,meta21944){
return (new cljs.core.async.t_cljs$core$async21943(f__$1,ch__$1,meta21944));
});

}

return (new cljs.core.async.t_cljs$core$async21943(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async21946 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async21946 = (function (p,ch,meta21947){
this.p = p;
this.ch = ch;
this.meta21947 = meta21947;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async21946.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_21948,meta21947__$1){
var self__ = this;
var _21948__$1 = this;
return (new cljs.core.async.t_cljs$core$async21946(self__.p,self__.ch,meta21947__$1));
}));

(cljs.core.async.t_cljs$core$async21946.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_21948){
var self__ = this;
var _21948__$1 = this;
return self__.meta21947;
}));

(cljs.core.async.t_cljs$core$async21946.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21946.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async21946.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
}));

(cljs.core.async.t_cljs$core$async21946.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21946.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async21946.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async21946.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async21946.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta21947","meta21947",1136211742,null)], null);
}));

(cljs.core.async.t_cljs$core$async21946.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async21946.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async21946");

(cljs.core.async.t_cljs$core$async21946.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write.call(null,writer__5331__auto__,"cljs.core.async/t_cljs$core$async21946");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async21946.
 */
cljs.core.async.__GT_t_cljs$core$async21946 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async21946(p__$1,ch__$1,meta21947){
return (new cljs.core.async.t_cljs$core$async21946(p__$1,ch__$1,meta21947));
});

}

return (new cljs.core.async.t_cljs$core$async21946(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__21950 = arguments.length;
switch (G__21950) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20507__auto___21990 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_21971){
var state_val_21972 = (state_21971[(1)]);
if((state_val_21972 === (7))){
var inst_21967 = (state_21971[(2)]);
var state_21971__$1 = state_21971;
var statearr_21973_21991 = state_21971__$1;
(statearr_21973_21991[(2)] = inst_21967);

(statearr_21973_21991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21972 === (1))){
var state_21971__$1 = state_21971;
var statearr_21974_21992 = state_21971__$1;
(statearr_21974_21992[(2)] = null);

(statearr_21974_21992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21972 === (4))){
var inst_21953 = (state_21971[(7)]);
var inst_21953__$1 = (state_21971[(2)]);
var inst_21954 = (inst_21953__$1 == null);
var state_21971__$1 = (function (){var statearr_21975 = state_21971;
(statearr_21975[(7)] = inst_21953__$1);

return statearr_21975;
})();
if(cljs.core.truth_(inst_21954)){
var statearr_21976_21993 = state_21971__$1;
(statearr_21976_21993[(1)] = (5));

} else {
var statearr_21977_21994 = state_21971__$1;
(statearr_21977_21994[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21972 === (6))){
var inst_21953 = (state_21971[(7)]);
var inst_21958 = p.call(null,inst_21953);
var state_21971__$1 = state_21971;
if(cljs.core.truth_(inst_21958)){
var statearr_21978_21995 = state_21971__$1;
(statearr_21978_21995[(1)] = (8));

} else {
var statearr_21979_21996 = state_21971__$1;
(statearr_21979_21996[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21972 === (3))){
var inst_21969 = (state_21971[(2)]);
var state_21971__$1 = state_21971;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21971__$1,inst_21969);
} else {
if((state_val_21972 === (2))){
var state_21971__$1 = state_21971;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21971__$1,(4),ch);
} else {
if((state_val_21972 === (11))){
var inst_21961 = (state_21971[(2)]);
var state_21971__$1 = state_21971;
var statearr_21980_21997 = state_21971__$1;
(statearr_21980_21997[(2)] = inst_21961);

(statearr_21980_21997[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21972 === (9))){
var state_21971__$1 = state_21971;
var statearr_21981_21998 = state_21971__$1;
(statearr_21981_21998[(2)] = null);

(statearr_21981_21998[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21972 === (5))){
var inst_21956 = cljs.core.async.close_BANG_.call(null,out);
var state_21971__$1 = state_21971;
var statearr_21982_21999 = state_21971__$1;
(statearr_21982_21999[(2)] = inst_21956);

(statearr_21982_21999[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21972 === (10))){
var inst_21964 = (state_21971[(2)]);
var state_21971__$1 = (function (){var statearr_21983 = state_21971;
(statearr_21983[(8)] = inst_21964);

return statearr_21983;
})();
var statearr_21984_22000 = state_21971__$1;
(statearr_21984_22000[(2)] = null);

(statearr_21984_22000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21972 === (8))){
var inst_21953 = (state_21971[(7)]);
var state_21971__$1 = state_21971;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_21971__$1,(11),out,inst_21953);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_21985 = [null,null,null,null,null,null,null,null,null];
(statearr_21985[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_21985[(1)] = (1));

return statearr_21985;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_21971){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_21971);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e21986){if((e21986 instanceof Object)){
var ex__20414__auto__ = e21986;
var statearr_21987_22001 = state_21971;
(statearr_21987_22001[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_21971);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e21986;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22002 = state_21971;
state_21971 = G__22002;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_21971){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_21971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_21988 = f__20508__auto__.call(null);
(statearr_21988[(6)] = c__20507__auto___21990);

return statearr_21988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__22004 = arguments.length;
switch (G__22004) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20507__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_22067){
var state_val_22068 = (state_22067[(1)]);
if((state_val_22068 === (7))){
var inst_22063 = (state_22067[(2)]);
var state_22067__$1 = state_22067;
var statearr_22069_22107 = state_22067__$1;
(statearr_22069_22107[(2)] = inst_22063);

(statearr_22069_22107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (20))){
var inst_22033 = (state_22067[(7)]);
var inst_22044 = (state_22067[(2)]);
var inst_22045 = cljs.core.next.call(null,inst_22033);
var inst_22019 = inst_22045;
var inst_22020 = null;
var inst_22021 = (0);
var inst_22022 = (0);
var state_22067__$1 = (function (){var statearr_22070 = state_22067;
(statearr_22070[(8)] = inst_22019);

(statearr_22070[(9)] = inst_22022);

(statearr_22070[(10)] = inst_22020);

(statearr_22070[(11)] = inst_22021);

(statearr_22070[(12)] = inst_22044);

return statearr_22070;
})();
var statearr_22071_22108 = state_22067__$1;
(statearr_22071_22108[(2)] = null);

(statearr_22071_22108[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (1))){
var state_22067__$1 = state_22067;
var statearr_22072_22109 = state_22067__$1;
(statearr_22072_22109[(2)] = null);

(statearr_22072_22109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (4))){
var inst_22008 = (state_22067[(13)]);
var inst_22008__$1 = (state_22067[(2)]);
var inst_22009 = (inst_22008__$1 == null);
var state_22067__$1 = (function (){var statearr_22073 = state_22067;
(statearr_22073[(13)] = inst_22008__$1);

return statearr_22073;
})();
if(cljs.core.truth_(inst_22009)){
var statearr_22074_22110 = state_22067__$1;
(statearr_22074_22110[(1)] = (5));

} else {
var statearr_22075_22111 = state_22067__$1;
(statearr_22075_22111[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (15))){
var state_22067__$1 = state_22067;
var statearr_22079_22112 = state_22067__$1;
(statearr_22079_22112[(2)] = null);

(statearr_22079_22112[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (21))){
var state_22067__$1 = state_22067;
var statearr_22080_22113 = state_22067__$1;
(statearr_22080_22113[(2)] = null);

(statearr_22080_22113[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (13))){
var inst_22019 = (state_22067[(8)]);
var inst_22022 = (state_22067[(9)]);
var inst_22020 = (state_22067[(10)]);
var inst_22021 = (state_22067[(11)]);
var inst_22029 = (state_22067[(2)]);
var inst_22030 = (inst_22022 + (1));
var tmp22076 = inst_22019;
var tmp22077 = inst_22020;
var tmp22078 = inst_22021;
var inst_22019__$1 = tmp22076;
var inst_22020__$1 = tmp22077;
var inst_22021__$1 = tmp22078;
var inst_22022__$1 = inst_22030;
var state_22067__$1 = (function (){var statearr_22081 = state_22067;
(statearr_22081[(8)] = inst_22019__$1);

(statearr_22081[(9)] = inst_22022__$1);

(statearr_22081[(10)] = inst_22020__$1);

(statearr_22081[(11)] = inst_22021__$1);

(statearr_22081[(14)] = inst_22029);

return statearr_22081;
})();
var statearr_22082_22114 = state_22067__$1;
(statearr_22082_22114[(2)] = null);

(statearr_22082_22114[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (22))){
var state_22067__$1 = state_22067;
var statearr_22083_22115 = state_22067__$1;
(statearr_22083_22115[(2)] = null);

(statearr_22083_22115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (6))){
var inst_22008 = (state_22067[(13)]);
var inst_22017 = f.call(null,inst_22008);
var inst_22018 = cljs.core.seq.call(null,inst_22017);
var inst_22019 = inst_22018;
var inst_22020 = null;
var inst_22021 = (0);
var inst_22022 = (0);
var state_22067__$1 = (function (){var statearr_22084 = state_22067;
(statearr_22084[(8)] = inst_22019);

(statearr_22084[(9)] = inst_22022);

(statearr_22084[(10)] = inst_22020);

(statearr_22084[(11)] = inst_22021);

return statearr_22084;
})();
var statearr_22085_22116 = state_22067__$1;
(statearr_22085_22116[(2)] = null);

(statearr_22085_22116[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (17))){
var inst_22033 = (state_22067[(7)]);
var inst_22037 = cljs.core.chunk_first.call(null,inst_22033);
var inst_22038 = cljs.core.chunk_rest.call(null,inst_22033);
var inst_22039 = cljs.core.count.call(null,inst_22037);
var inst_22019 = inst_22038;
var inst_22020 = inst_22037;
var inst_22021 = inst_22039;
var inst_22022 = (0);
var state_22067__$1 = (function (){var statearr_22086 = state_22067;
(statearr_22086[(8)] = inst_22019);

(statearr_22086[(9)] = inst_22022);

(statearr_22086[(10)] = inst_22020);

(statearr_22086[(11)] = inst_22021);

return statearr_22086;
})();
var statearr_22087_22117 = state_22067__$1;
(statearr_22087_22117[(2)] = null);

(statearr_22087_22117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (3))){
var inst_22065 = (state_22067[(2)]);
var state_22067__$1 = state_22067;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22067__$1,inst_22065);
} else {
if((state_val_22068 === (12))){
var inst_22053 = (state_22067[(2)]);
var state_22067__$1 = state_22067;
var statearr_22088_22118 = state_22067__$1;
(statearr_22088_22118[(2)] = inst_22053);

(statearr_22088_22118[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (2))){
var state_22067__$1 = state_22067;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22067__$1,(4),in$);
} else {
if((state_val_22068 === (23))){
var inst_22061 = (state_22067[(2)]);
var state_22067__$1 = state_22067;
var statearr_22089_22119 = state_22067__$1;
(statearr_22089_22119[(2)] = inst_22061);

(statearr_22089_22119[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (19))){
var inst_22048 = (state_22067[(2)]);
var state_22067__$1 = state_22067;
var statearr_22090_22120 = state_22067__$1;
(statearr_22090_22120[(2)] = inst_22048);

(statearr_22090_22120[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (11))){
var inst_22019 = (state_22067[(8)]);
var inst_22033 = (state_22067[(7)]);
var inst_22033__$1 = cljs.core.seq.call(null,inst_22019);
var state_22067__$1 = (function (){var statearr_22091 = state_22067;
(statearr_22091[(7)] = inst_22033__$1);

return statearr_22091;
})();
if(inst_22033__$1){
var statearr_22092_22121 = state_22067__$1;
(statearr_22092_22121[(1)] = (14));

} else {
var statearr_22093_22122 = state_22067__$1;
(statearr_22093_22122[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (9))){
var inst_22055 = (state_22067[(2)]);
var inst_22056 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_22067__$1 = (function (){var statearr_22094 = state_22067;
(statearr_22094[(15)] = inst_22055);

return statearr_22094;
})();
if(cljs.core.truth_(inst_22056)){
var statearr_22095_22123 = state_22067__$1;
(statearr_22095_22123[(1)] = (21));

} else {
var statearr_22096_22124 = state_22067__$1;
(statearr_22096_22124[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (5))){
var inst_22011 = cljs.core.async.close_BANG_.call(null,out);
var state_22067__$1 = state_22067;
var statearr_22097_22125 = state_22067__$1;
(statearr_22097_22125[(2)] = inst_22011);

(statearr_22097_22125[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (14))){
var inst_22033 = (state_22067[(7)]);
var inst_22035 = cljs.core.chunked_seq_QMARK_.call(null,inst_22033);
var state_22067__$1 = state_22067;
if(inst_22035){
var statearr_22098_22126 = state_22067__$1;
(statearr_22098_22126[(1)] = (17));

} else {
var statearr_22099_22127 = state_22067__$1;
(statearr_22099_22127[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (16))){
var inst_22051 = (state_22067[(2)]);
var state_22067__$1 = state_22067;
var statearr_22100_22128 = state_22067__$1;
(statearr_22100_22128[(2)] = inst_22051);

(statearr_22100_22128[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22068 === (10))){
var inst_22022 = (state_22067[(9)]);
var inst_22020 = (state_22067[(10)]);
var inst_22027 = cljs.core._nth.call(null,inst_22020,inst_22022);
var state_22067__$1 = state_22067;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22067__$1,(13),out,inst_22027);
} else {
if((state_val_22068 === (18))){
var inst_22033 = (state_22067[(7)]);
var inst_22042 = cljs.core.first.call(null,inst_22033);
var state_22067__$1 = state_22067;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22067__$1,(20),out,inst_22042);
} else {
if((state_val_22068 === (8))){
var inst_22022 = (state_22067[(9)]);
var inst_22021 = (state_22067[(11)]);
var inst_22024 = (inst_22022 < inst_22021);
var inst_22025 = inst_22024;
var state_22067__$1 = state_22067;
if(cljs.core.truth_(inst_22025)){
var statearr_22101_22129 = state_22067__$1;
(statearr_22101_22129[(1)] = (10));

} else {
var statearr_22102_22130 = state_22067__$1;
(statearr_22102_22130[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20411__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20411__auto____0 = (function (){
var statearr_22103 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22103[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20411__auto__);

(statearr_22103[(1)] = (1));

return statearr_22103;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20411__auto____1 = (function (state_22067){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_22067);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e22104){if((e22104 instanceof Object)){
var ex__20414__auto__ = e22104;
var statearr_22105_22131 = state_22067;
(statearr_22105_22131[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22067);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22104;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22132 = state_22067;
state_22067 = G__22132;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20411__auto__ = function(state_22067){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20411__auto____1.call(this,state_22067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20411__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20411__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_22106 = f__20508__auto__.call(null);
(statearr_22106[(6)] = c__20507__auto__);

return statearr_22106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));

return c__20507__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__22134 = arguments.length;
switch (G__22134) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__22137 = arguments.length;
switch (G__22137) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__22140 = arguments.length;
switch (G__22140) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20507__auto___22187 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_22164){
var state_val_22165 = (state_22164[(1)]);
if((state_val_22165 === (7))){
var inst_22159 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22166_22188 = state_22164__$1;
(statearr_22166_22188[(2)] = inst_22159);

(statearr_22166_22188[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (1))){
var inst_22141 = null;
var state_22164__$1 = (function (){var statearr_22167 = state_22164;
(statearr_22167[(7)] = inst_22141);

return statearr_22167;
})();
var statearr_22168_22189 = state_22164__$1;
(statearr_22168_22189[(2)] = null);

(statearr_22168_22189[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (4))){
var inst_22144 = (state_22164[(8)]);
var inst_22144__$1 = (state_22164[(2)]);
var inst_22145 = (inst_22144__$1 == null);
var inst_22146 = cljs.core.not.call(null,inst_22145);
var state_22164__$1 = (function (){var statearr_22169 = state_22164;
(statearr_22169[(8)] = inst_22144__$1);

return statearr_22169;
})();
if(inst_22146){
var statearr_22170_22190 = state_22164__$1;
(statearr_22170_22190[(1)] = (5));

} else {
var statearr_22171_22191 = state_22164__$1;
(statearr_22171_22191[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (6))){
var state_22164__$1 = state_22164;
var statearr_22172_22192 = state_22164__$1;
(statearr_22172_22192[(2)] = null);

(statearr_22172_22192[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (3))){
var inst_22161 = (state_22164[(2)]);
var inst_22162 = cljs.core.async.close_BANG_.call(null,out);
var state_22164__$1 = (function (){var statearr_22173 = state_22164;
(statearr_22173[(9)] = inst_22161);

return statearr_22173;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22164__$1,inst_22162);
} else {
if((state_val_22165 === (2))){
var state_22164__$1 = state_22164;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22164__$1,(4),ch);
} else {
if((state_val_22165 === (11))){
var inst_22144 = (state_22164[(8)]);
var inst_22153 = (state_22164[(2)]);
var inst_22141 = inst_22144;
var state_22164__$1 = (function (){var statearr_22174 = state_22164;
(statearr_22174[(7)] = inst_22141);

(statearr_22174[(10)] = inst_22153);

return statearr_22174;
})();
var statearr_22175_22193 = state_22164__$1;
(statearr_22175_22193[(2)] = null);

(statearr_22175_22193[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (9))){
var inst_22144 = (state_22164[(8)]);
var state_22164__$1 = state_22164;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22164__$1,(11),out,inst_22144);
} else {
if((state_val_22165 === (5))){
var inst_22144 = (state_22164[(8)]);
var inst_22141 = (state_22164[(7)]);
var inst_22148 = cljs.core._EQ_.call(null,inst_22144,inst_22141);
var state_22164__$1 = state_22164;
if(inst_22148){
var statearr_22177_22194 = state_22164__$1;
(statearr_22177_22194[(1)] = (8));

} else {
var statearr_22178_22195 = state_22164__$1;
(statearr_22178_22195[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (10))){
var inst_22156 = (state_22164[(2)]);
var state_22164__$1 = state_22164;
var statearr_22179_22196 = state_22164__$1;
(statearr_22179_22196[(2)] = inst_22156);

(statearr_22179_22196[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22165 === (8))){
var inst_22141 = (state_22164[(7)]);
var tmp22176 = inst_22141;
var inst_22141__$1 = tmp22176;
var state_22164__$1 = (function (){var statearr_22180 = state_22164;
(statearr_22180[(7)] = inst_22141__$1);

return statearr_22180;
})();
var statearr_22181_22197 = state_22164__$1;
(statearr_22181_22197[(2)] = null);

(statearr_22181_22197[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_22182 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22182[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_22182[(1)] = (1));

return statearr_22182;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_22164){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_22164);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e22183){if((e22183 instanceof Object)){
var ex__20414__auto__ = e22183;
var statearr_22184_22198 = state_22164;
(statearr_22184_22198[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22164);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22183;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22199 = state_22164;
state_22164 = G__22199;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_22164){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_22164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_22185 = f__20508__auto__.call(null);
(statearr_22185[(6)] = c__20507__auto___22187);

return statearr_22185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__22201 = arguments.length;
switch (G__22201) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20507__auto___22267 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_22239){
var state_val_22240 = (state_22239[(1)]);
if((state_val_22240 === (7))){
var inst_22235 = (state_22239[(2)]);
var state_22239__$1 = state_22239;
var statearr_22241_22268 = state_22239__$1;
(statearr_22241_22268[(2)] = inst_22235);

(statearr_22241_22268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (1))){
var inst_22202 = (new Array(n));
var inst_22203 = inst_22202;
var inst_22204 = (0);
var state_22239__$1 = (function (){var statearr_22242 = state_22239;
(statearr_22242[(7)] = inst_22204);

(statearr_22242[(8)] = inst_22203);

return statearr_22242;
})();
var statearr_22243_22269 = state_22239__$1;
(statearr_22243_22269[(2)] = null);

(statearr_22243_22269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (4))){
var inst_22207 = (state_22239[(9)]);
var inst_22207__$1 = (state_22239[(2)]);
var inst_22208 = (inst_22207__$1 == null);
var inst_22209 = cljs.core.not.call(null,inst_22208);
var state_22239__$1 = (function (){var statearr_22244 = state_22239;
(statearr_22244[(9)] = inst_22207__$1);

return statearr_22244;
})();
if(inst_22209){
var statearr_22245_22270 = state_22239__$1;
(statearr_22245_22270[(1)] = (5));

} else {
var statearr_22246_22271 = state_22239__$1;
(statearr_22246_22271[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (15))){
var inst_22229 = (state_22239[(2)]);
var state_22239__$1 = state_22239;
var statearr_22247_22272 = state_22239__$1;
(statearr_22247_22272[(2)] = inst_22229);

(statearr_22247_22272[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (13))){
var state_22239__$1 = state_22239;
var statearr_22248_22273 = state_22239__$1;
(statearr_22248_22273[(2)] = null);

(statearr_22248_22273[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (6))){
var inst_22204 = (state_22239[(7)]);
var inst_22225 = (inst_22204 > (0));
var state_22239__$1 = state_22239;
if(cljs.core.truth_(inst_22225)){
var statearr_22249_22274 = state_22239__$1;
(statearr_22249_22274[(1)] = (12));

} else {
var statearr_22250_22275 = state_22239__$1;
(statearr_22250_22275[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (3))){
var inst_22237 = (state_22239[(2)]);
var state_22239__$1 = state_22239;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22239__$1,inst_22237);
} else {
if((state_val_22240 === (12))){
var inst_22203 = (state_22239[(8)]);
var inst_22227 = cljs.core.vec.call(null,inst_22203);
var state_22239__$1 = state_22239;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22239__$1,(15),out,inst_22227);
} else {
if((state_val_22240 === (2))){
var state_22239__$1 = state_22239;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22239__$1,(4),ch);
} else {
if((state_val_22240 === (11))){
var inst_22219 = (state_22239[(2)]);
var inst_22220 = (new Array(n));
var inst_22203 = inst_22220;
var inst_22204 = (0);
var state_22239__$1 = (function (){var statearr_22251 = state_22239;
(statearr_22251[(7)] = inst_22204);

(statearr_22251[(8)] = inst_22203);

(statearr_22251[(10)] = inst_22219);

return statearr_22251;
})();
var statearr_22252_22276 = state_22239__$1;
(statearr_22252_22276[(2)] = null);

(statearr_22252_22276[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (9))){
var inst_22203 = (state_22239[(8)]);
var inst_22217 = cljs.core.vec.call(null,inst_22203);
var state_22239__$1 = state_22239;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22239__$1,(11),out,inst_22217);
} else {
if((state_val_22240 === (5))){
var inst_22204 = (state_22239[(7)]);
var inst_22207 = (state_22239[(9)]);
var inst_22203 = (state_22239[(8)]);
var inst_22212 = (state_22239[(11)]);
var inst_22211 = (inst_22203[inst_22204] = inst_22207);
var inst_22212__$1 = (inst_22204 + (1));
var inst_22213 = (inst_22212__$1 < n);
var state_22239__$1 = (function (){var statearr_22253 = state_22239;
(statearr_22253[(11)] = inst_22212__$1);

(statearr_22253[(12)] = inst_22211);

return statearr_22253;
})();
if(cljs.core.truth_(inst_22213)){
var statearr_22254_22277 = state_22239__$1;
(statearr_22254_22277[(1)] = (8));

} else {
var statearr_22255_22278 = state_22239__$1;
(statearr_22255_22278[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (14))){
var inst_22232 = (state_22239[(2)]);
var inst_22233 = cljs.core.async.close_BANG_.call(null,out);
var state_22239__$1 = (function (){var statearr_22257 = state_22239;
(statearr_22257[(13)] = inst_22232);

return statearr_22257;
})();
var statearr_22258_22279 = state_22239__$1;
(statearr_22258_22279[(2)] = inst_22233);

(statearr_22258_22279[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (10))){
var inst_22223 = (state_22239[(2)]);
var state_22239__$1 = state_22239;
var statearr_22259_22280 = state_22239__$1;
(statearr_22259_22280[(2)] = inst_22223);

(statearr_22259_22280[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22240 === (8))){
var inst_22203 = (state_22239[(8)]);
var inst_22212 = (state_22239[(11)]);
var tmp22256 = inst_22203;
var inst_22203__$1 = tmp22256;
var inst_22204 = inst_22212;
var state_22239__$1 = (function (){var statearr_22260 = state_22239;
(statearr_22260[(7)] = inst_22204);

(statearr_22260[(8)] = inst_22203__$1);

return statearr_22260;
})();
var statearr_22261_22281 = state_22239__$1;
(statearr_22261_22281[(2)] = null);

(statearr_22261_22281[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_22262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22262[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_22262[(1)] = (1));

return statearr_22262;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_22239){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_22239);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e22263){if((e22263 instanceof Object)){
var ex__20414__auto__ = e22263;
var statearr_22264_22282 = state_22239;
(statearr_22264_22282[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22239);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22263;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22283 = state_22239;
state_22239 = G__22283;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_22239){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_22239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_22265 = f__20508__auto__.call(null);
(statearr_22265[(6)] = c__20507__auto___22267);

return statearr_22265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__22285 = arguments.length;
switch (G__22285) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__20507__auto___22362 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__20508__auto__ = (function (){var switch__20410__auto__ = (function (state_22330){
var state_val_22331 = (state_22330[(1)]);
if((state_val_22331 === (7))){
var inst_22326 = (state_22330[(2)]);
var state_22330__$1 = state_22330;
var statearr_22332_22363 = state_22330__$1;
(statearr_22332_22363[(2)] = inst_22326);

(statearr_22332_22363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (1))){
var inst_22286 = [];
var inst_22287 = inst_22286;
var inst_22288 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_22330__$1 = (function (){var statearr_22333 = state_22330;
(statearr_22333[(7)] = inst_22287);

(statearr_22333[(8)] = inst_22288);

return statearr_22333;
})();
var statearr_22334_22364 = state_22330__$1;
(statearr_22334_22364[(2)] = null);

(statearr_22334_22364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (4))){
var inst_22291 = (state_22330[(9)]);
var inst_22291__$1 = (state_22330[(2)]);
var inst_22292 = (inst_22291__$1 == null);
var inst_22293 = cljs.core.not.call(null,inst_22292);
var state_22330__$1 = (function (){var statearr_22335 = state_22330;
(statearr_22335[(9)] = inst_22291__$1);

return statearr_22335;
})();
if(inst_22293){
var statearr_22336_22365 = state_22330__$1;
(statearr_22336_22365[(1)] = (5));

} else {
var statearr_22337_22366 = state_22330__$1;
(statearr_22337_22366[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (15))){
var inst_22287 = (state_22330[(7)]);
var inst_22318 = cljs.core.vec.call(null,inst_22287);
var state_22330__$1 = state_22330;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22330__$1,(18),out,inst_22318);
} else {
if((state_val_22331 === (13))){
var inst_22313 = (state_22330[(2)]);
var state_22330__$1 = state_22330;
var statearr_22338_22367 = state_22330__$1;
(statearr_22338_22367[(2)] = inst_22313);

(statearr_22338_22367[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (6))){
var inst_22287 = (state_22330[(7)]);
var inst_22315 = inst_22287.length;
var inst_22316 = (inst_22315 > (0));
var state_22330__$1 = state_22330;
if(cljs.core.truth_(inst_22316)){
var statearr_22339_22368 = state_22330__$1;
(statearr_22339_22368[(1)] = (15));

} else {
var statearr_22340_22369 = state_22330__$1;
(statearr_22340_22369[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (17))){
var inst_22323 = (state_22330[(2)]);
var inst_22324 = cljs.core.async.close_BANG_.call(null,out);
var state_22330__$1 = (function (){var statearr_22341 = state_22330;
(statearr_22341[(10)] = inst_22323);

return statearr_22341;
})();
var statearr_22342_22370 = state_22330__$1;
(statearr_22342_22370[(2)] = inst_22324);

(statearr_22342_22370[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (3))){
var inst_22328 = (state_22330[(2)]);
var state_22330__$1 = state_22330;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22330__$1,inst_22328);
} else {
if((state_val_22331 === (12))){
var inst_22287 = (state_22330[(7)]);
var inst_22306 = cljs.core.vec.call(null,inst_22287);
var state_22330__$1 = state_22330;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22330__$1,(14),out,inst_22306);
} else {
if((state_val_22331 === (2))){
var state_22330__$1 = state_22330;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22330__$1,(4),ch);
} else {
if((state_val_22331 === (11))){
var inst_22287 = (state_22330[(7)]);
var inst_22295 = (state_22330[(11)]);
var inst_22291 = (state_22330[(9)]);
var inst_22303 = inst_22287.push(inst_22291);
var tmp22343 = inst_22287;
var inst_22287__$1 = tmp22343;
var inst_22288 = inst_22295;
var state_22330__$1 = (function (){var statearr_22344 = state_22330;
(statearr_22344[(12)] = inst_22303);

(statearr_22344[(7)] = inst_22287__$1);

(statearr_22344[(8)] = inst_22288);

return statearr_22344;
})();
var statearr_22345_22371 = state_22330__$1;
(statearr_22345_22371[(2)] = null);

(statearr_22345_22371[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (9))){
var inst_22288 = (state_22330[(8)]);
var inst_22299 = cljs.core.keyword_identical_QMARK_.call(null,inst_22288,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_22330__$1 = state_22330;
var statearr_22346_22372 = state_22330__$1;
(statearr_22346_22372[(2)] = inst_22299);

(statearr_22346_22372[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (5))){
var inst_22296 = (state_22330[(13)]);
var inst_22288 = (state_22330[(8)]);
var inst_22295 = (state_22330[(11)]);
var inst_22291 = (state_22330[(9)]);
var inst_22295__$1 = f.call(null,inst_22291);
var inst_22296__$1 = cljs.core._EQ_.call(null,inst_22295__$1,inst_22288);
var state_22330__$1 = (function (){var statearr_22347 = state_22330;
(statearr_22347[(13)] = inst_22296__$1);

(statearr_22347[(11)] = inst_22295__$1);

return statearr_22347;
})();
if(inst_22296__$1){
var statearr_22348_22373 = state_22330__$1;
(statearr_22348_22373[(1)] = (8));

} else {
var statearr_22349_22374 = state_22330__$1;
(statearr_22349_22374[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (14))){
var inst_22295 = (state_22330[(11)]);
var inst_22291 = (state_22330[(9)]);
var inst_22308 = (state_22330[(2)]);
var inst_22309 = [];
var inst_22310 = inst_22309.push(inst_22291);
var inst_22287 = inst_22309;
var inst_22288 = inst_22295;
var state_22330__$1 = (function (){var statearr_22350 = state_22330;
(statearr_22350[(7)] = inst_22287);

(statearr_22350[(14)] = inst_22310);

(statearr_22350[(15)] = inst_22308);

(statearr_22350[(8)] = inst_22288);

return statearr_22350;
})();
var statearr_22351_22375 = state_22330__$1;
(statearr_22351_22375[(2)] = null);

(statearr_22351_22375[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (16))){
var state_22330__$1 = state_22330;
var statearr_22352_22376 = state_22330__$1;
(statearr_22352_22376[(2)] = null);

(statearr_22352_22376[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (10))){
var inst_22301 = (state_22330[(2)]);
var state_22330__$1 = state_22330;
if(cljs.core.truth_(inst_22301)){
var statearr_22353_22377 = state_22330__$1;
(statearr_22353_22377[(1)] = (11));

} else {
var statearr_22354_22378 = state_22330__$1;
(statearr_22354_22378[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (18))){
var inst_22320 = (state_22330[(2)]);
var state_22330__$1 = state_22330;
var statearr_22355_22379 = state_22330__$1;
(statearr_22355_22379[(2)] = inst_22320);

(statearr_22355_22379[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22331 === (8))){
var inst_22296 = (state_22330[(13)]);
var state_22330__$1 = state_22330;
var statearr_22356_22380 = state_22330__$1;
(statearr_22356_22380[(2)] = inst_22296);

(statearr_22356_22380[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20411__auto__ = null;
var cljs$core$async$state_machine__20411__auto____0 = (function (){
var statearr_22357 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22357[(0)] = cljs$core$async$state_machine__20411__auto__);

(statearr_22357[(1)] = (1));

return statearr_22357;
});
var cljs$core$async$state_machine__20411__auto____1 = (function (state_22330){
while(true){
var ret_value__20412__auto__ = (function (){try{while(true){
var result__20413__auto__ = switch__20410__auto__.call(null,state_22330);
if(cljs.core.keyword_identical_QMARK_.call(null,result__20413__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__20413__auto__;
}
break;
}
}catch (e22358){if((e22358 instanceof Object)){
var ex__20414__auto__ = e22358;
var statearr_22359_22381 = state_22330;
(statearr_22359_22381[(5)] = ex__20414__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22330);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22358;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__20412__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22382 = state_22330;
state_22330 = G__22382;
continue;
} else {
return ret_value__20412__auto__;
}
break;
}
});
cljs$core$async$state_machine__20411__auto__ = function(state_22330){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20411__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20411__auto____1.call(this,state_22330);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20411__auto____0;
cljs$core$async$state_machine__20411__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20411__auto____1;
return cljs$core$async$state_machine__20411__auto__;
})()
})();
var state__20509__auto__ = (function (){var statearr_22360 = f__20508__auto__.call(null);
(statearr_22360[(6)] = c__20507__auto___22362);

return statearr_22360;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__20509__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=async.js.map
