goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_36255 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_36255(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_36270 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null,this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_36270(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__35341 = coll;
var G__35342 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__35341,G__35342) : shadow.dom.lazy_native_coll_seq.call(null,G__35341,G__35342));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__35365 = arguments.length;
switch (G__35365) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__35367 = arguments.length;
switch (G__35367) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__35375 = arguments.length;
switch (G__35375) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__35388 = arguments.length;
switch (G__35388) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__35398 = arguments.length;
switch (G__35398) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__35401 = arguments.length;
switch (G__35401) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e35409){if((e35409 instanceof Object)){
var e = e35409;
return console.log("didnt support attachEvent",el,e);
} else {
throw e35409;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__35419 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__35420 = null;
var count__35421 = (0);
var i__35422 = (0);
while(true){
if((i__35422 < count__35421)){
var el = chunk__35420.cljs$core$IIndexed$_nth$arity$2(null,i__35422);
var handler_36439__$1 = ((function (seq__35419,chunk__35420,count__35421,i__35422,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__35419,chunk__35420,count__35421,i__35422,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_36439__$1);


var G__36445 = seq__35419;
var G__36446 = chunk__35420;
var G__36447 = count__35421;
var G__36448 = (i__35422 + (1));
seq__35419 = G__36445;
chunk__35420 = G__36446;
count__35421 = G__36447;
i__35422 = G__36448;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__35419);
if(temp__5823__auto__){
var seq__35419__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35419__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__35419__$1);
var G__36460 = cljs.core.chunk_rest(seq__35419__$1);
var G__36461 = c__5525__auto__;
var G__36462 = cljs.core.count(c__5525__auto__);
var G__36463 = (0);
seq__35419 = G__36460;
chunk__35420 = G__36461;
count__35421 = G__36462;
i__35422 = G__36463;
continue;
} else {
var el = cljs.core.first(seq__35419__$1);
var handler_36482__$1 = ((function (seq__35419,chunk__35420,count__35421,i__35422,el,seq__35419__$1,temp__5823__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__35419,chunk__35420,count__35421,i__35422,el,seq__35419__$1,temp__5823__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_36482__$1);


var G__36488 = cljs.core.next(seq__35419__$1);
var G__36489 = null;
var G__36490 = (0);
var G__36491 = (0);
seq__35419 = G__36488;
chunk__35420 = G__36489;
count__35421 = G__36490;
i__35422 = G__36491;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__35437 = arguments.length;
switch (G__35437) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__35440 = cljs.core.seq(events);
var chunk__35441 = null;
var count__35442 = (0);
var i__35443 = (0);
while(true){
if((i__35443 < count__35442)){
var vec__35458 = chunk__35441.cljs$core$IIndexed$_nth$arity$2(null,i__35443);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35458,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35458,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__36516 = seq__35440;
var G__36517 = chunk__35441;
var G__36518 = count__35442;
var G__36519 = (i__35443 + (1));
seq__35440 = G__36516;
chunk__35441 = G__36517;
count__35442 = G__36518;
i__35443 = G__36519;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__35440);
if(temp__5823__auto__){
var seq__35440__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35440__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__35440__$1);
var G__36536 = cljs.core.chunk_rest(seq__35440__$1);
var G__36537 = c__5525__auto__;
var G__36538 = cljs.core.count(c__5525__auto__);
var G__36539 = (0);
seq__35440 = G__36536;
chunk__35441 = G__36537;
count__35442 = G__36538;
i__35443 = G__36539;
continue;
} else {
var vec__35463 = cljs.core.first(seq__35440__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35463,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35463,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__36542 = cljs.core.next(seq__35440__$1);
var G__36543 = null;
var G__36544 = (0);
var G__36545 = (0);
seq__35440 = G__36542;
chunk__35441 = G__36543;
count__35442 = G__36544;
i__35443 = G__36545;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__35468 = cljs.core.seq(styles);
var chunk__35469 = null;
var count__35470 = (0);
var i__35471 = (0);
while(true){
if((i__35471 < count__35470)){
var vec__35482 = chunk__35469.cljs$core$IIndexed$_nth$arity$2(null,i__35471);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35482,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35482,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__36556 = seq__35468;
var G__36557 = chunk__35469;
var G__36558 = count__35470;
var G__36559 = (i__35471 + (1));
seq__35468 = G__36556;
chunk__35469 = G__36557;
count__35470 = G__36558;
i__35471 = G__36559;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__35468);
if(temp__5823__auto__){
var seq__35468__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35468__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__35468__$1);
var G__36561 = cljs.core.chunk_rest(seq__35468__$1);
var G__36562 = c__5525__auto__;
var G__36563 = cljs.core.count(c__5525__auto__);
var G__36564 = (0);
seq__35468 = G__36561;
chunk__35469 = G__36562;
count__35470 = G__36563;
i__35471 = G__36564;
continue;
} else {
var vec__35491 = cljs.core.first(seq__35468__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35491,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35491,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__36569 = cljs.core.next(seq__35468__$1);
var G__36570 = null;
var G__36571 = (0);
var G__36572 = (0);
seq__35468 = G__36569;
chunk__35469 = G__36570;
count__35470 = G__36571;
i__35471 = G__36572;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__35503_36574 = key;
var G__35503_36575__$1 = (((G__35503_36574 instanceof cljs.core.Keyword))?G__35503_36574.fqn:null);
switch (G__35503_36575__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_36602 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_36602,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_36602,"aria-");
}
})())){
el.setAttribute(ks_36602,value);
} else {
(el[ks_36602] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__35550){
var map__35551 = p__35550;
var map__35551__$1 = cljs.core.__destructure_map(map__35551);
var props = map__35551__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35551__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__35552 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35552,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35552,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35552,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__35555 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__35555,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__35555;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__35557 = arguments.length;
switch (G__35557) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__35565){
var vec__35566 = p__35565;
var seq__35567 = cljs.core.seq(vec__35566);
var first__35568 = cljs.core.first(seq__35567);
var seq__35567__$1 = cljs.core.next(seq__35567);
var nn = first__35568;
var first__35568__$1 = cljs.core.first(seq__35567__$1);
var seq__35567__$2 = cljs.core.next(seq__35567__$1);
var np = first__35568__$1;
var nc = seq__35567__$2;
var node = vec__35566;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35569 = nn;
var G__35570 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__35569,G__35570) : create_fn.call(null,G__35569,G__35570));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__35571 = nn;
var G__35572 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__35571,G__35572) : create_fn.call(null,G__35571,G__35572));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__35574 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35574,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35574,(1),null);
var seq__35589_36684 = cljs.core.seq(node_children);
var chunk__35590_36685 = null;
var count__35591_36686 = (0);
var i__35592_36687 = (0);
while(true){
if((i__35592_36687 < count__35591_36686)){
var child_struct_36690 = chunk__35590_36685.cljs$core$IIndexed$_nth$arity$2(null,i__35592_36687);
var children_36692 = shadow.dom.dom_node(child_struct_36690);
if(cljs.core.seq_QMARK_(children_36692)){
var seq__35625_36693 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_36692));
var chunk__35627_36694 = null;
var count__35628_36695 = (0);
var i__35629_36696 = (0);
while(true){
if((i__35629_36696 < count__35628_36695)){
var child_36699 = chunk__35627_36694.cljs$core$IIndexed$_nth$arity$2(null,i__35629_36696);
if(cljs.core.truth_(child_36699)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36699);


var G__36703 = seq__35625_36693;
var G__36704 = chunk__35627_36694;
var G__36705 = count__35628_36695;
var G__36706 = (i__35629_36696 + (1));
seq__35625_36693 = G__36703;
chunk__35627_36694 = G__36704;
count__35628_36695 = G__36705;
i__35629_36696 = G__36706;
continue;
} else {
var G__36708 = seq__35625_36693;
var G__36710 = chunk__35627_36694;
var G__36712 = count__35628_36695;
var G__36713 = (i__35629_36696 + (1));
seq__35625_36693 = G__36708;
chunk__35627_36694 = G__36710;
count__35628_36695 = G__36712;
i__35629_36696 = G__36713;
continue;
}
} else {
var temp__5823__auto___36716 = cljs.core.seq(seq__35625_36693);
if(temp__5823__auto___36716){
var seq__35625_36717__$1 = temp__5823__auto___36716;
if(cljs.core.chunked_seq_QMARK_(seq__35625_36717__$1)){
var c__5525__auto___36719 = cljs.core.chunk_first(seq__35625_36717__$1);
var G__36721 = cljs.core.chunk_rest(seq__35625_36717__$1);
var G__36722 = c__5525__auto___36719;
var G__36723 = cljs.core.count(c__5525__auto___36719);
var G__36724 = (0);
seq__35625_36693 = G__36721;
chunk__35627_36694 = G__36722;
count__35628_36695 = G__36723;
i__35629_36696 = G__36724;
continue;
} else {
var child_36725 = cljs.core.first(seq__35625_36717__$1);
if(cljs.core.truth_(child_36725)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36725);


var G__36726 = cljs.core.next(seq__35625_36717__$1);
var G__36727 = null;
var G__36728 = (0);
var G__36729 = (0);
seq__35625_36693 = G__36726;
chunk__35627_36694 = G__36727;
count__35628_36695 = G__36728;
i__35629_36696 = G__36729;
continue;
} else {
var G__36730 = cljs.core.next(seq__35625_36717__$1);
var G__36731 = null;
var G__36732 = (0);
var G__36733 = (0);
seq__35625_36693 = G__36730;
chunk__35627_36694 = G__36731;
count__35628_36695 = G__36732;
i__35629_36696 = G__36733;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_36692);
}


var G__36734 = seq__35589_36684;
var G__36735 = chunk__35590_36685;
var G__36736 = count__35591_36686;
var G__36737 = (i__35592_36687 + (1));
seq__35589_36684 = G__36734;
chunk__35590_36685 = G__36735;
count__35591_36686 = G__36736;
i__35592_36687 = G__36737;
continue;
} else {
var temp__5823__auto___36739 = cljs.core.seq(seq__35589_36684);
if(temp__5823__auto___36739){
var seq__35589_36745__$1 = temp__5823__auto___36739;
if(cljs.core.chunked_seq_QMARK_(seq__35589_36745__$1)){
var c__5525__auto___36746 = cljs.core.chunk_first(seq__35589_36745__$1);
var G__36747 = cljs.core.chunk_rest(seq__35589_36745__$1);
var G__36748 = c__5525__auto___36746;
var G__36749 = cljs.core.count(c__5525__auto___36746);
var G__36750 = (0);
seq__35589_36684 = G__36747;
chunk__35590_36685 = G__36748;
count__35591_36686 = G__36749;
i__35592_36687 = G__36750;
continue;
} else {
var child_struct_36752 = cljs.core.first(seq__35589_36745__$1);
var children_36755 = shadow.dom.dom_node(child_struct_36752);
if(cljs.core.seq_QMARK_(children_36755)){
var seq__35634_36757 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_36755));
var chunk__35636_36758 = null;
var count__35637_36759 = (0);
var i__35638_36760 = (0);
while(true){
if((i__35638_36760 < count__35637_36759)){
var child_36763 = chunk__35636_36758.cljs$core$IIndexed$_nth$arity$2(null,i__35638_36760);
if(cljs.core.truth_(child_36763)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36763);


var G__36767 = seq__35634_36757;
var G__36768 = chunk__35636_36758;
var G__36769 = count__35637_36759;
var G__36770 = (i__35638_36760 + (1));
seq__35634_36757 = G__36767;
chunk__35636_36758 = G__36768;
count__35637_36759 = G__36769;
i__35638_36760 = G__36770;
continue;
} else {
var G__36771 = seq__35634_36757;
var G__36772 = chunk__35636_36758;
var G__36773 = count__35637_36759;
var G__36774 = (i__35638_36760 + (1));
seq__35634_36757 = G__36771;
chunk__35636_36758 = G__36772;
count__35637_36759 = G__36773;
i__35638_36760 = G__36774;
continue;
}
} else {
var temp__5823__auto___36776__$1 = cljs.core.seq(seq__35634_36757);
if(temp__5823__auto___36776__$1){
var seq__35634_36777__$1 = temp__5823__auto___36776__$1;
if(cljs.core.chunked_seq_QMARK_(seq__35634_36777__$1)){
var c__5525__auto___36779 = cljs.core.chunk_first(seq__35634_36777__$1);
var G__36782 = cljs.core.chunk_rest(seq__35634_36777__$1);
var G__36783 = c__5525__auto___36779;
var G__36784 = cljs.core.count(c__5525__auto___36779);
var G__36785 = (0);
seq__35634_36757 = G__36782;
chunk__35636_36758 = G__36783;
count__35637_36759 = G__36784;
i__35638_36760 = G__36785;
continue;
} else {
var child_36787 = cljs.core.first(seq__35634_36777__$1);
if(cljs.core.truth_(child_36787)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_36787);


var G__36791 = cljs.core.next(seq__35634_36777__$1);
var G__36792 = null;
var G__36794 = (0);
var G__36796 = (0);
seq__35634_36757 = G__36791;
chunk__35636_36758 = G__36792;
count__35637_36759 = G__36794;
i__35638_36760 = G__36796;
continue;
} else {
var G__36797 = cljs.core.next(seq__35634_36777__$1);
var G__36798 = null;
var G__36799 = (0);
var G__36800 = (0);
seq__35634_36757 = G__36797;
chunk__35636_36758 = G__36798;
count__35637_36759 = G__36799;
i__35638_36760 = G__36800;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_36755);
}


var G__36801 = cljs.core.next(seq__35589_36745__$1);
var G__36802 = null;
var G__36803 = (0);
var G__36804 = (0);
seq__35589_36684 = G__36801;
chunk__35590_36685 = G__36802;
count__35591_36686 = G__36803;
i__35592_36687 = G__36804;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__35646 = cljs.core.seq(node);
var chunk__35647 = null;
var count__35648 = (0);
var i__35649 = (0);
while(true){
if((i__35649 < count__35648)){
var n = chunk__35647.cljs$core$IIndexed$_nth$arity$2(null,i__35649);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__36818 = seq__35646;
var G__36819 = chunk__35647;
var G__36820 = count__35648;
var G__36821 = (i__35649 + (1));
seq__35646 = G__36818;
chunk__35647 = G__36819;
count__35648 = G__36820;
i__35649 = G__36821;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__35646);
if(temp__5823__auto__){
var seq__35646__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35646__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__35646__$1);
var G__36822 = cljs.core.chunk_rest(seq__35646__$1);
var G__36823 = c__5525__auto__;
var G__36824 = cljs.core.count(c__5525__auto__);
var G__36825 = (0);
seq__35646 = G__36822;
chunk__35647 = G__36823;
count__35648 = G__36824;
i__35649 = G__36825;
continue;
} else {
var n = cljs.core.first(seq__35646__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__36828 = cljs.core.next(seq__35646__$1);
var G__36829 = null;
var G__36830 = (0);
var G__36831 = (0);
seq__35646 = G__36828;
chunk__35647 = G__36829;
count__35648 = G__36830;
i__35649 = G__36831;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__35655 = arguments.length;
switch (G__35655) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__35660 = arguments.length;
switch (G__35660) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__35670 = arguments.length;
switch (G__35670) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___36876 = arguments.length;
var i__5727__auto___36877 = (0);
while(true){
if((i__5727__auto___36877 < len__5726__auto___36876)){
args__5732__auto__.push((arguments[i__5727__auto___36877]));

var G__36879 = (i__5727__auto___36877 + (1));
i__5727__auto___36877 = G__36879;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__35687_36883 = cljs.core.seq(nodes);
var chunk__35688_36884 = null;
var count__35689_36885 = (0);
var i__35690_36886 = (0);
while(true){
if((i__35690_36886 < count__35689_36885)){
var node_36890 = chunk__35688_36884.cljs$core$IIndexed$_nth$arity$2(null,i__35690_36886);
fragment.appendChild(shadow.dom._to_dom(node_36890));


var G__36891 = seq__35687_36883;
var G__36892 = chunk__35688_36884;
var G__36893 = count__35689_36885;
var G__36894 = (i__35690_36886 + (1));
seq__35687_36883 = G__36891;
chunk__35688_36884 = G__36892;
count__35689_36885 = G__36893;
i__35690_36886 = G__36894;
continue;
} else {
var temp__5823__auto___36895 = cljs.core.seq(seq__35687_36883);
if(temp__5823__auto___36895){
var seq__35687_36897__$1 = temp__5823__auto___36895;
if(cljs.core.chunked_seq_QMARK_(seq__35687_36897__$1)){
var c__5525__auto___36899 = cljs.core.chunk_first(seq__35687_36897__$1);
var G__36900 = cljs.core.chunk_rest(seq__35687_36897__$1);
var G__36901 = c__5525__auto___36899;
var G__36902 = cljs.core.count(c__5525__auto___36899);
var G__36903 = (0);
seq__35687_36883 = G__36900;
chunk__35688_36884 = G__36901;
count__35689_36885 = G__36902;
i__35690_36886 = G__36903;
continue;
} else {
var node_36904 = cljs.core.first(seq__35687_36897__$1);
fragment.appendChild(shadow.dom._to_dom(node_36904));


var G__36906 = cljs.core.next(seq__35687_36897__$1);
var G__36907 = null;
var G__36908 = (0);
var G__36909 = (0);
seq__35687_36883 = G__36906;
chunk__35688_36884 = G__36907;
count__35689_36885 = G__36908;
i__35690_36886 = G__36909;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq35679){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35679));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__35693_36911 = cljs.core.seq(scripts);
var chunk__35694_36912 = null;
var count__35695_36913 = (0);
var i__35696_36914 = (0);
while(true){
if((i__35696_36914 < count__35695_36913)){
var vec__35708_36915 = chunk__35694_36912.cljs$core$IIndexed$_nth$arity$2(null,i__35696_36914);
var script_tag_36916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35708_36915,(0),null);
var script_body_36917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35708_36915,(1),null);
eval(script_body_36917);


var G__36921 = seq__35693_36911;
var G__36922 = chunk__35694_36912;
var G__36923 = count__35695_36913;
var G__36924 = (i__35696_36914 + (1));
seq__35693_36911 = G__36921;
chunk__35694_36912 = G__36922;
count__35695_36913 = G__36923;
i__35696_36914 = G__36924;
continue;
} else {
var temp__5823__auto___36925 = cljs.core.seq(seq__35693_36911);
if(temp__5823__auto___36925){
var seq__35693_36927__$1 = temp__5823__auto___36925;
if(cljs.core.chunked_seq_QMARK_(seq__35693_36927__$1)){
var c__5525__auto___36928 = cljs.core.chunk_first(seq__35693_36927__$1);
var G__36930 = cljs.core.chunk_rest(seq__35693_36927__$1);
var G__36931 = c__5525__auto___36928;
var G__36932 = cljs.core.count(c__5525__auto___36928);
var G__36933 = (0);
seq__35693_36911 = G__36930;
chunk__35694_36912 = G__36931;
count__35695_36913 = G__36932;
i__35696_36914 = G__36933;
continue;
} else {
var vec__35713_36934 = cljs.core.first(seq__35693_36927__$1);
var script_tag_36935 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35713_36934,(0),null);
var script_body_36936 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35713_36934,(1),null);
eval(script_body_36936);


var G__36940 = cljs.core.next(seq__35693_36927__$1);
var G__36941 = null;
var G__36942 = (0);
var G__36943 = (0);
seq__35693_36911 = G__36940;
chunk__35694_36912 = G__36941;
count__35695_36913 = G__36942;
i__35696_36914 = G__36943;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__35717){
var vec__35718 = p__35717;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35718,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35718,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__35726 = arguments.length;
switch (G__35726) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__35729 = cljs.core.seq(style_keys);
var chunk__35730 = null;
var count__35731 = (0);
var i__35732 = (0);
while(true){
if((i__35732 < count__35731)){
var it = chunk__35730.cljs$core$IIndexed$_nth$arity$2(null,i__35732);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36981 = seq__35729;
var G__36982 = chunk__35730;
var G__36983 = count__35731;
var G__36984 = (i__35732 + (1));
seq__35729 = G__36981;
chunk__35730 = G__36982;
count__35731 = G__36983;
i__35732 = G__36984;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__35729);
if(temp__5823__auto__){
var seq__35729__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35729__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__35729__$1);
var G__36990 = cljs.core.chunk_rest(seq__35729__$1);
var G__36991 = c__5525__auto__;
var G__36992 = cljs.core.count(c__5525__auto__);
var G__36993 = (0);
seq__35729 = G__36990;
chunk__35730 = G__36991;
count__35731 = G__36992;
i__35732 = G__36993;
continue;
} else {
var it = cljs.core.first(seq__35729__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__36994 = cljs.core.next(seq__35729__$1);
var G__36995 = null;
var G__36996 = (0);
var G__36997 = (0);
seq__35729 = G__36994;
chunk__35730 = G__36995;
count__35731 = G__36996;
i__35732 = G__36997;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k35739,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__35759 = k35739;
var G__35759__$1 = (((G__35759 instanceof cljs.core.Keyword))?G__35759.fqn:null);
switch (G__35759__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35739,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__35761){
var vec__35763 = p__35761;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35763,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35763,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35738){
var self__ = this;
var G__35738__$1 = this;
return (new cljs.core.RecordIter((0),G__35738__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35740,other35741){
var self__ = this;
var this35740__$1 = this;
return (((!((other35741 == null)))) && ((((this35740__$1.constructor === other35741.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35740__$1.x,other35741.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35740__$1.y,other35741.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35740__$1.__extmap,other35741.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k35739){
var self__ = this;
var this__5307__auto____$1 = this;
var G__35786 = k35739;
var G__35786__$1 = (((G__35786 instanceof cljs.core.Keyword))?G__35786.fqn:null);
switch (G__35786__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35739);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__35738){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__35791 = cljs.core.keyword_identical_QMARK_;
var expr__35792 = k__5309__auto__;
if(cljs.core.truth_((pred__35791.cljs$core$IFn$_invoke$arity$2 ? pred__35791.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__35792) : pred__35791.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__35792)))){
return (new shadow.dom.Coordinate(G__35738,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35791.cljs$core$IFn$_invoke$arity$2 ? pred__35791.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__35792) : pred__35791.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__35792)))){
return (new shadow.dom.Coordinate(self__.x,G__35738,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__35738),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__35738){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__35738,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__35751){
var extmap__5342__auto__ = (function (){var G__35815 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35751,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__35751)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35815);
} else {
return G__35815;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__35751),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__35751),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k35817,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__35821 = k35817;
var G__35821__$1 = (((G__35821 instanceof cljs.core.Keyword))?G__35821.fqn:null);
switch (G__35821__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k35817,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__35831){
var vec__35832 = p__35831;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35832,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35832,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__35816){
var self__ = this;
var G__35816__$1 = this;
return (new cljs.core.RecordIter((0),G__35816__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this35818,other35819){
var self__ = this;
var this35818__$1 = this;
return (((!((other35819 == null)))) && ((((this35818__$1.constructor === other35819.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35818__$1.w,other35819.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35818__$1.h,other35819.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this35818__$1.__extmap,other35819.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k35817){
var self__ = this;
var this__5307__auto____$1 = this;
var G__35853 = k35817;
var G__35853__$1 = (((G__35853 instanceof cljs.core.Keyword))?G__35853.fqn:null);
switch (G__35853__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k35817);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__35816){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__35854 = cljs.core.keyword_identical_QMARK_;
var expr__35855 = k__5309__auto__;
if(cljs.core.truth_((pred__35854.cljs$core$IFn$_invoke$arity$2 ? pred__35854.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__35855) : pred__35854.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__35855)))){
return (new shadow.dom.Size(G__35816,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__35854.cljs$core$IFn$_invoke$arity$2 ? pred__35854.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__35855) : pred__35854.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__35855)))){
return (new shadow.dom.Size(self__.w,G__35816,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__35816),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__35816){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__35816,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__35820){
var extmap__5342__auto__ = (function (){var G__35863 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__35820,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__35820)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__35863);
} else {
return G__35863;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__35820),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__35820),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__37124 = (i + (1));
var G__37125 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__37124;
ret = G__37125;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__35882){
var vec__35883 = p__35882;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35883,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35883,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__35888 = arguments.length;
switch (G__35888) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5821__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5821__auto__)){
var child = temp__5821__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__37137 = ps;
var G__37138 = (i + (1));
el__$1 = G__37137;
i = G__37138;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__36021 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36021,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36021,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36021,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__36025_37145 = cljs.core.seq(props);
var chunk__36026_37146 = null;
var count__36027_37147 = (0);
var i__36028_37148 = (0);
while(true){
if((i__36028_37148 < count__36027_37147)){
var vec__36051_37149 = chunk__36026_37146.cljs$core$IIndexed$_nth$arity$2(null,i__36028_37148);
var k_37150 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36051_37149,(0),null);
var v_37151 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36051_37149,(1),null);
el.setAttributeNS((function (){var temp__5823__auto__ = cljs.core.namespace(k_37150);
if(cljs.core.truth_(temp__5823__auto__)){
var ns = temp__5823__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_37150),v_37151);


var G__37152 = seq__36025_37145;
var G__37153 = chunk__36026_37146;
var G__37154 = count__36027_37147;
var G__37155 = (i__36028_37148 + (1));
seq__36025_37145 = G__37152;
chunk__36026_37146 = G__37153;
count__36027_37147 = G__37154;
i__36028_37148 = G__37155;
continue;
} else {
var temp__5823__auto___37156 = cljs.core.seq(seq__36025_37145);
if(temp__5823__auto___37156){
var seq__36025_37157__$1 = temp__5823__auto___37156;
if(cljs.core.chunked_seq_QMARK_(seq__36025_37157__$1)){
var c__5525__auto___37159 = cljs.core.chunk_first(seq__36025_37157__$1);
var G__37160 = cljs.core.chunk_rest(seq__36025_37157__$1);
var G__37161 = c__5525__auto___37159;
var G__37162 = cljs.core.count(c__5525__auto___37159);
var G__37163 = (0);
seq__36025_37145 = G__37160;
chunk__36026_37146 = G__37161;
count__36027_37147 = G__37162;
i__36028_37148 = G__37163;
continue;
} else {
var vec__36060_37164 = cljs.core.first(seq__36025_37157__$1);
var k_37165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36060_37164,(0),null);
var v_37166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36060_37164,(1),null);
el.setAttributeNS((function (){var temp__5823__auto____$1 = cljs.core.namespace(k_37165);
if(cljs.core.truth_(temp__5823__auto____$1)){
var ns = temp__5823__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_37165),v_37166);


var G__37167 = cljs.core.next(seq__36025_37157__$1);
var G__37168 = null;
var G__37169 = (0);
var G__37170 = (0);
seq__36025_37145 = G__37167;
chunk__36026_37146 = G__37168;
count__36027_37147 = G__37169;
i__36028_37148 = G__37170;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__36081 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36081,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36081,(1),null);
var seq__36088_37172 = cljs.core.seq(node_children);
var chunk__36090_37173 = null;
var count__36091_37174 = (0);
var i__36092_37175 = (0);
while(true){
if((i__36092_37175 < count__36091_37174)){
var child_struct_37176 = chunk__36090_37173.cljs$core$IIndexed$_nth$arity$2(null,i__36092_37175);
if((!((child_struct_37176 == null)))){
if(typeof child_struct_37176 === 'string'){
var text_37178 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_37178),child_struct_37176].join(''));
} else {
var children_37179 = shadow.dom.svg_node(child_struct_37176);
if(cljs.core.seq_QMARK_(children_37179)){
var seq__36182_37180 = cljs.core.seq(children_37179);
var chunk__36185_37181 = null;
var count__36186_37182 = (0);
var i__36187_37183 = (0);
while(true){
if((i__36187_37183 < count__36186_37182)){
var child_37184 = chunk__36185_37181.cljs$core$IIndexed$_nth$arity$2(null,i__36187_37183);
if(cljs.core.truth_(child_37184)){
node.appendChild(child_37184);


var G__37185 = seq__36182_37180;
var G__37186 = chunk__36185_37181;
var G__37187 = count__36186_37182;
var G__37188 = (i__36187_37183 + (1));
seq__36182_37180 = G__37185;
chunk__36185_37181 = G__37186;
count__36186_37182 = G__37187;
i__36187_37183 = G__37188;
continue;
} else {
var G__37189 = seq__36182_37180;
var G__37190 = chunk__36185_37181;
var G__37191 = count__36186_37182;
var G__37192 = (i__36187_37183 + (1));
seq__36182_37180 = G__37189;
chunk__36185_37181 = G__37190;
count__36186_37182 = G__37191;
i__36187_37183 = G__37192;
continue;
}
} else {
var temp__5823__auto___37195 = cljs.core.seq(seq__36182_37180);
if(temp__5823__auto___37195){
var seq__36182_37196__$1 = temp__5823__auto___37195;
if(cljs.core.chunked_seq_QMARK_(seq__36182_37196__$1)){
var c__5525__auto___37198 = cljs.core.chunk_first(seq__36182_37196__$1);
var G__37199 = cljs.core.chunk_rest(seq__36182_37196__$1);
var G__37200 = c__5525__auto___37198;
var G__37201 = cljs.core.count(c__5525__auto___37198);
var G__37202 = (0);
seq__36182_37180 = G__37199;
chunk__36185_37181 = G__37200;
count__36186_37182 = G__37201;
i__36187_37183 = G__37202;
continue;
} else {
var child_37203 = cljs.core.first(seq__36182_37196__$1);
if(cljs.core.truth_(child_37203)){
node.appendChild(child_37203);


var G__37209 = cljs.core.next(seq__36182_37196__$1);
var G__37210 = null;
var G__37211 = (0);
var G__37212 = (0);
seq__36182_37180 = G__37209;
chunk__36185_37181 = G__37210;
count__36186_37182 = G__37211;
i__36187_37183 = G__37212;
continue;
} else {
var G__37214 = cljs.core.next(seq__36182_37196__$1);
var G__37215 = null;
var G__37216 = (0);
var G__37217 = (0);
seq__36182_37180 = G__37214;
chunk__36185_37181 = G__37215;
count__36186_37182 = G__37216;
i__36187_37183 = G__37217;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_37179);
}
}


var G__37219 = seq__36088_37172;
var G__37220 = chunk__36090_37173;
var G__37221 = count__36091_37174;
var G__37222 = (i__36092_37175 + (1));
seq__36088_37172 = G__37219;
chunk__36090_37173 = G__37220;
count__36091_37174 = G__37221;
i__36092_37175 = G__37222;
continue;
} else {
var G__37223 = seq__36088_37172;
var G__37224 = chunk__36090_37173;
var G__37225 = count__36091_37174;
var G__37226 = (i__36092_37175 + (1));
seq__36088_37172 = G__37223;
chunk__36090_37173 = G__37224;
count__36091_37174 = G__37225;
i__36092_37175 = G__37226;
continue;
}
} else {
var temp__5823__auto___37228 = cljs.core.seq(seq__36088_37172);
if(temp__5823__auto___37228){
var seq__36088_37229__$1 = temp__5823__auto___37228;
if(cljs.core.chunked_seq_QMARK_(seq__36088_37229__$1)){
var c__5525__auto___37230 = cljs.core.chunk_first(seq__36088_37229__$1);
var G__37231 = cljs.core.chunk_rest(seq__36088_37229__$1);
var G__37232 = c__5525__auto___37230;
var G__37233 = cljs.core.count(c__5525__auto___37230);
var G__37234 = (0);
seq__36088_37172 = G__37231;
chunk__36090_37173 = G__37232;
count__36091_37174 = G__37233;
i__36092_37175 = G__37234;
continue;
} else {
var child_struct_37235 = cljs.core.first(seq__36088_37229__$1);
if((!((child_struct_37235 == null)))){
if(typeof child_struct_37235 === 'string'){
var text_37236 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_37236),child_struct_37235].join(''));
} else {
var children_37237 = shadow.dom.svg_node(child_struct_37235);
if(cljs.core.seq_QMARK_(children_37237)){
var seq__36207_37238 = cljs.core.seq(children_37237);
var chunk__36209_37239 = null;
var count__36210_37240 = (0);
var i__36211_37241 = (0);
while(true){
if((i__36211_37241 < count__36210_37240)){
var child_37243 = chunk__36209_37239.cljs$core$IIndexed$_nth$arity$2(null,i__36211_37241);
if(cljs.core.truth_(child_37243)){
node.appendChild(child_37243);


var G__37245 = seq__36207_37238;
var G__37246 = chunk__36209_37239;
var G__37247 = count__36210_37240;
var G__37248 = (i__36211_37241 + (1));
seq__36207_37238 = G__37245;
chunk__36209_37239 = G__37246;
count__36210_37240 = G__37247;
i__36211_37241 = G__37248;
continue;
} else {
var G__37250 = seq__36207_37238;
var G__37251 = chunk__36209_37239;
var G__37252 = count__36210_37240;
var G__37253 = (i__36211_37241 + (1));
seq__36207_37238 = G__37250;
chunk__36209_37239 = G__37251;
count__36210_37240 = G__37252;
i__36211_37241 = G__37253;
continue;
}
} else {
var temp__5823__auto___37257__$1 = cljs.core.seq(seq__36207_37238);
if(temp__5823__auto___37257__$1){
var seq__36207_37258__$1 = temp__5823__auto___37257__$1;
if(cljs.core.chunked_seq_QMARK_(seq__36207_37258__$1)){
var c__5525__auto___37259 = cljs.core.chunk_first(seq__36207_37258__$1);
var G__37260 = cljs.core.chunk_rest(seq__36207_37258__$1);
var G__37261 = c__5525__auto___37259;
var G__37262 = cljs.core.count(c__5525__auto___37259);
var G__37263 = (0);
seq__36207_37238 = G__37260;
chunk__36209_37239 = G__37261;
count__36210_37240 = G__37262;
i__36211_37241 = G__37263;
continue;
} else {
var child_37264 = cljs.core.first(seq__36207_37258__$1);
if(cljs.core.truth_(child_37264)){
node.appendChild(child_37264);


var G__37265 = cljs.core.next(seq__36207_37258__$1);
var G__37266 = null;
var G__37267 = (0);
var G__37268 = (0);
seq__36207_37238 = G__37265;
chunk__36209_37239 = G__37266;
count__36210_37240 = G__37267;
i__36211_37241 = G__37268;
continue;
} else {
var G__37273 = cljs.core.next(seq__36207_37258__$1);
var G__37274 = null;
var G__37275 = (0);
var G__37276 = (0);
seq__36207_37238 = G__37273;
chunk__36209_37239 = G__37274;
count__36210_37240 = G__37275;
i__36211_37241 = G__37276;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_37237);
}
}


var G__37280 = cljs.core.next(seq__36088_37229__$1);
var G__37281 = null;
var G__37283 = (0);
var G__37284 = (0);
seq__36088_37172 = G__37280;
chunk__36090_37173 = G__37281;
count__36091_37174 = G__37283;
i__36092_37175 = G__37284;
continue;
} else {
var G__37289 = cljs.core.next(seq__36088_37229__$1);
var G__37290 = null;
var G__37291 = (0);
var G__37292 = (0);
seq__36088_37172 = G__37289;
chunk__36090_37173 = G__37290;
count__36091_37174 = G__37291;
i__36092_37175 = G__37292;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___37322 = arguments.length;
var i__5727__auto___37324 = (0);
while(true){
if((i__5727__auto___37324 < len__5726__auto___37322)){
args__5732__auto__.push((arguments[i__5727__auto___37324]));

var G__37330 = (i__5727__auto___37324 + (1));
i__5727__auto___37324 = G__37330;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq36234){
var G__36236 = cljs.core.first(seq36234);
var seq36234__$1 = cljs.core.next(seq36234);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__36236,seq36234__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
