goog.provide('dataspex.render_client');

/**
 * @interface
 */
dataspex.render_client.HostChannel = function(){};

var dataspex$render_client$HostChannel$connect$dyn_42830 = (function (host_channel,render_f){
var x__5350__auto__ = (((host_channel == null))?null:host_channel);
var m__5351__auto__ = (dataspex.render_client.connect[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(host_channel,render_f) : m__5351__auto__.call(null,host_channel,render_f));
} else {
var m__5349__auto__ = (dataspex.render_client.connect["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(host_channel,render_f) : m__5349__auto__.call(null,host_channel,render_f));
} else {
throw cljs.core.missing_protocol("HostChannel.connect",host_channel);
}
}
});
dataspex.render_client.connect = (function dataspex$render_client$connect(host_channel,render_f){
if((((!((host_channel == null)))) && ((!((host_channel.dataspex$render_client$HostChannel$connect$arity$2 == null)))))){
return host_channel.dataspex$render_client$HostChannel$connect$arity$2(host_channel,render_f);
} else {
return dataspex$render_client$HostChannel$connect$dyn_42830(host_channel,render_f);
}
});

var dataspex$render_client$HostChannel$disconnect$dyn_42839 = (function (host_channel){
var x__5350__auto__ = (((host_channel == null))?null:host_channel);
var m__5351__auto__ = (dataspex.render_client.disconnect[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(host_channel) : m__5351__auto__.call(null,host_channel));
} else {
var m__5349__auto__ = (dataspex.render_client.disconnect["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(host_channel) : m__5349__auto__.call(null,host_channel));
} else {
throw cljs.core.missing_protocol("HostChannel.disconnect",host_channel);
}
}
});
dataspex.render_client.disconnect = (function dataspex$render_client$disconnect(host_channel){
if((((!((host_channel == null)))) && ((!((host_channel.dataspex$render_client$HostChannel$disconnect$arity$1 == null)))))){
return host_channel.dataspex$render_client$HostChannel$disconnect$arity$1(host_channel);
} else {
return dataspex$render_client$HostChannel$disconnect$dyn_42839(host_channel);
}
});

var dataspex$render_client$HostChannel$process_actions$dyn_42841 = (function (host_channel,node,actions){
var x__5350__auto__ = (((host_channel == null))?null:host_channel);
var m__5351__auto__ = (dataspex.render_client.process_actions[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(host_channel,node,actions) : m__5351__auto__.call(null,host_channel,node,actions));
} else {
var m__5349__auto__ = (dataspex.render_client.process_actions["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(host_channel,node,actions) : m__5349__auto__.call(null,host_channel,node,actions));
} else {
throw cljs.core.missing_protocol("HostChannel.process-actions",host_channel);
}
}
});
dataspex.render_client.process_actions = (function dataspex$render_client$process_actions(host_channel,node,actions){
if((((!((host_channel == null)))) && ((!((host_channel.dataspex$render_client$HostChannel$process_actions$arity$3 == null)))))){
return host_channel.dataspex$render_client$HostChannel$process_actions$arity$3(host_channel,node,actions);
} else {
return dataspex$render_client$HostChannel$process_actions$dyn_42841(host_channel,node,actions);
}
});

dataspex.render_client.prefers_dark_mode_QMARK_ = (function dataspex$render_client$prefers_dark_mode_QMARK_(){
return window.matchMedia("(prefers-color-scheme: dark)").matches;
});
dataspex.render_client.get_preferred_theme = (function dataspex$render_client$get_preferred_theme(){
if(cljs.core.truth_(dataspex.render_client.prefers_dark_mode_QMARK_())){
return new cljs.core.Keyword(null,"dark","dark",1818973999);
} else {
return new cljs.core.Keyword(null,"light","light",1918998747);
}
});
dataspex.render_client.execute_effects = (function dataspex$render_client$execute_effects(effects){
var seq__42561 = cljs.core.seq(effects);
var chunk__42562 = null;
var count__42563 = (0);
var i__42564 = (0);
while(true){
if((i__42564 < count__42563)){
var vec__42631 = chunk__42562.cljs$core$IIndexed$_nth$arity$2(null,i__42564);
var seq__42632 = cljs.core.seq(vec__42631);
var first__42633 = cljs.core.first(seq__42632);
var seq__42632__$1 = cljs.core.next(seq__42632);
var effect = first__42633;
var args = seq__42632__$1;
var G__42634_42844 = effect;
var G__42634_42845__$1 = (((G__42634_42844 instanceof cljs.core.Keyword))?G__42634_42844.fqn:null);
switch (G__42634_42845__$1) {
case "effect/copy":
dataspex.actions.copy_to_clipboard(cljs.core.first(args));

break;
case "effect/inspect-in-devtools":
if(cljs.core.truth_((function (){var and__5000__auto__ = (typeof window !== 'undefined');
if(and__5000__auto__){
var and__5000__auto____$1 = window.chrome_devtools;
if(cljs.core.truth_(and__5000__auto____$1)){
return window.chrome_devtools.inspectedWindow;
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})())){
var seq__42640_42847 = cljs.core.seq(args);
var chunk__42641_42848 = null;
var count__42642_42849 = (0);
var i__42643_42850 = (0);
while(true){
if((i__42643_42850 < count__42642_42849)){
var id_42851 = chunk__42641_42848.cljs$core$IIndexed$_nth$arity$2(null,i__42643_42850);
window.chrome_devtools.inspectedWindow.eval(["inspect(window.__DATASPEX__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id_42851),")"].join(''),((function (seq__42640_42847,chunk__42641_42848,count__42642_42849,i__42643_42850,seq__42561,chunk__42562,count__42563,i__42564,id_42851,G__42634_42844,G__42634_42845__$1,vec__42631,seq__42632,first__42633,seq__42632__$1,effect,args){
return (function (){
return null;
});})(seq__42640_42847,chunk__42641_42848,count__42642_42849,i__42643_42850,seq__42561,chunk__42562,count__42563,i__42564,id_42851,G__42634_42844,G__42634_42845__$1,vec__42631,seq__42632,first__42633,seq__42632__$1,effect,args))
);


var G__42852 = seq__42640_42847;
var G__42853 = chunk__42641_42848;
var G__42854 = count__42642_42849;
var G__42855 = (i__42643_42850 + (1));
seq__42640_42847 = G__42852;
chunk__42641_42848 = G__42853;
count__42642_42849 = G__42854;
i__42643_42850 = G__42855;
continue;
} else {
var temp__5823__auto___42856 = cljs.core.seq(seq__42640_42847);
if(temp__5823__auto___42856){
var seq__42640_42857__$1 = temp__5823__auto___42856;
if(cljs.core.chunked_seq_QMARK_(seq__42640_42857__$1)){
var c__5525__auto___42858 = cljs.core.chunk_first(seq__42640_42857__$1);
var G__42859 = cljs.core.chunk_rest(seq__42640_42857__$1);
var G__42860 = c__5525__auto___42858;
var G__42861 = cljs.core.count(c__5525__auto___42858);
var G__42862 = (0);
seq__42640_42847 = G__42859;
chunk__42641_42848 = G__42860;
count__42642_42849 = G__42861;
i__42643_42850 = G__42862;
continue;
} else {
var id_42863 = cljs.core.first(seq__42640_42857__$1);
window.chrome_devtools.inspectedWindow.eval(["inspect(window.__DATASPEX__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id_42863),")"].join(''),((function (seq__42640_42847,chunk__42641_42848,count__42642_42849,i__42643_42850,seq__42561,chunk__42562,count__42563,i__42564,id_42863,seq__42640_42857__$1,temp__5823__auto___42856,G__42634_42844,G__42634_42845__$1,vec__42631,seq__42632,first__42633,seq__42632__$1,effect,args){
return (function (){
return null;
});})(seq__42640_42847,chunk__42641_42848,count__42642_42849,i__42643_42850,seq__42561,chunk__42562,count__42563,i__42564,id_42863,seq__42640_42857__$1,temp__5823__auto___42856,G__42634_42844,G__42634_42845__$1,vec__42631,seq__42632,first__42633,seq__42632__$1,effect,args))
);


var G__42864 = cljs.core.next(seq__42640_42857__$1);
var G__42865 = null;
var G__42866 = (0);
var G__42867 = (0);
seq__42640_42847 = G__42864;
chunk__42641_42848 = G__42865;
count__42642_42849 = G__42866;
i__42643_42850 = G__42867;
continue;
}
} else {
}
}
break;
}
} else {
}

break;
default:
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unrecognized effect",effect], 0));

}

cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([effect,args], 0));


var G__42868 = seq__42561;
var G__42869 = chunk__42562;
var G__42870 = count__42563;
var G__42871 = (i__42564 + (1));
seq__42561 = G__42868;
chunk__42562 = G__42869;
count__42563 = G__42870;
i__42564 = G__42871;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__42561);
if(temp__5823__auto__){
var seq__42561__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__42561__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__42561__$1);
var G__42872 = cljs.core.chunk_rest(seq__42561__$1);
var G__42873 = c__5525__auto__;
var G__42874 = cljs.core.count(c__5525__auto__);
var G__42875 = (0);
seq__42561 = G__42872;
chunk__42562 = G__42873;
count__42563 = G__42874;
i__42564 = G__42875;
continue;
} else {
var vec__42655 = cljs.core.first(seq__42561__$1);
var seq__42656 = cljs.core.seq(vec__42655);
var first__42657 = cljs.core.first(seq__42656);
var seq__42656__$1 = cljs.core.next(seq__42656);
var effect = first__42657;
var args = seq__42656__$1;
var G__42659_42876 = effect;
var G__42659_42877__$1 = (((G__42659_42876 instanceof cljs.core.Keyword))?G__42659_42876.fqn:null);
switch (G__42659_42877__$1) {
case "effect/copy":
dataspex.actions.copy_to_clipboard(cljs.core.first(args));

break;
case "effect/inspect-in-devtools":
if(cljs.core.truth_((function (){var and__5000__auto__ = (typeof window !== 'undefined');
if(and__5000__auto__){
var and__5000__auto____$1 = window.chrome_devtools;
if(cljs.core.truth_(and__5000__auto____$1)){
return window.chrome_devtools.inspectedWindow;
} else {
return and__5000__auto____$1;
}
} else {
return and__5000__auto__;
}
})())){
var seq__42668_42879 = cljs.core.seq(args);
var chunk__42669_42880 = null;
var count__42670_42881 = (0);
var i__42671_42882 = (0);
while(true){
if((i__42671_42882 < count__42670_42881)){
var id_42883 = chunk__42669_42880.cljs$core$IIndexed$_nth$arity$2(null,i__42671_42882);
window.chrome_devtools.inspectedWindow.eval(["inspect(window.__DATASPEX__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id_42883),")"].join(''),((function (seq__42668_42879,chunk__42669_42880,count__42670_42881,i__42671_42882,seq__42561,chunk__42562,count__42563,i__42564,id_42883,G__42659_42876,G__42659_42877__$1,vec__42655,seq__42656,first__42657,seq__42656__$1,effect,args,seq__42561__$1,temp__5823__auto__){
return (function (){
return null;
});})(seq__42668_42879,chunk__42669_42880,count__42670_42881,i__42671_42882,seq__42561,chunk__42562,count__42563,i__42564,id_42883,G__42659_42876,G__42659_42877__$1,vec__42655,seq__42656,first__42657,seq__42656__$1,effect,args,seq__42561__$1,temp__5823__auto__))
);


var G__42884 = seq__42668_42879;
var G__42885 = chunk__42669_42880;
var G__42886 = count__42670_42881;
var G__42887 = (i__42671_42882 + (1));
seq__42668_42879 = G__42884;
chunk__42669_42880 = G__42885;
count__42670_42881 = G__42886;
i__42671_42882 = G__42887;
continue;
} else {
var temp__5823__auto___42888__$1 = cljs.core.seq(seq__42668_42879);
if(temp__5823__auto___42888__$1){
var seq__42668_42889__$1 = temp__5823__auto___42888__$1;
if(cljs.core.chunked_seq_QMARK_(seq__42668_42889__$1)){
var c__5525__auto___42890 = cljs.core.chunk_first(seq__42668_42889__$1);
var G__42891 = cljs.core.chunk_rest(seq__42668_42889__$1);
var G__42892 = c__5525__auto___42890;
var G__42893 = cljs.core.count(c__5525__auto___42890);
var G__42894 = (0);
seq__42668_42879 = G__42891;
chunk__42669_42880 = G__42892;
count__42670_42881 = G__42893;
i__42671_42882 = G__42894;
continue;
} else {
var id_42895 = cljs.core.first(seq__42668_42889__$1);
window.chrome_devtools.inspectedWindow.eval(["inspect(window.__DATASPEX__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(id_42895),")"].join(''),((function (seq__42668_42879,chunk__42669_42880,count__42670_42881,i__42671_42882,seq__42561,chunk__42562,count__42563,i__42564,id_42895,seq__42668_42889__$1,temp__5823__auto___42888__$1,G__42659_42876,G__42659_42877__$1,vec__42655,seq__42656,first__42657,seq__42656__$1,effect,args,seq__42561__$1,temp__5823__auto__){
return (function (){
return null;
});})(seq__42668_42879,chunk__42669_42880,count__42670_42881,i__42671_42882,seq__42561,chunk__42562,count__42563,i__42564,id_42895,seq__42668_42889__$1,temp__5823__auto___42888__$1,G__42659_42876,G__42659_42877__$1,vec__42655,seq__42656,first__42657,seq__42656__$1,effect,args,seq__42561__$1,temp__5823__auto__))
);


var G__42896 = cljs.core.next(seq__42668_42889__$1);
var G__42897 = null;
var G__42898 = (0);
var G__42899 = (0);
seq__42668_42879 = G__42896;
chunk__42669_42880 = G__42897;
count__42670_42881 = G__42898;
i__42671_42882 = G__42899;
continue;
}
} else {
}
}
break;
}
} else {
}

break;
default:
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unrecognized effect",effect], 0));

}

cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([effect,args], 0));


var G__42900 = cljs.core.next(seq__42561__$1);
var G__42901 = null;
var G__42902 = (0);
var G__42903 = (0);
seq__42561 = G__42900;
chunk__42562 = G__42901;
count__42563 = G__42902;
i__42564 = G__42903;
continue;
}
} else {
return null;
}
}
break;
}
});
dataspex.render_client.get_form_data = (function dataspex$render_client$get_form_data(form){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,el){
var k = (function (){var G__42683 = el;
var G__42683__$1 = (((G__42683 == null))?null:G__42683.name);
var G__42683__$2 = (((G__42683__$1 == null))?null:cljs.core.not_empty(G__42683__$1));
if((G__42683__$2 == null)){
return null;
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(G__42683__$2);
}
})();
var G__42684 = res;
if(cljs.core.truth_(k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__42684,k,el.value);
} else {
return G__42684;
}
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(form.elements));
});
dataspex.render_client.interpolate = (function dataspex$render_client$interpolate(event,actions){
return clojure.walk.postwalk((function (x){
var G__42690 = x;
var G__42690__$1 = (((G__42690 instanceof cljs.core.Keyword))?G__42690.fqn:null);
switch (G__42690__$1) {
case "event.target/value":
var G__42691 = event;
var G__42691__$1 = (((G__42691 == null))?null:G__42691.target);
if((G__42691__$1 == null)){
return null;
} else {
return G__42691__$1.value;
}

break;
case "event/form-data":
var G__42698 = event;
var G__42698__$1 = (((G__42698 == null))?null:G__42698.target);
if((G__42698__$1 == null)){
return null;
} else {
return dataspex.render_client.get_form_data(G__42698__$1);
}

break;
default:
return x;

}
}),actions);
});
dataspex.render_client.set_dispatch_BANG_ = (function dataspex$render_client$set_dispatch_BANG_(store,handle_remotes_actions){
return replicant.dom.set_dispatch_BANG_((function (p__42700,actions){
var map__42701 = p__42700;
var map__42701__$1 = cljs.core.__destructure_map(map__42701);
var dom_event = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42701__$1,new cljs.core.Keyword("replicant","dom-event","replicant/dom-event",-1613182512));
var node = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42701__$1,new cljs.core.Keyword("replicant","node","replicant/node",1306451380));
dom_event.preventDefault();

dom_event.stopPropagation();

var channel = node.closest("[data-channel]").getAttribute("data-channel");
var actions__$1 = dataspex.render_client.interpolate(dom_event,actions);
var seq__42702_42910 = cljs.core.seq(actions__$1);
var chunk__42703_42911 = null;
var count__42704_42912 = (0);
var i__42705_42913 = (0);
while(true){
if((i__42705_42913 < count__42704_42912)){
var action_42914 = chunk__42703_42911.cljs$core$IIndexed$_nth$arity$2(null,i__42705_42913);
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.prn,channel,action_42914);


var G__42915 = seq__42702_42910;
var G__42916 = chunk__42703_42911;
var G__42917 = count__42704_42912;
var G__42918 = (i__42705_42913 + (1));
seq__42702_42910 = G__42915;
chunk__42703_42911 = G__42916;
count__42704_42912 = G__42917;
i__42705_42913 = G__42918;
continue;
} else {
var temp__5823__auto___42919 = cljs.core.seq(seq__42702_42910);
if(temp__5823__auto___42919){
var seq__42702_42920__$1 = temp__5823__auto___42919;
if(cljs.core.chunked_seq_QMARK_(seq__42702_42920__$1)){
var c__5525__auto___42921 = cljs.core.chunk_first(seq__42702_42920__$1);
var G__42922 = cljs.core.chunk_rest(seq__42702_42920__$1);
var G__42923 = c__5525__auto___42921;
var G__42924 = cljs.core.count(c__5525__auto___42921);
var G__42925 = (0);
seq__42702_42910 = G__42922;
chunk__42703_42911 = G__42923;
count__42704_42912 = G__42924;
i__42705_42913 = G__42925;
continue;
} else {
var action_42926 = cljs.core.first(seq__42702_42920__$1);
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.prn,channel,action_42926);


var G__42927 = cljs.core.next(seq__42702_42920__$1);
var G__42928 = null;
var G__42929 = (0);
var G__42930 = (0);
seq__42702_42910 = G__42927;
chunk__42703_42911 = G__42928;
count__42704_42912 = G__42929;
i__42705_42913 = G__42930;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("dataspex-remotes",channel)){
return (handle_remotes_actions.cljs$core$IFn$_invoke$arity$1 ? handle_remotes_actions.cljs$core$IFn$_invoke$arity$1(actions__$1) : handle_remotes_actions.call(null,actions__$1));
} else {
return dataspex.render_client.process_actions(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"channels","channels",1132759174).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(store)),channel),node,actions__$1).then(dataspex.render_client.execute_effects);
}
}));
});
dataspex.render_client.ensure_element = (function dataspex$render_client$ensure_element(var_args){
var args__5732__auto__ = [];
var len__5726__auto___42931 = arguments.length;
var i__5727__auto___42932 = (0);
while(true){
if((i__5727__auto___42932 < len__5726__auto___42931)){
args__5732__auto__.push((arguments[i__5727__auto___42932]));

var G__42933 = (i__5727__auto___42932 + (1));
i__5727__auto___42932 = G__42933;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((2) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((2)),(0),null)):null);
return dataspex.render_client.ensure_element.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__5733__auto__);
});

(dataspex.render_client.ensure_element.cljs$core$IFn$_invoke$arity$variadic = (function (root,channel_id,p__42731){
var vec__42732 = p__42731;
var map__42735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42732,(0),null);
var map__42735__$1 = cljs.core.__destructure_map(map__42735);
var error_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42735__$1,new cljs.core.Keyword(null,"error?","error?",-460689159));
var id = ["el-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.hash(channel_id))].join('');
var el_id = [id,(cljs.core.truth_(error_QMARK_)?"-error":null)].join('');
var temp__5821__auto__ = document.getElementById(el_id);
if(cljs.core.truth_(temp__5821__auto__)){
var el = temp__5821__auto__;
return el;
} else {
var el = document.createElement("div");
(el.id = el_id);

if(cljs.core.truth_(error_QMARK_)){
el.setAttribute("data-error","error");
} else {
el.setAttribute("data-channel",channel_id);
}

if(cljs.core.truth_(error_QMARK_)){
root.appendChild(el);
} else {
var temp__5821__auto___42935__$1 = root.querySelector("[data-error]");
if(cljs.core.truth_(temp__5821__auto___42935__$1)){
var anchor_42936 = temp__5821__auto___42935__$1;
anchor_42936.insertAdjacentElement("beforebegin",el);
} else {
root.appendChild(el);
}
}

return el;
}
}));

(dataspex.render_client.ensure_element.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(dataspex.render_client.ensure_element.cljs$lang$applyTo = (function (seq42724){
var G__42725 = cljs.core.first(seq42724);
var seq42724__$1 = cljs.core.next(seq42724);
var G__42726 = cljs.core.first(seq42724__$1);
var seq42724__$2 = cljs.core.next(seq42724__$1);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42725,G__42726,seq42724__$2);
}));

dataspex.render_client.render_splash = (function dataspex$render_client$render_splash(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dataspex.ui","card-list#dataspex.code","dataspex.ui/card-list#dataspex.code",-1282841866),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [dataspex.ui.card_body,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"Well, it ain't much to look at - yet. ","You can fix that by telling Dataspex to inspect something:"], null),dataspex.hiccup.render_source(cljs.core.list(new cljs.core.Symbol(null,"require","require",1172530194,null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dataspex.core","dataspex.core",1972024858,null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"dataspex","dataspex",1862680110,null)], null)),cljs.core.PersistentArrayMap.EMPTY),dataspex.hiccup.render_source(cljs.core.list(new cljs.core.Symbol("dataspex","inspect","dataspex/inspect",495433114,null),"App state",new cljs.core.Symbol(null,"my-data","my-data",-646191248,null)),cljs.core.PersistentArrayMap.EMPTY),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"Dataspex can inspect pretty much anything you can throw at it: maps,\n     vectors and lists, atoms, Datascript and Datomic databases, and anything\n     that implements Clojure's Datafy. You can also implement Dataspex' own\n     protocols to create custom data browsers. Have fun!"], null)], null)], null);
});
dataspex.render_client.mount_splash = (function dataspex$render_client$mount_splash(root){
return replicant.dom.render(dataspex.render_client.ensure_element(root,"dataspex-splash"),dataspex.render_client.render_splash());
});
dataspex.render_client.render = (function dataspex$render_client$render(var_args){
var args__5732__auto__ = [];
var len__5726__auto___42942 = arguments.length;
var i__5727__auto___42943 = (0);
while(true){
if((i__5727__auto___42943 < len__5726__auto___42942)){
args__5732__auto__.push((arguments[i__5727__auto___42943]));

var G__42944 = (i__5727__auto___42943 + (1));
i__5727__auto___42943 = G__42944;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return dataspex.render_client.render.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(dataspex.render_client.render.cljs$core$IFn$_invoke$arity$variadic = (function (el,id,hiccup,p__42756){
var vec__42757 = p__42756;
var opt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42757,(0),null);
if(cljs.core.truth_(hiccup)){
var temp__5823__auto___42945 = dataspex.render_client.ensure_element(el,"dataspex-splash");
if(cljs.core.truth_(temp__5823__auto___42945)){
var splash_42946 = temp__5823__auto___42945;
replicant.dom.unmount(splash_42946);
} else {
}
} else {
}

replicant.dom.render(dataspex.render_client.ensure_element.cljs$core$IFn$_invoke$arity$variadic(el,cljs.core.name(id),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opt], 0)),hiccup);

if(cljs.core.truth_(hiccup)){
return null;
} else {
if(cljs.core.every_QMARK_((function (p1__42740_SHARP_){
return cljs.core.empty_QMARK_(p1__42740_SHARP_.innerHTML);
}),cljs.core.filterv(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [(1),null], null), null),(function (p1__42739_SHARP_){
return p1__42739_SHARP_.nodeType;
})),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,el.childNodes)))){
return dataspex.render_client.mount_splash(el);
} else {
return null;
}
}
}));

(dataspex.render_client.render.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(dataspex.render_client.render.cljs$lang$applyTo = (function (seq42741){
var G__42742 = cljs.core.first(seq42741);
var seq42741__$1 = cljs.core.next(seq42741);
var G__42743 = cljs.core.first(seq42741__$1);
var seq42741__$2 = cljs.core.next(seq42741__$1);
var G__42744 = cljs.core.first(seq42741__$2);
var seq42741__$3 = cljs.core.next(seq42741__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__42742,G__42743,G__42744,seq42741__$3);
}));

dataspex.render_client.set_theme_BANG_ = (function dataspex$render_client$set_theme_BANG_(theme){
return document.documentElement.setAttribute("data-theme",cljs.core.name(theme));
});
dataspex.render_client.add_channel = (function dataspex$render_client$add_channel(store,id,channel){
var map__42774 = cljs.core.deref(store);
var map__42774__$1 = cljs.core.__destructure_map(map__42774);
var root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42774__$1,new cljs.core.Keyword(null,"root","root",-448657453));
var el = dataspex.render_client.ensure_element(root,id);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(store,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"channels","channels",1132759174),id], null),channel);

dataspex.render_client.connect(channel,(function() { 
var G__42947__delegate = function (hiccup,p__42775){
var vec__42776 = p__42775;
var opt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42776,(0),null);
return dataspex.render_client.render.cljs$core$IFn$_invoke$arity$variadic(root,id,hiccup,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opt], 0));
};
var G__42947 = function (hiccup,var_args){
var p__42775 = null;
if (arguments.length > 1) {
var G__42948__i = 0, G__42948__a = new Array(arguments.length -  1);
while (G__42948__i < G__42948__a.length) {G__42948__a[G__42948__i] = arguments[G__42948__i + 1]; ++G__42948__i;}
  p__42775 = new cljs.core.IndexedSeq(G__42948__a,0,null);
} 
return G__42947__delegate.call(this,hiccup,p__42775);};
G__42947.cljs$lang$maxFixedArity = 1;
G__42947.cljs$lang$applyTo = (function (arglist__42949){
var hiccup = cljs.core.first(arglist__42949);
var p__42775 = cljs.core.rest(arglist__42949);
return G__42947__delegate(hiccup,p__42775);
});
G__42947.cljs$core$IFn$_invoke$arity$variadic = G__42947__delegate;
return G__42947;
})()
);

return dataspex.render_client.process_actions(channel,el,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dataspex.actions","assoc-in","dataspex.actions/assoc-in",-674227967),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-window-size","client-window-size",2134116614)], null),window.innerWidth], null)], null));
});
dataspex.render_client.remove_channel = (function dataspex$render_client$remove_channel(store,id){
var el = dataspex.render_client.ensure_element(new cljs.core.Keyword(null,"root","root",-448657453).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(store)),id);
var channel = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(store),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"channels","channels",1132759174),id], null));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(store,cljs.core.update,new cljs.core.Keyword(null,"channels","channels",1132759174),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([id], 0));

if(cljs.core.truth_(el)){
el.parentNode.removeChild(el);
} else {
}

if(cljs.core.truth_(channel)){
return dataspex.render_client.disconnect(channel);
} else {
return null;
}
});
dataspex.render_client.set_window_size = (function dataspex$render_client$set_window_size(store,root){
var w = window.innerWidth;
var seq__42779 = cljs.core.seq(new cljs.core.Keyword(null,"channels","channels",1132759174).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(store)));
var chunk__42780 = null;
var count__42781 = (0);
var i__42782 = (0);
while(true){
if((i__42782 < count__42781)){
var vec__42797 = chunk__42780.cljs$core$IIndexed$_nth$arity$2(null,i__42782);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42797,(0),null);
var channel = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42797,(1),null);
dataspex.render_client.process_actions(channel,dataspex.render_client.ensure_element(root,id),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dataspex.actions","assoc-in","dataspex.actions/assoc-in",-674227967),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-window-size","client-window-size",2134116614)], null),w], null)], null));


var G__42950 = seq__42779;
var G__42951 = chunk__42780;
var G__42952 = count__42781;
var G__42953 = (i__42782 + (1));
seq__42779 = G__42950;
chunk__42780 = G__42951;
count__42781 = G__42952;
i__42782 = G__42953;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__42779);
if(temp__5823__auto__){
var seq__42779__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__42779__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__42779__$1);
var G__42954 = cljs.core.chunk_rest(seq__42779__$1);
var G__42955 = c__5525__auto__;
var G__42956 = cljs.core.count(c__5525__auto__);
var G__42957 = (0);
seq__42779 = G__42954;
chunk__42780 = G__42955;
count__42781 = G__42956;
i__42782 = G__42957;
continue;
} else {
var vec__42802 = cljs.core.first(seq__42779__$1);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42802,(0),null);
var channel = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42802,(1),null);
dataspex.render_client.process_actions(channel,dataspex.render_client.ensure_element(root,id),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dataspex.actions","assoc-in","dataspex.actions/assoc-in",-674227967),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-window-size","client-window-size",2134116614)], null),w], null)], null));


var G__42958 = cljs.core.next(seq__42779__$1);
var G__42959 = null;
var G__42960 = (0);
var G__42961 = (0);
seq__42779 = G__42958;
chunk__42780 = G__42959;
count__42781 = G__42960;
i__42782 = G__42961;
continue;
}
} else {
return null;
}
}
break;
}
});
dataspex.render_client.set_window_size_debounced = goog.functions.debounce(dataspex.render_client.set_window_size,(100));
dataspex.render_client.init_el = (function dataspex$render_client$init_el(root){
root.classList.add("inspector");

return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"panels-el","panels-el",-1941731369),dataspex.render_client.ensure_element(root,"dataspex-panels")], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"remotes-el","remotes-el",-1767477683),dataspex.render_client.ensure_element(root,"dataspex-remotes")], null)], null));
});
dataspex.render_client.start_render_client = (function dataspex$render_client$start_render_client(root,p__42809){
var map__42810 = p__42809;
var map__42810__$1 = cljs.core.__destructure_map(map__42810);
var handle_remotes_actions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42810__$1,new cljs.core.Keyword(null,"handle-remotes-actions","handle-remotes-actions",1745680369));
var render_remotes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42810__$1,new cljs.core.Keyword(null,"render-remotes","render-remotes",1109529878));
var map__42811 = dataspex.render_client.init_el(root);
var map__42811__$1 = cljs.core.__destructure_map(map__42811);
var panels_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42811__$1,new cljs.core.Keyword(null,"panels-el","panels-el",-1941731369));
var remotes_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42811__$1,new cljs.core.Keyword(null,"remotes-el","remotes-el",-1767477683));
var store = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root","root",-448657453),panels_el,new cljs.core.Keyword(null,"channels","channels",1132759174),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"remotes","remotes",1132366312),cljs.core.PersistentArrayMap.EMPTY], null));
dataspex.render_client.set_theme_BANG_(dataspex.render_client.get_preferred_theme());

dataspex.render_client.mount_splash(panels_el);

dataspex.render_client.set_dispatch_BANG_(store,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(handle_remotes_actions,store,panels_el));

(window.onresize = (function (){
return (dataspex.render_client.set_window_size_debounced.cljs$core$IFn$_invoke$arity$2 ? dataspex.render_client.set_window_size_debounced.cljs$core$IFn$_invoke$arity$2(store,root) : dataspex.render_client.set_window_size_debounced.call(null,store,root));
}));

cljs.core.add_watch(store,new cljs.core.Keyword("dataspex.render-client","render-remotes","dataspex.render-client/render-remotes",607705708),(function (_,___$1,___$2,state){
return replicant.dom.render(remotes_el,(render_remotes.cljs$core$IFn$_invoke$arity$1 ? render_remotes.cljs$core$IFn$_invoke$arity$1(state) : render_remotes.call(null,state)));
}));

return store;
});

//# sourceMappingURL=dataspex.render_client.js.map
