goog.provide('dataspex.remote_host');
dataspex.remote_host.connect_event_source = (function dataspex$remote_host$connect_event_source(remote_host,host_id,process_actions){
var event_source = (new EventSource([cljs.core.str.cljs$core$IFn$_invoke$arity$1(remote_host),"/relay/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(host_id),"/actions"].join('')));
var attempts = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((3));
event_source.addEventListener("message",(function (e){
cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Remote host actions",e.data], 0));

var G__45077 = dataspex.codec.parse_string(e.data);
return (process_actions.cljs$core$IFn$_invoke$arity$1 ? process_actions.cljs$core$IFn$_invoke$arity$1(G__45077) : process_actions.call(null,G__45077));
}));

return event_source.addEventListener("error",(function (_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),cljs.core.deref(attempts))){
event_source.close();

return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Dataspex couldn't reach the server on ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(remote_host)," after three attempts, giving up. Refresh page to inspect remotely."].join('')], 0));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(attempts,cljs.core.dec);
}
}));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {dataspex.render_host.ClientChannel}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
dataspex.remote_host.RemoteHost = (function (_BANG_connected_QMARK_,remote_host,host_id,__meta,__extmap,__hash){
this._BANG_connected_QMARK_ = _BANG_connected_QMARK_;
this.remote_host = remote_host;
this.host_id = host_id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(dataspex.remote_host.RemoteHost.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k45081,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__45097 = k45081;
var G__45097__$1 = (((G__45097 instanceof cljs.core.Keyword))?G__45097.fqn:null);
switch (G__45097__$1) {
case "!connected?":
return self__._BANG_connected_QMARK_;

break;
case "remote-host":
return self__.remote_host;

break;
case "host-id":
return self__.host_id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k45081,else__5303__auto__);

}
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__45099){
var vec__45100 = p__45099;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45100,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45100,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#dataspex.remote-host.RemoteHost{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"!connected?","!connected?",-782800804),self__._BANG_connected_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"remote-host","remote-host",1390051238),self__.remote_host],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"host-id","host-id",742376279),self__.host_id],null))], null),self__.__extmap));
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__45080){
var self__ = this;
var G__45080__$1 = this;
return (new cljs.core.RecordIter((0),G__45080__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"!connected?","!connected?",-782800804),new cljs.core.Keyword(null,"remote-host","remote-host",1390051238),new cljs.core.Keyword(null,"host-id","host-id",742376279)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new dataspex.remote_host.RemoteHost(self__._BANG_connected_QMARK_,self__.remote_host,self__.host_id,self__.__meta,self__.__extmap,self__.__hash));
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (962472087 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this45082,other45083){
var self__ = this;
var this45082__$1 = this;
return (((!((other45083 == null)))) && ((((this45082__$1.constructor === other45083.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this45082__$1._BANG_connected_QMARK_,other45083._BANG_connected_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this45082__$1.remote_host,other45083.remote_host)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this45082__$1.host_id,other45083.host_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this45082__$1.__extmap,other45083.__extmap)))))))))));
}));

(dataspex.remote_host.RemoteHost.prototype.dataspex$render_host$ClientChannel$ = cljs.core.PROTOCOL_SENTINEL);

(dataspex.remote_host.RemoteHost.prototype.dataspex$render_host$ClientChannel$initialize_BANG_$arity$3 = (function (_,___$1,process_actions){
var self__ = this;
var ___$2 = this;
return dataspex.remote_host.connect_event_source(self__.remote_host,self__.host_id,process_actions);
}));

(dataspex.remote_host.RemoteHost.prototype.dataspex$render_host$ClientChannel$render$arity$2 = (function (_,hiccup){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(cljs.core.deref(self__._BANG_connected_QMARK_))){
return fetch([cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.remote_host),"/relay/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.host_id),"/renders"].join(''),({"method": "POST", "body": dataspex.codec.generate_string(hiccup)})).catch((function (___$2){
return cljs.core.reset_BANG_(self__._BANG_connected_QMARK_,false);
}));
} else {
return null;
}
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"remote-host","remote-host",1390051238),null,new cljs.core.Keyword(null,"host-id","host-id",742376279),null,new cljs.core.Keyword(null,"!connected?","!connected?",-782800804),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new dataspex.remote_host.RemoteHost(self__._BANG_connected_QMARK_,self__.remote_host,self__.host_id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k45081){
var self__ = this;
var this__5307__auto____$1 = this;
var G__45124 = k45081;
var G__45124__$1 = (((G__45124 instanceof cljs.core.Keyword))?G__45124.fqn:null);
switch (G__45124__$1) {
case "!connected?":
case "remote-host":
case "host-id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k45081);

}
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__45080){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__45128 = cljs.core.keyword_identical_QMARK_;
var expr__45129 = k__5309__auto__;
if(cljs.core.truth_((pred__45128.cljs$core$IFn$_invoke$arity$2 ? pred__45128.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"!connected?","!connected?",-782800804),expr__45129) : pred__45128.call(null,new cljs.core.Keyword(null,"!connected?","!connected?",-782800804),expr__45129)))){
return (new dataspex.remote_host.RemoteHost(G__45080,self__.remote_host,self__.host_id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__45128.cljs$core$IFn$_invoke$arity$2 ? pred__45128.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"remote-host","remote-host",1390051238),expr__45129) : pred__45128.call(null,new cljs.core.Keyword(null,"remote-host","remote-host",1390051238),expr__45129)))){
return (new dataspex.remote_host.RemoteHost(self__._BANG_connected_QMARK_,G__45080,self__.host_id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__45128.cljs$core$IFn$_invoke$arity$2 ? pred__45128.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"host-id","host-id",742376279),expr__45129) : pred__45128.call(null,new cljs.core.Keyword(null,"host-id","host-id",742376279),expr__45129)))){
return (new dataspex.remote_host.RemoteHost(self__._BANG_connected_QMARK_,self__.remote_host,G__45080,self__.__meta,self__.__extmap,null));
} else {
return (new dataspex.remote_host.RemoteHost(self__._BANG_connected_QMARK_,self__.remote_host,self__.host_id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__45080),null));
}
}
}
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"!connected?","!connected?",-782800804),self__._BANG_connected_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"remote-host","remote-host",1390051238),self__.remote_host,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"host-id","host-id",742376279),self__.host_id,null))], null),self__.__extmap));
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__45080){
var self__ = this;
var this__5299__auto____$1 = this;
return (new dataspex.remote_host.RemoteHost(self__._BANG_connected_QMARK_,self__.remote_host,self__.host_id,G__45080,self__.__extmap,self__.__hash));
}));

(dataspex.remote_host.RemoteHost.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(dataspex.remote_host.RemoteHost.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"!connected?","!connected?",857730723,null),new cljs.core.Symbol(null,"remote-host","remote-host",-1264384531,null),new cljs.core.Symbol(null,"host-id","host-id",-1912059490,null)], null);
}));

(dataspex.remote_host.RemoteHost.cljs$lang$type = true);

(dataspex.remote_host.RemoteHost.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"dataspex.remote-host/RemoteHost",null,(1),null));
}));

(dataspex.remote_host.RemoteHost.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"dataspex.remote-host/RemoteHost");
}));

/**
 * Positional factory function for dataspex.remote-host/RemoteHost.
 */
dataspex.remote_host.__GT_RemoteHost = (function dataspex$remote_host$__GT_RemoteHost(_BANG_connected_QMARK_,remote_host,host_id){
return (new dataspex.remote_host.RemoteHost(_BANG_connected_QMARK_,remote_host,host_id,null,null,null));
});

/**
 * Factory function for dataspex.remote-host/RemoteHost, taking a map of keywords to field values.
 */
dataspex.remote_host.map__GT_RemoteHost = (function dataspex$remote_host$map__GT_RemoteHost(G__45089){
var extmap__5342__auto__ = (function (){var G__45143 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__45089,new cljs.core.Keyword(null,"!connected?","!connected?",-782800804),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"remote-host","remote-host",1390051238),new cljs.core.Keyword(null,"host-id","host-id",742376279)], 0));
if(cljs.core.record_QMARK_(G__45089)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__45143);
} else {
return G__45143;
}
})();
return (new dataspex.remote_host.RemoteHost(new cljs.core.Keyword(null,"!connected?","!connected?",-782800804).cljs$core$IFn$_invoke$arity$1(G__45089),new cljs.core.Keyword(null,"remote-host","remote-host",1390051238).cljs$core$IFn$_invoke$arity$1(G__45089),new cljs.core.Keyword(null,"host-id","host-id",742376279).cljs$core$IFn$_invoke$arity$1(G__45089),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

dataspex.remote_host.get_host_id = (function dataspex$remote_host$get_host_id(){
if((typeof navigator !== 'undefined')){
return cljs.core.hash([cljs.core.str.cljs$core$IFn$_invoke$arity$1(navigator.userAgent),cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.origin)].join(''));
} else {
if((typeof process !== 'undefined')){
return cljs.core.hash(process.cwd);
} else {
return null;
}
}
});
dataspex.remote_host.create_channel = (function dataspex$remote_host$create_channel(remote_host){
return dataspex.remote_host.__GT_RemoteHost(cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true),remote_host,dataspex.remote_host.get_host_id());
});

//# sourceMappingURL=dataspex.remote_host.js.map
