goog.provide('dataspex.tap_inspector');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {dataspex.protocols.IRenderInline}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
dataspex.tap_inspector.TapKey = (function (idx,tapped_at,__meta,__extmap,__hash){
this.idx = idx;
this.tapped_at = tapped_at;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(dataspex.tap_inspector.TapKey.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5301__auto__,null);
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k49505,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__49523 = k49505;
var G__49523__$1 = (((G__49523 instanceof cljs.core.Keyword))?G__49523.fqn:null);
switch (G__49523__$1) {
case "idx":
return self__.idx;

break;
case "tapped-at":
return self__.tapped_at;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49505,else__5303__auto__);

}
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__49525){
var vec__49526 = p__49525;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49526,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49526,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null,ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#dataspex.tap-inspector.TapKey{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"idx","idx",1053688473),self__.idx],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054),self__.tapped_at],null))], null),self__.__extmap));
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49504){
var self__ = this;
var G__49504__$1 = this;
return (new cljs.core.RecordIter((0),G__49504__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"idx","idx",1053688473),new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new dataspex.tap_inspector.TapKey(self__.idx,self__.tapped_at,self__.__meta,self__.__extmap,self__.__hash));
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (600783954 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49508,other49509){
var self__ = this;
var this49508__$1 = this;
return (((!((other49509 == null)))) && ((((this49508__$1.constructor === other49509.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49508__$1.idx,other49509.idx)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49508__$1.tapped_at,other49509.tapped_at)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49508__$1.__extmap,other49509.__extmap)))))))));
}));

(dataspex.tap_inspector.TapKey.prototype.dataspex$protocols$IRenderInline$ = cljs.core.PROTOCOL_SENTINEL);

(dataspex.tap_inspector.TapKey.prototype.dataspex$protocols$IRenderInline$render_inline$arity$2 = (function (_,___$1){
var self__ = this;
var ___$2 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dataspex.ui","code","dataspex.ui/code",-778251490),dataspex.time.hh_COLON_mm_COLON_ss(self__.tapped_at)], null);
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054),null,new cljs.core.Keyword(null,"idx","idx",1053688473),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new dataspex.tap_inspector.TapKey(self__.idx,self__.tapped_at,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k49505){
var self__ = this;
var this__5307__auto____$1 = this;
var G__49577 = k49505;
var G__49577__$1 = (((G__49577 instanceof cljs.core.Keyword))?G__49577.fqn:null);
switch (G__49577__$1) {
case "idx":
case "tapped-at":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k49505);

}
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__49504){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__49586 = cljs.core.keyword_identical_QMARK_;
var expr__49587 = k__5309__auto__;
if(cljs.core.truth_((pred__49586.cljs$core$IFn$_invoke$arity$2 ? pred__49586.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"idx","idx",1053688473),expr__49587) : pred__49586.call(null,new cljs.core.Keyword(null,"idx","idx",1053688473),expr__49587)))){
return (new dataspex.tap_inspector.TapKey(G__49504,self__.tapped_at,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49586.cljs$core$IFn$_invoke$arity$2 ? pred__49586.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054),expr__49587) : pred__49586.call(null,new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054),expr__49587)))){
return (new dataspex.tap_inspector.TapKey(self__.idx,G__49504,self__.__meta,self__.__extmap,null));
} else {
return (new dataspex.tap_inspector.TapKey(self__.idx,self__.tapped_at,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__49504),null));
}
}
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"idx","idx",1053688473),self__.idx,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054),self__.tapped_at,null))], null),self__.__extmap));
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__49504){
var self__ = this;
var this__5299__auto____$1 = this;
return (new dataspex.tap_inspector.TapKey(self__.idx,self__.tapped_at,G__49504,self__.__extmap,self__.__hash));
}));

(dataspex.tap_inspector.TapKey.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(dataspex.tap_inspector.TapKey.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"idx","idx",-1600747296,null),new cljs.core.Symbol(null,"tapped-at","tapped-at",-1625673715,null)], null);
}));

(dataspex.tap_inspector.TapKey.cljs$lang$type = true);

(dataspex.tap_inspector.TapKey.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"dataspex.tap-inspector/TapKey",null,(1),null));
}));

(dataspex.tap_inspector.TapKey.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"dataspex.tap-inspector/TapKey");
}));

/**
 * Positional factory function for dataspex.tap-inspector/TapKey.
 */
dataspex.tap_inspector.__GT_TapKey = (function dataspex$tap_inspector$__GT_TapKey(idx,tapped_at){
return (new dataspex.tap_inspector.TapKey(idx,tapped_at,null,null,null));
});

/**
 * Factory function for dataspex.tap-inspector/TapKey, taking a map of keywords to field values.
 */
dataspex.tap_inspector.map__GT_TapKey = (function dataspex$tap_inspector$map__GT_TapKey(G__49517){
var extmap__5342__auto__ = (function (){var G__49595 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49517,new cljs.core.Keyword(null,"idx","idx",1053688473),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054)], 0));
if(cljs.core.record_QMARK_(G__49517)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49595);
} else {
return G__49595;
}
})();
return (new dataspex.tap_inspector.TapKey(new cljs.core.Keyword(null,"idx","idx",1053688473).cljs$core$IFn$_invoke$arity$1(G__49517),new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054).cljs$core$IFn$_invoke$arity$1(G__49517),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

dataspex.tap_inspector.get_taps = (function dataspex$tap_inspector$get_taps(taps){
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,p__49604){
var map__49605 = p__49604;
var map__49605__$1 = cljs.core.__destructure_map(map__49605);
var tapped_at = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49605__$1,new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49605__$1,new cljs.core.Keyword(null,"value","value",305978217));
var k = dataspex.tap_inspector.__GT_TapKey(idx,tapped_at);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1718410804),k,new cljs.core.Keyword(null,"k","k",-2146297393),k,new cljs.core.Keyword(null,"v","v",21465059),value], null);
}),taps);
});
dataspex.tap_inspector.nav_in_taps = (function dataspex$tap_inspector$nav_in_taps(taps,p__49608){
var vec__49609 = p__49608;
var seq__49610 = cljs.core.seq(vec__49609);
var first__49611 = cljs.core.first(seq__49610);
var seq__49610__$1 = cljs.core.next(seq__49610);
var k = first__49611;
var ks = seq__49610__$1;
var idx = (((k instanceof dataspex.tap_inspector.TapKey))?k.idx:k);
return dataspex.data.nav_in(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(taps,idx)),ks);
});

/**
* @constructor
 * @implements {dataspex.protocols.IRenderDictionary}
 * @implements {dataspex.protocols.Watchable}
 * @implements {dataspex.protocols.INavigatable}
*/
dataspex.tap_inspector.TapInspector = (function (store,inspector_opts){
this.store = store;
this.inspector_opts = inspector_opts;
});
(dataspex.tap_inspector.TapInspector.prototype.dataspex$protocols$INavigatable$ = cljs.core.PROTOCOL_SENTINEL);

(dataspex.tap_inspector.TapInspector.prototype.dataspex$protocols$INavigatable$nav_in$arity$2 = (function (_,path){
var self__ = this;
var ___$1 = this;
return dataspex.tap_inspector.nav_in_taps(cljs.core.deref(self__.store),path);
}));

(dataspex.tap_inspector.TapInspector.prototype.dataspex$protocols$IRenderDictionary$ = cljs.core.PROTOCOL_SENTINEL);

(dataspex.tap_inspector.TapInspector.prototype.dataspex$protocols$IRenderDictionary$render_dictionary$arity$2 = (function (_,opt){
var self__ = this;
var ___$1 = this;
return dataspex.hiccup.render_entries_dictionary(cljs.core.deref(self__.store),opt,dataspex.tap_inspector.get_taps(cljs.core.deref(self__.store)));
}));

(dataspex.tap_inspector.TapInspector.prototype.dataspex$protocols$Watchable$ = cljs.core.PROTOCOL_SENTINEL);

(dataspex.tap_inspector.TapInspector.prototype.dataspex$protocols$Watchable$get_val$arity$1 = (function (self){
var self__ = this;
var self__$1 = this;
return self__$1;
}));

(dataspex.tap_inspector.TapInspector.prototype.dataspex$protocols$Watchable$watch$arity$3 = (function (self,k,f){
var self__ = this;
var self__$1 = this;
cljs.core.add_watch(self__.store,k,(function (_,___$1,___$2,___$3){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(null,self__$1,null) : f.call(null,null,self__$1,null));
}));

var tapper = (function (x){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.store,(function (p1__49613_SHARP_){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"history-limit","history-limit",-1938739786).cljs$core$IFn$_invoke$arity$1(self__.inspector_opts),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__49613_SHARP_,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tapped-at","tapped-at",1028762054),dataspex.time.now(),new cljs.core.Keyword(null,"value","value",305978217),x], null)));
}));
});
cljs.core.add_tap(tapper);

return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"k","k",-2146297393),k,new cljs.core.Keyword(null,"tapper","tapper",570805764),tapper], null);
}));

(dataspex.tap_inspector.TapInspector.prototype.dataspex$protocols$Watchable$unwatch$arity$2 = (function (_,subscription){
var self__ = this;
var ___$1 = this;
cljs.core.remove_watch(self__.store,new cljs.core.Keyword(null,"k","k",-2146297393).cljs$core$IFn$_invoke$arity$1(subscription));

return cljs.core.remove_tap(new cljs.core.Keyword(null,"tapper","tapper",570805764).cljs$core$IFn$_invoke$arity$1(subscription));
}));

(dataspex.tap_inspector.TapInspector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"store","store",-1142205747,null),new cljs.core.Symbol(null,"inspector-opts","inspector-opts",1860208004,null)], null);
}));

(dataspex.tap_inspector.TapInspector.cljs$lang$type = true);

(dataspex.tap_inspector.TapInspector.cljs$lang$ctorStr = "dataspex.tap-inspector/TapInspector");

(dataspex.tap_inspector.TapInspector.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"dataspex.tap-inspector/TapInspector");
}));

/**
 * Positional factory function for dataspex.tap-inspector/TapInspector.
 */
dataspex.tap_inspector.__GT_TapInspector = (function dataspex$tap_inspector$__GT_TapInspector(store,inspector_opts){
return (new dataspex.tap_inspector.TapInspector(store,inspector_opts));
});

dataspex.tap_inspector.create_inspector = (function dataspex$tap_inspector$create_inspector(var_args){
var args__5732__auto__ = [];
var len__5726__auto___49694 = arguments.length;
var i__5727__auto___49699 = (0);
while(true){
if((i__5727__auto___49699 < len__5726__auto___49694)){
args__5732__auto__.push((arguments[i__5727__auto___49699]));

var G__49700 = (i__5727__auto___49699 + (1));
i__5727__auto___49699 = G__49700;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return dataspex.tap_inspector.create_inspector.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(dataspex.tap_inspector.create_inspector.cljs$core$IFn$_invoke$arity$variadic = (function (p__49639){
var vec__49640 = p__49639;
var map__49643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49640,(0),null);
var map__49643__$1 = cljs.core.__destructure_map(map__49643);
var history_limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49643__$1,new cljs.core.Keyword(null,"history-limit","history-limit",-1938739786));
return dataspex.tap_inspector.__GT_TapInspector(cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.List.EMPTY),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"history-limit","history-limit",-1938739786),(function (){var or__5002__auto__ = history_limit;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return (100);
}
})()], null));
}));

(dataspex.tap_inspector.create_inspector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(dataspex.tap_inspector.create_inspector.cljs$lang$applyTo = (function (seq49637){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49637));
}));


//# sourceMappingURL=dataspex.tap_inspector.js.map
