goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35891 = (function (f,blockable,meta35892){
this.f = f;
this.blockable = blockable;
this.meta35892 = meta35892;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35891.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35893,meta35892__$1){
var self__ = this;
var _35893__$1 = this;
return (new cljs.core.async.t_cljs$core$async35891(self__.f,self__.blockable,meta35892__$1));
}));

(cljs.core.async.t_cljs$core$async35891.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35893){
var self__ = this;
var _35893__$1 = this;
return self__.meta35892;
}));

(cljs.core.async.t_cljs$core$async35891.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35891.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async35891.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async35891.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async35891.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta35892","meta35892",-420144418,null)], null);
}));

(cljs.core.async.t_cljs$core$async35891.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35891.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35891");

(cljs.core.async.t_cljs$core$async35891.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async35891");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35891.
 */
cljs.core.async.__GT_t_cljs$core$async35891 = (function cljs$core$async$__GT_t_cljs$core$async35891(f,blockable,meta35892){
return (new cljs.core.async.t_cljs$core$async35891(f,blockable,meta35892));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__35886 = arguments.length;
switch (G__35886) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async35891(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__35903 = arguments.length;
switch (G__35903) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__35911 = arguments.length;
switch (G__35911) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__35924 = arguments.length;
switch (G__35924) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_39530 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_39530) : fn1.call(null,val_39530));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_39530) : fn1.call(null,val_39530));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__35937 = arguments.length;
switch (G__35937) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5821__auto__)){
var ret = temp__5821__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5821__auto__)){
var retb = temp__5821__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___39603 = n;
var x_39604 = (0);
while(true){
if((x_39604 < n__5593__auto___39603)){
(a[x_39604] = x_39604);

var G__39605 = (x_39604 + (1));
x_39604 = G__39605;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35947 = (function (flag,meta35948){
this.flag = flag;
this.meta35948 = meta35948;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35947.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35949,meta35948__$1){
var self__ = this;
var _35949__$1 = this;
return (new cljs.core.async.t_cljs$core$async35947(self__.flag,meta35948__$1));
}));

(cljs.core.async.t_cljs$core$async35947.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35949){
var self__ = this;
var _35949__$1 = this;
return self__.meta35948;
}));

(cljs.core.async.t_cljs$core$async35947.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35947.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async35947.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async35947.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async35947.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta35948","meta35948",-1066010703,null)], null);
}));

(cljs.core.async.t_cljs$core$async35947.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35947.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35947");

(cljs.core.async.t_cljs$core$async35947.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async35947");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35947.
 */
cljs.core.async.__GT_t_cljs$core$async35947 = (function cljs$core$async$__GT_t_cljs$core$async35947(flag,meta35948){
return (new cljs.core.async.t_cljs$core$async35947(flag,meta35948));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async35947(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async35955 = (function (flag,cb,meta35956){
this.flag = flag;
this.cb = cb;
this.meta35956 = meta35956;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async35955.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_35957,meta35956__$1){
var self__ = this;
var _35957__$1 = this;
return (new cljs.core.async.t_cljs$core$async35955(self__.flag,self__.cb,meta35956__$1));
}));

(cljs.core.async.t_cljs$core$async35955.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_35957){
var self__ = this;
var _35957__$1 = this;
return self__.meta35956;
}));

(cljs.core.async.t_cljs$core$async35955.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async35955.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async35955.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async35955.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async35955.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta35956","meta35956",1774704415,null)], null);
}));

(cljs.core.async.t_cljs$core$async35955.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async35955.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async35955");

(cljs.core.async.t_cljs$core$async35955.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async35955");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async35955.
 */
cljs.core.async.__GT_t_cljs$core$async35955 = (function cljs$core$async$__GT_t_cljs$core$async35955(flag,cb,meta35956){
return (new cljs.core.async.t_cljs$core$async35955(flag,cb,meta35956));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async35955(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__35968_SHARP_){
var G__35981 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35968_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__35981) : fret.call(null,G__35981));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__35969_SHARP_){
var G__35982 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35969_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__35982) : fret.call(null,G__35982));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__39630 = (i + (1));
i = G__39630;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5823__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5823__auto__)){
var got = temp__5823__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___39636 = arguments.length;
var i__5727__auto___39637 = (0);
while(true){
if((i__5727__auto___39637 < len__5726__auto___39636)){
args__5732__auto__.push((arguments[i__5727__auto___39637]));

var G__39638 = (i__5727__auto___39637 + (1));
i__5727__auto___39637 = G__39638;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__36009){
var map__36010 = p__36009;
var map__36010__$1 = cljs.core.__destructure_map(map__36010);
var opts = map__36010__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq35987){
var G__35988 = cljs.core.first(seq35987);
var seq35987__$1 = cljs.core.next(seq35987);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__35988,seq35987__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__36018 = arguments.length;
switch (G__36018) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__28228__auto___39640 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_36318){
var state_val_36319 = (state_36318[(1)]);
if((state_val_36319 === (7))){
var inst_36304 = (state_36318[(2)]);
var state_36318__$1 = state_36318;
var statearr_36328_39641 = state_36318__$1;
(statearr_36328_39641[(2)] = inst_36304);

(statearr_36328_39641[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (1))){
var state_36318__$1 = state_36318;
var statearr_36329_39642 = state_36318__$1;
(statearr_36329_39642[(2)] = null);

(statearr_36329_39642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (4))){
var inst_36254 = (state_36318[(7)]);
var inst_36254__$1 = (state_36318[(2)]);
var inst_36267 = (inst_36254__$1 == null);
var state_36318__$1 = (function (){var statearr_36346 = state_36318;
(statearr_36346[(7)] = inst_36254__$1);

return statearr_36346;
})();
if(cljs.core.truth_(inst_36267)){
var statearr_36347_39647 = state_36318__$1;
(statearr_36347_39647[(1)] = (5));

} else {
var statearr_36348_39648 = state_36318__$1;
(statearr_36348_39648[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (13))){
var state_36318__$1 = state_36318;
var statearr_36354_39649 = state_36318__$1;
(statearr_36354_39649[(2)] = null);

(statearr_36354_39649[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (6))){
var inst_36254 = (state_36318[(7)]);
var state_36318__$1 = state_36318;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36318__$1,(11),to,inst_36254);
} else {
if((state_val_36319 === (3))){
var inst_36316 = (state_36318[(2)]);
var state_36318__$1 = state_36318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36318__$1,inst_36316);
} else {
if((state_val_36319 === (12))){
var state_36318__$1 = state_36318;
var statearr_36363_39650 = state_36318__$1;
(statearr_36363_39650[(2)] = null);

(statearr_36363_39650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (2))){
var state_36318__$1 = state_36318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36318__$1,(4),from);
} else {
if((state_val_36319 === (11))){
var inst_36291 = (state_36318[(2)]);
var state_36318__$1 = state_36318;
if(cljs.core.truth_(inst_36291)){
var statearr_36365_39651 = state_36318__$1;
(statearr_36365_39651[(1)] = (12));

} else {
var statearr_36366_39652 = state_36318__$1;
(statearr_36366_39652[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (9))){
var state_36318__$1 = state_36318;
var statearr_36371_39653 = state_36318__$1;
(statearr_36371_39653[(2)] = null);

(statearr_36371_39653[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (5))){
var state_36318__$1 = state_36318;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36373_39654 = state_36318__$1;
(statearr_36373_39654[(1)] = (8));

} else {
var statearr_36374_39655 = state_36318__$1;
(statearr_36374_39655[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (14))){
var inst_36301 = (state_36318[(2)]);
var state_36318__$1 = state_36318;
var statearr_36379_39656 = state_36318__$1;
(statearr_36379_39656[(2)] = inst_36301);

(statearr_36379_39656[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (10))){
var inst_36287 = (state_36318[(2)]);
var state_36318__$1 = state_36318;
var statearr_36383_39661 = state_36318__$1;
(statearr_36383_39661[(2)] = inst_36287);

(statearr_36383_39661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36319 === (8))){
var inst_36272 = cljs.core.async.close_BANG_(to);
var state_36318__$1 = state_36318;
var statearr_36390_39665 = state_36318__$1;
(statearr_36390_39665[(2)] = inst_36272);

(statearr_36390_39665[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_36397 = [null,null,null,null,null,null,null,null];
(statearr_36397[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_36397[(1)] = (1));

return statearr_36397;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_36318){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_36318);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e36398){var ex__28052__auto__ = e36398;
var statearr_36399_39669 = state_36318;
(statearr_36399_39669[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_36318[(4)]))){
var statearr_36400_39670 = state_36318;
(statearr_36400_39670[(1)] = cljs.core.first((state_36318[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39671 = state_36318;
state_36318 = G__39671;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_36318){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_36318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_36402 = f__28229__auto__();
(statearr_36402[(6)] = c__28228__auto___39640);

return statearr_36402;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__36407){
var vec__36408 = p__36407;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36408,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36408,(1),null);
var job = vec__36408;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__28228__auto___39672 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_36415){
var state_val_36416 = (state_36415[(1)]);
if((state_val_36416 === (1))){
var state_36415__$1 = state_36415;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36415__$1,(2),res,v);
} else {
if((state_val_36416 === (2))){
var inst_36412 = (state_36415[(2)]);
var inst_36413 = cljs.core.async.close_BANG_(res);
var state_36415__$1 = (function (){var statearr_36418 = state_36415;
(statearr_36418[(7)] = inst_36412);

return statearr_36418;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_36415__$1,inst_36413);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0 = (function (){
var statearr_36420 = [null,null,null,null,null,null,null,null];
(statearr_36420[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__);

(statearr_36420[(1)] = (1));

return statearr_36420;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1 = (function (state_36415){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_36415);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e36425){var ex__28052__auto__ = e36425;
var statearr_36426_39676 = state_36415;
(statearr_36426_39676[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_36415[(4)]))){
var statearr_36427_39677 = state_36415;
(statearr_36427_39677[(1)] = cljs.core.first((state_36415[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39681 = state_36415;
state_36415 = G__39681;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = function(state_36415){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1.call(this,state_36415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_36430 = f__28229__auto__();
(statearr_36430[(6)] = c__28228__auto___39672);

return statearr_36430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__36431){
var vec__36436 = p__36431;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36436,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36436,(1),null);
var job = vec__36436;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___39687 = n;
var __39688 = (0);
while(true){
if((__39688 < n__5593__auto___39687)){
var G__36449_39689 = type;
var G__36449_39690__$1 = (((G__36449_39689 instanceof cljs.core.Keyword))?G__36449_39689.fqn:null);
switch (G__36449_39690__$1) {
case "compute":
var c__28228__auto___39692 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__39688,c__28228__auto___39692,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async){
return (function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = ((function (__39688,c__28228__auto___39692,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async){
return (function (state_36476){
var state_val_36477 = (state_36476[(1)]);
if((state_val_36477 === (1))){
var state_36476__$1 = state_36476;
var statearr_36487_39693 = state_36476__$1;
(statearr_36487_39693[(2)] = null);

(statearr_36487_39693[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36477 === (2))){
var state_36476__$1 = state_36476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36476__$1,(4),jobs);
} else {
if((state_val_36477 === (3))){
var inst_36474 = (state_36476[(2)]);
var state_36476__$1 = state_36476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36476__$1,inst_36474);
} else {
if((state_val_36477 === (4))){
var inst_36459 = (state_36476[(2)]);
var inst_36467 = process__$1(inst_36459);
var state_36476__$1 = state_36476;
if(cljs.core.truth_(inst_36467)){
var statearr_36493_39694 = state_36476__$1;
(statearr_36493_39694[(1)] = (5));

} else {
var statearr_36495_39695 = state_36476__$1;
(statearr_36495_39695[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36477 === (5))){
var state_36476__$1 = state_36476;
var statearr_36496_39696 = state_36476__$1;
(statearr_36496_39696[(2)] = null);

(statearr_36496_39696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36477 === (6))){
var state_36476__$1 = state_36476;
var statearr_36497_39697 = state_36476__$1;
(statearr_36497_39697[(2)] = null);

(statearr_36497_39697[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36477 === (7))){
var inst_36472 = (state_36476[(2)]);
var state_36476__$1 = state_36476;
var statearr_36499_39698 = state_36476__$1;
(statearr_36499_39698[(2)] = inst_36472);

(statearr_36499_39698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__39688,c__28228__auto___39692,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async))
;
return ((function (__39688,switch__28048__auto__,c__28228__auto___39692,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0 = (function (){
var statearr_36500 = [null,null,null,null,null,null,null];
(statearr_36500[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__);

(statearr_36500[(1)] = (1));

return statearr_36500;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1 = (function (state_36476){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_36476);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e36501){var ex__28052__auto__ = e36501;
var statearr_36502_39699 = state_36476;
(statearr_36502_39699[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_36476[(4)]))){
var statearr_36503_39704 = state_36476;
(statearr_36503_39704[(1)] = cljs.core.first((state_36476[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39705 = state_36476;
state_36476 = G__39705;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = function(state_36476){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1.call(this,state_36476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__;
})()
;})(__39688,switch__28048__auto__,c__28228__auto___39692,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async))
})();
var state__28230__auto__ = (function (){var statearr_36504 = f__28229__auto__();
(statearr_36504[(6)] = c__28228__auto___39692);

return statearr_36504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
});})(__39688,c__28228__auto___39692,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async))
);


break;
case "async":
var c__28228__auto___39713 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__39688,c__28228__auto___39713,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async){
return (function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = ((function (__39688,c__28228__auto___39713,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async){
return (function (state_36527){
var state_val_36532 = (state_36527[(1)]);
if((state_val_36532 === (1))){
var state_36527__$1 = state_36527;
var statearr_36533_39718 = state_36527__$1;
(statearr_36533_39718[(2)] = null);

(statearr_36533_39718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36532 === (2))){
var state_36527__$1 = state_36527;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36527__$1,(4),jobs);
} else {
if((state_val_36532 === (3))){
var inst_36525 = (state_36527[(2)]);
var state_36527__$1 = state_36527;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36527__$1,inst_36525);
} else {
if((state_val_36532 === (4))){
var inst_36513 = (state_36527[(2)]);
var inst_36514 = async(inst_36513);
var state_36527__$1 = state_36527;
if(cljs.core.truth_(inst_36514)){
var statearr_36534_39720 = state_36527__$1;
(statearr_36534_39720[(1)] = (5));

} else {
var statearr_36535_39721 = state_36527__$1;
(statearr_36535_39721[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36532 === (5))){
var state_36527__$1 = state_36527;
var statearr_36540_39722 = state_36527__$1;
(statearr_36540_39722[(2)] = null);

(statearr_36540_39722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36532 === (6))){
var state_36527__$1 = state_36527;
var statearr_36551_39723 = state_36527__$1;
(statearr_36551_39723[(2)] = null);

(statearr_36551_39723[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36532 === (7))){
var inst_36523 = (state_36527[(2)]);
var state_36527__$1 = state_36527;
var statearr_36560_39724 = state_36527__$1;
(statearr_36560_39724[(2)] = inst_36523);

(statearr_36560_39724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__39688,c__28228__auto___39713,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async))
;
return ((function (__39688,switch__28048__auto__,c__28228__auto___39713,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0 = (function (){
var statearr_36565 = [null,null,null,null,null,null,null];
(statearr_36565[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__);

(statearr_36565[(1)] = (1));

return statearr_36565;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1 = (function (state_36527){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_36527);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e36567){var ex__28052__auto__ = e36567;
var statearr_36568_39725 = state_36527;
(statearr_36568_39725[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_36527[(4)]))){
var statearr_36573_39727 = state_36527;
(statearr_36573_39727[(1)] = cljs.core.first((state_36527[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39730 = state_36527;
state_36527 = G__39730;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = function(state_36527){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1.call(this,state_36527);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__;
})()
;})(__39688,switch__28048__auto__,c__28228__auto___39713,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async))
})();
var state__28230__auto__ = (function (){var statearr_36576 = f__28229__auto__();
(statearr_36576[(6)] = c__28228__auto___39713);

return statearr_36576;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
});})(__39688,c__28228__auto___39713,G__36449_39689,G__36449_39690__$1,n__5593__auto___39687,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36449_39690__$1)].join('')));

}

var G__39737 = (__39688 + (1));
__39688 = G__39737;
continue;
} else {
}
break;
}

var c__28228__auto___39738 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_36604){
var state_val_36605 = (state_36604[(1)]);
if((state_val_36605 === (7))){
var inst_36597 = (state_36604[(2)]);
var state_36604__$1 = state_36604;
var statearr_36612_39740 = state_36604__$1;
(statearr_36612_39740[(2)] = inst_36597);

(statearr_36612_39740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36605 === (1))){
var state_36604__$1 = state_36604;
var statearr_36614_39742 = state_36604__$1;
(statearr_36614_39742[(2)] = null);

(statearr_36614_39742[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36605 === (4))){
var inst_36581 = (state_36604[(7)]);
var inst_36581__$1 = (state_36604[(2)]);
var inst_36583 = (inst_36581__$1 == null);
var state_36604__$1 = (function (){var statearr_36615 = state_36604;
(statearr_36615[(7)] = inst_36581__$1);

return statearr_36615;
})();
if(cljs.core.truth_(inst_36583)){
var statearr_36616_39743 = state_36604__$1;
(statearr_36616_39743[(1)] = (5));

} else {
var statearr_36617_39744 = state_36604__$1;
(statearr_36617_39744[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36605 === (6))){
var inst_36581 = (state_36604[(7)]);
var inst_36587 = (state_36604[(8)]);
var inst_36587__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_36588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36589 = [inst_36581,inst_36587__$1];
var inst_36590 = (new cljs.core.PersistentVector(null,2,(5),inst_36588,inst_36589,null));
var state_36604__$1 = (function (){var statearr_36619 = state_36604;
(statearr_36619[(8)] = inst_36587__$1);

return statearr_36619;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36604__$1,(8),jobs,inst_36590);
} else {
if((state_val_36605 === (3))){
var inst_36599 = (state_36604[(2)]);
var state_36604__$1 = state_36604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36604__$1,inst_36599);
} else {
if((state_val_36605 === (2))){
var state_36604__$1 = state_36604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36604__$1,(4),from);
} else {
if((state_val_36605 === (9))){
var inst_36594 = (state_36604[(2)]);
var state_36604__$1 = (function (){var statearr_36621 = state_36604;
(statearr_36621[(9)] = inst_36594);

return statearr_36621;
})();
var statearr_36624_39749 = state_36604__$1;
(statearr_36624_39749[(2)] = null);

(statearr_36624_39749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36605 === (5))){
var inst_36585 = cljs.core.async.close_BANG_(jobs);
var state_36604__$1 = state_36604;
var statearr_36628_39753 = state_36604__$1;
(statearr_36628_39753[(2)] = inst_36585);

(statearr_36628_39753[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36605 === (8))){
var inst_36587 = (state_36604[(8)]);
var inst_36592 = (state_36604[(2)]);
var state_36604__$1 = (function (){var statearr_36630 = state_36604;
(statearr_36630[(10)] = inst_36592);

return statearr_36630;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36604__$1,(9),results,inst_36587);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0 = (function (){
var statearr_36632 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36632[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__);

(statearr_36632[(1)] = (1));

return statearr_36632;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1 = (function (state_36604){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_36604);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e36633){var ex__28052__auto__ = e36633;
var statearr_36634_39758 = state_36604;
(statearr_36634_39758[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_36604[(4)]))){
var statearr_36635_39760 = state_36604;
(statearr_36635_39760[(1)] = cljs.core.first((state_36604[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39761 = state_36604;
state_36604 = G__39761;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = function(state_36604){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1.call(this,state_36604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_36637 = f__28229__auto__();
(statearr_36637[(6)] = c__28228__auto___39738);

return statearr_36637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


var c__28228__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_36677){
var state_val_36678 = (state_36677[(1)]);
if((state_val_36678 === (7))){
var inst_36673 = (state_36677[(2)]);
var state_36677__$1 = state_36677;
var statearr_36680_39764 = state_36677__$1;
(statearr_36680_39764[(2)] = inst_36673);

(statearr_36680_39764[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (20))){
var state_36677__$1 = state_36677;
var statearr_36681_39765 = state_36677__$1;
(statearr_36681_39765[(2)] = null);

(statearr_36681_39765[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (1))){
var state_36677__$1 = state_36677;
var statearr_36683_39767 = state_36677__$1;
(statearr_36683_39767[(2)] = null);

(statearr_36683_39767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (4))){
var inst_36640 = (state_36677[(7)]);
var inst_36640__$1 = (state_36677[(2)]);
var inst_36642 = (inst_36640__$1 == null);
var state_36677__$1 = (function (){var statearr_36688 = state_36677;
(statearr_36688[(7)] = inst_36640__$1);

return statearr_36688;
})();
if(cljs.core.truth_(inst_36642)){
var statearr_36689_39768 = state_36677__$1;
(statearr_36689_39768[(1)] = (5));

} else {
var statearr_36691_39769 = state_36677__$1;
(statearr_36691_39769[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (15))){
var inst_36654 = (state_36677[(8)]);
var state_36677__$1 = state_36677;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36677__$1,(18),to,inst_36654);
} else {
if((state_val_36678 === (21))){
var inst_36668 = (state_36677[(2)]);
var state_36677__$1 = state_36677;
var statearr_36697_39770 = state_36677__$1;
(statearr_36697_39770[(2)] = inst_36668);

(statearr_36697_39770[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (13))){
var inst_36670 = (state_36677[(2)]);
var state_36677__$1 = (function (){var statearr_36701 = state_36677;
(statearr_36701[(9)] = inst_36670);

return statearr_36701;
})();
var statearr_36702_39771 = state_36677__$1;
(statearr_36702_39771[(2)] = null);

(statearr_36702_39771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (6))){
var inst_36640 = (state_36677[(7)]);
var state_36677__$1 = state_36677;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36677__$1,(11),inst_36640);
} else {
if((state_val_36678 === (17))){
var inst_36662 = (state_36677[(2)]);
var state_36677__$1 = state_36677;
if(cljs.core.truth_(inst_36662)){
var statearr_36718_39777 = state_36677__$1;
(statearr_36718_39777[(1)] = (19));

} else {
var statearr_36720_39778 = state_36677__$1;
(statearr_36720_39778[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (3))){
var inst_36675 = (state_36677[(2)]);
var state_36677__$1 = state_36677;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36677__$1,inst_36675);
} else {
if((state_val_36678 === (12))){
var inst_36651 = (state_36677[(10)]);
var state_36677__$1 = state_36677;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36677__$1,(14),inst_36651);
} else {
if((state_val_36678 === (2))){
var state_36677__$1 = state_36677;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36677__$1,(4),results);
} else {
if((state_val_36678 === (19))){
var state_36677__$1 = state_36677;
var statearr_36738_39779 = state_36677__$1;
(statearr_36738_39779[(2)] = null);

(statearr_36738_39779[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (11))){
var inst_36651 = (state_36677[(2)]);
var state_36677__$1 = (function (){var statearr_36740 = state_36677;
(statearr_36740[(10)] = inst_36651);

return statearr_36740;
})();
var statearr_36741_39780 = state_36677__$1;
(statearr_36741_39780[(2)] = null);

(statearr_36741_39780[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (9))){
var state_36677__$1 = state_36677;
var statearr_36742_39781 = state_36677__$1;
(statearr_36742_39781[(2)] = null);

(statearr_36742_39781[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (5))){
var state_36677__$1 = state_36677;
if(cljs.core.truth_(close_QMARK_)){
var statearr_36743_39782 = state_36677__$1;
(statearr_36743_39782[(1)] = (8));

} else {
var statearr_36744_39783 = state_36677__$1;
(statearr_36744_39783[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (14))){
var inst_36656 = (state_36677[(11)]);
var inst_36654 = (state_36677[(8)]);
var inst_36654__$1 = (state_36677[(2)]);
var inst_36655 = (inst_36654__$1 == null);
var inst_36656__$1 = cljs.core.not(inst_36655);
var state_36677__$1 = (function (){var statearr_36751 = state_36677;
(statearr_36751[(11)] = inst_36656__$1);

(statearr_36751[(8)] = inst_36654__$1);

return statearr_36751;
})();
if(inst_36656__$1){
var statearr_36753_39784 = state_36677__$1;
(statearr_36753_39784[(1)] = (15));

} else {
var statearr_36756_39785 = state_36677__$1;
(statearr_36756_39785[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (16))){
var inst_36656 = (state_36677[(11)]);
var state_36677__$1 = state_36677;
var statearr_36761_39789 = state_36677__$1;
(statearr_36761_39789[(2)] = inst_36656);

(statearr_36761_39789[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (10))){
var inst_36648 = (state_36677[(2)]);
var state_36677__$1 = state_36677;
var statearr_36762_39790 = state_36677__$1;
(statearr_36762_39790[(2)] = inst_36648);

(statearr_36762_39790[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (18))){
var inst_36659 = (state_36677[(2)]);
var state_36677__$1 = state_36677;
var statearr_36765_39791 = state_36677__$1;
(statearr_36765_39791[(2)] = inst_36659);

(statearr_36765_39791[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36678 === (8))){
var inst_36645 = cljs.core.async.close_BANG_(to);
var state_36677__$1 = state_36677;
var statearr_36766_39792 = state_36677__$1;
(statearr_36766_39792[(2)] = inst_36645);

(statearr_36766_39792[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0 = (function (){
var statearr_36775 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36775[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__);

(statearr_36775[(1)] = (1));

return statearr_36775;
});
var cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1 = (function (state_36677){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_36677);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e36778){var ex__28052__auto__ = e36778;
var statearr_36780_39797 = state_36677;
(statearr_36780_39797[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_36677[(4)]))){
var statearr_36786_39798 = state_36677;
(statearr_36786_39798[(1)] = cljs.core.first((state_36677[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39800 = state_36677;
state_36677 = G__39800;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__ = function(state_36677){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1.call(this,state_36677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__28049__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_36788 = f__28229__auto__();
(statearr_36788[(6)] = c__28228__auto__);

return statearr_36788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));

return c__28228__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__36806 = arguments.length;
switch (G__36806) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__36813 = arguments.length;
switch (G__36813) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__36833 = arguments.length;
switch (G__36833) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__28228__auto___39820 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_36864){
var state_val_36865 = (state_36864[(1)]);
if((state_val_36865 === (7))){
var inst_36860 = (state_36864[(2)]);
var state_36864__$1 = state_36864;
var statearr_36868_39821 = state_36864__$1;
(statearr_36868_39821[(2)] = inst_36860);

(statearr_36868_39821[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (1))){
var state_36864__$1 = state_36864;
var statearr_36869_39822 = state_36864__$1;
(statearr_36869_39822[(2)] = null);

(statearr_36869_39822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (4))){
var inst_36840 = (state_36864[(7)]);
var inst_36840__$1 = (state_36864[(2)]);
var inst_36841 = (inst_36840__$1 == null);
var state_36864__$1 = (function (){var statearr_36871 = state_36864;
(statearr_36871[(7)] = inst_36840__$1);

return statearr_36871;
})();
if(cljs.core.truth_(inst_36841)){
var statearr_36872_39824 = state_36864__$1;
(statearr_36872_39824[(1)] = (5));

} else {
var statearr_36873_39825 = state_36864__$1;
(statearr_36873_39825[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (13))){
var state_36864__$1 = state_36864;
var statearr_36875_39826 = state_36864__$1;
(statearr_36875_39826[(2)] = null);

(statearr_36875_39826[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (6))){
var inst_36840 = (state_36864[(7)]);
var inst_36847 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_36840) : p.call(null,inst_36840));
var state_36864__$1 = state_36864;
if(cljs.core.truth_(inst_36847)){
var statearr_36880_39832 = state_36864__$1;
(statearr_36880_39832[(1)] = (9));

} else {
var statearr_36882_39833 = state_36864__$1;
(statearr_36882_39833[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (3))){
var inst_36862 = (state_36864[(2)]);
var state_36864__$1 = state_36864;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36864__$1,inst_36862);
} else {
if((state_val_36865 === (12))){
var state_36864__$1 = state_36864;
var statearr_36896_39837 = state_36864__$1;
(statearr_36896_39837[(2)] = null);

(statearr_36896_39837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (2))){
var state_36864__$1 = state_36864;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36864__$1,(4),ch);
} else {
if((state_val_36865 === (11))){
var inst_36840 = (state_36864[(7)]);
var inst_36851 = (state_36864[(2)]);
var state_36864__$1 = state_36864;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_36864__$1,(8),inst_36851,inst_36840);
} else {
if((state_val_36865 === (9))){
var state_36864__$1 = state_36864;
var statearr_36910_39838 = state_36864__$1;
(statearr_36910_39838[(2)] = tc);

(statearr_36910_39838[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (5))){
var inst_36843 = cljs.core.async.close_BANG_(tc);
var inst_36845 = cljs.core.async.close_BANG_(fc);
var state_36864__$1 = (function (){var statearr_36918 = state_36864;
(statearr_36918[(8)] = inst_36843);

return statearr_36918;
})();
var statearr_36920_39843 = state_36864__$1;
(statearr_36920_39843[(2)] = inst_36845);

(statearr_36920_39843[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (14))){
var inst_36858 = (state_36864[(2)]);
var state_36864__$1 = state_36864;
var statearr_36926_39844 = state_36864__$1;
(statearr_36926_39844[(2)] = inst_36858);

(statearr_36926_39844[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (10))){
var state_36864__$1 = state_36864;
var statearr_36929_39845 = state_36864__$1;
(statearr_36929_39845[(2)] = fc);

(statearr_36929_39845[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36865 === (8))){
var inst_36853 = (state_36864[(2)]);
var state_36864__$1 = state_36864;
if(cljs.core.truth_(inst_36853)){
var statearr_36938_39846 = state_36864__$1;
(statearr_36938_39846[(1)] = (12));

} else {
var statearr_36939_39847 = state_36864__$1;
(statearr_36939_39847[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_36946 = [null,null,null,null,null,null,null,null,null];
(statearr_36946[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_36946[(1)] = (1));

return statearr_36946;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_36864){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_36864);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e36947){var ex__28052__auto__ = e36947;
var statearr_36948_39850 = state_36864;
(statearr_36948_39850[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_36864[(4)]))){
var statearr_36949_39851 = state_36864;
(statearr_36949_39851[(1)] = cljs.core.first((state_36864[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39852 = state_36864;
state_36864 = G__39852;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_36864){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_36864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_36952 = f__28229__auto__();
(statearr_36952[(6)] = c__28228__auto___39820);

return statearr_36952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__28228__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_36988){
var state_val_36989 = (state_36988[(1)]);
if((state_val_36989 === (7))){
var inst_36978 = (state_36988[(2)]);
var state_36988__$1 = state_36988;
var statearr_37003_39855 = state_36988__$1;
(statearr_37003_39855[(2)] = inst_36978);

(statearr_37003_39855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36989 === (1))){
var inst_36960 = init;
var inst_36961 = inst_36960;
var state_36988__$1 = (function (){var statearr_37005 = state_36988;
(statearr_37005[(7)] = inst_36961);

return statearr_37005;
})();
var statearr_37007_39859 = state_36988__$1;
(statearr_37007_39859[(2)] = null);

(statearr_37007_39859[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36989 === (4))){
var inst_36964 = (state_36988[(8)]);
var inst_36964__$1 = (state_36988[(2)]);
var inst_36965 = (inst_36964__$1 == null);
var state_36988__$1 = (function (){var statearr_37009 = state_36988;
(statearr_37009[(8)] = inst_36964__$1);

return statearr_37009;
})();
if(cljs.core.truth_(inst_36965)){
var statearr_37010_39861 = state_36988__$1;
(statearr_37010_39861[(1)] = (5));

} else {
var statearr_37011_39863 = state_36988__$1;
(statearr_37011_39863[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36989 === (6))){
var inst_36961 = (state_36988[(7)]);
var inst_36964 = (state_36988[(8)]);
var inst_36968 = (state_36988[(9)]);
var inst_36968__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_36961,inst_36964) : f.call(null,inst_36961,inst_36964));
var inst_36969 = cljs.core.reduced_QMARK_(inst_36968__$1);
var state_36988__$1 = (function (){var statearr_37012 = state_36988;
(statearr_37012[(9)] = inst_36968__$1);

return statearr_37012;
})();
if(inst_36969){
var statearr_37013_39868 = state_36988__$1;
(statearr_37013_39868[(1)] = (8));

} else {
var statearr_37015_39869 = state_36988__$1;
(statearr_37015_39869[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36989 === (3))){
var inst_36980 = (state_36988[(2)]);
var state_36988__$1 = state_36988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36988__$1,inst_36980);
} else {
if((state_val_36989 === (2))){
var state_36988__$1 = state_36988;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36988__$1,(4),ch);
} else {
if((state_val_36989 === (9))){
var inst_36968 = (state_36988[(9)]);
var inst_36961 = inst_36968;
var state_36988__$1 = (function (){var statearr_37016 = state_36988;
(statearr_37016[(7)] = inst_36961);

return statearr_37016;
})();
var statearr_37018_39872 = state_36988__$1;
(statearr_37018_39872[(2)] = null);

(statearr_37018_39872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36989 === (5))){
var inst_36961 = (state_36988[(7)]);
var state_36988__$1 = state_36988;
var statearr_37019_39876 = state_36988__$1;
(statearr_37019_39876[(2)] = inst_36961);

(statearr_37019_39876[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36989 === (10))){
var inst_36976 = (state_36988[(2)]);
var state_36988__$1 = state_36988;
var statearr_37021_39877 = state_36988__$1;
(statearr_37021_39877[(2)] = inst_36976);

(statearr_37021_39877[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_36989 === (8))){
var inst_36968 = (state_36988[(9)]);
var inst_36972 = cljs.core.deref(inst_36968);
var state_36988__$1 = state_36988;
var statearr_37022_39879 = state_36988__$1;
(statearr_37022_39879[(2)] = inst_36972);

(statearr_37022_39879[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__28049__auto__ = null;
var cljs$core$async$reduce_$_state_machine__28049__auto____0 = (function (){
var statearr_37025 = [null,null,null,null,null,null,null,null,null,null];
(statearr_37025[(0)] = cljs$core$async$reduce_$_state_machine__28049__auto__);

(statearr_37025[(1)] = (1));

return statearr_37025;
});
var cljs$core$async$reduce_$_state_machine__28049__auto____1 = (function (state_36988){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_36988);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e37026){var ex__28052__auto__ = e37026;
var statearr_37027_39881 = state_36988;
(statearr_37027_39881[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_36988[(4)]))){
var statearr_37028_39882 = state_36988;
(statearr_37028_39882[(1)] = cljs.core.first((state_36988[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39883 = state_36988;
state_36988 = G__39883;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__28049__auto__ = function(state_36988){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__28049__auto____1.call(this,state_36988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__28049__auto____0;
cljs$core$async$reduce_$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__28049__auto____1;
return cljs$core$async$reduce_$_state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_37031 = f__28229__auto__();
(statearr_37031[(6)] = c__28228__auto__);

return statearr_37031;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));

return c__28228__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__28228__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_37042){
var state_val_37043 = (state_37042[(1)]);
if((state_val_37043 === (1))){
var inst_37037 = cljs.core.async.reduce(f__$1,init,ch);
var state_37042__$1 = state_37042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37042__$1,(2),inst_37037);
} else {
if((state_val_37043 === (2))){
var inst_37039 = (state_37042[(2)]);
var inst_37040 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_37039) : f__$1.call(null,inst_37039));
var state_37042__$1 = state_37042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37042__$1,inst_37040);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__28049__auto__ = null;
var cljs$core$async$transduce_$_state_machine__28049__auto____0 = (function (){
var statearr_37046 = [null,null,null,null,null,null,null];
(statearr_37046[(0)] = cljs$core$async$transduce_$_state_machine__28049__auto__);

(statearr_37046[(1)] = (1));

return statearr_37046;
});
var cljs$core$async$transduce_$_state_machine__28049__auto____1 = (function (state_37042){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_37042);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e37047){var ex__28052__auto__ = e37047;
var statearr_37048_39894 = state_37042;
(statearr_37048_39894[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_37042[(4)]))){
var statearr_37049_39895 = state_37042;
(statearr_37049_39895[(1)] = cljs.core.first((state_37042[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39897 = state_37042;
state_37042 = G__39897;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__28049__auto__ = function(state_37042){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__28049__auto____1.call(this,state_37042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__28049__auto____0;
cljs$core$async$transduce_$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__28049__auto____1;
return cljs$core$async$transduce_$_state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_37051 = f__28229__auto__();
(statearr_37051[(6)] = c__28228__auto__);

return statearr_37051;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));

return c__28228__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__37056 = arguments.length;
switch (G__37056) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__28228__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_37088){
var state_val_37089 = (state_37088[(1)]);
if((state_val_37089 === (7))){
var inst_37066 = (state_37088[(2)]);
var state_37088__$1 = state_37088;
var statearr_37094_39904 = state_37088__$1;
(statearr_37094_39904[(2)] = inst_37066);

(statearr_37094_39904[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (1))){
var inst_37058 = cljs.core.seq(coll);
var inst_37059 = inst_37058;
var state_37088__$1 = (function (){var statearr_37095 = state_37088;
(statearr_37095[(7)] = inst_37059);

return statearr_37095;
})();
var statearr_37096_39906 = state_37088__$1;
(statearr_37096_39906[(2)] = null);

(statearr_37096_39906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (4))){
var inst_37059 = (state_37088[(7)]);
var inst_37064 = cljs.core.first(inst_37059);
var state_37088__$1 = state_37088;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37088__$1,(7),ch,inst_37064);
} else {
if((state_val_37089 === (13))){
var inst_37082 = (state_37088[(2)]);
var state_37088__$1 = state_37088;
var statearr_37099_39919 = state_37088__$1;
(statearr_37099_39919[(2)] = inst_37082);

(statearr_37099_39919[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (6))){
var inst_37069 = (state_37088[(2)]);
var state_37088__$1 = state_37088;
if(cljs.core.truth_(inst_37069)){
var statearr_37101_39921 = state_37088__$1;
(statearr_37101_39921[(1)] = (8));

} else {
var statearr_37102_39922 = state_37088__$1;
(statearr_37102_39922[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (3))){
var inst_37086 = (state_37088[(2)]);
var state_37088__$1 = state_37088;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37088__$1,inst_37086);
} else {
if((state_val_37089 === (12))){
var state_37088__$1 = state_37088;
var statearr_37104_39923 = state_37088__$1;
(statearr_37104_39923[(2)] = null);

(statearr_37104_39923[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (2))){
var inst_37059 = (state_37088[(7)]);
var state_37088__$1 = state_37088;
if(cljs.core.truth_(inst_37059)){
var statearr_37111_39924 = state_37088__$1;
(statearr_37111_39924[(1)] = (4));

} else {
var statearr_37112_39931 = state_37088__$1;
(statearr_37112_39931[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (11))){
var inst_37079 = cljs.core.async.close_BANG_(ch);
var state_37088__$1 = state_37088;
var statearr_37114_39932 = state_37088__$1;
(statearr_37114_39932[(2)] = inst_37079);

(statearr_37114_39932[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (9))){
var state_37088__$1 = state_37088;
if(cljs.core.truth_(close_QMARK_)){
var statearr_37115_39934 = state_37088__$1;
(statearr_37115_39934[(1)] = (11));

} else {
var statearr_37116_39935 = state_37088__$1;
(statearr_37116_39935[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (5))){
var inst_37059 = (state_37088[(7)]);
var state_37088__$1 = state_37088;
var statearr_37117_39936 = state_37088__$1;
(statearr_37117_39936[(2)] = inst_37059);

(statearr_37117_39936[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (10))){
var inst_37084 = (state_37088[(2)]);
var state_37088__$1 = state_37088;
var statearr_37119_39939 = state_37088__$1;
(statearr_37119_39939[(2)] = inst_37084);

(statearr_37119_39939[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37089 === (8))){
var inst_37059 = (state_37088[(7)]);
var inst_37071 = cljs.core.next(inst_37059);
var inst_37059__$1 = inst_37071;
var state_37088__$1 = (function (){var statearr_37120 = state_37088;
(statearr_37120[(7)] = inst_37059__$1);

return statearr_37120;
})();
var statearr_37121_39942 = state_37088__$1;
(statearr_37121_39942[(2)] = null);

(statearr_37121_39942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_37123 = [null,null,null,null,null,null,null,null];
(statearr_37123[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_37123[(1)] = (1));

return statearr_37123;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_37088){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_37088);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e37126){var ex__28052__auto__ = e37126;
var statearr_37127_39946 = state_37088;
(statearr_37127_39946[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_37088[(4)]))){
var statearr_37128_39948 = state_37088;
(statearr_37128_39948[(1)] = cljs.core.first((state_37088[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__39950 = state_37088;
state_37088 = G__39950;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_37088){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_37088);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_37130 = f__28229__auto__();
(statearr_37130[(6)] = c__28228__auto__);

return statearr_37130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));

return c__28228__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__37134 = arguments.length;
switch (G__37134) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_39968 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null,_));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_39968(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_39971 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_39971(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_39980 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_39980(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_39983 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_39983(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37206 = (function (ch,cs,meta37207){
this.ch = ch;
this.cs = cs;
this.meta37207 = meta37207;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37206.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37208,meta37207__$1){
var self__ = this;
var _37208__$1 = this;
return (new cljs.core.async.t_cljs$core$async37206(self__.ch,self__.cs,meta37207__$1));
}));

(cljs.core.async.t_cljs$core$async37206.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37208){
var self__ = this;
var _37208__$1 = this;
return self__.meta37207;
}));

(cljs.core.async.t_cljs$core$async37206.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37206.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async37206.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37206.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async37206.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async37206.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async37206.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta37207","meta37207",-505884957,null)], null);
}));

(cljs.core.async.t_cljs$core$async37206.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37206.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37206");

(cljs.core.async.t_cljs$core$async37206.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async37206");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37206.
 */
cljs.core.async.__GT_t_cljs$core$async37206 = (function cljs$core$async$__GT_t_cljs$core$async37206(ch,cs,meta37207){
return (new cljs.core.async.t_cljs$core$async37206(ch,cs,meta37207));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async37206(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__28228__auto___39996 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_37434){
var state_val_37435 = (state_37434[(1)]);
if((state_val_37435 === (7))){
var inst_37426 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
var statearr_37438_40003 = state_37434__$1;
(statearr_37438_40003[(2)] = inst_37426);

(statearr_37438_40003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (20))){
var inst_37317 = (state_37434[(7)]);
var inst_37336 = cljs.core.first(inst_37317);
var inst_37337 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37336,(0),null);
var inst_37339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37336,(1),null);
var state_37434__$1 = (function (){var statearr_37443 = state_37434;
(statearr_37443[(8)] = inst_37337);

return statearr_37443;
})();
if(cljs.core.truth_(inst_37339)){
var statearr_37444_40007 = state_37434__$1;
(statearr_37444_40007[(1)] = (22));

} else {
var statearr_37445_40008 = state_37434__$1;
(statearr_37445_40008[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (27))){
var inst_37374 = (state_37434[(9)]);
var inst_37367 = (state_37434[(10)]);
var inst_37278 = (state_37434[(11)]);
var inst_37369 = (state_37434[(12)]);
var inst_37374__$1 = cljs.core._nth(inst_37367,inst_37369);
var inst_37375 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37374__$1,inst_37278,done);
var state_37434__$1 = (function (){var statearr_37447 = state_37434;
(statearr_37447[(9)] = inst_37374__$1);

return statearr_37447;
})();
if(cljs.core.truth_(inst_37375)){
var statearr_37450_40013 = state_37434__$1;
(statearr_37450_40013[(1)] = (30));

} else {
var statearr_37452_40015 = state_37434__$1;
(statearr_37452_40015[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (1))){
var state_37434__$1 = state_37434;
var statearr_37453_40016 = state_37434__$1;
(statearr_37453_40016[(2)] = null);

(statearr_37453_40016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (24))){
var inst_37317 = (state_37434[(7)]);
var inst_37344 = (state_37434[(2)]);
var inst_37345 = cljs.core.next(inst_37317);
var inst_37295 = inst_37345;
var inst_37296 = null;
var inst_37297 = (0);
var inst_37298 = (0);
var state_37434__$1 = (function (){var statearr_37454 = state_37434;
(statearr_37454[(13)] = inst_37296);

(statearr_37454[(14)] = inst_37298);

(statearr_37454[(15)] = inst_37344);

(statearr_37454[(16)] = inst_37295);

(statearr_37454[(17)] = inst_37297);

return statearr_37454;
})();
var statearr_37456_40018 = state_37434__$1;
(statearr_37456_40018[(2)] = null);

(statearr_37456_40018[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (39))){
var state_37434__$1 = state_37434;
var statearr_37465_40019 = state_37434__$1;
(statearr_37465_40019[(2)] = null);

(statearr_37465_40019[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (4))){
var inst_37278 = (state_37434[(11)]);
var inst_37278__$1 = (state_37434[(2)]);
var inst_37279 = (inst_37278__$1 == null);
var state_37434__$1 = (function (){var statearr_37466 = state_37434;
(statearr_37466[(11)] = inst_37278__$1);

return statearr_37466;
})();
if(cljs.core.truth_(inst_37279)){
var statearr_37468_40022 = state_37434__$1;
(statearr_37468_40022[(1)] = (5));

} else {
var statearr_37470_40025 = state_37434__$1;
(statearr_37470_40025[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (15))){
var inst_37296 = (state_37434[(13)]);
var inst_37298 = (state_37434[(14)]);
var inst_37295 = (state_37434[(16)]);
var inst_37297 = (state_37434[(17)]);
var inst_37313 = (state_37434[(2)]);
var inst_37314 = (inst_37298 + (1));
var tmp37459 = inst_37296;
var tmp37462 = inst_37295;
var tmp37463 = inst_37297;
var inst_37295__$1 = tmp37462;
var inst_37296__$1 = tmp37459;
var inst_37297__$1 = tmp37463;
var inst_37298__$1 = inst_37314;
var state_37434__$1 = (function (){var statearr_37472 = state_37434;
(statearr_37472[(13)] = inst_37296__$1);

(statearr_37472[(18)] = inst_37313);

(statearr_37472[(14)] = inst_37298__$1);

(statearr_37472[(16)] = inst_37295__$1);

(statearr_37472[(17)] = inst_37297__$1);

return statearr_37472;
})();
var statearr_37473_40030 = state_37434__$1;
(statearr_37473_40030[(2)] = null);

(statearr_37473_40030[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (21))){
var inst_37348 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
var statearr_37478_40032 = state_37434__$1;
(statearr_37478_40032[(2)] = inst_37348);

(statearr_37478_40032[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (31))){
var inst_37374 = (state_37434[(9)]);
var inst_37378 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37374);
var state_37434__$1 = state_37434;
var statearr_37481_40034 = state_37434__$1;
(statearr_37481_40034[(2)] = inst_37378);

(statearr_37481_40034[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (32))){
var inst_37366 = (state_37434[(19)]);
var inst_37367 = (state_37434[(10)]);
var inst_37368 = (state_37434[(20)]);
var inst_37369 = (state_37434[(12)]);
var inst_37380 = (state_37434[(2)]);
var inst_37382 = (inst_37369 + (1));
var tmp37475 = inst_37366;
var tmp37476 = inst_37367;
var tmp37477 = inst_37368;
var inst_37366__$1 = tmp37475;
var inst_37367__$1 = tmp37476;
var inst_37368__$1 = tmp37477;
var inst_37369__$1 = inst_37382;
var state_37434__$1 = (function (){var statearr_37484 = state_37434;
(statearr_37484[(19)] = inst_37366__$1);

(statearr_37484[(21)] = inst_37380);

(statearr_37484[(10)] = inst_37367__$1);

(statearr_37484[(20)] = inst_37368__$1);

(statearr_37484[(12)] = inst_37369__$1);

return statearr_37484;
})();
var statearr_37487_40039 = state_37434__$1;
(statearr_37487_40039[(2)] = null);

(statearr_37487_40039[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (40))){
var inst_37398 = (state_37434[(22)]);
var inst_37402 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_37398);
var state_37434__$1 = state_37434;
var statearr_37490_40043 = state_37434__$1;
(statearr_37490_40043[(2)] = inst_37402);

(statearr_37490_40043[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (33))){
var inst_37386 = (state_37434[(23)]);
var inst_37391 = cljs.core.chunked_seq_QMARK_(inst_37386);
var state_37434__$1 = state_37434;
if(inst_37391){
var statearr_37493_40044 = state_37434__$1;
(statearr_37493_40044[(1)] = (36));

} else {
var statearr_37494_40046 = state_37434__$1;
(statearr_37494_40046[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (13))){
var inst_37307 = (state_37434[(24)]);
var inst_37310 = cljs.core.async.close_BANG_(inst_37307);
var state_37434__$1 = state_37434;
var statearr_37496_40048 = state_37434__$1;
(statearr_37496_40048[(2)] = inst_37310);

(statearr_37496_40048[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (22))){
var inst_37337 = (state_37434[(8)]);
var inst_37341 = cljs.core.async.close_BANG_(inst_37337);
var state_37434__$1 = state_37434;
var statearr_37497_40051 = state_37434__$1;
(statearr_37497_40051[(2)] = inst_37341);

(statearr_37497_40051[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (36))){
var inst_37386 = (state_37434[(23)]);
var inst_37393 = cljs.core.chunk_first(inst_37386);
var inst_37394 = cljs.core.chunk_rest(inst_37386);
var inst_37395 = cljs.core.count(inst_37393);
var inst_37366 = inst_37394;
var inst_37367 = inst_37393;
var inst_37368 = inst_37395;
var inst_37369 = (0);
var state_37434__$1 = (function (){var statearr_37502 = state_37434;
(statearr_37502[(19)] = inst_37366);

(statearr_37502[(10)] = inst_37367);

(statearr_37502[(20)] = inst_37368);

(statearr_37502[(12)] = inst_37369);

return statearr_37502;
})();
var statearr_37503_40065 = state_37434__$1;
(statearr_37503_40065[(2)] = null);

(statearr_37503_40065[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (41))){
var inst_37386 = (state_37434[(23)]);
var inst_37404 = (state_37434[(2)]);
var inst_37405 = cljs.core.next(inst_37386);
var inst_37366 = inst_37405;
var inst_37367 = null;
var inst_37368 = (0);
var inst_37369 = (0);
var state_37434__$1 = (function (){var statearr_37504 = state_37434;
(statearr_37504[(19)] = inst_37366);

(statearr_37504[(10)] = inst_37367);

(statearr_37504[(20)] = inst_37368);

(statearr_37504[(25)] = inst_37404);

(statearr_37504[(12)] = inst_37369);

return statearr_37504;
})();
var statearr_37506_40073 = state_37434__$1;
(statearr_37506_40073[(2)] = null);

(statearr_37506_40073[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (43))){
var state_37434__$1 = state_37434;
var statearr_37508_40074 = state_37434__$1;
(statearr_37508_40074[(2)] = null);

(statearr_37508_40074[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (29))){
var inst_37413 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
var statearr_37513_40075 = state_37434__$1;
(statearr_37513_40075[(2)] = inst_37413);

(statearr_37513_40075[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (44))){
var inst_37423 = (state_37434[(2)]);
var state_37434__$1 = (function (){var statearr_37514 = state_37434;
(statearr_37514[(26)] = inst_37423);

return statearr_37514;
})();
var statearr_37515_40076 = state_37434__$1;
(statearr_37515_40076[(2)] = null);

(statearr_37515_40076[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (6))){
var inst_37358 = (state_37434[(27)]);
var inst_37357 = cljs.core.deref(cs);
var inst_37358__$1 = cljs.core.keys(inst_37357);
var inst_37359 = cljs.core.count(inst_37358__$1);
var inst_37360 = cljs.core.reset_BANG_(dctr,inst_37359);
var inst_37365 = cljs.core.seq(inst_37358__$1);
var inst_37366 = inst_37365;
var inst_37367 = null;
var inst_37368 = (0);
var inst_37369 = (0);
var state_37434__$1 = (function (){var statearr_37517 = state_37434;
(statearr_37517[(19)] = inst_37366);

(statearr_37517[(10)] = inst_37367);

(statearr_37517[(20)] = inst_37368);

(statearr_37517[(27)] = inst_37358__$1);

(statearr_37517[(28)] = inst_37360);

(statearr_37517[(12)] = inst_37369);

return statearr_37517;
})();
var statearr_37518_40083 = state_37434__$1;
(statearr_37518_40083[(2)] = null);

(statearr_37518_40083[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (28))){
var inst_37366 = (state_37434[(19)]);
var inst_37386 = (state_37434[(23)]);
var inst_37386__$1 = cljs.core.seq(inst_37366);
var state_37434__$1 = (function (){var statearr_37522 = state_37434;
(statearr_37522[(23)] = inst_37386__$1);

return statearr_37522;
})();
if(inst_37386__$1){
var statearr_37523_40085 = state_37434__$1;
(statearr_37523_40085[(1)] = (33));

} else {
var statearr_37524_40086 = state_37434__$1;
(statearr_37524_40086[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (25))){
var inst_37368 = (state_37434[(20)]);
var inst_37369 = (state_37434[(12)]);
var inst_37371 = (inst_37369 < inst_37368);
var inst_37372 = inst_37371;
var state_37434__$1 = state_37434;
if(cljs.core.truth_(inst_37372)){
var statearr_37526_40088 = state_37434__$1;
(statearr_37526_40088[(1)] = (27));

} else {
var statearr_37528_40089 = state_37434__$1;
(statearr_37528_40089[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (34))){
var state_37434__$1 = state_37434;
var statearr_37529_40090 = state_37434__$1;
(statearr_37529_40090[(2)] = null);

(statearr_37529_40090[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (17))){
var state_37434__$1 = state_37434;
var statearr_37531_40091 = state_37434__$1;
(statearr_37531_40091[(2)] = null);

(statearr_37531_40091[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (3))){
var inst_37428 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37434__$1,inst_37428);
} else {
if((state_val_37435 === (12))){
var inst_37353 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
var statearr_37535_40097 = state_37434__$1;
(statearr_37535_40097[(2)] = inst_37353);

(statearr_37535_40097[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (2))){
var state_37434__$1 = state_37434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37434__$1,(4),ch);
} else {
if((state_val_37435 === (23))){
var state_37434__$1 = state_37434;
var statearr_37537_40100 = state_37434__$1;
(statearr_37537_40100[(2)] = null);

(statearr_37537_40100[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (35))){
var inst_37411 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
var statearr_37541_40102 = state_37434__$1;
(statearr_37541_40102[(2)] = inst_37411);

(statearr_37541_40102[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (19))){
var inst_37317 = (state_37434[(7)]);
var inst_37321 = cljs.core.chunk_first(inst_37317);
var inst_37323 = cljs.core.chunk_rest(inst_37317);
var inst_37325 = cljs.core.count(inst_37321);
var inst_37295 = inst_37323;
var inst_37296 = inst_37321;
var inst_37297 = inst_37325;
var inst_37298 = (0);
var state_37434__$1 = (function (){var statearr_37546 = state_37434;
(statearr_37546[(13)] = inst_37296);

(statearr_37546[(14)] = inst_37298);

(statearr_37546[(16)] = inst_37295);

(statearr_37546[(17)] = inst_37297);

return statearr_37546;
})();
var statearr_37548_40103 = state_37434__$1;
(statearr_37548_40103[(2)] = null);

(statearr_37548_40103[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (11))){
var inst_37317 = (state_37434[(7)]);
var inst_37295 = (state_37434[(16)]);
var inst_37317__$1 = cljs.core.seq(inst_37295);
var state_37434__$1 = (function (){var statearr_37552 = state_37434;
(statearr_37552[(7)] = inst_37317__$1);

return statearr_37552;
})();
if(inst_37317__$1){
var statearr_37553_40105 = state_37434__$1;
(statearr_37553_40105[(1)] = (16));

} else {
var statearr_37554_40107 = state_37434__$1;
(statearr_37554_40107[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (9))){
var inst_37355 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
var statearr_37555_40108 = state_37434__$1;
(statearr_37555_40108[(2)] = inst_37355);

(statearr_37555_40108[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (5))){
var inst_37293 = cljs.core.deref(cs);
var inst_37294 = cljs.core.seq(inst_37293);
var inst_37295 = inst_37294;
var inst_37296 = null;
var inst_37297 = (0);
var inst_37298 = (0);
var state_37434__$1 = (function (){var statearr_37557 = state_37434;
(statearr_37557[(13)] = inst_37296);

(statearr_37557[(14)] = inst_37298);

(statearr_37557[(16)] = inst_37295);

(statearr_37557[(17)] = inst_37297);

return statearr_37557;
})();
var statearr_37558_40115 = state_37434__$1;
(statearr_37558_40115[(2)] = null);

(statearr_37558_40115[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (14))){
var state_37434__$1 = state_37434;
var statearr_37559_40122 = state_37434__$1;
(statearr_37559_40122[(2)] = null);

(statearr_37559_40122[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (45))){
var inst_37420 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
var statearr_37562_40123 = state_37434__$1;
(statearr_37562_40123[(2)] = inst_37420);

(statearr_37562_40123[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (26))){
var inst_37358 = (state_37434[(27)]);
var inst_37415 = (state_37434[(2)]);
var inst_37417 = cljs.core.seq(inst_37358);
var state_37434__$1 = (function (){var statearr_37564 = state_37434;
(statearr_37564[(29)] = inst_37415);

return statearr_37564;
})();
if(inst_37417){
var statearr_37565_40128 = state_37434__$1;
(statearr_37565_40128[(1)] = (42));

} else {
var statearr_37566_40129 = state_37434__$1;
(statearr_37566_40129[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (16))){
var inst_37317 = (state_37434[(7)]);
var inst_37319 = cljs.core.chunked_seq_QMARK_(inst_37317);
var state_37434__$1 = state_37434;
if(inst_37319){
var statearr_37568_40131 = state_37434__$1;
(statearr_37568_40131[(1)] = (19));

} else {
var statearr_37570_40132 = state_37434__$1;
(statearr_37570_40132[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (38))){
var inst_37408 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
var statearr_37571_40133 = state_37434__$1;
(statearr_37571_40133[(2)] = inst_37408);

(statearr_37571_40133[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (30))){
var state_37434__$1 = state_37434;
var statearr_37572_40134 = state_37434__$1;
(statearr_37572_40134[(2)] = null);

(statearr_37572_40134[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (10))){
var inst_37296 = (state_37434[(13)]);
var inst_37298 = (state_37434[(14)]);
var inst_37306 = cljs.core._nth(inst_37296,inst_37298);
var inst_37307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37306,(0),null);
var inst_37308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37306,(1),null);
var state_37434__$1 = (function (){var statearr_37579 = state_37434;
(statearr_37579[(24)] = inst_37307);

return statearr_37579;
})();
if(cljs.core.truth_(inst_37308)){
var statearr_37580_40138 = state_37434__$1;
(statearr_37580_40138[(1)] = (13));

} else {
var statearr_37581_40140 = state_37434__$1;
(statearr_37581_40140[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (18))){
var inst_37351 = (state_37434[(2)]);
var state_37434__$1 = state_37434;
var statearr_37582_40141 = state_37434__$1;
(statearr_37582_40141[(2)] = inst_37351);

(statearr_37582_40141[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (42))){
var state_37434__$1 = state_37434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37434__$1,(45),dchan);
} else {
if((state_val_37435 === (37))){
var inst_37386 = (state_37434[(23)]);
var inst_37398 = (state_37434[(22)]);
var inst_37278 = (state_37434[(11)]);
var inst_37398__$1 = cljs.core.first(inst_37386);
var inst_37399 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_37398__$1,inst_37278,done);
var state_37434__$1 = (function (){var statearr_37584 = state_37434;
(statearr_37584[(22)] = inst_37398__$1);

return statearr_37584;
})();
if(cljs.core.truth_(inst_37399)){
var statearr_37585_40144 = state_37434__$1;
(statearr_37585_40144[(1)] = (39));

} else {
var statearr_37586_40145 = state_37434__$1;
(statearr_37586_40145[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37435 === (8))){
var inst_37298 = (state_37434[(14)]);
var inst_37297 = (state_37434[(17)]);
var inst_37300 = (inst_37298 < inst_37297);
var inst_37301 = inst_37300;
var state_37434__$1 = state_37434;
if(cljs.core.truth_(inst_37301)){
var statearr_37588_40146 = state_37434__$1;
(statearr_37588_40146[(1)] = (10));

} else {
var statearr_37591_40147 = state_37434__$1;
(statearr_37591_40147[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__28049__auto__ = null;
var cljs$core$async$mult_$_state_machine__28049__auto____0 = (function (){
var statearr_37598 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37598[(0)] = cljs$core$async$mult_$_state_machine__28049__auto__);

(statearr_37598[(1)] = (1));

return statearr_37598;
});
var cljs$core$async$mult_$_state_machine__28049__auto____1 = (function (state_37434){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_37434);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e37600){var ex__28052__auto__ = e37600;
var statearr_37601_40149 = state_37434;
(statearr_37601_40149[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_37434[(4)]))){
var statearr_37602_40150 = state_37434;
(statearr_37602_40150[(1)] = cljs.core.first((state_37434[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40153 = state_37434;
state_37434 = G__40153;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__28049__auto__ = function(state_37434){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__28049__auto____1.call(this,state_37434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__28049__auto____0;
cljs$core$async$mult_$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__28049__auto____1;
return cljs$core$async$mult_$_state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_37606 = f__28229__auto__();
(statearr_37606[(6)] = c__28228__auto___39996);

return statearr_37606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__37609 = arguments.length;
switch (G__37609) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_40159 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_40159(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_40160 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null,m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_40160(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_40163 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null,m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_40163(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_40165 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null,m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_40165(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_40176 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null,m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_40176(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___40178 = arguments.length;
var i__5727__auto___40179 = (0);
while(true){
if((i__5727__auto___40179 < len__5726__auto___40178)){
args__5732__auto__.push((arguments[i__5727__auto___40179]));

var G__40180 = (i__5727__auto___40179 + (1));
i__5727__auto___40179 = G__40180;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__37650){
var map__37652 = p__37650;
var map__37652__$1 = cljs.core.__destructure_map(map__37652);
var opts = map__37652__$1;
var statearr_37653_40181 = state;
(statearr_37653_40181[(1)] = cont_block);


var temp__5823__auto__ = cljs.core.async.do_alts((function (val){
var statearr_37658_40182 = state;
(statearr_37658_40182[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5823__auto__)){
var cb = temp__5823__auto__;
var statearr_37661_40186 = state;
(statearr_37661_40186[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq37640){
var G__37641 = cljs.core.first(seq37640);
var seq37640__$1 = cljs.core.next(seq37640);
var G__37642 = cljs.core.first(seq37640__$1);
var seq37640__$2 = cljs.core.next(seq37640__$1);
var G__37643 = cljs.core.first(seq37640__$2);
var seq37640__$3 = cljs.core.next(seq37640__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__37641,G__37642,G__37643,seq37640__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async37681 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta37682){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta37682 = meta37682;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_37683,meta37682__$1){
var self__ = this;
var _37683__$1 = this;
return (new cljs.core.async.t_cljs$core$async37681(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta37682__$1));
}));

(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_37683){
var self__ = this;
var _37683__$1 = this;
return self__.meta37682;
}));

(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37681.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async37681.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta37682","meta37682",191702858,null)], null);
}));

(cljs.core.async.t_cljs$core$async37681.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async37681.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async37681");

(cljs.core.async.t_cljs$core$async37681.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async37681");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async37681.
 */
cljs.core.async.__GT_t_cljs$core$async37681 = (function cljs$core$async$__GT_t_cljs$core$async37681(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta37682){
return (new cljs.core.async.t_cljs$core$async37681(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta37682));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async37681(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__28228__auto___40206 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_37812){
var state_val_37813 = (state_37812[(1)]);
if((state_val_37813 === (7))){
var inst_37756 = (state_37812[(2)]);
var state_37812__$1 = state_37812;
if(cljs.core.truth_(inst_37756)){
var statearr_37817_40213 = state_37812__$1;
(statearr_37817_40213[(1)] = (8));

} else {
var statearr_37819_40215 = state_37812__$1;
(statearr_37819_40215[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (20))){
var inst_37741 = (state_37812[(7)]);
var state_37812__$1 = state_37812;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_37812__$1,(23),out,inst_37741);
} else {
if((state_val_37813 === (1))){
var inst_37720 = calc_state();
var inst_37721 = cljs.core.__destructure_map(inst_37720);
var inst_37722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37721,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37721,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37721,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_37725 = inst_37720;
var state_37812__$1 = (function (){var statearr_37824 = state_37812;
(statearr_37824[(8)] = inst_37723);

(statearr_37824[(9)] = inst_37724);

(statearr_37824[(10)] = inst_37725);

(statearr_37824[(11)] = inst_37722);

return statearr_37824;
})();
var statearr_37825_40217 = state_37812__$1;
(statearr_37825_40217[(2)] = null);

(statearr_37825_40217[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (24))){
var inst_37729 = (state_37812[(12)]);
var inst_37725 = inst_37729;
var state_37812__$1 = (function (){var statearr_37829 = state_37812;
(statearr_37829[(10)] = inst_37725);

return statearr_37829;
})();
var statearr_37830_40218 = state_37812__$1;
(statearr_37830_40218[(2)] = null);

(statearr_37830_40218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (4))){
var inst_37747 = (state_37812[(13)]);
var inst_37741 = (state_37812[(7)]);
var inst_37740 = (state_37812[(2)]);
var inst_37741__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37740,(0),null);
var inst_37743 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37740,(1),null);
var inst_37747__$1 = (inst_37741__$1 == null);
var state_37812__$1 = (function (){var statearr_37863 = state_37812;
(statearr_37863[(13)] = inst_37747__$1);

(statearr_37863[(14)] = inst_37743);

(statearr_37863[(7)] = inst_37741__$1);

return statearr_37863;
})();
if(cljs.core.truth_(inst_37747__$1)){
var statearr_37867_40221 = state_37812__$1;
(statearr_37867_40221[(1)] = (5));

} else {
var statearr_37868_40223 = state_37812__$1;
(statearr_37868_40223[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (15))){
var inst_37730 = (state_37812[(15)]);
var inst_37776 = (state_37812[(16)]);
var inst_37776__$1 = cljs.core.empty_QMARK_(inst_37730);
var state_37812__$1 = (function (){var statearr_37876 = state_37812;
(statearr_37876[(16)] = inst_37776__$1);

return statearr_37876;
})();
if(inst_37776__$1){
var statearr_37877_40226 = state_37812__$1;
(statearr_37877_40226[(1)] = (17));

} else {
var statearr_37878_40227 = state_37812__$1;
(statearr_37878_40227[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (21))){
var inst_37729 = (state_37812[(12)]);
var inst_37725 = inst_37729;
var state_37812__$1 = (function (){var statearr_37880 = state_37812;
(statearr_37880[(10)] = inst_37725);

return statearr_37880;
})();
var statearr_37881_40228 = state_37812__$1;
(statearr_37881_40228[(2)] = null);

(statearr_37881_40228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (13))){
var inst_37767 = (state_37812[(2)]);
var inst_37768 = calc_state();
var inst_37725 = inst_37768;
var state_37812__$1 = (function (){var statearr_37885 = state_37812;
(statearr_37885[(17)] = inst_37767);

(statearr_37885[(10)] = inst_37725);

return statearr_37885;
})();
var statearr_37889_40229 = state_37812__$1;
(statearr_37889_40229[(2)] = null);

(statearr_37889_40229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (22))){
var inst_37805 = (state_37812[(2)]);
var state_37812__$1 = state_37812;
var statearr_37892_40230 = state_37812__$1;
(statearr_37892_40230[(2)] = inst_37805);

(statearr_37892_40230[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (6))){
var inst_37743 = (state_37812[(14)]);
var inst_37751 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37743,change);
var state_37812__$1 = state_37812;
var statearr_37896_40231 = state_37812__$1;
(statearr_37896_40231[(2)] = inst_37751);

(statearr_37896_40231[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (25))){
var state_37812__$1 = state_37812;
var statearr_37900_40232 = state_37812__$1;
(statearr_37900_40232[(2)] = null);

(statearr_37900_40232[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (17))){
var inst_37743 = (state_37812[(14)]);
var inst_37731 = (state_37812[(18)]);
var inst_37781 = (inst_37731.cljs$core$IFn$_invoke$arity$1 ? inst_37731.cljs$core$IFn$_invoke$arity$1(inst_37743) : inst_37731.call(null,inst_37743));
var inst_37782 = cljs.core.not(inst_37781);
var state_37812__$1 = state_37812;
var statearr_37902_40234 = state_37812__$1;
(statearr_37902_40234[(2)] = inst_37782);

(statearr_37902_40234[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (3))){
var inst_37809 = (state_37812[(2)]);
var state_37812__$1 = state_37812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37812__$1,inst_37809);
} else {
if((state_val_37813 === (12))){
var state_37812__$1 = state_37812;
var statearr_37909_40237 = state_37812__$1;
(statearr_37909_40237[(2)] = null);

(statearr_37909_40237[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (2))){
var inst_37729 = (state_37812[(12)]);
var inst_37725 = (state_37812[(10)]);
var inst_37729__$1 = cljs.core.__destructure_map(inst_37725);
var inst_37730 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37729__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_37731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37729__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_37735 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37729__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_37812__$1 = (function (){var statearr_37913 = state_37812;
(statearr_37913[(12)] = inst_37729__$1);

(statearr_37913[(15)] = inst_37730);

(statearr_37913[(18)] = inst_37731);

return statearr_37913;
})();
return cljs.core.async.ioc_alts_BANG_(state_37812__$1,(4),inst_37735);
} else {
if((state_val_37813 === (23))){
var inst_37792 = (state_37812[(2)]);
var state_37812__$1 = state_37812;
if(cljs.core.truth_(inst_37792)){
var statearr_37916_40243 = state_37812__$1;
(statearr_37916_40243[(1)] = (24));

} else {
var statearr_37917_40244 = state_37812__$1;
(statearr_37917_40244[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (19))){
var inst_37785 = (state_37812[(2)]);
var state_37812__$1 = state_37812;
var statearr_37919_40245 = state_37812__$1;
(statearr_37919_40245[(2)] = inst_37785);

(statearr_37919_40245[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (11))){
var inst_37743 = (state_37812[(14)]);
var inst_37764 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_37743);
var state_37812__$1 = state_37812;
var statearr_37924_40246 = state_37812__$1;
(statearr_37924_40246[(2)] = inst_37764);

(statearr_37924_40246[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (9))){
var inst_37773 = (state_37812[(19)]);
var inst_37730 = (state_37812[(15)]);
var inst_37743 = (state_37812[(14)]);
var inst_37773__$1 = (inst_37730.cljs$core$IFn$_invoke$arity$1 ? inst_37730.cljs$core$IFn$_invoke$arity$1(inst_37743) : inst_37730.call(null,inst_37743));
var state_37812__$1 = (function (){var statearr_37929 = state_37812;
(statearr_37929[(19)] = inst_37773__$1);

return statearr_37929;
})();
if(cljs.core.truth_(inst_37773__$1)){
var statearr_37930_40247 = state_37812__$1;
(statearr_37930_40247[(1)] = (14));

} else {
var statearr_37935_40248 = state_37812__$1;
(statearr_37935_40248[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (5))){
var inst_37747 = (state_37812[(13)]);
var state_37812__$1 = state_37812;
var statearr_37939_40249 = state_37812__$1;
(statearr_37939_40249[(2)] = inst_37747);

(statearr_37939_40249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (14))){
var inst_37773 = (state_37812[(19)]);
var state_37812__$1 = state_37812;
var statearr_37940_40250 = state_37812__$1;
(statearr_37940_40250[(2)] = inst_37773);

(statearr_37940_40250[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (26))){
var inst_37801 = (state_37812[(2)]);
var state_37812__$1 = state_37812;
var statearr_37944_40251 = state_37812__$1;
(statearr_37944_40251[(2)] = inst_37801);

(statearr_37944_40251[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (16))){
var inst_37788 = (state_37812[(2)]);
var state_37812__$1 = state_37812;
if(cljs.core.truth_(inst_37788)){
var statearr_37950_40254 = state_37812__$1;
(statearr_37950_40254[(1)] = (20));

} else {
var statearr_37954_40255 = state_37812__$1;
(statearr_37954_40255[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (10))){
var inst_37807 = (state_37812[(2)]);
var state_37812__$1 = state_37812;
var statearr_37955_40256 = state_37812__$1;
(statearr_37955_40256[(2)] = inst_37807);

(statearr_37955_40256[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (18))){
var inst_37776 = (state_37812[(16)]);
var state_37812__$1 = state_37812;
var statearr_37957_40257 = state_37812__$1;
(statearr_37957_40257[(2)] = inst_37776);

(statearr_37957_40257[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_37813 === (8))){
var inst_37741 = (state_37812[(7)]);
var inst_37762 = (inst_37741 == null);
var state_37812__$1 = state_37812;
if(cljs.core.truth_(inst_37762)){
var statearr_37963_40267 = state_37812__$1;
(statearr_37963_40267[(1)] = (11));

} else {
var statearr_37965_40268 = state_37812__$1;
(statearr_37965_40268[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__28049__auto__ = null;
var cljs$core$async$mix_$_state_machine__28049__auto____0 = (function (){
var statearr_37968 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37968[(0)] = cljs$core$async$mix_$_state_machine__28049__auto__);

(statearr_37968[(1)] = (1));

return statearr_37968;
});
var cljs$core$async$mix_$_state_machine__28049__auto____1 = (function (state_37812){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_37812);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e37976){var ex__28052__auto__ = e37976;
var statearr_37977_40271 = state_37812;
(statearr_37977_40271[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_37812[(4)]))){
var statearr_37980_40272 = state_37812;
(statearr_37980_40272[(1)] = cljs.core.first((state_37812[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40273 = state_37812;
state_37812 = G__40273;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__28049__auto__ = function(state_37812){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__28049__auto____1.call(this,state_37812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__28049__auto____0;
cljs$core$async$mix_$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__28049__auto____1;
return cljs$core$async$mix_$_state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_37984 = f__28229__auto__();
(statearr_37984[(6)] = c__28228__auto___40206);

return statearr_37984;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_40280 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_40280(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_40282 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null,p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_40282(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_40286 = (function() {
var G__40287 = null;
var G__40287__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null,p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__40287__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null,p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__40287 = function(p,v){
switch(arguments.length){
case 1:
return G__40287__1.call(this,p);
case 2:
return G__40287__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__40287.cljs$core$IFn$_invoke$arity$1 = G__40287__1;
G__40287.cljs$core$IFn$_invoke$arity$2 = G__40287__2;
return G__40287;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__38028 = arguments.length;
switch (G__38028) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_40286(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_40286(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38040 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta38041){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta38041 = meta38041;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38040.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38042,meta38041__$1){
var self__ = this;
var _38042__$1 = this;
return (new cljs.core.async.t_cljs$core$async38040(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta38041__$1));
}));

(cljs.core.async.t_cljs$core$async38040.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38042){
var self__ = this;
var _38042__$1 = this;
return self__.meta38041;
}));

(cljs.core.async.t_cljs$core$async38040.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38040.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async38040.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38040.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async38040.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5823__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5823__auto__)){
var m = temp__5823__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async38040.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async38040.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async38040.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta38041","meta38041",-9307069,null)], null);
}));

(cljs.core.async.t_cljs$core$async38040.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38040.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38040");

(cljs.core.async.t_cljs$core$async38040.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async38040");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38040.
 */
cljs.core.async.__GT_t_cljs$core$async38040 = (function cljs$core$async$__GT_t_cljs$core$async38040(ch,topic_fn,buf_fn,mults,ensure_mult,meta38041){
return (new cljs.core.async.t_cljs$core$async38040(ch,topic_fn,buf_fn,mults,ensure_mult,meta38041));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__38033 = arguments.length;
switch (G__38033) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__38031_SHARP_){
if(cljs.core.truth_((p1__38031_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__38031_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__38031_SHARP_.call(null,topic)))){
return p1__38031_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__38031_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async38040(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__28228__auto___40310 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_38148){
var state_val_38149 = (state_38148[(1)]);
if((state_val_38149 === (7))){
var inst_38139 = (state_38148[(2)]);
var state_38148__$1 = state_38148;
var statearr_38157_40311 = state_38148__$1;
(statearr_38157_40311[(2)] = inst_38139);

(statearr_38157_40311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (20))){
var state_38148__$1 = state_38148;
var statearr_38158_40312 = state_38148__$1;
(statearr_38158_40312[(2)] = null);

(statearr_38158_40312[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (1))){
var state_38148__$1 = state_38148;
var statearr_38160_40313 = state_38148__$1;
(statearr_38160_40313[(2)] = null);

(statearr_38160_40313[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (24))){
var inst_38117 = (state_38148[(7)]);
var inst_38131 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_38117);
var state_38148__$1 = state_38148;
var statearr_38161_40314 = state_38148__$1;
(statearr_38161_40314[(2)] = inst_38131);

(statearr_38161_40314[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (4))){
var inst_38057 = (state_38148[(8)]);
var inst_38057__$1 = (state_38148[(2)]);
var inst_38058 = (inst_38057__$1 == null);
var state_38148__$1 = (function (){var statearr_38164 = state_38148;
(statearr_38164[(8)] = inst_38057__$1);

return statearr_38164;
})();
if(cljs.core.truth_(inst_38058)){
var statearr_38169_40319 = state_38148__$1;
(statearr_38169_40319[(1)] = (5));

} else {
var statearr_38173_40320 = state_38148__$1;
(statearr_38173_40320[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (15))){
var inst_38109 = (state_38148[(2)]);
var state_38148__$1 = state_38148;
var statearr_38174_40321 = state_38148__$1;
(statearr_38174_40321[(2)] = inst_38109);

(statearr_38174_40321[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (21))){
var inst_38136 = (state_38148[(2)]);
var state_38148__$1 = (function (){var statearr_38178 = state_38148;
(statearr_38178[(9)] = inst_38136);

return statearr_38178;
})();
var statearr_38180_40324 = state_38148__$1;
(statearr_38180_40324[(2)] = null);

(statearr_38180_40324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (13))){
var inst_38085 = (state_38148[(10)]);
var inst_38088 = cljs.core.chunked_seq_QMARK_(inst_38085);
var state_38148__$1 = state_38148;
if(inst_38088){
var statearr_38181_40327 = state_38148__$1;
(statearr_38181_40327[(1)] = (16));

} else {
var statearr_38182_40328 = state_38148__$1;
(statearr_38182_40328[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (22))){
var inst_38128 = (state_38148[(2)]);
var state_38148__$1 = state_38148;
if(cljs.core.truth_(inst_38128)){
var statearr_38183_40329 = state_38148__$1;
(statearr_38183_40329[(1)] = (23));

} else {
var statearr_38184_40330 = state_38148__$1;
(statearr_38184_40330[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (6))){
var inst_38117 = (state_38148[(7)]);
var inst_38057 = (state_38148[(8)]);
var inst_38119 = (state_38148[(11)]);
var inst_38117__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_38057) : topic_fn.call(null,inst_38057));
var inst_38118 = cljs.core.deref(mults);
var inst_38119__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38118,inst_38117__$1);
var state_38148__$1 = (function (){var statearr_38198 = state_38148;
(statearr_38198[(7)] = inst_38117__$1);

(statearr_38198[(11)] = inst_38119__$1);

return statearr_38198;
})();
if(cljs.core.truth_(inst_38119__$1)){
var statearr_38199_40331 = state_38148__$1;
(statearr_38199_40331[(1)] = (19));

} else {
var statearr_38200_40332 = state_38148__$1;
(statearr_38200_40332[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (25))){
var inst_38133 = (state_38148[(2)]);
var state_38148__$1 = state_38148;
var statearr_38207_40333 = state_38148__$1;
(statearr_38207_40333[(2)] = inst_38133);

(statearr_38207_40333[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (17))){
var inst_38085 = (state_38148[(10)]);
var inst_38095 = cljs.core.first(inst_38085);
var inst_38097 = cljs.core.async.muxch_STAR_(inst_38095);
var inst_38099 = cljs.core.async.close_BANG_(inst_38097);
var inst_38100 = cljs.core.next(inst_38085);
var inst_38068 = inst_38100;
var inst_38069 = null;
var inst_38070 = (0);
var inst_38071 = (0);
var state_38148__$1 = (function (){var statearr_38208 = state_38148;
(statearr_38208[(12)] = inst_38071);

(statearr_38208[(13)] = inst_38069);

(statearr_38208[(14)] = inst_38099);

(statearr_38208[(15)] = inst_38070);

(statearr_38208[(16)] = inst_38068);

return statearr_38208;
})();
var statearr_38209_40337 = state_38148__$1;
(statearr_38209_40337[(2)] = null);

(statearr_38209_40337[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (3))){
var inst_38141 = (state_38148[(2)]);
var state_38148__$1 = state_38148;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38148__$1,inst_38141);
} else {
if((state_val_38149 === (12))){
var inst_38111 = (state_38148[(2)]);
var state_38148__$1 = state_38148;
var statearr_38210_40340 = state_38148__$1;
(statearr_38210_40340[(2)] = inst_38111);

(statearr_38210_40340[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (2))){
var state_38148__$1 = state_38148;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38148__$1,(4),ch);
} else {
if((state_val_38149 === (23))){
var state_38148__$1 = state_38148;
var statearr_38221_40345 = state_38148__$1;
(statearr_38221_40345[(2)] = null);

(statearr_38221_40345[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (19))){
var inst_38057 = (state_38148[(8)]);
var inst_38119 = (state_38148[(11)]);
var inst_38126 = cljs.core.async.muxch_STAR_(inst_38119);
var state_38148__$1 = state_38148;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38148__$1,(22),inst_38126,inst_38057);
} else {
if((state_val_38149 === (11))){
var inst_38068 = (state_38148[(16)]);
var inst_38085 = (state_38148[(10)]);
var inst_38085__$1 = cljs.core.seq(inst_38068);
var state_38148__$1 = (function (){var statearr_38225 = state_38148;
(statearr_38225[(10)] = inst_38085__$1);

return statearr_38225;
})();
if(inst_38085__$1){
var statearr_38226_40350 = state_38148__$1;
(statearr_38226_40350[(1)] = (13));

} else {
var statearr_38227_40351 = state_38148__$1;
(statearr_38227_40351[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (9))){
var inst_38113 = (state_38148[(2)]);
var state_38148__$1 = state_38148;
var statearr_38232_40354 = state_38148__$1;
(statearr_38232_40354[(2)] = inst_38113);

(statearr_38232_40354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (5))){
var inst_38065 = cljs.core.deref(mults);
var inst_38066 = cljs.core.vals(inst_38065);
var inst_38067 = cljs.core.seq(inst_38066);
var inst_38068 = inst_38067;
var inst_38069 = null;
var inst_38070 = (0);
var inst_38071 = (0);
var state_38148__$1 = (function (){var statearr_38236 = state_38148;
(statearr_38236[(12)] = inst_38071);

(statearr_38236[(13)] = inst_38069);

(statearr_38236[(15)] = inst_38070);

(statearr_38236[(16)] = inst_38068);

return statearr_38236;
})();
var statearr_38237_40356 = state_38148__$1;
(statearr_38237_40356[(2)] = null);

(statearr_38237_40356[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (14))){
var state_38148__$1 = state_38148;
var statearr_38244_40359 = state_38148__$1;
(statearr_38244_40359[(2)] = null);

(statearr_38244_40359[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (16))){
var inst_38085 = (state_38148[(10)]);
var inst_38090 = cljs.core.chunk_first(inst_38085);
var inst_38091 = cljs.core.chunk_rest(inst_38085);
var inst_38092 = cljs.core.count(inst_38090);
var inst_38068 = inst_38091;
var inst_38069 = inst_38090;
var inst_38070 = inst_38092;
var inst_38071 = (0);
var state_38148__$1 = (function (){var statearr_38246 = state_38148;
(statearr_38246[(12)] = inst_38071);

(statearr_38246[(13)] = inst_38069);

(statearr_38246[(15)] = inst_38070);

(statearr_38246[(16)] = inst_38068);

return statearr_38246;
})();
var statearr_38247_40364 = state_38148__$1;
(statearr_38247_40364[(2)] = null);

(statearr_38247_40364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (10))){
var inst_38071 = (state_38148[(12)]);
var inst_38069 = (state_38148[(13)]);
var inst_38070 = (state_38148[(15)]);
var inst_38068 = (state_38148[(16)]);
var inst_38077 = cljs.core._nth(inst_38069,inst_38071);
var inst_38080 = cljs.core.async.muxch_STAR_(inst_38077);
var inst_38081 = cljs.core.async.close_BANG_(inst_38080);
var inst_38082 = (inst_38071 + (1));
var tmp38240 = inst_38069;
var tmp38241 = inst_38070;
var tmp38242 = inst_38068;
var inst_38068__$1 = tmp38242;
var inst_38069__$1 = tmp38240;
var inst_38070__$1 = tmp38241;
var inst_38071__$1 = inst_38082;
var state_38148__$1 = (function (){var statearr_38256 = state_38148;
(statearr_38256[(17)] = inst_38081);

(statearr_38256[(12)] = inst_38071__$1);

(statearr_38256[(13)] = inst_38069__$1);

(statearr_38256[(15)] = inst_38070__$1);

(statearr_38256[(16)] = inst_38068__$1);

return statearr_38256;
})();
var statearr_38258_40370 = state_38148__$1;
(statearr_38258_40370[(2)] = null);

(statearr_38258_40370[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (18))){
var inst_38106 = (state_38148[(2)]);
var state_38148__$1 = state_38148;
var statearr_38261_40372 = state_38148__$1;
(statearr_38261_40372[(2)] = inst_38106);

(statearr_38261_40372[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38149 === (8))){
var inst_38071 = (state_38148[(12)]);
var inst_38070 = (state_38148[(15)]);
var inst_38074 = (inst_38071 < inst_38070);
var inst_38075 = inst_38074;
var state_38148__$1 = state_38148;
if(cljs.core.truth_(inst_38075)){
var statearr_38263_40374 = state_38148__$1;
(statearr_38263_40374[(1)] = (10));

} else {
var statearr_38264_40379 = state_38148__$1;
(statearr_38264_40379[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_38269 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38269[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_38269[(1)] = (1));

return statearr_38269;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_38148){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_38148);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e38270){var ex__28052__auto__ = e38270;
var statearr_38271_40384 = state_38148;
(statearr_38271_40384[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_38148[(4)]))){
var statearr_38272_40386 = state_38148;
(statearr_38272_40386[(1)] = cljs.core.first((state_38148[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40387 = state_38148;
state_38148 = G__40387;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_38148){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_38148);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_38278 = f__28229__auto__();
(statearr_38278[(6)] = c__28228__auto___40310);

return statearr_38278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__38290 = arguments.length;
switch (G__38290) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__38299 = arguments.length;
switch (G__38299) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__38304 = arguments.length;
switch (G__38304) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__28228__auto___40401 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_38357){
var state_val_38358 = (state_38357[(1)]);
if((state_val_38358 === (7))){
var state_38357__$1 = state_38357;
var statearr_38362_40403 = state_38357__$1;
(statearr_38362_40403[(2)] = null);

(statearr_38362_40403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (1))){
var state_38357__$1 = state_38357;
var statearr_38363_40404 = state_38357__$1;
(statearr_38363_40404[(2)] = null);

(statearr_38363_40404[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (4))){
var inst_38312 = (state_38357[(7)]);
var inst_38313 = (state_38357[(8)]);
var inst_38318 = (inst_38313 < inst_38312);
var state_38357__$1 = state_38357;
if(cljs.core.truth_(inst_38318)){
var statearr_38364_40409 = state_38357__$1;
(statearr_38364_40409[(1)] = (6));

} else {
var statearr_38365_40411 = state_38357__$1;
(statearr_38365_40411[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (15))){
var inst_38342 = (state_38357[(9)]);
var inst_38347 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_38342);
var state_38357__$1 = state_38357;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38357__$1,(17),out,inst_38347);
} else {
if((state_val_38358 === (13))){
var inst_38342 = (state_38357[(9)]);
var inst_38342__$1 = (state_38357[(2)]);
var inst_38343 = cljs.core.some(cljs.core.nil_QMARK_,inst_38342__$1);
var state_38357__$1 = (function (){var statearr_38366 = state_38357;
(statearr_38366[(9)] = inst_38342__$1);

return statearr_38366;
})();
if(cljs.core.truth_(inst_38343)){
var statearr_38367_40413 = state_38357__$1;
(statearr_38367_40413[(1)] = (14));

} else {
var statearr_38368_40414 = state_38357__$1;
(statearr_38368_40414[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (6))){
var state_38357__$1 = state_38357;
var statearr_38369_40415 = state_38357__$1;
(statearr_38369_40415[(2)] = null);

(statearr_38369_40415[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (17))){
var inst_38349 = (state_38357[(2)]);
var state_38357__$1 = (function (){var statearr_38384 = state_38357;
(statearr_38384[(10)] = inst_38349);

return statearr_38384;
})();
var statearr_38386_40422 = state_38357__$1;
(statearr_38386_40422[(2)] = null);

(statearr_38386_40422[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (3))){
var inst_38354 = (state_38357[(2)]);
var state_38357__$1 = state_38357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38357__$1,inst_38354);
} else {
if((state_val_38358 === (12))){
var _ = (function (){var statearr_38387 = state_38357;
(statearr_38387[(4)] = cljs.core.rest((state_38357[(4)])));

return statearr_38387;
})();
var state_38357__$1 = state_38357;
var ex38379 = (state_38357__$1[(2)]);
var statearr_38388_40423 = state_38357__$1;
(statearr_38388_40423[(5)] = ex38379);


if((ex38379 instanceof Object)){
var statearr_38389_40424 = state_38357__$1;
(statearr_38389_40424[(1)] = (11));

(statearr_38389_40424[(5)] = null);

} else {
throw ex38379;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (2))){
var inst_38310 = cljs.core.reset_BANG_(dctr,cnt);
var inst_38312 = cnt;
var inst_38313 = (0);
var state_38357__$1 = (function (){var statearr_38395 = state_38357;
(statearr_38395[(11)] = inst_38310);

(statearr_38395[(7)] = inst_38312);

(statearr_38395[(8)] = inst_38313);

return statearr_38395;
})();
var statearr_38396_40426 = state_38357__$1;
(statearr_38396_40426[(2)] = null);

(statearr_38396_40426[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (11))){
var inst_38321 = (state_38357[(2)]);
var inst_38322 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_38357__$1 = (function (){var statearr_38397 = state_38357;
(statearr_38397[(12)] = inst_38321);

return statearr_38397;
})();
var statearr_38398_40427 = state_38357__$1;
(statearr_38398_40427[(2)] = inst_38322);

(statearr_38398_40427[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (9))){
var inst_38313 = (state_38357[(8)]);
var _ = (function (){var statearr_38399 = state_38357;
(statearr_38399[(4)] = cljs.core.cons((12),(state_38357[(4)])));

return statearr_38399;
})();
var inst_38328 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_38313) : chs__$1.call(null,inst_38313));
var inst_38329 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_38313) : done.call(null,inst_38313));
var inst_38330 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38328,inst_38329);
var ___$1 = (function (){var statearr_38402 = state_38357;
(statearr_38402[(4)] = cljs.core.rest((state_38357[(4)])));

return statearr_38402;
})();
var state_38357__$1 = state_38357;
var statearr_38405_40429 = state_38357__$1;
(statearr_38405_40429[(2)] = inst_38330);

(statearr_38405_40429[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (5))){
var inst_38340 = (state_38357[(2)]);
var state_38357__$1 = (function (){var statearr_38406 = state_38357;
(statearr_38406[(13)] = inst_38340);

return statearr_38406;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38357__$1,(13),dchan);
} else {
if((state_val_38358 === (14))){
var inst_38345 = cljs.core.async.close_BANG_(out);
var state_38357__$1 = state_38357;
var statearr_38407_40431 = state_38357__$1;
(statearr_38407_40431[(2)] = inst_38345);

(statearr_38407_40431[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (16))){
var inst_38352 = (state_38357[(2)]);
var state_38357__$1 = state_38357;
var statearr_38411_40436 = state_38357__$1;
(statearr_38411_40436[(2)] = inst_38352);

(statearr_38411_40436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (10))){
var inst_38313 = (state_38357[(8)]);
var inst_38333 = (state_38357[(2)]);
var inst_38334 = (inst_38313 + (1));
var inst_38313__$1 = inst_38334;
var state_38357__$1 = (function (){var statearr_38415 = state_38357;
(statearr_38415[(14)] = inst_38333);

(statearr_38415[(8)] = inst_38313__$1);

return statearr_38415;
})();
var statearr_38416_40438 = state_38357__$1;
(statearr_38416_40438[(2)] = null);

(statearr_38416_40438[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38358 === (8))){
var inst_38338 = (state_38357[(2)]);
var state_38357__$1 = state_38357;
var statearr_38418_40439 = state_38357__$1;
(statearr_38418_40439[(2)] = inst_38338);

(statearr_38418_40439[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_38422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38422[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_38422[(1)] = (1));

return statearr_38422;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_38357){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_38357);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e38423){var ex__28052__auto__ = e38423;
var statearr_38424_40456 = state_38357;
(statearr_38424_40456[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_38357[(4)]))){
var statearr_38425_40457 = state_38357;
(statearr_38425_40457[(1)] = cljs.core.first((state_38357[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40462 = state_38357;
state_38357 = G__40462;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_38357){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_38357);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_38433 = f__28229__auto__();
(statearr_38433[(6)] = c__28228__auto___40401);

return statearr_38433;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__38436 = arguments.length;
switch (G__38436) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28228__auto___40477 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_38474){
var state_val_38475 = (state_38474[(1)]);
if((state_val_38475 === (7))){
var inst_38452 = (state_38474[(7)]);
var inst_38451 = (state_38474[(8)]);
var inst_38451__$1 = (state_38474[(2)]);
var inst_38452__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38451__$1,(0),null);
var inst_38453 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38451__$1,(1),null);
var inst_38454 = (inst_38452__$1 == null);
var state_38474__$1 = (function (){var statearr_38479 = state_38474;
(statearr_38479[(7)] = inst_38452__$1);

(statearr_38479[(9)] = inst_38453);

(statearr_38479[(8)] = inst_38451__$1);

return statearr_38479;
})();
if(cljs.core.truth_(inst_38454)){
var statearr_38480_40486 = state_38474__$1;
(statearr_38480_40486[(1)] = (8));

} else {
var statearr_38481_40487 = state_38474__$1;
(statearr_38481_40487[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38475 === (1))){
var inst_38437 = cljs.core.vec(chs);
var inst_38438 = inst_38437;
var state_38474__$1 = (function (){var statearr_38485 = state_38474;
(statearr_38485[(10)] = inst_38438);

return statearr_38485;
})();
var statearr_38487_40489 = state_38474__$1;
(statearr_38487_40489[(2)] = null);

(statearr_38487_40489[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38475 === (4))){
var inst_38438 = (state_38474[(10)]);
var state_38474__$1 = state_38474;
return cljs.core.async.ioc_alts_BANG_(state_38474__$1,(7),inst_38438);
} else {
if((state_val_38475 === (6))){
var inst_38470 = (state_38474[(2)]);
var state_38474__$1 = state_38474;
var statearr_38495_40491 = state_38474__$1;
(statearr_38495_40491[(2)] = inst_38470);

(statearr_38495_40491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38475 === (3))){
var inst_38472 = (state_38474[(2)]);
var state_38474__$1 = state_38474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38474__$1,inst_38472);
} else {
if((state_val_38475 === (2))){
var inst_38438 = (state_38474[(10)]);
var inst_38441 = cljs.core.count(inst_38438);
var inst_38442 = (inst_38441 > (0));
var state_38474__$1 = state_38474;
if(cljs.core.truth_(inst_38442)){
var statearr_38497_40494 = state_38474__$1;
(statearr_38497_40494[(1)] = (4));

} else {
var statearr_38498_40495 = state_38474__$1;
(statearr_38498_40495[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38475 === (11))){
var inst_38438 = (state_38474[(10)]);
var inst_38463 = (state_38474[(2)]);
var tmp38496 = inst_38438;
var inst_38438__$1 = tmp38496;
var state_38474__$1 = (function (){var statearr_38500 = state_38474;
(statearr_38500[(11)] = inst_38463);

(statearr_38500[(10)] = inst_38438__$1);

return statearr_38500;
})();
var statearr_38502_40496 = state_38474__$1;
(statearr_38502_40496[(2)] = null);

(statearr_38502_40496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38475 === (9))){
var inst_38452 = (state_38474[(7)]);
var state_38474__$1 = state_38474;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38474__$1,(11),out,inst_38452);
} else {
if((state_val_38475 === (5))){
var inst_38468 = cljs.core.async.close_BANG_(out);
var state_38474__$1 = state_38474;
var statearr_38506_40498 = state_38474__$1;
(statearr_38506_40498[(2)] = inst_38468);

(statearr_38506_40498[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38475 === (10))){
var inst_38466 = (state_38474[(2)]);
var state_38474__$1 = state_38474;
var statearr_38511_40505 = state_38474__$1;
(statearr_38511_40505[(2)] = inst_38466);

(statearr_38511_40505[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38475 === (8))){
var inst_38452 = (state_38474[(7)]);
var inst_38453 = (state_38474[(9)]);
var inst_38451 = (state_38474[(8)]);
var inst_38438 = (state_38474[(10)]);
var inst_38456 = (function (){var cs = inst_38438;
var vec__38446 = inst_38451;
var v = inst_38452;
var c = inst_38453;
return (function (p1__38434_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__38434_SHARP_);
});
})();
var inst_38457 = cljs.core.filterv(inst_38456,inst_38438);
var inst_38438__$1 = inst_38457;
var state_38474__$1 = (function (){var statearr_38514 = state_38474;
(statearr_38514[(10)] = inst_38438__$1);

return statearr_38514;
})();
var statearr_38515_40509 = state_38474__$1;
(statearr_38515_40509[(2)] = null);

(statearr_38515_40509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_38516 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38516[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_38516[(1)] = (1));

return statearr_38516;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_38474){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_38474);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e38517){var ex__28052__auto__ = e38517;
var statearr_38518_40519 = state_38474;
(statearr_38518_40519[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_38474[(4)]))){
var statearr_38519_40520 = state_38474;
(statearr_38519_40520[(1)] = cljs.core.first((state_38474[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40525 = state_38474;
state_38474 = G__40525;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_38474){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_38474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_38520 = f__28229__auto__();
(statearr_38520[(6)] = c__28228__auto___40477);

return statearr_38520;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__38528 = arguments.length;
switch (G__38528) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28228__auto___40541 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_38568){
var state_val_38569 = (state_38568[(1)]);
if((state_val_38569 === (7))){
var inst_38549 = (state_38568[(7)]);
var inst_38549__$1 = (state_38568[(2)]);
var inst_38550 = (inst_38549__$1 == null);
var inst_38551 = cljs.core.not(inst_38550);
var state_38568__$1 = (function (){var statearr_38576 = state_38568;
(statearr_38576[(7)] = inst_38549__$1);

return statearr_38576;
})();
if(inst_38551){
var statearr_38577_40545 = state_38568__$1;
(statearr_38577_40545[(1)] = (8));

} else {
var statearr_38578_40546 = state_38568__$1;
(statearr_38578_40546[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38569 === (1))){
var inst_38542 = (0);
var state_38568__$1 = (function (){var statearr_38580 = state_38568;
(statearr_38580[(8)] = inst_38542);

return statearr_38580;
})();
var statearr_38586_40547 = state_38568__$1;
(statearr_38586_40547[(2)] = null);

(statearr_38586_40547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38569 === (4))){
var state_38568__$1 = state_38568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38568__$1,(7),ch);
} else {
if((state_val_38569 === (6))){
var inst_38562 = (state_38568[(2)]);
var state_38568__$1 = state_38568;
var statearr_38588_40553 = state_38568__$1;
(statearr_38588_40553[(2)] = inst_38562);

(statearr_38588_40553[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38569 === (3))){
var inst_38564 = (state_38568[(2)]);
var inst_38566 = cljs.core.async.close_BANG_(out);
var state_38568__$1 = (function (){var statearr_38595 = state_38568;
(statearr_38595[(9)] = inst_38564);

return statearr_38595;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38568__$1,inst_38566);
} else {
if((state_val_38569 === (2))){
var inst_38542 = (state_38568[(8)]);
var inst_38546 = (inst_38542 < n);
var state_38568__$1 = state_38568;
if(cljs.core.truth_(inst_38546)){
var statearr_38597_40556 = state_38568__$1;
(statearr_38597_40556[(1)] = (4));

} else {
var statearr_38599_40560 = state_38568__$1;
(statearr_38599_40560[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38569 === (11))){
var inst_38542 = (state_38568[(8)]);
var inst_38554 = (state_38568[(2)]);
var inst_38555 = (inst_38542 + (1));
var inst_38542__$1 = inst_38555;
var state_38568__$1 = (function (){var statearr_38602 = state_38568;
(statearr_38602[(8)] = inst_38542__$1);

(statearr_38602[(10)] = inst_38554);

return statearr_38602;
})();
var statearr_38603_40562 = state_38568__$1;
(statearr_38603_40562[(2)] = null);

(statearr_38603_40562[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38569 === (9))){
var state_38568__$1 = state_38568;
var statearr_38608_40563 = state_38568__$1;
(statearr_38608_40563[(2)] = null);

(statearr_38608_40563[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38569 === (5))){
var state_38568__$1 = state_38568;
var statearr_38609_40565 = state_38568__$1;
(statearr_38609_40565[(2)] = null);

(statearr_38609_40565[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38569 === (10))){
var inst_38559 = (state_38568[(2)]);
var state_38568__$1 = state_38568;
var statearr_38612_40567 = state_38568__$1;
(statearr_38612_40567[(2)] = inst_38559);

(statearr_38612_40567[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38569 === (8))){
var inst_38549 = (state_38568[(7)]);
var state_38568__$1 = state_38568;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38568__$1,(11),out,inst_38549);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_38615 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38615[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_38615[(1)] = (1));

return statearr_38615;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_38568){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_38568);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e38619){var ex__28052__auto__ = e38619;
var statearr_38620_40582 = state_38568;
(statearr_38620_40582[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_38568[(4)]))){
var statearr_38621_40584 = state_38568;
(statearr_38621_40584[(1)] = cljs.core.first((state_38568[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40595 = state_38568;
state_38568 = G__40595;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_38568){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_38568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_38628 = f__28229__auto__();
(statearr_38628[(6)] = c__28228__auto___40541);

return statearr_38628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38660 = (function (f,ch,meta38635,_,fn1,meta38661){
this.f = f;
this.ch = ch;
this.meta38635 = meta38635;
this._ = _;
this.fn1 = fn1;
this.meta38661 = meta38661;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38660.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38662,meta38661__$1){
var self__ = this;
var _38662__$1 = this;
return (new cljs.core.async.t_cljs$core$async38660(self__.f,self__.ch,self__.meta38635,self__._,self__.fn1,meta38661__$1));
}));

(cljs.core.async.t_cljs$core$async38660.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38662){
var self__ = this;
var _38662__$1 = this;
return self__.meta38661;
}));

(cljs.core.async.t_cljs$core$async38660.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38660.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async38660.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async38660.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__38630_SHARP_){
var G__38688 = (((p1__38630_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__38630_SHARP_) : self__.f.call(null,p1__38630_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__38688) : f1.call(null,G__38688));
});
}));

(cljs.core.async.t_cljs$core$async38660.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38635","meta38635",641329002,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async38634","cljs.core.async/t_cljs$core$async38634",2092005988,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta38661","meta38661",1267759776,null)], null);
}));

(cljs.core.async.t_cljs$core$async38660.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38660.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38660");

(cljs.core.async.t_cljs$core$async38660.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async38660");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38660.
 */
cljs.core.async.__GT_t_cljs$core$async38660 = (function cljs$core$async$__GT_t_cljs$core$async38660(f,ch,meta38635,_,fn1,meta38661){
return (new cljs.core.async.t_cljs$core$async38660(f,ch,meta38635,_,fn1,meta38661));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38634 = (function (f,ch,meta38635){
this.f = f;
this.ch = ch;
this.meta38635 = meta38635;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38634.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38636,meta38635__$1){
var self__ = this;
var _38636__$1 = this;
return (new cljs.core.async.t_cljs$core$async38634(self__.f,self__.ch,meta38635__$1));
}));

(cljs.core.async.t_cljs$core$async38634.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38636){
var self__ = this;
var _38636__$1 = this;
return self__.meta38635;
}));

(cljs.core.async.t_cljs$core$async38634.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38634.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38634.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38634.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38634.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async38660(self__.f,self__.ch,self__.meta38635,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__38711 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__38711) : self__.f.call(null,G__38711));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async38634.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38634.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async38634.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38635","meta38635",641329002,null)], null);
}));

(cljs.core.async.t_cljs$core$async38634.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38634.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38634");

(cljs.core.async.t_cljs$core$async38634.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async38634");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38634.
 */
cljs.core.async.__GT_t_cljs$core$async38634 = (function cljs$core$async$__GT_t_cljs$core$async38634(f,ch,meta38635){
return (new cljs.core.async.t_cljs$core$async38634(f,ch,meta38635));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async38634(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38720 = (function (f,ch,meta38721){
this.f = f;
this.ch = ch;
this.meta38721 = meta38721;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38720.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38722,meta38721__$1){
var self__ = this;
var _38722__$1 = this;
return (new cljs.core.async.t_cljs$core$async38720(self__.f,self__.ch,meta38721__$1));
}));

(cljs.core.async.t_cljs$core$async38720.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38722){
var self__ = this;
var _38722__$1 = this;
return self__.meta38721;
}));

(cljs.core.async.t_cljs$core$async38720.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38720.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38720.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38720.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async38720.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38720.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async38720.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38721","meta38721",241772501,null)], null);
}));

(cljs.core.async.t_cljs$core$async38720.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38720.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38720");

(cljs.core.async.t_cljs$core$async38720.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async38720");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38720.
 */
cljs.core.async.__GT_t_cljs$core$async38720 = (function cljs$core$async$__GT_t_cljs$core$async38720(f,ch,meta38721){
return (new cljs.core.async.t_cljs$core$async38720(f,ch,meta38721));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async38720(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38744 = (function (p,ch,meta38745){
this.p = p;
this.ch = ch;
this.meta38745 = meta38745;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async38744.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38746,meta38745__$1){
var self__ = this;
var _38746__$1 = this;
return (new cljs.core.async.t_cljs$core$async38744(self__.p,self__.ch,meta38745__$1));
}));

(cljs.core.async.t_cljs$core$async38744.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38746){
var self__ = this;
var _38746__$1 = this;
return self__.meta38745;
}));

(cljs.core.async.t_cljs$core$async38744.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38744.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38744.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async38744.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38744.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async38744.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async38744.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async38744.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta38745","meta38745",-1280791638,null)], null);
}));

(cljs.core.async.t_cljs$core$async38744.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async38744.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38744");

(cljs.core.async.t_cljs$core$async38744.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async38744");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async38744.
 */
cljs.core.async.__GT_t_cljs$core$async38744 = (function cljs$core$async$__GT_t_cljs$core$async38744(p,ch,meta38745){
return (new cljs.core.async.t_cljs$core$async38744(p,ch,meta38745));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async38744(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__38756 = arguments.length;
switch (G__38756) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28228__auto___40761 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_38802){
var state_val_38803 = (state_38802[(1)]);
if((state_val_38803 === (7))){
var inst_38791 = (state_38802[(2)]);
var state_38802__$1 = state_38802;
var statearr_38813_40766 = state_38802__$1;
(statearr_38813_40766[(2)] = inst_38791);

(statearr_38813_40766[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38803 === (1))){
var state_38802__$1 = state_38802;
var statearr_38814_40767 = state_38802__$1;
(statearr_38814_40767[(2)] = null);

(statearr_38814_40767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38803 === (4))){
var inst_38764 = (state_38802[(7)]);
var inst_38764__$1 = (state_38802[(2)]);
var inst_38766 = (inst_38764__$1 == null);
var state_38802__$1 = (function (){var statearr_38815 = state_38802;
(statearr_38815[(7)] = inst_38764__$1);

return statearr_38815;
})();
if(cljs.core.truth_(inst_38766)){
var statearr_38816_40775 = state_38802__$1;
(statearr_38816_40775[(1)] = (5));

} else {
var statearr_38817_40776 = state_38802__$1;
(statearr_38817_40776[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38803 === (6))){
var inst_38764 = (state_38802[(7)]);
var inst_38776 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38764) : p.call(null,inst_38764));
var state_38802__$1 = state_38802;
if(cljs.core.truth_(inst_38776)){
var statearr_38818_40777 = state_38802__$1;
(statearr_38818_40777[(1)] = (8));

} else {
var statearr_38819_40779 = state_38802__$1;
(statearr_38819_40779[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38803 === (3))){
var inst_38793 = (state_38802[(2)]);
var state_38802__$1 = state_38802;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38802__$1,inst_38793);
} else {
if((state_val_38803 === (2))){
var state_38802__$1 = state_38802;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38802__$1,(4),ch);
} else {
if((state_val_38803 === (11))){
var inst_38782 = (state_38802[(2)]);
var state_38802__$1 = state_38802;
var statearr_38820_40791 = state_38802__$1;
(statearr_38820_40791[(2)] = inst_38782);

(statearr_38820_40791[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38803 === (9))){
var state_38802__$1 = state_38802;
var statearr_38822_40797 = state_38802__$1;
(statearr_38822_40797[(2)] = null);

(statearr_38822_40797[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38803 === (5))){
var inst_38769 = cljs.core.async.close_BANG_(out);
var state_38802__$1 = state_38802;
var statearr_38826_40814 = state_38802__$1;
(statearr_38826_40814[(2)] = inst_38769);

(statearr_38826_40814[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38803 === (10))){
var inst_38786 = (state_38802[(2)]);
var state_38802__$1 = (function (){var statearr_38827 = state_38802;
(statearr_38827[(8)] = inst_38786);

return statearr_38827;
})();
var statearr_38828_40822 = state_38802__$1;
(statearr_38828_40822[(2)] = null);

(statearr_38828_40822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38803 === (8))){
var inst_38764 = (state_38802[(7)]);
var state_38802__$1 = state_38802;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38802__$1,(11),out,inst_38764);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_38829 = [null,null,null,null,null,null,null,null,null];
(statearr_38829[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_38829[(1)] = (1));

return statearr_38829;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_38802){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_38802);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e38833){var ex__28052__auto__ = e38833;
var statearr_38835_40825 = state_38802;
(statearr_38835_40825[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_38802[(4)]))){
var statearr_38836_40826 = state_38802;
(statearr_38836_40826[(1)] = cljs.core.first((state_38802[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40828 = state_38802;
state_38802 = G__40828;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_38802){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_38802);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_38837 = f__28229__auto__();
(statearr_38837[(6)] = c__28228__auto___40761);

return statearr_38837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__38843 = arguments.length;
switch (G__38843) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__28228__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_38927){
var state_val_38928 = (state_38927[(1)]);
if((state_val_38928 === (7))){
var inst_38920 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
var statearr_38932_40857 = state_38927__$1;
(statearr_38932_40857[(2)] = inst_38920);

(statearr_38932_40857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (20))){
var inst_38887 = (state_38927[(7)]);
var inst_38899 = (state_38927[(2)]);
var inst_38900 = cljs.core.next(inst_38887);
var inst_38871 = inst_38900;
var inst_38872 = null;
var inst_38873 = (0);
var inst_38874 = (0);
var state_38927__$1 = (function (){var statearr_38936 = state_38927;
(statearr_38936[(8)] = inst_38873);

(statearr_38936[(9)] = inst_38872);

(statearr_38936[(10)] = inst_38874);

(statearr_38936[(11)] = inst_38899);

(statearr_38936[(12)] = inst_38871);

return statearr_38936;
})();
var statearr_38943_40869 = state_38927__$1;
(statearr_38943_40869[(2)] = null);

(statearr_38943_40869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (1))){
var state_38927__$1 = state_38927;
var statearr_38946_40875 = state_38927__$1;
(statearr_38946_40875[(2)] = null);

(statearr_38946_40875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (4))){
var inst_38854 = (state_38927[(13)]);
var inst_38854__$1 = (state_38927[(2)]);
var inst_38861 = (inst_38854__$1 == null);
var state_38927__$1 = (function (){var statearr_38948 = state_38927;
(statearr_38948[(13)] = inst_38854__$1);

return statearr_38948;
})();
if(cljs.core.truth_(inst_38861)){
var statearr_38951_40877 = state_38927__$1;
(statearr_38951_40877[(1)] = (5));

} else {
var statearr_38953_40878 = state_38927__$1;
(statearr_38953_40878[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (15))){
var state_38927__$1 = state_38927;
var statearr_38957_40885 = state_38927__$1;
(statearr_38957_40885[(2)] = null);

(statearr_38957_40885[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (21))){
var state_38927__$1 = state_38927;
var statearr_38958_40890 = state_38927__$1;
(statearr_38958_40890[(2)] = null);

(statearr_38958_40890[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (13))){
var inst_38873 = (state_38927[(8)]);
var inst_38872 = (state_38927[(9)]);
var inst_38874 = (state_38927[(10)]);
var inst_38871 = (state_38927[(12)]);
var inst_38882 = (state_38927[(2)]);
var inst_38884 = (inst_38874 + (1));
var tmp38954 = inst_38873;
var tmp38955 = inst_38872;
var tmp38956 = inst_38871;
var inst_38871__$1 = tmp38956;
var inst_38872__$1 = tmp38955;
var inst_38873__$1 = tmp38954;
var inst_38874__$1 = inst_38884;
var state_38927__$1 = (function (){var statearr_38961 = state_38927;
(statearr_38961[(8)] = inst_38873__$1);

(statearr_38961[(9)] = inst_38872__$1);

(statearr_38961[(10)] = inst_38874__$1);

(statearr_38961[(14)] = inst_38882);

(statearr_38961[(12)] = inst_38871__$1);

return statearr_38961;
})();
var statearr_38963_40909 = state_38927__$1;
(statearr_38963_40909[(2)] = null);

(statearr_38963_40909[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (22))){
var state_38927__$1 = state_38927;
var statearr_38964_40910 = state_38927__$1;
(statearr_38964_40910[(2)] = null);

(statearr_38964_40910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (6))){
var inst_38854 = (state_38927[(13)]);
var inst_38869 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_38854) : f.call(null,inst_38854));
var inst_38870 = cljs.core.seq(inst_38869);
var inst_38871 = inst_38870;
var inst_38872 = null;
var inst_38873 = (0);
var inst_38874 = (0);
var state_38927__$1 = (function (){var statearr_38965 = state_38927;
(statearr_38965[(8)] = inst_38873);

(statearr_38965[(9)] = inst_38872);

(statearr_38965[(10)] = inst_38874);

(statearr_38965[(12)] = inst_38871);

return statearr_38965;
})();
var statearr_38966_40924 = state_38927__$1;
(statearr_38966_40924[(2)] = null);

(statearr_38966_40924[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (17))){
var inst_38887 = (state_38927[(7)]);
var inst_38891 = cljs.core.chunk_first(inst_38887);
var inst_38892 = cljs.core.chunk_rest(inst_38887);
var inst_38893 = cljs.core.count(inst_38891);
var inst_38871 = inst_38892;
var inst_38872 = inst_38891;
var inst_38873 = inst_38893;
var inst_38874 = (0);
var state_38927__$1 = (function (){var statearr_38972 = state_38927;
(statearr_38972[(8)] = inst_38873);

(statearr_38972[(9)] = inst_38872);

(statearr_38972[(10)] = inst_38874);

(statearr_38972[(12)] = inst_38871);

return statearr_38972;
})();
var statearr_38978_40934 = state_38927__$1;
(statearr_38978_40934[(2)] = null);

(statearr_38978_40934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (3))){
var inst_38922 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38927__$1,inst_38922);
} else {
if((state_val_38928 === (12))){
var inst_38908 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
var statearr_38981_40935 = state_38927__$1;
(statearr_38981_40935[(2)] = inst_38908);

(statearr_38981_40935[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (2))){
var state_38927__$1 = state_38927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38927__$1,(4),in$);
} else {
if((state_val_38928 === (23))){
var inst_38918 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
var statearr_38984_40936 = state_38927__$1;
(statearr_38984_40936[(2)] = inst_38918);

(statearr_38984_40936[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (19))){
var inst_38903 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
var statearr_39000_40941 = state_38927__$1;
(statearr_39000_40941[(2)] = inst_38903);

(statearr_39000_40941[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (11))){
var inst_38871 = (state_38927[(12)]);
var inst_38887 = (state_38927[(7)]);
var inst_38887__$1 = cljs.core.seq(inst_38871);
var state_38927__$1 = (function (){var statearr_39008 = state_38927;
(statearr_39008[(7)] = inst_38887__$1);

return statearr_39008;
})();
if(inst_38887__$1){
var statearr_39009_40944 = state_38927__$1;
(statearr_39009_40944[(1)] = (14));

} else {
var statearr_39018_40945 = state_38927__$1;
(statearr_39018_40945[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (9))){
var inst_38910 = (state_38927[(2)]);
var inst_38912 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_38927__$1 = (function (){var statearr_39021 = state_38927;
(statearr_39021[(15)] = inst_38910);

return statearr_39021;
})();
if(cljs.core.truth_(inst_38912)){
var statearr_39030_40946 = state_38927__$1;
(statearr_39030_40946[(1)] = (21));

} else {
var statearr_39034_40947 = state_38927__$1;
(statearr_39034_40947[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (5))){
var inst_38863 = cljs.core.async.close_BANG_(out);
var state_38927__$1 = state_38927;
var statearr_39035_40948 = state_38927__$1;
(statearr_39035_40948[(2)] = inst_38863);

(statearr_39035_40948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (14))){
var inst_38887 = (state_38927[(7)]);
var inst_38889 = cljs.core.chunked_seq_QMARK_(inst_38887);
var state_38927__$1 = state_38927;
if(inst_38889){
var statearr_39046_40950 = state_38927__$1;
(statearr_39046_40950[(1)] = (17));

} else {
var statearr_39047_40951 = state_38927__$1;
(statearr_39047_40951[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (16))){
var inst_38906 = (state_38927[(2)]);
var state_38927__$1 = state_38927;
var statearr_39049_40956 = state_38927__$1;
(statearr_39049_40956[(2)] = inst_38906);

(statearr_39049_40956[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_38928 === (10))){
var inst_38872 = (state_38927[(9)]);
var inst_38874 = (state_38927[(10)]);
var inst_38880 = cljs.core._nth(inst_38872,inst_38874);
var state_38927__$1 = state_38927;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38927__$1,(13),out,inst_38880);
} else {
if((state_val_38928 === (18))){
var inst_38887 = (state_38927[(7)]);
var inst_38896 = cljs.core.first(inst_38887);
var state_38927__$1 = state_38927;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38927__$1,(20),out,inst_38896);
} else {
if((state_val_38928 === (8))){
var inst_38873 = (state_38927[(8)]);
var inst_38874 = (state_38927[(10)]);
var inst_38877 = (inst_38874 < inst_38873);
var inst_38878 = inst_38877;
var state_38927__$1 = state_38927;
if(cljs.core.truth_(inst_38878)){
var statearr_39050_40963 = state_38927__$1;
(statearr_39050_40963[(1)] = (10));

} else {
var statearr_39051_40964 = state_38927__$1;
(statearr_39051_40964[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__28049__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__28049__auto____0 = (function (){
var statearr_39059 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39059[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__28049__auto__);

(statearr_39059[(1)] = (1));

return statearr_39059;
});
var cljs$core$async$mapcat_STAR__$_state_machine__28049__auto____1 = (function (state_38927){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_38927);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e39063){var ex__28052__auto__ = e39063;
var statearr_39064_40971 = state_38927;
(statearr_39064_40971[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_38927[(4)]))){
var statearr_39065_40974 = state_38927;
(statearr_39065_40974[(1)] = cljs.core.first((state_38927[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__40975 = state_38927;
state_38927 = G__40975;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__28049__auto__ = function(state_38927){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__28049__auto____1.call(this,state_38927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__28049__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__28049__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_39066 = f__28229__auto__();
(statearr_39066[(6)] = c__28228__auto__);

return statearr_39066;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));

return c__28228__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__39075 = arguments.length;
switch (G__39075) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__39095 = arguments.length;
switch (G__39095) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__39099 = arguments.length;
switch (G__39099) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28228__auto___40998 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_39128){
var state_val_39129 = (state_39128[(1)]);
if((state_val_39129 === (7))){
var inst_39123 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
var statearr_39131_40999 = state_39128__$1;
(statearr_39131_40999[(2)] = inst_39123);

(statearr_39131_40999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (1))){
var inst_39103 = null;
var state_39128__$1 = (function (){var statearr_39135 = state_39128;
(statearr_39135[(7)] = inst_39103);

return statearr_39135;
})();
var statearr_39136_41000 = state_39128__$1;
(statearr_39136_41000[(2)] = null);

(statearr_39136_41000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (4))){
var inst_39106 = (state_39128[(8)]);
var inst_39106__$1 = (state_39128[(2)]);
var inst_39107 = (inst_39106__$1 == null);
var inst_39108 = cljs.core.not(inst_39107);
var state_39128__$1 = (function (){var statearr_39137 = state_39128;
(statearr_39137[(8)] = inst_39106__$1);

return statearr_39137;
})();
if(inst_39108){
var statearr_39138_41001 = state_39128__$1;
(statearr_39138_41001[(1)] = (5));

} else {
var statearr_39139_41002 = state_39128__$1;
(statearr_39139_41002[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (6))){
var state_39128__$1 = state_39128;
var statearr_39141_41003 = state_39128__$1;
(statearr_39141_41003[(2)] = null);

(statearr_39141_41003[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (3))){
var inst_39125 = (state_39128[(2)]);
var inst_39126 = cljs.core.async.close_BANG_(out);
var state_39128__$1 = (function (){var statearr_39142 = state_39128;
(statearr_39142[(9)] = inst_39125);

return statearr_39142;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_39128__$1,inst_39126);
} else {
if((state_val_39129 === (2))){
var state_39128__$1 = state_39128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39128__$1,(4),ch);
} else {
if((state_val_39129 === (11))){
var inst_39106 = (state_39128[(8)]);
var inst_39117 = (state_39128[(2)]);
var inst_39103 = inst_39106;
var state_39128__$1 = (function (){var statearr_39147 = state_39128;
(statearr_39147[(10)] = inst_39117);

(statearr_39147[(7)] = inst_39103);

return statearr_39147;
})();
var statearr_39148_41011 = state_39128__$1;
(statearr_39148_41011[(2)] = null);

(statearr_39148_41011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (9))){
var inst_39106 = (state_39128[(8)]);
var state_39128__$1 = state_39128;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39128__$1,(11),out,inst_39106);
} else {
if((state_val_39129 === (5))){
var inst_39106 = (state_39128[(8)]);
var inst_39103 = (state_39128[(7)]);
var inst_39110 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39106,inst_39103);
var state_39128__$1 = state_39128;
if(inst_39110){
var statearr_39150_41016 = state_39128__$1;
(statearr_39150_41016[(1)] = (8));

} else {
var statearr_39154_41017 = state_39128__$1;
(statearr_39154_41017[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (10))){
var inst_39120 = (state_39128[(2)]);
var state_39128__$1 = state_39128;
var statearr_39155_41022 = state_39128__$1;
(statearr_39155_41022[(2)] = inst_39120);

(statearr_39155_41022[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39129 === (8))){
var inst_39103 = (state_39128[(7)]);
var tmp39149 = inst_39103;
var inst_39103__$1 = tmp39149;
var state_39128__$1 = (function (){var statearr_39156 = state_39128;
(statearr_39156[(7)] = inst_39103__$1);

return statearr_39156;
})();
var statearr_39157_41027 = state_39128__$1;
(statearr_39157_41027[(2)] = null);

(statearr_39157_41027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_39158 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_39158[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_39158[(1)] = (1));

return statearr_39158;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_39128){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_39128);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e39162){var ex__28052__auto__ = e39162;
var statearr_39163_41029 = state_39128;
(statearr_39163_41029[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_39128[(4)]))){
var statearr_39164_41030 = state_39128;
(statearr_39164_41030[(1)] = cljs.core.first((state_39128[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41031 = state_39128;
state_39128 = G__41031;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_39128){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_39128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_39166 = f__28229__auto__();
(statearr_39166[(6)] = c__28228__auto___40998);

return statearr_39166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__39169 = arguments.length;
switch (G__39169) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28228__auto___41036 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_39230){
var state_val_39231 = (state_39230[(1)]);
if((state_val_39231 === (7))){
var inst_39226 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
var statearr_39233_41037 = state_39230__$1;
(statearr_39233_41037[(2)] = inst_39226);

(statearr_39233_41037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (1))){
var inst_39187 = (new Array(n));
var inst_39188 = inst_39187;
var inst_39189 = (0);
var state_39230__$1 = (function (){var statearr_39234 = state_39230;
(statearr_39234[(7)] = inst_39189);

(statearr_39234[(8)] = inst_39188);

return statearr_39234;
})();
var statearr_39235_41040 = state_39230__$1;
(statearr_39235_41040[(2)] = null);

(statearr_39235_41040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (4))){
var inst_39192 = (state_39230[(9)]);
var inst_39192__$1 = (state_39230[(2)]);
var inst_39193 = (inst_39192__$1 == null);
var inst_39194 = cljs.core.not(inst_39193);
var state_39230__$1 = (function (){var statearr_39236 = state_39230;
(statearr_39236[(9)] = inst_39192__$1);

return statearr_39236;
})();
if(inst_39194){
var statearr_39249_41043 = state_39230__$1;
(statearr_39249_41043[(1)] = (5));

} else {
var statearr_39250_41044 = state_39230__$1;
(statearr_39250_41044[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (15))){
var inst_39219 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
var statearr_39251_41045 = state_39230__$1;
(statearr_39251_41045[(2)] = inst_39219);

(statearr_39251_41045[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (13))){
var state_39230__$1 = state_39230;
var statearr_39252_41046 = state_39230__$1;
(statearr_39252_41046[(2)] = null);

(statearr_39252_41046[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (6))){
var inst_39189 = (state_39230[(7)]);
var inst_39213 = (inst_39189 > (0));
var state_39230__$1 = state_39230;
if(cljs.core.truth_(inst_39213)){
var statearr_39253_41047 = state_39230__$1;
(statearr_39253_41047[(1)] = (12));

} else {
var statearr_39254_41048 = state_39230__$1;
(statearr_39254_41048[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (3))){
var inst_39228 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39230__$1,inst_39228);
} else {
if((state_val_39231 === (12))){
var inst_39188 = (state_39230[(8)]);
var inst_39217 = cljs.core.vec(inst_39188);
var state_39230__$1 = state_39230;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39230__$1,(15),out,inst_39217);
} else {
if((state_val_39231 === (2))){
var state_39230__$1 = state_39230;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39230__$1,(4),ch);
} else {
if((state_val_39231 === (11))){
var inst_39204 = (state_39230[(2)]);
var inst_39205 = (new Array(n));
var inst_39188 = inst_39205;
var inst_39189 = (0);
var state_39230__$1 = (function (){var statearr_39256 = state_39230;
(statearr_39256[(10)] = inst_39204);

(statearr_39256[(7)] = inst_39189);

(statearr_39256[(8)] = inst_39188);

return statearr_39256;
})();
var statearr_39257_41049 = state_39230__$1;
(statearr_39257_41049[(2)] = null);

(statearr_39257_41049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (9))){
var inst_39188 = (state_39230[(8)]);
var inst_39202 = cljs.core.vec(inst_39188);
var state_39230__$1 = state_39230;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39230__$1,(11),out,inst_39202);
} else {
if((state_val_39231 === (5))){
var inst_39192 = (state_39230[(9)]);
var inst_39197 = (state_39230[(11)]);
var inst_39189 = (state_39230[(7)]);
var inst_39188 = (state_39230[(8)]);
var inst_39196 = (inst_39188[inst_39189] = inst_39192);
var inst_39197__$1 = (inst_39189 + (1));
var inst_39198 = (inst_39197__$1 < n);
var state_39230__$1 = (function (){var statearr_39258 = state_39230;
(statearr_39258[(11)] = inst_39197__$1);

(statearr_39258[(12)] = inst_39196);

return statearr_39258;
})();
if(cljs.core.truth_(inst_39198)){
var statearr_39259_41056 = state_39230__$1;
(statearr_39259_41056[(1)] = (8));

} else {
var statearr_39260_41057 = state_39230__$1;
(statearr_39260_41057[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (14))){
var inst_39223 = (state_39230[(2)]);
var inst_39224 = cljs.core.async.close_BANG_(out);
var state_39230__$1 = (function (){var statearr_39262 = state_39230;
(statearr_39262[(13)] = inst_39223);

return statearr_39262;
})();
var statearr_39263_41058 = state_39230__$1;
(statearr_39263_41058[(2)] = inst_39224);

(statearr_39263_41058[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (10))){
var inst_39208 = (state_39230[(2)]);
var state_39230__$1 = state_39230;
var statearr_39264_41059 = state_39230__$1;
(statearr_39264_41059[(2)] = inst_39208);

(statearr_39264_41059[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39231 === (8))){
var inst_39197 = (state_39230[(11)]);
var inst_39188 = (state_39230[(8)]);
var tmp39261 = inst_39188;
var inst_39188__$1 = tmp39261;
var inst_39189 = inst_39197;
var state_39230__$1 = (function (){var statearr_39268 = state_39230;
(statearr_39268[(7)] = inst_39189);

(statearr_39268[(8)] = inst_39188__$1);

return statearr_39268;
})();
var statearr_39270_41060 = state_39230__$1;
(statearr_39270_41060[(2)] = null);

(statearr_39270_41060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_39272 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39272[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_39272[(1)] = (1));

return statearr_39272;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_39230){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_39230);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e39273){var ex__28052__auto__ = e39273;
var statearr_39274_41066 = state_39230;
(statearr_39274_41066[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_39230[(4)]))){
var statearr_39275_41067 = state_39230;
(statearr_39275_41067[(1)] = cljs.core.first((state_39230[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41068 = state_39230;
state_39230 = G__41068;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_39230){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_39230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_39276 = f__28229__auto__();
(statearr_39276[(6)] = c__28228__auto___41036);

return statearr_39276;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__39288 = arguments.length;
switch (G__39288) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__28228__auto___41074 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__28229__auto__ = (function (){var switch__28048__auto__ = (function (state_39340){
var state_val_39341 = (state_39340[(1)]);
if((state_val_39341 === (7))){
var inst_39336 = (state_39340[(2)]);
var state_39340__$1 = state_39340;
var statearr_39345_41075 = state_39340__$1;
(statearr_39345_41075[(2)] = inst_39336);

(statearr_39345_41075[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (1))){
var inst_39293 = [];
var inst_39294 = inst_39293;
var inst_39295 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_39340__$1 = (function (){var statearr_39349 = state_39340;
(statearr_39349[(7)] = inst_39294);

(statearr_39349[(8)] = inst_39295);

return statearr_39349;
})();
var statearr_39350_41079 = state_39340__$1;
(statearr_39350_41079[(2)] = null);

(statearr_39350_41079[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (4))){
var inst_39301 = (state_39340[(9)]);
var inst_39301__$1 = (state_39340[(2)]);
var inst_39302 = (inst_39301__$1 == null);
var inst_39303 = cljs.core.not(inst_39302);
var state_39340__$1 = (function (){var statearr_39352 = state_39340;
(statearr_39352[(9)] = inst_39301__$1);

return statearr_39352;
})();
if(inst_39303){
var statearr_39353_41080 = state_39340__$1;
(statearr_39353_41080[(1)] = (5));

} else {
var statearr_39354_41081 = state_39340__$1;
(statearr_39354_41081[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (15))){
var inst_39294 = (state_39340[(7)]);
var inst_39328 = cljs.core.vec(inst_39294);
var state_39340__$1 = state_39340;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39340__$1,(18),out,inst_39328);
} else {
if((state_val_39341 === (13))){
var inst_39323 = (state_39340[(2)]);
var state_39340__$1 = state_39340;
var statearr_39358_41082 = state_39340__$1;
(statearr_39358_41082[(2)] = inst_39323);

(statearr_39358_41082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (6))){
var inst_39294 = (state_39340[(7)]);
var inst_39325 = inst_39294.length;
var inst_39326 = (inst_39325 > (0));
var state_39340__$1 = state_39340;
if(cljs.core.truth_(inst_39326)){
var statearr_39362_41083 = state_39340__$1;
(statearr_39362_41083[(1)] = (15));

} else {
var statearr_39363_41084 = state_39340__$1;
(statearr_39363_41084[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (17))){
var inst_39333 = (state_39340[(2)]);
var inst_39334 = cljs.core.async.close_BANG_(out);
var state_39340__$1 = (function (){var statearr_39364 = state_39340;
(statearr_39364[(10)] = inst_39333);

return statearr_39364;
})();
var statearr_39365_41085 = state_39340__$1;
(statearr_39365_41085[(2)] = inst_39334);

(statearr_39365_41085[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (3))){
var inst_39338 = (state_39340[(2)]);
var state_39340__$1 = state_39340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39340__$1,inst_39338);
} else {
if((state_val_39341 === (12))){
var inst_39294 = (state_39340[(7)]);
var inst_39316 = cljs.core.vec(inst_39294);
var state_39340__$1 = state_39340;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39340__$1,(14),out,inst_39316);
} else {
if((state_val_39341 === (2))){
var state_39340__$1 = state_39340;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39340__$1,(4),ch);
} else {
if((state_val_39341 === (11))){
var inst_39305 = (state_39340[(11)]);
var inst_39301 = (state_39340[(9)]);
var inst_39294 = (state_39340[(7)]);
var inst_39313 = inst_39294.push(inst_39301);
var tmp39366 = inst_39294;
var inst_39294__$1 = tmp39366;
var inst_39295 = inst_39305;
var state_39340__$1 = (function (){var statearr_39367 = state_39340;
(statearr_39367[(12)] = inst_39313);

(statearr_39367[(7)] = inst_39294__$1);

(statearr_39367[(8)] = inst_39295);

return statearr_39367;
})();
var statearr_39368_41087 = state_39340__$1;
(statearr_39368_41087[(2)] = null);

(statearr_39368_41087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (9))){
var inst_39295 = (state_39340[(8)]);
var inst_39309 = cljs.core.keyword_identical_QMARK_(inst_39295,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_39340__$1 = state_39340;
var statearr_39369_41088 = state_39340__$1;
(statearr_39369_41088[(2)] = inst_39309);

(statearr_39369_41088[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (5))){
var inst_39305 = (state_39340[(11)]);
var inst_39301 = (state_39340[(9)]);
var inst_39306 = (state_39340[(13)]);
var inst_39295 = (state_39340[(8)]);
var inst_39305__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_39301) : f.call(null,inst_39301));
var inst_39306__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39305__$1,inst_39295);
var state_39340__$1 = (function (){var statearr_39370 = state_39340;
(statearr_39370[(11)] = inst_39305__$1);

(statearr_39370[(13)] = inst_39306__$1);

return statearr_39370;
})();
if(inst_39306__$1){
var statearr_39371_41091 = state_39340__$1;
(statearr_39371_41091[(1)] = (8));

} else {
var statearr_39372_41092 = state_39340__$1;
(statearr_39372_41092[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (14))){
var inst_39305 = (state_39340[(11)]);
var inst_39301 = (state_39340[(9)]);
var inst_39318 = (state_39340[(2)]);
var inst_39319 = [];
var inst_39320 = inst_39319.push(inst_39301);
var inst_39294 = inst_39319;
var inst_39295 = inst_39305;
var state_39340__$1 = (function (){var statearr_39380 = state_39340;
(statearr_39380[(14)] = inst_39320);

(statearr_39380[(7)] = inst_39294);

(statearr_39380[(15)] = inst_39318);

(statearr_39380[(8)] = inst_39295);

return statearr_39380;
})();
var statearr_39381_41094 = state_39340__$1;
(statearr_39381_41094[(2)] = null);

(statearr_39381_41094[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (16))){
var state_39340__$1 = state_39340;
var statearr_39382_41095 = state_39340__$1;
(statearr_39382_41095[(2)] = null);

(statearr_39382_41095[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (10))){
var inst_39311 = (state_39340[(2)]);
var state_39340__$1 = state_39340;
if(cljs.core.truth_(inst_39311)){
var statearr_39384_41099 = state_39340__$1;
(statearr_39384_41099[(1)] = (11));

} else {
var statearr_39385_41101 = state_39340__$1;
(statearr_39385_41101[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (18))){
var inst_39330 = (state_39340[(2)]);
var state_39340__$1 = state_39340;
var statearr_39386_41102 = state_39340__$1;
(statearr_39386_41102[(2)] = inst_39330);

(statearr_39386_41102[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_39341 === (8))){
var inst_39306 = (state_39340[(13)]);
var state_39340__$1 = state_39340;
var statearr_39387_41107 = state_39340__$1;
(statearr_39387_41107[(2)] = inst_39306);

(statearr_39387_41107[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__28049__auto__ = null;
var cljs$core$async$state_machine__28049__auto____0 = (function (){
var statearr_39400 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39400[(0)] = cljs$core$async$state_machine__28049__auto__);

(statearr_39400[(1)] = (1));

return statearr_39400;
});
var cljs$core$async$state_machine__28049__auto____1 = (function (state_39340){
while(true){
var ret_value__28050__auto__ = (function (){try{while(true){
var result__28051__auto__ = switch__28048__auto__(state_39340);
if(cljs.core.keyword_identical_QMARK_(result__28051__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__28051__auto__;
}
break;
}
}catch (e39401){var ex__28052__auto__ = e39401;
var statearr_39402_41109 = state_39340;
(statearr_39402_41109[(2)] = ex__28052__auto__);


if(cljs.core.seq((state_39340[(4)]))){
var statearr_39404_41112 = state_39340;
(statearr_39404_41112[(1)] = cljs.core.first((state_39340[(4)])));

} else {
throw ex__28052__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__28050__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__41121 = state_39340;
state_39340 = G__41121;
continue;
} else {
return ret_value__28050__auto__;
}
break;
}
});
cljs$core$async$state_machine__28049__auto__ = function(state_39340){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__28049__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__28049__auto____1.call(this,state_39340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__28049__auto____0;
cljs$core$async$state_machine__28049__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__28049__auto____1;
return cljs$core$async$state_machine__28049__auto__;
})()
})();
var state__28230__auto__ = (function (){var statearr_39414 = f__28229__auto__();
(statearr_39414[(6)] = c__28228__auto___41074);

return statearr_39414;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__28230__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
