goog.provide('editscript.core');
/**
 * Create an editscript to represent the transformations needed to turn a
 *   Clojure data structure `a` into another Clojure data structure `b`.
 * 
 *   This function accepts any nested Clojure data structures. In Clojure, those
 *   implement `IPersistentVector`, `IPersistentMap`, `IPersistentList`,
 *   and `IPersistentSet` will be treated as collections. The same are true for
 *   the corresponding deftypes in Clojurescript, such as `PersistentVector`,
 *   `PersistentMap`, and so on. Anything else are treated as atomic values.
 * 
 *   The editscript is represented as a vector of basic operations: add `:+`,
 *   delete `:-`, and replace `:r`. Each operation also include a path to the
 *   location of the operation, which is similar to the path vector in `update-in`.
 *   However, editscript path works for all above four collection types, not just
 *   associative ones. For `:+` and `:r`, a new value is also required.
 * 
 *   The following options are supported in the option map of the last argument:
 * 
 *   * `:algo`  chooses the diff algorithm. The value can be `:a-star` (default) or
 *   `:quick`; `:a-star` algorithm minimize the size of the resulting editscript,
 *   `:quick` algorithm is much faster, but does not producing diff with minimal size.
 * 
 *   * `:str-diff` specifies the granularity of string diffing. It may have one of
 *   the following values:
 *     - `:none`  (default), do not perform string diffing, the fastest.
 *     - `:line`, diff by line.
 *     - `:word`, diff by word,
 *     - `:character`, diff by character, the slowest.
 * 
 *   * `:str-change-limit`, a less than `1.0` and greater than `0.0` double value,
 *   representing percentage (default `0.2`). Only diff string when less than given
 *   percentage is changed, otherwise replace the string.
 * 
 *   * `:vec-timeout` specifies a timeout in milliseconds (default `1000`),
 *   for diffing vectors, lists or strings, as it has O(n^2) running time. When
 *   timed-out, a replacement operation will be used.
 */
editscript.core.diff = (function editscript$core$diff(var_args){
var G__52466 = arguments.length;
switch (G__52466) {
case 2:
return editscript.core.diff.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return editscript.core.diff.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(editscript.core.diff.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
return editscript.core.diff.cljs$core$IFn$_invoke$arity$3(a,b,null);
}));

(editscript.core.diff.cljs$core$IFn$_invoke$arity$3 = (function (a,b,p__52467){
var map__52468 = p__52467;
var map__52468__$1 = cljs.core.__destructure_map(map__52468);
var opts = map__52468__$1;
var algo = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__52468__$1,new cljs.core.Keyword(null,"algo","algo",1472048382),new cljs.core.Keyword(null,"a-star","a-star",-171330865));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(algo,new cljs.core.Keyword(null,"a-star","a-star",-171330865))){
return editscript.diff.a_star.diff.cljs$core$IFn$_invoke$arity$3(a,b,opts);
} else {
return editscript.diff.quick.diff.cljs$core$IFn$_invoke$arity$3(a,b,opts);
}
}));

(editscript.core.diff.cljs$lang$maxFixedArity = 3);

/**
 * Apply the editscript `script` on `a` to produce `b`, assuming the
 *   script is the results of running  `(diff a b)`, such that
 *   `(= b (patch a (diff a b)))` is true
 */
editscript.core.patch = (function editscript$core$patch(a,script){
if((script instanceof editscript.edit.EditScript)){
} else {
throw (new Error("Assert failed: (instance? editscript.edit.EditScript script)"));
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__52469_SHARP_,p2__52470_SHARP_){
return editscript.patch.patch_STAR_(p1__52469_SHARP_,p2__52470_SHARP_);
}),a,editscript.edit.get_edits(script));
});
/**
 * Check if the given vector represents valid edits that can be turned
 * into an EditScript
 */
editscript.core.valid_edits_QMARK_ = editscript.edit.valid_edits_QMARK_;
/**
 * Concate that editscript onto this editscript, return the new
 * editscript
 */
editscript.core.combine = editscript.edit.combine;
/**
 * Report the size of the editscript
 */
editscript.core.get_size = editscript.edit.get_size;
/**
 * Report the edit distance of the editscript, i.e. number of
 * operations
 */
editscript.core.edit_distance = editscript.edit.edit_distance;
/**
 * Report the edits of the editscript as a vector
 */
editscript.core.get_edits = editscript.edit.get_edits;
/**
 * Report the number of additions in the editscript
 */
editscript.core.get_adds_num = editscript.edit.get_adds_num;
/**
 * Report the number of deletes in the editscript
 */
editscript.core.get_dels_num = editscript.edit.get_dels_num;
/**
 * Report the edits of replacements in the editscript
 */
editscript.core.get_reps_num = editscript.edit.get_reps_num;
/**
 * Create an EditScript instance from a vector of edits, like those
 * obtained through calling `get-edits` on an EditScript
 */
editscript.core.edits__GT_script = editscript.edit.edits__GT_script;
/**
 * Return the number of nodes of a piece of data.
 */
editscript.core.data_nodes = (function editscript$core$data_nodes(data){
return editscript.util.index.index(data).editscript$util$index$INode$get_size$arity$1(null);
});
editscript.core.get_data = (function editscript$core$get_data(data,path){
var G__52489 = path;
var vec__52490 = G__52489;
var seq__52491 = cljs.core.seq(vec__52490);
var first__52492 = cljs.core.first(seq__52491);
var seq__52491__$1 = cljs.core.next(seq__52491);
var f = first__52492;
var r = seq__52491__$1;
var v = data;
var G__52489__$1 = G__52489;
var v__$1 = v;
while(true){
var vec__52493 = G__52489__$1;
var seq__52494 = cljs.core.seq(vec__52493);
var first__52495 = cljs.core.first(seq__52494);
var seq__52494__$1 = cljs.core.next(seq__52494);
var f__$1 = first__52495;
var r__$1 = seq__52494__$1;
var v__$2 = v__$1;
var c = editscript.patch.vget(v__$2,f__$1);
if(r__$1){
var G__52502 = r__$1;
var G__52503 = c;
G__52489__$1 = G__52502;
v__$1 = G__52503;
continue;
} else {
return c;
}
break;
}
});
/**
 * Return an approximation of the ratio of changes of an editscript, a double
 */
editscript.core.change_ratio = (function editscript$core$change_ratio(origin,editscript__$1){
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (sum,p__52496){
var vec__52497 = p__52496;
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52497,(0),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52497,(1),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52497,(2),null);
return (sum + (function (){var G__52500 = op;
var G__52500__$1 = (((G__52500 instanceof cljs.core.Keyword))?G__52500.fqn:null);
switch (G__52500__$1) {
case "r":
case "+":
return editscript.core.data_nodes(v);

break;
case "s":
return (1);

break;
case "-":
return editscript.core.data_nodes(editscript.core.get_data(origin,path));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__52500__$1)].join('')));

}
})());
}),(0),(editscript.core.get_edits.cljs$core$IFn$_invoke$arity$1 ? editscript.core.get_edits.cljs$core$IFn$_invoke$arity$1(editscript__$1) : editscript.core.get_edits.call(null,editscript__$1))) / editscript.core.data_nodes(origin));
});

//# sourceMappingURL=editscript.core.js.map
