goog.provide('dataspex.render_client');

/**
 * @interface
 */
dataspex.render_client.HostChannel = function(){};

var dataspex$render_client$HostChannel$connect$dyn_83119 = (function (host_channel,render_f){
var x__5350__auto__ = (((host_channel == null))?null:host_channel);
var m__5351__auto__ = (dataspex.render_client.connect[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(host_channel,render_f) : m__5351__auto__.call(null,host_channel,render_f));
} else {
var m__5349__auto__ = (dataspex.render_client.connect["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(host_channel,render_f) : m__5349__auto__.call(null,host_channel,render_f));
} else {
throw cljs.core.missing_protocol("HostChannel.connect",host_channel);
}
}
});
dataspex.render_client.connect = (function dataspex$render_client$connect(host_channel,render_f){
if((((!((host_channel == null)))) && ((!((host_channel.dataspex$render_client$HostChannel$connect$arity$2 == null)))))){
return host_channel.dataspex$render_client$HostChannel$connect$arity$2(host_channel,render_f);
} else {
return dataspex$render_client$HostChannel$connect$dyn_83119(host_channel,render_f);
}
});

var dataspex$render_client$HostChannel$disconnect$dyn_83122 = (function (host_channel){
var x__5350__auto__ = (((host_channel == null))?null:host_channel);
var m__5351__auto__ = (dataspex.render_client.disconnect[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(host_channel) : m__5351__auto__.call(null,host_channel));
} else {
var m__5349__auto__ = (dataspex.render_client.disconnect["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(host_channel) : m__5349__auto__.call(null,host_channel));
} else {
throw cljs.core.missing_protocol("HostChannel.disconnect",host_channel);
}
}
});
dataspex.render_client.disconnect = (function dataspex$render_client$disconnect(host_channel){
if((((!((host_channel == null)))) && ((!((host_channel.dataspex$render_client$HostChannel$disconnect$arity$1 == null)))))){
return host_channel.dataspex$render_client$HostChannel$disconnect$arity$1(host_channel);
} else {
return dataspex$render_client$HostChannel$disconnect$dyn_83122(host_channel);
}
});

var dataspex$render_client$HostChannel$process_actions$dyn_83124 = (function (host_channel,node,actions){
var x__5350__auto__ = (((host_channel == null))?null:host_channel);
var m__5351__auto__ = (dataspex.render_client.process_actions[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(host_channel,node,actions) : m__5351__auto__.call(null,host_channel,node,actions));
} else {
var m__5349__auto__ = (dataspex.render_client.process_actions["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(host_channel,node,actions) : m__5349__auto__.call(null,host_channel,node,actions));
} else {
throw cljs.core.missing_protocol("HostChannel.process-actions",host_channel);
}
}
});
dataspex.render_client.process_actions = (function dataspex$render_client$process_actions(host_channel,node,actions){
if((((!((host_channel == null)))) && ((!((host_channel.dataspex$render_client$HostChannel$process_actions$arity$3 == null)))))){
return host_channel.dataspex$render_client$HostChannel$process_actions$arity$3(host_channel,node,actions);
} else {
return dataspex$render_client$HostChannel$process_actions$dyn_83124(host_channel,node,actions);
}
});

dataspex.render_client.prefers_dark_mode_QMARK_ = (function dataspex$render_client$prefers_dark_mode_QMARK_(){
return window.matchMedia("(prefers-color-scheme: dark)").matches;
});
dataspex.render_client.get_preferred_theme = (function dataspex$render_client$get_preferred_theme(){
if(cljs.core.truth_(dataspex.render_client.prefers_dark_mode_QMARK_())){
return new cljs.core.Keyword(null,"dark","dark",1818973999);
} else {
return new cljs.core.Keyword(null,"light","light",1918998747);
}
});
dataspex.render_client.execute_effects = (function dataspex$render_client$execute_effects(effects){
var seq__83044 = cljs.core.seq(effects);
var chunk__83046 = null;
var count__83047 = (0);
var i__83050 = (0);
while(true){
if((i__83050 < count__83047)){
var vec__83070 = chunk__83046.cljs$core$IIndexed$_nth$arity$2(null,i__83050);
var seq__83071 = cljs.core.seq(vec__83070);
var first__83072 = cljs.core.first(seq__83071);
var seq__83071__$1 = cljs.core.next(seq__83071);
var effect = first__83072;
var args = seq__83071__$1;
var G__83074_83128 = effect;
var G__83074_83129__$1 = (((G__83074_83128 instanceof cljs.core.Keyword))?G__83074_83128.fqn:null);
switch (G__83074_83129__$1) {
case "effect/copy":
dataspex.actions.copy_to_clipboard(cljs.core.first(args));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__83074_83129__$1)].join('')));

}

cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([effect,args], 0));


var G__83135 = seq__83044;
var G__83136 = chunk__83046;
var G__83137 = count__83047;
var G__83138 = (i__83050 + (1));
seq__83044 = G__83135;
chunk__83046 = G__83136;
count__83047 = G__83137;
i__83050 = G__83138;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__83044);
if(temp__5823__auto__){
var seq__83044__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__83044__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__83044__$1);
var G__83143 = cljs.core.chunk_rest(seq__83044__$1);
var G__83144 = c__5525__auto__;
var G__83145 = cljs.core.count(c__5525__auto__);
var G__83146 = (0);
seq__83044 = G__83143;
chunk__83046 = G__83144;
count__83047 = G__83145;
i__83050 = G__83146;
continue;
} else {
var vec__83078 = cljs.core.first(seq__83044__$1);
var seq__83079 = cljs.core.seq(vec__83078);
var first__83080 = cljs.core.first(seq__83079);
var seq__83079__$1 = cljs.core.next(seq__83079);
var effect = first__83080;
var args = seq__83079__$1;
var G__83082_83150 = effect;
var G__83082_83151__$1 = (((G__83082_83150 instanceof cljs.core.Keyword))?G__83082_83150.fqn:null);
switch (G__83082_83151__$1) {
case "effect/copy":
dataspex.actions.copy_to_clipboard(cljs.core.first(args));

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__83082_83151__$1)].join('')));

}

cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([effect,args], 0));


var G__83157 = cljs.core.next(seq__83044__$1);
var G__83158 = null;
var G__83159 = (0);
var G__83160 = (0);
seq__83044 = G__83157;
chunk__83046 = G__83158;
count__83047 = G__83159;
i__83050 = G__83160;
continue;
}
} else {
return null;
}
}
break;
}
});
dataspex.render_client.get_form_data = (function dataspex$render_client$get_form_data(form){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,el){
var k = (function (){var G__83084 = el;
var G__83084__$1 = (((G__83084 == null))?null:G__83084.name);
var G__83084__$2 = (((G__83084__$1 == null))?null:cljs.core.not_empty(G__83084__$1));
if((G__83084__$2 == null)){
return null;
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(G__83084__$2);
}
})();
var G__83086 = res;
if(cljs.core.truth_(k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__83086,k,el.value);
} else {
return G__83086;
}
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(form.elements));
});
dataspex.render_client.interpolate = (function dataspex$render_client$interpolate(event,actions){
return clojure.walk.postwalk((function (x){
var G__83087 = x;
var G__83087__$1 = (((G__83087 instanceof cljs.core.Keyword))?G__83087.fqn:null);
switch (G__83087__$1) {
case "event.target/value":
var G__83089 = event;
var G__83089__$1 = (((G__83089 == null))?null:G__83089.target);
if((G__83089__$1 == null)){
return null;
} else {
return G__83089__$1.value;
}

break;
case "event/form-data":
var G__83091 = event;
var G__83091__$1 = (((G__83091 == null))?null:G__83091.target);
if((G__83091__$1 == null)){
return null;
} else {
return dataspex.render_client.get_form_data(G__83091__$1);
}

break;
default:
return x;

}
}),actions);
});
dataspex.render_client.set_dispatch_BANG_ = (function dataspex$render_client$set_dispatch_BANG_(store,handle_remotes_actions){
return replicant.dom.set_dispatch_BANG_((function (p__83093,actions){
var map__83096 = p__83093;
var map__83096__$1 = cljs.core.__destructure_map(map__83096);
var dom_event = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__83096__$1,new cljs.core.Keyword("replicant","dom-event","replicant/dom-event",-1613182512));
var node = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__83096__$1,new cljs.core.Keyword("replicant","node","replicant/node",1306451380));
dom_event.preventDefault();

dom_event.stopPropagation();

var channel = node.closest("[data-channel]").getAttribute("data-channel");
var actions__$1 = dataspex.render_client.interpolate(dom_event,actions);
var seq__83101_83168 = cljs.core.seq(actions__$1);
var chunk__83102_83169 = null;
var count__83103_83170 = (0);
var i__83104_83171 = (0);
while(true){
if((i__83104_83171 < count__83103_83170)){
var action_83177 = chunk__83102_83169.cljs$core$IIndexed$_nth$arity$2(null,i__83104_83171);
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.prn,channel,action_83177);


var G__83180 = seq__83101_83168;
var G__83181 = chunk__83102_83169;
var G__83182 = count__83103_83170;
var G__83183 = (i__83104_83171 + (1));
seq__83101_83168 = G__83180;
chunk__83102_83169 = G__83181;
count__83103_83170 = G__83182;
i__83104_83171 = G__83183;
continue;
} else {
var temp__5823__auto___83188 = cljs.core.seq(seq__83101_83168);
if(temp__5823__auto___83188){
var seq__83101_83190__$1 = temp__5823__auto___83188;
if(cljs.core.chunked_seq_QMARK_(seq__83101_83190__$1)){
var c__5525__auto___83195 = cljs.core.chunk_first(seq__83101_83190__$1);
var G__83196 = cljs.core.chunk_rest(seq__83101_83190__$1);
var G__83197 = c__5525__auto___83195;
var G__83198 = cljs.core.count(c__5525__auto___83195);
var G__83199 = (0);
seq__83101_83168 = G__83196;
chunk__83102_83169 = G__83197;
count__83103_83170 = G__83198;
i__83104_83171 = G__83199;
continue;
} else {
var action_83200 = cljs.core.first(seq__83101_83190__$1);
cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.prn,channel,action_83200);


var G__83201 = cljs.core.next(seq__83101_83190__$1);
var G__83202 = null;
var G__83203 = (0);
var G__83204 = (0);
seq__83101_83168 = G__83201;
chunk__83102_83169 = G__83202;
count__83103_83170 = G__83203;
i__83104_83171 = G__83204;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("dataspex-remotes",channel)){
return (handle_remotes_actions.cljs$core$IFn$_invoke$arity$1 ? handle_remotes_actions.cljs$core$IFn$_invoke$arity$1(actions__$1) : handle_remotes_actions.call(null,actions__$1));
} else {
return dataspex.render_client.process_actions(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"channels","channels",1132759174).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(store)),channel),node,actions__$1).then(dataspex.render_client.execute_effects);
}
}));
});
dataspex.render_client.ensure_element = (function dataspex$render_client$ensure_element(root,channel_id){
var id = ["el-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.hash(channel_id))].join('');
var temp__5821__auto__ = document.getElementById(id);
if(cljs.core.truth_(temp__5821__auto__)){
var el = temp__5821__auto__;
return el;
} else {
var el = document.createElement("div");
(el.id = id);

el.setAttribute("data-channel",channel_id);

root.appendChild(el);

return el;
}
});
dataspex.render_client.render_splash = (function dataspex$render_client$render_splash(){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("dataspex.ui","card-list#dataspex.code","dataspex.ui/card-list#dataspex.code",-1282841866),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [dataspex.ui.card_body,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"Well, it ain't much to look at - yet. ","You can fix that by telling Dataspex to inspect something:"], null),dataspex.hiccup.render_source(cljs.core.list(new cljs.core.Symbol(null,"require","require",1172530194,null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dataspex.core","dataspex.core",1972024858,null),new cljs.core.Keyword(null,"as","as",1148689641),new cljs.core.Symbol(null,"dataspex","dataspex",1862680110,null)], null)),cljs.core.PersistentArrayMap.EMPTY),dataspex.hiccup.render_source(cljs.core.list(new cljs.core.Symbol("dataspex","inspect","dataspex/inspect",495433114,null),"App state",new cljs.core.Symbol(null,"my-data","my-data",-646191248,null)),cljs.core.PersistentArrayMap.EMPTY),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"Dataspex can inspect pretty much anything you can throw at it: maps,\n     vectors and lists, atoms, Datascript and Datomic databases, and anything\n     that implements Clojure's Datafy. You can also implement Dataspex' own\n     protocols to create custom data browsers. Have fun!"], null)], null)], null);
});
dataspex.render_client.mount_splash = (function dataspex$render_client$mount_splash(root){
return replicant.dom.render(dataspex.render_client.ensure_element(root,"dataspex-splash"),dataspex.render_client.render_splash());
});
dataspex.render_client.render = (function dataspex$render_client$render(el,id,hiccup){
if(cljs.core.truth_(hiccup)){
var temp__5823__auto___83207 = dataspex.render_client.ensure_element(el,"dataspex-splash");
if(cljs.core.truth_(temp__5823__auto___83207)){
var splash_83208 = temp__5823__auto___83207;
replicant.dom.unmount(splash_83208);
} else {
}
} else {
}

replicant.dom.render(dataspex.render_client.ensure_element(el,cljs.core.name(id)),hiccup);

if(cljs.core.truth_(hiccup)){
return null;
} else {
if(cljs.core.every_QMARK_((function (p1__83108_SHARP_){
return cljs.core.empty_QMARK_(p1__83108_SHARP_.innerHTML);
}),cljs.core.filterv(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [(1),null], null), null),(function (p1__83105_SHARP_){
return p1__83105_SHARP_.nodeType;
})),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,el.childNodes)))){
return dataspex.render_client.mount_splash(el);
} else {
return null;
}
}
});
dataspex.render_client.set_theme_BANG_ = (function dataspex$render_client$set_theme_BANG_(theme){
return document.documentElement.setAttribute("data-theme",cljs.core.name(theme));
});
dataspex.render_client.add_channel = (function dataspex$render_client$add_channel(store,id,channel){
var map__83112 = cljs.core.deref(store);
var map__83112__$1 = cljs.core.__destructure_map(map__83112);
var root = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__83112__$1,new cljs.core.Keyword(null,"root","root",-448657453));
dataspex.render_client.ensure_element(root,id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(store,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"channels","channels",1132759174),id], null),channel);

return dataspex.render_client.connect(channel,(function (p1__83110_SHARP_){
return dataspex.render_client.render(root,id,p1__83110_SHARP_);
}));
});
dataspex.render_client.remove_channel = (function dataspex$render_client$remove_channel(store,id){
var el = dataspex.render_client.ensure_element(new cljs.core.Keyword(null,"root","root",-448657453).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(store)),id);
var channel = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(store),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"channels","channels",1132759174),id], null));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(store,cljs.core.update,new cljs.core.Keyword(null,"channels","channels",1132759174),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([id], 0));

if(cljs.core.truth_(el)){
el.parentNode.removeChild(el);
} else {
}

if(cljs.core.truth_(channel)){
return dataspex.render_client.disconnect(channel);
} else {
return null;
}
});
dataspex.render_client.init_el = (function dataspex$render_client$init_el(root){
root.classList.add("inspector");

return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"panels-el","panels-el",-1941731369),dataspex.render_client.ensure_element(root,"dataspex-panels")], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"remotes-el","remotes-el",-1767477683),dataspex.render_client.ensure_element(root,"dataspex-remotes")], null)], null));
});
dataspex.render_client.start_render_client = (function dataspex$render_client$start_render_client(root,p__83115){
var map__83116 = p__83115;
var map__83116__$1 = cljs.core.__destructure_map(map__83116);
var handle_remotes_actions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__83116__$1,new cljs.core.Keyword(null,"handle-remotes-actions","handle-remotes-actions",1745680369));
var render_remotes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__83116__$1,new cljs.core.Keyword(null,"render-remotes","render-remotes",1109529878));
var map__83118 = dataspex.render_client.init_el(root);
var map__83118__$1 = cljs.core.__destructure_map(map__83118);
var panels_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__83118__$1,new cljs.core.Keyword(null,"panels-el","panels-el",-1941731369));
var remotes_el = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__83118__$1,new cljs.core.Keyword(null,"remotes-el","remotes-el",-1767477683));
var store = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root","root",-448657453),panels_el,new cljs.core.Keyword(null,"channels","channels",1132759174),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"remotes","remotes",1132366312),cljs.core.PersistentArrayMap.EMPTY], null));
dataspex.render_client.set_theme_BANG_(dataspex.render_client.get_preferred_theme());

dataspex.render_client.mount_splash(panels_el);

dataspex.render_client.set_dispatch_BANG_(store,cljs.core.partial.cljs$core$IFn$_invoke$arity$3(handle_remotes_actions,store,panels_el));

cljs.core.add_watch(store,new cljs.core.Keyword("dataspex.render-client","render-remotes","dataspex.render-client/render-remotes",607705708),(function (_,___$1,___$2,state){
return replicant.dom.render(remotes_el,(render_remotes.cljs$core$IFn$_invoke$arity$1 ? render_remotes.cljs$core$IFn$_invoke$arity$1(state) : render_remotes.call(null,state)));
}));

return store;
});

//# sourceMappingURL=dataspex.render_client.js.map
