goog.provide('datascript.conn');

/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IReset}
 * @implements {cljs.core.ISwap}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
 * @implements {extend_clj.core.IAtom3}
 * @implements {cljs.core.ILookup}
*/
datascript.conn.Conn = (function (atom,validator,watches,meta){
this.atom = atom;
this.validator = validator;
this.watches = watches;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 98306;
this.cljs$lang$protocol_mask$partition0$ = 6455552;
});
(datascript.conn.Conn.prototype.equiv = (function (other__29922__auto__){
var self__ = this;
var this__29921__auto__ = this;
return this__29921__auto__.cljs$core$IEquiv$_equiv$arity$2(null,other__29922__auto__);
}));

(datascript.conn.Conn.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this__29921__auto__,oldv__29929__auto__,newv__29924__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
var seq__47219 = cljs.core.seq(self__.watches);
var chunk__47220 = null;
var count__47221 = (0);
var i__47222 = (0);
while(true){
if((i__47222 < count__47221)){
var vec__47229 = chunk__47220.cljs$core$IIndexed$_nth$arity$2(null,i__47222);
var k__29930__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47229,(0),null);
var f__29925__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47229,(1),null);
(f__29925__auto__.cljs$core$IFn$_invoke$arity$4 ? f__29925__auto__.cljs$core$IFn$_invoke$arity$4(k__29930__auto__,this__29921__auto____$1,oldv__29929__auto__,newv__29924__auto__) : f__29925__auto__.call(null,k__29930__auto__,this__29921__auto____$1,oldv__29929__auto__,newv__29924__auto__));


var G__47485 = seq__47219;
var G__47486 = chunk__47220;
var G__47487 = count__47221;
var G__47488 = (i__47222 + (1));
seq__47219 = G__47485;
chunk__47220 = G__47486;
count__47221 = G__47487;
i__47222 = G__47488;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__47219);
if(temp__5823__auto__){
var seq__47219__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47219__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__47219__$1);
var G__47490 = cljs.core.chunk_rest(seq__47219__$1);
var G__47491 = c__5525__auto__;
var G__47492 = cljs.core.count(c__5525__auto__);
var G__47493 = (0);
seq__47219 = G__47490;
chunk__47220 = G__47491;
count__47221 = G__47492;
i__47222 = G__47493;
continue;
} else {
var vec__47232 = cljs.core.first(seq__47219__$1);
var k__29930__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47232,(0),null);
var f__29925__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47232,(1),null);
(f__29925__auto__.cljs$core$IFn$_invoke$arity$4 ? f__29925__auto__.cljs$core$IFn$_invoke$arity$4(k__29930__auto__,this__29921__auto____$1,oldv__29929__auto__,newv__29924__auto__) : f__29925__auto__.call(null,k__29930__auto__,this__29921__auto____$1,oldv__29929__auto__,newv__29924__auto__));


var G__47495 = cljs.core.next(seq__47219__$1);
var G__47496 = null;
var G__47497 = (0);
var G__47498 = (0);
seq__47219 = G__47495;
chunk__47220 = G__47496;
count__47221 = G__47497;
i__47222 = G__47498;
continue;
}
} else {
return null;
}
}
break;
}
}));

(datascript.conn.Conn.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this__29921__auto__,key__29931__auto__,f__29925__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
(this__29921__auto____$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key__29931__auto__,f__29925__auto__));

return this__29921__auto____$1;
}));

(datascript.conn.Conn.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this__29921__auto__,key__29931__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return (this__29921__auto____$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key__29931__auto__));
}));

(datascript.conn.Conn.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o__29923__auto__,other__29922__auto__){
var self__ = this;
var o__29923__auto____$1 = this;
return (o__29923__auto____$1 === other__29922__auto__);
}));

(datascript.conn.Conn.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__29921__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return goog.getUid(this__29921__auto____$1);
}));

(datascript.conn.Conn.prototype.cljs$core$IReset$_reset_BANG_$arity$2 = (function (this__29921__auto__,newv__29924__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(this__29921__auto____$1.extend_clj$core$IAtom3$swap_STAR_$arity$3(null,cljs.core.constantly(newv__29924__auto__),cljs.core.List.EMPTY),(1));
}));

(datascript.conn.Conn.prototype.cljs$core$ISwap$_swap_BANG_$arity$2 = (function (this__29921__auto__,f__29925__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(this__29921__auto____$1.extend_clj$core$IAtom3$swap_STAR_$arity$3(null,f__29925__auto__,cljs.core.List.EMPTY),(1));
}));

(datascript.conn.Conn.prototype.cljs$core$ISwap$_swap_BANG_$arity$3 = (function (this__29921__auto__,f__29925__auto__,a__29926__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(this__29921__auto____$1.extend_clj$core$IAtom3$swap_STAR_$arity$3(null,f__29925__auto__,(new cljs.core.List(null,a__29926__auto__,null,(1),null))),(1));
}));

(datascript.conn.Conn.prototype.cljs$core$ISwap$_swap_BANG_$arity$4 = (function (this__29921__auto__,f__29925__auto__,a__29926__auto__,b__29927__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(this__29921__auto____$1.extend_clj$core$IAtom3$swap_STAR_$arity$3(null,f__29925__auto__,(new cljs.core.List(null,a__29926__auto__,(new cljs.core.List(null,b__29927__auto__,null,(1),null)),(2),null))),(1));
}));

(datascript.conn.Conn.prototype.cljs$core$ISwap$_swap_BANG_$arity$5 = (function (this__29921__auto__,f__29925__auto__,a__29926__auto__,b__29927__auto__,xs__29928__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(this__29921__auto____$1.extend_clj$core$IAtom3$swap_STAR_$arity$3(null,f__29925__auto__,cljs.core.cons(a__29926__auto__,cljs.core.cons(b__29927__auto__,xs__29928__auto__))),(1));
}));

(datascript.conn.Conn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__29921__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return self__.meta;
}));

(datascript.conn.Conn.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this__29921__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return this__29921__auto____$1.extend_clj$core$IAtom3$deref_impl$arity$1(null);
}));

(datascript.conn.Conn.prototype.extend_clj$core$IAtom3$ = cljs.core.PROTOCOL_SENTINEL);

(datascript.conn.Conn.prototype.extend_clj$core$IAtom3$validate$arity$3 = (function (this__29921__auto__,validator__29933__auto__,value__29934__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
if((!((validator__29933__auto__ == null)))){
if(cljs.core.truth_((validator__29933__auto__.cljs$core$IFn$_invoke$arity$1 ? validator__29933__auto__.cljs$core$IFn$_invoke$arity$1(value__29934__auto__) : validator__29933__auto__.call(null,value__29934__auto__)))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid reference state",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),value__29934__auto__], null));
}
} else {
return null;
}
}));

(datascript.conn.Conn.prototype.extend_clj$core$IAtom3$notify_watches$arity$3 = (function (this__29921__auto__,oldv__29929__auto__,newv__29924__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
var seq__47240 = cljs.core.seq(self__.watches);
var chunk__47241 = null;
var count__47242 = (0);
var i__47243 = (0);
while(true){
if((i__47243 < count__47242)){
var vec__47250 = chunk__47241.cljs$core$IIndexed$_nth$arity$2(null,i__47243);
var k__29930__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47250,(0),null);
var w__29935__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47250,(1),null);
(w__29935__auto__.cljs$core$IFn$_invoke$arity$4 ? w__29935__auto__.cljs$core$IFn$_invoke$arity$4(k__29930__auto__,this__29921__auto____$1,oldv__29929__auto__,newv__29924__auto__) : w__29935__auto__.call(null,k__29930__auto__,this__29921__auto____$1,oldv__29929__auto__,newv__29924__auto__));


var G__47501 = seq__47240;
var G__47502 = chunk__47241;
var G__47503 = count__47242;
var G__47504 = (i__47243 + (1));
seq__47240 = G__47501;
chunk__47241 = G__47502;
count__47242 = G__47503;
i__47243 = G__47504;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__47240);
if(temp__5823__auto__){
var seq__47240__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47240__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__47240__$1);
var G__47505 = cljs.core.chunk_rest(seq__47240__$1);
var G__47506 = c__5525__auto__;
var G__47507 = cljs.core.count(c__5525__auto__);
var G__47508 = (0);
seq__47240 = G__47505;
chunk__47241 = G__47506;
count__47242 = G__47507;
i__47243 = G__47508;
continue;
} else {
var vec__47254 = cljs.core.first(seq__47240__$1);
var k__29930__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47254,(0),null);
var w__29935__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47254,(1),null);
(w__29935__auto__.cljs$core$IFn$_invoke$arity$4 ? w__29935__auto__.cljs$core$IFn$_invoke$arity$4(k__29930__auto__,this__29921__auto____$1,oldv__29929__auto__,newv__29924__auto__) : w__29935__auto__.call(null,k__29930__auto__,this__29921__auto____$1,oldv__29929__auto__,newv__29924__auto__));


var G__47511 = cljs.core.next(seq__47240__$1);
var G__47512 = null;
var G__47513 = (0);
var G__47514 = (0);
seq__47240 = G__47511;
chunk__47241 = G__47512;
count__47242 = G__47513;
i__47243 = G__47514;
continue;
}
} else {
return null;
}
}
break;
}
}));

(datascript.conn.Conn.prototype.extend_clj$core$IAtom3$swap_STAR_$arity$3 = (function (this__29921__auto__,f__29925__auto__,args__29936__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
var oldv__29929__auto__ = cljs.core.deref(this__29921__auto____$1);
var newv__29924__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f__29925__auto__,oldv__29929__auto__,args__29936__auto__);
this__29921__auto____$1.extend_clj$core$IAtom3$validate$arity$3(null,self__.validator,newv__29924__auto__);

this__29921__auto____$1.extend_clj$core$IAtom3$compare_and_set_impl$arity$3(null,oldv__29929__auto__,newv__29924__auto__);

this__29921__auto____$1.extend_clj$core$IAtom3$notify_watches$arity$3(null,oldv__29929__auto__,newv__29924__auto__);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [oldv__29929__auto__,newv__29924__auto__], null);
}));

(datascript.conn.Conn.prototype.extend_clj$core$IAtom3$deref_impl$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(self__.atom));
}));

(datascript.conn.Conn.prototype.extend_clj$core$IAtom3$compare_and_set_impl$arity$3 = (function (this$,oldv,newv){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare_and_set_BANG_(self__.atom,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.deref(self__.atom),new cljs.core.Keyword(null,"db","db",993250759),oldv),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.deref(self__.atom),new cljs.core.Keyword(null,"db","db",993250759),newv));
}));

(datascript.conn.Conn.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__29921__auto__,k__29930__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
return this__29921__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__29930__auto__,null);
}));

(datascript.conn.Conn.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__29921__auto__,k__29930__auto__,not_found__29932__auto__){
var self__ = this;
var this__29921__auto____$1 = this;
var G__47260 = k__29930__auto__;
var G__47260__$1 = (((G__47260 instanceof cljs.core.Keyword))?G__47260.fqn:null);
switch (G__47260__$1) {
case "atom":
return self__.atom;

break;
default:
return not_found__29932__auto__;

}
}));

(datascript.conn.Conn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"atom","atom",1243487874,null),new cljs.core.Symbol(null,"validator","validator",-325659154,null),new cljs.core.Symbol(null,"watches","watches",1367433992,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null)], null);
}));

(datascript.conn.Conn.cljs$lang$type = true);

(datascript.conn.Conn.cljs$lang$ctorStr = "datascript.conn/Conn");

(datascript.conn.Conn.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"datascript.conn/Conn");
}));

/**
 * Positional factory function for datascript.conn/Conn.
 */
datascript.conn.__GT_Conn = (function datascript$conn$__GT_Conn(atom,validator,watches,meta){
return (new datascript.conn.Conn(atom,validator,watches,meta));
});


datascript.conn.__GT_Conn = (function datascript$conn$__GT_Conn(var_args){
var G__47268 = arguments.length;
switch (G__47268) {
case 1:
return datascript.conn.__GT_Conn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__5751__auto__ = [];
var len__5726__auto___47528 = arguments.length;
var i__5727__auto___47533 = (0);
while(true){
if((i__5727__auto___47533 < len__5726__auto___47528)){
args_arr__5751__auto__.push((arguments[i__5727__auto___47533]));

var G__47535 = (i__5727__auto___47533 + (1));
i__5727__auto___47533 = G__47535;
continue;
} else {
}
break;
}

var argseq__5752__auto__ = ((((1) < args_arr__5751__auto__.length))?(new cljs.core.IndexedSeq(args_arr__5751__auto__.slice((1)),(0),null)):null);
return datascript.conn.__GT_Conn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5752__auto__);

}
});

(datascript.conn.__GT_Conn.cljs$core$IFn$_invoke$arity$1 = (function (atom){
return (new datascript.conn.Conn(atom,null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY));
}));

(datascript.conn.__GT_Conn.cljs$core$IFn$_invoke$arity$variadic = (function (atom,rest__29937__auto__){
var opts__29938__auto__ = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,rest__29937__auto__);
var ref__29939__auto__ = (new datascript.conn.Conn(atom,null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY));
var temp__5827__auto___47544 = new cljs.core.Keyword(null,"validator","validator",-1966190681).cljs$core$IFn$_invoke$arity$1(opts__29938__auto__);
if((temp__5827__auto___47544 == null)){
} else {
var validator__29933__auto___47545 = temp__5827__auto___47544;
ref__29939__auto__.extend_clj$core$IAtom3$validate$arity$3(null,validator__29933__auto___47545,cljs.core.deref(ref__29939__auto__));

(ref__29939__auto__.validator = validator__29933__auto___47545);
}

var temp__5827__auto___47546 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts__29938__auto__);
if((temp__5827__auto___47546 == null)){
} else {
var meta__29940__auto___47547 = temp__5827__auto___47546;
cljs.core.reset_meta_BANG_(ref__29939__auto__,meta__29940__auto___47547);
}

return ref__29939__auto__;
}));

/** @this {Function} */
(datascript.conn.__GT_Conn.cljs$lang$applyTo = (function (seq47266){
var G__47267 = cljs.core.first(seq47266);
var seq47266__$1 = cljs.core.next(seq47266);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47267,seq47266__$1);
}));

(datascript.conn.__GT_Conn.cljs$lang$maxFixedArity = (1));


datascript.conn.make_conn = (function datascript$conn$make_conn(opts){
var G__47279 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(opts);
return (datascript.conn.__GT_Conn.cljs$core$IFn$_invoke$arity$1 ? datascript.conn.__GT_Conn.cljs$core$IFn$_invoke$arity$1(G__47279) : datascript.conn.__GT_Conn.call(null,G__47279));
});
datascript.conn.with$ = (function datascript$conn$with(var_args){
var G__47298 = arguments.length;
switch (G__47298) {
case 2:
return datascript.conn.with$.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return datascript.conn.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(datascript.conn.with$.cljs$core$IFn$_invoke$arity$2 = (function (db,tx_data){
return datascript.conn.with$.cljs$core$IFn$_invoke$arity$3(db,tx_data,null);
}));

(datascript.conn.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,tx_data,tx_meta){
if(datascript.db.db_QMARK_(db)){
} else {
throw (new Error("Assert failed: (db/db? db)"));
}

if((db instanceof datascript.db.FilteredDB)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Filtered DB cannot be modified",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("transaction","filtered","transaction/filtered",1699706605)], null));
} else {
return datascript.db.transact_tx_data(datascript.db.__GT_TxReport(db,db,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentArrayMap.EMPTY,tx_meta),tx_data);
}
}));

(datascript.conn.with$.cljs$lang$maxFixedArity = 3);

/**
 * Applies transaction to an immutable db value, returning new immutable db value. Same as `(:db-after (with db tx-data))`.
 */
datascript.conn.db_with = (function datascript$conn$db_with(db,tx_data){
if(datascript.db.db_QMARK_(db)){
} else {
throw (new Error("Assert failed: (db/db? db)"));
}

return new cljs.core.Keyword(null,"db-after","db-after",-571884666).cljs$core$IFn$_invoke$arity$1(datascript.conn.with$.cljs$core$IFn$_invoke$arity$2(db,tx_data));
});
datascript.conn.conn_QMARK_ = (function datascript$conn$conn_QMARK_(conn){
var and__5000__auto__ = (((!((conn == null))))?(((((conn.cljs$lang$protocol_mask$partition0$ & (32768))) || ((cljs.core.PROTOCOL_SENTINEL === conn.cljs$core$IDeref$))))?true:(((!conn.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IDeref,conn):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IDeref,conn));
if(and__5000__auto__){
var temp__5825__auto__ = cljs.core.deref(conn);
if((temp__5825__auto__ == null)){
return true;
} else {
var db = temp__5825__auto__;
return datascript.db.db_QMARK_(db);
}
} else {
return and__5000__auto__;
}
});
datascript.conn.conn_from_db = (function datascript$conn$conn_from_db(db){
if(datascript.db.db_QMARK_(db)){
} else {
throw (new Error("Assert failed: (db/db? db)"));
}

var temp__5825__auto__ = datascript.storage.storage(db);
if((temp__5825__auto__ == null)){
return datascript.conn.make_conn(new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),db], null));
} else {
var storage = temp__5825__auto__;
datascript.storage.store.cljs$core$IFn$_invoke$arity$1(db);

return datascript.conn.make_conn(new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx-tail","tx-tail",1116487556),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"db-last-stored","db-last-stored",-2068760702),db], null));
}
});
datascript.conn.conn_from_datoms = (function datascript$conn$conn_from_datoms(var_args){
var G__47339 = arguments.length;
switch (G__47339) {
case 1:
return datascript.conn.conn_from_datoms.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return datascript.conn.conn_from_datoms.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return datascript.conn.conn_from_datoms.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(datascript.conn.conn_from_datoms.cljs$core$IFn$_invoke$arity$1 = (function (datoms){
return datascript.conn.conn_from_db(datascript.db.init_db(datoms,null,cljs.core.PersistentArrayMap.EMPTY));
}));

(datascript.conn.conn_from_datoms.cljs$core$IFn$_invoke$arity$2 = (function (datoms,schema){
return datascript.conn.conn_from_db(datascript.db.init_db(datoms,schema,cljs.core.PersistentArrayMap.EMPTY));
}));

(datascript.conn.conn_from_datoms.cljs$core$IFn$_invoke$arity$3 = (function (datoms,schema,opts){
return datascript.conn.conn_from_db(datascript.db.init_db(datoms,schema,datascript.storage.maybe_adapt_storage(opts)));
}));

(datascript.conn.conn_from_datoms.cljs$lang$maxFixedArity = 3);

datascript.conn.create_conn = (function datascript$conn$create_conn(var_args){
var G__47344 = arguments.length;
switch (G__47344) {
case 0:
return datascript.conn.create_conn.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return datascript.conn.create_conn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return datascript.conn.create_conn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(datascript.conn.create_conn.cljs$core$IFn$_invoke$arity$0 = (function (){
return datascript.conn.conn_from_db(datascript.db.empty_db(null,cljs.core.PersistentArrayMap.EMPTY));
}));

(datascript.conn.create_conn.cljs$core$IFn$_invoke$arity$1 = (function (schema){
return datascript.conn.conn_from_db(datascript.db.empty_db(schema,cljs.core.PersistentArrayMap.EMPTY));
}));

(datascript.conn.create_conn.cljs$core$IFn$_invoke$arity$2 = (function (schema,opts){
return datascript.conn.conn_from_db(datascript.db.empty_db(schema,datascript.storage.maybe_adapt_storage(opts)));
}));

(datascript.conn.create_conn.cljs$lang$maxFixedArity = 2);

datascript.conn._transact_BANG_ = (function datascript$conn$_transact_BANG_(conn,tx_data,tx_meta){
if(datascript.conn.conn_QMARK_(conn)){
} else {
throw (new Error("Assert failed: (conn? conn)"));
}

var _STAR_report = cljs.core.volatile_BANG_(null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(conn,(function (db){
var r = datascript.conn.with$.cljs$core$IFn$_invoke$arity$3(db,tx_data,tx_meta);
cljs.core.vreset_BANG_(_STAR_report,r);

return new cljs.core.Keyword(null,"db-after","db-after",-571884666).cljs$core$IFn$_invoke$arity$1(r);
}));

return cljs.core.deref(_STAR_report);
});
datascript.conn.transact_BANG_ = (function datascript$conn$transact_BANG_(var_args){
var G__47373 = arguments.length;
switch (G__47373) {
case 2:
return datascript.conn.transact_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return datascript.conn.transact_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(datascript.conn.transact_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (conn,tx_data){
return datascript.conn.transact_BANG_.cljs$core$IFn$_invoke$arity$3(conn,tx_data,null);
}));

(datascript.conn.transact_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (conn,tx_data,tx_meta){
if(datascript.conn.conn_QMARK_(conn)){
} else {
throw (new Error("Assert failed: (conn? conn)"));
}

var report = datascript.conn._transact_BANG_(conn,tx_data,tx_meta);
var seq__47381_47604 = cljs.core.seq(new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"atom","atom",-397043653).cljs$core$IFn$_invoke$arity$1(conn))));
var chunk__47382_47605 = null;
var count__47383_47606 = (0);
var i__47384_47607 = (0);
while(true){
if((i__47384_47607 < count__47383_47606)){
var vec__47403_47609 = chunk__47382_47605.cljs$core$IIndexed$_nth$arity$2(null,i__47384_47607);
var __47610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47403_47609,(0),null);
var callback_47611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47403_47609,(1),null);
(callback_47611.cljs$core$IFn$_invoke$arity$1 ? callback_47611.cljs$core$IFn$_invoke$arity$1(report) : callback_47611.call(null,report));


var G__47612 = seq__47381_47604;
var G__47613 = chunk__47382_47605;
var G__47614 = count__47383_47606;
var G__47615 = (i__47384_47607 + (1));
seq__47381_47604 = G__47612;
chunk__47382_47605 = G__47613;
count__47383_47606 = G__47614;
i__47384_47607 = G__47615;
continue;
} else {
var temp__5823__auto___47616 = cljs.core.seq(seq__47381_47604);
if(temp__5823__auto___47616){
var seq__47381_47617__$1 = temp__5823__auto___47616;
if(cljs.core.chunked_seq_QMARK_(seq__47381_47617__$1)){
var c__5525__auto___47618 = cljs.core.chunk_first(seq__47381_47617__$1);
var G__47619 = cljs.core.chunk_rest(seq__47381_47617__$1);
var G__47620 = c__5525__auto___47618;
var G__47621 = cljs.core.count(c__5525__auto___47618);
var G__47622 = (0);
seq__47381_47604 = G__47619;
chunk__47382_47605 = G__47620;
count__47383_47606 = G__47621;
i__47384_47607 = G__47622;
continue;
} else {
var vec__47415_47623 = cljs.core.first(seq__47381_47617__$1);
var __47624 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47415_47623,(0),null);
var callback_47625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47415_47623,(1),null);
(callback_47625.cljs$core$IFn$_invoke$arity$1 ? callback_47625.cljs$core$IFn$_invoke$arity$1(report) : callback_47625.call(null,report));


var G__47626 = cljs.core.next(seq__47381_47617__$1);
var G__47627 = null;
var G__47628 = (0);
var G__47629 = (0);
seq__47381_47604 = G__47626;
chunk__47382_47605 = G__47627;
count__47383_47606 = G__47628;
i__47384_47607 = G__47629;
continue;
}
} else {
}
}
break;
}

return report;
}));

(datascript.conn.transact_BANG_.cljs$lang$maxFixedArity = 3);

datascript.conn.reset_conn_BANG_ = (function datascript$conn$reset_conn_BANG_(var_args){
var G__47427 = arguments.length;
switch (G__47427) {
case 2:
return datascript.conn.reset_conn_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return datascript.conn.reset_conn_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(datascript.conn.reset_conn_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (conn,db){
return datascript.conn.reset_conn_BANG_.cljs$core$IFn$_invoke$arity$3(conn,db,null);
}));

(datascript.conn.reset_conn_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (conn,db,tx_meta){
if(datascript.conn.conn_QMARK_(conn)){
} else {
throw (new Error("Assert failed: (conn? conn)"));
}

if(datascript.db.db_QMARK_(db)){
} else {
throw (new Error("Assert failed: (db/db? db)"));
}

var db_before = cljs.core.deref(conn);
var report = datascript.db.map__GT_TxReport(new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"db-before","db-before",-553691536),db_before,new cljs.core.Keyword(null,"db-after","db-after",-571884666),db,new cljs.core.Keyword(null,"tx-data","tx-data",934159761),cljs.core.concat.cljs$core$IFn$_invoke$arity$2((cljs.core.truth_(db_before)?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__47420_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__47420_SHARP_,new cljs.core.Keyword(null,"added","added",2057651688),false);
}),datascript.db._datoms(db_before,new cljs.core.Keyword(null,"eavt","eavt",-666437073),null,null,null,null)):null),datascript.db._datoms(db,new cljs.core.Keyword(null,"eavt","eavt",-666437073),null,null,null,null)),new cljs.core.Keyword(null,"tx-meta","tx-meta",1159283194),tx_meta], null));
var temp__5825__auto___47636 = datascript.storage.storage(db_before);
if((temp__5825__auto___47636 == null)){
cljs.core.reset_BANG_(conn,db);
} else {
var storage_47640 = temp__5825__auto___47636;
datascript.storage.store.cljs$core$IFn$_invoke$arity$1(db);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"atom","atom",-397043653).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"db","db",993250759),db,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"tx-tail","tx-tail",1116487556),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"db-last-stored","db-last-stored",-2068760702),db], 0));
}

var seq__47431_47641 = cljs.core.seq(new cljs.core.Keyword(null,"listeners","listeners",394544445).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"atom","atom",-397043653).cljs$core$IFn$_invoke$arity$1(conn))));
var chunk__47432_47643 = null;
var count__47433_47644 = (0);
var i__47434_47645 = (0);
while(true){
if((i__47434_47645 < count__47433_47644)){
var vec__47446_47646 = chunk__47432_47643.cljs$core$IIndexed$_nth$arity$2(null,i__47434_47645);
var __47647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47446_47646,(0),null);
var callback_47648 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47446_47646,(1),null);
(callback_47648.cljs$core$IFn$_invoke$arity$1 ? callback_47648.cljs$core$IFn$_invoke$arity$1(report) : callback_47648.call(null,report));


var G__47649 = seq__47431_47641;
var G__47650 = chunk__47432_47643;
var G__47651 = count__47433_47644;
var G__47652 = (i__47434_47645 + (1));
seq__47431_47641 = G__47649;
chunk__47432_47643 = G__47650;
count__47433_47644 = G__47651;
i__47434_47645 = G__47652;
continue;
} else {
var temp__5823__auto___47653 = cljs.core.seq(seq__47431_47641);
if(temp__5823__auto___47653){
var seq__47431_47654__$1 = temp__5823__auto___47653;
if(cljs.core.chunked_seq_QMARK_(seq__47431_47654__$1)){
var c__5525__auto___47659 = cljs.core.chunk_first(seq__47431_47654__$1);
var G__47660 = cljs.core.chunk_rest(seq__47431_47654__$1);
var G__47661 = c__5525__auto___47659;
var G__47662 = cljs.core.count(c__5525__auto___47659);
var G__47663 = (0);
seq__47431_47641 = G__47660;
chunk__47432_47643 = G__47661;
count__47433_47644 = G__47662;
i__47434_47645 = G__47663;
continue;
} else {
var vec__47451_47664 = cljs.core.first(seq__47431_47654__$1);
var __47665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47451_47664,(0),null);
var callback_47666 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47451_47664,(1),null);
(callback_47666.cljs$core$IFn$_invoke$arity$1 ? callback_47666.cljs$core$IFn$_invoke$arity$1(report) : callback_47666.call(null,report));


var G__47671 = cljs.core.next(seq__47431_47654__$1);
var G__47672 = null;
var G__47673 = (0);
var G__47674 = (0);
seq__47431_47641 = G__47671;
chunk__47432_47643 = G__47672;
count__47433_47644 = G__47673;
i__47434_47645 = G__47674;
continue;
}
} else {
}
}
break;
}

return db;
}));

(datascript.conn.reset_conn_BANG_.cljs$lang$maxFixedArity = 3);

datascript.conn.reset_schema_BANG_ = (function datascript$conn$reset_schema_BANG_(conn,schema){
if(datascript.conn.conn_QMARK_(conn)){
} else {
throw (new Error("Assert failed: (conn? conn)"));
}

var db = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(conn,datascript.db.with_schema,schema);
return db;
});
datascript.conn.listen_BANG_ = (function datascript$conn$listen_BANG_(var_args){
var G__47469 = arguments.length;
switch (G__47469) {
case 2:
return datascript.conn.listen_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return datascript.conn.listen_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(datascript.conn.listen_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (conn,callback){
return datascript.conn.listen_BANG_.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.rand.cljs$core$IFn$_invoke$arity$0(),callback);
}));

(datascript.conn.listen_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (conn,key,callback){
if(datascript.conn.conn_QMARK_(conn)){
} else {
throw (new Error("Assert failed: (conn? conn)"));
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"atom","atom",-397043653).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.update,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.assoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key,callback], 0));

return key;
}));

(datascript.conn.listen_BANG_.cljs$lang$maxFixedArity = 3);

datascript.conn.unlisten_BANG_ = (function datascript$conn$unlisten_BANG_(conn,key){
if(datascript.conn.conn_QMARK_(conn)){
} else {
throw (new Error("Assert failed: (conn? conn)"));
}

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"atom","atom",-397043653).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.update,new cljs.core.Keyword(null,"listeners","listeners",394544445),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));
});

//# sourceMappingURL=datascript.conn.js.map
