package nats;

import io.nats.client.Connection;
import io.nats.client.Nats;
import io.nats.client.Options;

import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.DeliverPolicy;

// import io.nats.client.JetStreamApiException;
// import io.nats.client.KeyValue;
// import io.nats.client.KeyValueOptions;
// import io.nats.client.Message;
// import io.nats.client.api.*;
// import io.nats.client.support.Validator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ReadStream {
    public static void main(String[] args) throws Exception {
        String credentials = "-----BEGIN NATS USER JWT-----\neyJ0eXAiOiJKV1QiLCJhbGciOiJlZDI1NTE5LW5rZXkifQ.eyJqdGkiOiJTNFNYNDNWUk42M0JISEFIUFhKUEhLNENJU0FUVk9NN09HM1hGRlZWQ1lMQkM3WFZZSUFRIiwiaWF0IjoxNzE4Nzg2ODAzLCJpc3MiOiJBRDNZUUw0U1BCSTdYNkxNQUczTENIRDNNRzZaRUYzRFNHV1FHVk02VDNGQkRNVVhCVDJKWVNLSiIsIm5hbWUiOiJtMm4iLCJzdWIiOiJVQzZDSklZMk5EM1RQTDJYMjZETEY1RFNSV1ozNFVINUdKNDdBNEtNTERHNExET1FIWERLQjRLRSIsIm5hdHMiOnsicHViIjp7fSwic3ViIjp7fSwic3VicyI6LTEsImRhdGEiOi0xLCJwYXlsb2FkIjotMSwiaXNzdWVyX2FjY291bnQiOiJBRERKU1NURFQ0WFM1QTVTQ0pBN09DUlFLSjVUREZWVUhQWFVPQUxGN1hIVTY0VU82Q1hRWkhHNyIsInR5cGUiOiJ1c2VyIiwidmVyc2lvbiI6Mn19.6O9OvbUZp0pzBYH5F_6HLMwP6Uh3r_4ca40n7u4O8W0GBuWl79i8w1TT6QSrUvCqNscgi3BZwsWU6nCDUfgZDQ\n------END NATS USER JWT------\n\n************************* IMPORTANT *************************\nNKEY Seed printed below can be used to sign and prove identity.\nNKEYs are sensitive and should be treated as secrets.\n\n-----BEGIN USER NKEY SEED-----\nSUAEDIF2M57WNWCC522HL3A2JXIKLIGP2PMJKYUQ3H5FHFAPLQ4M55VLEQ\n------END USER NKEY SEED------\n\n*************************************************************";
        String serverUrl = "tls://connect.nats.mattilsynet.io:4222";
        String streamName = "marta-trafikk";

        Connection conn = Nats.connect(Options.builder()
                                       .server(serverUrl)
                                       .authHandler(Nats.staticCredentials(credentials.getBytes()))
                                       .build());

        // Create consumer

        ConsumerConfiguration.builder()
            .durable(false)
            .ackPolicy(AckPolicy/Explicit)
            .deliverPolicy(DeliverPolicy/All)
            .build()
            

        (consumer/create-consumer conn
         (cond-> {:nats.consumer/name consumer-name
                 :nats.consumer/stream-name stream-name
                 :nats.consumer/ack-policy :nats.ack-policy/explicit
                 :nats.consumer/deliver-policy :nats.deliver-policy/all
                 :nats.consumer/durable? true}
             filter-subjects (assoc :nats.consumer/filter-subjects filter-subjects)))

        conn.getStreamContext(streamName).getConsumerContext("");

        // Delete consumer

        conn.close();
    }
}
