/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Connection;
import io.nats.client.JetStreamApiException;
import io.nats.client.KeyValue;
import io.nats.client.KeyValueOptions;
import io.nats.client.Message;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.KeyValueEntry;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.PublishAck;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsKeyValue;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CljNatsKeyValue
extends NatsKeyValue
implements KeyValue {
    CljNatsKeyValue(NatsConnection natsConnection, String string, KeyValueOptions keyValueOptions) throws IOException {
        super(natsConnection, string, keyValueOptions);
    }

    public MessageInfo getMessage(String string) throws IOException, JetStreamApiException {
        return this._getLast(this.readSubject(Validator.validateNonWildcardKvKeyRequired((String)string)));
    }

    public MessageInfo getMessage(String string, long l) throws IOException, JetStreamApiException {
        return this._getMessage(Validator.validateNonWildcardKvKeyRequired((String)string), l);
    }

    MessageInfo _getMessage(String string, long l) throws IOException, JetStreamApiException {
        KeyValueEntry keyValueEntry;
        MessageInfo messageInfo = this._getBySeq(l);
        if (messageInfo != null && string.equals((keyValueEntry = new KeyValueEntry(messageInfo)).getKey())) {
            return messageInfo;
        }
        return null;
    }

    public long put(String string, byte[] byArray, Headers headers) throws IOException, JetStreamApiException {
        return this._write(string, byArray, headers).getSeqno();
    }

    private PublishAck _write(String string, byte[] byArray, Headers headers) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired((String)string);
        return this.js.publish((Message)NatsMessage.builder().subject(this.writeSubject(string)).data(byArray).headers(headers).build());
    }

    public List<Message> getHistory(String string) throws IOException, JetStreamApiException, InterruptedException {
        Validator.validateNonWildcardKvKeyRequired((String)string);
        ArrayList<Message> arrayList = new ArrayList<Message>();
        this.visitSubject(this.readSubject(string), DeliverPolicy.All, false, true, message -> arrayList.add(message));
        return arrayList;
    }

    public static CljNatsKeyValue create(Connection connection, String string, KeyValueOptions keyValueOptions) throws IOException {
        NatsConnection natsConnection = (NatsConnection)connection;
        Validator.validateBucketName((String)string, (boolean)true);
        if (natsConnection.isClosing() || natsConnection.isClosed()) {
            throw new IOException("A JetStream context can't be established during close.");
        }
        return new CljNatsKeyValue(natsConnection, string, keyValueOptions);
    }
}

