(ns nats.example
  (:import (io.nats.client Connection JetStreamOptions Nats)
           (io.nats.client.api RetentionPolicy StreamConfiguration)
           (java.time Duration))
  (:require [clojure.core.async :refer [sub]]))

(def conn (Nats/connect "nats://localhost:4222"))

(def jet-stream
  (let [options (-> (JetStreamOptions/builder)
                    (.requestTimeout (Duration/ofMillis 1000))
                    .build)]
    (.jetStreamManagement conn options)))

(let [options (-> (StreamConfiguration/builder)
                  (.name "chats")
                  (.description "Chat-meldinger")
                  (.subjects (into-array String ["chat.>"]))
                  (.retentionPolicy RetentionPolicy/Limits)
                  (.maxAge (Duration/ofDays 30))
                  .build)]
  (.addStream jet-stream options))

(defn create-stream [conn options]
  (let [js-opt (-> (JetStreamOptions/builder)
                  (.requestTimeout (Duration/ofMillis
                                    (or (:request-timeout options) 1000)))
                  .build)
        jet-stream (.jetStreamManagement conn js-opt)
        stream-opts (cond-> (StreamConfiguration/builder)
                      (:stream-name options)
                      (.name (:stream-name options))

                      (:description options)
                      (.description (:description options))

                      (:subjects options)
                      (.subjects (into-array String (:subjects options)))

                      (:retention-policy options)
                      (.retentionPolicy (:retention-policy options))

                      (:max-age options)
                      (.maxAge (Duration/ofDays (:max-age options)))
                      .build)]
    (stream-info->map (.addStream jet-stream stream-opts))))



(create-stream conn
 {:request-timeout 1000
  :stream-name "chats"
  :description "Chat-meldinger"
  :subjects ["chat.>"]
  :retention-policy RetentionPolicy/Limits
  :max-age })

#object[io.nats.client.api.StreamInfo 0xe86de3a "StreamInfo {\"did_create\":true,\"created\":\"2024-05-14T06:18:53.878301Z\",\"state\":{\"first_seq\":0,\"bytes\":0,\"first_ts\":\"0001-01-01T00:00:00Z\",\"messages\":0,\"last_ts\":\"0001-01-01T00:00:00Z\",\"consumer_count\":0,\"last_seq\":0},\"config\":{\"discard\":\"old\",\"duplicate_window\":120000000000,\"consumer_limits\":{},\"deny_delete\":false,\"sealed\":false,\"subjects\":[\"chat.>\"],\"max_msg_size\":-1,\"description\":\"Chat-meldinger\",\"allow_rollup_hdrs\":false,\"max_bytes\":-1,\"storage\":\"file\",\"allow_direct\":false,\"max_age\":2592000000000000,\"max_consumers\":-1,\"max_msgs_per_subject\":-1,\"num_replicas\":1,\"name\":\"chats\",\"deny_purge\":false,\"compression\":\"none\",\"max_msgs\":-1,\"retention\":\"limits\",\"mirror_direct\":false},\"ts\":\"2024-05-14T06:18:53.883619Z\"}"]


;; Koble til serveren
(def conn (Nats/connect "nats://localhost:4222"))
(def subject "chat.general")

;; Vent på en melding
(.start
 (Thread.
  (fn []
    (let [sub (.subscribe conn subject)
          msg (.nextMessage sub (Duration/ofSeconds 1))]
      (println
       (format "Fikk melding \"%s\" på emne \"%s\"\n"
               (String. (.getData msg) StandardCharsets/UTF_8)
               (.getSubject msg)))))))

;; Publiser en melding
(.publish conn subject (.getBytes "Hello world!" StandardCharsets/UTF_8))
