(require '[george.appengine.lein :as gal])
(gal/ammend-classpath)

(ns george.appengine.devserver
  (:require
    ;[clojure.string :as cs]
    [clojure.reflect :refer [reflect]]
    [clojure.pprint :refer [pprint]]
    [clojure.java.io :as cio]
    [cemerick.pomegranate :as pom]
    [ring.util.servlet :refer [servlet]]
    [george.appengine.lein :as gal])
  (:import [java.util.jar JarFile]

           ;[com.google.appengine.tools.development DevAppServerFactory]  ;; appengine-local-runtime.jar

           ;; http://grepcode.com/project/repo1.maven.org/maven2/org.mortbay.jetty/jetty/
           ;; appengine-local-runtime.jar
           [org.mortbay.jetty.servlet ServletHolder]

           [clojure.lang Reflector]
           [java.io File]
           [java.util Map HashMap]))







(defn add-classpaths
  "adds paths  to classpath"
  [seq-of-paths]
  (when (first seq-of-paths)
    (pom/add-classpath (first seq-of-paths))
    (recur (rest seq-of-paths))))



(defn list-jar-content [jar-file-or-path]
  (let [jar (JarFile. jar-file-or-path)]
    (println "listing content of jar:" jar-file-or-path)
    (doseq [entry (enumeration-seq (.entries jar))]
      ;(when (re-find #"com/google/appengine/tools" (str entry))
      (println "  " entry))))



;;;; "public" ;;;;


(defn load-class [^String class-name]
  (let [class-name class-name
        class-loader (.getContextClassLoader (Thread/currentThread))
        loaded-class (.loadClass class-loader class-name)]
    loaded-class))


(defn proxy-from-class [^Class cls proxy-init-map]
  (let [pc (get-proxy-class cls)
        p (construct-proxy pc)]
    (init-proxy p proxy-init-map)))


(defn proxy-from-jar [^String jar-path ^String canonical-class proxy-init-map]
  (pom/add-classpath jar-path)
  (let [cls (load-class canonical-class)]
    (proxy-from-class cls proxy-init-map)))


(defn classloader-for
  "returns the classloader for the given class og object"
  [cls-or-obj]
  (let [cls (if (class? cls-or-obj) cls-or-obj (class cls-or-obj))]
    (.getClassLoader cls)))


(defn arg-class
  "Returns the class of the arg, extracting the primitive of boxed args"
  [arg]
  (cond
    (instance? Byte arg) Byte/TYPE
    (instance? Character arg) Character/TYPE
    (instance? Short arg) Short/TYPE
    (instance? Integer arg) Integer/TYPE
    (instance? Long arg) Long/TYPE
    (instance? Float arg) Float/TYPE
    (instance? Double arg) Double/TYPE
    (instance? Boolean arg) Boolean/TYPE
    :default (class arg)))


(defn array-of-arg-types
  "Returns an array of classes for the types in the args-seq, including unboxing primitives.
  (Modeled on clojure.lang.Reflector/boxArg"
  [args-seq]
  (let [r (into-array Class (map arg-class args-seq))]
    (println (format "  ## array-of-arg-types \n      inn: %s \n     out: %s" args-seq (vec r)))
    r))


(defn construct [klass args-classes-seq args-seq]
  (let [constr (.getConstructor klass
                                ;(into-array Class (map type args)))
                                ;(array-of-arg-types args)
                                (into-array Class args-classes-seq))]
    (.setAccessible constr true)
    (.newInstance constr (object-array args-seq))))


(defn method
  "cass-or-str e.g. of form 'String ' or 'java.lang.String' or '\"java.lang.String\"'
obj-or-nil is instance of object if method, or nil if static method"
  [class-or-str method-name-str-or-kw args-classes obj-or-nil args-seq]
  (let [klass (if (class? class-or-str) class-or-str (load-class class-or-str))
        methd (.getDeclaredMethod klass (name method-name-str-or-kw) (into-array Class args-classes))]
    (.setAccessible methd true)
    (.invoke methd obj-or-nil (object-array args-seq))))


;(defn construct [klass & args]
;  (eval `(new ~klass ~@args)))



(defonce srv (atom nil))


;; To find/kill server process on port on Windows (in DOS Terminal):
;; 1.  `netstat -aon`
;; 2. locate PID for process on port
;; 3. `taskkill /F /PID <PID>


(def DEFAULT_SETTINGS {:address "localhost" :port 3000 :app-dir-path "target/war"})


(defn serve [& {:as args-map}]
  (when @srv
    (try (.shutdown @srv) (catch Exception _)))  ;; TODO: maybe needs to be better?

  (let [
        ;; We don't use KickStarter, as it is intended for starting a server as a seperate system process.
        ;;   https://code.google.com/p/googleappengine/source/browse/trunk/java/src/main/com/google/appengine/tools/KickStart.java

        ;; Also, we don't use DevAppServerMain, as it too starts a separate system process.
        ;; In stead we in replicate the minimum required based on the classes StartAction.apply()
        ;;   https://code.google.com/p/googleappengine/source/browse/trunk/java/src/main/com/google/appengine/tools/development/DevAppServerMain.java#224

        ;; We need a few jars in our path - from the GAE SDK.


;        sdk-dir (:sdk-dir (gal/read-appengine-sdk))

        ;; and lets get the settings from the lein-project and merge with default and passed-in
        project-settings (gal/read-appengine-settings)
        settings (conj DEFAULT_SETTINGS project-settings args-map)

        ;; for com.google.appengine.tools.info.AppengineSdk
;        appengine-tools-api-jar-path (.getAbsolutePath (cio/file sdk-dir  "lib" "appengine-tools-api.jar"))
;        _ (pom/add-classpath appengine-tools-api-jar-path)

        ;; don' need theses ... for now
        ;agent-jar-path (str (cio/file sdk-dir "lib" "agent" "appengine-agent.jar"))
        ;override-jar-path (str (cio/file sdk-dir "lib" "override" "appengine-dev-jdk-overrides.jar"))
        ;impl-appengine-api-jar-path (.getAbsolutePath (cio/file sdk-dir  "lib" "impl" "appengine-api.jar"))
        ;impl-appengine-api-labs-jar-path (.getAbsolutePath (cio/file sdk-dir  "lib" "impl" "appengine-api-labs.jar"))

        ;; for com.google.appengine.api.backends.dev.LocalServerController
;        impl-appengine-api-stubs-jar-path (.getAbsolutePath (cio/file sdk-dir  "lib" "impl" "appengine-api-stubs.jar"))
;        _ (pom/add-classpath impl-appengine-api-stubs-jar-path)
        ;_ (load-class "com.google.appengine.api.backends.dev.LocalServerController")
        ;; for com.google.appengine.tools.development.DevAppServerMainImpl
        ;;   https://code.google.com/p/googleappengine/source/browse/trunk/java/src/main/com/google/appengine/tools/development/DevAppServerImpl.java
        ;; and com.google.appengine.tools.development.DevAppServerFactory
        ;;   https://code.google.com/p/googleappengine/source/browse/trunk/java/src/main/com/google/appengine/tools/development/DevAppServerFactory.java?r=530
        ;; and for org.mortbay.jetty ...
        ;;     http://api.dpml.net/org/mortbay/jetty/6.1.0/index.html?org/mortbay/jetty/webapp/WebAppContext.html

;        impl-appengine-local-runtime-jar-path (.getAbsolutePath (cio/file sdk-dir  "lib" "impl" "appengine-local-runtime.jar"))
;        _ (pom/add-classpath impl-appengine-local-runtime-jar-path)

        ;_ (add-classpaths (sdk-jars-paths))

        ;; We use the DevAppServerFactory to create a DevAppServer instance.
        ;; We might as well proxy it, as we have a nice neat function for that.
        ;; (And we might want to extend something in future.)
        ;;   https://code.google.com/p/googleappengine/source/browse/trunk/java/src/main/com/google/appengine/tools/development/DevAppServerFactory.java?r=530
        ;cls (load-class "com.google.appengine.tools.development.DevAppServerFactory")
        ;factory (proxy-from-class cls {})
        factory (com.google.appengine.tools.development.DevAppServerFactory.)
        _ (println "  CL for factory:" (classloader-for factory))



        server (.createDevAppServer factory (cio/file (:app-dir-path settings))  nil (:address settings) (:port settings) true)
        ;; The above callloads all services correctly, but uses com.google.appengine.tools.development.DevAppServerClassLoader  :-(
        ;; So we want to bypass DevAppServerFactory, and in stead replicate its behavior using our standard (system) classloader.

        ;server (.createDevAppServer factory (cio/file (:app-dir-path settings))  nil nil nil (:address settings) (:port settings) true true (java.util.HashMap.) true)


        devappserver-cls (load-class "com.google.appengine.tools.development.DevAppServerImpl")
        SMI-cls (load-class "com.google.apphosting.utils.security.SecurityManagerInstaller")

        _ (pprint (reflect SMI-cls))

        privileged-jars (method (class factory) "getPrivilegedJars"  [Class] nil [devappserver-cls])

        _ (com.google.apphosting.utils.security.SecurityManagerInstaller/install false privileged-jars)

        server_
        (java.security.AccessController/doPrivileged
          (reify java.security.PrivilegedAction
            (run [this]
              (construct
                       devappserver-cls
                       [File File File File String Integer/TYPE Boolean/TYPE Map]
                       [(cio/file (:app-dir-path settings))  nil
                        nil nil
                        (:address settings) (int (:port settings))
                        true (HashMap.)]))))

        CSM-cls (load-class "com.google.appengine.tools.development.DevAppServerFactory$CustomSecurityManager")
        CSM-inst (construct CSM-cls [com.google.appengine.tools.development.DevAppServer] [server_])
        _ (System/setSecurityManager CSM-inst)


        ;server (construct
        ;         devappserver-cls
        ;         [File, File, File, File, String, Integer/TYPE, Boolean/TYPE, Boolean/TYPE, Map, Boolean/TYPE]
        ;         [(cio/file (:app-dir-path settings))  nil nil nil
        ;          (:address settings) (int (:port settings))
        ;          true true (HashMap.) true])


        _ (println "  CL for server:" (classloader-for server))
        ;; We also need to set a couple service properties minimum for it to work.
        ;; The args need to match between the factory and the services!
        string-properties {"address" (:address settings) "port" (str (:port settings))}]


    (.setServiceProperties server string-properties)

    (reset! srv server)))


(defn restart []
  (if @srv
    (.restart @srv)
    (println "Ops!  No server set up.  Call `(server & params)` first.")))


(defn stop []
  (if @srv
    (.shutdown @srv)
    (println "Ops!  No server to stop.  Call `(server & params)` first.")))






(defn tst [app-handler]
  (let [
        srvr (serve)
        _ (println "  ## srvr:" srvr)
        _ (.start srvr)


        _ (println "app-handler:" app-handler)
        app-servlet
        (servlet app-handler)
        _ (println "app-servlet:" app-servlet)
        ;_ (pprint (reflect app-servlet))

        app-context (.getAppContext srvr)
        _ (println "  ## app-context:" app-context)

        ;; http://api.dpml.net/org/mortbay/jetty/6.1.0/index.html?org/mortbay/jetty/webapp/WebAppContext.html
        container-context (.getContainerContext app-context)
        _ (println "  ## container-context:" container-context)
        ;_ (pprint (reflect container-context))

        _ (println "  ## getWar:" (.getWar container-context))
        servlet-handler (.getServletHandler container-context)
        _ (println "  ## servlet-handler:" servlet-handler)

        server-classloader (classloader-for srvr)
        ;server-classloader (.getClassLoader app-context)
        ;_ (doseq [url (.getURLs server-classloader)] (println " - url:" url))

        ;servletholder-cls (load-class "org.mortbay.jetty.servlet.ServletHolder")
        ;_ (println "  ## servletholder-cls:" servletholder-cls)
        ;servlet-holder (Reflector/invokeConstructor servletholder-cls (into-array Object [app-servlet]))
        ;servletholder (construct servletholder-cls app-servlet)
        ;servlet-holder (ServletHolder. app-servlet)
        _ (println "CL for servlet-handler:" (classloader-for servlet-handler))
        _ (println "CL for srvr:" server-classloader)
        ;_ (println "CL for servlet-holder:" (classloader-for servlet-holder))
        ;servletholder-cls (.loadClass server-classloader "org.mortbay.jetty.servlet ServletHolder" true)
        ;_ (println "server-classloader:" server-classloader)
        ;reflected (reflect server-classloader)
        ;_ (pprint (-> reflected :members))
        ;_ ("selected:")
        ;_ (pprint (filter #(= [java.lang.String boolean] (:parameter-types %)))(:members reflected))

        ;methods (Reflector/getMethods (class server-classloader) 2 "loadClass" false)
        ;methods (.getDeclaredMethods (class server-classloader))
        ;_ (doseq [m (seq methods)] (println " - m: " m (.getName m)))

        ;method (first (filter #(= (.getName %) "loadClass") (seq methods)))
        ;_ (println "  method!!: " method)
        ;_ (.setAccessible method true)
        ;servletholder-cls (.invoke method server-classloader (object-array ["org.mortbay.jetty.servlet.ServletHolder" true]))
        ;;servletholder-cls (.loadClass server-classloader "org.mortbay.jetty.servlet.ServletHolder" true)
        ;servletholder-cls (Reflector/invokeInstanceMethod server-classloader "loadClass" (to-array ["org.mortbay.jetty.servlet.ServletHolder" true]))
        ;servletholder-cls (Reflector/invokeMatchingMethod "loadClass" methods server-classloader  (into-array Object ["org.mortbay.jetty.servlet.ServletHolder" true]))

        ;_ (pprint (reflect servletholder-cls))
        ;servlet-holder (Reflector/invokeConstructor servletholder-cls (object-array [app-servlet]))

        _ (println "BEFORE")
        servlet-holders (.getServlets servlet-handler)
        _ (doseq [sh (seq servlet-holders)] (println " - sh: " sh  "  name:" (.getName sh)  "  classname:" (.getClassName sh)))
        _ (Thread/sleep 300)

        _ (.addServlet servlet-handler (ServletHolder. app-servlet))

        _ (println "AFTER")
        servlet-holders (.getServlets servlet-handler)
        _ (doseq [sh (seq servlet-holders)] (println " - sh: " sh  "  name:" (.getName sh)  "  classname:" (.getClassName sh)))
        _ (Thread/sleep 300)

        ;servlet-holder (.getServlet servlet-handler "triptrade.core/app servlet")
        ;_ (.setServlet servlet-holder app-servlet)


        _ (println "  ## container-context:" container-context)

        _ (println "getHandler:" (.getHandler container-context))]))
        ;_ (.setServletHandler container-context app-servlet)
        ;_ (.shutdown srvr)]))




(comment let [appDir (cio/file "target" "war")]
      appEngineWebXmlLocation nil
      webXmlLocation nil
      externalResourceDir nil
      release (.. com.google.appengine.tools.info.SdkInfo getLocalVersion getRelease)
      tempManager (method "com.google.appengine.tools.development.ApplicationConfigurationManager" "newWarConfigurationManager"
                          [File File File File String] nil [appDir appEngineWebXmlLocation webXmlLocation externalResourceDir release])
      applicationConfigurationManager tempManager
      _ (doseq [m (seq (.getModuleConfigurationHandles applicationConfigurationManager))] (println "- m:" m))
      serverInfo (com.google.appengine.tools.development.ContainerUtils/getServerInfo)
      _ (println "serverInfo:" serverInfo)
      _ (com.google.appengine.tools.development.StreamHandlerFactory/install)
      externalResourceDir nil
      address "localhost"
      modules (com.google.appengine.tools.development.Modules/createModules applicationConfigurationManager serverInfo externalResourceDir address @srv)
      backendContainer (com.google.appengine.tools.development.BackendServers/getInstance)
      containerConfigProperties {"com.google.appengine.tools.development.modules_filter_helper", (com.google.appengine.tools.development.DelegatingModulesFilterHelper. backendContainer, modules)}
      ;AbstractContainerService.PORT_MAPPING_PROVIDER_PROP, backendContainer}
      _ (.configure modules containerConfigProperties)

      factory (com.google.appengine.tools.development.ApiProxyLocalFactory.)
      apiProxyLocal (.create factory (.getLocalServerEnvironment modules))  ;; .getLocal... must not be null
      _ (com.google.apphosting.api.ApiProxy/setDelegate apiProxyLocal)
      localModulesService (.getService apiProxyLocal com.google.appengine.api.modules.dev.LocalModulesService/PACKAGE))
