/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

public class ZMQ {
    public static final int NOBLOCK = 1;
    public static final int SNDMORE = 2;
    public static final int PAIR = 0;
    public static final int PUB = 1;
    public static final int SUB = 2;
    public static final int REQ = 3;
    public static final int REP = 4;
    public static final int XREQ = 5;
    public static final int XREP = 6;
    public static final int PULL = 7;
    public static final int PUSH = 8;
    public static final int UPSTREAM = 7;
    public static final int DOWNSTREAM = 8;
    public static final int HWM = 1;
    public static final int SWAP = 3;
    public static final int AFFINITY = 4;
    public static final int IDENTITY = 5;
    public static final int SUBSCRIBE = 6;
    public static final int UNSUBSCRIBE = 7;
    public static final int RATE = 8;
    public static final int RECOVERY_IVL = 9;
    public static final int MCAST_LOOP = 10;
    public static final int SNDBUF = 11;
    public static final int RCVBUF = 12;
    public static final int RCVMORE = 13;
    public static final int POLLIN = 1;
    public static final int POLLOUT = 2;
    public static final int POLLERR = 4;

    public static Context context(int n) {
        return new Context(n);
    }

    static {
        System.loadLibrary("jzmq");
    }

    public static class Poller {
        private Context context = null;
        private long timeout = 0L;
        private int size = 0;
        private int next = 0;
        private Socket[] socket = null;
        private short[] event = null;
        private short[] revent = null;

        public int register(Socket socket) {
            return this.register(socket, 7);
        }

        public int register(Socket socket, int n) {
            if (this.next >= this.size) {
                return -1;
            }
            this.socket[this.next] = socket;
            this.event[this.next] = (short)n;
            return this.next++;
        }

        public Socket getSocket(int n) {
            if (n < 0 || n >= this.next) {
                return null;
            }
            return this.socket[n];
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long l) {
            this.timeout = l;
        }

        public int getSize() {
            return this.size;
        }

        public int getNext() {
            return this.next;
        }

        public long poll() {
            if (this.size <= 0 || this.next <= 0) {
                return 0L;
            }
            for (int i = 0; i < this.next; ++i) {
                this.revent[i] = 0;
            }
            return this.run_poll(this.next, this.socket, this.event, this.revent, this.timeout);
        }

        public boolean pollin(int n) {
            return this.poll_mask(n, 1);
        }

        public boolean pollout(int n) {
            return this.poll_mask(n, 2);
        }

        public boolean pollerr(int n) {
            return this.poll_mask(n, 4);
        }

        protected Poller(Context context, int n) {
            this.context = context;
            this.size = n;
            this.next = 0;
            this.socket = new Socket[n];
            this.event = new short[n];
            this.revent = new short[n];
        }

        private native long run_poll(int var1, Socket[] var2, short[] var3, short[] var4, long var5);

        private boolean poll_mask(int n, int n2) {
            if (n2 <= 0 || n < 0 || n >= this.next) {
                return false;
            }
            return (this.revent[n] & n2) > 0;
        }
    }

    public static class Socket {
        private long socketHandle;
        private Context context = null;

        public void close() {
            this.finalize();
        }

        public long getHWM() {
            return this.getLongSockopt(1);
        }

        public long getSwap() {
            return this.getLongSockopt(3);
        }

        public long getAffinity() {
            return this.getLongSockopt(4);
        }

        public byte[] getIdentity() {
            return this.getBytesSockopt(5);
        }

        public long getRate() {
            return this.getLongSockopt(8);
        }

        public long getRecoveryInterval() {
            return this.getLongSockopt(9);
        }

        public boolean hasMulticastLoop() {
            return this.getLongSockopt(10) != 0L;
        }

        public long getSendBufferSize() {
            return this.getLongSockopt(11);
        }

        public long getReceiveBufferSize() {
            return this.getLongSockopt(12);
        }

        public boolean hasReceiveMore() {
            return this.getLongSockopt(13) != 0L;
        }

        public void setHWM(long l) {
            this.setLongSockopt(1, l);
        }

        public void setSwap(long l) {
            this.setLongSockopt(3, l);
        }

        public void setAffinity(long l) {
            this.setLongSockopt(4, l);
        }

        public void setIdentity(byte[] byArray) {
            this.setBytesSockopt(5, byArray);
        }

        public void subscribe(byte[] byArray) {
            this.setBytesSockopt(6, byArray);
        }

        public void unsubscribe(byte[] byArray) {
            this.setBytesSockopt(7, byArray);
        }

        public void setRate(long l) {
            this.setLongSockopt(8, l);
        }

        public void setRecoveryInterval(long l) {
            this.setLongSockopt(9, l);
        }

        public void setMulticastLoop(boolean bl) {
            this.setLongSockopt(10, bl ? 1L : 0L);
        }

        public void setSendBufferSize(long l) {
            this.setLongSockopt(11, l);
        }

        public void setReceiveBufferSize(long l) {
            this.setLongSockopt(12, l);
        }

        public native void bind(String var1);

        public native void connect(String var1);

        public native boolean send(byte[] var1, long var2);

        public native byte[] recv(long var1);

        protected Socket(Context context, int n) {
            this.context = context;
            this.construct(context, n);
        }

        protected native void construct(Context var1, int var2);

        protected native void finalize();

        protected native long getLongSockopt(int var1);

        protected native byte[] getBytesSockopt(int var1);

        protected native void setLongSockopt(int var1, long var2);

        protected native void setBytesSockopt(int var1, byte[] var2);

        private long getSocketHandle() {
            return this.socketHandle;
        }
    }

    public static class Context {
        private long contextHandle;

        public void term() {
            this.finalize();
        }

        public Socket socket(int n) {
            return new Socket(this, n);
        }

        public Poller poller(int n) {
            return new Poller(this, n);
        }

        protected Context(int n) {
            this.construct(n);
        }

        protected native void construct(int var1);

        protected native void finalize();

        private long getContextHandle() {
            return this.contextHandle;
        }
    }
}

