/*
 * Decompiled with CFR 0.152.
 */
package com.kikini.logging.simpledb;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

class GranularDelay
implements Delayed {
    Clock clock;
    long expire;

    private void initialize(Clock clock, long granularityMillis) {
        if (granularityMillis < 1L) {
            throw new IllegalArgumentException("granularity must be greater than 0");
        }
        this.clock = clock;
        this.expire = clock.getCurrentTimeMillis() / granularityMillis;
        this.expire = (this.expire + 1L) * granularityMillis;
    }

    GranularDelay(Clock c, long granularityMillis) {
        this.initialize(c, granularityMillis);
    }

    public GranularDelay(long granularityMillis) {
        this.initialize(new Clock(), granularityMillis);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long remaining = this.expire - this.clock.getCurrentTimeMillis();
        return unit.convert(remaining, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        long diff = this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS);
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    class Clock {
        Clock() {
        }

        long getCurrentTimeMillis() {
            return System.currentTimeMillis();
        }
    }
}

