/*
 * Decompiled with CFR 0.152.
 */
package com.kikini.logging.simpledb;

import java.util.List;

class ListBatcher<E> {
    private final int batchSize;
    private final List<E> list;
    private int idx = 0;

    ListBatcher(List<E> list, int batchSize) {
        if (batchSize < 1) {
            throw new IllegalArgumentException("Must choose a batch size greater than 0");
        }
        this.list = list;
        this.batchSize = batchSize;
    }

    public List<E> nextBatch() {
        if (this.idx >= this.list.size()) {
            return null;
        }
        int nextIdx = this.idx + this.batchSize < this.list.size() ? this.idx + this.batchSize : this.list.size();
        List<E> subList = this.list.subList(this.idx, nextIdx);
        this.idx = nextIdx;
        return subList;
    }
}

