(defproject nl.jomco/select-tree "0.1.0"
  :description "Library to recursively select subtrees of collections"
  :url "https://git.sr.ht/~jomco/select-tree"
  :license {:name         "MIT"
            :url          "https://opensource.org/licenses/MIT"
            :distribution :repo}
  :profiles {:provided {:dependencies [[org.clojure/clojure "1.11.1"]]}
             :dev {:dependencies [[clj-kondo "2022.05.31"]]}}
  :repl-options {:init-ns nl.jomco.select-tree}
  :release-tasks [["test-full"]
                  ["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]
                  ["vcs" "push"]]
  ;; link to git repo, also ensures that cljdoc.org finds additional markdown files
  :scm {:name "git"
        :url  "https://git.sr.ht/~jomco/select-tree"}
  :aliases {"lint"        ["run" "-m" "clj-kondo.main" "--lint" "src"]
            "test-full"   ["do" "lint," "test"]})
