# Select Tree

Select subtrees of collections.

## Dependency coordinates

[![Clojars Project](https://img.shields.io/clojars/v/nl.jomco/select-tree.svg)](https://clojars.org/nl.jomco/select-tree)

## Documentation

API documentation is available inline and at [cljdoc](https://cljdoc.org/d/nl.jomco/select-tree/CURRENT). [![](https://cljdoc.org/badge/nl.jomco/select-tree)](https://cljdoc.org/jump/release/nl.jomco/select-tree)

# USAGE

```clojure
(require '[nl.jomco.select-tree :refer [select-tree]])

(def ring-request
  {:request-method :post
   :uri            "/foo"
   :headers        {"content-type"  "text/html; charset=utf8"
                    "authorisation" "Bearer SOMECREDENTIALS"}
   :body           "<html><body>Hello, World</body></html>"
   :params         {:pageNumber 1
                    :pageSize   10
                    :other      "thing"}})

(select-tree ring-request
            {:request-method nil
             :uri            nil
             :headers        #{"content-type"}
             :params         #{:pageNumber
                               :pageSize}})
=> {:request-method :post
    :uri            "/foo"
    :headers        {"content-type" "text/html; charset=utf8"}
    :params         {:pageNumber 1
                     :pageSize   10}}
```

# Selectors specification

`nil` means select whole tree

A map selector recursively selects items in a map, with selectors as
values.

A set selector works as a map selector with `nil` values (select whole
value for each key). Set selectors also work on sets.

A sequential selector of size N recursively selects the first N, or
less if the collection is smaller, items in the sequential collection,
with selectors as values.

An integer selector N selects the first N items in a sequential
collection (like a sequential selector with N `nil` entries).
