# Ring middleware implementing the W3C Trace Context Standard

# Ring Middleware

This package defines the
`nl.jomco.ring-trace-context/wrap-trace-context` middleware function.

This parses the `traceparent` header if present or generates new
`traceparent` data and sets it on the request for, and the response of
the wrapped handler under the `:trace-context` key.

```
request =>
{:request-method :get
 # ...
 :trace-context {:version "00",
                 :trace-id "74e744b8a6cb016a0ebf84d7d7932512",
                 :parent-id "23fc93418d1e37bd",
                 :trace-flags "00"}}
```

# Dynamic var

`nl.jomco.ring-trace-context/*trace-context*` holds the current
trace context while the wrapped handler is called. You can also use
`(with-context (new-context) ...)` to create new (sub) contexts.

# HTTP Client Middleware

If you want to pass trace context along to other services you can use
`wrap-new-trace-context` to wrap around your HTTP client function.

something like

```
(def http-client
	(-> clj-http.client/request
		(wrap-new-trace-context)))

;; automatically spawns a new trace context based on
;; the current context on every request
(http-client {:method :get
              :url    "http://example.com"})
```

With `clj-http` you can also use its `with-additional-middleware`
macro and related functionality.

# Headers

The standard defines two headers; `traceparent` and
`tracestate`.

## `traceparent`

The `traceparent` header contains 4 fields, `version`, `trace-id`,
`parent-id` and `flags`. The only currenly defined versions are "00"
(hexadecimal), and the "invalid version" "ff".

## `tracestate`

TODO: document further

# References

https://newrelic.com/blog/nerdlog/w3c-trace-context-distributed-tracing-standard

https://www.w3.org/TR/trace-context/

# Changes

## 0.0.8
- Fixes backwards compatibility with version 0.0.2

## 0.0.7
- Bugfix release

## 0.0.6
- Documentation improvements
- HTTP Client middleware added

## 0.0.5
- Add `new-context` alias for `new-span` and fix implementation when
  `nil` is passed.

## 0.0.4
- Add `*trace-context*` dynamic var and related functions.

## 0.0.3

- Set `traceparent` header also on response in middleware
- Set `trace-context` on request and response map
- Add `new-span`
- Renaming for clarity: use `trace-context` for parsed objects and
  `traceparent` for raw string.

