(ns nl.jomco.openapi.v3.example
  "Generate example documents from a JSON Schema."
  (:require
   [nl.jomco.openapi.v3.json-pointer :as pointer]))

(defn example
  [specification schema-path]
  (let [{:strs       [oneOf anyOf allOf enum type format properties required $ref]
         example-val "example"
         :as         schema}
        (pointer/get specification schema-path true)]
    ;; if we have a literal :example, just return that.
    (if (and (map? schema)
             (contains? schema "example"))
      example-val
      ;; else attempt to find or generate based on the schema
      (let [part (cond
                   (seq oneOf)
                   (example specification (into schema-path ["oneOf" 0]))

                   (seq anyOf)
                   (example specification (into schema-path ["anyOf" 0]))

                   (seq allOf)
                   ;; FIXME -- merge won't work for non-object schemas
                   (apply merge (map #(example
                                       specification
                                       (into schema-path ["allOf" %]))
                                     (range 0 (count allOf))))

                   $ref
                   (example specification (pointer/pointer-path $ref))

                   enum
                   (first enum)

                   (= "object" type)
                   {}

                   (= "array" type)
                   [(example specification (conj schema-path "items"))]

                   (= "string" type)
                   (if (= "uuid" format)
                     "c72f9426-7138-4b5a-bc3d-09c8228ee18c"
                     "example string"))]

        ;; it's possible to have additional properties defined on a
        ;; schema, for instance {:allOf [...] :properties [...] }
        (if (and (seq properties)
                 (or (nil? part) (map? part)))
          (reduce-kv
           (fn [e k _]
             (assoc e k (example specification (into schema-path ["properties" k]))))
           (or part {})
           (if required
             (select-keys properties required)
             properties))
          part)))))
