# OpenAPI V3 Validator

A pure-clojure library for validating ring requests & responses
against OpenAPI v3 specifications.

**This is a work in progress. There will be breaking changes as we
work.**

## Build status

[![builds.sr.ht status](https://builds.sr.ht/~jomco/openapi-v3-validator/commits/master.svg)](https://builds.sr.ht/~jomco/openapi-v3-validator/commits/master?)

## Deps

[![Clojars Project](https://img.shields.io/clojars/v/nl.jomco/openapi-v3-validator.svg?include_prereleases)](https://clojars.org/nl.jomco/openapi-v3-validator)

## Goals

### Portable clojure

Long term goal: Should work on any Clojure implementation.

Immediate goal: works on Clojure JVM and Babashka

Status: the core validator code has no dependencies and should work
with minimal changes on any Clojure implementation. Clojure JVM and
Babashka are tested as part of development.

### Schema validation

Complete implementation of Schema validator compatible with OpenAPI
v3.1.0 (the current version of the OpenAPI specification).

Status: mostly complete, but there's no comprehensive documentation on
what is and isn't implemented. Notably we're currently missing an
implementation of the OpenAPI "discriminator" keyword.

### Request validation

Immediate goal: validate `ring` request maps against OpenAPI specs,
including parameters, headers and request body (JSON).

Mostly done, but request params coercion to Objects is incomplete.

### Response validation

Immediate goal: validate `ring` response maps against OpenAPI specs,
including parameters, headers and request body (JSON).

Status: mostly complete. Response object links not implemented.

## Usage

Validating OpenAPI requests/responses:

```clojure
(require '[nl.jomco.openapi.v3.validator :as validator])

(def validate
  (-> ooapi-spec
      (validator/validator-context nil)
      validator/interaction-validator))

(validate 
   {:request  {:method       :get
               :uri          "/courses"
               :query-params {"pageNumber" "foo"
                              "sort"       "something,-name"}}
               :response {:status  200
                          :headers {"content-type" "application/json; charset=utf8"}
                          :body    {:pageSize        0
                                    :pageNumber      1
                                    :hasPreviousPage false
                                    :hasNextPage     "true"
                                    :items           []}}}
   [])
=> [{:issue       :coercion-error,
     :type        "integer",
     :instance    "foo",
     :in          [:request :query-params "pageNumber"],
     :schema-path [:components :parameters :pageNumber]}
     {:issue    :enum-error,
      :instance "something",
      :in       [:request :query-params "sort" 0],
      :schema-path [:paths :/courses :get
                    :parameters 8 :schema :items :enum],
      :enum     ["courseId" "name" "-courseId" "-name"]}
     {:issue    :type-error,
      :instance "true",
      :schema-path [:components :schemas :Pagination
                    :properties :hasNextPage :type],
      :type     "boolean",
      :in       [:response :body :hasNextPage]}]
```

Validating JSON Schemas:

```clojure
(require '[nl.jomco.openapi.v3.schema-validator :as validator])

(def validate
   (validator/schema-validator
      (validator/validator-context specification)
      [:path :to :schema :in :spec]))

(def issues
  (validate instance [:path :of :instance]))
```

## License

Copyright © 2022-2023 Joost Diepenmaat, Jomco BV

This program and the accompanying materials are made available under the
terms of the Eclipse Public License 2.0 which is available at
http://www.eclipse.org/legal/epl-2.0.

This Source Code may also be made available under the following Secondary
Licenses when the conditions for such availability set forth in the Eclipse
Public License, v. 2.0 are satisfied: GNU General Public License as published by
the Free Software Foundation, either version 2 of the License, or (at your
option) any later version, with the GNU Classpath Exception which is available
at https://www.gnu.org/software/classpath/license.html.
