(ns nl.jomco.openapi.v3.example
  "Generate example documents from a JSON Schema."
  (:require
   [nl.jomco.json-pointer :as pointer]))

(defn example
  [specification schema-path]
  (let [schema (pointer/get specification schema-path true)]
    ;; if we have a literal :example, just return that.
    (if (contains? schema :example)
      (:example schema)
      ;; else attempt to find or generate based on the schema
      (let [part (cond
                   (seq (:oneOf schema))
                   (example specification (into schema-path [:oneOf 0]))

                   (seq (:anyOf schema))
                   (example specification (into schema-path [:anyOf 0]))

                   (seq (:allOf schema))
                   ;; FIXME -- merge won't work for non-object schemas
                   (apply merge (map #(example
                                       specification
                                       (into schema-path [:allOf %]))
                                     (range 0 (count (:allOf schema)))))

                   (:enum schema)
                   (first (:enum schema))

                   (= "object" (:type schema))
                   {}

                   (= "array" (:type schema))
                   [(example specification (conj schema-path :items))]

                   (= "string" (:type schema))
                   (if (= "uuid" (:format schema))
                     "c72f9426-7138-4b5a-bc3d-09c8228ee18c"
                     "example string"))]

        ;; it's possible to have additional properties defined on a
        ;; schema, for instance {:allOf [...] :properties [...] }
        (if (and (seq (:properties schema))
                 (or (nil? part) (map? part)))
          (reduce-kv
           (fn [e k _]
             (assoc e k (example specification (into schema-path [:properties k]))))
           (or part {})
           (if (:required schema)
             (select-keys (:properties schema) (map pointer/as-key (:required schema)))
             (:properties schema)))
          part)))))
