(ns nl.jomco.openapi.main
  (:require
   [clojure.data.json :as json]
   [clojure.java.io :as io]
   [nl.jomco.json-pointer :as pointer]
   [nl.jomco.openapi.v3.validator.json-schema-validator :as validator]))

(defn -main
  [cmd specification pointer]
  (when-not (= cmd "validate")
    (throw (ex-info (str "Unkown command " cmd)
                    {:cmd cmd})))

  (let [v (time (validator/schema-validator (validator/validator-context
                                           (json/read (io/reader (io/file specification))
                                                      :key-fn keyword))
                                               (pointer/pointer-path (str "#" pointer))))]
    (time (prn (v (json/read *in* :key-fn keyword) [])))))
