(defproject nl.jomco/envopts "0.0.4"
  :description "create configuration data from environment variables"
  :url "https://git.sr.ht/~jomco/clj-envopts"
  :dependencies [[environ "1.2.0"]]
  :license {:name         "MIT"
            :url          "https://opensource.org/licenses/MIT"
            :distribution :repo}
  :profiles {:provided {:dependencies [[org.clojure/clojure "1.10.3"]]}
             :dev      {:dependencies [[clj-kondo "2021.04.23"]]
                        :plugins      [[lein-kibit "0.1.8"]]
                        :aliases      {"lint" ["do"
                                               ["run" "-m" "clj-kondo.main" "--lint" "src"]
                                               "kibit"]}}}

  ;; setup `vX.Y.Z` tags, deploy to clojars, don't push
  :release-tasks [["vcs" "assert-committed"]
                  ["change" "version" "leiningen.release/bump-version" "release"]
                  ["vcs" "commit"]
                  ["vcs" "tag" "v"]
                  ["deploy" "clojars"]
                  ["change" "version" "leiningen.release/bump-version"]
                  ["vcs" "commit"]]
  ;; link to git repo, also ensures that cljdoc.org finds additional markdown files
  :scm {:name "git"
        :url  "https://git.sr.ht/~jomco/clj-envopts"})
