# NAME

envopts - Clojure library for parsing configuration from environment

# SYNOPSIS

    (ns your-ns.main
      (:require [nl.jomco.envopts :as envopts]))
    
    (defn -main [& args]
      (let [[opts errs] (envopts/opts env SPEC)]
        (when errs
          (println (envopts/errs-description errs))
          (System/exit 1))
        ... do something with opts))

# DESCRIPTION

See the [documentation on
cljdoc.org](https://cljdoc.org/d/nl.jomco/envopts/CURRENT) and the
inline docs.

# ALPHA RELEASE

[![](https://cljdoc.org/badge/nl.jomco/envopts)](https://cljdoc.org/jump/release/nl.jomco/envopts)

This library is in alpha; it works for us but we're still tweaking the
interface.

# RATIONALE

When running applications as services, it's useful to set
configuration options using environment variables. The [Twelve-Factor
App section on configuration](https://12factor.net/config) goes into
more detail why.

Our preferred tool for reading the environment is
[Environ](https://github.com/weavejester/environ), which works well.
When using Environ in production settings, we found some additional
things missing; Types, Defaults and Reporting.

Types: In the environment, everything is a string, but the application
configuration may need numbers, urls, uuids etc. `envopts` will parse
the environment strings as the expected type - or fail with an error
report.

Defaults: dealing with defaults can be a hassle - it's really easy to
end up with settings defined everywhere.

Error reporting: when deploying an application, it's extremely useful to
have _clear and complete_ error feedback when the application is
misconfigured.

# OPTIONS SPEC

TODO

# AUTHOR

Joost Diepenmaat <joost@jomco.nl>

# SEE ALSO

<https://12factor.net/> - The 12 Factor App manifesto

<https://github.com/weavejester/environ> - Environ

